/** LongPlayer - cross-platform multimedia queuer
 *  Copyright (C) 2001-2004 Andrew Wils
 *
 *  This program is free software; See the
 *  GNU General Public License for more details.
 */
#ifndef LPGUIHANDLER_H
#define LPGUIHANDLER_H

#include <qevent.h>
#include <string>

using namespace std;

/** LPGUIEvent is used to communicate debugging and other information between threads (especially the GUI) */
class LPGUIEvent: public QEvent
{
public: 
	enum axes {
			LPDEBUG = 1,
			LPINFO = 2,
			LPWARNING = 3,
			LPERROR = 4,
			LPNOTIFY = 5,
			LPMESSAGE = 6,
			BUSY = 7,
			READY = 8,
			LPBEGINPROGRESS = 10,
			LPSETPROGRESS = 11,
			LPENDPROGRESS = 12,
			LPQUIT = 50
	};

	LPGUIEvent(int type,string message,int arg=0);
	int getType();
	int getValue();
	string getMessage();
private:
	int _type;
	int _integer;
	string _message;
};

#endif
