/** LongPlayer - cross-platform multimedia queuer
 *  Copyright (C) 2001-2004 Andrew Wils
 *
 *  This program is free software; See the
 *  GNU General Public License for more details.
 */
#ifndef LPITER_H
#define LPITER_H

#include "lpsong.h"
#include <qmap.h>

class LPSongFilter;
class Playlist;
class LPDatabase;
class LPSettings;

class LPPlaylistIterator
{
	public:
		LPPlaylistIterator(Playlist* playlist, LPSongFilter* filter, LPDatabase* database, bool random, bool adapt);
		//tries to find next song (if returns empty song, try again)
		Song next();
		bool hasNext();
		uint getSize();
		uint getPosition();
		static bool isPlaylist(string filename);
	private:
    	//analyses the song and returns value greater than 0 if not suitable to play
		float songGoodahness(Song song) ;
		//analyses the given M3U playlist file and returns true if not suitable to play
		float m3uGoodahness(string filename);	
		
		LPSongFilter* _filter;
		Playlist* _playlist;
		LPDatabase* _database;
		LPSettings* _settings;
		bool _random;
		bool _adapt;
		unsigned int _currpos;
};

#endif
