#include "lpremotegeneric.h"

#include <qfile.h>
#include <qdir.h>
#include <qfileinfo.h>
#include <qtextstream.h>

#include "absplayer.h"
#include "lpfactory.h"
#include "lpapp.h"

LPRemoteGeneric::LPRemoteGeneric(LPApp* app) 
	: brunning(false), flagQuit(false) , flagStopLP(false), _app(app)
{
	start();
}

LPApp* LPRemoteGeneric::getApp() {
	return _app;
}

void LPRemoteGeneric::run() {
	brunning = true;
	string command = "";
	string arg1 = ""; string arg2 = "";
	int consumedcommands;//read new
	while (!flagQuit)
	{
		consumedcommands = 3;
		QString filename = QString::fromLocal8Bit(_app->getSettings()->getSetting("remote","location").c_str());
		QFile f(filename);
	    if (!f.open(IO_ReadOnly))
    	{
    	}
		else
		{
	        logInfo(string("Remote input."));
	        logDebug(string("LPRemote::input command(s) found. "));
		    QTextStream t( &f );
		    string st;
	    	while (!t.atEnd())
		    {
						if (consumedcommands == 3)
						{
							if (t.atEnd())
								command = "";
							else
								command = t.readLine().latin1();
							if (t.atEnd())
								arg1 = "";
							else
								arg1 = t.readLine().latin1();
							if (t.atEnd())
								arg2 = "";
							else
								arg2 = t.readLine().latin1();
						}
						if (consumedcommands == 2)
						{
							command = arg2;
							if (t.atEnd())
								arg1 = "";
							else
								arg1 = t.readLine().latin1();
							if (t.atEnd())
								arg2 = "";
							else
								arg2 = t.readLine().latin1();
						}
						if (consumedcommands == 1)
						{
							command = arg1;
							arg1 = arg2;
							if (t.atEnd())
								arg2 = "";
							else
								arg2 = t.readLine().latin1();
						}
				consumedcommands = handleCommand(command,arg1,arg2);
    		}
		    f.close();
			QFile::remove(filename);
		}
        this->usleep(100000);
    }
	brunning = false;
	//todo: this thread gets destroyed while running
	if (flagStopLP) LPFactory::getFactory()->destroyLPlayer();
}

int LPRemoteGeneric::handleCommand(string command, string arg,string arg2)
{
		logDebug("LPRemote::trying " + command + " " + arg + " " + arg2);
		if (command == "ratesong")
		{
				Song s = _app->SongRetrieveFromFilename(arg);
					s.setLike(atoi(arg2.c_str()));
				_app->SongStore(s);
				return 3;
		}
		if (command == "playdir")
		{
				Song s = _app->SongCurrent();
				vector<string> files; files.push_back(string(QFileInfo(QString::fromLocal8Bit(s.getFilename().c_str())).dirPath().local8Bit()));
				_app->play(files, true);
				return 1;
		}
		if (command == "ratedown")
		{
				Song s = getApp()->SongCurrent();
				s.setLike(s.getLike()-1);
				getApp()->SongStore(s);
				return 1;
		}
		if (command == "rateup")
		{
				Song s = getApp()->SongCurrent();
				s.setLike(s.getLike()+1);
				getApp()->SongStore(s);
				return 1;
		}
		if (command == "rate")
		{
				Song s = getApp()->SongCurrent();
				s.setLike(atoi(arg.c_str()));
				getApp()->SongStore(s);
				return 2;
		}
		if (command == "search")
		{
				getApp()->search(arg,false);
				return 2;
		}
		if (command == "playlist")
		{
				getApp()->changePlaylist(arg);
				return 2;
		}
		if (command == "queue")
		{
				getApp()->queue((arg == "force"));				
				return 2;
		}
		if (command == "play")
		{
            getApp()->getMPlayer()->play();
			return 1;
		}
		if (command == "stop")
		{
				getApp()->getMPlayer()->stop();
				return 1;
		}
		if (command == "previous")
		{
				getApp()->getMPlayer()->previous();
				return 1;
		}
		if (command == "quit")
		{
				logDebug("remote-quitting");
				flagStopLP = true;
				flagQuit = true;
				return 1;
		}
		if (command == "next")
		{
				getApp()->getMPlayer()->next();
				return 1;
		}
		if (command == "volume")
		{
			getApp()->getMPlayer()->setVolume(atoi(arg.c_str()));
			return 2;
		}
		if (command == "exportXML")
		{
			getApp()->DatabaseExportXML(arg);
			return 2;
		}
	//default: dismiss command
	return 1;
}
