/** LongPlayer - cross-platform multimedia queuer
 *  Copyright (C) 2001-2002 Andrew Wils
 *
 *  This program is free software; See the
 *  GNU General Public License for more details.
 */
#ifndef H_LPSONG
#define H_LPSONG

#include <qstring.h>
#include "absutil.h"
using namespace std;

class Song
{
public:
	/** returns a hashing key for the filename
	 */
	static string getKey(string filename);

	/** constructs a new Song based on the given songname and filename
	 */
	Song(string name,string filename);

	/** constructs a new Song based on the given key */
	Song (string key);
	
	/** constructs a new Song with default values
	 */
	Song();

	/** adds 1 to the number of times a song has been listened to
	 * also, changes the date the song has last been listened to
	 * (more spec needed)
	 */
	void listen();
	/** reverts date to olddate */
	void resetListen();
	bool heard() const;
	bool hearing() const;
	bool firstTime() const;

	/** the length (in seconds) of the song */
	int length() const;
	void setLength(int length);

	/** the size (in bytes) of the song */
	int size() const;
	void setSize(int size);
	
	//TODOrelative path to musicdir too??
	
	/** times the song has been listened to */
	int getTimes() const;
	void setTimes(int);

	/** a hashing key for the song */
	string getKey() const;
	void setKey(string);
			
	/** the title and artist of the song */
	string getName() const;
	void setName(string name);

	/** the filename of the song */
	string getFilename() const;
	/** no keygeneration */
	void setFilename(string filename);
	/** with keygeneration */
	void setSong(string filename);
	/** the rating of the song, a value between -5 and +5 */
	int getLike() const;
	void setLike(int newlike);

	/** the date the song has been listened to for the last time 
	 *  expressed in number of seconds elapsed since 1/1/1970 midnight
	 */ 
	int getDate() const;
	int getOldDate() const; //only for statistical use
	void setDate(int);
	void setOldDate(int);

	// hue: 0..255, sat: 0..255, val: 0..255 
	void getColor(int* h, int* s, int* v) const;
	void setColor(int h, int s, int v);
			
	bool empty() const; //empty song
	bool valid() const; //empty or non existing song
	/** tries to detect inconsistensies (date vs olddate) */
	void repair();

	/** certain that those songs are the same */
	bool equal(Song song) const;
	/** fairly certain */
	bool equivalent(Song song) const;
	
	/** updates song stats if equivalent and argument is NEWER */
	void softmerge(Song song);

	string toString() const;
	
private:
	bool equivalentFilename(string filename) const;
	int _times;
    int _date;
	int _olddate;
	string _filename;
	string _name;
	string _key;
	int _like;
	int _colorh, _colors, _colorv;
	int _size;
	int _length;
};
#endif

