/** LongPlayer - cross-platform multimedia queuer
 *  Copyright (C) 2001-2004 Andrew Wils
 *
 *  This program is free software; See the
 *  GNU General Public License for more details.
 */
#ifndef LPMWIN_H
#define LPMWIN_H

#include "lpglobal.h"
#include "lpwindowmainbase.h"
#include "lpfactory.h"
#include "lpsong.h"
#include "lpapp.h"
#include "lpsettings.h"

#ifdef _WS_WIN_
#include "trayicon.h"
#endif

#include <qlistview.h>
#include <qtooltip.h>
#include <qtoolbar.h>

class LPApp; class LPFormStartup; class PlayedSongTip; class PlayedSongHandler; class LPSettings; class QStatusBar; class QToolButton; 

class LPWindowMain : public LPWindowMainBase, public LPGUI
{
	Q_OBJECT
public:
	static IntSetting SettingSplash;
	static IntSetting SettingTrim;
	static IntSetting SettingTrimVal;
	static IntSetting SettingTray;
	static IntSetting SettingAutoTitleWidth;
	static IntSetting SettingTitleWidth;
	static IntSetting SettingMinimal;
	static IntSetting SettingX;
	static IntSetting SettingY;
	static IntSetting SettingHideOnMinimize;
	static IntSetting SettingHideOnClose;
	static IntSetting SettingStartInTray;
	static IntSetting SettingShowMain;
	static IntSetting SettingShowCurrent;
	static IntSetting SettingShowPlayed;
	static IntSetting SettingWidth;
	static IntSetting SettingHeight;
	static IntSetting SettingMediabar;
	static IntSetting SettingMainbar;

	/* constructs a new gui and LPApplication. */
	LPWindowMain(LPSettings* settings, QWidget* parent = 0, const char* name = 0, WFlags f = 0 );
	~LPWindowMain();
	void notify(int i=0);
	void show();

	void updateWidgets();
	void updateTrayIcon();
	
	//reimplemented slots
	void queue();
	void search();
	void prefs();
	void prefchange();
    void changeRating(int);
    void changeQRating(int);
    void playNow(QListViewItem*);

    void selectSong(QListViewItem*);

    void setSelectedSong(Song);
    Song getSelectedSong();

    void toggleQueue();
    void toggleAnalyze();
    void toggleShowCurrent();
    void toggleShowQueue();
	void toggleAlwaysOnTop();

	void pplay();
	void pstop();
	void pnext();
	void pprevious();

	bool quitting();

public slots:
	void toggleShow();
	void enqueue();
	void quit();
	void playlists();
	void clearLists();
	void importXML();
	void exportXML();

	void showAbout();
    void toggleShowMain();
	void toggleMinimal();
	void incRatingCurrentSong();
	void decRatingCurrentSong();

	void setSelectedSongGenre(int, int, int);
	void setQConstraint(int, int, int, int);

	void saveVisibility();

	//sets the playlist to the one selected in the tray menu
	void setPlaylist(int);
protected:
	bool event(QEvent* e);

private:
	LPApp* getApp();
	void setApp(LPApp* app);
	LPSettings* getSettings();
	void checkSettings();
	void setLayout();
	void saveLayout();
	void createMenus();
	void checkMenus();
	void createToolbars();
	void refreshPlaylists();
	bool _quitting;

	void update();
	QString formatSongText(Song s);
	QStatusBar *statusbar;
	QPopupMenu *viewMenu;

	Song _lastSong;
	Song _selectedSong;
	PlayedSongHandler* _playedSongHandler;
	LPFormStartup* _splash;
	LPApp* _app;
	PlayedSongTip* tip;
#ifdef _WS_WIN_
	TrayIcon *tray;
	QPopupMenu *_playlistsmenu;
#endif

	bool _msgbusy;
	
	//toolbars
	QToolBar* _mainBar;
	QToolBar* _mediaBar;
	QToolButton* _minimalButton;
	
	//states
	bool _stateMinimal;
	LPSettings* _settings;
}; //LPWindowMain


//Played Songs listviewitem
class PlayedSongItem : public QListViewItem
{
	public:
		PlayedSongItem(QListView* list, Song sng);
		//needed for sorting
		virtual QString key(int column, bool ascending) const;
		QString getSongKey();
		//sets song and updates fields
		void setSong(Song sng);
		string getFilename();

		//reimplemented
		void paintCell ( QPainter* p, const QColorGroup& cg, int column, int width, int align );
		void setOdd(bool);
	protected:
		virtual void activate();
								
    private:
        int playedcolid;
		string _filename;
		int _odd;
}; //PlayedSongItem

//Played Songs tooltip
class PlayedSongTip : public QToolTip
{
	public:
		PlayedSongTip(QWidget* parent);

	protected:
		void maybeTip ( const QPoint& );
}; //PlayedSongTip

//Played Songs handler
class PlayedSongHandler : public QObject
{
	Q_OBJECT
	public:
		PlayedSongHandler(QWidget* parent);
		~PlayedSongHandler();
	
		void setSong(Song ns);
		void setItem(QListViewItem* nitem);
		void setApp(LPApp* app);
		//creates or updates a song item
		void makeSongListViewItem(QListView* list, Song sng,QListViewItem* existingItem=0);
		LPApp* getApp();

	public slots:
		void viewPopup(QListViewItem*, const QPoint&);

	protected slots:
	    void ListSongRefresh();
    	void ListSongIncRating();
	    void ListSongDecRating();
		void ListSongReset();
		void ListSongRemoveFromDisk();
		void ListSongCopyPath();
		void ListSongCopyDescription();
		void ListSongRequeue();
		void ListSongReplay();
		void ListSongRate(int i);
		void ListDirRate(int i);
		void ListDirPlay();
		void ListPlaylistPlay();
		void setDirGenre();
	private:
		Song s; QListViewItem* item;
		QPopupMenu *ratesong;
		QWidget* widget;
		QPopupMenu *ratedir;
		LPApp* _app;
}; //PlayedSongHandler

class LPToolBar : public QToolBar {
	
	public:
		LPToolBar ( LPSettings* ,string setting, QMainWindow* parent = 0, const char* name = 0);
		virtual void polish();
		virtual void showEvent(QShowEvent*);
		virtual void hideEvent(QHideEvent*);
	private:
		LPSettings* _settings; string _setting;
}; //LPToolBar



#endif

