#include "lpwindowmainbase.h"
#include "lpglobal.h"
#include "lpsettings.h"
#include "absutil.h"
#include "lpglobal.h"
#include "lpicon.h"
#include "genrewidget.h"

#include <qcheckbox.h>
#include <qcombobox.h>
#include <qdir.h>
#include <qdial.h>
#include <qslider.h>
#include <qgroupbox.h>
#include <qheader.h>
#include <qlabel.h>
#include <qlistbox.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qtextview.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpicture.h>
#include <qpixmap.h>
#include <qpainter.h>
#include <qvbox.h>

/*
 *  Constructs a LPWindowMainBase which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
LPWindowMainBase::LPWindowMainBase( QWidget* parent,  const char* name, WFlags fl )
    : QMainWindow( parent, name, fl )
{
    QPixmap image0( ( const char** ) lplayer0_xpm );
    if ( !name )
	setName( "MainWindowBase" );
    setProperty( "caption", tr( "LongPlayer" ) );
    setProperty( "icon", image0 );

	mainWidget = new QVBox(this);
	mainWidget->setSpacing(6);
	mainWidget->setMargin(6);

	/* main box
	 */
#if QT_VERSION / 100 > 2
#endif
		grpMain = new QGroupBox( mainWidget, "grpMain" );
		grpMain->setMargin(6);
#if QT_VERSION / 100 > 2
		grpMain->setBackgroundOrigin(QWidget::AncestorOrigin);
#endif

#if QT_VERSION / 100 > 2
//		grpMain->setFlat(true);
		grpMain->setSizePolicy(QSizePolicy(QSizePolicy::Preferred,QSizePolicy::Fixed,0,0));
#else
//		grpMain->setFrameShape(QFrame::NoFrame);
		grpMain->setSizePolicy(QSizePolicy(QSizePolicy::Preferred,QSizePolicy::Fixed));
#endif
		grpMain->setColumnLayout(0, Qt::Vertical );

		//horizontal layout containing everything from grpMain
		grpMainLayout = new QHBoxLayout( grpMain->layout() );

		//a grid containing ...everything
		//  Queue From	Box		Space	Genre	Rating
		//				checks	Space	widget	widget
		QGridLayout* gridLayoutQueue = new QGridLayout(2,5);
		grpMainLayout->addLayout( gridLayoutQueue);
		gridLayoutQueue->setSpacing(6);

		gridLayoutQueue->setColStretch(2,1);

			//Queue From
			chkQueue = new QCheckBox( grpMain, "chkQueue" );
#if QT_VERSION / 100 > 2
			chkQueue->setBackgroundOrigin(QWidget::AncestorOrigin);
#endif
			chkQueue->setProperty( "text", tr( "Queue From" ) );
			QToolTip::add(  chkQueue, tr( "if checked, keeps queueing new songs." ) );
			gridLayoutQueue->addWidget( chkQueue,0,0);

			boxPlaylist = new QListBox(grpMain, "boxPlaylist" );
#if QT_VERSION / 100 > 2
			boxPlaylist->setBackgroundOrigin(QWidget::AncestorOrigin);
#endif
			boxPlaylist->setProperty( "minimumSize", QSize( 100, 94 ) );
			boxPlaylist->setProperty( "maximumSize", QSize( 32000, 94 ) );
			QToolTip::add(boxPlaylist, tr( "source of the music to play" ) );
			gridLayoutQueue->addWidget( boxPlaylist,1,0,Qt::AlignTop );

//			chkAnalyze = new QCheckBox( grpMain, "chkAnalyze" );
#if QT_VERSION / 100 > 2
//			chkAnalyze->setBackgroundOrigin(QWidget::AncestorOrigin);
#endif
//			chkAnalyze->setProperty( "text", tr( "Register" ) );
//			QToolTip::add(  chkAnalyze, tr( "if checked, LongPlayer will register the dates new songs are being played on." ) );


			QLabel* genreQLabel = new QLabel( grpMain, "GenreTopLabel" );
#if QT_VERSION / 100 > 2
			genreQLabel->setBackgroundOrigin(QWidget::AncestorOrigin);
#endif
			genreQLabel->setProperty( "text", tr( "Genre Limits" ) );
			genreQLabel->setProperty( "alignment", int( QLabel::AlignBottom | QLabel::AlignLeft ) );
			gridLayoutQueue->addWidget( genreQLabel,0,3);

			genreQMatrix = new GenreConstraintWidget( grpMain, "genreMatrix" );
			genreQMatrix->setProperty( "frameShape", (int)QFrame::StyledPanel );
			genreQMatrix->setProperty( "frameShadow", (int)QFrame::Sunken );
			genreQMatrix->setLineWidth(2);
			gridLayoutQueue->addWidget(genreQMatrix,1,3);

			QLabel* qRatingLabel = new QLabel( grpMain, "RatingTopLabel" );
#if QT_VERSION / 100 > 2
			qRatingLabel->setBackgroundOrigin(QWidget::AncestorOrigin);
#endif
			qRatingLabel->setProperty( "text", tr( "Min. Rating" ) );
			qRatingLabel->setProperty( "alignment", int( QLabel::AlignBottom | QLabel::AlignHCenter ) );
			gridLayoutQueue->addWidget( qRatingLabel,0,4);

			//layout containing 0+ slider + 10
			QHBoxLayout* layoutLQRating = new QHBoxLayout;
			layoutLQRating->setMargin(6);
			layoutLQRating->setSpacing(0);
			QVBoxLayout* layoutQRating = new QVBoxLayout;

				QLabel* tenQLabel = new QLabel( grpMain, "tenQLabel" );
#if QT_VERSION / 100 > 2
				tenQLabel->setBackgroundOrigin(QWidget::AncestorOrigin);
#endif
				tenQLabel->setProperty( "text", tr( "10 " ) );
				tenQLabel->setProperty( "alignment", int( QLabel::AlignTop | QLabel::AlignRight ) );
				layoutQRating->addWidget(tenQLabel);

				QLabel* zeroQLabel = new QLabel( grpMain , "zeroQLabel" );
#if QT_VERSION / 100 > 2
				zeroQLabel->setBackgroundOrigin(QWidget::AncestorOrigin);
#endif
				zeroQLabel->setProperty( "text", tr( "0 " ) );
				zeroQLabel->setProperty( "alignment", int( QLabel::AlignBottom | QLabel::AlignRight ) );
				layoutQRating->addWidget(zeroQLabel);

				layoutLQRating->addLayout(layoutQRating);

				sliderQRating = new QSlider( Vertical, grpMain , "sliderQRating" );
#if QT_VERSION / 100 > 2
				sliderQRating->setBackgroundOrigin(QWidget::AncestorOrigin);
#endif
				sliderQRating->setRange(-10,0);
				sliderQRating->setSteps(1,1);
				sliderQRating->setValue(-5);
				sliderQRating->setTickmarks(QSlider::Left);
				sliderQRating->setTickInterval(2);
				QToolTip::add(  sliderQRating, tr( "Sets the minimum rating of the songs to queue." ) );
				layoutLQRating->addWidget(sliderQRating,0,int(Qt::AlignLeft));

			gridLayoutQueue->addLayout( layoutLQRating,1,4);

	/* played box
	 */
#if QT_VERSION / 100 > 2
#endif
		grpPlayed = new QGroupBox( mainWidget, "grpPlayed" );
		grpPlayed->setMargin(6);
#if QT_VERSION / 100 > 2
		grpPlayed->setBackgroundOrigin(QWidget::AncestorOrigin);
#endif
#if QT_VERSION / 100 > 2
//		grpPlayed->setFlat(true);
		grpPlayed->setSizePolicy(QSizePolicy(QSizePolicy::Expanding,QSizePolicy::Expanding,0,5));
#else
//		grpPlayed->setFrameShape(QFrame::NoFrame);
		grpPlayed->setSizePolicy(QSizePolicy(QSizePolicy::Expanding,QSizePolicy::Expanding));
#endif
		grpPlayed->setColumnLayout(0, Qt::Vertical );

		grpPlayedLayout = new QHBoxLayout( grpPlayed->layout() );
		grpPlayedLayout->setAlignment( Qt::AlignTop );
		grpPlayedLayout->setSpacing( 6 );

		viewPlayedSongs = new QListView( grpPlayed, "viewPlayedSongs" );
#if QT_VERSION / 100 > 2
		viewPlayedSongs->setBackgroundOrigin(QWidget::AncestorOrigin);
#endif
		viewPlayedSongs->addColumn( tr( "Played At" ) );
		viewPlayedSongs->addColumn( tr( "Song" ) );
		viewPlayedSongs->addColumn( tr( "Rating" ) );
		viewPlayedSongs->addColumn( tr( "Last Heard" ) );
		viewPlayedSongs->addColumn( tr( "Times" ) );
		viewPlayedSongs->addColumn( tr( "Length" ) );
		grpPlayedLayout->addWidget( viewPlayedSongs );

	/* current song box
	 */
		grpCurrent = new QGroupBox( mainWidget, "grpCurrent" );
		grpCurrent->setMargin(6);
#if QT_VERSION / 100 > 2
		grpCurrent->setBackgroundOrigin(QWidget::AncestorOrigin);
		grpCurrent->setSizePolicy(QSizePolicy(QSizePolicy::Preferred,QSizePolicy::Fixed,0,0));
#else
		grpCurrent->setSizePolicy(QSizePolicy(QSizePolicy::Preferred,QSizePolicy::Fixed));
#endif

#if QT_VERSION / 100 > 2
//		grpCurrent->setFlat(true);
#else
//		grpCurrent->setFrameShape(QFrame::NoFrame);
#endif
		grpCurrent->setColumnLayout(0, Qt::Vertical );

		//horizontal box containing songinfo + right side
		grpCurrentLayout = new QHBoxLayout( grpCurrent->layout() );
		grpCurrentLayout->setAlignment( Qt::AlignTop );
		grpCurrentLayout->setSpacing( 6 );
			//a grid consisting of song details ,a genre and rating widget, and upper space
			QGridLayout* layoutRight = new QGridLayout(2,4);
			grpCurrentLayout->addLayout( layoutRight );
			layoutRight->setSpacing(6);
			layoutRight->setRowStretch(0,0);
			layoutRight->setRowStretch(1,0);
			layoutRight->setColStretch(0,5);
			layoutRight->setColStretch(1,0);
			layoutRight->setColStretch(2,0);

			//current song info
			QLabel* detailsLabel = new QLabel( grpCurrent, "Song Details" );
#if QT_VERSION / 100 > 2
				detailsLabel->setBackgroundOrigin(QWidget::AncestorOrigin);
#endif
				detailsLabel->setProperty( "text", tr( "Song Details" ) );
				detailsLabel->setProperty( "alignment", int( QLabel::AlignBottom | QLabel::AlignLeft ) );
				layoutRight->addWidget( detailsLabel , 0,0);
			txtSong = new QTextView( grpCurrent, "txtSong" );
			txtSong->setMinimumHeight(94);
			txtSong->setMaximumHeight(94);
#if QT_VERSION / 100 > 2
			txtSong->setBackgroundOrigin(QWidget::AncestorOrigin);
#endif
			txtSong->setProperty( "backgroundOrigin", (int)QTextView::ParentOrigin );
			txtSong->setProperty( "frameShape", (int)QTextView::StyledPanel );
			txtSong->setProperty( "frameShadow", (int)QTextView::Sunken );
			QToolTip::add(  txtSong, tr( "information about the song playing currently " ) );
			layoutRight->addWidget( txtSong , 1,0);

				//genre
				QLabel* genreLabel = new QLabel( grpCurrent, "GenreTopLabel" );
#if QT_VERSION / 100 > 2
				genreLabel->setBackgroundOrigin(QWidget::AncestorOrigin);
#endif
				genreLabel->setProperty( "text", tr( "Genre" ) );
				genreLabel->setProperty( "alignment", int( QLabel::AlignBottom | QLabel::AlignLeft ) );
				layoutRight->addWidget( genreLabel , 0,1);

				genreMatrix = new GenreWidget( grpCurrent, "genreMatrix" );
				genreMatrix->setProperty( "frameShape", (int)QFrame::StyledPanel );
				genreMatrix->setProperty( "frameShadow", (int)QFrame::Sunken );
				genreMatrix->setLineWidth(2);

				layoutRight->addWidget(genreMatrix, 1,1);

				//rating
				TextLabel2 = new QLabel( grpCurrent, "RatingTopLabel" );
#if QT_VERSION / 100 > 2
				TextLabel2->setBackgroundOrigin(QWidget::AncestorOrigin);
#endif
				TextLabel2->setProperty( "text", tr( "Rating" ) );
				TextLabel2->setProperty( "alignment", int( QLabel::AlignBottom | QLabel::AlignHCenter ) );
				layoutRight->addWidget( TextLabel2, 0,2 );

				//frame containing 0 + slider + 10
				QVBoxLayout* layoutRating = new QVBoxLayout;
				QHBoxLayout* layoutLRating = new QHBoxLayout;
				layoutLRating->setMargin(6);
				layoutLRating->setSpacing(0);

					TextLabel1 = new QLabel( grpCurrent, "tenQLabel" );
#if QT_VERSION / 100 > 2
					TextLabel1->setBackgroundOrigin(QWidget::AncestorOrigin);
#endif
					TextLabel1->setProperty( "text", tr( "10 " ) );
					TextLabel1->setProperty( "alignment", int( QLabel::AlignTop | QLabel::AlignRight ) );
					layoutRating->addWidget(TextLabel1);

					TextLabel1_2 = new QLabel( grpCurrent, "zeroQLabel" );
#if QT_VERSION / 100 > 2
					TextLabel1_2->setBackgroundOrigin(QWidget::AncestorOrigin);
#endif
					TextLabel1_2->setProperty( "text", tr( "0 " ) );
					TextLabel1_2->setProperty( "alignment", int( QLabel::AlignBottom | QLabel::AlignRight ) );
					layoutRating->addWidget(TextLabel1_2);
					layoutLRating->addLayout(layoutRating);

					sliderCurrentRating = new QSlider( Vertical, grpCurrent, "sliderCurrentRating" );
#if QT_VERSION / 100 > 2
					sliderCurrentRating->setBackgroundOrigin(QWidget::AncestorOrigin);
#endif
					sliderCurrentRating->setRange(-10,0);
					sliderCurrentRating->setSteps(1,1);
					sliderCurrentRating->setValue(-5);
					sliderCurrentRating->setTickmarks(QSlider::Left);
					sliderCurrentRating->setTickInterval(2);
					QToolTip::add(  sliderCurrentRating, tr( "sets the rating for this song" ) );
					QWhatsThis::add(  sliderCurrentRating, tr( "test" ) );

					layoutLRating->addWidget(sliderCurrentRating, int(Qt::AlignLeft));

				// end of 0+slider+10
				layoutRight->addLayout( layoutLRating,1,2);

	/* Queued list
	*/
		grpQueued = new QGroupBox( this, "grpQueued" );
#if QT_VERSION / 100 > 2
		grpQueued->setBackgroundOrigin(QWidget::AncestorOrigin);
#endif
		grpQueued->setProperty( "title", tr( "Coming Up" ) );
		grpQueued->setColumnLayout(0, Qt::Vertical );
		grpQueued->layout()->setMargin(11);
		grpQueuedLayout = new QHBoxLayout( grpQueued->layout() );
		grpQueuedLayout->setAlignment( Qt::AlignTop );
		grpQueuedLayout->setSpacing(6);

		viewQueuedSongs = new QListView( grpQueued, "viewQueuedSongs" );
#if QT_VERSION / 100 > 2
		viewQueuedSongs->setBackgroundOrigin(QWidget::AncestorOrigin);
#endif
		viewQueuedSongs->addColumn( tr( "Name" ) );
		viewQueuedSongs->addColumn( tr( "Heard on" ) );
		viewQueuedSongs->addColumn( tr( "Rating" ) );
		viewQueuedSongs->addColumn( tr( "Times heard" ) );
		viewQueuedSongs->addColumn( tr( "Length" ) );
		QListViewItem * item = new QListViewItem( viewQueuedSongs, 0 );
		item->setText( 0, tr( "New Item" ) );

		grpQueuedLayout->addWidget( viewQueuedSongs );

       // signals and slots connections
    connect( boxPlaylist, SIGNAL( currentChanged(QListBoxItem*) ), this, SLOT( prefchange() ) );
    //connect( chkAnalyze, SIGNAL( clicked() ), this, SLOT( toggleAnalyze() ) );
    connect( chkQueue, SIGNAL( clicked() ), this, SLOT( toggleQueue() ) );
    connect( sliderCurrentRating, SIGNAL( valueChanged(int) ), this, SLOT( changeRating(int) ) );
    connect( sliderQRating, SIGNAL( valueChanged(int) ), this, SLOT( changeQRating(int) ) );
    connect( viewPlayedSongs, SIGNAL( doubleClicked(QListViewItem*) ), this, SLOT( playNow(QListViewItem*) ) );
    connect( viewPlayedSongs, SIGNAL( currentChanged(QListViewItem*) ), this, SLOT( selectSong(QListViewItem*) ) );

    // tab order
    setTabOrder( chkQueue, boxPlaylist );
    setTabOrder( chkQueue, viewQueuedSongs );
    
	setCentralWidget(mainWidget);
}


/*
 *  Destroys the object and frees any allocated resources
 */
LPWindowMainBase::~LPWindowMainBase() {
    // no need to delete child widgets, Qt does it all for us
}

void LPWindowMainBase::changeQRating(int) {
    qWarning( "LPWindowMainBase::changeLike(int): Not implemented yet!" );
}

void LPWindowMainBase::changeRating(int) {
    qWarning( "LPWindowMainBase::changeLike(int): Not implemented yet!" );
}
void LPWindowMainBase::selectSong(QListViewItem*)
{
    qWarning( "LPWindowMainBase::selectSong(QListViewItem*): Not implemented yet!" );
}

void LPWindowMainBase::playNow(QListViewItem*) {
    qWarning( "LPWindowMainBase::playNow(QListViewItem*): Not implemented yet!" );
}

void LPWindowMainBase::prefchange() {
    qWarning( "LPWindowMainBase::prefchange(): Not implemented yet!" );
}

void LPWindowMainBase::prefs() {
    qWarning( "LPWindowMainBase::prefs(): Not implemented yet!" );
}

void LPWindowMainBase::queue() {
    qWarning( "LPWindowMainBase::queue(): Not implemented yet!" );
}

void LPWindowMainBase::search() {
    qWarning( "LPWindowMainBase::search(): Not implemented yet!" );
}

void LPWindowMainBase::toggleAnalyze() {
    qWarning( "LPWindowMainBase::toggleAnalyze(): Not implemented yet!" );
}

void LPWindowMainBase::toggleQueue() {
    qWarning( "LPWindowMainBase::toggleQueue(): Not implemented yet!" );
}

void LPWindowMainBase::toggleShowCurrent() {
    qWarning( "LPWindowMainBase::toggleShowCurrent(): Not implemented yet!" );
}

void LPWindowMainBase::toggleShowQueue() {
    qWarning( "LPWindowMainBase::toggleShowQueue(): Not implemented yet!" );
}

void LPWindowMainBase::pplay() {
    qWarning( "LPWindowMainBase::toggleShowQueue(): Not implemented yet!" );
}

void LPWindowMainBase::pnext() {
    qWarning( "LPWindowMainBase::toggleShowQueue(): Not implemented yet!" );
}

void LPWindowMainBase::pprevious() {
    qWarning( "LPWindowMainBase::toggleShowQueue(): Not implemented yet!" );
}

void LPWindowMainBase::pstop() {
    qWarning( "LPWindowMainBase::toggleShowQueue(): Not implemented yet!" );
}

void LPWindowMainBase::accept() { }


