/** LongPlayer - cross-platform multimedia queuer
 *  Copyright (C) 2001-2004 Andrew Wils
 *
 *  This program is free software; See the
 *  GNU General Public License for more details.
 */
#ifndef H_M3UPLAYLIST
#define H_M3UPLAYLIST

#include "lpglobal.h"
#include "playlist.h"

#include <vector>
using namespace std;

/** a playlist that is based on a set of directories */
class M3UPlaylist : public Playlist {
public:
	M3UPlaylist();
	M3UPlaylist(string name);

	string getM3U();
	void setM3U(string filename);

	virtual bool equals(Playlist*); //redefined
	static bool isM3U(string filename);
	
	virtual int getType();
	static const int TYPE;
protected:
	virtual void buildInit(vector<string>*);
	virtual void buildStep(vector<string>*);
	virtual void buildCleanup(vector<string>*);
private:
	string _m3u;
};

#endif
