/* LongPlayer shabby code copyright Andrew Wils */

#include "lpglobal.h"
#include "lpsettings.h"
#include "lpwindowmain.h"
#include "lpnogui.h"
#include "lpargparser.h"
#include "logqt.h"
#include "tester.h"

#ifdef _WS_WIN_
	#include "utilwin.h"
#else
	#include "utillinux.h"
#endif

#include <qnamespace.h>
#include <qapplication.h>

#include <iostream>

/*a main method that starts LPApp */
int main(int argc, char *argv[]) {

	//initialize Qt and process Qt-related switches
    QApplication app( argc, argv );
   
	//process LongPlayer command-line switches
	LPSettings* settings = new LPSettings();
	LPArgParser argparser(argc, argv, settings);
	if (!argparser.valid()) 
		settings->setISetting("main","help",1,false); //display help
		
	settings->revert();
    LogQt* logger = new LogQt(settings->getISetting("main","debug"));
    logger->setOutput(0);
    logger->setWidget(0);
	logger->setApplication(qApp);
    globalclass::setLogger(logger);
    absUtil::setUtil(new Util());
    if (settings->testSetting("main","quit")) return 0;
    if (settings->getISetting("main","nogui")) {
        cout << "command line version under construction.\n";
	}
	else {
		if (settings->getISetting("main","test")) {
			Tester t(settings);
			t.testAll();
		}
		else {
		/* create and start the default Qt GUI */
		LPWindowMain* qtgui = new LPWindowMain(settings, 0,"LongPlayer",Qt::WStyle_MinMax | Qt::WStyle_SysMenu);
		qApp->setMainWidget(qtgui);
		//start gui...
		qApp->exec();
		}

	}
	delete settings;
	delete logger;
	delete absUtil::getUtil();
	return 0;
}
