#include "playlist.h"
#include "absutil.h"
#include <qdir.h>

Playlist::Playlist(string name) : _abort(true), _built(false), _name(name), _filter(0) {
	_filenames = 0;
	_buildMutex = new QMutex();
	_filter = this;
}

Playlist::~Playlist() { if (_filenames) delete _filenames; }

bool Playlist::equals(Playlist* list) {
	logDebug("playlist::equals");
	if (getName() != list->getName()) return false;
	if (getFilenamesEndWith() != list->getFilenamesEndWith()) return false;
	if (getFilenamesDoNotEndWith() != list->getFilenamesDoNotEndWith()) return false;
	if (getFilenamesContain() != list->getFilenamesContain()) return false;
	return true;
}

string Playlist::getName() const { return _name; }
void Playlist::setName(string name) { _name = name; }

vector<string> Playlist::getFilenamesEndWith() const { return _filenamesEndWith; }
vector<string> Playlist::getFilenamesDoNotEndWith() const { return _filenamesDoNotEndWith; }
vector<string> Playlist::getFilenamesContain() const{ return _filenamesContain; }

void Playlist::setFilenamesEndWith(vector<string> filter) { _filenamesEndWith = filter; }
void Playlist::setFilenamesContain(vector<string> filter) {	_filenamesContain = filter; }
void Playlist::setFilenamesDoNotEndWith(vector<string> filter) { _filenamesDoNotEndWith = filter; }

void Playlist::setFilter(Playlist* f) { _filter = f; }
Playlist* Playlist::getFilter() { return _filter; }

vector<string>* Playlist::filenames(){ return _filenames; }

bool Playlist::getBuilt() {	return _built; }

void Playlist::stopBuilding() {
	_abort = true;
}

void Playlist::startBuilding() {
	_filenames = 0;
	_abort = false;

    logDebug(string("Playlist::building list of files..."));
	if (_filenames) delete _filenames;
	vector<string>* temp = new vector<string>();
	buildInit(temp);
	while (!_built && !_abort) {
		buildStep(temp);
	}
	buildCleanup(temp);
	_filenames = temp;
}

bool Playlist::validFilename(string sfilename) {
	if (getFilter() != this) return getFilter()->validFilename(sfilename);
	QString filename = QString::fromLocal8Bit(sfilename.c_str());
//1
	for (uint j=0;j<_filenamesContain.size();j++) {	
		if ( !filename.contains(_filenamesContain[j].c_str(),false) ) return false;
	}
//2	
	bool foundOne = false; //default
	for (uint k=0;!foundOne && (k<_filenamesEndWith.size());k++) {
		 if ( filename.right(_filenamesEndWith[k].length()).contains(_filenamesEndWith[k].c_str(),false)) { foundOne = true; }
	}
	if (!foundOne && _filenamesEndWith.size()) return false;
//3
	for (uint l=0;l<_filenamesDoNotEndWith.size();l++) {
		if ( filename.right(_filenamesDoNotEndWith[l].length()).contains(_filenamesDoNotEndWith[l].c_str(),false)) return false;
	}
	return true;
}
