/** LongPlayer - cross-platform multimedia queuer
 *  Copyright (C) 2001-2004 Andrew Wils
 *
 *  This program is free software; See the
 *  GNU General Public License for more details.
 */
#ifndef H_PLAYLISTREADER
#define H_PLAYLISTREADER

#include <vector>

#include "lpglobal.h"
#include "lpsong.h"
#include "compositeplaylist.h"

#include <qdom.h>

class LPSettings;
/* Provides persistance for all built-in Playlist-types */
class PlaylistReader {
public:
    PlaylistReader(LPSettings* settings);
    ~PlaylistReader();
	
    CompositePlaylist* getPlaylist(string name);
    void setPlaylist(CompositePlaylist* playlist);
    void removePlaylist(string playlist);
    vector<string> getPlaylists();

    void save();
    void revert();
	
	LPSettings* getSettings();
private:
	void loadPlaylists();
    QDomDocument _playlistdoc;
	LPSettings* _settings;
};
#endif
