#ifndef H_SYNCDATABASE
#define H_SYNCDATABASE

#include <fstream>
#include <iostream>

#include <qthread.h>

#include "absutil.h"
#include "lpsong.h"
#include "lpdatabasereader.h"
#include "lpdatabaseiterator.h"

using namespace std;

/** SynchronizedDBAccess:
 *  thread-safe version of LPDatabaseReader
 */
class LPSettings;
class QFile;
class SynchronizedDBAccess;

class SynchronizedDBAccess : public LPDatabaseReader
{
public:
	SynchronizedDBAccess(LPDatabaseReader*);
	~SynchronizedDBAccess();
	virtual void flush();
	virtual void compact();

	virtual void store(Song song);
	virtual void remove(Song song);
	virtual Song retrieve(string key);
	virtual Song retrieve(Song);

	virtual bool inDatabase(string key) ;
	virtual int getSize() ;

	virtual LPDatabaseIterator* iterator();

private:
	LPDatabaseReader* _reader;
	QMutex dbAccess;

    class SynchronizedIterator : public LPDatabaseIterator
    {
      public:
        SynchronizedIterator(SynchronizedDBAccess*, LPDatabaseIterator*);
        void reset();
        Song next();
        bool atEnd();
                                       
      private:
        SynchronizedDBAccess* _db;
        LPDatabaseIterator* _iterator;
    };  
    
    friend class SynchronizedIterator;
};

#endif
