#ifdef _WINDOWS
#include "winamp3.h"
#include <fstream>
#include <qtextstream.h>
#include <qfileinfo.h>
#include <string>
#include "../../studio/services/svc_mediacore.h"
//#include "../../studio/services/svc_playlist.h"
#include "../../../studio/pledit/svc_pldir.h"
#include "../../../studio/pledit/playlist.h"

#include "resource.h"

#include "../../studio/api.h"
#include "../../bfc/wnds/buttwnd.h"
#include "../../common/framewnd.h"
#include "../../bfc/notifmsg.h"

using namespace std;

//const int timerId = 0x0F4A352B;

/*
int Winamp3::rewind()
{
	return 0;
}
int Winamp3::forward(){
	return 0;
}

const char* Winamp3::getNextPlayItem(){
	return 0;
}
*/
Winamp3::Winamp3(ComponentAPI* myApi) : _rtitle("")
{
	_api = myApi;
	_rplaying = false;
	_rfilename = "";

	//not used for now TODO
//	timerclient_setTimer(timerId, 250);

}
Winamp3::~Winamp3()
{
}

int Winamp3::getPlaylistPosition() const
{
	return _rcurpos;
}

string Winamp3::getPath() const

{
	return _api->getAppPath ();//todo not threadsafe
}

int Winamp3::getPlaylistLength() const
{
	
	return _rtotalpos;
}

void Winamp3::setRFileName(string newf)
{
	_rfilename = newf;
}

string Winamp3::getRFileName() const 
{
	return _rfilename;

}

void Winamp3::setIsPlaying(bool play) 
{
	_rplaying = play;
}

bool Winamp3::isPlaying() const
{
	return _rplaying;
}

bool Winamp3::isRunning() const
{
	return 1;
}


bool Winamp3::inPlaylist(string filename) const
{
	//TODO test this..
	svc_plDir *pldir = SvcEnumByGuid<svc_plDir>();
	if (!pldir) return false;
	PlaylistHandle hand = pldir->getCurrentlyPlaying();
	Playlist *pl = pldir->getPlaylist(hand);
	int length = 0;
	if (!pl) return false;

	//Get the number of entries in the playlist.
	int numentries = pl->getNumEntries(); 
	//Enumerate all entries in the playlist.
	const char* str; //TODO: delete later on??
	bool result = false; string compstr = string("file:") + filename;
	for(int i = 0; !result && (i < numentries); i++) {         
		//Get the next playlist entry.
		PlaylistEntry * plentry = pl->enumEntry(i); 
		str = pl->getPlayStringFromEntry(plentry);
		if (string(str) == compstr) result = true;
	}
	SvcEnum::release(pldir);
	return result;
}

void Winamp3::cleanPlayed(int newsize)
{

} 

//this also cleans played
void Winamp3::cleanQueued()
{
} 

int Winamp3::getVolume()
{
	CoreHandle newHandle;
	return (newHandle.getVolume()*100) / 255;
}

void Winamp3::setVolume(int vol)
{
	CoreHandle newHandle;
	newHandle.setVolume((vol*255) / 100 );
}

void Winamp3::play()
{
	CoreHandle newHandle;
	newHandle.play();
}

void Winamp3::next()
{
	CoreHandle newHandle;
	newHandle.next();
}

void Winamp3::previous()
{
	CoreHandle newHandle;
	newHandle.prev();
}

void Winamp3::stop()
{
	CoreHandle newHandle;
	newHandle.stop();
}

int Winamp3::getRSongLength() const
{
	CoreHandle newHandle;
	return newHandle.getLength();
}
int Winamp3::getSongPosition(void) const
{
	CoreHandle newHandle;
	return newHandle.getPosition();
}
void Winamp3::setRSongName(string name)
{
	_rtitle = name;
}

string Winamp3::getRSongName() const
{
	return _rtitle;
}

void Winamp3::play(vector<string> filenames)
{
	if (filenames[0].empty() || (filenames[0] == "")) return;
	logDebug(string("WAC::Playing...and others"));
      svc_plDir *pldir;
      pldir = SvcEnumByGuid<svc_plDir>();  //Playlist Directory service.
	PlaylistHandle hand = pldir->getCurrentlyPlaying();
	Playlist *pl = pldir->getPlaylist(hand);
	for (int i=0;i<filenames.size();i++)
		pl->addPlaylistItem(string(string("file:") + filenames[i]).c_str());
	int nr = pl->getNumEntries();
	if (nr) pl->startPlayback(nr + filenames.size() - 2);
	SvcEnum::release(pldir);
	CoreHandle newHandle;
	newHandle.play();
	return;
  }

void Winamp3::queue(vector<string> filenames)
{
	if (filenames[0].empty() || (filenames[0] == "")) return;
	logDebug(string("WAC::Queueing...and others"));
	svc_plDir *pldir = SvcEnumByGuid<svc_plDir>();
	//PlaylistHandle hand = pldir->getCurrentlyOpen();
	PlaylistHandle hand = pldir->getCurrentlyPlaying();
	Playlist *pl = pldir->getPlaylist(hand);
	for (int i=0;i<filenames.size();i++)
		pl->addPlaylistItem(string(string("file:") + filenames[i]).c_str());
	SvcEnum::release(pldir);
return;
}

// Basic Events
int Winamp3::corecb_onStarted() {
	logDebug("WA3::corecb_onStarted");
	CoreHandle newHandle;
	const char* res = 0;
	res = newHandle.getCurrent();
	if (!res) return 0;
	string result = res;
	setRFileName(result.substr(5,result.size()-5));
	setIsPlaying(true);
	return 0;
}

int Winamp3::corecb_onStopped() {
//	logDebug("WA3::corecb_onStopped");
	setIsPlaying(false);
	return 0;
}

int Winamp3::corecb_onPaused() {
	logDebug("WA3::corecb_onPaused");
	return 0;
}

int Winamp3::corecb_onUnpaused() {
	logDebug("WA3::corecb_onUnPaused");
	return 0;
}

int Winamp3::corecb_onSeeked(int newpos) {
	logDebug("WA3::corecb_onSeeked");
	return 0;
}


// Volume & EQ Events
int Winamp3::corecb_onVolumeChange(int newvol) {
	logDebug("WA3::corecb_onVolume");
	return 0;
}

int Winamp3::corecb_onEQStatusChange(int newval) {
	logDebug("WA3::corecb_onEQ");
	return 0;
}

int Winamp3::corecb_onEQPreampChange(int newval) {
	logDebug("WA3::corecb_onEQ");
	return 0;
}

int Winamp3::corecb_onEQBandChange(int band, int newval) {
	logDebug("WA3::corecb_onEQ");
	return 0;
}


// Info Events
int Winamp3::corecb_onTitleChange(const char *title) {
	logDebug("WA3::corecb_onTitle1");
	setRSongName(title);
	return 0;
}

int Winamp3::corecb_onTitle2Change(const char *title, const char *title2) {
	logDebug("WA3::corecb_onTitle2");
	return 0;
}

int Winamp3::corecb_onInfoChange(const char *info) {
	logDebug("WA3::corecb_onInfo");
	return 0;
}

int Winamp3::corecb_onUrlChange(const char *url) {
	logDebug("WA3::corecb_onURL");
	return 0;
}


// Source Events
int Winamp3::corecb_onNextFile() {
	logDebug("WA3::corecb_onNextFile");
	CoreHandle newHandle;
	const char* res = 0;
	res = newHandle.getCurrent();
	if (!res) return 0;

	string result = res;
	setRFileName(result.substr(5,result.size()-5));

	//TODO test this..
	svc_plDir *pldir = SvcEnumByGuid<svc_plDir>();
	if (!pldir) return 0;
	PlaylistHandle hand = pldir->getCurrentlyPlaying();
	Playlist *pl = pldir->getPlaylist(hand);

	//Get the current playlist entry and its position
	//PlaylistEntry * plentry = pl->getCurrent(); 
	//	pl->getPositionFromEntry(plentry);
	if (!pl) _rcurpos = 0;
	_rcurpos = pl->getCurrent(); 

	//Get the total nr of playlist entries
	_rtotalpos = 0;
	if (pl) _rtotalpos = pl->getNumEntries();

	SvcEnum::release(pldir);
	
	//CoreHandle newHandle;
	//newHandle.setNextFile("file:m:\\games\\blade runner - bounce.mp3");
	//newHandle.play();
	return 0;
}

int Winamp3::corecb_onNeedNextFile(int fileid) {
	logDebug("WA3::corecb_onNeedNextFile");
	return 0;
}

int Winamp3::corecb_onAbortCurrentSong() {
	logDebug("WA3::corecb_onAbort");
	return 0;
}

int Winamp3::corecb_onEndOfDecode() {
	logDebug("WA3::corecb_onEnd");
	return 0;
}


// Bad Events.
int Winamp3::corecb_onErrorOccured(int severity, const char *text) {
	logDebug("WA3::corecb_onError");
	return 0;
}

int Winamp3::corecb_onStatusMsg(const char *text) {
	logDebug("WA3::corecb_onStatus: " + string(text));
	return 0;
}

int Winamp3::corecb_onWarningMsg(const char *text) {
	logDebug("WA3::corecb_onWarning: " + string(text));
  return 0;
}

int Winamp3::corecb_onErrorMsg(const char *text) {
	logDebug("WA3::corecb_onError: " + string(text));
	return 0;
}
/*
void Winamp3::timerclient_timerCallback(int id)
{
//	timerclient_setTimer(timerId, 250);
  if(id == timerId)
  {
	  logDebug("bla");
  if(id == timerId && !registered)/////
	  const GUID svcguid = svc_Selector::getServiceGuid();

    svc_Selector *svcSel = SvcEnumByGuid<svc_Selector>(svcguid);

    if(svcSel)
    {
      svcSel->addSelector(exampleselector);

      SvcEnum::release(svcSel);

      registered = TRUE;

      timerclient_setTimer(timerId, 0);
    }
  }
}
*/
#endif


