/** LongPlayer - cross-platform multimedia queuer
 *  Copyright (C) 2001-2004 Andrew Wils
 *
 *  This program is free software; See the
 *  GNU General Public License for more details.
 */
#ifndef _WS_WIN_
#ifndef H_XMMS
#define H_XMMS

#include "lpglobal.h"
#include "absplayer.h"

class XMMS : public absPlayer {
public:
	virtual void play(vector<string> filename);
	virtual void setVolume(int vol);
	virtual int getVolume();
	virtual void play();
	virtual void next();
	virtual void previous();
	virtual void stop();
	virtual void queue(vector<string> filename);
	virtual int getPlaylistPosition() const;
	virtual int getPlaylistLength() const;
	virtual bool isPlaying() const;
	virtual bool isRunning() const;

	virtual bool inPlaylist(string filename) const;
	virtual void cleanPlayed(int newsize);
	virtual void cleanQueued();
	virtual string getPath() const;
	virtual int getSongPosition() const;
private:
	void setVars(string&,string&,int&) const;
	virtual string getRSongName() const;
	virtual int getRSongLength() const;
	virtual string getRFileName() const;
	 
};


#endif
#endif
