/* -*- C++ -*-
 *
 * ---------------------------------------------------------------------
 * $Id: config.h,v 1.5.2.4 2004/07/10 23:18:55 drory Exp $
 * ---------------------------------------------------------------------
 *
 * Copyright (C) 2000-2002 Niv Drory <drory@usm.uni-muenchen.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA 
 *
 * ---------------------------------------------------------------------
 *
 */


#ifndef __LTL_CONFIG__
#define __LTL_CONFIG__


// read autoconf output
#include <ltl/acconfig.h>

// ====================================================================

// DEFAULT BEHAVIOUR : edit these to reflect your needs
//                     (can also be set manually before includig ltl
//                     headers. set reasonable default values here)

// ====================================================================

// range checking and behaviour on range errors
//

// range checking off by default
// #define LTL_RANGE_CHECKING
//
// default is to abort on range error
// #define LTL_ABORT_ON_RANGE_ERROR
// #define LTL_THROW_ON_RANGE_ERROR
//
// #undef LTL_DEBUG_EXPRESSIONS
// #undef LTL_DEBUG_MEMORY_BLOCK

//
// limit for loop unrolling in FVector and FMatrix classes
//
#ifndef LTL_TEMPLATE_LOOP_LIMIT
#  define LTL_TEMPLATE_LOOP_LIMIT 32
#endif

// emit prefetch instructions (with GCC)
//
//#define LTL_EMIT_PREFETCH_GCC

// use namespaces 
//
#ifdef HAVE_NAMESPACES
#  define LTL_USING_NAMESPACE
#  define UTIL_USING_NAMESPACE
#endif

// ====================================================================

// END OF USER PART - the rest should not be changed

// ====================================================================



// exactly one of these two MUST be defined if we have range checking on
// either LTL_ABORT_ON_RANGE_ERROR or LTL_THROW_ON_RANGE_ERROR
//
#if defined(LTL_RANGE_CHECKING) && !defined(LTL_ABORT_ON_RANGE_ERROR) && !defined(LTL_THROW_ON_RANGE_ERROR)
#  define LTL_ABORT_ON_RANGE_ERROR
#endif


/* support for proposed 'restrict' keyword  */
#ifndef HAVE_NCEG_RESTRICT
#  define restrict_
#endif


#ifdef LTL_USING_NAMESPACE
#  define LTL_BEGIN_NAMESPACE  namespace ltl {
#  define UTIL_BEGIN_NAMESPACE namespace util {
#  define LTL_END_NAMESPACE  }
#  define UTIL_END_NAMESPACE }
#else
#  define LTL_BEGIN_NAMESPACE
#  define UTIL_BEGIN_NAMESPACE
#  define LTL_END_NAMESPACE
#  define UTIL_END_NAMESPACE
#endif


#if defined(HAVE_IEEE_MATH) && !defined(__SUNPRO_CC) && !defined(__GNUC__)
#  ifndef _ALL_SOURCE
#    define _ALL_SOURCE
#  endif
#  ifndef _XOPEN_SOURCE
#    define _XOPEN_SOURCE
#  endif
#  ifndef _XOPEN_SOURCE_EXTENDED
#    define _XOPEN_SOURCE_EXTENDED 1
#  endif
#endif


#if defined( __GNUC__ ) && defined( LTL_EMIT_PREFETCH_GCC ) 
#  if ( __GNUC__ > 3 ) || ( __GNUC__ == 3 && __GNUC_MINOR__ >= 1 )
#    define LTL_PREFETCH_R(addr) __builtin_prefetch((addr),0,1)
#    define LTL_PREFETCH_RW(addr) __builtin_prefetch((addr),1,1)
#  endif
#else
#  define LTL_PREFETCH_R(addr)
#  define LTL_PREFETCH_RW(addr)
#endif


#endif //__LTL_CONFIG__
