/* -*- C++ -*-
 *
 * ---------------------------------------------------------------------
 * $Id: fmexpr_ops.h,v 1.3.2.1 2003/11/02 23:23:43 cag Exp $
 * ---------------------------------------------------------------------
 *
 * Copyright (C) 2000-2002 Niv Drory <drory@usm.uni-muenchen.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA 
 *
 * ---------------------------------------------------------------------
 *
 */

#ifndef __LTL_IN_FILE_FMATRIX__
#error "<ltl/fmatrix/fmexpr_ops.h> must be included via <ltl/fmatrix.h>, never alone!"
#endif


#ifndef __LTL_APPLICOPS_H__
#include <ltl/misc/applicops.h>
#endif

#ifndef __LTL_FMEXPR_OPS__
#define __LTL_FMEXPR_OPS__

LTL_BEGIN_NAMESPACE

//
// now actually define operator template functions
// using the macros defined in <ltl/fvector/fvexpr.h>
//

// standard operators
//
DECLARE_FMBINOP(+, TAdd)

DECLARE_FMBINOP(-, TSub)
DECLARE_FMBINOP(*, TMul)
DECLARE_FMBINOP(/, TDiv)
DECLARE_FMBINOP_RET(&&, bool, TAnd)
DECLARE_FMBINOP_RET(||, bool, TOr)

DECLARE_FMBINOP(& , TBitAnd )
DECLARE_FMBINOP(| , TBitOr )
DECLARE_FMBINOP(^ , TBitXor )
DECLARE_FMBINOP(% , TMod )

DECLARE_FMBINOP_RET(> , bool, TGT )
DECLARE_FMBINOP_RET(< , bool, TLT )
DECLARE_FMBINOP_RET(>=, bool, TGE )
DECLARE_FMBINOP_RET(<=, bool, TLE )
DECLARE_FMBINOP_RET(!=, bool, TNE )
DECLARE_FMBINOP_RET(==, bool, TEQ )

DECLARE_FMUNOP( +,  TPlus )
DECLARE_FMUNOP( -,  TMinus )
DECLARE_FMUNOP( !,  TNot )
DECLARE_FMUNOP( ~,  TNeg )


// standard library math functions
//
DECLARE_FMUNARY_FUNC_( sin,   double )
DECLARE_FMUNARY_FUNC_( cos,   double )
DECLARE_FMUNARY_FUNC_( tan,   double )
DECLARE_FMUNARY_FUNC_( asin,  double )
DECLARE_FMUNARY_FUNC_( acos,  double )
DECLARE_FMUNARY_FUNC_( atan,  double )
DECLARE_FMUNARY_FUNC_( sinh,  double )
DECLARE_FMUNARY_FUNC_( cosh,  double )
DECLARE_FMUNARY_FUNC_( tanh,  double )
DECLARE_FMUNARY_FUNC_( exp,   double )
DECLARE_FMUNARY_FUNC_( log,   double )
DECLARE_FMUNARY_FUNC_( log10, double )
DECLARE_FMUNARY_FUNC_( sqrt,  double )
DECLARE_FMUNARY_FUNC_( fabs,  double )
DECLARE_FMUNARY_FUNC_( floor, double )
DECLARE_FMUNARY_FUNC_( ceil,  double )

DECLARE_FMBINARY_FUNC_( pow,  double )
DECLARE_FMBINARY_FUNC_( fmod, double )
DECLARE_FMBINARY_FUNC_( atan2,double )


// IEEE math functions
//
#ifdef HAVE_IEEE_MATH

DECLARE_FMUNARY_FUNC_( asinh,  double )
DECLARE_FMUNARY_FUNC_( acosh,  double )
DECLARE_FMUNARY_FUNC_( atanh,  double )
DECLARE_FMUNARY_FUNC_( cbrt,   double )
DECLARE_FMUNARY_FUNC_( expm1,  double )
DECLARE_FMUNARY_FUNC_( log1p,  double )
DECLARE_FMUNARY_FUNC_( erf,    double )
DECLARE_FMUNARY_FUNC_( erfc,   double )
DECLARE_FMUNARY_FUNC_( j0,     double )
DECLARE_FMUNARY_FUNC_( j1,     double )
DECLARE_FMUNARY_FUNC_( y0,     double )
DECLARE_FMUNARY_FUNC_( y1,     double )
DECLARE_FMUNARY_FUNC_( lgamma, double )
DECLARE_FMUNARY_FUNC_( rint,   double )

DECLARE_FMBINARY_FUNC_( hypot, double )
#endif

// these are defined in misc/applicops.h
//
DECLARE_FMUNARY_FUNC_( pow2, double )
DECLARE_FMUNARY_FUNC_( pow3, double )
DECLARE_FMUNARY_FUNC_( pow4, double )
DECLARE_FMUNARY_FUNC_( pow5, double )
DECLARE_FMUNARY_FUNC_( pow6, double )
DECLARE_FMUNARY_FUNC_( pow7, double )
DECLARE_FMUNARY_FUNC_( pow8, double )

LTL_END_NAMESPACE

#endif // __LTL_FMEXPROPS__
