/* -*- C++ -*-
 *
 * ---------------------------------------------------------------------
 * $Id: fvexpr_ops.h,v 1.3.2.1 2003/11/02 23:23:43 cag Exp $
 * ---------------------------------------------------------------------
 *
 * Copyright (C) 2000-2002 Niv Drory <drory@usm.uni-muenchen.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA 
 *
 * ---------------------------------------------------------------------
 *
 */

#ifndef __LTL_IN_FILE_FVECTOR__
#error "<ltl/fvector/fexpr_ops.h> must be included via <ltl/fvector.h>, never alone!"
#endif


#ifndef __LTL_APPLICOPS_H__
#include <ltl/misc/applicops.h>
#endif

#ifndef __LTL_FVEXPR_OPS__
#define __LTL_FVEXPR_OPS__

LTL_BEGIN_NAMESPACE

//
// now actually define operator template functions
// using the macros defined in <ltl/fvector/fvexpr.h>
//

// standard operators
//
DECLARE_FVBINOP(+, TAdd)

DECLARE_FVBINOP(-, TSub)
DECLARE_FVBINOP(*, TMul)
DECLARE_FVBINOP(/, TDiv)
DECLARE_FVBINOP_RET(&&, bool, TAnd)
DECLARE_FVBINOP_RET(||, bool, TOr)

DECLARE_FVBINOP(& , TBitAnd )
DECLARE_FVBINOP(| , TBitOr )
DECLARE_FVBINOP(^ , TBitXor )
DECLARE_FVBINOP(% , TMod )

DECLARE_FVBINOP_RET(> , bool, TGT )
DECLARE_FVBINOP_RET(< , bool, TLT )
DECLARE_FVBINOP_RET(>=, bool, TGE )
DECLARE_FVBINOP_RET(<=, bool, TLE )
DECLARE_FVBINOP_RET(!=, bool, TNE )
DECLARE_FVBINOP_RET(==, bool, TEQ )

DECLARE_FVUNOP( +,  TPlus )
DECLARE_FVUNOP( -,  TMinus )
DECLARE_FVUNOP( !,  TNot )
DECLARE_FVUNOP( ~,  TNeg )


// standard library math functions
//
DECLARE_FVUNARY_FUNC_( sin,   double )
DECLARE_FVUNARY_FUNC_( cos,   double )
DECLARE_FVUNARY_FUNC_( tan,   double )
DECLARE_FVUNARY_FUNC_( asin,  double )
DECLARE_FVUNARY_FUNC_( acos,  double )
DECLARE_FVUNARY_FUNC_( atan,  double )
DECLARE_FVUNARY_FUNC_( sinh,  double )
DECLARE_FVUNARY_FUNC_( cosh,  double )
DECLARE_FVUNARY_FUNC_( tanh,  double )
DECLARE_FVUNARY_FUNC_( exp,   double )
DECLARE_FVUNARY_FUNC_( log,   double )
DECLARE_FVUNARY_FUNC_( log10, double )
DECLARE_FVUNARY_FUNC_( sqrt,  double )
DECLARE_FVUNARY_FUNC_( fabs,  double )
DECLARE_FVUNARY_FUNC_( floor, double )
DECLARE_FVUNARY_FUNC_( ceil,  double )

DECLARE_FVBINARY_FUNC_( pow,  double )
DECLARE_FVBINARY_FUNC_( fmod, double )
DECLARE_FVBINARY_FUNC_( atan2,double )


// IEEE math functions
//
#ifdef HAVE_IEEE_MATH

DECLARE_FVUNARY_FUNC_( asinh,  double )
DECLARE_FVUNARY_FUNC_( acosh,  double )
DECLARE_FVUNARY_FUNC_( atanh,  double )
DECLARE_FVUNARY_FUNC_( cbrt,   double )
DECLARE_FVUNARY_FUNC_( expm1,  double )
DECLARE_FVUNARY_FUNC_( log1p,  double )
DECLARE_FVUNARY_FUNC_( erf,    double )
DECLARE_FVUNARY_FUNC_( erfc,   double )
DECLARE_FVUNARY_FUNC_( j0,     double )
DECLARE_FVUNARY_FUNC_( j1,     double )
DECLARE_FVUNARY_FUNC_( y0,     double )
DECLARE_FVUNARY_FUNC_( y1,     double )
DECLARE_FVUNARY_FUNC_( lgamma, double )
DECLARE_FVUNARY_FUNC_( rint,   double )

DECLARE_FVBINARY_FUNC_( hypot, double )
#endif

// these are defined in misc/applicops.h
//
DECLARE_FVUNARY_FUNC_( pow2, double )
DECLARE_FVUNARY_FUNC_( pow3, double )
DECLARE_FVUNARY_FUNC_( pow4, double )
DECLARE_FVUNARY_FUNC_( pow5, double )
DECLARE_FVUNARY_FUNC_( pow6, double )
DECLARE_FVUNARY_FUNC_( pow7, double )
DECLARE_FVUNARY_FUNC_( pow8, double )

LTL_END_NAMESPACE

#endif // __LTL_FVEXPROPS__
