/* -*- C++ -*-
*
* ---------------------------------------------------------------------
* $Id: cast.h,v 1.1.2.1 2004/06/30 22:53:31 drory Exp $
* ---------------------------------------------------------------------
*
* Copyright (C) 2000-2002 Niv Drory <drory@usm.uni-muenchen.de>
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
*
* ---------------------------------------------------------------------
*
*/


#if !defined(__LTL_IN_FILE_MARRAY__)
#error "<ltl/marray/cast.h> must be included via ltl headers, never alone!"
#endif


#ifndef __LTL_MARRAY_CAST_H__
#define __LTL_MARRAY_CAST_H__


LTL_BEGIN_NAMESPACE

/*! \file cast.h

  Type cast operations for MArrays and expressions

  Use as \code cast<type>()( MArray ) \endcode or \code
  cast<type>()(expression) \endcode.
*/


/*! \defgroup cast cast<Type>( Expr )

   Type-cast operation for \c MArrays and Expressions.
*/

//{@

//! The applicative template to do the cast
template<typename To_type, typename From_type>
struct __ltl_cast : public _et_applic_base
{
   typedef To_type value_type;
   static inline To_type eval( const From_type& a )
      { return static_cast<To_type>(a); }
};

/*!
 *  Type cast operation for \c MArray. Usage and semantics are
 *  (almost) as \c static_cast<T>() operation. For example, to use the
 *  elements of an \code MArray<float,2> A \endcode as \c ints, use
 *  cast<int>()( A ). See the extra parenthesis to instantiate the \c
 *  cast instance?
 */
template<typename T_type>
struct cast
{
      //! Version that accepts \c MArrays
      template<typename T, int N>
      inline TExpr<TUnExprOp<typename MArray<T,N>::ConstIterator,
                             __ltl_cast<T_type,T>, N >, N>
      operator()( const MArray<T,N>& a )
      {
         typedef TUnExprOp<typename MArray<T,N>::ConstIterator,
                           __ltl_cast<T_type,T>, N >
            ExprT;
         return TExpr<ExprT,N>( ExprT( a.begin() ) );
      }

      //! Version that accepts expression types
      template<typename T, int N>
      inline TExpr<TUnExprOp<TExpr<T,N>, 
                             __ltl_cast<T_type,typename T::value_type>, N >, N >
      operator()( const TExpr<T,N>& e )
      {
         typedef TUnExprOp<TExpr<T,N>, 
                 __ltl_cast<T_type,typename T::value_type>, N >
            ExprT;
         return TExpr<ExprT,N>(ExprT(e));
      }
};

//@}



LTL_END_NAMESPACE


#endif // __LTL_MARRAY_CAST_H__
