/* -*- C++ -*-
 *
 * ---------------------------------------------------------------------
 * $Id: expr_ops.h,v 1.4.2.2 2004/05/05 18:01:40 drory Exp $
 * ---------------------------------------------------------------------
 *
 * Copyright (C) 2000-2002 Niv Drory <drory@usm.uni-muenchen.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA 
 *
 * ---------------------------------------------------------------------
 *
 */

#ifndef __LTL_IN_FILE_MARRAY__
#error "<ltl/marray/expr_ops.h> must be included via <ltl/marray.h>, never alone!"
#endif


#ifndef __LTL_EXPR_OPS__
#define __LTL_EXPR_OPS__

LTL_BEGIN_NAMESPACE

//
// now actually define operator template functions
// using the macros defined in <ltl/expr.h>
//

// standard operators
//
DECLARE_BINOP(+, TAdd)
DECLARE_BINOP(-, TSub)
DECLARE_BINOP(*, TMul)
DECLARE_BINOP(/, TDiv)
DECLARE_BINOP_RET(&&, bool, TAnd)
DECLARE_BINOP_RET(||, bool, TOr)

DECLARE_BINOP(& , TBitAnd )
DECLARE_BINOP(| , TBitOr )
DECLARE_BINOP(^ , TBitXor )
DECLARE_BINOP(% , TMod )

DECLARE_BINOP_RET(> , bool, TGT )
DECLARE_BINOP_RET(< , bool, TLT )
DECLARE_BINOP_RET(>=, bool, TGE )
DECLARE_BINOP_RET(<=, bool, TLE )
DECLARE_BINOP_RET(!=, bool, TNE )
DECLARE_BINOP_RET(==, bool, TEQ )

DECLARE_UNOP( +,  TPlus )
DECLARE_UNOP( -,  TMinus )
DECLARE_UNOP( !,  TNot )
DECLARE_UNOP( ~,  TNeg )


// standard library math functions
//
DECLARE_UNARY_FUNC_( sin,   double )
DECLARE_UNARY_FUNC_( cos,   double )
DECLARE_UNARY_FUNC_( tan,   double )
DECLARE_UNARY_FUNC_( asin,  double )
DECLARE_UNARY_FUNC_( acos,  double )
DECLARE_UNARY_FUNC_( atan,  double )
DECLARE_UNARY_FUNC_( sinh,  double )
DECLARE_UNARY_FUNC_( cosh,  double )
DECLARE_UNARY_FUNC_( tanh,  double )
DECLARE_UNARY_FUNC_( exp,   double )
DECLARE_UNARY_FUNC_( log,   double )
DECLARE_UNARY_FUNC_( log10, double )
DECLARE_UNARY_FUNC_( sqrt,  double )
DECLARE_UNARY_FUNC_( fabs,  double )
DECLARE_UNARY_FUNC_( floor, double )
DECLARE_UNARY_FUNC_( ceil,  double )

DECLARE_BINARY_FUNC_( pow,  double )
DECLARE_BINARY_FUNC_( fmod, double )
DECLARE_BINARY_FUNC_( atan2,double )


// IEEE math functions
//
#ifdef HAVE_IEEE_MATH
DECLARE_UNARY_FUNC_( asinh,  double )
DECLARE_UNARY_FUNC_( acosh,  double )
DECLARE_UNARY_FUNC_( atanh,  double )
DECLARE_UNARY_FUNC_( cbrt,   double )
DECLARE_UNARY_FUNC_( expm1,  double )
DECLARE_UNARY_FUNC_( log1p,  double )
DECLARE_UNARY_FUNC_( erf,    double )
DECLARE_UNARY_FUNC_( erfc,   double )
DECLARE_UNARY_FUNC_( j0,     double )
DECLARE_UNARY_FUNC_( j1,     double )
DECLARE_UNARY_FUNC_( y0,     double )
DECLARE_UNARY_FUNC_( y1,     double )
DECLARE_UNARY_FUNC_( lgamma, double )
DECLARE_UNARY_FUNC_( rint,   double )

DECLARE_BINARY_FUNC_( hypot, double )
#endif

// these are defined in misc/applicops.h
//
DECLARE_UNARY_FUNC_( pow2, double )
DECLARE_UNARY_FUNC_( pow3, double )
DECLARE_UNARY_FUNC_( pow4, double )
DECLARE_UNARY_FUNC_( pow5, double )
DECLARE_UNARY_FUNC_( pow6, double )
DECLARE_UNARY_FUNC_( pow7, double )
DECLARE_UNARY_FUNC_( pow8, double )

LTL_END_NAMESPACE

#endif
