/* -*- C++ -*-
 *
 * ---------------------------------------------------------------------
 * $Id: swapbytes.h,v 1.1.1.1 2002/08/28 18:52:38 drory Exp $
 * ---------------------------------------------------------------------
 *
 * Copyright (C) 2000-2002 Niv Drory <drory@usm.uni-muenchen.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA 
 *
 * ---------------------------------------------------------------------
 *
 */




#ifndef __LTL_BYTESWAP__
#define __LTL_BYTESWAP__



#include <ltl/config.h>



// Byte swapping stuff for FITS I/O
//

#ifdef WORDS_BIGENDIAN

#  define LTL_TO_BIGENDIAN_16(val)   (val)
#  define LTL_TO_BIGENDIAN_32(val)   (val)
#  define LTL_TO_BIGENDIAN_64(val)   (val)
#  define LTL_FROM_BIGENDIAN_16(val) (val)
#  define LTL_FROM_BIGENDIAN_32(val) (val)
#  define LTL_FROM_BIGENDIAN_64(val) (val)

#else

#define LTL_UINT16_SWAP_(val)        ((uint16_t) (      \
    (((uint16_t) (val) & (uint16_t) 0x00ffU) << 8) |    \
    (((uint16_t) (val) & (uint16_t) 0xff00U) >> 8)))

#define LTL_UINT32_SWAP_(val)        ((uint32_t) (              \
    (((uint32_t) (val) & (uint32_t) 0x000000ffU) << 24) |       \
    (((uint32_t) (val) & (uint32_t) 0x0000ff00U) <<  8) |       \
    (((uint32_t) (val) & (uint32_t) 0x00ff0000U) >>  8) |       \
    (((uint32_t) (val) & (uint32_t) 0xff000000U) >> 24)))

#define LTL_UINT64_SWAP_(val)       ((uint64_t) (       \
      (((uint64_t) (val) &                              \
        (uint64_t) 0x00000000000000ffULL) << 56) |        \
      (((uint64_t) (val) &                              \
        (uint64_t) 0x000000000000ff00ULL) << 40) |        \
      (((uint64_t) (val) &                              \
        (uint64_t) 0x0000000000ff0000ULL) << 24) |        \
      (((uint64_t) (val) &                              \
        (uint64_t) 0x00000000ff000000ULL) <<  8) |        \
      (((uint64_t) (val) &                              \
        (uint64_t) 0x000000ff00000000ULL) >>  8) |        \
      (((uint64_t) (val) &                              \
        (uint64_t) 0x0000ff0000000000ULL) >> 24) |        \
      (((uint64_t) (val) &                              \
        (uint64_t) 0x00ff000000000000ULL) >> 40) |        \
      (((uint64_t) (val) &                              \
        (uint64_t) 0xff00000000000000ULL) >> 56)))

#  define LTL_TO_BIGENDIAN_16(val)   LTL_UINT16_SWAP_(val)
#  define LTL_TO_BIGENDIAN_32(val)   LTL_UINT32_SWAP_(val)
#  define LTL_TO_BIGENDIAN_64(val)   LTL_UINT64_SWAP_(val)
#  define LTL_FROM_BIGENDIAN_16(val) LTL_UINT16_SWAP_(val)
#  define LTL_FROM_BIGENDIAN_32(val) LTL_UINT32_SWAP_(val)
#  define LTL_FROM_BIGENDIAN_64(val) LTL_UINT64_SWAP_(val)

#endif  // WORDS_BIGENDIAN

#endif // __LTL_BYTESWAP__
