/* -*- C++ -*-
*
* ---------------------------------------------------------------------
* $Id: testfvec.cpp,v 1.2.2.1 2005/10/07 19:55:46 drory Exp $
* ---------------------------------------------------------------------
*
* Copyright (C) 2000-2002 Niv Drory <drory@usm.uni-muenchen.de>
*                         Claus A. Goessl <cag@usm.uni-muenchen.de>
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
*
* ---------------------------------------------------------------------
*
*/

#define LTL_RANGE_CHECKING

//#define LTL_TEMPLATE_LOOP_LIMIT 0

#include <ltl/fvector.h>

#include <iostream>
#include <algorithm>

using namespace ltl;

using std::cout;
using std::endl;


int main(int argc, char **argv)
{
   cerr << "Testing FVector (template unrolled loops) ..." << endl;
   
   FVector<float,3> A;
   A = 1,2,3;
   LTL_ASSERT_( (A(1) == A[0] && A(1) == 1. && A(2) == 2. && A(3) == 3.),
                "FVector basic indexing failed" );

   FVector<float,3> B = A;
   LTL_ASSERT_( (B(1) == 1. && B(2) == 2. && B(3) == 3.),
                "FVector init assignment failed" );
   B = 1.;   
   LTL_ASSERT_( (B(1) == 1. && B(2) == 1. && B(3) == 1.),
                "FVector assignment failed" );
   B = 0;
   B = A;
   LTL_ASSERT_( (B(1) == 1. && B(2) == 2. && B(3) == 3.),
                "FVector assignment failed" );
   B -= A;
   LTL_ASSERT_( (B(1) == 0. && B(2) == 0. && B(3) == 0.),
                "FVector assignment failed" );
   B += 1;
   LTL_ASSERT_( (B(1) == 1. && B(2) == 1. && B(3) == 1.),
                "FVector assignment failed" );
   
   FVector<float,3> C = 0.;
   C = A + B + log10(B);
   
   FVector<float,3> D;
   D = 2,3,4;
   LTL_ASSERT_( (C(1) == D(1) && C(2) == D(2) && C(3) == D(3) ),
                "FVector expression failed" );
   LTL_ASSERT_( allof( C == D ),
                "FVector allof() failed" );
   LTL_ASSERT_( noneof( C != D ),
                "FVector noneof() failed" );   
   LTL_ASSERT_( !anyof( C != D ),
                "FVector anyof() failed" );

   D = D + (D - 1) + 1 - D;
   LTL_ASSERT_( (C(1) == D(1) && C(2) == D(2) && C(3) == D(3) ),
                "FVector expression failed" );
   

   C *= C;
   
   LTL_ASSERT_( allof( C == pow2(D) ),
                "FVector allof(expr) failed" );
   
   
   float d = dot(D,D);
   float dd = D(1)*D(1) + D(2)*D(2) + D(3)*D(3);
   LTL_ASSERT_( (d==dd),
                "FVector dot() failed" );

   A = 1,2,3;
   std::copy( A.begin(), A.end(), D.begin() );
   LTL_ASSERT_( (A(1) == D(1) && A(2) == D(2) && A(3) == D(3) ),
                "FVector std::copy() failed" );
}

