/* -*- C++ -*-
*
* ---------------------------------------------------------------------
* $Id: testieee.cpp,v 1.3.2.1 2003/10/21 22:52:31 cag Exp $
* ---------------------------------------------------------------------
*
* Copyright (C) 2000-2002 Niv Drory <drory@usm.uni-muenchen.de>
*                         Claus A. Goessl <cag@usm.uni-muenchen.de>
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
*
* ---------------------------------------------------------------------
*
*/

#define LTL_RANGE_CHECKING

#include <ltl/marray.h>
#include <ltl/statistics.h>

#include <iostream>

using std::cerr;
using namespace ltl;

int main(int argc, char* argv[])
{

   cerr << "Testing presence of additional IEEE Math function(s) ...\n";
   
#ifdef HAVE_IEEE_MATH

   double s = 1.6;
   s = rint(s);

   MArray<double, 1> a(10);
   a = 1.6;
   a = rint(a);
   LTL_ASSERT_( allof(a == 2.0), "IEEE rint() failed" );

#else

   cerr << "Do not have IEEE Math functions.\n";

#endif

   return 0;
}
