/* -*- C++ -*-
*
* ---------------------------------------------------------------------
* $Id: testmarray.cpp,v 1.2.2.4 2004/06/30 22:53:32 drory Exp $
* ---------------------------------------------------------------------
*
* Copyright (C) 2000-2002 Niv Drory <drory@usm.uni-muenchen.de>
*                         Claus A. Goessl <cag@usm.uni-muenchen.de>
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
*
* ---------------------------------------------------------------------
*
*/

#define LTL_RANGE_CHECKING
//#define LTL_USE_SIMD

#include <ltl/marray.h>
#include <ltl/statistics.h>

#include <iostream>

using namespace ltl;

using std::cout;
using std::endl;


int main(int argc, char **argv)
{
   cerr << "Testing MArray basics ..." << endl;
   
   MArray<float,2> A(5,5);
   A = 42.f;
   
   LTL_ASSERT_( A(1,1)==42.f && A(3,3)==42.f,
                "MArray init failed" );

   A.setBase(-1,-1);
   LTL_ASSERT_( A(-1,-1)==42.f && A(1,1)==42.f,
                "MArray setBase() failed" );
   A *= 2.0f;
   A -= A/2.f;   
   LTL_ASSERT_( allof(A==42.f),
                "MArray basic expressions failed" );
   
   MArray<int, 2> I(5,5), I2(5,5);
   I = cast<int>()(A);
   I2 = 42;
   
   LTL_ASSERT_( allof(I == I2),
                "MArray type-cast failed" );

   A(-1,-1) = 0.f;
   LTL_ASSERT_( !allof(A) && anyof(A) && !noneof(A),
                "MArray logic expressions failed" );
   
   MArray<float,1> B = A(-1,Range::all());
   B = 1.f;
   LTL_ASSERT_( allof(B==1.f) && allof( A(-1,Range::all())==1.f ),
                "MArray slice 1 failed" );

   MArray<float,1> C = A(Range::all(),1);
   C = 2.f;
   LTL_ASSERT_( allof(C==2.f) && allof( A(Range::all(),1)==2.f ),
                "MArray slice 2 failed" );

   A = 10.0f;
   A = log10(A);
   LTL_ASSERT_( allof(A==1.0f),
                "MArray basic mathlib expressions failed" );

   A = 0.0f;
   A(0,0)  = 1.f;
   A(-1,0) = 3.f;
   MArray<float,2>::IndexSet l = where( A!=0.0f );
   LTL_ASSERT_( l.size() == 2, 
                "MArray where() failed" );
   
   A[l] = 5.0f;
   LTL_ASSERT_( A(0,0) == 5.0f && A(-1,0) == 5.0f, 
                "MArray where()/operator[] failed" );
   A[l] = 0.0f;
   LTL_ASSERT_( noneof(A),
                "MArray where()/operator[] failed" );
   

   A(-1,Range::all()) = 2.0f;
   A = merge( A, 1.0f/A, -1.0f );
   LTL_ASSERT_( allof( A(-1,Range::all()) == 0.5f ),
                "MArray merge() failed" );

   A(-1,Range::all()) = -1.0f;
   LTL_ASSERT_( allof( A == -1.0f ),
                "MArray merge() failed" );


   MArray<float,3> AA(10,10,10);
   AA = indexPos(AA,1) + 10*indexPos(AA,2) + 100*indexPos(AA,3);
   LTL_ASSERT_( AA(1,1,1)==111.0f && AA(6,9,2)==296.0f && AA(9,9,9)==999.0f ,
                "MArray indexPos() failed" );
   
   MArray<float,2> BB = AA(Range(2,7,2),5,Range(3,8,3));
   MArray<float,2> CC(3,2);
   CC = 352.f,354.f,356.f,
        652.f,654.f,656.f;
   LTL_ASSERT_( allof(BB==CC),
                "MArray subarray failed" );
   
   MArray<float,1> DD = BB(2,Range::all());
   MArray<float,1> EE(2);
   EE = 354.f,654.f;   
   LTL_ASSERT_( allof(DD==EE),
                "MArray complex slice failed" );
   
   DD = 555.f;
   LTL_ASSERT_( allof(DD==555.f),
                "MArray complex slice assign failed" );
   LTL_ASSERT_( AA(4,5,3)==555.f && AA(4,5,6)==555.f,
                "MArray complex slice assign failed" );

}

