//  MaCoPiX = Mascot Construnctive Pilot for X
//                                (ActX / Gtk+ Evolution)
//    A unified desktop mascot program
//    for UNIX / X Window System with Gdk Environment
//
//       balloon.c  : Drawing Balloon Message of mascots for   MaCoPiX
//                                         copyright K.Chimari 2002-4
//
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
// 
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
// 
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "main.h"
#include<string.h>
#include<ctype.h>


// *** GLOBAL ARGUMENT ***
extern GtkWidget *win_main, *balloon_main;
extern GtkWidget *popup_menu; 
extern gint window_x, window_y;
extern GdkDrawable *pixmap_bal[2];

extern gint dw_configure_bal();
extern void MoveBalloon();

extern gboolean flag_balloon;

GdkBitmap *mask_bal[2]={NULL,NULL};
static gint old_x=0, old_y=0;

// *** Protptype of function in this file
void DrawBalloon();
void DoBalloon();
GtkWidget * make_balloon();


void DrawBalloon(typMascot *mascot, char **wn_iwp, int wn_max)
{
  gint bal_width,bal_height;
  GdkGCValues gcv;
  gint w,h;
  gint lb,rb,as,ds=0;
  GdkPoint points[4];
  gint h_arrow=6;
  int tmp_h,tmp_w,tmp_ds;
  int i_wn;
  gint work_page;
#ifdef USE_GTK2
  PangoLayout *pango_text;
  PangoLanguage *pango_lang;
#endif

  work_page=mascot->bal_page;
  work_page^=1;

  // bal_height, bal_width  ƥȰԤ礭
  bal_height=0;
  bal_width=0;
  for(i_wn=0;i_wn<wn_max;i_wn++){
#ifdef USE_GTK2
    pango_text=gtk_widget_create_pango_layout(mascot->w_baldraw,
					      wn_iwp[i_wn]);
    pango_layout_get_pixel_size(pango_text,&tmp_w,&tmp_h);
#else
    gdk_string_extents(mascot->fontbal,wn_iwp[i_wn],
		       &lb,&rb,&tmp_w,&as,&tmp_ds);
    tmp_h=as+tmp_ds;
#endif
    
    if(tmp_w>bal_width){
      bal_width=tmp_w;
    }
     if(tmp_h>bal_height){
       bal_height=tmp_h;
#ifdef USE_GTK2
       ds=0;
#else
       ds=tmp_ds;
#endif
     }
  }
  
  // w, h Х롼Τ礭
  w=bal_width+(mascot->baltext_x+mascot->wbalbd)*2;
  h=(bal_height+mascot->baltext_y)*wn_max
    +mascot->baltext_y+mascot->wbalbd*2;
  mascot->balwidth=w;
  mascot->balheight=h+h_arrow;

  // Х롼ΰַ
  mascot->bal_pos=mascot->bal_defpos;
  if(mascot->bal_pos==BAL_POS_LEFT){
    if((mascot->x-w)<0) mascot->bal_pos=BAL_POS_RIGHT;
  }
  else if(mascot->bal_pos==BAL_POS_RIGHT){
    if((mascot->x+mascot->width+w)>mascot->width_root)
      mascot->bal_pos=BAL_POS_LEFT;
  }

  //gtk_widget_unmap(balloon_main);
  //MoveBalloon(mascot,mascot->x,mascot->y);
    
    
  // Х롼Υꥵ
  gtk_drawing_area_size (GTK_DRAWING_AREA(mascot->w_baldraw), w,h+h_arrow);
  gdk_window_resize (balloon_main->window,w,h+h_arrow);



  
  if (pixmap_bal[work_page]) {
    gdk_pixmap_unref(pixmap_bal[work_page]);
  } 
  
  pixmap_bal[work_page] = gdk_pixmap_new(balloon_main->window,w,h+h_arrow,-1);
  
  if (mask_bal[work_page]) {
    gdk_pixmap_unref(mask_bal[work_page]);
  } 
  
  mask_bal[work_page] = gdk_pixmap_new(balloon_main->window,
			    w,h+h_arrow,1); // Depth =1 (Bitmap)
  
  if(mascot->gc_balmask[work_page]){
    gdk_gc_unref(mascot->gc_balmask[work_page]);
  }
  mascot->gc_balmask[work_page]=gdk_gc_new(mask_bal[work_page]);
  // äޥforegroundǥꥢ
  gdk_draw_rectangle(mask_bal[work_page],mascot->gc_balmask[work_page],
		     TRUE,
		     0,0,
		     w,h+h_arrow);
  // ޥforegroundʬäΤ, Ĥʬ
  // background褹
  gdk_gc_get_values(mascot->gc_balmask[work_page], &gcv);
  gdk_gc_set_foreground(mascot->gc_balmask[work_page], &gcv.background);
  gdk_gc_set_background(mascot->gc_balmask[work_page], &gcv.foreground);
    
    
  // **** pixmapؤBUFFERING
  // border
  gdk_draw_arc(pixmap_bal[work_page],mascot->gc_balbd[work_page],
	       TRUE,
	       0,0,
	       mascot->baltext_x*2,mascot->baltext_y*2,
	       5760,5760);
  gdk_draw_arc(pixmap_bal[work_page],mascot->gc_balbd[work_page],
	       TRUE,
	       w-mascot->baltext_x*2-1,0,
	       mascot->baltext_x*2,mascot->baltext_y*2,
	       0,5760);
  gdk_draw_arc(pixmap_bal[work_page],mascot->gc_balbd[work_page],
	       TRUE,
	       0,h-mascot->baltext_y*2-1,
	       mascot->baltext_x*2,mascot->baltext_y*2,
	       5760*2,5760);
  gdk_draw_arc(pixmap_bal[work_page],mascot->gc_balbd[work_page],
	       TRUE,
	       w-mascot->baltext_x*2-1,h-mascot->baltext_y*2-1,
	       mascot->baltext_x*2,mascot->baltext_y*2,
	       5760*3,5760);
  gdk_draw_rectangle(pixmap_bal[work_page],mascot->gc_balbd[work_page],
		     TRUE,
		     0,mascot->baltext_y,
		     w,h-mascot->baltext_y*2);
  gdk_draw_rectangle(pixmap_bal[work_page],mascot->gc_balbd[work_page],
		     TRUE,
		     mascot->baltext_x,0,
		     w-mascot->baltext_x*2,h);
  
  points[0].y=h+h_arrow;
  points[1].y=h-mascot->baltext_y;
  points[2].y=h-mascot->baltext_y;
  points[3].y=h+h_arrow;
  if(mascot->bal_pos==BAL_POS_RIGHT){
    points[0].x=0;
    points[1].x=10-mascot->wbalbd;
    points[2].x=16+mascot->wbalbd;
    points[3].x=0;
  }
  else if(mascot->bal_pos==BAL_POS_LEFT){
    points[0].x=w;
    points[1].x=w-10+mascot->wbalbd;
    points[2].x=w-16-mascot->wbalbd;
    points[3].x=w;
  }
  
  gdk_draw_polygon(pixmap_bal[work_page],mascot->gc_balbd[work_page],
		   TRUE,points,4);
  
  // Mask (BorderƱ)
  gdk_draw_arc(mask_bal[work_page],mascot->gc_balmask[work_page],
	       TRUE,
	       0,0,
	       mascot->baltext_x*2,mascot->baltext_y*2,
	       5760,5760);
  gdk_draw_arc(mask_bal[work_page],mascot->gc_balmask[work_page],
	       TRUE,
	       w-mascot->baltext_x*2-1,0,
	       mascot->baltext_x*2,mascot->baltext_y*2,
	       0,5760);
  gdk_draw_arc(mask_bal[work_page],mascot->gc_balmask[work_page],
	       TRUE,
	       0,h-mascot->baltext_y*2-1,
	       mascot->baltext_x*2,mascot->baltext_y*2,
	       5760*2,5760);
  gdk_draw_arc(mask_bal[work_page],mascot->gc_balmask[work_page],
	       TRUE,
	       w-mascot->baltext_x*2-1,h-mascot->baltext_y*2-1,
	       mascot->baltext_x*2,mascot->baltext_y*2,
	       5760*3,5760);
  gdk_draw_rectangle(mask_bal[work_page],mascot->gc_balmask[work_page],
		     TRUE,
		     0,mascot->baltext_y,
		     w,h-mascot->baltext_y*2);
  gdk_draw_rectangle(mask_bal[work_page],mascot->gc_balmask[work_page],
		     TRUE,
		     mascot->baltext_x,0,
		     w-mascot->baltext_x*2,h);
  gdk_draw_polygon(mask_bal[work_page],mascot->gc_balmask[work_page],
		   TRUE,points,4);
    
  // background
  gdk_draw_arc(pixmap_bal[work_page],mascot->gc_balbg[work_page],
	       TRUE,
	       mascot->wbalbd,mascot->wbalbd,
	       mascot->baltext_x*2,mascot->baltext_y*2,
	       5760,5760);
  gdk_draw_arc(pixmap_bal[work_page],mascot->gc_balbg[work_page],
	       TRUE,
	       w-mascot->baltext_x*2-mascot->wbalbd-1,
	       mascot->wbalbd,
	       mascot->baltext_x*2,mascot->baltext_y*2,
	       0,5760);
  gdk_draw_arc(pixmap_bal[work_page],mascot->gc_balbg[work_page],
	       TRUE,
	       mascot->wbalbd,
	       h-mascot->baltext_y*2-mascot->wbalbd-1,
	       mascot->baltext_x*2,mascot->baltext_y*2,
	       5760*2,5760);
  gdk_draw_arc(pixmap_bal[work_page],mascot->gc_balbg[work_page],
	       TRUE,
	       w-mascot->baltext_x*2-mascot->wbalbd-1,
	       h-mascot->baltext_y*2-mascot->wbalbd-1,
	       mascot->baltext_x*2,mascot->baltext_y*2,
	       5760*3,5760);
  gdk_draw_rectangle(pixmap_bal[work_page],mascot->gc_balbg[work_page],
		     TRUE,
		     mascot->wbalbd,
		     mascot->wbalbd+mascot->baltext_y,
		     w-mascot->wbalbd*2,
		     h-mascot->baltext_y*2-mascot->wbalbd*2);
  gdk_draw_rectangle(pixmap_bal[work_page],mascot->gc_balbg[work_page],
		     TRUE,
		     mascot->wbalbd+mascot->baltext_x,
		     mascot->wbalbd,
		     w-mascot->baltext_x*2-mascot->wbalbd*2,
		     h-mascot->wbalbd*2);
  
  points[0].y-=1;
  points[1].y-=mascot->wbalbd;
  points[2].y-=mascot->wbalbd;
  points[3].y-=1;
  if(mascot->bal_pos==BAL_POS_RIGHT){
    points[1].x+=mascot->wbalbd;
    points[2].x-=mascot->wbalbd;
  }
  else if(mascot->bal_pos==BAL_POS_LEFT){
    points[1].x-=mascot->wbalbd;
    points[2].x+=mascot->wbalbd;
  }
  gdk_draw_polygon(pixmap_bal[work_page],mascot->gc_balbg[work_page],
		   TRUE,points,4);
  
  // Balloon Text
  for(i_wn=0;i_wn<wn_max;i_wn++){
#ifdef USE_GTK2
    pango_text=gtk_widget_create_pango_layout(mascot->w_baldraw,
					      wn_iwp[i_wn]);
    
    gdk_draw_layout(pixmap_bal[work_page],
		    mascot->gc_bal[work_page],
    		    mascot->baltext_x+mascot->wbalbd,
    		    (mascot->baltext_y+bal_height)*(i_wn+1)
    		    +mascot->wbalbd-bal_height,
		    pango_text);
#else
    gdk_draw_string(pixmap_bal[work_page],mascot->fontbal,
    		    mascot->gc_bal[work_page],
    		    mascot->baltext_x+mascot->wbalbd,
    		    (mascot->baltext_y+bal_height)*(i_wn+1)
    		    +mascot->wbalbd-ds,
    		    wn_iwp[i_wn]);
#endif
  }
  mascot->bal_page=work_page;

  MoveBalloon(mascot,mascot->x,mascot->y);
  gtk_widget_map(balloon_main);
  while (g_main_iteration(FALSE));

  gdk_flush();

}


// Balloonpixmap bufferؤ
void DoBalloon(typMascot *mascot)
{
  static int i_wp, i_wn;
  static char *wn[64][64];
  static char *wp[64], w_tmp[1024];
  static gint wp_max, wn_max[64];
  static gint wp_no, wn_no;
  static int balseqp;
  static int balseqp_biff;
  static int balseqp_sock;
  static int balseqpend[64];
  int i_p;

  char w_tmp_m[1024];
  char w_tmp_m3[1024];
  char *w_tmp_m2;
  int mp;

  if(mascot->balseq==0){ // Х롼ɽʸβ 
    mascot->balseq=1;    //  %p:ڡ %n: %a:ղ
    wp_no=0;

    switch(mascot->bal_mode){
    case BALLOON_MAIL:
      strcpy(w_tmp,mascot->mail.word);
      /* mail count %m */
      while(NULL != (w_tmp_m2 = strstr(w_tmp, "%m"))){
	mp = strlen(w_tmp) - strlen(w_tmp_m2); 
	strncpy(w_tmp_m, w_tmp, mp);
	w_tmp_m[mp] = '\0';
	w_tmp_m2 +=  strlen("%m");
	sprintf(w_tmp_m3,"%s%d%s",
		w_tmp_m, mascot->mail.count, w_tmp_m2);
	strcpy(w_tmp, w_tmp_m3);
      }
      balseqp_biff=BALLOON_EXPIRE;
      break;
    case BALLOON_POPERROR:
      strcpy(w_tmp,_("POP3 access error"));
      balseqp_biff=BALLOON_EXPIRE;
      break;
    case BALLOON_SOCKMSG:
      strncpy(w_tmp,mascot->sockmsg,1023);
      balseqp_sock=SOCK_BALLOON_EXPIRE;
      break;     
    case BALLOON_DUET:
      strncpy(w_tmp,mascot->sockmsg,1023);
      break;
    default:
      strcpy(w_tmp,mascot->click_word[mascot->anime_ptn]);
    }

    wp[wp_no]=(char *)strtok(w_tmp,"%");

    for(;;){
      wp_no++;
      if((wp[wp_no]=(char *)strtok(NULL,"%"))==NULL){
	wp_max=wp_no;
	break;
      }
      
      if(wp[wp_no][0]=='p'){
	balseqpend[wp_no-1]=10;  // ǥե10޴ֳ֤Ȥ
	wp[wp_no]++;
      }
      else if(wp[wp_no][0]=='a'){
	balseqpend[wp_no-1]=10;  // ǥե10޴ֳ֤Ȥ
	wp[wp_no]++;
	wp[wp_no] = g_strconcat(wp[wp_no-1],"%n",wp[wp_no],NULL);
      }
      else if(wp[wp_no][0]=='c'){
	balseqpend[wp_no-1]=1;  // ǥե1޴ֳ֤Ȥ
	wp[wp_no]++;
	wp[wp_no] = g_strconcat(wp[wp_no-1],wp[wp_no],NULL);
      }
      else if(isdigit(wp[wp_no][0])){
	balseqpend[wp_no-1]=wp[wp_no][0]-0x30;
	i_p=0;
	for(;;){
	  i_p++;
	  if(isdigit(wp[wp_no][i_p])){
	    balseqpend[wp_no-1]=balseqpend[wp_no-1]*10+wp[wp_no][i_p]-0x30;
	  }
	  else if(wp[wp_no][i_p]=='p'){
	    wp[wp_no]+=i_p;
	    break;
	  }
	  else if(wp[wp_no][i_p]=='a'){
	    wp[wp_no]+=i_p+1;
	    wp[wp_no] = g_strconcat(wp[wp_no-1],"%n",wp[wp_no],NULL);
	    wp[wp_no]--;
	    break;
	  }
	  else if(wp[wp_no][i_p]=='c'){
	    wp[wp_no]+=i_p+1;
	    wp[wp_no] = g_strconcat(wp[wp_no-1],wp[wp_no],NULL);
	    wp[wp_no]--;
	    break;
	  }
	  else{
	    wp[wp_no-1] = g_strconcat(wp[wp_no-1],"%",wp[wp_no],NULL);
	    wp_no--;
	    wp[wp_no]--;
	    break;
	  }
	}
	wp[wp_no]++;
      }
      else{
	wp[wp_no-1] = g_strconcat(wp[wp_no-1],"%",wp[wp_no],NULL);
	wp_no--;
      }
      
    }

    // Խ %n򽦤
    for(i_wp=0;i_wp<wp_max;i_wp++){
      wn_no=0;
      wn[i_wp][wn_no]=(char *)strtok(wp[i_wp],"%");
      
      for(;;){
	wn_no++;
	if((wn[i_wp][wn_no]=(char *)strtok(NULL,"%"))==NULL){
	  wn_max[i_wp]=wn_no;
	  break;
	}
	
	if(wn[i_wp][wn_no][0]=='n'){
	    wn[i_wp][wn_no]++;
	  }
	  else{
	  wn[i_wp][wn_no-1] 
	    = g_strconcat(wn[i_wp][wn_no-1],"%",wn[i_wp][wn_no],NULL);
	  wn_no--;
	}
      }
    }
    // ʸڤʬDEBUG
    /*  for(i_wp=0;i_wp<wp_max;i_wp++){
      for(i_wn=0;i_wn<wn_max[i_wp];i_wn++){
      printf("  %d: %d   %s\n",i_wp, i_wn, wn[i_wp][i_wn]);
      
      }
      }*/
    

    i_wp=0;
    i_wn=0;
    balseqp=0;

      
  }

  //printf("%2d :  %d/%d  %5d   %5d\n",mascot->bal_mode, i_wp, 
  // wp_max, balseqp, balseqp_biff);


  // Х롼κ   
  // balseqp = -1: ̾ΥХ롼, -2: BiffѥХ롼
  if(balseqp==0){
    if(i_wp<wp_max-1){
      balseqp=balseqpend[i_wp];  // ڡֳ֥޿
    }

    DrawBalloon(mascot, wn[i_wp], wn_max[i_wp]);


    if(i_wp<wp_max-1){
      i_wp++;
    }
    else{ // Х롼
      if(mascot->bal_mode==BALLOON_SOCKMSG) {
        balseqp=-3;
      } else if((mascot->bal_mode==BALLOON_MAIL)
	 ||(mascot->bal_mode==BALLOON_POPERROR)){
	balseqp=-2;
      }
      else{
	balseqp=-1;
      }
    }
  }
  else{
    //ޥåȤưХ롼褹
    if((old_x!=mascot->x)||(old_y!=mascot->y)){
      DrawBalloon(mascot, wn[i_wp], wn_max[i_wp]);
    }

    // 󥿤򸺤餹
    if(balseqp>0){
      balseqp--;
    }
    else if(balseqp==-2){
      if(balseqp_biff==0){  // BiffѥХ롼Υ
	gtk_widget_unmap(balloon_main);
	flag_balloon=FALSE;
      }
      else{
	balseqp_biff--;
      }
    } else if(balseqp==-3){
      if(balseqp_sock==0){  // SocketѥХ롼Υ
	gtk_widget_unmap(balloon_main);
	flag_balloon=FALSE;
      }
      else{
	balseqp_sock--;
      }
    }
  }
  old_x=mascot->x;
  old_y=mascot->y;

}


GtkWidget * make_balloon(void){
  GtkWidget *balloon_vbox;
  GtkWidget *balloon_drawing_area;

  balloon_main = gtk_window_new(GTK_WINDOW_POPUP);
  gtk_widget_set_app_paintable(balloon_main, TRUE);
  gtk_widget_set_events(GTK_WIDGET (balloon_main), 
			GDK_FOCUS_CHANGE_MASK | 
			GDK_BUTTON_MOTION_MASK | 
			GDK_BUTTON_RELEASE_MASK | 
			GDK_BUTTON_PRESS_MASK | 
			GDK_EXPOSURE_MASK);
  gtk_widget_realize(balloon_main);
  gdk_window_set_decorations(balloon_main->window, 0);
  gdk_window_set_override_redirect(balloon_main->window,TRUE);

  balloon_vbox = gtk_hbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER (balloon_main), balloon_vbox);
  gtk_widget_show(balloon_vbox);

  balloon_drawing_area = gtk_drawing_area_new();
  gtk_drawing_area_size (GTK_DRAWING_AREA(balloon_drawing_area), 1, 1);
  gtk_box_pack_start(GTK_BOX(balloon_vbox), balloon_drawing_area,
		     TRUE, TRUE, 0);
  gtk_widget_show(balloon_drawing_area);



  return(balloon_drawing_area);
}
