//  MaCoPiX = Mascot Construnctive Pilot for X
//                                (ActX / Gtk+ Evolution)
//    A unified desktop mascot program
//    for UNIX / X Window System with Gdk Environment
//
//       callbacks.c  : Callback Functions for   MaCoPiX
//                                         copyright K.Chimari 2002-4
//
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
// 
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
// 
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "main.h"
#include <signal.h>
#include <sys/wait.h>
#include <gdk/gdkx.h>

#include "sockmsg.h"

#undef DEBUG

// *** GLOBAL ARGUMENT ***
extern GtkWidget *win_main,*balloon_main,*clock_main,*biff_pix;
extern GtkTooltips *tooltip;
extern GtkWidget *PopupMenu; 
extern GdkDrawable *pixmap_main[2], *pixmap_clk[2], *pixmap_bal[2];

extern GdkBitmap *mask_bal[2];

extern gchar *FullPathSoundFile();

extern gint DrawMascot0();
extern gint DrawMascot();
extern gint DrawMascotWithDigit();
extern void DoBalloon();

extern void AllRandomChangeMascotMenu();

extern void create_biff_dialog();

extern void copy_file();


// *** GLOBAL ARGUMENT in this code *** 
int pre_hour=-1, pre_min=-1, pre_sec=-1;
gint start_x=0, start_y=0, biff_start_x=0, biff_start_y=0, clk_start_x=0, clk_start_y=0;
gboolean flag_balloon=FALSE;
gboolean flag_anime=FALSE, flag_clock=FALSE;
int old_day=0;
int errflag=-1;
int xpop,ypop;
gint FWinX,FWinWidth;
gint window_x, window_y, biff_window_x, biff_window_y, clk_window_x, clk_window_y;


// Prototype of functions in this file
int weight_random();
int weight_click();

int ehandler ();

void MoveMascot();
void MoveBiffPix();
void MoveBalloon();
int MoveToFocus();

GdkGC *CreatePen();

void drag_begin();
void drag_end();
void clk_drag_begin();
void clk_drag_end();
void biff_drag_begin();
void biff_drag_end();

gint dw_configure_main();
gint dw_configure_biff_pix();
gint dw_configure_clk();
gint dw_configure_bal();
gint dw_expose_main();
gint dw_expose_biff_pix();
gint dw_expose_clk();
gint dw_expose_bal();
void window_motion();
void clk_window_motion();
void biff_window_motion();
void focus_in();
void focus_out();
gint time_update();
void clock_update();
void DrawPanelClock();
gchar * ini_week();

void ext_play();
void sound_play();
void ChildTerm();

// ŤߤĤѥ
int weight_random(typMascot *mascot)
{
  int ptn=0,sum=0,random_end;

  random_end=RANDOM(mascot->random_total)+1;

  do{
    ptn++;
    sum+=mascot->random_weight[ptn];
  }while(sum<random_end);

  return(ptn);
}

// ŤߤĤåѥ
int weight_click(typMascot *mascot)
{
  int ptn=0,sum=0,random_end;

  random_end=RANDOM(mascot->click_total)+1;

  do{
    ptn++;
    sum+=mascot->click_weight[ptn];
  }while(sum<random_end);

  return(ptn);
}


// XEvent ϢΥ顼ϥɥ顼  MoveToFocusǻȤ
int ehandler (Display *d, XErrorEvent *e)
{
    errflag = 1;
    return(0);
}


// ޥåȤΰư
void MoveMascot(typMascot *mascot, gint x, gint y)
{

  mascot->x=x;
  mascot->y=y;

  gdk_window_move(win_main->window, x, y);

  MoveBalloon(mascot, x, y);
  if(mascot->clkmode==CLOCK_PANEL){
    gdk_window_move(clock_main->window, 
		    x+mascot->clk_x*((gfloat)(mascot->magnify)/100), 
		    y+mascot->clk_y*((gfloat)(mascot->magnify)/100));
  }	 
  MoveBiffPix(mascot, x, y);
  
  gdk_window_raise(win_main->window);
  gdk_window_raise(clock_main->window);
  gdk_window_raise(balloon_main->window);
  gdk_window_raise(biff_pix->window);

  gdk_flush();

}

// Biffΰư
void MoveBiffPix(typMascot *mascot, gint x, gint y)
{
  if(mascot->mail.flag){
    if(mascot->mail.pix_pos==MAIL_PIX_LEFT){
      gdk_window_move(biff_pix->window, 
		      x+mascot->mail.pix_x-biff_pix->allocation.width/2, 
		      //x+mascot->mail.pix_x-mascot->mail.pix_width/2, 
		      y+mascot->mail.pix_y);
    }
    else{
      gdk_window_move(biff_pix->window, 
		      x+mascot->mail.pix_x
		      +mascot->width-biff_pix->allocation.width/2, 
		      // +mascot->width-mascot->mail.pix_width/2, 
		      y+mascot->mail.pix_y);
    }
  }

 gdk_flush();
}


// Х롼ΰư
void MoveBalloon(typMascot *mascot, gint x, gint y)
{
  gint bal_y;
  bal_y=y;

  if(bal_y<0) bal_y=0;

  if(mascot->bal_pos==BAL_POS_LEFT){
    gdk_window_move(balloon_main->window, 
		    x-mascot->balwidth, bal_y);
  }
  else{
    gdk_window_move(balloon_main->window, x+mascot->width, bal_y);
  }

 gdk_flush();
}

// եWindowɽư
int MoveToFocus(typMascot *mascot, gboolean force_fl)
{
  Window rootwin,parent,*children,child,wf;
  int sx,sy,x,y,i,x_root=0,y_root=0;
  unsigned int border,depth;
  unsigned int nchildren;
  unsigned int width,height,width_root,height_root;
  int rx,ry,wx,wy,mask_return,realXPos;
  gboolean eflag=FALSE, flag_homepos=FALSE;

  gint oxpop,oypop;

  XGetInputFocus(GDK_WINDOW_XDISPLAY(win_main->window),
		 &wf, &i);
  XGetGeometry(GDK_WINDOW_XDISPLAY(win_main->window),
	       GDK_ROOT_WINDOW(),
	       &rootwin,
	       &x_root,
	       &y_root,
	       &width_root,
	       &height_root,
	       &border,
	       &depth);

  parent = 0;
  sx = 0;
  sy = 0;

  if(wf!=GDK_WINDOW_XWINDOW(win_main->window) 
     && wf!=GDK_WINDOW_XWINDOW(balloon_main->window)
     && wf!=GDK_WINDOW_XWINDOW(clock_main->window)
     && wf!=GDK_WINDOW_XWINDOW(biff_pix->window)
     && (int)wf!=0){

    if(mascot->focus_autobar==TRUE){ // ȥСΥư 
      if(errflag ==0){
	XQueryTree(GDK_WINDOW_XDISPLAY(win_main->window),
		   wf,&rootwin,&parent,&children,&nchildren);
	if(errflag ==0)  XFree(children);
      }
      else{
	errflag = 0;
	return(0);
      }
      
      if(wf == rootwin){
	if(errflag ==0){
	  XQueryTree(GDK_WINDOW_XDISPLAY(win_main->window),
		     wf,&rootwin,&parent,&children,&nchildren);
	  if(errflag ==0)  XFree(children);
	}
	else{
	  errflag = 0;
	  return(0);
	}
	
	if(errflag ==0){
	  XGetGeometry(GDK_WINDOW_XDISPLAY(win_main->window),
		       wf,&rootwin,&x,&y,&width,&height,
		       &border,&depth);
	}
	else{
	  errflag = 0;
	  return(0);
	}
      }
      else{
	for(;;){
	  if(parent == rootwin)
	    break;
	  XGetGeometry(GDK_WINDOW_XDISPLAY(win_main->window),
		       parent,&rootwin,&x_root,&y_root,
		       &width,&height,&border,&depth);
	  if((width==width_root)&&(height==height_root)){
	    eflag=TRUE;
	    break; // For Enlightenment
	  }
	  
	  if(mascot->bar_offset!=0){
	    if(errflag ==0){
	      XQueryPointer(GDK_WINDOW_XDISPLAY(win_main->window),
			    wf, &rootwin, &child, &rx, &ry,
			    &wx, &wy, &mask_return);
	    }
	    else{
	      errflag = 0;
	      return(0);
	    }
	  }
	  
	  wf = parent;
	  if(errflag ==0){
	    XQueryTree(GDK_WINDOW_XDISPLAY(win_main->window),
		       wf,&rootwin,&parent,&children,&nchildren);
	    if(errflag ==0)  XFree(children);
	  }
	  else{
	    errflag = 0;
	    return(0);
	  }
	  

	}

	if(errflag ==0){
	  XGetGeometry(GDK_WINDOW_XDISPLAY(win_main->window),
		       wf,&rootwin,&x,&y,&width,&height,
		       &border,&depth);
	  // եWindow¸ߤʤ Offset"%"ΤȤ
	  //		if (mascot->flag_xp){
	  // if((x<0)&&(y<0)&&(depth==0)&&(border==0)){
	  //   x-=mascot->width; y-=mascot->height;
	  //}
	  //}
	}
	else{
	  errflag = 0;
	  return(0);
	}
      }

      sx=x;
      if(mascot->bar_offset==0){
	sy=y;
      }
      else if((x==rx-wx)&&(y==ry-wy)){
	sy=y;  // եåȷ¬ : ޥåȤϥС̵Win˾äƤ
      }
      else{    // եåȷ¬ : ޥåȤϥСͭWin˾äƤ
	sy=y-mascot->bar_offset;
      }
    }
    else{  // ȥСΥޥ˥奢⡼
      if(errflag ==0){
	XGetGeometry(GDK_WINDOW_XDISPLAY(win_main->window),
		     wf,&rootwin,&x,&y,&width,&height,&border,&depth);
      }
      else{
	errflag = 0;
	return(0);
      }
      if(errflag ==0){
	XQueryPointer(GDK_WINDOW_XDISPLAY(win_main->window),
		      wf, &rootwin, &child, &rx, &ry,
		      &wx, &wy, &mask_return);
      }
      else{
	errflag = 0;
	return(0);
	
      }
      sx=rx-wx;
      sy=ry-wy-mascot->bar_size;
    }

    // sx, sy ϸߤΥեWindowκ(ޥȥС)а
      
    errflag = 0;
    
    oxpop=xpop;
    oypop=ypop;
    
    if(mascot->ff_side==FF_SIDE_RIGHT){
      if(mascot->flag_xp){
	realXPos=((int)width-mascot->width)*(1-(mascot->offsetp*0.01))
	  -mascot->xoff;
      }
      else{
	realXPos=(int)width-mascot->width-mascot->xoff-mascot->offset;
      }
    }
    else{
      if(mascot->flag_xp){
	realXPos=((int)width-mascot->width)*(mascot->offsetp*0.01)
	  -mascot->xoff;
      }
      else{
	realXPos=-mascot->xoff+mascot->offset;
      }
    }    
    
    if(eflag){
      xpop=sx+realXPos+x_root;
      ypop=sy+mascot->yoff*((gfloat)(mascot->magnify)/100)+y_root-mascot->height;
    }
    else{
      xpop=sx+realXPos;
      ypop=sy+mascot->yoff*((gfloat)(mascot->magnify)/100)-mascot->height;
    }

    if(mascot->focus_autobar){
      if((sx==ROOTOFF_X-width)
	 &&(sy==ROOTOFF_Y-mascot->bar_offset)){  // եʤ 
	if(mascot->homepos!=HOMEPOS_NEVER){
	  flag_homepos=TRUE;
	}
      }
      else if(ypop<ROOTOFF_Y){ //̾˥ޥåȤϤߤǤ
	if(mascot->homepos==HOMEPOS_OUT){
	  flag_homepos=TRUE;
	}
      }
    }
    else{
      if((sx==ROOTOFF_X) &&(sy==ROOTOFF_Y)){  // եʤ 
	if(mascot->homepos!=HOMEPOS_NEVER){
	  flag_homepos=TRUE;
	}
      }
      else if(ypop<ROOTOFF_Y){ //̾˥ޥåȤϤߤǤ
	if(mascot->homepos==HOMEPOS_OUT){
	  flag_homepos=TRUE;
	}
      }
    }
    if(flag_homepos){
      if(mascot->ff_side==FF_SIDE_RIGHT){
	if(mascot->flag_xp){
	  xpop=((mascot->width_root-mascot->home_x)-mascot->width)
	    *(1-(mascot->offsetp*0.01)) -mascot->xoff;
	}
	else{
	  xpop=(mascot->width_root-mascot->home_x)
	    -mascot->width-mascot->xoff-mascot->offset;
	}
      }
      else{
	if(mascot->flag_xp){
	  xpop=((mascot->width_root-mascot->home_x)-mascot->width)
	    *(mascot->offsetp*0.01) -mascot->xoff;
	}
	else{
	  xpop=mascot->home_x-mascot->xoff+mascot->offset;
	}
      }
      ypop=(mascot->height_root-mascot->home_y)
	+mascot->yoff*((gfloat)(mascot->magnify)/100)-mascot->height;
    }

    
    if((oxpop!=xpop)||(oypop!=ypop)){
      MoveMascot(mascot, xpop, ypop);
      if(flag_homepos){
	FWinWidth=mascot->width_root-mascot->home_x;
	FWinX=0;
      }
      else{
	FWinWidth=width;
	FWinX=sx;
      }
    }
    else if(force_fl){
      MoveMascot(mascot, xpop, ypop);
      if(flag_homepos){
	FWinWidth=mascot->width_root-mascot->home_x;
	FWinX=0;
      }
      else{
	FWinWidth=width;
	FWinX=sx;
      }
    }
  }

  while (g_main_iteration(FALSE));
  gdk_flush();
  return(1);
  
}


// ĤGCκȥ顼allocation
GdkGC *CreatePen(GdkDrawable *pixmap, GdkColor *color)
{
  GdkGC *gc;

  gdk_colormap_alloc_color(gdk_colormap_get_system(),color,FALSE,TRUE);

  gc=gdk_gc_new(pixmap);
  
  gdk_gc_set_foreground(gc, color);

  return(gc);
}


// ޥܥ򤪤ȤΥ٥Callback
void drag_begin(GtkWidget * widget, GdkEventButton * event, gpointer gdata)
{
  typMascot *mascot;
  GdkModifierType modmask;

  mascot=(typMascot *)gdata; 

  if(mascot->flag_menu) return;
  
  if (event->button == 1) {
    mascot->drag = TRUE;
    gdk_window_set_cursor(win_main->window,mascot->cursor.push);
    window_x = event->x;
    window_y = event->y;
    gdk_window_get_pointer(NULL, &start_x, &start_y, &modmask);
    gdk_pointer_grab(win_main->window, 
		     FALSE, GDK_BUTTON_MOTION_MASK | GDK_BUTTON_RELEASE_MASK,
		     NULL, NULL, GDK_CURRENT_TIME);
    gdk_flush();
  }
  else if(event->button == 3){
    gtk_menu_popup (GTK_MENU(PopupMenu), NULL, NULL, NULL, NULL, 
		    event->button, event->time);
  }

}


// ޥܥϤʤȤΥ٥Callback
void drag_end(GtkWidget * widget, GdkEventButton * event, gpointer gdata)
{
  typMascot *mascot;
  GdkModifierType modmask;
  gint end_x,end_y;
  int i_frm;

  mascot=(typMascot *)gdata; 

  gdk_window_raise(win_main->window);
  gdk_window_raise(clock_main->window);
  gdk_window_raise(balloon_main->window);
  gdk_window_raise(biff_pix->window);
  
  if (mascot->drag){
    mascot->drag = FALSE;
    gdk_window_get_pointer(NULL, &end_x, &end_y, &modmask);
    if((end_x==start_x)&&(end_y==start_y)&&
       (mascot->click_total!=0)&&(flag_balloon==FALSE)){
      /////// å˥ ///////
      for(i_frm=0;i_frm<mascot->frame_num[mascot->anime_ptn];i_frm++){
	// ֥å롼פΥ󥻥
	mascot->frame_loop[mascot->anime_ptn][i_frm].seq=0;
      }
      mascot->anime_ptn=weight_click(mascot);
      mascot->anime_frm=-1;
      mascot->anime_seq=-1;
      mascot->anime_seqend=
	RANDOM(mascot->frame_max[mascot->anime_ptn][mascot->anime_frm]
	       -mascot->frame_min[mascot->anime_ptn][mascot->anime_frm]+1)
	+mascot->frame_min[mascot->anime_ptn][mascot->anime_frm];

      sound_play(mascot,mascot->click_sound[mascot->anime_ptn]);

      if(mascot->click_word[mascot->anime_ptn]) {
	mascot->balseq=0;
	mascot->bal_mode=BALLOON_NORMAL;
	DoBalloon(mascot); 
	flag_balloon=TRUE;
      }

      // Duet˥
      if(mascot->duet_use_click){
	mascot->duet_seq=mascot->duet_delay[mascot->anime_ptn];
	mascot->duet_mode=DUET_CLICK;
      }

      // flag_anime=TRUE;
    }
      

  }
  gdk_window_set_cursor(win_main->window,mascot->cursor.normal);
  gdk_pointer_ungrab(GDK_CURRENT_TIME);
  gdk_flush();
}


//   ޥܥ򤪤ȤΥ٥Callback
void clk_drag_begin(GtkWidget * widget, GdkEventButton * event, gpointer gdata)
{
  typMascot *mascot;
  GdkModifierType modmask;

  mascot=(typMascot *)gdata; 

  if(mascot->flag_menu) return;
  
  if (event->button == 1) {
    mascot->clk_drag = TRUE;
    clk_window_x = event->x;
    clk_window_y = event->y;
    gdk_window_get_pointer(NULL, &clk_start_x, &clk_start_y, &modmask);
    gdk_pointer_grab(clock_main->window, 
		     FALSE, GDK_BUTTON_MOTION_MASK | GDK_BUTTON_RELEASE_MASK,
		     NULL, NULL, GDK_CURRENT_TIME);
    gdk_flush();
  }
}


//  ޥܥϤʤȤΥ٥Callback
void clk_drag_end(GtkWidget * widget, GdkEventButton * event, gpointer gdata)
{
  typMascot *mascot;
  GdkModifierType modmask;
  gint end_x,end_y;
  int i_frm;


  mascot=(typMascot *)gdata; 

  gdk_window_raise(win_main->window);
  gdk_window_raise(clock_main->window);
  gdk_window_raise(balloon_main->window);
  gdk_window_raise(biff_pix->window);
  
  if (mascot->clk_drag){
    mascot->clk_drag = FALSE;
    gdk_window_get_pointer(NULL, &end_x, &end_y, &modmask);
  }
  
  gdk_window_set_cursor(clock_main->window,mascot->cursor.clk);
  gdk_pointer_ungrab(GDK_CURRENT_TIME);
  gdk_flush();
}


// Biff ޥܥ򤪤ȤΥ٥Callback
void biff_drag_begin(GtkWidget * widget, GdkEventButton * event, gpointer gdata)
{
  typMascot *mascot;
  GdkModifierType modmask;

  mascot=(typMascot *)gdata; 

  if(mascot->flag_menu) return;
  
  if (event->button == 1) {
    mascot->mail.drag = TRUE;
    biff_window_x = event->x;
    biff_window_y = event->y;
    gdk_window_get_pointer(NULL, &biff_start_x, &biff_start_y, &modmask);
    gdk_pointer_grab(biff_pix->window, 
		     FALSE, GDK_BUTTON_MOTION_MASK | GDK_BUTTON_RELEASE_MASK,
		     NULL, NULL, GDK_CURRENT_TIME);
    gdk_flush();
  }
}


// Biff ޥܥϤʤȤΥ٥Callback
void biff_drag_end(GtkWidget * widget, GdkEventButton * event, gpointer gdata)
{
  typMascot *mascot;
  GdkModifierType modmask;
  gint end_x,end_y;
  int i_frm;


  mascot=(typMascot *)gdata; 

  gdk_window_raise(win_main->window);
  gdk_window_raise(clock_main->window);
  gdk_window_raise(balloon_main->window);
  gdk_window_raise(biff_pix->window);
  
  if (mascot->mail.drag){
    mascot->mail.drag = FALSE;
    gdk_window_get_pointer(NULL, &end_x, &end_y, &modmask);
    if((end_x==biff_start_x)&&(end_y==biff_start_y)){
      // From Subject Win ư
      create_biff_dialog(mascot);
    }
    else{
      //mascot->mail.pix_x=end_x-mascot->x;
      //mascot->mail.pix_y=end_y-mascot->y;
    }
  }
  
  gdk_window_set_cursor(biff_pix->window,mascot->cursor.biff);
  gdk_pointer_ungrab(GDK_CURRENT_TIME);
  gdk_flush();
}



// Mascot WindowѷˤȤʤCallback
gint dw_configure_main(GtkWidget *widget, GdkEventConfigure *event,
		       gpointer gdata)
{
  typMascot *mascot;
  mascot=(typMascot *)gdata; 

#ifdef DEBUG
  printf("Configure: \n");
#endif

  if (pixmap_main[0]) {
    gdk_pixmap_unref(pixmap_main[0]);
  } 
  if (pixmap_main[1]) {
    gdk_pixmap_unref(pixmap_main[1]);
  } 
  
  pixmap_main[0] = gdk_pixmap_new(widget->window,
			       widget->allocation.width,
			       widget->allocation.height,
			       -1);
  pixmap_main[1] = gdk_pixmap_new(widget->window,
			       widget->allocation.width,
			       widget->allocation.height,
			       -1);
  if(mascot->gc_main[0]==NULL){
    mascot->gc_main[0] = CreatePen(pixmap_main[0], mascot->colclk);
    mascot->gc_mainsd[0] = CreatePen(pixmap_main[0], mascot->colclksd);
    if(mascot->gc_main[1]==NULL){
      mascot->gc_main[1] = CreatePen(pixmap_main[1], mascot->colclk);
      mascot->gc_mainsd[1] = CreatePen(pixmap_main[1], mascot->colclksd);
    }
    if(errflag==-1){
      XSetErrorHandler (ehandler);
    }
  }
  DrawMascot0(mascot);
  return TRUE;
}


// Biff Pixmap  WindowѷˤȤʤCallback
gint dw_configure_biff_pix(GtkWidget *widget, GdkEventConfigure *event,
			   gpointer gdata)
{
  typMascot *mascot;
  mascot=(typMascot *)gdata; 

  gdk_draw_pixmap(widget->window,
		  widget->style->fg_gc[GTK_WIDGET_STATE(widget)],
		  mascot->mail.pixmap,
		  0,0,0,0,
		  widget->allocation.width,
		  widget->allocation.height);
  return TRUE;
}


// Clock PanelѷˤȤʤCallback
gint dw_configure_clk(GtkWidget *widget, GdkEventConfigure *event,
		      gpointer gdata)
{
  typMascot *mascot;
  mascot=(typMascot *)gdata; 

  if(pixmap_clk[0]==NULL){
    pixmap_clk[0] = gdk_pixmap_new(widget->window,
				widget->allocation.width,
				widget->allocation.height,
				-1);
  }

  if(pixmap_clk[1]==NULL){
    pixmap_clk[1] = gdk_pixmap_new(widget->window,
				widget->allocation.width,
				widget->allocation.height,
				-1);
  }

  if(mascot->gc_clk[0]==NULL){
    mascot->gc_clk[0] = CreatePen(pixmap_clk[0], mascot->colclk);
    mascot->gc_clksd[0] = CreatePen(pixmap_clk[0], mascot->colclksd);
    mascot->gc_clkbg[0] = CreatePen(pixmap_clk[0], mascot->colclkbg);
    mascot->gc_clkbd[0] = CreatePen(pixmap_clk[0], mascot->colclkbd);
  }
  if(mascot->gc_clk[1]==NULL){
    mascot->gc_clk[1] = CreatePen(pixmap_clk[1], mascot->colclk);
    mascot->gc_clksd[1] = CreatePen(pixmap_clk[1], mascot->colclksd);
    mascot->gc_clkbg[1] = CreatePen(pixmap_clk[1], mascot->colclkbg);
    mascot->gc_clkbd[1] = CreatePen(pixmap_clk[1], mascot->colclkbd);
  }


  if(mascot->clkmode==CLOCK_PANEL){
    // **** Mascot windowؤ
    // **** windowؤ
    gdk_window_set_back_pixmap(mascot->w_clkdraw->window,
			       pixmap_clk[mascot->clk_page],
			       FALSE);
    //gdk_draw_pixmap(mascot->w_clkdraw->window,
    //		    mascot->w_clkdraw->style->fg_gc[GTK_WIDGET_STATE (mascot->w_clkdraw)],
    //		    pixmap_clk[mascot->clk_page],
    //		    0,0,0,0,
    //		    widget->allocation.width,
    //		    widget->allocation.height);

  }
  return TRUE;
}


// Balloon WindowѷˤȤʤCallback
gint dw_configure_bal(GtkWidget *widget, GdkEventConfigure *event,
		      gpointer gdata)
{
  typMascot *mascot;
  mascot=(typMascot *)gdata; 


  if(pixmap_bal[0]==NULL){
    pixmap_bal[0] = gdk_pixmap_new(widget->window,
				widget->allocation.width,
				widget->allocation.height,
				-1);
  }

  if(pixmap_bal[1]==NULL){
    pixmap_bal[1] = gdk_pixmap_new(widget->window,
				widget->allocation.width,
				widget->allocation.height,
				-1);
  }

  if(mascot->gc_bal[0]==NULL){
    mascot->gc_bal[0] = CreatePen(pixmap_bal[0], mascot->colbal);
    mascot->gc_balbg[0] = CreatePen(pixmap_bal[0], mascot->colbalbg);
    mascot->gc_balbd[0] = CreatePen(pixmap_bal[0], mascot->colbalbd);
  }
  if(mascot->gc_bal[1]==NULL){
    mascot->gc_bal[1] = CreatePen(pixmap_bal[1], mascot->colbal);
    mascot->gc_balbg[1] = CreatePen(pixmap_bal[1], mascot->colbalbg);
    mascot->gc_balbd[1] = CreatePen(pixmap_bal[1], mascot->colbalbd);
  }
  return TRUE;
}


// Main (Mascot) Ťʤν
// WorkƤʤBufferPixmapԤ
gint dw_expose_main(GtkWidget *widget, GdkEventExpose *event,  gpointer gdata)
{
  typMascot *mascot;
#ifdef DEBUG
  printf("Expose in\n");
#endif

  mascot=(typMascot *)gdata; 
  
  // **** Mascot windowؤ
  gdk_draw_pixmap(widget->window,
		  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		  pixmap_main[mascot->pixmap_page],
		  event->area.x, event->area.y,
		  event->area.x, event->area.y,
		  event->area.width, event->area.height);

#ifdef DEBUG
  printf("Expose: using %d\n",mascot->pixmap_page);
#endif
  return FALSE;
}


// Biff Pixmap Ťʤν
gint dw_expose_biff_pix(GtkWidget *widget, GdkEventExpose *event,  gpointer gdata)
{
  typMascot *mascot;

  mascot=(typMascot *)gdata; 

  if(mascot->mail.flag){
    gdk_draw_pixmap(widget->window,
		    widget->style->fg_gc[GTK_WIDGET_STATE(widget)],
		    mascot->mail.pixmap,
		    0,0,0,0,
		    widget->allocation.width,
		    widget->allocation.height);
  }

  return FALSE;
}


// Clock Panel Ťʤν
// WorkƤʤBufferPixmapԤ
gint dw_expose_clk(GtkWidget *widget, GdkEventExpose *event,  gpointer gdata)
{
  typMascot *mascot;

  mascot=(typMascot *)gdata; 

  if(mascot->clkmode==CLOCK_PANEL){
    // **** Mascot windowؤ
    // **** windowؤ
    gdk_draw_pixmap(mascot->w_clkdraw->window,
		    mascot->w_clkdraw->style->fg_gc[GTK_WIDGET_STATE (mascot->w_clkdraw)],
		    pixmap_clk[mascot->clk_page],
		    0,0,0,0,
		    widget->allocation.width,
		    widget->allocation.height);

  }

  return FALSE;
}


// Balloon Ťʤν
// WorkƤʤBufferPixmapԤ
gint dw_expose_bal(GtkWidget *widget, GdkEventExpose *event,  gpointer gdata)
{
  typMascot *mascot;
  mascot=(typMascot *)gdata; 

  // **** Balloon windowؤ
  gdk_window_set_back_pixmap(widget->window,
			     pixmap_bal[mascot->bal_page],
			     FALSE);

  gdk_draw_pixmap(widget->window,
		  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		  pixmap_bal[mascot->bal_page],
		  0,0,0,0,
		  widget->allocation.width,
		  widget->allocation.height);
  gtk_widget_shape_combine_mask( balloon_main,
				 mask_bal[mascot->bal_page],
				 0,0);


  return FALSE;
}


// ɥåˤư
void window_motion(GtkWidget * widget, GdkEventMotion * event, gpointer gdata)
{   
  typMascot *mascot;
  mascot=(typMascot *)gdata; 

  if (mascot->drag){
    gint mx, my, newx, newy;
    GdkModifierType modmask;
    
    gdk_window_get_pointer(NULL, &mx, &my, &modmask);
    if(mascot->move==MOVE_FIX){
      gdk_window_set_cursor(win_main->window,mascot->cursor.drag_f);
      newx = mx - window_x;
      newy = my - window_y;
      MoveMascot(mascot, newx, newy);
    }
    else if(mascot->move==MOVE_FOCUS){
      gdk_window_set_cursor(win_main->window,mascot->cursor.drag_h);
      newx = mx - window_x;
      if(mascot->ff_side==FF_SIDE_RIGHT){
	if(mascot->flag_xp){
	  mascot->offsetp=100-
	    (int)((double)(newx-FWinX)/(double)(FWinWidth-mascot->width)*100);
	  if(mascot->offsetp>100) mascot->offsetp=100;
	  if(mascot->offsetp<0) mascot->offsetp=0;
	}
	else{
	  mascot->offset=-newx+FWinWidth+FWinX-mascot->width-mascot->xoff;
	}
      }
      else{
	if(mascot->flag_xp){
	    mascot->offsetp=(int)((double)(newx-FWinX)/
				  (double)(FWinWidth-mascot->width)*100);
	  if(mascot->offsetp>100) mascot->offsetp=100;
	  if(mascot->offsetp<0) mascot->offsetp=0;
	}
	else{
	  mascot->offset=newx-FWinX-mascot->xoff;
	}
      }
      MoveToFocus(mascot,FALSE);
    }
  }
}   


//  ɥåˤư
void clk_window_motion(GtkWidget * widget, GdkEventMotion * event, gpointer gdata)
{   
  typMascot *mascot;
  mascot=(typMascot *)gdata; 

  if (mascot->clk_drag){
    gint mx, my, newx, newy;
    GdkModifierType modmask;
    
    gdk_window_set_cursor(clock_main->window,mascot->cursor.drag_f);
    gdk_window_get_pointer(NULL, &mx, &my, &modmask);
    newx = mx - clk_window_x;
    newy = my - clk_window_y;

    mascot->clk_x = (newx - mascot->x)*100/mascot->magnify;
    mascot->clk_y = (newy - mascot->y)*100/mascot->magnify;
    MoveMascot(mascot, mascot->x, mascot->y);
  }
}   


// Biff ɥåˤư
void biff_window_motion(GtkWidget * widget, GdkEventMotion * event, gpointer gdata)
{   
  typMascot *mascot;
  mascot=(typMascot *)gdata; 

  if (mascot->mail.drag){
    gint mx, my, newx, newy;
    GdkModifierType modmask;
    
    gdk_window_set_cursor(biff_pix->window,mascot->cursor.drag_f);
    gdk_window_get_pointer(NULL, &mx, &my, &modmask);
    newx = mx - biff_window_x;
    newy = my - biff_window_y;
    if(mascot->mail.pix_pos==MAIL_PIX_LEFT){
      mascot->mail.pix_x = newx - mascot->x + biff_pix->allocation.width/2;
    }
    else{
      mascot->mail.pix_x = newx - mascot->x - mascot->width 
	+ biff_pix->allocation.width/2;
    }
      mascot->mail.pix_y = newy - mascot->y;
    MoveBiffPix(mascot, mascot->x, mascot->y);
  }
}   


void focus_in(GtkWidget * widget, GdkEventMotion * event)
{
  gdk_flush();
}

void focus_out(GtkWidget * widget, GdkEventMotion * event)
{
  gdk_pointer_ungrab(GDK_CURRENT_TIME);
  gdk_flush();
}


// ˥᡼󤪤ӻupdateѴؿ
// timeoutʥŪ˸ƤӽФ
gint time_update(gpointer gdata)
{
  typMascot *mascot;
#ifdef DEBUG
  static int pre_pix;
  gint work_page;
#endif
  SockMsgInitResult sockres;
  gchar *msg=NULL;

  flag_anime=FALSE;
  flag_clock=FALSE;
  mascot=(typMascot *)gdata; 

  if(mascot->flag_menu) return;

  if(mascot->move==MOVE_FOCUS){
    MoveToFocus(mascot, FALSE);
  }
  if(mascot->move==MOVE_FIX){
    mascot->xfix=mascot->x;
    mascot->yfix=mascot->y;
  }


  if(flag_balloon==TRUE){
    DoBalloon(mascot);
  }

  // Duet˥
  if(mascot->duet_seq>0){
    mascot->duet_seq--;
  }
  else if(mascot->duet_seq==0){
    mascot->duet_seq--;
    if (mascot->duet_tgt[mascot->anime_ptn]){
      if((0<mascot->duet_ptn[mascot->anime_ptn])&&
	 (mascot->duet_ptn[mascot->anime_ptn]<MAX_ANIME_PATTERN)){
	if((mascot->duet_mode==DUET_CLICK)
	   &&(mascot->duet_word[mascot->anime_ptn])){
	  msg = g_strdup_printf("%02d%02d%s",
				mascot->duet_mode,
				mascot->duet_ptn[mascot->anime_ptn],
				mascot->duet_word[mascot->anime_ptn]);
	}
	else{
	  msg = g_strdup_printf("%02d%02d",mascot->duet_mode,
				mascot->duet_ptn[mascot->anime_ptn]);
	}
	
	// Duet Anime Client ư
	sockres = duet_cl_init(mascot->duet_tgt[mascot->anime_ptn]);
	switch (sockres) {
	case SOCKMSG_ERROR:
	  break;
	case SOCKMSG_OPENED:
	  duet_send_msg(msg);
	  duet_cl_done(mascot->duet_tgt[mascot->anime_ptn],FALSE);
	  break;
	}
	g_free(msg);
      }
    }
  }


  // ˥
  mascot->anime_seq++;
  if((mascot->anime_seqend-mascot->anime_seq)<=0){
    //ե졼νλ
    mascot->anime_seq=0;
    // ֥å롼
    if((mascot->frame_loop[mascot->anime_ptn][mascot->anime_frm].next>=0)){
      mascot->frame_loop[mascot->anime_ptn][mascot->anime_frm].seq++;
      if(mascot->frame_loop[mascot->anime_ptn][mascot->anime_frm].seq==1){
	// ֥å롼׳
	mascot->frame_loop[mascot->anime_ptn][mascot->anime_frm].seqend=
	  RANDOM(mascot->frame_loop[mascot->anime_ptn][mascot->anime_frm].max
		 -mascot->frame_loop[mascot->anime_ptn][mascot->anime_frm].min+1)
	  +mascot->frame_loop[mascot->anime_ptn][mascot->anime_frm].min;
	       
	if(mascot->frame_loop[mascot->anime_ptn][mascot->anime_frm].seqend==1){
	  mascot->frame_loop[mascot->anime_ptn][mascot->anime_frm].seq=0;
	  mascot->anime_frm++;
	}
	else{
	  mascot->anime_frm=
	    mascot->frame_loop[mascot->anime_ptn][mascot->anime_frm].next;
	}
      }
      else if(mascot->frame_loop[mascot->anime_ptn][mascot->anime_frm].seqend-
	      mascot->frame_loop[mascot->anime_ptn][mascot->anime_frm].seq<=0){
	// ֥å롼׽λ
	mascot->frame_loop[mascot->anime_ptn][mascot->anime_frm].seq=0;
	mascot->anime_frm++;
      }
      else{
	// ֥å롼׷³
	mascot->anime_frm=
	  mascot->frame_loop[mascot->anime_ptn][mascot->anime_frm].next;
      }
    }
    else{
      mascot->anime_frm++;
    }
    if(mascot->anime_frm>=mascot->frame_num[mascot->anime_ptn]){
      //ѥνλ
      if(mascot->anime_ptn==0){
	if(mascot->random_total==0){
	  // ॢ˥᤬ʤ ١Ƭ
	  mascot->anime_frm=0;
	}
	else{
	  // ١νλ -> ѥؤΰܹ
	  mascot->anime_ptn=weight_random(mascot);
	  mascot->anime_frm=0;
	  if(mascot->duet_use_random){
	    if(mascot->duet_tgt[mascot->anime_ptn]){
	      // Duet˥
	      mascot->duet_seq=mascot->duet_delay[mascot->anime_ptn];
	      mascot->duet_mode=DUET_RANDOM;
	    }
	  }
	}
      }
      else{
	// ֤
	mascot->anime_ptn=0;
	mascot->anime_frm=0;
	if((flag_balloon)&&
	   ((mascot->bal_mode==BALLOON_NORMAL)
	    ||(mascot->bal_mode==BALLOON_DUET))){
	  // Х롼󤬤ǤƤĤ
	  // å˥νλ
	    gtk_widget_unmap(balloon_main);
	    flag_balloon=FALSE;
	}
      }
    }
    else{
      //Υե졼ذܹ
    }
    mascot->anime_seqend=
      RANDOM(mascot->frame_max[mascot->anime_ptn][mascot->anime_frm]
	     -mascot->frame_min[mascot->anime_ptn][mascot->anime_frm]+1)
      +mascot->frame_min[mascot->anime_ptn][mascot->anime_frm];
    flag_anime=TRUE;
  }
  // ե졼बѤäshapeѷ
  //  if(pre_pix!=mascot->frame_pix[mascot->anime_ptn][mascot->anime_frm]){
  //   gtk_widget_shape_combine_mask( win_main, 
  //				  mascot->sprites[mascot->frame_pix[mascot->anime_ptn][mascot->anime_frm]].mask,
  //				   0, 0 ); 
  //pre_pix=mascot->frame_pix[mascot->anime_ptn][mascot->anime_frm];
    
  //}

  clock_update(mascot,FALSE);


  // ˥᡼ˤޥåȤ
  // ޥåȾλפ񤭴ȤϤʤ
  if((flag_clock==FALSE)&&(flag_anime==TRUE)){ 
#ifdef DEBUG 
    work_page=mascot->pixmap_page;
    work_page^=1;
    printf("Drawto %d\n",work_page);
#endif
  
    if(mascot->clkmode==CLOCK_PIXMAP){ 
      //פѤʤ˥᤬Ѥä
      DrawMascotWithDigit(mascot);
    }
    else{
      DrawMascot(mascot);
    }

#ifdef DEBUG
    printf("Draw finish %d\n",work_page);
#endif
  }
    
  gdk_flush();

}


// פΥåץǡ
void clock_update(typMascot *mascot, gboolean force_flag){
  time_t t;
  struct tm *tmpt;
  static char caldigit[20];
  gchar *weekk;

  t = time(NULL);
  tmpt = localtime(&t);
  
  if(tmpt->tm_mday!=old_day){
    weekk=g_strdup(ini_week(tmpt->tm_wday));
    sprintf(caldigit,_("%d/%d/%d(%s)"),
	    tmpt->tm_year+1900,tmpt->tm_mon+1,tmpt->tm_mday,weekk);

    gtk_tooltips_set_tip(tooltip,clock_main,caldigit,NULL);
    old_day=tmpt->tm_mday;
  }

  // 
  if(pre_hour!=-1){
    if(pre_hour!=tmpt->tm_hour){
      pre_hour=tmpt->tm_hour;
      if((mascot->signal.flag)&&(!mascot->drag)){
	// ޥ
	if(mascot->signal.com){
	  ext_play(mascot,mascot->signal.com);
	}

	// ޥåȤư
	switch(mascot->signal.type){
	case SIGACT_CLICK:
	  if((mascot->click_total!=0)&&(flag_balloon==FALSE)){
	    gint i_frm;

	    // å˥
	    for(i_frm=0;i_frm<mascot->frame_num[mascot->anime_ptn];i_frm++){
	      // ֥å롼פΥ󥻥
	      mascot->frame_loop[mascot->anime_ptn][i_frm].seq=0;
	    }
	    mascot->anime_ptn=weight_click(mascot);
	    mascot->anime_frm=-1;
	    mascot->anime_seq=-1;
	    mascot->anime_seqend=
	      RANDOM(mascot->frame_max[mascot->anime_ptn][mascot->anime_frm]
		     -mascot->frame_min[mascot->anime_ptn][mascot->anime_frm]+1)
	      +mascot->frame_min[mascot->anime_ptn][mascot->anime_frm];

	    sound_play(mascot,mascot->click_sound[mascot->anime_ptn]);

	    if(mascot->click_word[mascot->anime_ptn]) {
	      mascot->balseq=0;
	      mascot->bal_mode=BALLOON_NORMAL;
	      DoBalloon(mascot); 
	      flag_balloon=TRUE;
	    }
	  }
      	  gdk_pointer_ungrab(GDK_CURRENT_TIME);
	  gdk_flush();
	  break;
	case SIGACT_CHANGE:
	  if(mascot->menu_file){
	    AllRandomChangeMascotMenu(NULL);
	  }
	  break;
	}
      }
    }
  }
  else{
    // ư
    pre_hour=tmpt->tm_hour;
  }

  if(mascot->drag==FALSE){
    gboolean draw_flag=FALSE;

    switch(mascot->clktype){
    case CLOCK_TYPE_24S:
      if((tmpt->tm_sec!=pre_sec)||(force_flag)){
	sprintf(mascot->digit,"%2d:%02d:%02d",
		tmpt->tm_hour,tmpt->tm_min,tmpt->tm_sec);
	draw_flag=TRUE;
      }
      break;

    case CLOCK_TYPE_12S:
      if((tmpt->tm_sec!=pre_sec)||(force_flag)){
	if(tmpt->tm_hour>12){
	  sprintf(mascot->digit,"%2d:%02d:%02d",
		  tmpt->tm_hour-12,tmpt->tm_min,tmpt->tm_sec);
	  mascot->clk_pm=TRUE;
	}
	else{
	  sprintf(mascot->digit,"%2d:%02d:%02d",
		  tmpt->tm_hour,tmpt->tm_min,tmpt->tm_sec);
	  mascot->clk_pm=FALSE;
	}
	draw_flag=TRUE;
      }
      break;

    case CLOCK_TYPE_24M:
      if((tmpt->tm_min!=pre_min)||(force_flag)){
	sprintf(mascot->digit,"%2d:%02d",
		tmpt->tm_hour,tmpt->tm_min);
	draw_flag=TRUE;
      }
      break;

    case CLOCK_TYPE_12M:
      if((tmpt->tm_min!=pre_min)||(force_flag)){
	if(tmpt->tm_hour>12){
	  sprintf(mascot->digit,"%2d:%02d",
		  tmpt->tm_hour-12,tmpt->tm_min);
	  mascot->clk_pm=TRUE;
	}
	else{
	  sprintf(mascot->digit,"%2d:%02d",
		  tmpt->tm_hour,tmpt->tm_min);
	  mascot->clk_pm=FALSE;
	}
	draw_flag=TRUE;
      }
    }

    if(draw_flag){
      // 
      switch(mascot->clkmode){
      case CLOCK_PIXMAP:
	// Mascotľʸ񤯾ϰ٥ޥåȤpixmap
	// 褷ʤɬפ(ʸä)
	DrawMascotWithDigit(mascot);
	flag_clock=TRUE;
	break;
	
      case CLOCK_PANEL:
	// ѥͥλפξϥѥͥΤߤľ
	// δؿWindowѹˤconfigure/expose_event
	// ƤӽФ, pixmapwindowؤԤäƤ
	if(force_flag){
	  DrawPanelClock(mascot);
	}
	DrawPanelClock(mascot);
	break;
	
      }
      pre_sec=tmpt->tm_sec;
      pre_min=tmpt->tm_min;
    }
  }
}


// ѥͥפpixmap bufferؤ
void DrawPanelClock(typMascot *mascot)
{
  gint clk_width,clk_height;
  gint work_page;
#ifdef USE_GTK2
  PangoLayout *pango_text;
#else
  gint lb,rb,as,ds;
#endif

  work_page=mascot->clk_page;
  work_page^=1;

#ifdef USE_GTK2
  pango_text=gtk_widget_create_pango_layout(mascot->w_clkdraw,
					    mascot->digit);
  pango_layout_get_pixel_size(pango_text,&clk_width,&clk_height);
#else
  gdk_string_extents(mascot->fontclk,mascot->digit,
		     &lb,&rb,&clk_width,&as,&ds);
  clk_height=as+ds;
#endif


  switch(mascot->clktype){
  case CLOCK_TYPE_12S:
  case CLOCK_TYPE_12M:
    clk_width+=clk_height/3;
    break;
  }

  gtk_drawing_area_size (GTK_DRAWING_AREA(mascot->w_clkdraw), 
			 clk_width+(mascot->clktext_x+mascot->wclkbd)*2,
			 clk_height+(mascot->clktext_y+mascot->wclkbd)*2);
  
  if (pixmap_clk[work_page]) {
    gdk_pixmap_unref(pixmap_clk[work_page]);
  } 
  
  pixmap_clk[work_page] = gdk_pixmap_new(mascot->w_clkdraw->window,
			       mascot->w_clkdraw->allocation.width,
			       mascot->w_clkdraw->allocation.height,
			       -1);
  

  // **** pixmapؤBUFFERING
  // border
  gdk_draw_rectangle(pixmap_clk[work_page],mascot->gc_clkbd[work_page],
		     TRUE,
		     0,0,
		     clk_width+(mascot->clktext_x+mascot->wclkbd)*2,
		     clk_height+(mascot->clktext_y+mascot->wclkbd)*2);

  // background
  gdk_draw_rectangle(pixmap_clk[work_page],mascot->gc_clkbg[work_page],
		     TRUE,
		     mascot->wclkbd,mascot->wclkbd,
		     clk_width+mascot->clktext_x*2,
		     clk_height+mascot->clktext_y*2);

  
  // digital clock
  if(mascot->flag_clksd){
#ifdef USE_GTK2
    gdk_draw_layout(pixmap_clk[work_page],
		    mascot->gc_clksd[work_page],
		    mascot->clktext_x+mascot->wclkbd+1,
		    mascot->clktext_y+mascot->wclkbd+1,
		    pango_text);
#else
    gdk_draw_string(pixmap_clk[work_page],mascot->fontclk,
		    mascot->gc_clksd[work_page],
		    mascot->clktext_x+mascot->wclkbd+1,
		    as+mascot->clktext_y+mascot->wclkbd+1,
		    mascot->digit);
#endif
  }
#ifdef USE_GTK2
  gdk_draw_layout(pixmap_clk[work_page],
		  mascot->gc_clk[work_page],
		  mascot->clktext_x+mascot->wclkbd,
		  mascot->clktext_y+mascot->wclkbd,
		  pango_text);
#else
  gdk_draw_string(pixmap_clk[work_page],mascot->fontclk,
		  mascot->gc_clk[work_page],
		  mascot->clktext_x+mascot->wclkbd,
		  as+mascot->clktext_y+mascot->wclkbd,
		  mascot->digit);
#endif

  switch(mascot->clktype){
  case CLOCK_TYPE_12S:
  case CLOCK_TYPE_12M:
    // digital clock
    if(mascot->flag_clksd){
      if(mascot->clk_pm){
	gdk_draw_arc(pixmap_clk[work_page],mascot->gc_clksd[work_page],
		     TRUE,
		     clk_width+mascot->clktext_x+mascot->wclkbd+1-clk_height/3,
		     mascot->clktext_y+mascot->wclkbd+1+clk_height*2/3,
		     clk_height/3,clk_height/3,
		     0,(360*64));
      }
      else{
	gdk_draw_arc(pixmap_clk[work_page],mascot->gc_clksd[work_page],
		     TRUE,
		     clk_width+mascot->clktext_x+mascot->wclkbd+1-clk_height/3,
		     mascot->clktext_y+mascot->wclkbd+1,
		     clk_height/3,clk_height/3,
		     0,(360*64));
      }
    }
    
    if(mascot->clk_pm){
      gdk_draw_arc(pixmap_clk[work_page],mascot->gc_clk[work_page],
		   TRUE,
		   clk_width+mascot->clktext_x+mascot->wclkbd-clk_height/3,
		   mascot->clktext_y+mascot->wclkbd+clk_height*2/3,
		   clk_height/3,clk_height/3,
		   0,(360*64));
    }
    else{
      gdk_draw_arc(pixmap_clk[work_page],mascot->gc_clk[work_page],
		   TRUE,
		   clk_width+mascot->clktext_x+mascot->wclkbd-clk_height/3,
		   mascot->clktext_y+mascot->wclkbd,
		   clk_height/3,clk_height/3,
		   0,(360*64));
    }

    break;
  }


  gdk_window_resize (clock_main->window,
		     clk_width+(mascot->clktext_x+mascot->wclkbd)*2,
		     clk_height+(mascot->clktext_y+mascot->wclkbd)*2);

  mascot->clk_page=work_page;

  while (g_main_iteration(FALSE));
  gdk_flush();
}


gchar *ini_week(gint day_of_week){
  gchar * weekk=NULL;

  switch(day_of_week){
  case 0:
    weekk=g_strdup(_("Sun"));
    break;
  case 1:
    weekk=g_strdup(_("Mon"));
    break;
  case 2:
    weekk=g_strdup(_("Tue"));
    break;
  case 3:
    weekk=g_strdup(_("Wed"));
    break;
  case 4:
    weekk=g_strdup(_("Thu"));
    break;
  case 5:
    weekk=g_strdup(_("Fri"));
    break;
  case 6:
    weekk=g_strdup(_("Sat"));
    break;
  }
  
  return(weekk);
}

// Ǥեޥɼ¹
void ext_play(typMascot *mascot, char *exe_command)
{
  static pid_t pid;
  gchar *cmdline;
  
  if(exe_command){
    waitpid(pid,0,WNOHANG);
    if(strcmp(exe_command,"\0")!=0){
      cmdline=g_strdup(exe_command);
      if( (pid = fork()) == 0 ){
	system(cmdline);
	_exit(-1);
	signal(SIGCHLD,ChildTerm);
      }
    }
  }
}


//  (1Ĥ)
void sound_play(typMascot *mascot, char *wav_name)
{
  static pid_t pid;
  gchar cmdline[1024];
  gchar *filename1;
  

  if( (mascot->sound_command) && (wav_name) ){

    if(!(filename1=FullPathSoundFile(mascot, wav_name))) return;

    sprintf(cmdline,mascot->sound_command,filename1);
    waitpid(pid,0,WNOHANG);
    if( (pid = fork()) == 0 ){
      system(cmdline);
      _exit(-1);
      signal(SIGCHLD,ChildTerm);
    }
  }
}


// ҥץν 
void ChildTerm(int dummy)
{
  int s;

  wait(&s);
  signal(SIGCHLD,ChildTerm);
}


