//  MaCoPiX = Mascot Construnctive Pilot for X
//                                (ActX / Gtk+ Evolution)
//    A unified desktop mascot program
//    for UNIX / X Window System with Gdk Environment
//
//  gui.c  : Constraction & Management of Graphical User Interfaces
//                                                    for   MaCoPiX
//                                copyright K.Chimari 2002-4
//
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
// 
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
// 
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//

#include "main.h"
#include <stdarg.h>

#define GTK_MSG

//CallbackϤ碌¤ եѹ
typedef struct{
  gchar *fn;
  GtkFontSelectionDialog *fsd;
  GtkWidget *entry;
}confFont;

//CallbackϤ碌¤ ѹ
typedef struct{
  GdkColor *color;
  GtkColorSelectionDialog *csd;
  GtkWidget *button;
  gboolean update;
}confColor;

//CallbackϤ碌¤ Pixmapѹ
typedef struct{
  GtkFileSelection *fs;
  int i_pix;
  gboolean update;
}confChangePixmap;

//CallbackϤ碌¤ ΤäPixmap
typedef struct{
  GtkFileSelection *fs;
  gchar *filename;
  gboolean update;
}confNkrChangePixmap;

//CallbackϤ碌¤ Pixmapѹ
typedef struct{
  GtkFileSelection *fs;
  gboolean update;
}confChangeBiffPixmap;

//CallbackϤ碌¤ Targetѹ
typedef struct{
  GtkFileSelection *fs;
  int i_cat;
  int i_tgt;
  gboolean update;
}confChangeTgt;

//CallbackϤ碌¤ Target
typedef struct{
  GtkWidget *dd;
  gboolean update;
}confDelTgt;

//CallbackϤ碌¤ Categoryɲ/
typedef struct{
  GtkWidget *pd;
  gint dest_cat;
  gboolean update;
}confCat;

//CallbackϤ碌¤ Categoryۼ
typedef struct{
  GtkFileSelection *fs;
  gboolean update;
}confMergeCat;

//CallbackϤ碌¤ ˥塼
typedef struct{
  GtkFileSelection *fs;
  gboolean update;
}confNewMenu;

//CallbackϤ碌¤ Pixmapɲ
typedef struct{
  GtkFileSelection *fs;
  gboolean update;
}confAddPixmap;

//CallbackϤ碌¤ ե¸񤭳ǧ
typedef struct{
  GtkWidget *dialog;
  gboolean update;
}confSaveOther;

//CallbackϤ碌¤ ꡼ѥե¸
typedef struct{
  GtkWidget *dialog;
  GtkWidget *fdialog;
  GtkWidget *copyright_entry;
  GtkWidget *name_entry;
  GtkWidget *code_entry;
  GtkWidget *font_check;
  gboolean update;
  gchar *new_copyright;
  gchar *new_name;
  gchar *new_code;
  gboolean font_flag;
}confSaveReleaseMascot;


//CallbackϤ碌¤ Pixmap
typedef struct{
  GtkWidget *dd;
  gint del_pix;
  gint hit_ptn;
  gint hit_frm;
  gboolean update;
}confDelPixmap;

//CallbackϤ碌¤ Frameɲ/
typedef struct{
  GtkWidget *fd;
  gint dest_frm;
  gboolean update;
}confFrame;

//CallbackϤ碌¤ Patternɲ/
typedef struct{
  GtkWidget *pd;
  gint dest_ptn;
  gboolean update;
}confPattern;

//CallbackϤ碌¤ Patternԡ
typedef struct{
  GtkWidget *pd;
  gint from_ptn;
  gint dest_ptn;
  gboolean update;
}confPatternCopy;

//CallbackϤ碌¤ Mascot
typedef struct{
  GtkWidget *dialog;
  GtkFileSelection *fs;
  gchar *mascot_file;
  gchar *image_file;
  gchar *copyright;
  gboolean update;
}confNewMascot;

//CallbackϤ碌¤ Click Soundѹ
typedef struct{
  GtkFileSelection *fs;
  gboolean update;
  gint i_ptn;
}confChangeClickSound;

//CallbackϤ碌¤ Duet ˥ѹ
typedef struct{
  GtkFileSelection *fs;
  gboolean update;
  gint i_ptn;
}confChangeDuetTgt;

//CallbackϤ碌¤ Biff Soundѹ
typedef struct{
  GtkFileSelection *fs;
  gboolean update;
}confChangeBiffSound;

//CallbackϤ碌¤ Mailȥեdѹ
typedef struct{
  GtkFileSelection *fs;
  gboolean update;
}confMailFile;

//CallbackϤ碌¤ Mailȥեdѹ
typedef struct{
  GtkWidget *dialog;
  GtkWidget *auto_check;
  gchar *filename;
  gboolean flag_ow;
  gboolean flag_auto;
}consType;



// *** GLOBAL ARGUMENT ***
extern GtkWidget *win_main, *clock_main, *balloon_main, *PopupMenu, *biff_pix;
extern gint window_x, window_y;
extern GdkDrawable *pixmap_main[2], *pixmap_clk[2], *pixmap_bal[2];
extern typMascot *Mascot;
extern gboolean flag_balloon;

extern gchar* all_random_menu_mascot_file();
extern void ReadMenu();
extern void SaveMenu();
extern void SaveRC();
extern void SaveDefMenu();
extern void SaveMascot();
extern void RemoveFontFromSaveData();
extern void InitMascot();
extern void ReadMascot();
extern gchar* FullPathMascotFile();
extern gchar* FullPathPixmapFile();
extern gchar* FullPathSoundFile();
extern gchar* ReadMascotName();
extern void ScanMenu();

extern void LoadPixmaps();
extern void LoadBiffPixmap();
extern void DrawMascot0();
extern void DrawMascot();
extern void DrawMascotWithDigit();
extern gboolean TestLoadPixmaps();

extern void MoveMascot();
extern int MoveToFocus();
extern GdkGC *CreatePen();
extern void ReInitGC();
extern void clock_update();

extern void copy_file();

extern void sound_play();

extern gint SetMailChecker();
extern gchar* set_mhdir();

extern void NkrSave();
extern void NkrRead();


// *** GLOBAL ARGUMENT ***
GtkTooltips *tooltip;
typMascot tmp_mascot;
gchar *tmp_pixfile[MAX_PIXMAP];
gboolean flagChildDialog=FALSE;
gboolean flag_make_pixmap_list=FALSE;
gboolean flag_make_pattern_list[MAX_ANIME_PATTERN];
gboolean flag_make_frame_list[MAX_ANIME_PATTERN];
gboolean flag_make_cat_list[MAX_MENU_CATEGORY];
gboolean flag_make_tgt_list[MAX_MENU_CATEGORY];
gint pattern_num=0;
gint selected_smenu;

// Prototype of Functions in this file
void MenuSaveRC();
void MenuSaveMascot();
void MenuSaveDefMenu();
void MenuDelDefMenu();
void MenuSaveAll();
void MoveTmpDataRC();
void MoveTmpDataMascot();
void MoveTmpDataMenu();
static void conf_change();
void change_bgcolor();
void change_fgcolor();
static void cc_move();
static void cc_clkmode ();
static void cc_clktype ();
static void cc_flag_xp();
static void cc_homepos ();
static void cc_ip_style();
static void cc_cons_check_mode();
static void cc_bal_defpos();
static void cc_mail_pixpos();
static void cc_ff_side();
static void cc_get_adj();
static void cc_get_entry();
static void cc_mail_type();
static void cc_signal_type();
static void cc_get_toggle();
static void check_menu_get_toggle();
static void check_menu_get_smenu();
static void mail_flag_toggle();

static void test_click_sound();
static void test_biff_sound();
static void clear_click_sound();
static void clear_biff_sound();

static void mc_up_tgt();
static void mc_down_tgt();
static void mc_up_cat();
static void mc_down_cat();

static void fs_set_udir();
static void fs_set_ddir();
static void fs_set_updir();
static void fs_set_dpdir();
static void fs_set_usdir();
static void fs_set_dsdir();
static void fs_set_mascotext();
static void fs_set_pngext();
static void fs_set_gifext();
static void fs_set_xpmext();
static void fs_set_menuext();
static void fs_set_rcext();
static void fs_set_nkrext();
static void fs_set_bmpext();


void ChangeMascotFS();
void NkrChangeMascotFS();
void ChangeMenuFS();
void MakeMenuFS();
void ChangeMascotMenu();
void CatRandomChangeMascotMenu();
void AllRandomChangeMascotMenu();
void ConfirmSaveOther();
void ConfirmSaveRelease();
void SaveMascotOther();
void SaveReleaseMascot();
void GoRelease();
void SaveMenuOther();
void SaveRCOther();
void ChangeFontname();
void ChangeColor();
void ChangeTgt();
void MergeCatFS();
void DelTgt();
void ChangeDuetTgt();
void ChangeClickSound();
void ChangeBiffSound();
void ChangeMailFile();


static void close_dialog();
static void close_cons();
static void ow_cons();
static void noow_cons();
static void close_new_mascot_dialog();
static void close_child_dialog();
gint close_popup();
static void destroy_popup();
static void close_conf();
static void close_smenu();

void TestPut();
void TestPut2();
void TestAnime();
void AddPixmap();
void DelPixmap();
void AddDelPattern();
void CopyPattern();
void AddDelFrame();
void ChangePixmap();
void NkrChangePixmap();
void ChangeBiffPixmap();
void ChangeTgt();

static void create_change_image_dialog();
gchar* create_nkr_change_image_dialog();
static void create_change_biff_image_dialog();
static void create_add_image_dialog();
static void create_del_image_dialog();
static void create_add_pattern_dialog();
static void create_del_pattern_dialog();
static void create_copy_pattern_dialog();
static void create_add_frame_dialog();
static void create_del_frame_dialog();
static void create_change_tgt_dialog();
static void create_add_tgt_dialog();
static void create_del_tgt_dialog();
static void create_add_cat_dialog();
static void create_del_cat_dialog();
static void create_merge_cat_dialog();

static void create_change_duet_tgt_dialog();
static void create_change_click_sound_dialog();
static void create_change_biff_sound_dialog();
static void create_mail_file_dialog();

static void NewMascotSelectMascot();
static void NewMascotSelectImage();
static void MakeNewMascot();
static void create_new_mascot_file_selection_dialog();
static void create_new_mascot_image_selection_dialog();
static void create_new_mascot_dialog();

static void create_file_selection_dialog();
static void create_menu_selection_dialog();
static void create_smenu_dialog2();
static void create_nkr_selection_dialog();
static void create_new_menu_selection_dialog();
static void create_save_mascot_dialog();
static void create_nkr_save_mascot_dialog();
static void create_save_release_mascot_dialog();
static void create_save_menu_dialog();
static void create_save_rc_dialog();
static void create_font_selection_dialog();
static void create_color_selection_dialog();
void create_config_dialog();
GtkWidget * create_menu_page();
GtkWidget * create_new_menu_page();

void make_pixmap_list();
void make_pattern_list();
void make_cat_list();
void make_frame_list();
void make_tgt_list();

GtkWidget * make_popup_menu();
GtkWidget * make_open_menu();
GtkWidget * make_save_menu();
GtkWidget * make_new_menu();
GtkWidget * make_menu_menu();
GtkWidget * make_open_launcher_menu();
GtkWidget * make_open_develop_menu();
GtkWidget * make_develop_menu();
GtkWidget * make_cat_menu();
GtkWidget * make_tgt_menu();

GtkWidget * make_clock();

void ChangeMascot();
void NkrChangeMascot();


void create_cons_dialog();

void create_smenu_dialog();
void make_smenu_list();

void popup_message(gint , ...);

///// Widget as Globalatgument /////

//Move

//Clock
GtkWidget *entry_fontname_clk;

//Balloon
GtkWidget *entry_fontname_bal;

// Pixmap
GtkWidget *pixmap_table;
GtkWidget *pixmap_entry[MAX_PIXMAP];

// Animation
GtkWidget *pattern_table[MAX_ANIME_PATTERN];
GtkWidget *frame_table[MAX_ANIME_PATTERN];
GtkWidget *ptn_scrwin[MAX_ANIME_PATTERN];
GtkWidget *click_sound_entry[MAX_ANIME_PATTERN];
GtkWidget *duet_tgt_entry[MAX_ANIME_PATTERN];


// Menu Category
GtkWidget *cat_table[MAX_MENU_CATEGORY];
GtkWidget *tgt_table[MAX_MENU_TARGET];
GtkWidget *cat_scrwin[MAX_MENU_CATEGORY];
GtkWidget *cat_note;

GtkWidget *menu_page_table;

//Misc
GtkWidget *entry_deffontname_clk;
GtkWidget *entry_deffontname_bal;


void MenuSaveRC(void){
  //MoveTmpDataRC();
  SaveRC(Mascot,FALSE);
}

void MenuSaveMascot(void){
  //MoveTmpDataMascot();
  SaveMascot(Mascot,FALSE);
}

void MenuSaveDefMenu(void){
  //MoveTmpDataRC();
  SaveDefMenu(Mascot,FALSE);
}

void MenuDelDefMenu(void){
  Mascot->menu_total=0;
  Mascot->menu_file=NULL;
  SaveDefMenu(Mascot,FALSE);

  gtk_widget_destroy(PopupMenu);
  ReadMenu(Mascot,0,NULL);
  PopupMenu=make_popup_menu();
}


void MenuSaveAll(void){
  SaveMascot(Mascot,FALSE);
  SaveRC(Mascot,FALSE);
  if(Mascot->menu_total>0)  SaveMenu(Mascot);
  SaveDefMenu(Mascot,FALSE);
}


void MoveTmpDataRC(void){

  //// for RCFILE
  //Move
  Mascot->flag_xp=tmp_mascot.flag_xp;
  Mascot->offset=tmp_mascot.offset;
  Mascot->offsetp=tmp_mascot.offsetp;
  Mascot->ff_side=tmp_mascot.ff_side;
  Mascot->focus_autobar=tmp_mascot.focus_autobar;
  Mascot->bar_size=tmp_mascot.bar_size;
  Mascot->bar_offset=tmp_mascot.bar_offset;
  Mascot->homepos=tmp_mascot.homepos;
  Mascot->home_x=tmp_mascot.home_x;
  Mascot->home_y=tmp_mascot.home_y;
  Mascot->sound_command=tmp_mascot.sound_command;
  Mascot->sjis_filter=tmp_mascot.sjis_filter;
  Mascot->euc_filter=tmp_mascot.euc_filter;
  //Misc
  Mascot->magnify=tmp_mascot.magnify;
  Mascot->duet_use_click=tmp_mascot.duet_use_click;
  Mascot->duet_use_random=tmp_mascot.duet_use_random;
  Mascot->ip_style=tmp_mascot.ip_style;
  Mascot->flag_install=tmp_mascot.flag_install;
  Mascot->cons_check_mode=tmp_mascot.cons_check_mode;
  Mascot->deffontname_clk=tmp_mascot.deffontname_clk;
  Mascot->deffontname_bal=tmp_mascot.deffontname_bal;
}

void MoveTmpDataMascot(void){
  int i_pix, i_ptn, i_frm;
  gint i_tmp;
  gchar *pix_dir;
  gchar *tmp_file, *tmp_file2;

  /// 
  Mascot->name=tmp_mascot.name;

  //// Move Window
  Mascot->move=tmp_mascot.move;

  Mascot->xfix=tmp_mascot.xfix;
  Mascot->yfix=tmp_mascot.yfix;


  //// Clock
  Mascot->clkmode=tmp_mascot.clkmode;
  Mascot->clktype=tmp_mascot.clktype;
  Mascot->fontname_clk=tmp_mascot.fontname_clk;
  Mascot->clk_x=tmp_mascot.clk_x;
  Mascot->clk_y=tmp_mascot.clk_y;
  Mascot->clktext_x=tmp_mascot.clktext_x;
  Mascot->clktext_y=tmp_mascot.clktext_y;
  Mascot->flag_clksd=tmp_mascot.flag_clksd;
  Mascot->wclkbd=tmp_mascot.wclkbd;
  Mascot->colclk=tmp_mascot.colclk;
  Mascot->colclkbg=tmp_mascot.colclkbg;
  Mascot->colclkbd=tmp_mascot.colclkbd;
  Mascot->colclksd=tmp_mascot.colclksd;

  //// Time Signal
  Mascot->signal.flag=tmp_mascot.signal.flag;
  Mascot->signal.type=tmp_mascot.signal.type;
  Mascot->signal.com=tmp_mascot.signal.com;
  

  //// Balloon
  Mascot->fontname_bal=tmp_mascot.fontname_bal;
  Mascot->baltext_x=tmp_mascot.baltext_x;
  Mascot->baltext_y=tmp_mascot.baltext_y;
  Mascot->wbalbd=tmp_mascot.wbalbd;
  Mascot->bal_defpos=tmp_mascot.bal_defpos;
  Mascot->colbal=tmp_mascot.colbal;
  Mascot->colbalbg=tmp_mascot.colbalbg;
  Mascot->colbalbd=tmp_mascot.colbalbd;
  

  //// Biff
  Mascot->mail.type=tmp_mascot.mail.type;
  Mascot->mail.pop_port=tmp_mascot.mail.pop_port;
  Mascot->mail.pop_server=tmp_mascot.mail.pop_server;
  Mascot->mail.pop_id=tmp_mascot.mail.pop_id;
  Mascot->mail.pop_pass=tmp_mascot.mail.pop_pass;
  Mascot->mail.file=tmp_mascot.mail.file;
  if(!tmp_mascot.mail.file){
    if(Mascot->mail.type==MAIL_LOCAL){
      Mascot->mail.file=g_strdup(g_getenv("MAIL"));
    }
    else if(Mascot->mail.type==MAIL_QMAIL){
      Mascot->mail.file=g_strconcat(g_get_home_dir(),"/Maildir/new/",NULL);
    }
    else if(Mascot->mail.type==MAIL_PROCMAIL){
      Mascot->mail.file=g_strconcat(set_mhdir(),PROCMAIL_LOG,NULL);
    }
  }
  Mascot->mail.spam_check=tmp_mascot.mail.spam_check;
  Mascot->mail.spam_mark=tmp_mascot.mail.spam_mark;
  

  Mascot->mail.interval=tmp_mascot.mail.interval;
  Mascot->mail.polling=tmp_mascot.mail.polling;
  Mascot->mail.mailer=tmp_mascot.mail.mailer;
  Mascot->mail.filter=tmp_mascot.mail.filter;

  Mascot->mail.pix_file=tmp_mascot.mail.pix_file;
  Mascot->mail.pix_pos=tmp_mascot.mail.pix_pos;
  Mascot->mail.pix_x=tmp_mascot.mail.pix_x;
  Mascot->mail.pix_y=tmp_mascot.mail.pix_y;
  Mascot->mail.word=tmp_mascot.mail.word;
  Mascot->mail.sound=tmp_mascot.mail.sound;

  Mascot->mail.win_width=tmp_mascot.mail.win_width;
  Mascot->mail.win_height=tmp_mascot.mail.win_height;


  //// Pixmap
  Mascot->xoff=tmp_mascot.xoff;
  Mascot->yoff=tmp_mascot.yoff;

  pix_dir=g_dirname(Mascot->sprites[0].filename);
  for(i_pix=0;i_pix<tmp_mascot.nPixmap;i_pix++){
    // ǥ쥯ȥ꤬00֥᡼Ȱ㤦
    //  00֥᡼Ʊǥ쥯ȥ -> USERDIR/PIXDIR/
    // ̤ͥǥԡ򤹤(ξƱե뤬ʤȤΤ)
    if(tmp_pixfile[i_pix]){
      if(strcmp(g_dirname(tmp_pixfile[i_pix]),pix_dir)){
	tmp_file=g_strconcat(pix_dir,"/",g_basename(tmp_pixfile[i_pix]),NULL);
	tmp_file2=g_strconcat(g_get_home_dir(), "/",USER_DIR,
			     PIXDIR, g_basename(tmp_pixfile[i_pix]), NULL);
	if((access(tmp_file,F_OK)!=0)&&(access(tmp_file2,F_OK)!=0)){
	  if(access(pix_dir,W_OK)==0){
	    g_print(_("Installing %s -> %s\n"),tmp_pixfile[i_pix],tmp_file);
	    copy_file(tmp_pixfile[i_pix],tmp_file);
	  }
	  else{
	    g_print(_("Installing %s -> %s\n"),tmp_pixfile[i_pix],tmp_file2);
	    copy_file(tmp_pixfile[i_pix],tmp_file2);
	  }
	}
      }
    }
    
    Mascot->sprites[i_pix].filename=tmp_pixfile[i_pix];
    Mascot->sprites[i_pix].pixmap=NULL;
    Mascot->sprites[i_pix].mask=NULL;
  }
  
  for(i_pix=tmp_mascot.nPixmap;i_pix<MAX_PIXMAP;i_pix++){
    Mascot->sprites[i_pix].filename=NULL;
    Mascot->sprites[i_pix].pixmap=NULL;
    Mascot->sprites[i_pix].mask=NULL;
  }

  Mascot->random_total=0;
  Mascot->click_total=0;
  //// Animation
  for(i_ptn=0;i_ptn<MAX_ANIME_PATTERN;i_ptn++){
      Mascot->frame_num[i_ptn]=tmp_mascot.frame_num[i_ptn];
      Mascot->random_weight[i_ptn]=tmp_mascot.random_weight[i_ptn];
      Mascot->click_weight[i_ptn]=tmp_mascot.click_weight[i_ptn];
      Mascot->click_word[i_ptn]=tmp_mascot.click_word[i_ptn];
      Mascot->click_sound[i_ptn]=tmp_mascot.click_sound[i_ptn];
      Mascot->duet_tgt[i_ptn]=tmp_mascot.duet_tgt[i_ptn];
      Mascot->duet_ptn[i_ptn]=tmp_mascot.duet_ptn[i_ptn];
      Mascot->duet_word[i_ptn]=tmp_mascot.duet_word[i_ptn];
      Mascot->duet_delay[i_ptn]=tmp_mascot.duet_delay[i_ptn];
      Mascot->random_total+=Mascot->random_weight[i_ptn];
      Mascot->click_total+=Mascot->click_weight[i_ptn];
    for(i_frm=0;i_frm<MAX_ANIME_FRAME;i_frm++){
      Mascot->frame_pix[i_ptn][i_frm]=tmp_mascot.frame_pix[i_ptn][i_frm];
      Mascot->frame_min[i_ptn][i_frm]=tmp_mascot.frame_min[i_ptn][i_frm];
      Mascot->frame_max[i_ptn][i_frm]=tmp_mascot.frame_max[i_ptn][i_frm];
      Mascot->frame_loop[i_ptn][i_frm].next
	=tmp_mascot.frame_loop[i_ptn][i_frm].next;
      Mascot->frame_loop[i_ptn][i_frm].min
	=tmp_mascot.frame_loop[i_ptn][i_frm].min;
      Mascot->frame_loop[i_ptn][i_frm].max
	=tmp_mascot.frame_loop[i_ptn][i_frm].max;

      if(Mascot->frame_min[i_ptn][i_frm]>Mascot->frame_max[i_ptn][i_frm]){
	i_tmp=Mascot->frame_max[i_ptn][i_frm];
	Mascot->frame_max[i_ptn][i_frm]=Mascot->frame_min[i_ptn][i_frm];
	Mascot->frame_min[i_ptn][i_frm]=i_tmp;
      }
      if( Mascot->frame_loop[i_ptn][i_frm].min
	  > Mascot->frame_loop[i_ptn][i_frm].max){
	i_tmp= Mascot->frame_loop[i_ptn][i_frm].max;
	Mascot->frame_loop[i_ptn][i_frm].max
	  = Mascot->frame_loop[i_ptn][i_frm].min;
	Mascot->frame_loop[i_ptn][i_frm].min=i_tmp;
      }
    }
  }
}

void MoveTmpDataMenu(void){
  int i_cat, i_tgt;

  //// for Menu
  Mascot->menu_file=tmp_mascot.menu_file;
  Mascot->menu_cat_max=tmp_mascot.menu_cat_max;
  Mascot->menu_total=tmp_mascot.menu_total;

  for(i_cat=0;i_cat<Mascot->menu_cat_max;i_cat++){
    Mascot->menu_cat[i_cat]=tmp_mascot.menu_cat[i_cat];
    Mascot->menu_tgt_max[i_cat]=tmp_mascot.menu_tgt_max[i_cat];
    for(i_tgt=0;i_tgt<Mascot->menu_tgt_max[i_cat];i_tgt++){
      Mascot->menu_tgt[i_cat][i_tgt]=tmp_mascot.menu_tgt[i_cat][i_tgt];
      Mascot->menu_tgt_name[i_cat][i_tgt]
	=tmp_mascot.menu_tgt_name[i_cat][i_tgt];
    }
  }
}



static void conf_change(GtkWidget *w, GtkWidget *dialog)
{

  if(flagChildDialog){
    return;
  }

  InitMascot(Mascot);

  MoveTmpDataRC();
  MoveTmpDataMascot();
  MoveTmpDataMenu();

  SetMailChecker(Mascot);


  gtk_widget_destroy(GTK_WIDGET(dialog));
  while (g_main_iteration(FALSE));

  LoadPixmaps(win_main, Mascot->w_drawing, Mascot, Mascot->sprites);
  ReInitGC(Mascot);
  gtk_widget_unmap(balloon_main);
  flag_balloon=FALSE;
  LoadBiffPixmap(biff_pix, Mascot);


  if(Mascot->clkmode!=CLOCK_NO)  clock_update(Mascot, TRUE);
  if(Mascot->clkmode==CLOCK_PANEL){
    gtk_widget_map(clock_main);
  }
  else{
    gtk_widget_unmap(clock_main);
  }

  if((Mascot->move==MOVE_FIX)
     &&(Mascot->xfix>=0)&&(Mascot->xfix<=Mascot->width_root)
     &&(Mascot->yfix>=0)&&(Mascot->yfix<=Mascot->height_root))
    MoveMascot(Mascot,Mascot->xfix,Mascot->yfix);
  else{
    Mascot->x=tmp_mascot.x;
    Mascot->y=tmp_mascot.y;
    MoveMascot(Mascot,Mascot->x,Mascot->y);
  }

  gtk_widget_destroy(PopupMenu);
  PopupMenu=make_popup_menu();

  flag_make_pixmap_list=FALSE;
  Mascot->flag_menu=FALSE;
  while (g_main_iteration(FALSE));
  gdk_flush();
}


void change_bgcolor(GtkWidget *widget, GdkColor color){
  GtkStyle *def_style, *style;
  
  def_style = gtk_widget_get_style(widget);
  style = gtk_style_copy(def_style);

  style->bg[GTK_STATE_NORMAL] = color;
  style->bg[GTK_STATE_ACTIVE] = color;
  style->bg[GTK_STATE_PRELIGHT] = color;
  style->bg[GTK_STATE_SELECTED] = color;
  gtk_widget_set_style(widget,style);

}

void change_fgcolor(GtkWidget *widget, GdkColor color){
  GtkStyle *def_style, *style;
  
  def_style = gtk_widget_get_style(widget);
  style = gtk_style_copy(def_style);

  style->fg[0] = color;
  gtk_widget_set_style(widget,style);

}


static void cc_move (GtkWidget *widget,GdkEvent  *event)
{
  if(!strcmp(gtk_entry_get_text(GTK_ENTRY(widget)),_("Focus Follow"))){
    tmp_mascot.move=MOVE_FOCUS;
  }
  else{
    tmp_mascot.move=MOVE_FIX;
  }
    
}

static void cc_clkmode (GtkWidget *widget)
{
  if(!strcmp(gtk_entry_get_text(GTK_ENTRY(widget)),_("No Clock"))){
    tmp_mascot.clkmode=CLOCK_NO;
  }
  else if(!strcmp(gtk_entry_get_text(GTK_ENTRY(widget)),_("Clock on Image"))){
    tmp_mascot.clkmode=CLOCK_PIXMAP;
  }
  else{
    tmp_mascot.clkmode=CLOCK_PANEL;
  }
}


static void cc_clktype (GtkWidget *widget)
{
  if(!strcmp(gtk_entry_get_text(GTK_ENTRY(widget)),_("14:00:00"))){
    tmp_mascot.clktype=CLOCK_TYPE_24S;
  }
  else if(!strcmp(gtk_entry_get_text(GTK_ENTRY(widget)),_("14:00"))){
    tmp_mascot.clktype=CLOCK_TYPE_24M;
  }
  else if(!strcmp(gtk_entry_get_text(GTK_ENTRY(widget)),_("PM  2:00:00"))){
    tmp_mascot.clktype=CLOCK_TYPE_12S;
  }
  else{
    tmp_mascot.clktype=CLOCK_TYPE_12M;
  }
}


static void cc_flag_xp (GtkWidget *widget)
{
  if(!strcmp(gtk_entry_get_text(GTK_ENTRY(widget)),_("Relative"))){
    tmp_mascot.flag_xp=TRUE;
  }
  else{
    tmp_mascot.flag_xp=FALSE;
  }
    
}

static void cc_homepos (GtkWidget *widget)
{
  if(!strcmp(gtk_entry_get_text(GTK_ENTRY(widget)),_("No Focus Only"))){
    tmp_mascot.homepos=HOMEPOS_FOCUS;
  }
  else if(!strcmp(gtk_entry_get_text(GTK_ENTRY(widget)),_("Support Sticking Out"))){
    tmp_mascot.homepos=HOMEPOS_OUT;
  }
  else{
    tmp_mascot.homepos=HOMEPOS_NEVER;
  }
}


static void cc_ip_style (GtkWidget *widget,GdkEvent  *event)
{
  if(!strcmp(gtk_entry_get_text(GTK_ENTRY(widget)),
	     _("Nearest-Neighbor"))){
    tmp_mascot.ip_style=MAG_IP_NEAREST;
  }
  else if(!strcmp(gtk_entry_get_text(GTK_ENTRY(widget)),
		  _("Tiles"))){
    tmp_mascot.ip_style=MAG_IP_TILES;
  }
  else if(!strcmp(gtk_entry_get_text(GTK_ENTRY(widget)),
		  _("Bilinear"))){
    tmp_mascot.ip_style=MAG_IP_BILINEAR;
  }
  else if(!strcmp(gtk_entry_get_text(GTK_ENTRY(widget)),
		  _("Hyper"))){
    tmp_mascot.ip_style=MAG_IP_HYPER;
  }
    
}

static void cc_cons_check_mode (GtkWidget *widget,GdkEvent  *event)
{
  if(!strcmp(gtk_entry_get_text(GTK_ENTRY(widget)),
	     _("Manual"))){
    tmp_mascot.cons_check_mode=CONS_MANUAL;
  }
  else if(!strcmp(gtk_entry_get_text(GTK_ENTRY(widget)),
		  _("Auto Overwrite"))){
    tmp_mascot.cons_check_mode=CONS_AUTOOW;
  }
  else if(!strcmp(gtk_entry_get_text(GTK_ENTRY(widget)),
		  _("Ignore"))){
    tmp_mascot.cons_check_mode=CONS_IGNORE;
  }
    
}

static void cc_bal_defpos (GtkWidget *widget,GdkEvent  *event)
{
  if(!strcmp(gtk_entry_get_text(GTK_ENTRY(widget)),_("Left"))){
    tmp_mascot.bal_defpos=BAL_POS_LEFT;
  }
  else{
    tmp_mascot.bal_defpos=BAL_POS_RIGHT;
  }
    
}

static void cc_mail_pixpos (GtkWidget *widget,GdkEvent  *event)
{
  if(!strcmp(gtk_entry_get_text(GTK_ENTRY(widget)),_("Left"))){
    tmp_mascot.mail.pix_pos=MAIL_PIX_LEFT;
  }
  else{
    tmp_mascot.mail.pix_pos=MAIL_PIX_RIGHT;
  }
    
}

static void cc_ff_side (GtkWidget *widget,GdkEvent  *event)
{
  if(!strcmp(gtk_entry_get_text(GTK_ENTRY(widget)),_("Left"))){
    tmp_mascot.ff_side=FF_SIDE_LEFT;
  }
  else{
    tmp_mascot.ff_side=FF_SIDE_RIGHT;
  }
    
}

static void cc_get_adj (GtkWidget *widget, gint * gdata)
{
  *gdata=GTK_ADJUSTMENT(widget)->value;
}

static void cc_get_entry (GtkWidget *widget, gchar **gdata)
{
  *gdata=g_strdup(gtk_entry_get_text(GTK_ENTRY(widget)));
}


static void cc_mail_type (GtkWidget *widget,GdkEvent  *event)
{
  if(!strcmp(gtk_entry_get_text(GTK_ENTRY(widget)),
	     _("None"))){
    tmp_mascot.mail.type=MAIL_NO;
  }
  else if(!strcmp(gtk_entry_get_text(GTK_ENTRY(widget)),
		  _("Local"))){
    tmp_mascot.mail.type=MAIL_LOCAL;
  }
  else if(!strcmp(gtk_entry_get_text(GTK_ENTRY(widget)),
		  _("POP3 (normal)"))){
    tmp_mascot.mail.type=MAIL_POP3;
  }
  else if(!strcmp(gtk_entry_get_text(GTK_ENTRY(widget)),
		  _("POP3 (APOP auth)"))){
    tmp_mascot.mail.type=MAIL_APOP;
  }
  else if(!strcmp(gtk_entry_get_text(GTK_ENTRY(widget)),
		  _("qmail (Maildir)"))){
    tmp_mascot.mail.type=MAIL_QMAIL;
  }
  else if(!strcmp(gtk_entry_get_text(GTK_ENTRY(widget)),
		  _("MH + Procmail"))){
    tmp_mascot.mail.type=MAIL_PROCMAIL;
  }
    
}

static void cc_signal_type (GtkWidget *widget)
{
  if(!strcmp(gtk_entry_get_text(GTK_ENTRY(widget)),_("None"))){
    tmp_mascot.signal.type=SIGACT_NO;
  }
  else if(!strcmp(gtk_entry_get_text(GTK_ENTRY(widget)),_("Click Action"))){
    tmp_mascot.signal.type=SIGACT_CLICK;
  }
  else{
    tmp_mascot.signal.type=SIGACT_CHANGE;
  }
}

static void cc_get_toggle (GtkWidget * widget, gboolean * gdata)
{
  *gdata=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));
}

static void check_menu_get_toggle (GtkWidget * widget, gboolean * gdata)
{
  if(GTK_CHECK_MENU_ITEM(widget)->active){
    *gdata=TRUE;
  }
  else{
    *gdata=FALSE;
  }
}

static void check_menu_get_smenu (GtkWidget * widget, gint *gdata)
{
  if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget))){
    selected_smenu=(gint)gdata;
  }
}


static void mail_flag_toggle (GtkWidget * widget)
{
  if(GTK_CHECK_MENU_ITEM(widget)->active){
    Mascot->mail.flag=TRUE;
  }
  else{
    Mascot->mail.flag=FALSE;
  }
  SetMailChecker(Mascot);
}

static void test_click_sound (GtkWidget *widget, gpointer gdata)
{
  int i_ptn;
  i_ptn=(int)gdata;

  sound_play(&tmp_mascot,tmp_mascot.click_sound[i_ptn]);
}

static void test_biff_sound (GtkWidget *widget)
{
  sound_play(&tmp_mascot,tmp_mascot.mail.sound);
}

static void clear_click_sound (GtkWidget *widget, gpointer gdata)
{
  int i_ptn;
  i_ptn=(int)gdata;

  tmp_mascot.click_sound[i_ptn]=NULL;
  gtk_entry_set_text(GTK_ENTRY(click_sound_entry[i_ptn]),"");
  
}

static void clear_biff_sound (GtkWidget *widget, gpointer gdata)
{
  GtkWidget *snd_entry;
  snd_entry=(GtkWidget *)gdata;

  tmp_mascot.mail.sound=NULL;
  gtk_entry_set_text(GTK_ENTRY(snd_entry),"");
  
}


static void mc_up_tgt (GtkWidget *widget, gpointer gdata)
{
  int i_tmp, i_cat, i_tgt;
  gchar *tmp_menu_tgt, *tmp_menu_tgt_name;

  i_tmp=(int)gdata;
  
  i_cat=i_tmp / MAX_MENU_TARGET;
  i_tgt=i_tmp % MAX_MENU_TARGET; 

  if(i_tgt<=0) return;
  
  tmp_menu_tgt=g_strdup(tmp_mascot.menu_tgt[i_cat][i_tgt-1]);
  tmp_menu_tgt_name=g_strdup(tmp_mascot.menu_tgt_name[i_cat][i_tgt-1]);

  tmp_mascot.menu_tgt[i_cat][i_tgt-1]
    =g_strdup(tmp_mascot.menu_tgt[i_cat][i_tgt]);
  tmp_mascot.menu_tgt_name[i_cat][i_tgt-1]
    =g_strdup(tmp_mascot.menu_tgt_name[i_cat][i_tgt]);

  tmp_mascot.menu_tgt[i_cat][i_tgt]=g_strdup(tmp_menu_tgt);
  tmp_mascot.menu_tgt_name[i_cat][i_tgt]=g_strdup(tmp_menu_tgt_name);

  make_tgt_list(i_cat);
}

static void mc_down_tgt (GtkWidget *widget, gpointer gdata)
{
  int i_tmp, i_cat, i_tgt;
  gchar *tmp_menu_tgt, *tmp_menu_tgt_name;

  i_tmp=(int)gdata;
  
  i_cat=i_tmp / MAX_MENU_TARGET;
  i_tgt=i_tmp % MAX_MENU_TARGET; 

  if(i_tgt>=MAX_MENU_TARGET) return;
  
  tmp_menu_tgt=g_strdup(tmp_mascot.menu_tgt[i_cat][i_tgt+1]);
  tmp_menu_tgt_name=g_strdup(tmp_mascot.menu_tgt_name[i_cat][i_tgt+1]);

  tmp_mascot.menu_tgt[i_cat][i_tgt+1]
    =g_strdup(tmp_mascot.menu_tgt[i_cat][i_tgt]);
  tmp_mascot.menu_tgt_name[i_cat][i_tgt+1]
    =g_strdup(tmp_mascot.menu_tgt_name[i_cat][i_tgt]);

  tmp_mascot.menu_tgt[i_cat][i_tgt]=g_strdup(tmp_menu_tgt);
  tmp_mascot.menu_tgt_name[i_cat][i_tgt]=g_strdup(tmp_menu_tgt_name);

  make_tgt_list(i_cat);
 
}


static void mc_up_cat (GtkWidget *widget, gpointer gdata)
{
  int i_cat, i_tgt;
  gint  tmp_menu_tgt_max;
  gchar *tmp_menu_cat;
  gchar *tmp_menu_tgt[MAX_MENU_TARGET];
  gchar *tmp_menu_tgt_name[MAX_MENU_TARGET];

  i_cat=(int)gdata;
  
  if(i_cat<=0) return;

  tmp_menu_tgt_max=tmp_mascot.menu_tgt_max[i_cat-1];
  tmp_menu_cat=g_strdup(tmp_mascot.menu_cat[i_cat-1]);
  
  for(i_tgt=0;i_tgt<tmp_mascot.menu_tgt_max[i_cat-1];i_tgt++){
    tmp_menu_tgt[i_tgt]
      =g_strdup(tmp_mascot.menu_tgt[i_cat-1][i_tgt]);
    tmp_menu_tgt_name[i_tgt]
      =g_strdup(tmp_mascot.menu_tgt_name[i_cat-1][i_tgt]);
  }
 
  tmp_mascot.menu_tgt_max[i_cat-1]=tmp_mascot.menu_tgt_max[i_cat];
  tmp_mascot.menu_cat[i_cat-1]=g_strdup(tmp_mascot.menu_cat[i_cat]);
  
  for(i_tgt=0;i_tgt<tmp_mascot.menu_tgt_max[i_cat-1];i_tgt++){
    tmp_mascot.menu_tgt[i_cat-1][i_tgt]
      =g_strdup(tmp_mascot.menu_tgt[i_cat][i_tgt]);
    tmp_mascot.menu_tgt_name[i_cat-1][i_tgt]
      =g_strdup(tmp_mascot.menu_tgt_name[i_cat][i_tgt]);
  }

  tmp_mascot.menu_tgt_max[i_cat]=tmp_menu_tgt_max;
  tmp_mascot.menu_cat[i_cat]=g_strdup(tmp_menu_cat);
  
  for(i_tgt=0;i_tgt<tmp_mascot.menu_tgt_max[i_cat];i_tgt++){
    tmp_mascot.menu_tgt[i_cat][i_tgt]
      =g_strdup(tmp_menu_tgt[i_tgt]);
    tmp_mascot.menu_tgt_name[i_cat][i_tgt]
      =g_strdup(tmp_menu_tgt_name[i_tgt]);
  }
  

  make_cat_list(cat_note, i_cat-1);
  make_cat_list(cat_note, i_cat);

  gtk_notebook_set_page(GTK_NOTEBOOK(cat_note), (gint)(i_cat-1));
  gtk_widget_queue_draw(GTK_WIDGET(cat_note));

}

static void mc_down_cat (GtkWidget *widget, gpointer gdata)
{
  int i_cat, i_tgt;
  gint  tmp_menu_tgt_max;
  gchar *tmp_menu_cat;
  gchar *tmp_menu_tgt[MAX_MENU_TARGET];
  gchar *tmp_menu_tgt_name[MAX_MENU_TARGET];

  i_cat=(int)gdata;
  
  if(i_cat>=tmp_mascot.menu_cat_max-1) return;

  tmp_menu_tgt_max=tmp_mascot.menu_tgt_max[i_cat+1];
  tmp_menu_cat=g_strdup(tmp_mascot.menu_cat[i_cat+1]);
  
  for(i_tgt=0;i_tgt<tmp_mascot.menu_tgt_max[i_cat+1];i_tgt++){
    tmp_menu_tgt[i_tgt]
      =g_strdup(tmp_mascot.menu_tgt[i_cat+1][i_tgt]);
    tmp_menu_tgt_name[i_tgt]
      =g_strdup(tmp_mascot.menu_tgt_name[i_cat+1][i_tgt]);
  }
 
  tmp_mascot.menu_tgt_max[i_cat+1]=tmp_mascot.menu_tgt_max[i_cat];
  tmp_mascot.menu_cat[i_cat+1]=g_strdup(tmp_mascot.menu_cat[i_cat]);
  
  for(i_tgt=0;i_tgt<tmp_mascot.menu_tgt_max[i_cat+1];i_tgt++){
    tmp_mascot.menu_tgt[i_cat+1][i_tgt]
      =g_strdup(tmp_mascot.menu_tgt[i_cat][i_tgt]);
    tmp_mascot.menu_tgt_name[i_cat+1][i_tgt]
      =g_strdup(tmp_mascot.menu_tgt_name[i_cat][i_tgt]);
  }

  tmp_mascot.menu_tgt_max[i_cat]=tmp_menu_tgt_max;
  tmp_mascot.menu_cat[i_cat]=g_strdup(tmp_menu_cat);
  
  for(i_tgt=0;i_tgt<tmp_mascot.menu_tgt_max[i_cat];i_tgt++){
    tmp_mascot.menu_tgt[i_cat][i_tgt]
      =g_strdup(tmp_menu_tgt[i_tgt]);
    tmp_mascot.menu_tgt_name[i_cat][i_tgt]
      =g_strdup(tmp_menu_tgt_name[i_tgt]);
  }
  

  make_cat_list(cat_note, i_cat);
  make_cat_list(cat_note, i_cat+1);

  gtk_notebook_set_page(GTK_NOTEBOOK(cat_note), (gint)(i_cat+1));
  gtk_widget_queue_draw(GTK_WIDGET(cat_note));

}


static void fs_set_udir (GtkWidget *widget, gpointer gdata)
{
  GtkWidget *fdialog;
  gchar *userdir;

  fdialog=(GtkWidget *)gdata;
  userdir = g_strconcat(g_get_home_dir(),"/",USER_DIR, NULL);
  

  gtk_file_selection_set_filename (GTK_FILE_SELECTION (fdialog), 
  				   userdir);
}

static void fs_set_ddir (GtkWidget *widget, gpointer gdata)
{
  GtkWidget *fdialog;

  fdialog=(GtkWidget *)gdata;
  

  gtk_file_selection_set_filename (GTK_FILE_SELECTION (fdialog), 
  				   COMMON_DIR);
}


static void fs_set_updir (GtkWidget *widget, gpointer gdata)
{
  GtkWidget *fdialog;
  gchar *userdir;

  fdialog=(GtkWidget *)gdata;
  userdir = g_strconcat(g_get_home_dir(),"/",USER_DIR,PIXDIR, NULL);
  

  gtk_file_selection_set_filename (GTK_FILE_SELECTION (fdialog), 
  				   userdir);
}

static void fs_set_dpdir (GtkWidget *widget, gpointer gdata)
{
  GtkWidget *fdialog;
  gchar *datadir;

  fdialog=(GtkWidget *)gdata;
  datadir = g_strconcat(COMMON_DIR,PIXDIR, NULL);


  gtk_file_selection_set_filename (GTK_FILE_SELECTION (fdialog), 
  				   datadir);
}


static void fs_set_usdir (GtkWidget *widget, gpointer gdata)
{
  GtkWidget *fdialog;
  gchar *userdir;

  fdialog=(GtkWidget *)gdata;
  userdir = g_strconcat(g_get_home_dir(),"/",USER_DIR,SOUNDDIR, NULL);
  

  gtk_file_selection_set_filename (GTK_FILE_SELECTION (fdialog), 
  				   userdir);
}

static void fs_set_dsdir (GtkWidget *widget, gpointer gdata)
{
  GtkWidget *fdialog;
  gchar *datadir;

  fdialog=(GtkWidget *)gdata;
  datadir = g_strconcat(COMMON_DIR,SOUNDDIR, NULL);


  gtk_file_selection_set_filename (GTK_FILE_SELECTION (fdialog), 
  				   datadir);
}


static void fs_set_mascotext (GtkWidget *widget, gpointer gdata)
{
  GtkWidget *fdialog;

  fdialog=(GtkWidget *)gdata;
  
  gtk_file_selection_complete (GTK_FILE_SELECTION (fdialog), 
				   MASCOT_EXTENSION);
}


static void fs_set_pngext (GtkWidget *widget, gpointer gdata)
{
  GtkWidget *fdialog;

  fdialog=(GtkWidget *)gdata;
  
  gtk_file_selection_complete (GTK_FILE_SELECTION (fdialog), 
				   PNG_EXTENSION);
}

static void fs_set_gifext (GtkWidget *widget, gpointer gdata)
{
  GtkWidget *fdialog;

  fdialog=(GtkWidget *)gdata;
  
  gtk_file_selection_complete (GTK_FILE_SELECTION (fdialog), 
				   GIF_EXTENSION);
}

static void fs_set_xpmext (GtkWidget *widget, gpointer gdata)
{
  GtkWidget *fdialog;

  fdialog=(GtkWidget *)gdata;
  
  gtk_file_selection_complete (GTK_FILE_SELECTION (fdialog), 
				   XPM_EXTENSION);
}


static void fs_set_menuext (GtkWidget *widget, gpointer gdata)
{
  GtkWidget *fdialog;

  fdialog=(GtkWidget *)gdata;
  
  gtk_file_selection_complete (GTK_FILE_SELECTION (fdialog), 
				   MENU_EXTENSION);
}


static void fs_set_rcext (GtkWidget *widget, gpointer gdata)
{
  GtkWidget *fdialog;

  fdialog=(GtkWidget *)gdata;
  
  gtk_file_selection_complete (GTK_FILE_SELECTION (fdialog), 
				   RC_EXTENSION);
}

static void fs_set_nkrext (GtkWidget *widget, gpointer gdata)
{
  GtkWidget *fdialog;

  fdialog=(GtkWidget *)gdata;
  
  gtk_file_selection_complete (GTK_FILE_SELECTION (fdialog), 
				   NKR_EXTENSION);
}

static void fs_set_bmpext (GtkWidget *widget, gpointer gdata)
{
  GtkWidget *fdialog;

  fdialog=(GtkWidget *)gdata;
  
  gtk_file_selection_complete (GTK_FILE_SELECTION (fdialog), 
				   BMP_EXTENSION);
}




// եΥޥåȤѹ
void ChangeMascotFS(GtkWidget *w, GtkFileSelection *fs)
{ 
  if(access(gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)),F_OK)==0){
    Mascot->file=g_strdup(
		     gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)));
      
    ChangeMascot();
  }
  else{
#ifdef GTK_MSG
    popup_message(POPUP_TIMEOUT*2,
		  _("Error: File cannot be opened."),
		  " ",
		  gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)),
		  NULL);
#else
    g_print (_("Cannot Open %s\n"),
	     gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)));
#endif
  }

  gtk_main_quit();
  gtk_widget_destroy(GTK_WIDGET(fs));
  
  Mascot->flag_menu=FALSE;
}


// եΤΤäꥭɤ߹
void NkrChangeMascotFS(GtkWidget *w, GtkFileSelection *fs)
{ 
  if(access(gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)),F_OK)==0){
    Mascot->inifile=g_strdup(
		     gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)));
      
    NkrChangeMascot();
  }
  else{
#ifdef GTK_MSG
    popup_message(POPUP_TIMEOUT*2,
		  _("Error: File cannot be opened."),
		  " ",
		  gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)),
		  NULL);
#else
    g_print (_("Cannot Open %s\n"),
	     gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)));
#endif
  }

  gtk_main_quit();
  gtk_widget_destroy(GTK_WIDGET(fs));
  
  create_save_mascot_dialog();
}


// եΥ˥塼ѹ
void ChangeMenuFS(GtkWidget *w, GtkFileSelection *fs)
{ 
  if(access(gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)),F_OK)==0){
    Mascot->menu_file=g_strdup(
	       gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)));
    gtk_widget_destroy(PopupMenu);
    ReadMenu(Mascot,0,NULL);
    PopupMenu=make_popup_menu();
  }
  else{
#ifdef GTK_MSG
    popup_message(POPUP_TIMEOUT*2,
		  _("Error: File cannot be opened."),
		  " ",
		  gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)),
		  NULL);
#else
    g_print (_("Cannot Open %s\n"),
	     gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)));
#endif
  }

  gtk_main_quit();
  gtk_widget_destroy(GTK_WIDGET(fs));
  
  Mascot->flag_menu=FALSE;
}


// ˥塼κ
void MakeMenuFS(GtkWidget *w, GtkFileSelection *fs)
{ 
  FILE *fp_test;

  if((fp_test=fopen(gtk_file_selection_get_filename(fs),"w"))!=NULL){
    fclose(fp_test);
    Mascot->menu_file=g_strdup(gtk_file_selection_get_filename(fs));

    Mascot->menu_cat[0]=g_strdup(TMP_CATEGORY_NAME);
    Mascot->menu_tgt_max[0]=1;

    Mascot->menu_tgt[0][0]
      =g_strdup(g_basename(Mascot->file));
    Mascot->menu_tgt_name[0][0]=ReadMascotName(Mascot, Mascot->file);

    Mascot->menu_cat_max=1;
    Mascot->menu_total=1;
    
    SaveMenu(Mascot);
    gtk_widget_destroy(PopupMenu);
    PopupMenu=make_popup_menu();

  }
  else{
#ifdef GTK_MSG
    popup_message(POPUP_TIMEOUT*2,
		  _("Error: File cannot be opened."),
		  " ",
		  gtk_file_selection_get_filename (fs),
		  NULL);
#else
    g_print (_("Cannot Open %s\n"),
	     gtk_file_selection_get_filename (fs));
#endif
  }

  gtk_main_quit();
  gtk_widget_destroy(GTK_WIDGET(fs));
  
  Mascot->flag_menu=FALSE;
 
}


// å˥塼ΥޥåȤѹ
void ChangeMascotMenu(GtkWidget *widget, gchar *mascotfile)
{ 
  Mascot->file=g_strdup(mascotfile);
  
  ChangeMascot();
}

// å˥塼ΥޥåȤΥƥ꡼ѹ
void CatRandomChangeMascotMenu(GtkWidget *widget, gpointer gdata)
{
  int i_cat,i_tgt;

  i_cat=(gint)gdata;
  
  i_tgt=RANDOM(Mascot->menu_tgt_max[i_cat]);
 
  Mascot->file=g_strdup(Mascot->menu_tgt[i_cat][i_tgt]);
      
  ChangeMascot();
}

// å˥塼ΥޥåȤѹ
void AllRandomChangeMascotMenu(GtkWidget *widget)
{

  Mascot->file=g_strdup(all_random_menu_mascot_file(Mascot));
  
  ChangeMascot();

}

// ¾̾ǥޥåȤ¸
void ConfirmSaveOther(GtkWidget *w, gpointer gdata)
{ 
  confSaveOther *cdata;

  cdata=(confSaveOther *)gdata;

  cdata->update=TRUE;

  gtk_main_quit();
  gtk_widget_destroy(GTK_WIDGET(cdata->dialog));
}

// ¾̾ǥޥåȤ¸
void ConfirmSaveRelease(GtkWidget *w, gpointer gdata)
{ 
  confSaveReleaseMascot *cdata;

  cdata=(confSaveReleaseMascot *)gdata;

  cdata->update=TRUE;

  gtk_main_quit();
  gtk_widget_destroy(GTK_WIDGET(cdata->dialog));
}


// եΥޥåȤ¸
void SaveMascotOther(GtkWidget *w, GtkFileSelection *fs)
{ 
  GtkWidget *dialog;
  GtkWidget *label;
  GtkWidget *button;
  confSaveOther *cdata;
  gchar *dest_file;
  gchar tmp_label[128];
  
  dest_file
    =g_strdup(gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)));

  gtk_widget_unmap(GTK_WIDGET(fs));
  

  if(access(dest_file,F_OK)==0){
    cdata=g_malloc0(sizeof(confSaveOther));

    dialog = gtk_dialog_new();
    gtk_container_border_width(GTK_CONTAINER(dialog),5);
    gtk_window_set_title(GTK_WINDOW(dialog),
			 _("File Save : Overwrite Confirmation"));
    
    sprintf(tmp_label,_("File %s already exists."),dest_file);
    label=gtk_label_new(tmp_label);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),
		       label,TRUE,TRUE,0);
    label=gtk_label_new(_("Overwrite?"));
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),
		       label,TRUE,TRUE,0);
    cdata->update=FALSE;
    cdata->dialog=dialog;
    
    button=gtk_button_new_with_label(_("OK"));
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		       button,TRUE,TRUE,0);
    gtk_signal_connect(GTK_OBJECT(button),"pressed",
		       GTK_SIGNAL_FUNC(ConfirmSaveOther), 
		       (gpointer)cdata);

    button=gtk_button_new_with_label(_("Cancel"));
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		       button,TRUE,TRUE,0);
    gtk_signal_connect(GTK_OBJECT(button),"pressed",
		       GTK_SIGNAL_FUNC(close_child_dialog), 
		       GTK_WIDGET(dialog));

    
    gtk_widget_show_all(dialog);
    gtk_main();
    
    if(cdata->update){
      Mascot->file=dest_file;
      SaveMascot(Mascot,FALSE);
    }

    g_free(cdata);
  }
  else{
    Mascot->file=dest_file;
    SaveMascot(Mascot,FALSE);
  }

  gtk_main_quit();
  gtk_widget_destroy(GTK_WIDGET(fs));
  Mascot->flag_menu=FALSE;
}

// ΤäꥭեѴ¸
void SaveNokkari(GtkWidget *w, GtkFileSelection *fs)
{ 
  GtkWidget *dialog;
  GtkWidget *label;
  GtkWidget *button;
  confSaveOther *cdata;
  gchar *dest_file;
  gchar tmp_label[128];
  
  dest_file
    =g_strdup(gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)));

  gtk_widget_unmap(GTK_WIDGET(fs));
  

  if(access(dest_file,F_OK)==0){
    cdata=g_malloc0(sizeof(confSaveOther));

    dialog = gtk_dialog_new();
    gtk_container_border_width(GTK_CONTAINER(dialog),5);
    gtk_window_set_title(GTK_WINDOW(dialog),
			 _("File Save : Overwrite Confirmation"));
    
    sprintf(tmp_label,_("File %s already exists."),dest_file);
    label=gtk_label_new(tmp_label);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),
		       label,TRUE,TRUE,0);
    label=gtk_label_new(_("Overwrite?"));
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),
		       label,TRUE,TRUE,0);
    cdata->update=FALSE;
    cdata->dialog=dialog;
    
    button=gtk_button_new_with_label(_("OK"));
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		       button,TRUE,TRUE,0);
    gtk_signal_connect(GTK_OBJECT(button),"pressed",
		       GTK_SIGNAL_FUNC(ConfirmSaveOther), 
		       (gpointer)cdata);

    button=gtk_button_new_with_label(_("Cancel"));
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		       button,TRUE,TRUE,0);
    gtk_signal_connect(GTK_OBJECT(button),"pressed",
		       GTK_SIGNAL_FUNC(close_child_dialog), 
		       GTK_WIDGET(dialog));

    
    gtk_widget_show_all(dialog);
    gtk_main();
    
    if(cdata->update){
      Mascot->inifile=dest_file;
      NkrSave(Mascot);
    }

    g_free(cdata);
  }
  else{
    Mascot->inifile=dest_file;
    NkrSave(Mascot);
  }

  gtk_main_quit();
  gtk_widget_destroy(GTK_WIDGET(fs));
  Mascot->flag_menu=FALSE;
}


// եΥ꡼ѥޥåȤ¸
void SaveReleaseMascot(GtkWidget *w, gpointer gdata)
{ 
  GtkWidget *dialog;
  GtkWidget *label;
  GtkWidget *button;
  confSaveReleaseMascot *cdata;
  gchar *dest_file;
  gchar tmp_label[128];
  gchar *tmp_file,*tmp_file1,*tmp_file2;
  int i_pix;
  
  cdata=(confSaveReleaseMascot *)gdata;

  dest_file
    =g_strdup(gtk_file_selection_get_filename(GTK_FILE_SELECTION(cdata->fdialog)));

  gtk_widget_unmap(GTK_WIDGET(cdata->fdialog));
  

  if(access(dest_file,F_OK)==0){

    dialog = gtk_dialog_new();
    gtk_container_border_width(GTK_CONTAINER(dialog),5);
    gtk_window_set_title(GTK_WINDOW(dialog),
			 _("File Save : Overwrite Confirmation"));
    
    sprintf(tmp_label,_("File %s already exists."),dest_file);
    label=gtk_label_new(tmp_label);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),
		       label,TRUE,TRUE,0);
    label=gtk_label_new(_("Overwrite?"));
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),
		       label,TRUE,TRUE,0);
    cdata->update=FALSE;
    cdata->dialog=dialog;
    
    button=gtk_button_new_with_label(_("OK"));
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		       button,TRUE,TRUE,0);
    gtk_signal_connect(GTK_OBJECT(button),"pressed",
		       GTK_SIGNAL_FUNC(ConfirmSaveRelease), 
		       (gpointer)cdata);

    button=gtk_button_new_with_label(_("Cancel"));
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		       button,TRUE,TRUE,0);
    gtk_signal_connect(GTK_OBJECT(button),"pressed",
		       GTK_SIGNAL_FUNC(close_child_dialog), 
		       GTK_WIDGET(dialog));

    
    gtk_widget_show_all(dialog);
    gtk_main();
    
    if(cdata->update){
      if(cdata->new_copyright){
	Mascot->copyright=g_strdup(cdata->new_copyright);
      }
      else{
	Mascot->copyright=NULL;
      }
      if(cdata->new_name){
	Mascot->name=g_strdup(cdata->new_name);
      }
      else{
	Mascot->name=NULL;
      }
      if(cdata->new_code){
	Mascot->code=g_strdup(cdata->new_code);
      }
      else{
	Mascot->code=NULL;
      }
      Mascot->file=dest_file;
      SaveMascot(Mascot,TRUE);
      SaveMascot(Mascot,FALSE);
      if(!cdata->font_flag){
	RemoveFontFromSaveData(Mascot,TRUE);
	RemoveFontFromSaveData(Mascot,FALSE);
      }

      tmp_file = g_strconcat(g_dirname(Mascot->file),"/",NULL);
      tmp_file1 = g_strconcat(g_get_home_dir(),"/",USER_DIR, NULL);
      tmp_file2 = g_strdup(COMMON_DIR);

      if((strcmp(tmp_file,tmp_file1)!=0)&&
	 (strcmp(tmp_file,tmp_file2)!=0)){
	for(i_pix=0;i_pix<Mascot->nPixmap;i_pix++){
	
	  tmp_file=g_strconcat(g_dirname(Mascot->file),"/",
			     g_basename(Mascot->sprites[i_pix].filename),
			     NULL);
	   
	  if(access(tmp_file,F_OK)!=0){
	    copy_file(Mascot->sprites[i_pix].filename,tmp_file);
	  }
	}
      }
    }
  }
  else{
    if(cdata->new_copyright){
      Mascot->copyright=g_strdup(cdata->new_copyright);
    }
    else{
      Mascot->copyright=NULL;
    }
    if(cdata->new_name){
      Mascot->name=g_strdup(cdata->new_name);
    }
    else{
      Mascot->name=NULL;
    }
    if(cdata->new_code){
      Mascot->code=g_strdup(cdata->new_code);
    }
    else{
      Mascot->code=NULL;
    }
    Mascot->file=dest_file;
    SaveMascot(Mascot,TRUE);
    SaveMascot(Mascot,FALSE);
    if(!cdata->font_flag){
      RemoveFontFromSaveData(Mascot,TRUE);
      RemoveFontFromSaveData(Mascot,FALSE);
    }

    tmp_file = g_strconcat(g_dirname(Mascot->file),"/",NULL);
    tmp_file1 = g_strconcat(g_get_home_dir(),"/",USER_DIR, NULL);
    tmp_file2 = g_strdup(COMMON_DIR);
    
    if((strcmp(tmp_file,tmp_file1)!=0)&&
       (strcmp(tmp_file,tmp_file2)!=0)){
      for(i_pix=0;i_pix<Mascot->nPixmap;i_pix++){
	
	tmp_file=g_strconcat(g_dirname(Mascot->file),"/",
			     g_basename(Mascot->sprites[i_pix].filename),
			     NULL);
	
	if(access(tmp_file,F_OK)!=0){
	  copy_file(Mascot->sprites[i_pix].filename,tmp_file);
	}
      }
    }
  }

  gtk_main_quit();
  gtk_widget_destroy(GTK_WIDGET(cdata->fdialog));
  Mascot->flag_menu=FALSE;
}


// ꡼ѥޥå¸ : CopyrightϽλ
void GoRelease(GtkWidget *w, gpointer gdata)
{ 
  confSaveReleaseMascot *cdata;

  cdata=(confSaveReleaseMascot *)gdata;

  cdata->update=TRUE;
  cdata->new_copyright=
    g_strdup(gtk_entry_get_text(GTK_ENTRY(cdata->copyright_entry)));
  cdata->new_name=
    g_strdup(gtk_entry_get_text(GTK_ENTRY(cdata->name_entry)));
  cdata->new_code=
    g_strdup(gtk_entry_get_text(GTK_ENTRY(cdata->code_entry)));
  cdata->font_flag=
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(cdata->font_check));

  gtk_main_quit();
  gtk_widget_destroy(GTK_WIDGET(cdata->dialog));
}


// եΥ˥塼¸
void SaveMenuOther(GtkWidget *w, GtkFileSelection *fs)
{ 
  GtkWidget *dialog;
  GtkWidget *label;
  GtkWidget *button;
  confSaveOther *cdata;
  gchar *dest_file;
  gchar tmp_label[128];
  
  dest_file
    =g_strdup(gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)));

  gtk_widget_unmap(GTK_WIDGET(fs));
  

  if(access(dest_file,F_OK)==0){
    cdata=g_malloc0(sizeof(confSaveOther));

    dialog = gtk_dialog_new();
    gtk_container_border_width(GTK_CONTAINER(dialog),5);
    gtk_window_set_title(GTK_WINDOW(dialog),
			 _("Menu Save : Overwrite Confirmation"));
    
    sprintf(tmp_label,_("Menu File %s already exists."),dest_file);
    label=gtk_label_new(tmp_label);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),
		       label,TRUE,TRUE,0);
    label=gtk_label_new(_("Overwrite?"));
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),
		       label,TRUE,TRUE,0);
    cdata->update=FALSE;
    cdata->dialog=dialog;
    
    button=gtk_button_new_with_label(_("OK"));
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		       button,TRUE,TRUE,0);
    gtk_signal_connect(GTK_OBJECT(button),"pressed",
		       GTK_SIGNAL_FUNC(ConfirmSaveOther), 
		       (gpointer)cdata);

    button=gtk_button_new_with_label(_("Cancel"));
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		       button,TRUE,TRUE,0);
    gtk_signal_connect(GTK_OBJECT(button),"pressed",
		       GTK_SIGNAL_FUNC(close_child_dialog), 
		       GTK_WIDGET(dialog));

    
    gtk_widget_show_all(dialog);
    gtk_main();
    
    if(cdata->update){
      Mascot->menu_file=dest_file;
      SaveMenu(Mascot);
    }

    g_free(cdata);
  }
  else{
    Mascot->menu_file=dest_file;
    SaveMenu(Mascot);
  }

  gtk_main_quit();
  gtk_widget_destroy(GTK_WIDGET(fs));
  Mascot->flag_menu=FALSE;
}



// եΥ꥽¸
void SaveRCOther(GtkWidget *w, GtkFileSelection *fs)
{ 
  GtkWidget *dialog;
  GtkWidget *label;
  GtkWidget *button;
  confSaveOther *cdata;
  gchar *dest_file;
  gchar tmp_label[128];
  
  dest_file
    =g_strdup(gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)));

  gtk_widget_unmap(GTK_WIDGET(fs));
  

  if(access(dest_file,F_OK)==0){
    cdata=g_malloc0(sizeof(confSaveOther));

    dialog = gtk_dialog_new();
    gtk_container_border_width(GTK_CONTAINER(dialog),5);
    gtk_window_set_title(GTK_WINDOW(dialog),
			 _("Resource Save : Overwrite Confirmation"));
    
    sprintf(tmp_label,_("Resource File %s already exists."),dest_file);
    label=gtk_label_new(tmp_label);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),
		       label,TRUE,TRUE,0);
    label=gtk_label_new(_("Overwrite?"));
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),
		       label,TRUE,TRUE,0);
    cdata->update=FALSE;
    cdata->dialog=dialog;
    
    button=gtk_button_new_with_label(_("OK"));
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		       button,TRUE,TRUE,0);
    gtk_signal_connect(GTK_OBJECT(button),"pressed",
		       GTK_SIGNAL_FUNC(ConfirmSaveOther), 
		       (gpointer)cdata);

    button=gtk_button_new_with_label(_("Cancel"));
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		       button,TRUE,TRUE,0);
    gtk_signal_connect(GTK_OBJECT(button),"pressed",
		       GTK_SIGNAL_FUNC(close_child_dialog), 
		       GTK_WIDGET(dialog));

    
    gtk_widget_show_all(dialog);
    gtk_main();
    
    if(cdata->update){
      Mascot->rcfile=dest_file;
      SaveRC(Mascot,FALSE);
    }

    g_free(cdata);
  }
  else{
    Mascot->rcfile=dest_file;
    SaveRC(Mascot,TRUE);
    SaveRC(Mascot,FALSE);
  }

  gtk_main_quit();
  gtk_widget_destroy(GTK_WIDGET(fs));
  Mascot->flag_menu=FALSE;
}


// եΥեȤѹ
void ChangeFontname(GtkWidget *w, gpointer gdata)
{ 
  confFont *cdata;
  cdata=(confFont *)gdata;

  cdata->fn=gtk_font_selection_dialog_get_font_name(cdata->fsd);
  if(cdata->fn){
    gtk_entry_set_text(GTK_ENTRY(cdata->entry),cdata->fn);
  }

  gtk_main_quit();
  gtk_widget_destroy(GTK_WIDGET(cdata->fsd));
}

// οѹ
void ChangeColor(GtkWidget *w, gpointer gdata)
{ 
  confColor *cdata;
  gdouble selcolor[4];
  cdata=(confColor *)gdata;
  
  gtk_color_selection_get_color(GTK_COLOR_SELECTION(cdata->csd->colorsel),
				selcolor);
  cdata->color->red=  selcolor[0]*0xFFFF;
  cdata->color->green=selcolor[1]*0xFFFF;
  cdata->color->blue= selcolor[2]*0xFFFF;
  gdk_color_alloc(gdk_colormap_get_system(),cdata->color);
  change_bgcolor(cdata->button,*cdata->color);

  cdata->update=TRUE;

  gtk_main_quit();
  gtk_widget_destroy(GTK_WIDGET(cdata->csd));
}

static void close_dialog(GtkWidget *w, GtkWidget *dialog)
{
  //gdk_pointer_ungrab(GDK_CURRENT_TIME);

  gtk_main_quit();
  gtk_widget_destroy(dialog);

  Mascot->flag_menu=FALSE;
}

static void close_cons(GtkWidget *w, GtkWidget *dialog)
{
  //gdk_pointer_ungrab(GDK_CURRENT_TIME);

  gtk_widget_destroy(dialog);
  gtk_main_quit();

  Mascot->flag_menu=FALSE;
}

static void ow_cons(GtkWidget *w, gpointer gdata)
{
  consType *cdata;

  cdata=(consType *)gdata;

  cdata->flag_auto=
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(cdata->auto_check));
  cdata->flag_ow=TRUE;
  
  gtk_widget_destroy(cdata->dialog);
  gtk_main_quit();

  Mascot->flag_menu=FALSE;
}


static void noow_cons(GtkWidget *w, gpointer gdata)
{
  consType *cdata;

  cdata=(consType *)gdata;

  cdata->flag_auto=
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(cdata->auto_check));
  cdata->flag_ow=FALSE;
  
  gtk_widget_destroy(cdata->dialog);
  gtk_main_quit();

  Mascot->flag_menu=FALSE;
}


static void close_new_mascot_dialog(GtkWidget *w, GtkWidget *dialog)
{
  //gdk_pointer_ungrab(GDK_CURRENT_TIME);

  gtk_main_quit();
  gtk_widget_destroy(dialog);
}

static void close_child_dialog(GtkWidget *w, GtkWidget *dialog)
{
  //gdk_pointer_ungrab(GDK_CURRENT_TIME);

  gtk_main_quit();
  gtk_widget_destroy(dialog);
}

gint close_popup(gpointer data)
{
  GtkWidget *dialog;

  dialog=(GtkWidget *)data;

  gtk_main_quit();
  gtk_widget_destroy(GTK_WIDGET(dialog));
}

static void destroy_popup(GtkWidget *w, gpointer data)
{
  guint timer;
  timer=(guint)data;

  gtk_timeout_remove((guint)timer);
  gtk_main_quit();
}

static void close_conf(GtkWidget *w, GtkWidget *dialog)
{
  //gdk_pointer_ungrab(GDK_CURRENT_TIME);

  if(flagChildDialog){
    return;
  }

  LoadPixmaps(win_main, Mascot->w_drawing, Mascot, Mascot->sprites);
  DrawMascot0(Mascot);

  // ƥɽShapeѤäΤб
  if(Mascot->clkmode==CLOCK_PIXMAP){ 
    DrawMascotWithDigit(Mascot);
  }
  else{
    DrawMascot(Mascot);
  }


  while (g_main_iteration(FALSE));
  gtk_widget_destroy(GTK_WIDGET(dialog));
  while (g_main_iteration(FALSE));
 
  flag_make_pixmap_list=FALSE;
  Mascot->flag_menu=FALSE;

  gdk_flush();
}


static void close_smenu(GtkWidget *w, GtkWidget *dialog)
{

  while (g_main_iteration(FALSE));
  gtk_widget_destroy(GTK_WIDGET(dialog));
  while (g_main_iteration(FALSE));
  if(selected_smenu==-1) gtk_main_quit();

  selected_smenu=-1;
}


// ޥåȥƥɽѥХå
void TestPut(GtkWidget *w, gpointer gdata)
{
  int i_pix;
  i_pix=(int)gdata;
  
  TestLoadPixmaps(&tmp_mascot,
		  tmp_pixfile[i_pix],
		  i_pix);
}

// ޥåȥƥɽѥХå Animationڡ
void TestPut2(GtkWidget *w, gpointer gdata)
{
  int *i_pix;

  i_pix=(int *)gdata;

  TestLoadPixmaps(&tmp_mascot,
	  tmp_pixfile[*i_pix],
          *i_pix);
}

// ޥåȥƥɽѥХå Animationڡ
void TestAnime(GtkWidget *w, gpointer gdata)
{
  int i_ptn, i_frm;
  int seqend;

  if(flagChildDialog){
    return;
  }
  else{
    flagChildDialog=TRUE;
  }

  i_ptn=(int)gdata;

  gtk_widget_set_sensitive(w, FALSE);
  
  i_frm=0;

  // ˥
  while(i_frm<tmp_mascot.frame_num[i_ptn]){
    TestLoadPixmaps(&tmp_mascot,
    	    tmp_pixfile[tmp_mascot.frame_pix[i_ptn][i_frm]],
    	    tmp_mascot.frame_pix[i_ptn][i_frm]);
    
    seqend=RANDOM(tmp_mascot.frame_max[i_ptn][i_frm]
		  -tmp_mascot.frame_min[i_ptn][i_frm]+1)
      +tmp_mascot.frame_min[i_ptn][i_frm];
    usleep(seqend*INTERVAL*1e3);

    // ֥å롼
    if((tmp_mascot.frame_loop[i_ptn][i_frm].next>=0)){
      tmp_mascot.frame_loop[i_ptn][i_frm].seq++;
      if(tmp_mascot.frame_loop[i_ptn][i_frm].seq==1){
	// ֥å롼׳
	tmp_mascot.frame_loop[i_ptn][i_frm].seqend=
	  RANDOM(tmp_mascot.frame_loop[i_ptn][i_frm].max
		 -tmp_mascot.frame_loop[i_ptn][i_frm].min+1)
	  +tmp_mascot.frame_loop[i_ptn][i_frm].min;
	       
	if(tmp_mascot.frame_loop[i_ptn][i_frm].seqend==1){
	  tmp_mascot.frame_loop[i_ptn][i_frm].seq=0;
	  i_frm++;
	}
	else{
	  i_frm=
	    tmp_mascot.frame_loop[i_ptn][i_frm].next;
	}
      }
      else if(tmp_mascot.frame_loop[i_ptn][i_frm].seqend-
	      tmp_mascot.frame_loop[i_ptn][i_frm].seq<=0){
	// ֥å롼׽λ
	tmp_mascot.frame_loop[i_ptn][i_frm].seq=0;
	i_frm++;
      }
      else{
	// ֥å롼׷³
	i_frm=
	  tmp_mascot.frame_loop[i_ptn][i_frm].next;
      }
    }
    else{
      i_frm++;
    }
  }

  TestLoadPixmaps(&tmp_mascot,
		  tmp_pixfile[tmp_mascot.frame_pix[0][0]],
		  tmp_mascot.frame_pix[0][0]);


  /*
  tmp_mascot.anime_seq++;
  if((seqend-tmp_mascot.anime_seq)<=0){
    //ե졼νλ
    tmp_mascot.anime_seq=0;
  
    if(i_frm>=tmp_mascot.frame_num[i_ptn]){
      //ѥνλ
      if(i_ptn==0){
	if(tmp_mascot.random_total==0){
	  // ॢ˥᤬ʤ ١Ƭ
	  i_frm=0;
	}
	else{
	  // ١νλ -> ѥؤΰܹ
	  i_ptn=weight_random(mascot);
	  i_frm=0;
	}
      }
      else{
	// ֤
	i_ptn=0;
	i_frm=0;
	if(flag_balloon==TRUE){
	  // Х롼󤬤ǤƤĤ
	  // å˥νλ
	    gtk_widget_unmap(balloon_main);
	    flag_balloon=FALSE;
	}
      }
    }
    else{
    //Υե졼ذܹ
    }
    seqend=
    RANDOM(tmp_mascot.frame_max[i_ptn][i_frm]
	     -tmp_mascot.frame_min[i_ptn][i_frm]+1)
      +tmp_mascot.frame_min[i_ptn][i_frm];
      }*/

  gtk_widget_set_sensitive(w, TRUE);
  flagChildDialog=FALSE;

}

// եPixmapɲ
void AddPixmap(GtkWidget *w, gpointer gdata)
{ 
  confAddPixmap *cdata;
#ifdef USE_GTK2
  int i_pix;
#endif

  cdata=(confAddPixmap *)gdata;


#ifdef USE_GTK2
  i_pix=0;
  while(gtk_file_selection_get_selections(cdata->fs)[i_pix]){
    if(access(gtk_file_selection_get_selections(cdata->fs)[i_pix],F_OK)==0){
      if(TestLoadPixmaps(&tmp_mascot,
			 gtk_file_selection_get_selections(cdata->fs)[i_pix],
			 tmp_mascot.nPixmap)){
	tmp_pixfile[tmp_mascot.nPixmap]
	  =g_strdup(gtk_file_selection_get_selections(cdata->fs)[i_pix]);
	tmp_mascot.nPixmap++;
    
	cdata->update=TRUE;
      }
      else{
#ifdef GTK_MSG
    popup_message(POPUP_TIMEOUT*2,
		  _("Error: File cannot be loaded."),
		  " ",
		  gtk_file_selection_get_selections(cdata->fs)[i_pix],
		  NULL);
#else
	g_print (_("Cannot Load %s\n"),
		 gtk_file_selection_get_selections(cdata->fs)[i_pix]);
#endif
      }
    }
    else{
#ifdef GTK_MSG
    popup_message(POPUP_TIMEOUT*2,
		  _("Error: File cannot be opened."),
		  " ",
		  gtk_file_selection_get_selections(cdata->fs)[i_pix],
		  NULL);
#else
      g_print (_("Cannot Open %s\n"),
	       gtk_file_selection_get_selections(cdata->fs)[i_pix]);
#endif
    }

    if(tmp_mascot.nPixmap>=MAX_PIXMAP-1) break;
    i_pix++;
  }
#else
  if(access(gtk_file_selection_get_filename(cdata->fs),F_OK)==0){
    if(TestLoadPixmaps(&tmp_mascot,
		       gtk_file_selection_get_filename(cdata->fs),
		       tmp_mascot.nPixmap)){
      tmp_pixfile[tmp_mascot.nPixmap]
	=g_strdup(gtk_file_selection_get_filename(cdata->fs));
      tmp_mascot.nPixmap++;
    
      cdata->update=TRUE;
    }
    else{
#ifdef GTK_MSG
    popup_message(POPUP_TIMEOUT*2,
		  _("Error: File cannot be loaded."),
		  " ",
		  gtk_file_selection_get_filename (cdata->fs),
		  NULL);
#else
      g_print (_("Cannot Load %s\n"),
	       gtk_file_selection_get_filename (cdata->fs));
#endif
    }

  }
  else{
#ifdef GTK_MSG
    popup_message(POPUP_TIMEOUT*2,
		  _("Error: File cannot be opened."),
		  " ",
		  gtk_file_selection_get_filename (cdata->fs),
		  NULL);
#else
    g_print (_("Cannot Open %s\n"),
	     gtk_file_selection_get_filename (cdata->fs));
#endif
  }
#endif
  
  gtk_main_quit();
  gtk_widget_destroy(GTK_WIDGET(cdata->fs));
}


// Pixmap
void DelPixmap(GtkWidget *w, gpointer gdata)
{ 
  confDelPixmap *cdata;
  int i_ptn, i_frm;

  cdata=(confDelPixmap *)gdata;

  for(i_ptn=0;i_ptn<MAX_ANIME_PATTERN;i_ptn++){
    for(i_frm=0;i_frm<MAX_ANIME_FRAME;i_frm++){
      if(tmp_mascot.frame_pix[i_ptn][i_frm]==cdata->del_pix){
	cdata->hit_ptn=i_ptn;
	cdata->hit_frm=i_frm;
	break;
      }
    }
    if(cdata->hit_ptn!=-1) break;
  }

  if(cdata->hit_ptn==-1) cdata->update=TRUE;
  
	 
  gtk_main_quit();
  gtk_widget_destroy(GTK_WIDGET(cdata->dd));
}


// Patternɲ/
void AddDelPattern(GtkWidget *w, gpointer gdata)
{ 
  confPattern *cdata;

  cdata=(confPattern *)gdata;

  cdata->update=TRUE;
	 
  gtk_main_quit();
  gtk_widget_destroy(GTK_WIDGET(cdata->pd));
}


// Pattern򥳥ԡ
void CopyPattern(GtkWidget *w, gpointer gdata)
{ 
  confPatternCopy *cdata;

  cdata=(confPatternCopy *)gdata;

  cdata->update=TRUE;
	 
  gtk_main_quit();
  gtk_widget_destroy(GTK_WIDGET(cdata->pd));
}


// Frameɲ/
void AddDelFrame(GtkWidget *w, gpointer gdata)
{ 
  confFrame *cdata;

  cdata=(confFrame *)gdata;

  cdata->update=TRUE;
	 
  gtk_main_quit();
  gtk_widget_destroy(GTK_WIDGET(cdata->fd));
}


// եPixmapѹ
void ChangePixmap(GtkWidget *w, gpointer gdata)
{ 
  confChangePixmap *cdata;

  cdata=(confChangePixmap *)gdata;

  if(access(gtk_file_selection_get_filename(cdata->fs),F_OK)==0){
    if(TestLoadPixmaps(&tmp_mascot,
		       gtk_file_selection_get_filename(cdata->fs),
		       cdata->i_pix)){
      tmp_pixfile[cdata->i_pix]
	=g_strdup(gtk_file_selection_get_filename(cdata->fs));
    
      cdata->update=TRUE;
    }
    else{
#ifdef GTK_MSG
    popup_message(POPUP_TIMEOUT*2,
		  _("Error: File cannot be loaded."),
		  " ",
		  gtk_file_selection_get_filename (cdata->fs),
		  NULL);
#else
      g_print (_("Cannot Load %s\n"),
	       gtk_file_selection_get_filename (cdata->fs));
#endif
    }

  }
  else{
#ifdef GTK_MSG
    popup_message(POPUP_TIMEOUT*2,
		  _("Error: File cannot be opened."),
		  " ",
		  gtk_file_selection_get_filename (cdata->fs),
		  NULL);
#else
    g_print (_("Cannot Open %s\n"),
	     gtk_file_selection_get_filename (cdata->fs));
#endif
  }
  
  gtk_main_quit();
  gtk_widget_destroy(GTK_WIDGET(cdata->fs));
}


// Τäꥭ եPixmap
void NkrChangePixmap(GtkWidget *w, gpointer gdata)
{ 
  confNkrChangePixmap *cdata;

  cdata=(confNkrChangePixmap  *)gdata;

  if(access(gtk_file_selection_get_filename(cdata->fs),F_OK)==0){
    cdata->filename
      =g_strdup(gtk_file_selection_get_filename(cdata->fs));
    
    cdata->update=TRUE;
  }
  else{
#ifdef GTK_MSG
    popup_message(POPUP_TIMEOUT*2,
		  _("Error: File cannot be opened."),
		  " ",
		  gtk_file_selection_get_filename (cdata->fs),
		  NULL);
#else
    g_print (_("Cannot Open %s\n"),
	     gtk_file_selection_get_filename (cdata->fs));
#endif
  }
  
  gtk_main_quit();
  gtk_widget_destroy(GTK_WIDGET(cdata->fs));
}


// եBiff Pixmapѹ
void ChangeBiffPixmap(GtkWidget *w, gpointer gdata)
{ 
  confChangeBiffPixmap *cdata;

  cdata=(confChangeBiffPixmap *)gdata;

  if(access(gtk_file_selection_get_filename(cdata->fs),F_OK)==0){
    tmp_mascot.mail.pix_file
      =g_strdup(FullPathPixmapFile(&tmp_mascot,
	   gtk_file_selection_get_filename(cdata->fs)));
      cdata->update=TRUE;
  }
  else{
#ifdef GTK_MSG
    popup_message(POPUP_TIMEOUT*2,
		  _("Error: File cannot be opened."),
		  " ",
		  gtk_file_selection_get_filename (cdata->fs),
		  NULL);
#else
    g_print (_("Cannot Open %s\n"),
	     gtk_file_selection_get_filename (cdata->fs));
#endif
  }
  
  gtk_main_quit();
  gtk_widget_destroy(GTK_WIDGET(cdata->fs));
}


// եTargetѹ
void ChangeTgt(GtkWidget *w, gpointer gdata)
{ 
  confChangeTgt *cdata;

  cdata=(confChangeTgt *)gdata;

  if(access(gtk_file_selection_get_filename(cdata->fs),F_OK)==0){
    tmp_mascot.menu_tgt[cdata->i_cat][cdata->i_tgt]
      =g_strdup(g_basename(gtk_file_selection_get_filename(cdata->fs)));
    
      cdata->update=TRUE;
  }
  else{
#ifdef GTK_MSG
    popup_message(POPUP_TIMEOUT*2,
		  _("Error: File cannot be opened."),
		  " ",
		  gtk_file_selection_get_filename (cdata->fs),
		  NULL);
#else
    g_print (_("Cannot Open %s\n"),
	     gtk_file_selection_get_filename (cdata->fs));
#endif
  }
  
  gtk_main_quit();
  gtk_widget_destroy(GTK_WIDGET(cdata->fs));
}

// եΥ˥塼εۼ
void MergeCatFS(GtkWidget *w, gpointer gdata)
{ 
  confMergeCat *cdata;
  gchar *merge_file;
  gint menu_cat_max_old;

#ifdef USE_GTK2
  int i_menu;
#endif

  cdata=(confMergeCat *)gdata;

#ifdef USE_GTK2
  i_menu=0;
  while(gtk_file_selection_get_selections(cdata->fs)[i_menu]){
    if(access(gtk_file_selection_get_selections(GTK_FILE_SELECTION(cdata->fs))[i_menu],
	    F_OK)==0){
      merge_file=g_strdup(
	gtk_file_selection_get_selections(GTK_FILE_SELECTION(cdata->fs))[i_menu]);
      gtk_widget_destroy(PopupMenu);
      menu_cat_max_old=tmp_mascot.menu_cat_max;
      ReadMenu(&tmp_mascot,tmp_mascot.menu_cat_max,merge_file);
      if(tmp_mascot.menu_cat_max>MAX_MENU_CATEGORY){
        tmp_mascot.menu_cat_max=menu_cat_max_old;
      }

      cdata->update=TRUE;
    }
    else{
#ifdef GTK_MSG
    popup_message(POPUP_TIMEOUT*2,
		  _("Error: File cannot be opened."),
		  " ",
		  gtk_file_selection_get_filename(GTK_FILE_SELECTION(cdata->fs))[i_menu],
		  NULL);
#else
      g_print(_("Cannot Open %s\n"),
	      gtk_file_selection_get_filename(GTK_FILE_SELECTION(cdata->fs))[i_menu]);
#endif
    }

    if(tmp_mascot.menu_cat_max>=MAX_MENU_CATEGORY) break;
    i_menu++;
  }
  if(cdata->update) PopupMenu=make_popup_menu();
#else
  if(access(gtk_file_selection_get_filename(GTK_FILE_SELECTION(cdata->fs)),
	    F_OK)==0){
    merge_file=g_strdup(
	gtk_file_selection_get_filename(GTK_FILE_SELECTION(cdata->fs)));
    gtk_widget_destroy(PopupMenu);
    ReadMenu(&tmp_mascot,tmp_mascot.menu_cat_max,merge_file);
    PopupMenu=make_popup_menu();

    cdata->update=TRUE;
  }
  else{
#ifdef GTK_MSG
    popup_message(POPUP_TIMEOUT*2,
		  _("Error: File cannot be opened."),
		  " ",
		  gtk_file_selection_get_filename (GTK_FILE_SELECTION (cdata->fs)),
		  NULL);
#else
    g_print (_("Cannot Open %s\n"),
	     gtk_file_selection_get_filename (GTK_FILE_SELECTION (cdata->fs)));
#endif
  }
#endif

  gtk_main_quit();
  gtk_widget_destroy(GTK_WIDGET(cdata->fs));
 
}




// Target
void DelTgt(GtkWidget *w, gpointer gdata)
{ 
  confDelTgt *cdata;

  cdata=(confDelTgt *)gdata;

  cdata->update=TRUE;
  
  gtk_main_quit();
  gtk_widget_destroy(GTK_WIDGET(cdata->dd));
}


// Categoryɲ/
void AddDelCat(GtkWidget *w, gpointer gdata)
{ 
  confCat *cdata;

  cdata=(confCat *)gdata;

  cdata->update=TRUE;
	 
  gtk_main_quit();
  gtk_widget_destroy(GTK_WIDGET(cdata->pd));
}


// եClick Soundѹ
void ChangeDuetTgt(GtkWidget *w, gpointer gdata)
{ 
  confChangeDuetTgt *cdata;

  cdata=(confChangeDuetTgt *)gdata;

  if(access(gtk_file_selection_get_filename(cdata->fs),F_OK)==0){
    tmp_mascot.duet_tgt[cdata->i_ptn]
      =g_strdup(g_basename(FullPathMascotFile(&tmp_mascot,
					     gtk_file_selection_get_filename(cdata->fs))));
      cdata->update=TRUE;
  }
  else{
#ifdef GTK_MSG
    popup_message(POPUP_TIMEOUT*2,
		  _("Error: File cannot be opened."),
		  " ",
		  gtk_file_selection_get_filename (cdata->fs),
		  NULL);
#else
    g_print (_("Cannot Open %s\n"),
	     gtk_file_selection_get_filename (cdata->fs));
#endif
  }
  
  gtk_main_quit();
  gtk_widget_destroy(GTK_WIDGET(cdata->fs));
}


void ChangeClickSound(GtkWidget *w, gpointer gdata)
{ 
  confChangeClickSound *cdata;

  cdata=(confChangeClickSound *)gdata;

  if(access(gtk_file_selection_get_filename(cdata->fs),F_OK)==0){
    tmp_mascot.click_sound[cdata->i_ptn]
      =g_strdup(g_basename(FullPathSoundFile(&tmp_mascot,
					     gtk_file_selection_get_filename(cdata->fs))));
      cdata->update=TRUE;
  }
  else{
#ifdef GTK_MSG
    popup_message(POPUP_TIMEOUT*2,
		  _("Error: File cannot be opened."),
		  " ",
		  gtk_file_selection_get_filename (cdata->fs),
		  NULL);
#else
    g_print (_("Cannot Open %s\n"),
	     gtk_file_selection_get_filename (cdata->fs));
#endif
  }
  
  gtk_main_quit();
  gtk_widget_destroy(GTK_WIDGET(cdata->fs));
}


// եBiff Soundѹ
void ChangeBiffSound(GtkWidget *w, gpointer gdata)
{ 
  confChangeBiffSound *cdata;

  cdata=(confChangeBiffSound *)gdata;

  if(access(gtk_file_selection_get_filename(cdata->fs),F_OK)==0){
    tmp_mascot.mail.sound
      =g_strdup(g_basename(FullPathSoundFile(&tmp_mascot,
					     gtk_file_selection_get_filename(cdata->fs))));
      cdata->update=TRUE;
  }
  else{
#ifdef GTK_MSG
    popup_message(POPUP_TIMEOUT*2,
		  _("Error: File cannot be opened."),
		  " ",
		  gtk_file_selection_get_filename (cdata->fs),
		  NULL);
#else
    g_print (_("Cannot Open %s\n"),
	     gtk_file_selection_get_filename (cdata->fs));
#endif
  }
  
  gtk_main_quit();
  gtk_widget_destroy(GTK_WIDGET(cdata->fs));
}


// եMailȥեѹ
void ChangeMailFile(GtkWidget *w, gpointer gdata)
{ 
  confMailFile *cdata;

  cdata=(confMailFile *)gdata;

  if(access(gtk_file_selection_get_filename(cdata->fs),F_OK)==0){
    tmp_mascot.mail.file
      =g_strdup(gtk_file_selection_get_filename(cdata->fs));
    cdata->update=TRUE;
  }
  else{
#ifdef GTK_MSG
    popup_message(POPUP_TIMEOUT*2,
		  _("Error: File cannot be opened."),
		  " ",
		  gtk_file_selection_get_filename (cdata->fs),
		  NULL);
#else
    g_print (_("Cannot Open %s\n"),
	     gtk_file_selection_get_filename (cdata->fs));
#endif
  }
  
  gtk_main_quit();
  gtk_widget_destroy(GTK_WIDGET(cdata->fs));
}




static void create_change_image_dialog(GtkWidget *w, gpointer gdata)
{
  GtkWidget *fdialog;
  GtkWidget *button;
  GtkWidget *hbox;
  confChangePixmap *cdata;
  char win_title[64];

  if(flagChildDialog){
    return;
  }
  else{
    flagChildDialog=TRUE;
  }

  cdata=g_malloc0(sizeof(confChangePixmap));

  cdata->i_pix=(int)gdata;

  // WinۤϽŤΤExpose٥򤹤٤ƽƤ
  while (g_main_iteration(FALSE));

  sprintf(win_title,_("Select New Image for No.%02d"),
	  cdata->i_pix);
  fdialog = gtk_file_selection_new(_(win_title));
  
  cdata->fs=GTK_FILE_SELECTION(fdialog);
  cdata->update=FALSE;
  
  gtk_signal_connect(GTK_OBJECT(fdialog),"destroy",
		     GTK_SIGNAL_FUNC(close_child_dialog), 
		     GTK_WIDGET(fdialog));
  
  gtk_signal_connect(
		     GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->ok_button),
		     "clicked", 
		     GTK_SIGNAL_FUNC(ChangePixmap), (gpointer)cdata);
  
  gtk_signal_connect(
		     GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->cancel_button),
		     "clicked", 
		     GTK_SIGNAL_FUNC(close_child_dialog), 
		     GTK_WIDGET(fdialog));

  gtk_file_selection_set_filename (GTK_FILE_SELECTION (fdialog), 
  				   tmp_pixfile[cdata->i_pix]);
  gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (fdialog));


  hbox = gtk_hbox_new(FALSE,5);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
  gtk_box_pack_start(GTK_BOX(GTK_FILE_SELECTION(fdialog)->action_area),
		     hbox,FALSE,FALSE,0);

  
  button=gtk_button_new_with_label(_("User Pix Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_updir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(_("Common Pix Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_dpdir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(PNG_EXTENSION);
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_pngext), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(GIF_EXTENSION);
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_gifext), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(XPM_EXTENSION);
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_xpmext), 
		     (gpointer)fdialog);


  gtk_widget_show_all(fdialog);
  
  gtk_main();

  if(cdata->update){
    gtk_entry_set_text(GTK_ENTRY(pixmap_entry[cdata->i_pix]),
		       g_basename(tmp_pixfile[cdata->i_pix]));
    
  }

  flagChildDialog=FALSE;
  g_free(cdata);
}


gchar* create_nkr_change_image_dialog
(gchar *lost_filename, int i_pix)
{
  GtkWidget *fdialog;
  GtkWidget *button;
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *label;
  confNkrChangePixmap *cdata;
  char win_title[64];

  if(flagChildDialog){
    return;
  }
  else{
    flagChildDialog=TRUE;
  }

  cdata=g_malloc0(sizeof(confNkrChangePixmap));

  cdata->filename=NULL;

  // WinۤϽŤΤExpose٥򤹤٤ƽƤ
  while (g_main_iteration(FALSE));

  sprintf(win_title,_("Select New Image for No.%02d"),i_pix);
  fdialog = gtk_file_selection_new(_(win_title));
  
  cdata->fs=GTK_FILE_SELECTION(fdialog);
  cdata->update=FALSE;
  
  gtk_signal_connect(GTK_OBJECT(fdialog),"destroy",
		     GTK_SIGNAL_FUNC(close_child_dialog), 
		     GTK_WIDGET(fdialog));
  
  gtk_signal_connect(
		     GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->ok_button),
		     "clicked", 
		     GTK_SIGNAL_FUNC(NkrChangePixmap), (gpointer)cdata);
  
  gtk_signal_connect(
		     GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->cancel_button),
		     "clicked", 
		     GTK_SIGNAL_FUNC(close_child_dialog), 
		     GTK_WIDGET(fdialog));

  gtk_file_selection_set_filename (GTK_FILE_SELECTION (fdialog), 
  				   lost_filename);
  gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (fdialog));


  vbox = gtk_vbox_new(FALSE,5);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);
  gtk_box_pack_start(GTK_BOX(GTK_FILE_SELECTION(fdialog)->action_area),
		     vbox,FALSE,FALSE,0);

  label=gtk_label_new(_("The image described in INI cannot be found."));
  gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);

  sprintf(win_title,_("Please select the image File for No.%d."),i_pix);
  label=gtk_label_new(win_title);
  gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);

  hbox = gtk_hbox_new(FALSE,5);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
  gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);

  
  button=gtk_button_new_with_label(_("User Pix Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_updir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(_("Common Pix Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_dpdir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(BMP_EXTENSION);
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_bmpext), 
		     (gpointer)fdialog);

  gtk_widget_show_all(fdialog);
  
  gtk_main();

  flagChildDialog=FALSE;

  return(cdata->filename);
}


static void create_change_biff_image_dialog(GtkWidget *w, gpointer gdata)
{
  GtkWidget *fdialog;
  GtkWidget *button;
  GtkWidget *hbox;
  GtkWidget *pix_entry;
  confChangeBiffPixmap *cdata;

  if(flagChildDialog){
    return;
  }
  else{
    flagChildDialog=TRUE;
  }

  cdata=g_malloc0(sizeof(confChangeBiffPixmap));

  pix_entry=(GtkWidget *)gdata;

  // WinۤϽŤΤExpose٥򤹤٤ƽƤ
  while (g_main_iteration(FALSE));

  fdialog = gtk_file_selection_new(_("Select New Image for Biff"));
  
  cdata->fs=GTK_FILE_SELECTION(fdialog);
  cdata->update=FALSE;
  
  gtk_signal_connect(GTK_OBJECT(fdialog),"destroy",
		     GTK_SIGNAL_FUNC(close_child_dialog), 
		     GTK_WIDGET(fdialog));
  
  gtk_signal_connect(
		     GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->ok_button),
		     "clicked", 
		     GTK_SIGNAL_FUNC(ChangeBiffPixmap), (gpointer)cdata);
  
  gtk_signal_connect(
		     GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->cancel_button),
		     "clicked", 
		     GTK_SIGNAL_FUNC(close_child_dialog), 
		     GTK_WIDGET(fdialog));

  if(tmp_mascot.mail.pix_file){
    gtk_file_selection_set_filename (GTK_FILE_SELECTION (fdialog), 
				     tmp_mascot.mail.pix_file);
  }
  else{
    gtk_file_selection_set_filename (GTK_FILE_SELECTION (fdialog), 
				     g_strconcat(g_get_home_dir(),"/",
						 USER_DIR,PIXDIR, NULL));
    gtk_file_selection_complete (GTK_FILE_SELECTION (fdialog), 
				 "*");
  }
  gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (fdialog));


  hbox = gtk_hbox_new(FALSE,5);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
  gtk_box_pack_start(GTK_BOX(GTK_FILE_SELECTION(fdialog)->action_area),
		     hbox,FALSE,FALSE,0);

  
  button=gtk_button_new_with_label(_("User Pix Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_updir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(_("Common Pix Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_dpdir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(PNG_EXTENSION);
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_pngext), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(GIF_EXTENSION);
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_gifext), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(XPM_EXTENSION);
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_xpmext), 
		     (gpointer)fdialog);

  gtk_widget_show_all(fdialog);
  
  gtk_main();

  if(cdata->update){
    gtk_entry_set_text(GTK_ENTRY(pix_entry),
		       g_basename(tmp_mascot.mail.pix_file));
    
  }

  flagChildDialog=FALSE;
  g_free(cdata);
}


static void create_add_image_dialog(GtkWidget *w, gpointer gdata)
{
  GtkWidget *scrwin;
  GtkWidget *fdialog;
  GtkWidget *button;
  GtkWidget *hbox;
  confAddPixmap *cdata;
  char win_title[64];

  if(flagChildDialog){
    return;
  }
  else{
    flagChildDialog=TRUE;
  }

  if(tmp_mascot.nPixmap>=MAX_PIXMAP-1){
    popup_message(POPUP_TIMEOUT,
		  _("Error: Append Image."),
		  " ",
		  _("The number of images maxes out."),
		  NULL);
    return;
  }
  

  scrwin=(GtkWidget *)gdata;

  cdata=g_malloc0(sizeof(confAddPixmap));

  // WinۤϽŤΤExpose٥򤹤٤ƽƤ
  while (g_main_iteration(FALSE));

  sprintf(win_title,_("Select New Image for No.%02d"),
			       tmp_mascot.nPixmap);
  fdialog = gtk_file_selection_new(_(win_title));
#ifdef USE_GTK2
  gtk_file_selection_set_select_multiple(GTK_FILE_SELECTION(fdialog),TRUE);
#endif

  cdata->fs=GTK_FILE_SELECTION(fdialog);
  cdata->update=FALSE;

  gtk_signal_connect(GTK_OBJECT(fdialog),"destroy",
		     GTK_SIGNAL_FUNC(close_child_dialog), 
		     GTK_WIDGET(fdialog));
  
  gtk_signal_connect(
     GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->ok_button),
     "clicked", 
     GTK_SIGNAL_FUNC(AddPixmap), (gpointer)cdata);

  gtk_signal_connect(
     GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->cancel_button),
     "clicked", 
     GTK_SIGNAL_FUNC(close_child_dialog), 
     GTK_WIDGET(fdialog));

  gtk_file_selection_set_filename (GTK_FILE_SELECTION (fdialog), 
  				   tmp_pixfile[tmp_mascot.nPixmap-1]);
  //gtk_file_selection_complete (GTK_FILE_SELECTION (fdialog), 
  //				   MASCOT_EXTENSION);
  gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (fdialog));


  hbox = gtk_hbox_new(FALSE,5);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
  gtk_box_pack_start(GTK_BOX(GTK_FILE_SELECTION(fdialog)->action_area),
		     hbox,FALSE,FALSE,0);

  
  button=gtk_button_new_with_label(_("User Pix Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_updir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(_("Common Pix Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_dpdir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(PNG_EXTENSION);
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_pngext), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(GIF_EXTENSION);
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_gifext), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(XPM_EXTENSION);
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_xpmext), 
		     (gpointer)fdialog);

  gtk_widget_show_all(fdialog);
  
  gtk_main();

  if(cdata->update){
    make_pixmap_list(scrwin);
  }

  flagChildDialog=FALSE;
  g_free(cdata);
}


static void create_del_image_dialog(GtkWidget *w, gpointer gdata)
{
  GtkWidget *scrwin;
  GtkWidget *deldialog;
  GtkWidget *button;
  GtkWidget *label;
  GtkAdjustment *adj;
  GtkWidget *spinner;
  GtkWidget *hbox;
  confDelPixmap *cdata;
  gchar tmp_label[128];
  int i_pix, i_ptn, i_frm;

  
 

  if(flagChildDialog){
    return;
  }
  else{
    flagChildDialog=TRUE;
  }

  scrwin=(GtkWidget *)gdata;
  cdata=g_malloc0(sizeof(confDelPixmap));

  cdata->del_pix=tmp_mascot.nPixmap-1;
  cdata->hit_ptn=-1;
  cdata->hit_frm=-1;
  cdata->update=FALSE;

  deldialog = gtk_dialog_new();
  gtk_container_border_width(GTK_CONTAINER(deldialog),5);
  gtk_window_set_title(GTK_WINDOW(deldialog),_("Select Image No. to Delete"));

  cdata->dd=deldialog;

  hbox=gtk_hbox_new(FALSE,0);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(deldialog)->vbox),
		     hbox,TRUE,TRUE,0);

  label=gtk_label_new(_("Delete Image No."));
  gtk_box_pack_start(GTK_BOX(hbox),label,TRUE,TRUE,0);

  adj = (GtkAdjustment *)gtk_adjustment_new 
    ((gfloat)tmp_mascot.nPixmap-1, 0,(gfloat)tmp_mascot.nPixmap-1,
     1.0, 1.0, 0.0);
  gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
		      GTK_SIGNAL_FUNC (cc_get_adj),
		      &cdata->del_pix);
  spinner =  gtk_spin_button_new (adj, 0, 0);
  gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), FALSE);
  gtk_box_pack_start(GTK_BOX(hbox), spinner,FALSE, FALSE, 0);
  gtk_entry_set_editable(GTK_ENTRY(&GTK_SPIN_BUTTON(spinner)->entry),
			 FALSE);
  

  button=gtk_button_new_with_label(_("OK"));
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(deldialog)->action_area),
		     button,TRUE,TRUE,0);
  gtk_signal_connect(GTK_OBJECT(button),"pressed",
		     GTK_SIGNAL_FUNC(DelPixmap), 
		     (gpointer)cdata);
  
  button=gtk_button_new_with_label(_("Cancel"));
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(deldialog)->action_area),
		     button,TRUE,TRUE,0);
  gtk_signal_connect(GTK_OBJECT(button),"pressed",
		     GTK_SIGNAL_FUNC(close_child_dialog), 
		     GTK_WIDGET(deldialog));

  
  gtk_widget_show_all(deldialog);
  gtk_main();

  if(cdata->update){

    for(i_ptn=0;i_ptn<MAX_ANIME_PATTERN;i_ptn++){
      for(i_frm=0;i_frm<MAX_ANIME_FRAME;i_frm++){
	if(tmp_mascot.frame_pix[i_ptn][i_frm]>cdata->del_pix){
	  tmp_mascot.frame_pix[i_ptn][i_frm]--;
	}
      }
    }

    for(i_pix=cdata->del_pix;i_pix<tmp_mascot.nPixmap-1;i_pix++){
      tmp_pixfile[i_pix]=tmp_pixfile[i_pix+1];
    }
    tmp_pixfile[tmp_mascot.nPixmap-1]=NULL;
    tmp_mascot.nPixmap--;
  
    make_pixmap_list(scrwin);
  }
  else if(cdata->hit_ptn!=-1){
    deldialog = gtk_dialog_new();
    gtk_container_border_width(GTK_CONTAINER(deldialog),5);
    gtk_window_set_title(GTK_WINDOW(deldialog),
			 _("Error : Delete Image."));

    sprintf(tmp_label,_("Image %02d is used in Pattern %02d / Frame %02d\n"),
	    cdata->del_pix,cdata->hit_ptn,cdata->hit_frm);
    label=gtk_label_new(tmp_label);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(deldialog)->vbox),
		       label,TRUE,TRUE,0);
    label=gtk_label_new(_("Please Change..."));
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(deldialog)->vbox),
		       label,TRUE,TRUE,0);

    button=gtk_button_new_with_label(_("OK"));
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(deldialog)->action_area),
		       button,TRUE,TRUE,0);
    gtk_signal_connect(GTK_OBJECT(button),"pressed",
		       GTK_SIGNAL_FUNC(close_child_dialog), 
		       GTK_WIDGET(deldialog));

    gtk_widget_show_all(deldialog);
    gtk_main();

  }

  g_free(cdata);
  flagChildDialog=FALSE;
}


static void create_add_pattern_dialog(GtkWidget *w, gpointer gdata)
{
  GtkWidget *ptn_note;
  GtkWidget *dialog;
  GtkWidget *button;
  GtkWidget *label;
  GtkAdjustment *adj;
  GtkWidget *spinner;
  GtkWidget *hbox;
  confPattern *cdata;
  int i_ptn,i_frm;

  if(flagChildDialog){
    return;
  }
  else{
    flagChildDialog=TRUE;
  }

  if(pattern_num>=MAX_ANIME_PATTERN){
    popup_message(POPUP_TIMEOUT,
		  _("Error: Append Pattern."),
		  " ",
		  _("The number of patterns maxes out."),
		  NULL);
    return;
  }

  ptn_note=(GtkWidget *)gdata;

  cdata=g_malloc0(sizeof(confPattern));

  cdata->dest_ptn=pattern_num;
  cdata->update=FALSE;

  dialog = gtk_dialog_new();
  gtk_container_border_width(GTK_CONTAINER(dialog),5);
  gtk_window_set_title(GTK_WINDOW(dialog),_("Select Pattern No. to Append"));
  
  cdata->pd=dialog;
  
  hbox=gtk_hbox_new(FALSE,0);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),
		     hbox,TRUE,TRUE,0);

  label=gtk_label_new(_("Append Pattern No."));
  gtk_box_pack_start(GTK_BOX(hbox),label,TRUE,TRUE,0);

  adj = (GtkAdjustment *)gtk_adjustment_new 
    ((gfloat)pattern_num, 1,(gfloat)pattern_num,1.0, 1.0, 0.0);
  gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
		      GTK_SIGNAL_FUNC (cc_get_adj),
		      &cdata->dest_ptn);
  spinner =  gtk_spin_button_new (adj, 0, 0);
  gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), FALSE);
  gtk_box_pack_start(GTK_BOX(hbox), spinner,FALSE, FALSE, 0);
  gtk_entry_set_editable(GTK_ENTRY(&GTK_SPIN_BUTTON(spinner)->entry),
			 FALSE);
  

  button=gtk_button_new_with_label(_("OK"));
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		     button,TRUE,TRUE,0);
  gtk_signal_connect(GTK_OBJECT(button),"pressed",
		     GTK_SIGNAL_FUNC(AddDelPattern), 
		     (gpointer)cdata);

  
  button=gtk_button_new_with_label(_("Cancel"));
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		     button,TRUE,TRUE,0);
  gtk_signal_connect(GTK_OBJECT(button),"pressed",
		     GTK_SIGNAL_FUNC(close_child_dialog), 
		     GTK_WIDGET(dialog));

  
  gtk_widget_show_all(dialog);
  gtk_main();

  if(cdata->update){
    for(i_ptn=pattern_num;i_ptn>cdata->dest_ptn;i_ptn--){
      tmp_mascot.frame_num[i_ptn]=tmp_mascot.frame_num[i_ptn-1];
      tmp_mascot.random_weight[i_ptn]=tmp_mascot.random_weight[i_ptn-1];
      tmp_mascot.click_weight[i_ptn]=tmp_mascot.click_weight[i_ptn-1];
      tmp_mascot.click_word[i_ptn]=tmp_mascot.click_word[i_ptn-1];
      tmp_mascot.duet_tgt[i_ptn]=tmp_mascot.duet_tgt[i_ptn-1];
      tmp_mascot.duet_ptn[i_ptn]=tmp_mascot.duet_ptn[i_ptn-1];
      tmp_mascot.duet_word[i_ptn]=tmp_mascot.duet_word[i_ptn-1];
      tmp_mascot.duet_delay[i_ptn]=tmp_mascot.duet_delay[i_ptn-1];
      for(i_frm=0;i_frm<MAX_ANIME_FRAME;i_frm++){
	tmp_mascot.frame_pix[i_ptn][i_frm]
	  =tmp_mascot.frame_pix[i_ptn-1][i_frm];
	tmp_mascot.frame_min[i_ptn][i_frm]
	  =tmp_mascot.frame_min[i_ptn-1][i_frm];
	tmp_mascot.frame_max[i_ptn][i_frm]
	  =tmp_mascot.frame_max[i_ptn-1][i_frm];
	tmp_mascot.frame_loop[i_ptn][i_frm].next
	  =tmp_mascot.frame_loop[i_ptn-1][i_frm].next;
	tmp_mascot.frame_loop[i_ptn][i_frm].min
	  =tmp_mascot.frame_loop[i_ptn-1][i_frm].min;
	tmp_mascot.frame_loop[i_ptn][i_frm].max
	  =tmp_mascot.frame_loop[i_ptn-1][i_frm].max;
      }
      gtk_notebook_remove_page(GTK_NOTEBOOK(ptn_note),i_ptn-1);
      flag_make_frame_list[i_ptn-1]=FALSE;
      flag_make_pattern_list[i_ptn-1]=FALSE;
      gtk_widget_queue_draw (GTK_WIDGET(ptn_note));
    }

    tmp_mascot.frame_pix[cdata->dest_ptn][0]=0;
    tmp_mascot.frame_min[cdata->dest_ptn][0]=1;
    tmp_mascot.frame_max[cdata->dest_ptn][0]=1;
    tmp_mascot.frame_loop[cdata->dest_ptn][0].next=-1;
    tmp_mascot.frame_loop[cdata->dest_ptn][0].min=0;
    tmp_mascot.frame_loop[cdata->dest_ptn][0].max=0;
    tmp_mascot.frame_num[cdata->dest_ptn]=1;
    tmp_mascot.random_weight[cdata->dest_ptn]=0;
    tmp_mascot.click_weight[cdata->dest_ptn]=0;
    tmp_mascot.click_word[cdata->dest_ptn]=NULL;
    tmp_mascot.duet_tgt[cdata->dest_ptn]=NULL;
    tmp_mascot.duet_ptn[cdata->dest_ptn]=1;
    tmp_mascot.duet_word[cdata->dest_ptn]=NULL;
    tmp_mascot.duet_delay[cdata->dest_ptn]=DEF_DUET_DELAY;
    for(i_frm=1;i_frm<MAX_ANIME_FRAME;i_frm++){
      tmp_mascot.frame_pix[cdata->dest_ptn][i_frm]=-1;
      tmp_mascot.frame_min[cdata->dest_ptn][i_frm]=0;
      tmp_mascot.frame_max[cdata->dest_ptn][i_frm]=0;
      tmp_mascot.frame_loop[cdata->dest_ptn][i_frm].next=-1;
      tmp_mascot.frame_loop[cdata->dest_ptn][i_frm].min=0;
      tmp_mascot.frame_loop[cdata->dest_ptn][i_frm].max=0;
      tmp_mascot.frame_loop[cdata->dest_ptn][i_frm].seq=0;
      tmp_mascot.frame_loop[cdata->dest_ptn][i_frm].seqend=0;
    }
    
    pattern_num++;

    for(i_ptn=cdata->dest_ptn;i_ptn<pattern_num;i_ptn++){
      make_pattern_list(ptn_note, i_ptn);
    }
    gtk_notebook_set_page(GTK_NOTEBOOK(ptn_note), cdata->dest_ptn);
    gtk_widget_queue_draw(GTK_WIDGET(ptn_note));
  }


  g_free(cdata);
  flagChildDialog=FALSE;
}

static void create_del_pattern_dialog(GtkWidget *w, gpointer gdata)
{
  GtkWidget *ptn_note;
  GtkWidget *dialog;
  GtkWidget *button;
  GtkWidget *label;
  GtkAdjustment *adj;
  GtkWidget *spinner;
  GtkWidget *hbox;
  confPattern *cdata;
  int i_ptn,i_frm;

  if(flagChildDialog){
    return;
  }
  else{
    flagChildDialog=TRUE;
  }

  if(pattern_num==1){
    popup_message(POPUP_TIMEOUT,
		  _("Error: Delete Pattern."),
		  " ",
		  _("You cannot delete the base pattern."),
		  NULL);
    return;
  }

  ptn_note=(GtkWidget *)gdata;

  cdata=g_malloc0(sizeof(confPattern));

  cdata->dest_ptn=pattern_num-1;
  cdata->update=FALSE;

  dialog = gtk_dialog_new();
  gtk_container_border_width(GTK_CONTAINER(dialog),5);
  gtk_window_set_title(GTK_WINDOW(dialog),_("Select Pattern No. to Delete"));
  
  cdata->pd=dialog;
  
  hbox=gtk_hbox_new(FALSE,0);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),
		     hbox,TRUE,TRUE,0);

  label=gtk_label_new(_("Delete Pattern No."));
  gtk_box_pack_start(GTK_BOX(hbox),label,TRUE,TRUE,0);

  adj = (GtkAdjustment *)gtk_adjustment_new 
    ((gfloat)gtk_notebook_get_current_page(GTK_NOTEBOOK(ptn_note)),
     1,(gfloat)pattern_num-1,1.0, 1.0, 0.0);
  gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
		      GTK_SIGNAL_FUNC (cc_get_adj),
		      &cdata->dest_ptn);
  spinner =  gtk_spin_button_new (adj, 0, 0);
  gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), FALSE);
  gtk_box_pack_start(GTK_BOX(hbox), spinner,FALSE, FALSE, 0);
  gtk_entry_set_editable(GTK_ENTRY(&GTK_SPIN_BUTTON(spinner)->entry),
			 FALSE);
  

  button=gtk_button_new_with_label(_("OK"));
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		     button,TRUE,TRUE,0);
  gtk_signal_connect(GTK_OBJECT(button),"pressed",
		     GTK_SIGNAL_FUNC(AddDelPattern), 
		     (gpointer)cdata);


  
  button=gtk_button_new_with_label(_("Cancel"));
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		     button,TRUE,TRUE,0);
  gtk_signal_connect(GTK_OBJECT(button),"pressed",
		     GTK_SIGNAL_FUNC(close_child_dialog), 
		     GTK_WIDGET(dialog));

  
  gtk_widget_show_all(dialog);
  gtk_main();

  if(cdata->update){
    for(i_ptn=cdata->dest_ptn;i_ptn<pattern_num-1;i_ptn++){
      tmp_mascot.frame_num[i_ptn]=tmp_mascot.frame_num[i_ptn+1];
      tmp_mascot.random_weight[i_ptn]=tmp_mascot.random_weight[i_ptn+1];
      tmp_mascot.click_weight[i_ptn]=tmp_mascot.click_weight[i_ptn+1];
      tmp_mascot.click_word[i_ptn]=tmp_mascot.click_word[i_ptn+1];
      tmp_mascot.duet_tgt[i_ptn]=tmp_mascot.duet_tgt[i_ptn+1];
      tmp_mascot.duet_ptn[i_ptn]=tmp_mascot.duet_ptn[i_ptn+1];
      tmp_mascot.duet_word[i_ptn]=tmp_mascot.duet_word[i_ptn+1];
      tmp_mascot.duet_delay[i_ptn]=tmp_mascot.duet_delay[i_ptn+1];
      for(i_frm=0;i_frm<MAX_ANIME_FRAME;i_frm++){
	tmp_mascot.frame_pix[i_ptn][i_frm]
	  =tmp_mascot.frame_pix[i_ptn+1][i_frm];
	tmp_mascot.frame_min[i_ptn][i_frm]
	  =tmp_mascot.frame_min[i_ptn+1][i_frm];
	tmp_mascot.frame_max[i_ptn][i_frm]
	  =tmp_mascot.frame_max[i_ptn+1][i_frm];
	tmp_mascot.frame_loop[i_ptn][i_frm].next
	  =tmp_mascot.frame_loop[i_ptn+1][i_frm].next;
	tmp_mascot.frame_loop[i_ptn][i_frm].min
	  =tmp_mascot.frame_loop[i_ptn+1][i_frm].min;
	tmp_mascot.frame_loop[i_ptn][i_frm].max
	  =tmp_mascot.frame_loop[i_ptn+1][i_frm].max;
      }
    }

    for(i_ptn=pattern_num-1;i_ptn>=cdata->dest_ptn;i_ptn--){
      gtk_notebook_remove_page(GTK_NOTEBOOK(ptn_note),i_ptn);
      flag_make_frame_list[i_ptn]=FALSE;
      flag_make_pattern_list[i_ptn]=FALSE;
      gtk_widget_queue_draw (GTK_WIDGET(ptn_note));
    }

    tmp_mascot.frame_num[pattern_num-1]=0;
    tmp_mascot.random_weight[pattern_num-1]=0;
    tmp_mascot.click_weight[pattern_num-1]=0;
    tmp_mascot.click_word[pattern_num-1]=NULL;
    tmp_mascot.duet_tgt[pattern_num-1]=NULL;
    tmp_mascot.duet_ptn[pattern_num-1]=1;
    tmp_mascot.duet_word[pattern_num-1]=NULL;
    tmp_mascot.duet_delay[pattern_num-1]=DEF_DUET_DELAY;
    for(i_frm=0;i_frm<MAX_ANIME_FRAME;i_frm++){
      tmp_mascot.frame_pix[pattern_num-1][i_frm]=-1;
      tmp_mascot.frame_min[pattern_num-1][i_frm]=0;
      tmp_mascot.frame_max[pattern_num-1][i_frm]=0;
      tmp_mascot.frame_loop[pattern_num-1][i_frm].next=-1;
      tmp_mascot.frame_loop[pattern_num-1][i_frm].min=0;
      tmp_mascot.frame_loop[pattern_num-1][i_frm].max=0;
      tmp_mascot.frame_loop[pattern_num-1][i_frm].seq=0;
      tmp_mascot.frame_loop[pattern_num-1][i_frm].seqend=0;
    }
    
    pattern_num--;

    for(i_ptn=cdata->dest_ptn;i_ptn<pattern_num;i_ptn++){
      make_pattern_list(ptn_note, i_ptn);
    }

    if(cdata->dest_ptn<=pattern_num){
      gtk_notebook_set_page(GTK_NOTEBOOK(ptn_note), cdata->dest_ptn-1);
    }
    else{
      gtk_notebook_set_page(GTK_NOTEBOOK(ptn_note), cdata->dest_ptn);
    }
    gtk_widget_queue_draw(GTK_WIDGET(ptn_note));

  }


  g_free(cdata);
  flagChildDialog=FALSE;
}


static void create_copy_pattern_dialog(GtkWidget *w, gpointer gdata)
{
  GtkWidget *ptn_note;
  GtkWidget *dialog;
  GtkWidget *button;
  GtkWidget *label;
  GtkAdjustment *adj;
  GtkWidget *spinner;
  GtkWidget *hbox;
  confPatternCopy *cdata;
  int i_ptn,i_frm;

  if(flagChildDialog){
    return;
  }
  else{
    flagChildDialog=TRUE;
  }

  if(pattern_num==1){
    popup_message(POPUP_TIMEOUT,
		  _("Error: Copy Pattern."),
		  " ",
		  _("You should append new pattern to copy."),
		  NULL);
    return;
  }


  ptn_note=(GtkWidget *)gdata;

  cdata=g_malloc0(sizeof(confPatternCopy));

  cdata->dest_ptn=pattern_num-1;
  cdata->update=FALSE;

  dialog = gtk_dialog_new();
  gtk_container_border_width(GTK_CONTAINER(dialog),5);
  gtk_window_set_title(GTK_WINDOW(dialog),_("Pattern Copy"));
  
  cdata->pd=dialog;
  
  hbox=gtk_hbox_new(FALSE,0);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),
		     hbox,TRUE,TRUE,0);

  label=gtk_label_new(_("Pattern Copy :  No."));
  gtk_box_pack_start(GTK_BOX(hbox),label,TRUE,TRUE,0);

  adj = (GtkAdjustment *)gtk_adjustment_new 
    ((gfloat)gtk_notebook_get_current_page(GTK_NOTEBOOK(ptn_note)),
     1,(gfloat)pattern_num-1,1.0, 1.0, 0.0);

  gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
		      GTK_SIGNAL_FUNC (cc_get_adj),
		      &cdata->from_ptn);
  spinner =  gtk_spin_button_new (adj, 0, 0);
  gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), FALSE);
  gtk_box_pack_start(GTK_BOX(hbox), spinner,FALSE, FALSE, 0);
  gtk_entry_set_editable(GTK_ENTRY(&GTK_SPIN_BUTTON(spinner)->entry),
			 FALSE);
  
  label=gtk_label_new(_(" -> No."));
  gtk_box_pack_start(GTK_BOX(hbox),label,TRUE,TRUE,0);

  adj = (GtkAdjustment *)gtk_adjustment_new 
    ((gfloat)pattern_num-1, 1,(gfloat)pattern_num-1,1.0, 1.0, 0.0);
  gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
		      GTK_SIGNAL_FUNC (cc_get_adj),
		      &cdata->dest_ptn);
  spinner =  gtk_spin_button_new (adj, 0, 0);
  gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), FALSE);
  gtk_box_pack_start(GTK_BOX(hbox), spinner,FALSE, FALSE, 0);
  gtk_entry_set_editable(GTK_ENTRY(&GTK_SPIN_BUTTON(spinner)->entry),
			 FALSE);
  


  button=gtk_button_new_with_label(_("OK"));
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		     button,TRUE,TRUE,0);
  gtk_signal_connect(GTK_OBJECT(button),"pressed",
		     GTK_SIGNAL_FUNC(CopyPattern), 
		     (gpointer)cdata);

  
  button=gtk_button_new_with_label(_("Cancel"));
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		     button,TRUE,TRUE,0);
  gtk_signal_connect(GTK_OBJECT(button),"pressed",
		     GTK_SIGNAL_FUNC(close_child_dialog), 
		     GTK_WIDGET(dialog));

  
  gtk_widget_show_all(dialog);
  gtk_main();

  if(cdata->update){
    tmp_mascot.frame_num[cdata->dest_ptn]
      =tmp_mascot.frame_num[cdata->from_ptn];
    tmp_mascot.random_weight[cdata->dest_ptn]
      =tmp_mascot.random_weight[cdata->from_ptn];
    tmp_mascot.click_weight[cdata->dest_ptn]
      =tmp_mascot.click_weight[cdata->from_ptn];
    tmp_mascot.click_word[cdata->dest_ptn]
      =tmp_mascot.click_word[cdata->from_ptn];
    tmp_mascot.duet_tgt[cdata->dest_ptn]
      =tmp_mascot.duet_tgt[cdata->from_ptn];
    tmp_mascot.duet_ptn[cdata->dest_ptn]
      =tmp_mascot.duet_ptn[cdata->from_ptn];
    tmp_mascot.duet_word[cdata->dest_ptn]
      =tmp_mascot.duet_word[cdata->from_ptn];
    tmp_mascot.duet_delay[cdata->dest_ptn]
      =tmp_mascot.duet_delay[cdata->from_ptn];
    for(i_frm=0;i_frm<MAX_ANIME_FRAME;i_frm++){
      tmp_mascot.frame_pix[cdata->dest_ptn][i_frm]
	=tmp_mascot.frame_pix[cdata->from_ptn][i_frm];
      tmp_mascot.frame_min[cdata->dest_ptn][i_frm]
	=tmp_mascot.frame_min[cdata->from_ptn][i_frm];
      tmp_mascot.frame_max[cdata->dest_ptn][i_frm]
	=tmp_mascot.frame_max[cdata->from_ptn][i_frm];
      tmp_mascot.frame_loop[cdata->dest_ptn][i_frm].next
	=tmp_mascot.frame_loop[cdata->from_ptn][i_frm].next;
      tmp_mascot.frame_loop[cdata->dest_ptn][i_frm].min
	=tmp_mascot.frame_loop[cdata->from_ptn][i_frm].min;
      tmp_mascot.frame_loop[cdata->dest_ptn][i_frm].max
	=tmp_mascot.frame_loop[cdata->from_ptn][i_frm].max;
    }


    for(i_ptn=pattern_num-1;i_ptn>=cdata->dest_ptn;i_ptn--){
      gtk_notebook_remove_page(GTK_NOTEBOOK(ptn_note),i_ptn);
      flag_make_frame_list[i_ptn]=FALSE;
      flag_make_pattern_list[i_ptn]=FALSE;
      gtk_widget_queue_draw (GTK_WIDGET(ptn_note));
    }

    for(i_ptn=cdata->dest_ptn;i_ptn<pattern_num;i_ptn++){
      make_pattern_list(ptn_note, i_ptn);
    }

    gtk_notebook_set_page(GTK_NOTEBOOK(ptn_note), cdata->dest_ptn);
    gtk_widget_queue_draw(GTK_WIDGET(ptn_note));
  }


  g_free(cdata);
  flagChildDialog=FALSE;
}


static void create_add_frame_dialog(GtkWidget *w, gpointer gdata)
{
  GtkWidget *dialog;
  GtkWidget *button;
  GtkWidget *label;
  GtkAdjustment *adj;
  GtkWidget *spinner;
  GtkWidget *hbox;
  confFrame *cdata;
  int i_ptn,i_frm;

  i_ptn=(int)gdata;
  
  if(flagChildDialog){
    return;
  }
  else{
    flagChildDialog=TRUE;
  }

  if(tmp_mascot.frame_num[i_ptn]>=MAX_ANIME_FRAME){
    popup_message(POPUP_TIMEOUT,
		  _("Error: Append Frame."),
		  " ",
		  _("The number of frames maxes out."),
		  NULL);
    return;
  }

  cdata=g_malloc0(sizeof(confFrame));

  cdata->dest_frm=tmp_mascot.frame_num[i_ptn];
  cdata->update=FALSE;

  dialog = gtk_dialog_new();
  gtk_container_border_width(GTK_CONTAINER(dialog),5);
  gtk_window_set_title(GTK_WINDOW(dialog),_("Select Frame No. to Append"));
  
  cdata->fd=dialog;
  
  hbox=gtk_hbox_new(FALSE,0);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),
		     hbox,TRUE,TRUE,0);

  label=gtk_label_new(_("Append Frame No."));
  gtk_box_pack_start(GTK_BOX(hbox),label,TRUE,TRUE,0);

  adj = (GtkAdjustment *)gtk_adjustment_new 
    ((gfloat)tmp_mascot.frame_num[i_ptn], 0,
     (gfloat)tmp_mascot.frame_num[i_ptn],1.0, 1.0, 0.0);
  gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
		      GTK_SIGNAL_FUNC (cc_get_adj),
		      &cdata->dest_frm);
  spinner =  gtk_spin_button_new (adj, 0, 0);
  gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), FALSE);
  gtk_box_pack_start(GTK_BOX(hbox), spinner,FALSE, FALSE, 0);
  gtk_entry_set_editable(GTK_ENTRY(&GTK_SPIN_BUTTON(spinner)->entry),
			 FALSE);
  

  button=gtk_button_new_with_label(_("OK"));
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		     button,TRUE,TRUE,0);
  gtk_signal_connect(GTK_OBJECT(button),"pressed",
		     GTK_SIGNAL_FUNC(AddDelFrame), 
		     (gpointer)cdata);

  button=gtk_button_new_with_label(_("Cancel"));
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		     button,TRUE,TRUE,0);
  gtk_signal_connect(GTK_OBJECT(button),"pressed",
		     GTK_SIGNAL_FUNC(close_child_dialog), 
		     GTK_WIDGET(dialog));

  
  gtk_widget_show_all(dialog);
  gtk_main();

  if(cdata->update){
    for(i_frm=tmp_mascot.frame_num[i_ptn];i_frm>cdata->dest_frm;i_frm--){
      tmp_mascot.frame_pix[i_ptn][i_frm]=tmp_mascot.frame_pix[i_ptn][i_frm-1];
      tmp_mascot.frame_min[i_ptn][i_frm]=tmp_mascot.frame_min[i_ptn][i_frm-1];
      tmp_mascot.frame_max[i_ptn][i_frm]=tmp_mascot.frame_max[i_ptn][i_frm-1];
      tmp_mascot.frame_loop[i_ptn][i_frm].next
	=tmp_mascot.frame_loop[i_ptn][i_frm-1].next;
      tmp_mascot.frame_loop[i_ptn][i_frm].min
	=tmp_mascot.frame_loop[i_ptn][i_frm-1].min;
      tmp_mascot.frame_loop[i_ptn][i_frm].max
	=tmp_mascot.frame_loop[i_ptn][i_frm-1].max;
    }
    tmp_mascot.frame_pix[i_ptn][cdata->dest_frm]=0;
    tmp_mascot.frame_min[i_ptn][cdata->dest_frm]=1;
    tmp_mascot.frame_max[i_ptn][cdata->dest_frm]=1;
    tmp_mascot.frame_loop[i_ptn][cdata->dest_frm].next=-1;
    tmp_mascot.frame_loop[i_ptn][cdata->dest_frm].min=0;
    tmp_mascot.frame_loop[i_ptn][cdata->dest_frm].max=0;

    tmp_mascot.frame_num[i_ptn]++;

    make_frame_list(i_ptn);
  }


  g_free(cdata);
  flagChildDialog=FALSE;
}



static void create_del_frame_dialog(GtkWidget *w, gpointer gdata)
{
  GtkWidget *dialog;
  GtkWidget *button;
  GtkWidget *label;
  GtkAdjustment *adj;
  GtkWidget *spinner;
  GtkWidget *hbox;
  confFrame *cdata;
  int i_ptn,i_frm;

  i_ptn=(int)gdata;
  
  if(flagChildDialog){
    return;
  }
  else{
    flagChildDialog=TRUE;
  }

  if(tmp_mascot.frame_num[i_ptn]==1){
    popup_message(POPUP_TIMEOUT,
		  _("Error: Delete Frame."),
		  " ",
		  _("You cannot delete no more frames."),
		  NULL);
    return;
  }

  cdata=g_malloc0(sizeof(confFrame));

  cdata->dest_frm=tmp_mascot.frame_num[i_ptn]-1;
  cdata->update=FALSE;

  dialog = gtk_dialog_new();
  gtk_container_border_width(GTK_CONTAINER(dialog),5);
  gtk_window_set_title(GTK_WINDOW(dialog),_("Select Frame No. to Delete"));
  
  cdata->fd=dialog;
  
  hbox=gtk_hbox_new(FALSE,0);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),
		     hbox,TRUE,TRUE,0);

  label=gtk_label_new(_("Delete Frame No."));
  gtk_box_pack_start(GTK_BOX(hbox),label,TRUE,TRUE,0);

  adj = (GtkAdjustment *)gtk_adjustment_new 
    ((gfloat)tmp_mascot.frame_num[i_ptn]-1, 0,
     (gfloat)tmp_mascot.frame_num[i_ptn]-1,1.0, 1.0, 0.0);
  gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
		      GTK_SIGNAL_FUNC (cc_get_adj),
		      &cdata->dest_frm);
  spinner =  gtk_spin_button_new (adj, 0, 0);
  gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), FALSE);
  gtk_box_pack_start(GTK_BOX(hbox), spinner,FALSE, FALSE, 0);
  gtk_entry_set_editable(GTK_ENTRY(&GTK_SPIN_BUTTON(spinner)->entry),
			 FALSE);
  

  button=gtk_button_new_with_label(_("OK"));
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		     button,TRUE,TRUE,0);
  gtk_signal_connect(GTK_OBJECT(button),"pressed",
		     GTK_SIGNAL_FUNC(AddDelFrame), 
		     (gpointer)cdata);

  
  button=gtk_button_new_with_label(_("Cancel"));
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		     button,TRUE,TRUE,0);
  gtk_signal_connect(GTK_OBJECT(button),"pressed",
		     GTK_SIGNAL_FUNC(close_child_dialog), 
		     GTK_WIDGET(dialog));

  
  gtk_widget_show_all(dialog);
  gtk_main();

  if(cdata->update){
    for(i_frm=cdata->dest_frm;i_frm<tmp_mascot.frame_num[i_ptn]-1;i_frm++){
      tmp_mascot.frame_pix[i_ptn][i_frm]=tmp_mascot.frame_pix[i_ptn][i_frm+1];
      tmp_mascot.frame_min[i_ptn][i_frm]=tmp_mascot.frame_min[i_ptn][i_frm+1];
      tmp_mascot.frame_max[i_ptn][i_frm]=tmp_mascot.frame_max[i_ptn][i_frm+1];
      tmp_mascot.frame_loop[i_ptn][i_frm].next
	=tmp_mascot.frame_loop[i_ptn][i_frm+1].next;
      tmp_mascot.frame_loop[i_ptn][i_frm].min
	=tmp_mascot.frame_loop[i_ptn][i_frm+1].min;
      tmp_mascot.frame_loop[i_ptn][i_frm].max
	=tmp_mascot.frame_loop[i_ptn][i_frm+1].max;
    }
    tmp_mascot.frame_pix[i_ptn][tmp_mascot.frame_num[i_ptn]-1]=-1;
    tmp_mascot.frame_min[i_ptn][tmp_mascot.frame_num[i_ptn]-1]=0;
    tmp_mascot.frame_max[i_ptn][tmp_mascot.frame_num[i_ptn]-1]=0;
    tmp_mascot.frame_loop[i_ptn][tmp_mascot.frame_num[i_ptn]-1].next=-1;
    tmp_mascot.frame_loop[i_ptn][tmp_mascot.frame_num[i_ptn]-1].min=0;
    tmp_mascot.frame_loop[i_ptn][tmp_mascot.frame_num[i_ptn]-1].max=0;

    tmp_mascot.frame_num[i_ptn]--;

    make_frame_list(i_ptn);
  }


  g_free(cdata);
  flagChildDialog=FALSE;
}

static void create_change_tgt_dialog(GtkWidget *w, gpointer gdata)
{
  int i_tmp, i_cat, i_tgt;
  GtkWidget *fdialog;
  GtkWidget *button;
  GtkWidget *hbox;
  confChangeTgt *cdata;

  if(flagChildDialog){
    return;
  }
  else{
    flagChildDialog=TRUE;
  }

  i_tmp=(int)gdata;
  
  i_cat=i_tmp / MAX_MENU_TARGET;
  i_tgt=i_tmp % MAX_MENU_TARGET; 

  cdata=g_malloc0(sizeof(confChangeTgt));

  cdata->i_cat=i_cat;
  cdata->i_tgt=i_tgt;

  // WinۤϽŤΤExpose٥򤹤٤ƽƤ
  while (g_main_iteration(FALSE));

  fdialog = gtk_file_selection_new(_("Select Mascot File"));
  
  cdata->fs=GTK_FILE_SELECTION(fdialog);
  cdata->update=FALSE;
  
  gtk_signal_connect(GTK_OBJECT(fdialog),"destroy",
		     GTK_SIGNAL_FUNC(close_child_dialog), 
		     GTK_WIDGET(fdialog));
  
  gtk_signal_connect(
		     GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->ok_button),
		     "clicked", 
		     GTK_SIGNAL_FUNC(ChangeTgt), (gpointer)cdata);
  
  gtk_signal_connect(
		     GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->cancel_button),
		     "clicked", 
		     GTK_SIGNAL_FUNC(close_child_dialog), 
		     GTK_WIDGET(fdialog));

  gtk_file_selection_set_filename (GTK_FILE_SELECTION (fdialog), 
	       FullPathMascotFile(&tmp_mascot, tmp_mascot.menu_tgt[i_cat][i_tgt]));
  gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (fdialog));


  hbox = gtk_hbox_new(FALSE,5);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
  gtk_box_pack_start(GTK_BOX(GTK_FILE_SELECTION(fdialog)->action_area),
		     hbox,FALSE,FALSE,0);
  
  button=gtk_button_new_with_label(_("User Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_udir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(_("Common Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_ddir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(MASCOT_EXTENSION);
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_mascotext), 
		     (gpointer)fdialog);

  gtk_widget_show_all(fdialog);
  
  gtk_main();

  if(cdata->update){
    tmp_mascot.menu_tgt_name[i_cat][i_tgt]
      =ReadMascotName(&tmp_mascot, tmp_mascot.menu_tgt[i_cat][i_tgt]);
    make_tgt_list(i_cat);
    
  }

  flagChildDialog=FALSE;
  g_free(cdata);
}


static void create_add_tgt_dialog(GtkWidget *w, gpointer gdata)
{
  int i_cat, i_tgt;
  GtkWidget *fdialog;
  GtkWidget *button;
  GtkWidget *hbox;
  confChangeTgt *cdata;

  i_cat=(int)gdata;

  if(flagChildDialog){
    return;
  }
  else{
    flagChildDialog=TRUE;
  }

  if(tmp_mascot.menu_tgt_max[i_cat]>=MAX_MENU_TARGET){
    popup_message(POPUP_TIMEOUT,
		  _("Error: Append Mascot."),
		  " ",
		  _("The number of mascots maxes out."),
		  NULL);
    return;
  }

  cdata=g_malloc0(sizeof(confChangeTgt));

  // WinۤϽŤΤExpose٥򤹤٤ƽƤ
  while (g_main_iteration(FALSE));

  fdialog = gtk_file_selection_new(_("Select New Mascot File"));

  cdata->fs=GTK_FILE_SELECTION(fdialog);
  cdata->update=FALSE;
  cdata->i_cat=i_cat;
  i_tgt=tmp_mascot.menu_tgt_max[i_cat];
  cdata->i_tgt=i_tgt;

  gtk_signal_connect(GTK_OBJECT(fdialog),"destroy",
		     GTK_SIGNAL_FUNC(close_child_dialog), 
		     GTK_WIDGET(fdialog));
  
  gtk_signal_connect(
     GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->ok_button),
     "clicked", 
     GTK_SIGNAL_FUNC(ChangeTgt), (gpointer)cdata);

  gtk_signal_connect(
     GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->cancel_button),
     "clicked", 
     GTK_SIGNAL_FUNC(close_child_dialog), 
     GTK_WIDGET(fdialog));

  gtk_file_selection_set_filename (GTK_FILE_SELECTION (fdialog), 
 	  FullPathMascotFile(&tmp_mascot, 
			     tmp_mascot.menu_tgt[i_cat][i_tgt-1]));
  gtk_file_selection_complete (GTK_FILE_SELECTION (fdialog), 
  				   MASCOT_EXTENSION);
  gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (fdialog));


  hbox = gtk_hbox_new(FALSE,5);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
  gtk_box_pack_start(GTK_BOX(GTK_FILE_SELECTION(fdialog)->action_area),
		     hbox,FALSE,FALSE,0);
  
  button=gtk_button_new_with_label(_("User Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_udir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(_("Common Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_ddir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(MASCOT_EXTENSION);
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_mascotext), 
		     (gpointer)fdialog);

  gtk_widget_show_all(fdialog);
  
  gtk_main();

  if(cdata->update){
    tmp_mascot.menu_tgt_max[i_cat]++;
    tmp_mascot.menu_total++;
    tmp_mascot.menu_tgt_name[i_cat][i_tgt]
      =ReadMascotName(&tmp_mascot, tmp_mascot.menu_tgt[i_cat][i_tgt]);
    make_tgt_list(i_cat);
  }

  flagChildDialog=FALSE;
  g_free(cdata);
}


static void create_del_tgt_dialog(GtkWidget *w, gpointer gdata)
{
  int i_cat, i_tgt, dest_tgt;
  GtkWidget *deldialog;
  GtkWidget *button;
  GtkWidget *label;
  GtkAdjustment *adj;
  GtkWidget *spinner;
  GtkWidget *hbox;
  confDelTgt *cdata;

  
  i_cat=(int)gdata;

  if(flagChildDialog){
    return;
  }
  else{
    flagChildDialog=TRUE;
  }

  if(tmp_mascot.menu_tgt_max[i_cat]==1){
    popup_message(POPUP_TIMEOUT,
		  _("Error: Delete Mascot."),
		  " ",
		  _("You cannot delete no more mascots."),
		  NULL);
    return;
  }


  dest_tgt=tmp_mascot.menu_tgt_max[i_cat]-1;

  cdata=g_malloc0(sizeof(confDelTgt));

  cdata->update=FALSE;

  deldialog = gtk_dialog_new();
  gtk_container_border_width(GTK_CONTAINER(deldialog),5);
  gtk_window_set_title(GTK_WINDOW(deldialog),_("Select Mascot No. to Remove from the Menu"));

  cdata->dd=deldialog;

  hbox=gtk_hbox_new(FALSE,0);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(deldialog)->vbox),
		     hbox,TRUE,TRUE,0);

  label=gtk_label_new(_("Remove Mascot No."));
  gtk_box_pack_start(GTK_BOX(hbox),label,TRUE,TRUE,0);

  adj = (GtkAdjustment *)gtk_adjustment_new 
    ((gfloat)dest_tgt, 0,(gfloat)dest_tgt,1.0, 1.0, 0.0);
  gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
		      GTK_SIGNAL_FUNC (cc_get_adj),
		      &dest_tgt);
  spinner =  gtk_spin_button_new (adj, 0, 0);
  gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), FALSE);
  gtk_box_pack_start(GTK_BOX(hbox), spinner,FALSE, FALSE, 0);
  gtk_entry_set_editable(GTK_ENTRY(&GTK_SPIN_BUTTON(spinner)->entry),
			 FALSE);
  

  button=gtk_button_new_with_label(_("OK"));
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(deldialog)->action_area),
		     button,TRUE,TRUE,0);
  gtk_signal_connect(GTK_OBJECT(button),"pressed",
		     GTK_SIGNAL_FUNC(DelTgt), 
		     (gpointer)cdata);
  
  button=gtk_button_new_with_label(_("Cancel"));
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(deldialog)->action_area),
		     button,TRUE,TRUE,0);
  gtk_signal_connect(GTK_OBJECT(button),"pressed",
		     GTK_SIGNAL_FUNC(close_child_dialog), 
		     GTK_WIDGET(deldialog));

  
  gtk_widget_show_all(deldialog);
  gtk_main();

  if(cdata->update){

    tmp_mascot.menu_tgt_max[i_cat]--;
    tmp_mascot.menu_total--;
    for(i_tgt=dest_tgt;i_tgt<tmp_mascot.menu_tgt_max[i_cat];i_tgt++){
      tmp_mascot.menu_tgt[i_cat][i_tgt]=
	tmp_mascot.menu_tgt[i_cat][i_tgt+1];
      tmp_mascot.menu_tgt_name[i_cat][i_tgt]=
	tmp_mascot.menu_tgt_name[i_cat][i_tgt+1];
    }

    make_tgt_list(i_cat);
  }

  g_free(cdata);
  flagChildDialog=FALSE;
}


static void create_add_cat_dialog(GtkWidget *w)
{
  GtkWidget *dialog;
  GtkWidget *button;
  GtkWidget *label;
  GtkAdjustment *adj;
  GtkWidget *spinner;
  GtkWidget *hbox;
  confCat *cdata;
  int i_cat, i_tgt;

  if(flagChildDialog){
    return;
  }
  else{
    flagChildDialog=TRUE;
  }

  if(tmp_mascot.menu_cat_max>=MAX_MENU_CATEGORY){
    popup_message(POPUP_TIMEOUT,
		  _("Error: Append Category."),
		  " ",
		  _("The number of categories maxes out."),
		  NULL);
    return;
  }

  cdata=g_malloc0(sizeof(confCat));

  cdata->dest_cat=tmp_mascot.menu_cat_max;
  cdata->update=FALSE;

  dialog = gtk_dialog_new();
  gtk_container_border_width(GTK_CONTAINER(dialog),5);
  gtk_window_set_title(GTK_WINDOW(dialog),_("Select Category No. to Append"));
  
  cdata->pd=dialog;
  
  hbox=gtk_hbox_new(FALSE,0);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),
		     hbox,TRUE,TRUE,0);

  label=gtk_label_new(_("Append Category No."));
  gtk_box_pack_start(GTK_BOX(hbox),label,TRUE,TRUE,0);

  adj = (GtkAdjustment *)gtk_adjustment_new 
    ((gfloat)tmp_mascot.menu_cat_max, 0,(gfloat)tmp_mascot.menu_cat_max,
     1.0, 1.0, 0.0);
  gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
		      GTK_SIGNAL_FUNC (cc_get_adj),
		      &cdata->dest_cat);
  spinner =  gtk_spin_button_new (adj, 0, 0);
  gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), FALSE);
  gtk_box_pack_start(GTK_BOX(hbox), spinner,FALSE, FALSE, 0);
  gtk_entry_set_editable(GTK_ENTRY(&GTK_SPIN_BUTTON(spinner)->entry),
			 FALSE);
  

  button=gtk_button_new_with_label(_("OK"));
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		     button,TRUE,TRUE,0);
  gtk_signal_connect(GTK_OBJECT(button),"pressed",
		     GTK_SIGNAL_FUNC(AddDelCat), 
		     (gpointer)cdata);
  
  button=gtk_button_new_with_label(_("Cancel"));
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		     button,TRUE,TRUE,0);
  gtk_signal_connect(GTK_OBJECT(button),"pressed",
		     GTK_SIGNAL_FUNC(close_child_dialog), 
		     GTK_WIDGET(dialog));

  
  gtk_widget_show_all(dialog);
  gtk_main();

  if(cdata->update){
    for(i_cat=tmp_mascot.menu_cat_max;i_cat>cdata->dest_cat;i_cat--){
      tmp_mascot.menu_cat[i_cat]
	=g_strdup(tmp_mascot.menu_cat[i_cat-1]);
      tmp_mascot.menu_tgt_max[i_cat]=tmp_mascot.menu_tgt_max[i_cat-1];
      for(i_tgt=0;i_tgt<tmp_mascot.menu_tgt_max[i_cat];i_tgt++){
	tmp_mascot.menu_tgt[i_cat][i_tgt]
	  =g_strdup(tmp_mascot.menu_tgt[i_cat-1][i_tgt]);
	tmp_mascot.menu_tgt_name[i_cat][i_tgt]
	  =g_strdup(tmp_mascot.menu_tgt_name[i_cat-1][i_tgt]);
      }
      //gtk_notebook_remove_page(GTK_NOTEBOOK(cat_note),i_cat-1);
      //flag_make_tgt_list[i_cat-1]=FALSE;
      //flag_make_cat_list[i_cat-1]=FALSE;
      //gtk_widget_draw (GTK_WIDGET(cat_note), NULL);
    }

    tmp_mascot.menu_cat[cdata->dest_cat]=g_strdup(TMP_CATEGORY_NAME);
    tmp_mascot.menu_tgt_max[cdata->dest_cat]=1;

    tmp_mascot.menu_tgt[cdata->dest_cat][0]
      =g_strdup(g_basename(tmp_mascot.file));
    tmp_mascot.menu_tgt_name[cdata->dest_cat][0]
      =ReadMascotName(&tmp_mascot, tmp_mascot.file);

    
    tmp_mascot.menu_cat_max++;
    tmp_mascot.menu_total++;

    if(cdata->dest_cat==tmp_mascot.menu_cat_max-1){
      make_cat_list(cat_note, cdata->dest_cat-1);
    } // Up/Downդ褦ˤʤ

    for(i_cat=cdata->dest_cat;i_cat<tmp_mascot.menu_cat_max;i_cat++){
      make_cat_list(cat_note, i_cat);
    }
    gtk_notebook_set_page(GTK_NOTEBOOK(cat_note), cdata->dest_cat);
    gtk_widget_queue_draw(GTK_WIDGET(cat_note));
  
  }


  g_free(cdata);
  flagChildDialog=FALSE;
}



static void create_del_cat_dialog(GtkWidget *w)
{
  GtkWidget *dialog;
  GtkWidget *button;
  GtkWidget *label;
  GtkAdjustment *adj;
  GtkWidget *spinner;
  GtkWidget *hbox;
  confCat *cdata;
  int i_cat, i_tgt, dest_menu_tgt_max;

  if(flagChildDialog){
    return;
  }
  else{
    flagChildDialog=TRUE;
  }

  if(tmp_mascot.menu_cat_max<=1){
    popup_message(POPUP_TIMEOUT,
		  _("Error: Delete Category."),
		  " ",
		  _("You cannot delete no more categories."),
		  NULL);
    return;
  }
  

  cdata=g_malloc0(sizeof(confCat));

  cdata->dest_cat=tmp_mascot.menu_cat_max-1;
  cdata->update=FALSE;

  dialog = gtk_dialog_new();
  gtk_container_border_width(GTK_CONTAINER(dialog),5);
  gtk_window_set_title(GTK_WINDOW(dialog),_("Select Category No. to Delete"));
  
  cdata->pd=dialog;
  
  hbox=gtk_hbox_new(FALSE,0);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),
		     hbox,TRUE,TRUE,0);

  label=gtk_label_new(_("Delete Category No."));
  gtk_box_pack_start(GTK_BOX(hbox),label,TRUE,TRUE,0);

  adj = (GtkAdjustment *)gtk_adjustment_new 
    ((gfloat)gtk_notebook_get_current_page(GTK_NOTEBOOK(cat_note)),
     0,(gfloat)tmp_mascot.menu_cat_max-1,
     1.0, 1.0, 0.0);
  gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
		      GTK_SIGNAL_FUNC (cc_get_adj),
		      &cdata->dest_cat);
  spinner =  gtk_spin_button_new (adj, 0, 0);
  gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), FALSE);
  gtk_box_pack_start(GTK_BOX(hbox), spinner,FALSE, FALSE, 0);
  gtk_entry_set_editable(GTK_ENTRY(&GTK_SPIN_BUTTON(spinner)->entry),
			 FALSE);
  

  button=gtk_button_new_with_label(_("OK"));
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		     button,TRUE,TRUE,0);
  gtk_signal_connect(GTK_OBJECT(button),"pressed",
		     GTK_SIGNAL_FUNC(AddDelCat), 
		     (gpointer)cdata);
  
  button=gtk_button_new_with_label(_("Cancel"));
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		     button,TRUE,TRUE,0);
  gtk_signal_connect(GTK_OBJECT(button),"pressed",
		     GTK_SIGNAL_FUNC(close_child_dialog), 
		     GTK_WIDGET(dialog));

  
  gtk_widget_show_all(dialog);
  gtk_main();

  if(cdata->update){
    dest_menu_tgt_max=tmp_mascot.menu_tgt_max[cdata->dest_cat];

    for(i_cat=cdata->dest_cat;i_cat<tmp_mascot.menu_cat_max-1;i_cat++){
      tmp_mascot.menu_cat[i_cat]
	=g_strdup(tmp_mascot.menu_cat[i_cat+1]);
      tmp_mascot.menu_tgt_max[i_cat]=tmp_mascot.menu_tgt_max[i_cat+1];
      for(i_tgt=0;i_tgt<tmp_mascot.menu_tgt_max[i_cat];i_tgt++){
	tmp_mascot.menu_tgt[i_cat][i_tgt]
	  =g_strdup(tmp_mascot.menu_tgt[i_cat+1][i_tgt]);
	tmp_mascot.menu_tgt_name[i_cat][i_tgt]
	  =g_strdup(tmp_mascot.menu_tgt_name[i_cat+1][i_tgt]);
      }
    }

    gtk_notebook_remove_page(GTK_NOTEBOOK(cat_note),tmp_mascot.menu_cat_max-1);
    flag_make_tgt_list[tmp_mascot.menu_cat_max-1]=FALSE;
    flag_make_cat_list[tmp_mascot.menu_cat_max-1]=FALSE;
    gtk_widget_queue_draw (GTK_WIDGET(cat_note));

    tmp_mascot.menu_cat_max--;
    tmp_mascot.menu_total-=dest_menu_tgt_max;


    for(i_cat=cdata->dest_cat;i_cat<tmp_mascot.menu_cat_max;i_cat++){
      make_cat_list(cat_note, i_cat);
    }
    
    if(cdata->dest_cat==tmp_mascot.menu_cat_max){
      make_cat_list(cat_note, cdata->dest_cat-1);
    }

    if(cdata->dest_cat<tmp_mascot.menu_cat_max){
      gtk_notebook_set_page(GTK_NOTEBOOK(cat_note), cdata->dest_cat);
    }
    else{
      gtk_notebook_set_page(GTK_NOTEBOOK(cat_note), tmp_mascot.menu_cat_max-1);
    }
    gtk_widget_queue_draw(GTK_WIDGET(cat_note));
  }

  g_free(cdata);

  flagChildDialog=FALSE;
}


static void create_merge_cat_dialog(GtkWidget *w)
{
  int i_cat, old_cat_max;
  GtkWidget *fdialog;
  GtkWidget *button;
  GtkWidget *hbox;
  confMergeCat *cdata;

  if(flagChildDialog){
    return;
  }
  else{
    flagChildDialog=TRUE;
  }

  if(tmp_mascot.menu_cat_max>=MAX_MENU_CATEGORY){
    popup_message(POPUP_TIMEOUT,
		  _("Error: Merge Menu."),
		  " ",
		  _("The number of categories maxes out."),
		  NULL);
    return;
  }

  old_cat_max=tmp_mascot.menu_cat_max;

  cdata=g_malloc0(sizeof(confMergeCat));


  // WinۤϽŤΤExpose٥򤹤٤ƽƤ
  while (g_main_iteration(FALSE));

  fdialog = gtk_file_selection_new(_("Select Menu File to Merge"));
#ifdef USE_GTK2
  gtk_file_selection_set_select_multiple(GTK_FILE_SELECTION(fdialog),TRUE);
#endif
  
  cdata->fs=GTK_FILE_SELECTION(fdialog);
  cdata->update=FALSE;
  
  gtk_signal_connect(GTK_OBJECT(fdialog),"destroy",
		     GTK_SIGNAL_FUNC(close_child_dialog), 
		     GTK_WIDGET(fdialog));
  
  gtk_signal_connect(
		     GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->ok_button),
		     "clicked", 
		     GTK_SIGNAL_FUNC(MergeCatFS), (gpointer)cdata);
  
  gtk_signal_connect(
		     GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->cancel_button),
		     "clicked", 
		     GTK_SIGNAL_FUNC(close_child_dialog), 
		     GTK_WIDGET(fdialog));

  gtk_file_selection_set_filename (GTK_FILE_SELECTION (fdialog), 
	       FullPathMascotFile(&tmp_mascot, tmp_mascot.menu_file));
  gtk_file_selection_complete (GTK_FILE_SELECTION (fdialog), 
  				   MENU_EXTENSION);
  gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (fdialog));


  hbox = gtk_hbox_new(FALSE,5);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
  gtk_box_pack_start(GTK_BOX(GTK_FILE_SELECTION(fdialog)->action_area),
		     hbox,FALSE,FALSE,0);
  
  button=gtk_button_new_with_label(_("User Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_udir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(_("Common Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_ddir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(MENU_EXTENSION);
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_menuext), 
		     (gpointer)fdialog);

  gtk_widget_show_all(fdialog);
  
  gtk_main();

  if(cdata->update){
    for(i_cat=old_cat_max-1;i_cat<tmp_mascot.menu_cat_max;i_cat++){
      make_cat_list(cat_note,i_cat);
    }
    gtk_notebook_set_page(GTK_NOTEBOOK(cat_note),tmp_mascot.menu_cat_max-1);
    gtk_widget_queue_draw(GTK_WIDGET(cat_note));
  }

  flagChildDialog=FALSE;
  g_free(cdata);
}




static void create_change_duet_tgt_dialog(GtkWidget *w, gpointer gdata)
{
  int i_ptn;
  GtkWidget *fdialog;
  GtkWidget *button;
  GtkWidget *hbox;
  confChangeDuetTgt *cdata;
  gchar *userdir=NULL;

  if(flagChildDialog){
    return;
  }
  else{
    flagChildDialog=TRUE;
  }

  i_ptn=(int)gdata;
  
  cdata=g_malloc0(sizeof(confChangeDuetTgt));


  // WinۤϽŤΤExpose٥򤹤٤ƽƤ
  while (g_main_iteration(FALSE));

  fdialog = gtk_file_selection_new(_("Select Mascot File"));
  
  cdata->fs=GTK_FILE_SELECTION(fdialog);
  cdata->update=FALSE;
  cdata->i_ptn=i_ptn;
  
  gtk_signal_connect(GTK_OBJECT(fdialog),"destroy",
		     GTK_SIGNAL_FUNC(close_child_dialog), 
		     GTK_WIDGET(fdialog));
  
  gtk_signal_connect(
		     GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->ok_button),
		     "clicked", 
		     GTK_SIGNAL_FUNC(ChangeDuetTgt), (gpointer)cdata);
  
  gtk_signal_connect(
		     GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->cancel_button),
		     "clicked", 
		     GTK_SIGNAL_FUNC(close_child_dialog), 
		     GTK_WIDGET(fdialog));

  userdir = g_strconcat(g_get_home_dir(),"/",USER_DIR, NULL);
  gtk_file_selection_set_filename (GTK_FILE_SELECTION (fdialog), 
  				   userdir);
  g_free(userdir);

  if(tmp_mascot.duet_tgt[i_ptn]){
    gtk_file_selection_set_filename (GTK_FILE_SELECTION (fdialog), 
				     FullPathMascotFile(&tmp_mascot,
  				     tmp_mascot.duet_tgt[i_ptn]));
  }
  gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (fdialog));


  hbox = gtk_hbox_new(FALSE,5);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
  gtk_box_pack_start(GTK_BOX(GTK_FILE_SELECTION(fdialog)->action_area),
		     hbox,FALSE,FALSE,0);
  
  button=gtk_button_new_with_label(_("User Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_udir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(_("Common Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_ddir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(MASCOT_EXTENSION);
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_mascotext), 
		     (gpointer)fdialog);

  gtk_widget_show_all(fdialog);
  
  gtk_main();

  if(cdata->update){
    gtk_entry_set_text(GTK_ENTRY(duet_tgt_entry[i_ptn]),
		       tmp_mascot.duet_tgt[i_ptn]);
  }

  flagChildDialog=FALSE;
  g_free(cdata);
}


static void create_change_click_sound_dialog(GtkWidget *w, gpointer gdata)
{
  int i_ptn;
  GtkWidget *fdialog;
  GtkWidget *button;
  GtkWidget *hbox;
  confChangeClickSound *cdata;

  if(flagChildDialog){
    return;
  }
  else{
    flagChildDialog=TRUE;
  }

  i_ptn=(int)gdata;
  
  cdata=g_malloc0(sizeof(confChangeClickSound));


  // WinۤϽŤΤExpose٥򤹤٤ƽƤ
  while (g_main_iteration(FALSE));

  fdialog = gtk_file_selection_new(_("Select Sound File"));
  
  cdata->fs=GTK_FILE_SELECTION(fdialog);
  cdata->update=FALSE;
  cdata->i_ptn=i_ptn;
  
  gtk_signal_connect(GTK_OBJECT(fdialog),"destroy",
		     GTK_SIGNAL_FUNC(close_child_dialog), 
		     GTK_WIDGET(fdialog));
  
  gtk_signal_connect(
		     GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->ok_button),
		     "clicked", 
		     GTK_SIGNAL_FUNC(ChangeClickSound), (gpointer)cdata);
  
  gtk_signal_connect(
		     GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->cancel_button),
		     "clicked", 
		     GTK_SIGNAL_FUNC(close_child_dialog), 
		     GTK_WIDGET(fdialog));

  if(tmp_mascot.click_sound[i_ptn]){
    gtk_file_selection_set_filename (GTK_FILE_SELECTION (fdialog), 
	     FullPathSoundFile(&tmp_mascot,
			       tmp_mascot.click_sound[i_ptn]));
  }
  else{
    gtk_file_selection_set_filename (GTK_FILE_SELECTION (fdialog), 
				     g_strconcat(g_get_home_dir(),"/",
						 USER_DIR,SOUNDDIR, NULL));
    gtk_file_selection_complete (GTK_FILE_SELECTION (fdialog), 
				 "*");
  }
  gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (fdialog));


  hbox = gtk_hbox_new(FALSE,5);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
  gtk_box_pack_start(GTK_BOX(GTK_FILE_SELECTION(fdialog)->action_area),
		     hbox,FALSE,FALSE,0);
  
  button=gtk_button_new_with_label(_("User Sound Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_usdir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(_("Common Sound Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_dsdir), 
		     (gpointer)fdialog);

  gtk_widget_show_all(fdialog);
  
  gtk_main();

  if(cdata->update){
    gtk_entry_set_text(GTK_ENTRY(click_sound_entry[i_ptn]),
		       tmp_mascot.click_sound[i_ptn]);
  }

  flagChildDialog=FALSE;
  g_free(cdata);
}


static void create_change_biff_sound_dialog(GtkWidget *w, gpointer gdata)
{
  GtkWidget *fdialog;
  GtkWidget *button;
  GtkWidget *hbox;
  GtkWidget *snd_entry;
  confChangeBiffSound *cdata;

  if(flagChildDialog){
    return;
  }
  else{
    flagChildDialog=TRUE;
  }

  snd_entry=(GtkWidget *)gdata;
  
  cdata=g_malloc0(sizeof(confChangeBiffSound));


  // WinۤϽŤΤExpose٥򤹤٤ƽƤ
  while (g_main_iteration(FALSE));

  fdialog = gtk_file_selection_new(_("Select Sound File"));
  
  cdata->fs=GTK_FILE_SELECTION(fdialog);
  cdata->update=FALSE;
  
  gtk_signal_connect(GTK_OBJECT(fdialog),"destroy",
		     GTK_SIGNAL_FUNC(close_child_dialog), 
		     GTK_WIDGET(fdialog));
  
  gtk_signal_connect(
		     GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->ok_button),
		     "clicked", 
		     GTK_SIGNAL_FUNC(ChangeBiffSound), (gpointer)cdata);
  
  gtk_signal_connect(
		     GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->cancel_button),
		     "clicked", 
		     GTK_SIGNAL_FUNC(close_child_dialog), 
		     GTK_WIDGET(fdialog));

  if(tmp_mascot.mail.sound){
    gtk_file_selection_set_filename (GTK_FILE_SELECTION (fdialog), 
				     FullPathSoundFile(&tmp_mascot,
						       tmp_mascot.mail.sound));
  }
  else{
    gtk_file_selection_set_filename (GTK_FILE_SELECTION (fdialog), 
				     g_strconcat(g_get_home_dir(),"/",
						 USER_DIR,SOUNDDIR, NULL));
    gtk_file_selection_complete (GTK_FILE_SELECTION (fdialog), 
				 "*");
  }
  gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (fdialog));


  hbox = gtk_hbox_new(FALSE,5);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
  gtk_box_pack_start(GTK_BOX(GTK_FILE_SELECTION(fdialog)->action_area),
		     hbox,FALSE,FALSE,0);
  
  button=gtk_button_new_with_label(_("User Sound Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_usdir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(_("Common Sound Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_dsdir), 
		     (gpointer)fdialog);

  gtk_widget_show_all(fdialog);
  
  gtk_main();

  if(cdata->update){
    gtk_entry_set_text(GTK_ENTRY(snd_entry),
		       tmp_mascot.mail.sound);
  }
  
  flagChildDialog=FALSE;
  g_free(cdata);
}


static void create_mail_file_dialog(GtkWidget *w, gpointer gdata)
{
  GtkWidget *fdialog;
  GtkWidget *button;
  GtkWidget *hbox;
  GtkWidget *file_entry;
  confMailFile *cdata;

  if(flagChildDialog){
    return;
  }
  else{
    switch(tmp_mascot.mail.type){
    case MAIL_POP3:
    case MAIL_APOP:
      return;
      break;
    }
    flagChildDialog=TRUE;
  }


  file_entry=(GtkWidget *)gdata;
  
  cdata=g_malloc0(sizeof(confMailFile));


  // WinۤϽŤΤExpose٥򤹤٤ƽƤ
  while (g_main_iteration(FALSE));

  fdialog = gtk_file_selection_new(_("Select the file refered for the mail checking"));
  
  cdata->fs=GTK_FILE_SELECTION(fdialog);
  cdata->update=FALSE;
  
  gtk_signal_connect(GTK_OBJECT(fdialog),"destroy",
		     GTK_SIGNAL_FUNC(close_child_dialog), 
		     GTK_WIDGET(fdialog));
  
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->ok_button),
		     "clicked", 
		     GTK_SIGNAL_FUNC(ChangeMailFile), (gpointer)cdata);
  
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->cancel_button),
		     "clicked", 
		     GTK_SIGNAL_FUNC(close_child_dialog), 
		     GTK_WIDGET(fdialog));

  if(tmp_mascot.mail.file){
    gtk_file_selection_set_filename (GTK_FILE_SELECTION (fdialog), 
				     tmp_mascot.mail.file);
  }
  else{
    switch(tmp_mascot.mail.type){
    case MAIL_LOCAL:
      gtk_file_selection_set_filename (GTK_FILE_SELECTION (fdialog), 
				       g_getenv("MAIL"));
      break;
    case MAIL_QMAIL:
      gtk_file_selection_set_filename (GTK_FILE_SELECTION (fdialog), 
				       g_strconcat(g_get_home_dir(),"/Maildir/new/",NULL));
      break;
    case MAIL_PROCMAIL:
      gtk_file_selection_set_filename (GTK_FILE_SELECTION (fdialog), 
				       g_strconcat(set_mhdir(),PROCMAIL_LOG,NULL));
      break;
    }
  }
  gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (fdialog));


  gtk_widget_show_all(fdialog);
  
  gtk_main();

  if(cdata->update){
    gtk_entry_set_text(GTK_ENTRY(file_entry),
		       tmp_mascot.mail.file);
  }
  
  flagChildDialog=FALSE;
  g_free(cdata);
}





static void NewMascotSelectMascot(GtkWidget *w, gpointer gdata)
{
  confNewMascot *cdata;

  cdata=(confNewMascot *)gdata;
  
  if(access(g_dirname(gtk_file_selection_get_filename(cdata->fs)),W_OK)==0){
    cdata->mascot_file
      =g_strdup(gtk_file_selection_get_filename(cdata->fs));
    cdata->update=TRUE;
  }
  else{
#ifdef GTK_MSG
    popup_message(POPUP_TIMEOUT*2,
		  _("Error: File cannot be opened."),
		  " ",
		  gtk_file_selection_get_filename (cdata->fs),
		  NULL);
#else
    g_print (_("Cannot Open %s\n"),
	     gtk_file_selection_get_filename (cdata->fs));
#endif
  }
  
  gtk_main_quit();
  gtk_widget_destroy(GTK_WIDGET(cdata->fs));

}


static void NewMascotSelectImage(GtkWidget *w, gpointer gdata)
{
  confNewMascot *cdata;

  cdata=(confNewMascot *)gdata;
  
  if(access(gtk_file_selection_get_filename(cdata->fs),F_OK)==0){
    cdata->image_file
      =g_strdup(gtk_file_selection_get_filename(cdata->fs));
    cdata->update=TRUE;
  }
  else{
#ifdef GTK_MSG
    popup_message(POPUP_TIMEOUT*2,
		  _("Error: File cannot be opened."),
		  " ",
		  gtk_file_selection_get_filename (cdata->fs),
		  NULL);
#else
    g_print (_("Cannot Open %s\n"),
	     gtk_file_selection_get_filename (cdata->fs));
#endif
  }
  
  gtk_main_quit();
  gtk_widget_destroy(GTK_WIDGET(cdata->fs));

}


static void MakeNewMascot(GtkWidget *w, gpointer gdata)
{
  confNewMascot *cdata;
  int i_pix;
  gchar *tmp_file;
  gboolean tmp_flag;

  cdata=(confNewMascot *)gdata;
  
  InitMascot(Mascot);

  Mascot->file=cdata->mascot_file;
  if(strcmp(g_dirname(cdata->mascot_file),g_dirname(cdata->image_file))){
    tmp_file=g_strconcat(g_get_home_dir(), "/",USER_DIR,
			 PIXDIR, NULL);
    if(!strcmp(g_dirname(cdata->mascot_file),tmp_file)){
      tmp_file=g_strconcat(g_get_home_dir(), "/",USER_DIR,
			   PIXDIR, g_basename(cdata->image_file), NULL);
    }
    else{
      tmp_file=g_strconcat(g_dirname(cdata->mascot_file), "/",
			   g_basename(cdata->image_file), NULL);
    }
    
    
    g_print(_("Installing %s -> %s\n"),cdata->image_file,tmp_file);
    copy_file(cdata->image_file,tmp_file);
    Mascot->sprites[0].filename=tmp_file;
  }
  else{
    Mascot->sprites[0].filename=cdata->image_file;
    
  }

  if(cdata->copyright) Mascot->copyright=cdata->copyright;

  Mascot->random_total=0;
  Mascot->click_total=0;

  Mascot->name=NULL;
  Mascot->move=MOVE_FIX;
  Mascot->xoff=0;
  Mascot->yoff=0;
  Mascot->x=0;
  Mascot->y=0;

  Mascot->clk_x=INIT_CLK_POS;
  Mascot->clk_y=INIT_CLK_POS;
  Mascot->clktext_x=INIT_CLK_TEXT;
  Mascot->clktext_x=INIT_CLK_TEXT;
  Mascot->wclkbd=INIT_CLK_BORDER;
  Mascot->clkmode=CLOCK_NO;
  Mascot->clktype=CLOCK_TYPE_24S;
  Mascot->flag_clksd=TRUE;
  Mascot->fontname_clk=Mascot->deffontname_clk;

  Mascot->baltext_x=INIT_BAL_TEXT;
  Mascot->baltext_y=INIT_BAL_TEXT;
  Mascot->wbalbd=INIT_BAL_BORDER;
  Mascot->bal_defpos=BAL_POS_LEFT;
  Mascot->fontname_bal=Mascot->deffontname_bal;

  Mascot->colclk->red=COLOR_CLK_R;
  Mascot->colclk->green=COLOR_CLK_G;
  Mascot->colclk->blue=COLOR_CLK_B;
  Mascot->colclksd->red=COLOR_CLKSD_R;
  Mascot->colclksd->green=COLOR_CLKSD_G;
  Mascot->colclksd->blue=COLOR_CLKSD_B;
  Mascot->colclkbg->red=COLOR_CLKBG_R;
  Mascot->colclkbg->green=COLOR_CLKBG_G;
  Mascot->colclkbg->blue=COLOR_CLKBG_B;
  Mascot->colclkbd->red=COLOR_CLKBD_R;
  Mascot->colclkbd->green=COLOR_CLKBD_G;
  Mascot->colclkbd->blue=COLOR_CLKBD_B;

  Mascot->colbal->red=COLOR_BAL_R;
  Mascot->colbal->green=COLOR_BAL_G;
  Mascot->colbal->blue=COLOR_BAL_B;
  Mascot->colbalbg->red=COLOR_BALBG_R;
  Mascot->colbalbg->green=COLOR_BALBG_G;
  Mascot->colbalbg->blue=COLOR_BALBG_B;
  Mascot->colbalbd->red=COLOR_BALBD_R;
  Mascot->colbalbd->green=COLOR_BALBD_G;
  Mascot->colbalbd->blue=COLOR_BALBD_B;

  //// Biff
  Mascot->mail.pix_file=NULL;
  Mascot->mail.pix_pos=MAIL_PIX_RIGHT;
  Mascot->mail.pix_x=0;
  Mascot->mail.pix_y=0;
  Mascot->mail.word=NULL;
  Mascot->mail.sound=NULL;

  
  for(i_pix=1;i_pix<MAX_PIXMAP;i_pix++){
    Mascot->sprites[i_pix].filename=NULL;
  }

  Mascot->frame_num[0]=1;
  Mascot->frame_pix[0][0]=0;
  Mascot->frame_min[0][0]=1;
  Mascot->frame_max[0][0]=100;

  SaveMascot(Mascot,FALSE);

  tmp_flag=Mascot->flag_install;
  Mascot->flag_install=FALSE;
  ReadMascot(Mascot,FALSE);
  LoadPixmaps(win_main, Mascot->w_drawing, Mascot, Mascot->sprites);
  ReInitGC(Mascot);
  gtk_widget_unmap(balloon_main);
  flag_balloon=FALSE;
  LoadBiffPixmap(biff_pix, Mascot);


  if(Mascot->clkmode!=CLOCK_NO) clock_update(Mascot, TRUE);
  if(Mascot->clkmode==CLOCK_PANEL){
    gtk_widget_map(clock_main);
  }
  else{
    gtk_widget_unmap(clock_main);
  }

  if(Mascot->move==MOVE_FIX){
    MoveMascot(Mascot,Mascot->xfix,Mascot->yfix);
  }
  else{
    MoveToFocus(Mascot,TRUE);
  }

  Mascot->flag_install=tmp_flag;

  gtk_main_quit();
  gtk_widget_destroy(GTK_WIDGET(cdata->dialog));

}


static void create_new_mascot_file_selection_dialog
(GtkWidget *w, gpointer gdata)
{
  GtkWidget *fdialog;
  GtkWidget *button;
  GtkWidget *hbox;
  confNewMascot *cdata;

  if(flagChildDialog){
    return;
  }
  else{
    flagChildDialog=TRUE;
  }


  cdata=(confNewMascot *)gdata;

  gtk_widget_unmap(cdata->dialog);

  // WinۤϽŤΤExpose٥򤹤٤ƽƤ
  while (g_main_iteration(FALSE));

  fdialog = gtk_file_selection_new(_("Select New Mascot File"));

  cdata->fs=GTK_FILE_SELECTION(fdialog);
    
  gtk_signal_connect(GTK_OBJECT(fdialog),"destroy",
		     GTK_SIGNAL_FUNC(close_child_dialog), 
		     GTK_WIDGET(fdialog));
  
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->ok_button),
  		     "clicked", 
  		     GTK_SIGNAL_FUNC(NewMascotSelectMascot), (gpointer)cdata);
  
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->cancel_button),
		     "clicked", 
		     GTK_SIGNAL_FUNC(close_child_dialog), 
		     GTK_WIDGET(fdialog));

  gtk_file_selection_complete (GTK_FILE_SELECTION (fdialog), 
  				   MASCOT_EXTENSION);


  hbox = gtk_hbox_new(FALSE,5);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
  gtk_box_pack_start(GTK_BOX(GTK_FILE_SELECTION(fdialog)->action_area),
		     hbox,FALSE,FALSE,0);
  
  button=gtk_button_new_with_label(_("User Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_udir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(_("Common Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_ddir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(MASCOT_EXTENSION);
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_mascotext), 
		     (gpointer)fdialog);

  gtk_widget_show_all(fdialog);
  
  gtk_main();

  if(cdata->update){
  }

  flagChildDialog=FALSE;
  gtk_main_quit();
  while (g_main_iteration(FALSE));
}


static void create_new_mascot_image_selection_dialog
(GtkWidget *w, gpointer gdata)
{
  GtkWidget *fdialog;
  GtkWidget *button;
  GtkWidget *hbox;
  confNewMascot *cdata;

  if(flagChildDialog){
    return;
  }
  else{
    flagChildDialog=TRUE;
  }


  cdata=(confNewMascot *)gdata;

  gtk_widget_unmap(cdata->dialog);

  // WinۤϽŤΤExpose٥򤹤٤ƽƤ
  while (g_main_iteration(FALSE));

  fdialog = gtk_file_selection_new(_("Select Image for New Mascot"));

  cdata->fs=GTK_FILE_SELECTION(fdialog);
    
  gtk_signal_connect(GTK_OBJECT(fdialog),"destroy",
		     GTK_SIGNAL_FUNC(close_child_dialog), 
		     GTK_WIDGET(fdialog));
  
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->ok_button),
  		     "clicked", 
  		     GTK_SIGNAL_FUNC(NewMascotSelectImage), (gpointer)cdata);
  
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->cancel_button),
		     "clicked", 
		     GTK_SIGNAL_FUNC(close_child_dialog), 
		     GTK_WIDGET(fdialog));


  hbox = gtk_hbox_new(FALSE,5);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
  gtk_box_pack_start(GTK_BOX(GTK_FILE_SELECTION(fdialog)->action_area),
		     hbox,FALSE,FALSE,0);

  button=gtk_button_new_with_label(_("User Pix Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_updir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(_("Common Pix Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_dpdir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(PNG_EXTENSION);
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_pngext), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(GIF_EXTENSION);
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_gifext), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(XPM_EXTENSION);
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_xpmext), 
		     (gpointer)fdialog);

  gtk_file_selection_set_filename (GTK_FILE_SELECTION (fdialog), 
  				   cdata->mascot_file);
  gtk_file_selection_complete (GTK_FILE_SELECTION (fdialog), 
			       "");

  gtk_widget_show_all(fdialog);
  
  gtk_main();

  if(cdata->update){
  }

  flagChildDialog=FALSE;
  gtk_main_quit();
  while (g_main_iteration(FALSE));
}


static void create_new_mascot_dialog(GtkWidget *w, gpointer gdata)
{
  GtkWidget *dialog;
  GtkWidget *button_cancel;
  GtkWidget *button_ok;
  GtkWidget *table;
  GtkWidget *hbox;
  GtkWidget *label;
  GtkWidget *entry;
  confNewMascot *cdata;

  Mascot->flag_menu=TRUE;

  cdata=g_malloc0(sizeof(confNewMascot));

  cdata->mascot_file=NULL;
  cdata->image_file=NULL;
  cdata->copyright=NULL;
  cdata->update=FALSE;

  dialog = gtk_dialog_new();
  gtk_container_border_width(GTK_CONTAINER(dialog),5);
  gtk_window_set_title(GTK_WINDOW(dialog),_("Create New Mascot"));
  
  gtk_signal_connect(GTK_OBJECT(dialog),"destroy",
		     GTK_SIGNAL_FUNC(gtk_main_quit), 
		     NULL);
  
  cdata->dialog=dialog;
  

  label=gtk_label_new(_("Creating New Masscot..."));
  gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),
		     label,TRUE,TRUE,0);

  label=gtk_label_new("");
  gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),
		     label,TRUE,TRUE,0);

  hbox=gtk_hbox_new(FALSE,0);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),
		     hbox,TRUE,TRUE,0);
  label=gtk_label_new(_("1. Please select Mascot File Name to be created"));
  gtk_misc_set_alignment (GTK_MISC (label), 0.5, 0.5);
  gtk_box_pack_start(GTK_BOX(hbox),label,TRUE,TRUE,0);
  

  button_ok=gtk_button_new_with_label(_("OK"));
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		     button_ok,TRUE,TRUE,0);
  gtk_signal_connect(GTK_OBJECT(button_ok),"pressed",
  		     GTK_SIGNAL_FUNC(create_new_mascot_file_selection_dialog), 
  		     (gpointer)cdata);
  
  button_cancel=gtk_button_new_with_label(_("Cancel"));
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		     button_cancel,TRUE,TRUE,0);
  gtk_signal_connect(GTK_OBJECT(button_cancel),"pressed",
		     GTK_SIGNAL_FUNC(close_new_mascot_dialog), 
		     GTK_WIDGET(dialog));

  
  gtk_widget_show_all(dialog);
  gtk_main();

  // Mascot File : CancelƤ齪λ
  if(!cdata->update){
    g_free(cdata);
    Mascot->flag_menu=FALSE;
    return;
  }

  cdata->update=FALSE;

  gtk_widget_destroy(hbox);
  gtk_widget_destroy(button_ok);
  gtk_widget_destroy(button_cancel);

  hbox=gtk_hbox_new(FALSE,0);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),
		     hbox,TRUE,TRUE,0);
  label=gtk_label_new(_("2. Please select an Image File Name to be used in Mascot"));
  gtk_misc_set_alignment (GTK_MISC (label), 0.5, 0.5);
  gtk_box_pack_start(GTK_BOX(hbox),label,TRUE,TRUE,0);

  button_ok=gtk_button_new_with_label(_("OK"));
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		     button_ok,TRUE,TRUE,0);
  gtk_signal_connect(GTK_OBJECT(button_ok),"pressed",
  		     GTK_SIGNAL_FUNC(create_new_mascot_image_selection_dialog), 
  		     (gpointer)cdata);

  button_cancel=gtk_button_new_with_label(_("Cancel"));
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		     button_cancel,TRUE,TRUE,0);
  gtk_signal_connect(GTK_OBJECT(button_cancel),"pressed",
		     GTK_SIGNAL_FUNC(close_new_mascot_dialog), 
		     GTK_WIDGET(dialog));

  gtk_widget_show_all(dialog);
  gtk_widget_map(dialog);
  gtk_main();


  
  // Mascot Image : CancelƤ齪λ
  if(!cdata->update){
    g_free(cdata);
    Mascot->flag_menu=FALSE;
    return;
  }

  cdata->update=FALSE;

  gtk_widget_destroy(hbox);
  gtk_widget_destroy(button_ok);
  gtk_widget_destroy(button_cancel);

  table=gtk_table_new(2,6,FALSE);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),
		     table,TRUE,TRUE,0);
  label=gtk_label_new(_("Mascot File : "));
  gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
  gtk_table_attach_defaults (GTK_TABLE(table), label, 0, 1, 0, 1);
  label=gtk_label_new(cdata->mascot_file);
  gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
  gtk_table_attach_defaults (GTK_TABLE(table), label, 1, 2, 0, 1);
  label=gtk_label_new(_("Image File : "));
  gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
  gtk_table_attach_defaults (GTK_TABLE(table), label, 0, 1, 1, 2);
  label=gtk_label_new(cdata->image_file);
  gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
  gtk_table_attach_defaults (GTK_TABLE(table), label, 1, 2, 1, 2);
  label=gtk_label_new("");
  gtk_misc_set_alignment (GTK_MISC (label), 0.5, 0.5);
  gtk_table_attach_defaults (GTK_TABLE(table), label, 0, 2, 2, 3);
  label=gtk_label_new(_("At last, Please Input Descrption for Copyright"));
  gtk_misc_set_alignment (GTK_MISC (label), 0.5, 0.5);
  gtk_table_attach_defaults (GTK_TABLE(table), label, 0, 2, 3, 4);

  entry = gtk_entry_new ();
  gtk_entry_set_text(GTK_ENTRY(entry),"Copyright (C) ");
  gtk_entry_set_editable(GTK_ENTRY(entry),TRUE);
  label=gtk_label_new(_("At last, Please Input Descrption for Copyright"));
  gtk_misc_set_alignment (GTK_MISC (label), 0.5, 0.5);
  gtk_table_attach_defaults (GTK_TABLE(table), entry, 0, 2, 4, 5);
  gtk_signal_connect (GTK_OBJECT(entry),
		      "changed",
		      GTK_SIGNAL_FUNC(cc_get_entry),
		      &cdata->copyright);

  button_ok=gtk_button_new_with_label(_("OK"));
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		     button_ok,TRUE,TRUE,0);
  gtk_signal_connect(GTK_OBJECT(button_ok),"pressed",
		     GTK_SIGNAL_FUNC(MakeNewMascot), 
		     (gpointer)cdata);

  button_cancel=gtk_button_new_with_label(_("Cancel"));
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		     button_cancel,TRUE,TRUE,0);
  gtk_signal_connect(GTK_OBJECT(button_cancel),"pressed",
		     GTK_SIGNAL_FUNC(close_new_mascot_dialog), 
		     GTK_WIDGET(dialog));

  gtk_widget_show_all(dialog);
  gtk_widget_map(dialog);
  gtk_main();

  g_free(cdata);
  Mascot->flag_menu=FALSE;
}

static void create_file_selection_dialog(void)
{
  GtkWidget *fdialog;
  GtkWidget *button;
  GtkWidget *hbox;

  // WinۤϽŤΤExpose٥򤹤٤ƽƤ
  while (g_main_iteration(FALSE));


  Mascot->flag_menu=TRUE;
  
  fdialog = gtk_file_selection_new(_("Open Mascot"));

  gtk_signal_connect(GTK_OBJECT(fdialog),"destroy",
		     GTK_SIGNAL_FUNC(close_dialog), 
		     GTK_WIDGET(fdialog));
  
  gtk_signal_connect(
     GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->ok_button),
     "clicked", 
     GTK_SIGNAL_FUNC(ChangeMascotFS), fdialog);

  gtk_signal_connect(
     GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->cancel_button),
     "clicked", 
     GTK_SIGNAL_FUNC(close_dialog), 
     GTK_WIDGET(fdialog));

  gtk_file_selection_set_filename (GTK_FILE_SELECTION (fdialog), 
				   Mascot->file);
  gtk_file_selection_complete (GTK_FILE_SELECTION (fdialog), 
				   MASCOT_EXTENSION);
  gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (fdialog));


  hbox = gtk_hbox_new(FALSE,5);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
  gtk_box_pack_start(GTK_BOX(GTK_FILE_SELECTION(fdialog)->action_area),
		     hbox,FALSE,FALSE,0);
  
  button=gtk_button_new_with_label(_("User Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_udir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(_("Common Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_ddir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(MASCOT_EXTENSION);
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_mascotext), 
		     (gpointer)fdialog);

  gtk_widget_show_all(fdialog);

  gtk_main();

}

  
static void create_menu_selection_dialog(void)
{
  GtkWidget *fdialog;
  GtkWidget *button;
  GtkWidget *hbox;
  gchar *filepath;

  // WinۤϽŤΤExpose٥򤹤٤ƽƤ
  while (g_main_iteration(FALSE));


  Mascot->flag_menu=TRUE;
  
  fdialog = gtk_file_selection_new(_("Open Launcher Menu"));

  gtk_signal_connect(GTK_OBJECT(fdialog),"destroy",
		     GTK_SIGNAL_FUNC(close_dialog), 
		     GTK_WIDGET(fdialog));
  
  gtk_signal_connect(
     GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->ok_button),
     "clicked", 
     GTK_SIGNAL_FUNC(ChangeMenuFS), fdialog);

  gtk_signal_connect(
     GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->cancel_button),
     "clicked", 
     GTK_SIGNAL_FUNC(close_dialog), 
     GTK_WIDGET(fdialog));

  if(Mascot->menu_file){
     gtk_file_selection_set_filename (GTK_FILE_SELECTION (fdialog), 
				      Mascot->menu_file);
  }
  else{
    filepath=g_strconcat(g_get_home_dir(), "/",USER_DIR, NULL);
    gtk_file_selection_set_filename (GTK_FILE_SELECTION (fdialog),filepath);
  }
  gtk_file_selection_complete (GTK_FILE_SELECTION (fdialog), 
				   MENU_EXTENSION);
  gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (fdialog));


  hbox = gtk_hbox_new(FALSE,5);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
  gtk_box_pack_start(GTK_BOX(GTK_FILE_SELECTION(fdialog)->action_area),
		     hbox,FALSE,FALSE,0);
  

  button=gtk_button_new_with_label(_("User Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_udir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(_("Common Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_ddir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(MENU_EXTENSION);
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_menuext), 
		     (gpointer)fdialog);


  gtk_widget_show_all(fdialog);

  gtk_main();

}


static void create_smenu_dialog2(void)
{
  // WinۤϽŤΤExpose٥򤹤٤ƽƤ
  while (g_main_iteration(FALSE));


  Mascot->flag_menu=TRUE;

  create_smenu_dialog(Mascot,TRUE);

  Mascot->flag_menu=FALSE;
}


static void create_nkr_selection_dialog(void)
{
  GtkWidget *fdialog;
  GtkWidget *button;
  GtkWidget *hbox;

  // WinۤϽŤΤExpose٥򤹤٤ƽƤ
  while (g_main_iteration(FALSE));


  Mascot->flag_menu=TRUE;
  
  fdialog = gtk_file_selection_new(_("Convert from Nokkari-Chara"));

  gtk_signal_connect(GTK_OBJECT(fdialog),"destroy",
		     GTK_SIGNAL_FUNC(close_dialog), 
		     GTK_WIDGET(fdialog));
  
  gtk_signal_connect(
     GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->ok_button),
     "clicked", 
     GTK_SIGNAL_FUNC(NkrChangeMascotFS), fdialog);

  gtk_signal_connect(
     GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->cancel_button),
     "clicked", 
     GTK_SIGNAL_FUNC(close_dialog), 
     GTK_WIDGET(fdialog));

  gtk_file_selection_complete (GTK_FILE_SELECTION (fdialog), 
				   NKR_EXTENSION);
  gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (fdialog));


  hbox = gtk_hbox_new(FALSE,5);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
  gtk_box_pack_start(GTK_BOX(GTK_FILE_SELECTION(fdialog)->action_area),
		     hbox,FALSE,FALSE,0);
  
  button=gtk_button_new_with_label(_("User Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_udir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(_("Common Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_ddir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(NKR_EXTENSION);
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_nkrext), 
		     (gpointer)fdialog);

  gtk_widget_show_all(fdialog);

  gtk_main();

}

  
static void create_new_menu_selection_dialog(void)
{
  GtkWidget *fdialog;
  GtkWidget *button;
  GtkWidget *hbox;
  gchar *filepath;

  // WinۤϽŤΤExpose٥򤹤٤ƽƤ
  while (g_main_iteration(FALSE));


  Mascot->flag_menu=TRUE;
  
  fdialog = gtk_file_selection_new(_("Select New Launcher Menu File to Create"));

  gtk_signal_connect(GTK_OBJECT(fdialog),"destroy",
		     GTK_SIGNAL_FUNC(close_dialog), 
		     GTK_WIDGET(fdialog));
  
  gtk_signal_connect(
     GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->ok_button),
     "clicked", 
     GTK_SIGNAL_FUNC(MakeMenuFS), GTK_FILE_SELECTION(fdialog));

  gtk_signal_connect(
     GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->cancel_button),
     "clicked", 
     GTK_SIGNAL_FUNC(close_dialog), 
     GTK_WIDGET(fdialog));

  filepath=g_strconcat(g_get_home_dir(), "/",USER_DIR, NULL);
  gtk_file_selection_set_filename (GTK_FILE_SELECTION (fdialog),filepath);
  gtk_file_selection_complete (GTK_FILE_SELECTION (fdialog), 
			       MENU_EXTENSION);
  gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (fdialog));


  hbox = gtk_hbox_new(FALSE,5);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
  gtk_box_pack_start(GTK_BOX(GTK_FILE_SELECTION(fdialog)->action_area),
		     hbox,FALSE,FALSE,0);

  
  button=gtk_button_new_with_label(_("User Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_udir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(_("Common Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_ddir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(MENU_EXTENSION);
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_menuext), 
		     (gpointer)fdialog);

  gtk_widget_show_all(fdialog);

  gtk_main();
}

  
static void create_save_mascot_dialog(void)
{
  GtkWidget *fdialog;
  GtkWidget *hbox;
  GtkWidget *button;

  // WinۤϽŤΤExpose٥򤹤٤ƽƤ
  while (g_main_iteration(FALSE));


  Mascot->flag_menu=TRUE;
  
  fdialog = gtk_file_selection_new(_("Save Mascot to Other File"));

  gtk_signal_connect(GTK_OBJECT(fdialog),"destroy",
		     GTK_SIGNAL_FUNC(close_dialog), 
		     GTK_WIDGET(fdialog));
  
  gtk_signal_connect(
     GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->ok_button),
     "clicked", 
     GTK_SIGNAL_FUNC(SaveMascotOther), fdialog);

  gtk_signal_connect(
     GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->cancel_button),
     "clicked", 
     GTK_SIGNAL_FUNC(close_dialog), 
     GTK_WIDGET(fdialog));

  gtk_file_selection_set_filename (GTK_FILE_SELECTION (fdialog), 
				   Mascot->file);
  gtk_file_selection_complete (GTK_FILE_SELECTION (fdialog), 
				   MASCOT_EXTENSION);
  //gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (fdialog));


  hbox = gtk_hbox_new(FALSE,5);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
  gtk_box_pack_start(GTK_BOX(GTK_FILE_SELECTION(fdialog)->action_area),
		     hbox,FALSE,FALSE,0);

  
  button=gtk_button_new_with_label(_("User Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_udir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(_("Common Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_ddir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(MASCOT_EXTENSION);
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_mascotext), 
		     (gpointer)fdialog);

  gtk_widget_show_all(fdialog);


  gtk_main();
}

static void create_nkr_save_mascot_dialog(void)
{
  GtkWidget *fdialog;
  GtkWidget *hbox;
  GtkWidget *button;

  // WinۤϽŤΤExpose٥򤹤٤ƽƤ
  while (g_main_iteration(FALSE));


  fdialog = gtk_file_selection_new(_("Appoint MaCoPiX File to Save"));

  gtk_signal_connect(GTK_OBJECT(fdialog),"destroy",
		     GTK_SIGNAL_FUNC(close_dialog), 
		     GTK_WIDGET(fdialog));
  
  gtk_signal_connect(
     GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->ok_button),
     "clicked", 
     GTK_SIGNAL_FUNC(SaveMascotOther), fdialog);

  gtk_signal_connect(
     GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->cancel_button),
     "clicked", 
     GTK_SIGNAL_FUNC(close_dialog), 
     GTK_WIDGET(fdialog));

  gtk_file_selection_complete (GTK_FILE_SELECTION (fdialog), 
				   MASCOT_EXTENSION);
  //gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (fdialog));


  hbox = gtk_hbox_new(FALSE,5);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
  gtk_box_pack_start(GTK_BOX(GTK_FILE_SELECTION(fdialog)->action_area),
		     hbox,FALSE,FALSE,0);

  
  button=gtk_button_new_with_label(_("User Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_udir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(_("Common Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_ddir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(MASCOT_EXTENSION);
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_mascotext), 
		     (gpointer)fdialog);

  gtk_widget_show_all(fdialog);


  gtk_main();
}

static void create_save_nokkari_dialog(void)
{
  GtkWidget *fdialog;
  GtkWidget *hbox;
  GtkWidget *button;

  // WinۤϽŤΤExpose٥򤹤٤ƽƤ
  while (g_main_iteration(FALSE));


  Mascot->flag_menu=TRUE;
  
  fdialog = gtk_file_selection_new(_("Convert Mascot to Nokkari-Chara"));

  gtk_signal_connect(GTK_OBJECT(fdialog),"destroy",
		     GTK_SIGNAL_FUNC(close_dialog), 
		     GTK_WIDGET(fdialog));
  
  gtk_signal_connect(
     GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->ok_button),
     "clicked", 
     GTK_SIGNAL_FUNC(SaveNokkari), fdialog);

  gtk_signal_connect(
     GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->cancel_button),
     "clicked", 
     GTK_SIGNAL_FUNC(close_dialog), 
     GTK_WIDGET(fdialog));

  gtk_file_selection_complete (GTK_FILE_SELECTION (fdialog), 
				   NKR_EXTENSION);
  //gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (fdialog));


  hbox = gtk_hbox_new(FALSE,5);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
  gtk_box_pack_start(GTK_BOX(GTK_FILE_SELECTION(fdialog)->action_area),
		     hbox,FALSE,FALSE,0);

  
  button=gtk_button_new_with_label(_("User Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_udir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(_("Common Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_ddir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(NKR_EXTENSION);
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_nkrext), 
		     (gpointer)fdialog);

  gtk_widget_show_all(fdialog);


  gtk_main();
}

static void create_save_release_mascot_dialog(void)
{
  GtkWidget *fdialog;
  GtkWidget *dialog;
  GtkWidget *table;
  GtkWidget *label;
  GtkWidget *button;
  GtkWidget *entry;
  GtkWidget *check;
  GtkWidget *hbox;
  confSaveReleaseMascot *cdata;


  Mascot->flag_menu=TRUE;

  // WinۤϽŤΤExpose٥򤹤٤ƽƤ
  while (g_main_iteration(FALSE));

  cdata=g_malloc0(sizeof(confSaveReleaseMascot));

  // Copyrightѥ
  dialog = gtk_dialog_new();
  gtk_container_border_width(GTK_CONTAINER(dialog),5);
  gtk_window_set_title(GTK_WINDOW(dialog),_("Setup for Release Mascot"));
  
  gtk_signal_connect(GTK_OBJECT(dialog),"destroy",
		     GTK_SIGNAL_FUNC(gtk_main_quit), 
		     NULL);


  cdata->dialog=dialog;
  cdata->update=FALSE;
  cdata->font_flag=FALSE;
 

  label=gtk_label_new(_("Please edit the setting for this mascot"));
  gtk_misc_set_alignment (GTK_MISC (label), 0.5, 0.5);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),label,TRUE,TRUE,0);
  
  table = gtk_table_new (2, 4, FALSE);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),table,TRUE,TRUE,0);


  label=gtk_label_new(_("Mascot Name"));
  gtk_misc_set_alignment (GTK_MISC (label), 0.5, 0.5);
  gtk_table_attach(GTK_TABLE(table), label, 0, 1, 0, 1,
		   GTK_FILL,GTK_SHRINK,0,0);

  entry = gtk_entry_new ();
  if(Mascot->name){
    gtk_entry_set_text(GTK_ENTRY(entry),Mascot->name);
  }
  gtk_entry_set_editable(GTK_ENTRY(entry),TRUE);
  gtk_table_attach_defaults(GTK_TABLE(table), entry, 1, 2, 0, 1);
  cdata->name_entry=entry;


  label=gtk_label_new(_("Copyright"));
  gtk_misc_set_alignment (GTK_MISC (label), 0.5, 0.5);
  gtk_table_attach(GTK_TABLE(table), label, 0, 1, 1, 2,
		   GTK_FILL,GTK_SHRINK,0,0);

  entry = gtk_entry_new ();
  if(Mascot->copyright){
    gtk_entry_set_text(GTK_ENTRY(entry),Mascot->copyright);
  }
  else{
    gtk_entry_set_text(GTK_ENTRY(entry),"Copyright (C)");
  }
  gtk_entry_set_editable(GTK_ENTRY(entry),TRUE);
  gtk_table_attach_defaults(GTK_TABLE(table), entry, 1, 2, 1, 2);
  cdata->copyright_entry=entry;


  label=gtk_label_new(_("Character Code"));
  gtk_misc_set_alignment (GTK_MISC (label), 0.5, 0.5);
  gtk_table_attach(GTK_TABLE(table), label, 0, 1, 2, 3,
		   GTK_FILL,GTK_SHRINK,0,0);

  entry = gtk_entry_new ();
  gtk_entry_set_text(GTK_ENTRY(entry),DEF_CODE1);
  gtk_entry_set_editable(GTK_ENTRY(entry),TRUE);
  gtk_table_attach_defaults(GTK_TABLE(table), entry, 1, 2, 2, 3);
  cdata->code_entry=entry;


  check = gtk_check_button_new_with_label(_("Save Fontset"));
  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(check),FALSE);
  gtk_table_attach(GTK_TABLE(table), check, 0, 2, 3, 4,
		   GTK_FILL,GTK_SHRINK,0,0);
  cdata->font_check=check;

  
  button=gtk_button_new_with_label(_("OK"));
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		     button,TRUE,TRUE,0);
  gtk_signal_connect(GTK_OBJECT(button),"pressed",
  		     GTK_SIGNAL_FUNC(GoRelease), 
  		     (gpointer)cdata);
  
  button=gtk_button_new_with_label(_("Cancel"));
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		     button,TRUE,TRUE,0);
  gtk_signal_connect(GTK_OBJECT(button),"pressed",
		     GTK_SIGNAL_FUNC(close_child_dialog), 
		     GTK_WIDGET(dialog));

  
  gtk_widget_show_all(dialog);
  gtk_main();

  // Mascot File : CancelƤ齪λ
  if(!cdata->update){
    g_free(cdata);
    Mascot->flag_menu=FALSE;
    return;
  }

  

  // WinۤϽŤΤExpose٥򤹤٤ƽƤ
  while (g_main_iteration(FALSE));

  
  fdialog = gtk_file_selection_new(_("Save Mascot for Release"));

  cdata->fdialog=fdialog;
  cdata->update=FALSE;

  gtk_signal_connect(GTK_OBJECT(fdialog),"destroy",
		     GTK_SIGNAL_FUNC(close_dialog), 
		     GTK_WIDGET(fdialog));
  
  gtk_signal_connect(
     GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->ok_button),
     "clicked", 
     GTK_SIGNAL_FUNC(SaveReleaseMascot), (gpointer)cdata);

  gtk_signal_connect(
     GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->cancel_button),
     "clicked", 
     GTK_SIGNAL_FUNC(close_dialog), 
     GTK_WIDGET(fdialog));

  gtk_file_selection_complete (GTK_FILE_SELECTION (fdialog), 
			       MASCOT_EXTENSION);
  gtk_file_selection_set_filename (GTK_FILE_SELECTION (fdialog), 
				   g_basename(Mascot->file));
  //gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (fdialog));

  hbox = gtk_hbox_new(FALSE,5);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
  gtk_box_pack_start(GTK_BOX(GTK_FILE_SELECTION(fdialog)->action_area),
		     hbox,FALSE,FALSE,0);

  
  button=gtk_button_new_with_label(_("User Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_udir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(_("Common Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_ddir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(MASCOT_EXTENSION);
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_mascotext), 
		     (gpointer)fdialog);

  gtk_widget_show_all(fdialog);

  gtk_main();

  g_free(cdata);
}

static void create_save_menu_dialog(void)
{
  GtkWidget *fdialog;
  GtkWidget *button;
  GtkWidget *hbox;

  // WinۤϽŤΤExpose٥򤹤٤ƽƤ
  while (g_main_iteration(FALSE));


  Mascot->flag_menu=TRUE;
  
  fdialog = gtk_file_selection_new(_("Save Menu to File"));

  gtk_signal_connect(GTK_OBJECT(fdialog),"destroy",
		     GTK_SIGNAL_FUNC(close_dialog), 
		     GTK_WIDGET(fdialog));
  
  gtk_signal_connect(
     GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->ok_button),
     "clicked", 
     GTK_SIGNAL_FUNC(SaveMenuOther), fdialog);

  gtk_signal_connect(
     GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->cancel_button),
     "clicked", 
     GTK_SIGNAL_FUNC(close_dialog), 
     GTK_WIDGET(fdialog));

  gtk_file_selection_complete (GTK_FILE_SELECTION (fdialog), 
				   MENU_EXTENSION);
  if(Mascot->menu_file){
    gtk_file_selection_set_filename (GTK_FILE_SELECTION (fdialog), 
				     Mascot->menu_file);
  }
  //gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (fdialog));

  hbox = gtk_hbox_new(FALSE,5);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
  gtk_box_pack_start(GTK_BOX(GTK_FILE_SELECTION(fdialog)->action_area),
		     hbox,FALSE,FALSE,0);

  
  button=gtk_button_new_with_label(_("User Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_udir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(_("Common Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_ddir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(MENU_EXTENSION);
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_menuext), 
		     (gpointer)fdialog);

  gtk_widget_show_all(fdialog);

  gtk_main();
}

static void create_save_rc_dialog(void)
{
  GtkWidget *fdialog;
  GtkWidget *button;
  GtkWidget *hbox;

  // WinۤϽŤΤExpose٥򤹤٤ƽƤ
  while (g_main_iteration(FALSE));


  Mascot->flag_menu=TRUE;
  
  fdialog = gtk_file_selection_new(_("Save Resource to File"));

  gtk_signal_connect(GTK_OBJECT(fdialog),"destroy",
		     GTK_SIGNAL_FUNC(close_dialog), 
		     GTK_WIDGET(fdialog));
  
  gtk_signal_connect(
     GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->ok_button),
     "clicked", 
     GTK_SIGNAL_FUNC(SaveRCOther), fdialog);

  gtk_signal_connect(
     GTK_OBJECT(GTK_FILE_SELECTION(fdialog)->cancel_button),
     "clicked", 
     GTK_SIGNAL_FUNC(close_dialog), 
     GTK_WIDGET(fdialog));

  gtk_file_selection_complete (GTK_FILE_SELECTION (fdialog), 
				   RC_EXTENSION);
  if(Mascot->rcfile){
    gtk_file_selection_set_filename (GTK_FILE_SELECTION (fdialog), 
				     Mascot->rcfile);
  }
  //gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (fdialog));


  hbox = gtk_hbox_new(FALSE,5);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
  gtk_box_pack_start(GTK_BOX(GTK_FILE_SELECTION(fdialog)->action_area),
		     hbox,FALSE,FALSE,0);

  
  button=gtk_button_new_with_label(_("User Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_udir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(_("Common Dir"));
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_ddir), 
		     (gpointer)fdialog);

  button=gtk_button_new_with_label(RC_EXTENSION);
  gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked", 
		     GTK_SIGNAL_FUNC(fs_set_rcext), 
		     (gpointer)fdialog);

  gtk_widget_show_all(fdialog);

  gtk_main();
}


static void create_font_selection_dialog(GtkWidget *w, gpointer gdata)
{
  GtkWidget *fdialog;
  int bal_clk;
  confFont *cdata;

  if(flagChildDialog){
    return;
  }
  else{
    flagChildDialog=TRUE;
  }

  cdata=g_malloc0(sizeof(confFont));

  bal_clk=(int)gdata;

  // WinۤϽŤΤExpose٥򤹤٤ƽƤ
  while (g_main_iteration(FALSE));


  fdialog = gtk_font_selection_dialog_new(_("Fontset Selection"));
  cdata->fsd=GTK_FONT_SELECTION_DIALOG(fdialog);

  cdata->fn=NULL;

  switch(bal_clk){
  case CONF_FONT_CLK:
    cdata->entry=entry_fontname_clk;
    gtk_font_selection_dialog_set_font_name(cdata->fsd,
					    tmp_mascot.fontname_clk);
    break;
  case CONF_FONT_BAL:
    cdata->entry=entry_fontname_bal;
    gtk_font_selection_dialog_set_font_name(cdata->fsd,
					    tmp_mascot.fontname_bal);
    break;
  case CONF_DEF_FONT_CLK:
    cdata->entry=entry_deffontname_clk;
    gtk_font_selection_dialog_set_font_name(cdata->fsd,
					    tmp_mascot.deffontname_clk);
    break;
  case CONF_DEF_FONT_BAL:
    cdata->entry=entry_deffontname_bal;
    gtk_font_selection_dialog_set_font_name(cdata->fsd,
					    tmp_mascot.deffontname_bal);
    break;
  }

  gtk_signal_connect(
       GTK_OBJECT(GTK_FONT_SELECTION_DIALOG(fdialog)->ok_button),
       "clicked", 
       GTK_SIGNAL_FUNC(ChangeFontname), (gpointer)cdata);
    
  gtk_signal_connect(GTK_OBJECT(fdialog),"destroy",
		     GTK_SIGNAL_FUNC(close_child_dialog), 
		     GTK_WIDGET(fdialog));
  
  gtk_signal_connect(
     GTK_OBJECT(GTK_FONT_SELECTION_DIALOG(fdialog)->cancel_button),
     "clicked", 
     GTK_SIGNAL_FUNC(close_child_dialog),GTK_WIDGET(fdialog));

  gtk_widget_show(fdialog);

  gtk_main();

  if(cdata->fn){
    switch(bal_clk){
    case CONF_FONT_CLK:
      tmp_mascot.fontname_clk=cdata->fn;
      break;
    case CONF_FONT_BAL:
      tmp_mascot.fontname_bal=cdata->fn;
      break;
    case CONF_DEF_FONT_CLK:
      tmp_mascot.deffontname_clk=cdata->fn;
      break;
    case CONF_DEF_FONT_BAL:
      tmp_mascot.deffontname_bal=cdata->fn;
      break;
    }
  }

  g_free(cdata);
  flagChildDialog=FALSE;
}
  

static void create_color_selection_dialog(GtkWidget *w, gpointer gdata)
{
  GdkColor init_col = {0, 0, 0, 0};
  GtkWidget *fdialog;
  int bal_clk;
  confColor *cdata=NULL;
  gdouble selcolor[4];

  if(flagChildDialog){
    return;
  }
  else{
    flagChildDialog=TRUE;
  }


  cdata=g_malloc0(sizeof(confColor));

  bal_clk=(int)gdata;

  // WinۤϽŤΤExpose٥򤹤٤ƽƤ
  while (g_main_iteration(FALSE));


  fdialog = gtk_color_selection_dialog_new(_("Color Selection"));
  //gtk_color_selection_set_opacity
  //  (GTK_COLOR_SELECTION (GTK_COLOR_SELECTION_DIALOG (fdialog)->colorsel),
  //  TRUE);

  gtk_color_selection_set_update_policy
    (GTK_COLOR_SELECTION (GTK_COLOR_SELECTION_DIALOG (fdialog)->colorsel),
     GTK_UPDATE_CONTINUOUS);

  cdata->csd=GTK_COLOR_SELECTION_DIALOG(fdialog);
  cdata->color=&init_col;
  cdata->update=FALSE;
  cdata->button=w;

  selcolor[3]=0;
  switch(bal_clk){
  case CONF_COLOR_CLK:
    selcolor[0]=(gdouble)tmp_mascot.colclk->red/0xFFFF;
    selcolor[1]=(gdouble)tmp_mascot.colclk->green/0xFFFF;
    selcolor[2]=(gdouble)tmp_mascot.colclk->blue/0xFFFF;
    break;
  case CONF_COLOR_CLKBG:
    selcolor[0]=(gdouble)tmp_mascot.colclkbg->red/0xFFFF;
    selcolor[1]=(gdouble)tmp_mascot.colclkbg->green/0xFFFF;
    selcolor[2]=(gdouble)tmp_mascot.colclkbg->blue/0xFFFF;
    break;
  case CONF_COLOR_CLKBD:
    selcolor[0]=(gdouble)tmp_mascot.colclkbd->red/0xFFFF;
    selcolor[1]=(gdouble)tmp_mascot.colclkbd->green/0xFFFF;
    selcolor[2]=(gdouble)tmp_mascot.colclkbd->blue/0xFFFF;
    break;
  case CONF_COLOR_CLKSD:
    selcolor[0]=(gdouble)tmp_mascot.colclksd->red/0xFFFF;
    selcolor[1]=(gdouble)tmp_mascot.colclksd->green/0xFFFF;
    selcolor[2]=(gdouble)tmp_mascot.colclksd->blue/0xFFFF;
    break;
  case CONF_COLOR_BAL:
    selcolor[0]=(gdouble)tmp_mascot.colbal->red/0xFFFF;
    selcolor[1]=(gdouble)tmp_mascot.colbal->green/0xFFFF;
    selcolor[2]=(gdouble)tmp_mascot.colbal->blue/0xFFFF;
    break;
  case CONF_COLOR_BALBG:
    selcolor[0]=(gdouble)tmp_mascot.colbalbg->red/0xFFFF;
    selcolor[1]=(gdouble)tmp_mascot.colbalbg->green/0xFFFF;
    selcolor[2]=(gdouble)tmp_mascot.colbalbg->blue/0xFFFF;
    break;
  case CONF_COLOR_BALBD:
    selcolor[0]=(gdouble)tmp_mascot.colbalbd->red/0xFFFF;
    selcolor[1]=(gdouble)tmp_mascot.colbalbd->green/0xFFFF;
    selcolor[2]=(gdouble)tmp_mascot.colbalbd->blue/0xFFFF;
    break;
  }
  gtk_color_selection_set_color(
      GTK_COLOR_SELECTION (GTK_COLOR_SELECTION_DIALOG (fdialog)->colorsel),
      selcolor);

  gtk_signal_connect(
       GTK_OBJECT(GTK_COLOR_SELECTION_DIALOG(fdialog)->ok_button),
       "clicked", 
       GTK_SIGNAL_FUNC(ChangeColor), (gpointer)cdata);
    
  gtk_signal_connect(GTK_OBJECT(fdialog),"destroy",
		     GTK_SIGNAL_FUNC(close_child_dialog), 
		     GTK_WIDGET(fdialog));
  
  gtk_signal_connect(
     GTK_OBJECT(GTK_COLOR_SELECTION_DIALOG(fdialog)->cancel_button),
     "clicked", 
     GTK_SIGNAL_FUNC(close_child_dialog),GTK_WIDGET(fdialog));

  gtk_widget_show(fdialog);

  gtk_main();
  
  if(cdata->update){
    switch(bal_clk){
    case CONF_COLOR_CLK:
      gdk_color_free(tmp_mascot.colclk);
      tmp_mascot.colclk=gdk_color_copy(cdata->color);
      break;
    case CONF_COLOR_CLKBG:
      gdk_color_free(tmp_mascot.colclkbg);
      tmp_mascot.colclkbg=gdk_color_copy(cdata->color);
      break;
    case CONF_COLOR_CLKBD:
      gdk_color_free(tmp_mascot.colclkbd);
      tmp_mascot.colclkbd=gdk_color_copy(cdata->color);
      break;
    case CONF_COLOR_CLKSD:
      gdk_color_free(tmp_mascot.colclksd);
      tmp_mascot.colclksd=gdk_color_copy(cdata->color);
      break;
    case CONF_COLOR_BAL:
      gdk_color_free(tmp_mascot.colbal);
      tmp_mascot.colbal=gdk_color_copy(cdata->color);
      break;
    case CONF_COLOR_BALBG:
      gdk_color_free(tmp_mascot.colbalbg);
      tmp_mascot.colbalbg=gdk_color_copy(cdata->color);
      break;
    case CONF_COLOR_BALBD:
      gdk_color_free(tmp_mascot.colbalbd);
      tmp_mascot.colbalbd=gdk_color_copy(cdata->color);
      break;
    }
  }

  g_free(cdata);
  flagChildDialog=FALSE;
}
  


// 
void create_config_dialog(void)
{
  GtkWidget *conf_main;
  GtkWidget *conf_tbl;
  GtkWidget *all_note;
  GtkWidget *button;
  int i_pix;

  // WinۤϽŤΤExpose٥򤹤٤ƽƤ
  while (g_main_iteration(FALSE));

  Mascot->flag_menu=TRUE;

  // ƥݥǡѰ
  tmp_mascot=*Mascot;
  for(i_pix=0;i_pix<MAX_PIXMAP;i_pix++){
    tmp_pixfile[i_pix]=Mascot->sprites[i_pix].filename;
  }

#ifdef USE_GTK2  
  conf_main = gtk_window_new(GTK_WINDOW_TOPLEVEL);
#else
  conf_main = gtk_window_new(GTK_WINDOW_DIALOG);
#endif
  gtk_window_set_title(GTK_WINDOW(conf_main), 
		       _("Config for MaCoPiX"));
  //gtk_widget_set_app_paintable(conf_main, TRUE);
  gtk_widget_realize(conf_main);
  gtk_signal_connect(GTK_OBJECT(conf_main),"destroy",
		     GTK_SIGNAL_FUNC(close_conf), 
		     GTK_WIDGET(conf_main));
  gtk_container_set_border_width (GTK_CONTAINER (conf_main), 5);
  
  // 3x6Υơ֥
  conf_tbl = gtk_table_new (3, 6, FALSE);
  gtk_container_add (GTK_CONTAINER (conf_main), conf_tbl);


  all_note = gtk_notebook_new ();
  gtk_notebook_set_tab_pos (GTK_NOTEBOOK (all_note), GTK_POS_TOP);
  gtk_notebook_set_scrollable (GTK_NOTEBOOK (all_note), TRUE);

  gtk_table_attach_defaults (GTK_TABLE(conf_tbl), all_note, 0, 6, 0, 1);


  /////// ޥåȶ̤ ///////
  {
  GtkWidget *conf_note;
  GtkWidget *label;

  conf_note = gtk_notebook_new ();
  gtk_notebook_set_tab_pos (GTK_NOTEBOOK (conf_note), GTK_POS_TOP);
  gtk_notebook_set_scrollable (GTK_NOTEBOOK (conf_note), TRUE);


  //  button=gtk_button_new_with_label(_("Save Mascot"));
  //gtk_table_attach(GTK_TABLE(conf_tbl), button, 0, 1, 1, 2,
  //		   GTK_FILL,GTK_SHRINK,0,0);
  //gtk_signal_connect(GTK_OBJECT(button),"pressed",
  //		     GTK_SIGNAL_FUNC(ConfSaveMascot), 
  //		     NULL);

  button=gtk_button_new_with_label(_("OK"));
  gtk_table_attach(GTK_TABLE(conf_tbl), button, 4, 5, 1, 2,
		   GTK_FILL,GTK_SHRINK,0,0);
  gtk_signal_connect(GTK_OBJECT(button),"pressed",
		     GTK_SIGNAL_FUNC(conf_change), 
		     GTK_WIDGET(conf_main));
  
  button=gtk_button_new_with_label(_("Cancel"));
  gtk_table_attach(GTK_TABLE(conf_tbl), button, 5, 6, 1, 2,
		   GTK_FILL,GTK_SHRINK,0,0);
  gtk_signal_connect(GTK_OBJECT(button),"pressed",
		     GTK_SIGNAL_FUNC(close_conf), 
		     GTK_WIDGET(conf_main));

  
  // Ρȥ֥å
  {
    gint i_resource=0;
    GtkWidget *frame;
    GtkWidget *table;
    GtkWidget *label;
    GtkWidget *combo;
    GtkWidget *clabel;
    GtkWidget *table1;
    GtkWidget *table2;
    GtkWidget *check;
    GtkWidget *vbox;
    GtkWidget *hbox;
    GtkAdjustment *adj;
    GtkWidget *scale;
    GtkWidget *spinner;
    GtkWidget *button;
    GtkWidget *scrwin;

    
    // ư
    i_resource++;
    {
      GtkWidget *table3;
      
      // 3x2Υơ֥
      table = gtk_table_new (3, 2, FALSE);

      frame = gtk_frame_new (_("Focus Follow"));
      gtk_table_attach(GTK_TABLE(table), frame, 0, 2, 0, 1,
		       GTK_FILL,GTK_SHRINK,0,0);
      gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
	
      table1 = gtk_table_new(2,3,FALSE);
      gtk_container_set_border_width (GTK_CONTAINER (table1), 5);
      gtk_container_add (GTK_CONTAINER (frame), table1);


      frame = gtk_frame_new (_("Offset on the Title Bar"));
      gtk_table_attach(GTK_TABLE(table1), frame, 0, 2, 0, 1,
		       GTK_FILL,GTK_SHRINK,0,0);
      gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
	
      table2 = gtk_table_new(2,3,FALSE);
      gtk_container_set_border_width (GTK_CONTAINER (table2), 5);
      gtk_container_add (GTK_CONTAINER (frame), table2);
      gtk_table_set_col_spacing (GTK_TABLE(table2), 0, 15);


      vbox = gtk_hbox_new(FALSE,10);
      gtk_container_set_border_width (GTK_CONTAINER (vbox), 0);
      gtk_table_attach_defaults (GTK_TABLE(table2), vbox, 0, 2, 0, 1);

      label = gtk_label_new (_("Starting Point"));
      gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
      gtk_box_pack_start(GTK_BOX(vbox), label,FALSE, FALSE, 5);

      combo = gtk_combo_new();
      gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(combo)->entry),FALSE);
      gtk_box_pack_start(GTK_BOX(vbox), combo,FALSE, FALSE, 0);

      clabel = gtk_list_item_new_with_label (_("Right"));
      gtk_container_add (GTK_CONTAINER (GTK_COMBO(combo)->list),
			 clabel);
      gtk_widget_show(clabel);
      clabel = gtk_list_item_new_with_label (_("Left"));
      gtk_container_add (GTK_CONTAINER (GTK_COMBO(combo)->list),
			 clabel);
      gtk_widget_show(clabel);
      if(Mascot->ff_side==FF_SIDE_RIGHT){
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),
			  _("Right"));
      }
      else if(Mascot->ff_side==FF_SIDE_LEFT){
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),
			  _("Left"));
      }
      gtk_signal_connect (GTK_OBJECT(GTK_COMBO(combo)->entry),
			  "changed",
			  GTK_SIGNAL_FUNC (cc_ff_side),
			  NULL);

      combo = gtk_combo_new();
      gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(combo)->entry),FALSE);
      gtk_table_attach (GTK_TABLE(table2), combo, 0, 1, 1, 2,
			GTK_FILL,GTK_SHRINK,0,15);

      clabel = gtk_list_item_new_with_label (_("Absolute"));
      gtk_container_add (GTK_CONTAINER (GTK_COMBO(combo)->list),
			 clabel);
      gtk_widget_show(clabel);
      clabel = gtk_list_item_new_with_label (_("Relative"));
      gtk_container_add (GTK_CONTAINER (GTK_COMBO(combo)->list),
			 clabel);
      gtk_widget_show(clabel);
      if(Mascot->flag_xp){
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),
			  _("Relative"));
      }
      gtk_signal_connect (GTK_OBJECT(GTK_COMBO(combo)->entry),
			  "changed",
			  GTK_SIGNAL_FUNC (cc_flag_xp),
			  NULL);
      
      table3 = gtk_table_new(2,2,FALSE);
      gtk_container_set_border_width (GTK_CONTAINER (table3), 5);
      gtk_table_attach (GTK_TABLE(table2), table3, 1, 2, 1, 3,
			GTK_FILL|GTK_EXPAND,GTK_SHRINK,0,0);
      
      label = gtk_label_new (_("Absolute[pix]"));
      gtk_misc_set_alignment (GTK_MISC (label), 0, 1.0);
      gtk_table_attach(GTK_TABLE(table3), label, 0, 1, 0, 1,
		       GTK_SHRINK,GTK_FILL,0,0);
      adj = (GtkAdjustment *)gtk_adjustment_new 
	((gfloat)Mascot->offset, 0, Mascot->width_root, 1.0, 10.0, 0.0);
      gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
			  GTK_SIGNAL_FUNC (cc_get_adj),
			  &tmp_mascot.offset);
      scale =  gtk_hscale_new (GTK_ADJUSTMENT(adj));
      gtk_scale_set_digits (GTK_SCALE (scale), 0);
      gtk_scale_set_draw_value (GTK_SCALE (scale), TRUE);
      gtk_table_attach (GTK_TABLE(table3), scale, 1, 2, 0, 1,
			GTK_FILL|GTK_EXPAND,GTK_SHRINK,0,0);

      label = gtk_label_new (_("Relative[%]"));
      gtk_misc_set_alignment (GTK_MISC (label), 0, 1.0);
      gtk_table_attach (GTK_TABLE(table3), label, 0, 1, 1, 2,
			GTK_FILL,GTK_FILL,0,0);
      adj = (GtkAdjustment *)gtk_adjustment_new 
	((gfloat)Mascot->offsetp, 0, 100, 1.0, 10.0, 0.0);
      gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
			  GTK_SIGNAL_FUNC (cc_get_adj),
			  &tmp_mascot.offsetp);
      scale =  gtk_hscale_new (GTK_ADJUSTMENT(adj));
      gtk_scale_set_digits (GTK_SCALE (scale), 0);
      gtk_scale_set_draw_value (GTK_SCALE (scale), TRUE);
      gtk_table_attach (GTK_TABLE(table3), scale, 1, 2, 1, 2,
			GTK_FILL|GTK_EXPAND,GTK_SHRINK,0,0);
      



      frame = gtk_frame_new (_("Title Bar Management"));
      gtk_table_attach(GTK_TABLE(table1), frame, 0, 1, 1, 2,
		       GTK_FILL,GTK_FILL,0,0);
      gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
	
      table2 = gtk_table_new(2,3,FALSE);
      gtk_container_set_border_width (GTK_CONTAINER (table2), 5);
      gtk_container_add (GTK_CONTAINER (frame), table2);
      gtk_table_set_row_spacings (GTK_TABLE(table2), 5);
      gtk_table_set_col_spacings (GTK_TABLE(table2), 8);


      check = gtk_check_button_new_with_label(_("Auto Scaling"));
      gtk_table_attach_defaults (GTK_TABLE(table2), check, 0, 1, 0, 1);
      if(Mascot->focus_autobar){
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),TRUE);
      }
      gtk_signal_connect (GTK_OBJECT (check), "toggled",
			  GTK_SIGNAL_FUNC (cc_get_toggle),
			  &tmp_mascot.focus_autobar);
      


      label = gtk_label_new (_("Bar Size (Manual)"));
      gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
      gtk_table_attach_defaults (GTK_TABLE(table2), label, 0, 1, 1, 2);
      adj = (GtkAdjustment *)gtk_adjustment_new ((gfloat)Mascot->bar_size, 0.0, 50.0, 1.0, 1.0, 1.0);
      gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
			  GTK_SIGNAL_FUNC (cc_get_adj),
			  &tmp_mascot.bar_size);
      spinner =  gtk_spin_button_new (adj, 0, 0);
      gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), FALSE);
      gtk_table_attach (GTK_TABLE(table2), spinner, 1, 2, 1, 2,
			GTK_SHRINK,GTK_SHRINK,0,0);

      label = gtk_label_new (_("Offset for Shaped Bar"));
      gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
      gtk_table_attach_defaults (GTK_TABLE(table2), label, 0, 1, 2, 3);
      adj = (GtkAdjustment *)gtk_adjustment_new ((gfloat)Mascot->bar_offset, -50, 50.0, 1.0, 1.0, 1.0);
      gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
			  GTK_SIGNAL_FUNC (cc_get_adj),
			  &tmp_mascot.bar_offset);
      spinner =  gtk_spin_button_new (adj, 0, 0);
      gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), FALSE);
      gtk_table_attach (GTK_TABLE(table2), spinner, 1, 2, 2, 3,
			GTK_SHRINK,GTK_SHRINK,0,0);


      frame = gtk_frame_new (_("Home Position"));
      gtk_table_attach(GTK_TABLE(table1), frame, 1, 2, 1, 2,
		       GTK_FILL,GTK_FILL,0,0);
      gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
	
      table2 = gtk_table_new(2,3,FALSE);
      gtk_container_set_border_width (GTK_CONTAINER (table2), 5);
      gtk_container_add (GTK_CONTAINER (frame), table2);
      gtk_table_set_row_spacings (GTK_TABLE(table2), 5);
      gtk_table_set_col_spacings (GTK_TABLE(table2), 5);

      combo = gtk_combo_new();
      gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(combo)->entry),FALSE);
      gtk_table_attach_defaults (GTK_TABLE(table2), combo, 0, 2, 0, 1);

      clabel = gtk_list_item_new_with_label (_("Never Use"));
      gtk_container_add (GTK_CONTAINER (GTK_COMBO(combo)->list),
			 clabel);
      gtk_widget_show(clabel);
      clabel = gtk_list_item_new_with_label (_("No Focus Only"));
      gtk_container_add (GTK_CONTAINER (GTK_COMBO(combo)->list),
			 clabel);
      gtk_widget_show(clabel);
      clabel = gtk_list_item_new_with_label (_("Support Sticking Out"));
      gtk_container_add (GTK_CONTAINER (GTK_COMBO(combo)->list),
			 clabel);
      gtk_widget_show(clabel);
      if(Mascot->homepos==HOMEPOS_NEVER){
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),
			  _("Never Use"));
      }
      else if(Mascot->homepos==HOMEPOS_FOCUS){
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),
			  _("No Focus Only"));
      }
      else if(Mascot->homepos==HOMEPOS_OUT){
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),
			  _("Support Sticking Out"));
      }
      gtk_signal_connect (GTK_OBJECT(GTK_COMBO(combo)->entry),
			  "changed",
			  GTK_SIGNAL_FUNC (cc_homepos),
			  NULL);



      label = gtk_label_new (_("Home X"));
      gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
      gtk_table_attach_defaults (GTK_TABLE(table2), label, 0, 1, 1, 2);
      adj = (GtkAdjustment *)gtk_adjustment_new 
	((gfloat)Mascot->home_x, 0,Mascot->width_root, 1.0, 1.0, 1.0);
      gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
			  GTK_SIGNAL_FUNC (cc_get_adj),
			  &tmp_mascot.home_x);
      spinner =  gtk_spin_button_new (adj, 0, 0);
      gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), FALSE);
      gtk_table_attach (GTK_TABLE(table2), spinner, 1, 2, 1, 2,
			GTK_SHRINK,GTK_SHRINK,0,0);


      label = gtk_label_new (_("Home Y"));
      gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
      gtk_table_attach_defaults (GTK_TABLE(table2), label, 0, 1, 2, 3);
      adj = (GtkAdjustment *)gtk_adjustment_new 
	((gfloat)Mascot->home_y, 0, Mascot->height_root, 1.0, 1.0, 1.0);
      gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
			  GTK_SIGNAL_FUNC (cc_get_adj),
			  &tmp_mascot.home_y);
      spinner =  gtk_spin_button_new (adj, 0, 0);
      gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), FALSE);
      gtk_table_attach (GTK_TABLE(table2), spinner, 1, 2, 2, 3,
			GTK_SHRINK,GTK_SHRINK,0,0);

      table2=gtk_table_new(1,1,FALSE);
      gtk_table_attach_defaults(GTK_TABLE(table1), table2, 0, 2, 2, 3);

      table1=gtk_table_new(1,1,FALSE);
      gtk_table_attach_defaults(GTK_TABLE(table), table1, 0, 2, 1, 2);

      label = gtk_label_new (_("Move"));
      gtk_notebook_append_page (GTK_NOTEBOOK (conf_note), table, label);
    }

    // 
    i_resource++;
    {
      GtkWidget *entry;

      // 1x3Υơ֥
      table = gtk_table_new (1, 2, FALSE);

      frame = gtk_frame_new (_("Time Signal"));
      gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
      gtk_table_attach(GTK_TABLE(table), frame, 0, 1, 0, 1,
		       GTK_FILL,GTK_FILL,0,0);
      gtk_table_set_row_spacings (GTK_TABLE(table1), 5);
      gtk_table_set_col_spacings (GTK_TABLE(table1), 5);
	
      table1 = gtk_table_new (3, 2, FALSE);
      gtk_container_set_border_width (GTK_CONTAINER (table1), 5);
      gtk_container_add (GTK_CONTAINER (frame), table1);

      check = gtk_check_button_new_with_label(_("Use Signal"));
      gtk_table_attach(GTK_TABLE(table1), check, 0, 2, 0, 1,
		       GTK_FILL|GTK_EXPAND, GTK_SHRINK, 0, 0);
      if(Mascot->signal.flag){
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),TRUE);
      }
      gtk_signal_connect (GTK_OBJECT (check), "toggled",
			  GTK_SIGNAL_FUNC (cc_get_toggle),
			  &tmp_mascot.signal.flag);


      hbox = gtk_hbox_new(FALSE,5);
      gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
      gtk_table_attach(GTK_TABLE(table1), hbox, 2, 3, 0, 1,
		       GTK_SHRINK, GTK_SHRINK, 0, 0);

      label = gtk_label_new (_("Mascot Action"));
      gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
      gtk_box_pack_start(GTK_BOX(hbox), label,FALSE, FALSE, 0);

      combo = gtk_combo_new();
      gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(combo)->entry),FALSE);
      gtk_box_pack_start(GTK_BOX(hbox), combo,FALSE, FALSE, 0);

      clabel = gtk_list_item_new_with_label (_("None"));
      gtk_container_add (GTK_CONTAINER (GTK_COMBO(combo)->list),
			 clabel);
      gtk_widget_show(clabel);
      clabel = gtk_list_item_new_with_label (_("Click Action"));
      gtk_container_add (GTK_CONTAINER (GTK_COMBO(combo)->list),
			 clabel);
      gtk_widget_show(clabel);
      clabel = gtk_list_item_new_with_label (_("Mascot Random Change"));
      gtk_container_add (GTK_CONTAINER (GTK_COMBO(combo)->list),
			 clabel);
      gtk_widget_show(clabel);
      if(Mascot->signal.type==SIGACT_CLICK){
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),
			  _("Click Action"));
      }
      else if(Mascot->signal.type==SIGACT_CHANGE){
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),
			  _("Mascot Random Change"));
      }
      gtk_signal_connect (GTK_OBJECT(GTK_COMBO(combo)->entry),
			  "changed",
			  GTK_SIGNAL_FUNC (cc_signal_type),
			  NULL);


      label = gtk_label_new (_("External Command"));
      gtk_misc_set_alignment (GTK_MISC (label), 0, 0);
      gtk_table_attach(GTK_TABLE(table1), label, 0, 1, 1, 2, 
		       GTK_SHRINK, GTK_SHRINK, 0, 0);

      entry = gtk_entry_new ();
      gtk_signal_connect (GTK_OBJECT(entry),
			  "changed",
			  GTK_SIGNAL_FUNC (cc_get_entry),
			  &tmp_mascot.signal.com);
      gtk_table_attach (GTK_TABLE(table1), entry,
			1, 3, 1, 2,
			GTK_EXPAND | GTK_FILL,
			GTK_EXPAND | GTK_FILL,0,0);
      if(Mascot->signal.com){
	gtk_entry_set_text(GTK_ENTRY(entry), Mascot->signal.com);
      }
      gtk_entry_set_editable(GTK_ENTRY(entry),TRUE);


      table1=gtk_table_new(1,1,FALSE);
      gtk_table_attach_defaults(GTK_TABLE(table), table1, 0, 1, 1, 2);

      label = gtk_label_new (_("Time Signal"));
      gtk_notebook_append_page (GTK_NOTEBOOK (conf_note), table, label);
    }

    // Biff
    i_resource++;
    {
      GtkWidget *entry;
      GtkWidget *table2;

	// 1x3Υơ֥
	table = gtk_table_new (1, 5, FALSE);
	
	frame = gtk_frame_new (_("Server Information"));
	gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
	gtk_table_attach(GTK_TABLE(table), frame, 0, 1, 0, 1,
			 GTK_FILL|GTK_EXPAND,GTK_SHRINK,0,0);
	
	

	table1 = gtk_table_new (5, 5, FALSE);
	gtk_container_set_border_width (GTK_CONTAINER (table1), 5);
	gtk_container_add (GTK_CONTAINER (frame), table1);
	gtk_table_set_row_spacings (GTK_TABLE(table1), 5);
	gtk_table_set_row_spacing (GTK_TABLE(table1), 3, 0);
	gtk_table_set_col_spacings (GTK_TABLE(table1), 8);
	
	
	label = gtk_label_new (_("Protocol"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
	gtk_table_attach_defaults(GTK_TABLE(table1), label, 0, 1, 0, 1);
	
	combo = gtk_combo_new();
	gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(combo)->entry),FALSE);
	gtk_table_attach(GTK_TABLE(table1), combo, 1, 2, 0, 1,
			 GTK_SHRINK,GTK_SHRINK,0,0);
	
	clabel = gtk_list_item_new_with_label (_("None"));
	gtk_container_add (GTK_CONTAINER (GTK_COMBO(combo)->list),
			   clabel);
	gtk_widget_show(clabel);
	clabel = gtk_list_item_new_with_label (_("Local"));
	gtk_container_add (GTK_CONTAINER (GTK_COMBO(combo)->list),
			 clabel);
	gtk_widget_show(clabel);
	clabel = gtk_list_item_new_with_label (_("POP3 (normal)"));
	gtk_container_add (GTK_CONTAINER (GTK_COMBO(combo)->list),
			   clabel);
	gtk_widget_show(clabel);
	clabel = gtk_list_item_new_with_label (_("POP3 (APOP auth)"));
	gtk_container_add (GTK_CONTAINER (GTK_COMBO(combo)->list),
			   clabel);
	gtk_widget_show(clabel);
	clabel = gtk_list_item_new_with_label (_("qmail (Maildir)"));
	gtk_container_add (GTK_CONTAINER (GTK_COMBO(combo)->list),
			   clabel);
	gtk_widget_show(clabel);
	clabel = gtk_list_item_new_with_label (_("MH + Procmail"));
	gtk_container_add (GTK_CONTAINER (GTK_COMBO(combo)->list),
			   clabel);
	gtk_widget_show(clabel);
	switch(Mascot->mail.type){
	case MAIL_NO:
	  gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),
			     _("None"));
	  break;
	case MAIL_LOCAL:
	  gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),
			     _("Local"));
	  break;
	case MAIL_POP3:
	  gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),
			     _("POP3 (normal)"));
	  break;
	case MAIL_APOP:
	  gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),
			     _("POP3 (APOP auth)"));
	  break;
	case MAIL_QMAIL:
	  gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),
			     _("qmail (Maildir)"));
	  break;
	case MAIL_PROCMAIL:
	  gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),
			     _("MH + Procmail"));
	  break;
	}
	gtk_signal_connect (GTK_OBJECT(GTK_COMBO(combo)->entry),
			    "changed",
			    GTK_SIGNAL_FUNC (cc_mail_type),
			    NULL);


	hbox = gtk_hbox_new(FALSE,5);
	gtk_table_attach_defaults(GTK_TABLE(table1), hbox, 3, 4, 0, 1);

	label = gtk_label_new (_("POP3 Port No."));
	gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
	gtk_box_pack_start(GTK_BOX(hbox), label,FALSE, FALSE, 5);
	
	adj = (GtkAdjustment *)gtk_adjustment_new 
	  ((gfloat)Mascot->mail.pop_port, 1, 999, 1.0, 1.0, 1.0);
	gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
			    GTK_SIGNAL_FUNC (cc_get_adj),
			    &tmp_mascot.mail.pop_port);
	spinner =  gtk_spin_button_new (adj, 0, 0);
	gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), FALSE);
	gtk_box_pack_start(GTK_BOX(hbox), spinner,FALSE, FALSE, 0);
	gtk_entry_set_editable(GTK_ENTRY(&GTK_SPIN_BUTTON(spinner)->entry),
			       FALSE);
	

	label = gtk_label_new (_("Address"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
	gtk_table_attach(GTK_TABLE(table1), label, 0, 1, 1, 2,0,0,0,0);
	
	entry = gtk_entry_new ();
	gtk_signal_connect (GTK_OBJECT(entry),
			    "changed",
			    GTK_SIGNAL_FUNC (cc_get_entry),
			    &tmp_mascot.mail.pop_server);
	gtk_table_attach (GTK_TABLE(table1), entry,
			  1, 5, 1, 2,
			  GTK_EXPAND | GTK_FILL,
			  GTK_EXPAND | GTK_FILL,0,0);
	if(Mascot->mail.pop_server){
	  gtk_entry_set_text(GTK_ENTRY(entry), Mascot->mail.pop_server);
	}
	gtk_entry_set_editable(GTK_ENTRY(entry),TRUE);
	

	label = gtk_label_new (_("User ID"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
	gtk_table_attach(GTK_TABLE(table1), label, 0, 1, 2, 3,0,0,0,0);
	
	entry = gtk_entry_new ();
	gtk_signal_connect (GTK_OBJECT(entry),
			    "changed",
			    GTK_SIGNAL_FUNC (cc_get_entry),
			    &tmp_mascot.mail.pop_id);
	gtk_table_attach (GTK_TABLE(table1), entry,
			  1, 2, 2, 3,
			  GTK_EXPAND | GTK_SHRINK | GTK_FILL,
			  GTK_EXPAND | GTK_SHRINK | GTK_FILL,0,0);
	if(Mascot->mail.pop_id){
	  gtk_entry_set_text(GTK_ENTRY(entry), Mascot->mail.pop_id);
	}
	gtk_entry_set_editable(GTK_ENTRY(entry),TRUE);



	label = gtk_label_new (_("Password"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
	gtk_table_attach(GTK_TABLE(table1), label, 2, 3, 2, 3,0,0,0,0);
	
	entry = gtk_entry_new ();
	gtk_signal_connect (GTK_OBJECT(entry),
			    "changed",
			    GTK_SIGNAL_FUNC (cc_get_entry),
			    &tmp_mascot.mail.pop_pass);
	gtk_table_attach (GTK_TABLE(table1), entry,
			  3, 5, 2, 3,
			  GTK_EXPAND | GTK_SHRINK | GTK_FILL,
			  GTK_EXPAND | GTK_SHRINK | GTK_FILL,0,0);
	gtk_entry_set_visibility(GTK_ENTRY(entry), FALSE);
	if(Mascot->mail.pop_pass){
	  gtk_entry_set_text(GTK_ENTRY(entry), Mascot->mail.pop_pass);
	}
	gtk_entry_set_editable(GTK_ENTRY(entry),TRUE);
	
	
	label = gtk_label_new (_("File"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
	gtk_table_attach(GTK_TABLE(table1), label, 0, 1, 3, 4,0,0,0,0);
	
	table2 = gtk_table_new (2, 1, FALSE);
	gtk_table_attach (GTK_TABLE(table1), table2,
			1, 5, 3, 4,
			GTK_FILL,
			GTK_FILL,0,0);

	entry = gtk_entry_new ();
	gtk_table_attach_defaults (GTK_TABLE(table2), entry,
				   0, 1, 0, 1);
	if(Mascot->mail.file){
	  gtk_entry_set_text(GTK_ENTRY(entry), Mascot->mail.file);
	}
	gtk_entry_set_editable(GTK_ENTRY(entry),TRUE);
	gtk_signal_connect (GTK_OBJECT(entry),
			    "changed",
			    GTK_SIGNAL_FUNC (cc_get_entry),
			    &tmp_mascot.mail.file);

	button = gtk_button_new_with_label("...");
	gtk_table_attach (GTK_TABLE(table2), button, 1, 2, 0, 1, 
			  GTK_SHRINK,GTK_SHRINK,0,0);
	gtk_signal_connect (GTK_OBJECT(button),
			    "pressed",
			    GTK_SIGNAL_FUNC (create_mail_file_dialog),
			    (gpointer)entry);
	


	frame = gtk_frame_new (_("Operating Information"));
	gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
	gtk_table_attach(GTK_TABLE(table), frame, 0, 1, 1, 2,
			 GTK_FILL|GTK_EXPAND,GTK_SHRINK,0,0);
	


	table1 = gtk_table_new (1, 2, FALSE);
	gtk_container_set_border_width (GTK_CONTAINER (table1), 5);
	gtk_container_add (GTK_CONTAINER (frame), table1);
	gtk_table_set_row_spacings (GTK_TABLE(table1), 5);
	gtk_table_set_col_spacings (GTK_TABLE(table1), 5);
	
	hbox = gtk_hbox_new(FALSE,5);
	gtk_table_attach_defaults(GTK_TABLE(table1), hbox, 0, 1, 0, 1);
	
	label = gtk_label_new (_("Interval[sec]"));
	gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
	gtk_box_pack_start(GTK_BOX(hbox), label,FALSE, FALSE, 0);
	
	adj = (GtkAdjustment *)gtk_adjustment_new 
	  ((gfloat)Mascot->mail.interval, 10, 3600, 10.0, 10.0, 10.0);
	gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
			    GTK_SIGNAL_FUNC (cc_get_adj),
			    &tmp_mascot.mail.interval);
	spinner =  gtk_spin_button_new (adj, 0, 0);
	gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), FALSE);
	gtk_box_pack_start(GTK_BOX(hbox), spinner,FALSE, FALSE, 0);
	gtk_entry_set_editable(GTK_ENTRY(&GTK_SPIN_BUTTON(spinner)->entry),
			       FALSE);
	

	label = gtk_label_new (_("  Polling"));
	gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
	gtk_box_pack_start(GTK_BOX(hbox), label,FALSE, FALSE, 0);
	
	entry = gtk_entry_new ();
	gtk_signal_connect (GTK_OBJECT(entry),
			    "changed",
			    GTK_SIGNAL_FUNC (cc_get_entry),
			    &tmp_mascot.mail.polling);
	gtk_box_pack_start(GTK_BOX(hbox), entry,TRUE, TRUE, 0);
	if(Mascot->mail.polling){
	  gtk_entry_set_text(GTK_ENTRY(entry), Mascot->mail.polling);
	}
	gtk_entry_set_editable(GTK_ENTRY(entry),TRUE);
	


	hbox = gtk_hbox_new(FALSE,5);
	gtk_table_attach_defaults(GTK_TABLE(table1), hbox, 0, 1, 1, 2);
	
	label = gtk_label_new (_("Mailer"));
	gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
	gtk_box_pack_start(GTK_BOX(hbox), label,FALSE, FALSE, 0);
	
	entry = gtk_entry_new ();
	gtk_signal_connect (GTK_OBJECT(entry),
			    "changed",
			    GTK_SIGNAL_FUNC (cc_get_entry),
			    &tmp_mascot.mail.mailer);
	gtk_box_pack_start(GTK_BOX(hbox), entry,TRUE, TRUE, 0);
	if(Mascot->mail.mailer){
	  gtk_entry_set_text(GTK_ENTRY(entry), Mascot->mail.mailer);
	}
	gtk_entry_set_editable(GTK_ENTRY(entry),TRUE);


	label = gtk_label_new (_("  Filter"));
	gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
	gtk_box_pack_start(GTK_BOX(hbox), label,FALSE, FALSE, 0);
	
	entry = gtk_entry_new ();
	gtk_signal_connect (GTK_OBJECT(entry),
			    "changed",
			    GTK_SIGNAL_FUNC (cc_get_entry),
			    &tmp_mascot.mail.filter);
	gtk_box_pack_start(GTK_BOX(hbox), entry,FALSE, FALSE, 0);
	if(Mascot->mail.filter){
	  gtk_entry_set_text(GTK_ENTRY(entry), Mascot->mail.filter);
	}
	gtk_entry_set_editable(GTK_ENTRY(entry),TRUE);
	


	frame = gtk_frame_new (_("SPAM exception"));
	gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
	gtk_table_attach(GTK_TABLE(table), frame, 0, 1, 2, 3,
			 GTK_FILL|GTK_EXPAND,GTK_SHRINK,0,0);

	table1 = gtk_table_new (3, 1, FALSE);
	gtk_container_set_border_width (GTK_CONTAINER (table1), 5);
	gtk_container_add (GTK_CONTAINER (frame), table1);
	
	check = gtk_check_button_new_with_label(_("Use exception"));
	gtk_table_attach(GTK_TABLE(table1), check, 0, 2, 0, 1,
			 GTK_EXPAND | GTK_FILL,
			 GTK_EXPAND | GTK_FILL,0,0);
	if(Mascot->mail.spam_check){
	  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),TRUE);
	}
	gtk_signal_connect (GTK_OBJECT (check), "toggled",
			    GTK_SIGNAL_FUNC (cc_get_toggle),
			    &tmp_mascot.mail.spam_check);
	
	
	label = gtk_label_new (_("Mark in Header"));
	gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(table1), label, 1, 2, 0, 1, 
			  GTK_EXPAND | GTK_FILL,
			  GTK_EXPAND | GTK_FILL,0,0);

	entry = gtk_entry_new ();
	gtk_signal_connect (GTK_OBJECT(entry),
			    "changed",
			    GTK_SIGNAL_FUNC (cc_get_entry),
			    &tmp_mascot.mail.spam_mark);
	gtk_table_attach (GTK_TABLE(table1), entry,
			  2, 3, 0, 1,
			  GTK_EXPAND | GTK_FILL,
			  GTK_EXPAND | GTK_FILL,0,0);
	if(Mascot->mail.spam_mark){
	  gtk_entry_set_text(GTK_ENTRY(entry), Mascot->mail.spam_mark);
	}
	gtk_entry_set_editable(GTK_ENTRY(entry),TRUE);


	frame = gtk_frame_new (_("Mail List Window"));
	gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
	gtk_table_attach(GTK_TABLE(table), frame, 0, 1, 3, 4,
			 GTK_FILL|GTK_EXPAND,GTK_SHRINK,0,0);


	table1 = gtk_table_new (4, 1, FALSE);
	gtk_container_set_border_width (GTK_CONTAINER (table1), 5);
	gtk_container_add (GTK_CONTAINER (frame), table1);
	gtk_table_set_row_spacings (GTK_TABLE(table1), 5);
	gtk_table_set_col_spacings (GTK_TABLE(table1), 5);
	gtk_table_set_row_spacing (GTK_TABLE(table1), 2, 0);
	
	
	label = gtk_label_new (_("Width"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
	gtk_table_attach(GTK_TABLE(table1), label, 0, 1, 0, 1,0,0,0,0);
	adj = (GtkAdjustment *)gtk_adjustment_new 
	  ((gfloat)Mascot->mail.win_width, 100, Mascot->width_root, 10.0, 10.0, 10.0);
	gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
			    GTK_SIGNAL_FUNC (cc_get_adj),
			    &tmp_mascot.mail.win_width);
	scale =  gtk_hscale_new (GTK_ADJUSTMENT(adj));
	gtk_scale_set_digits (GTK_SCALE (scale), 0);
	gtk_scale_set_draw_value (GTK_SCALE (scale), TRUE);
	gtk_table_attach (GTK_TABLE(table1), scale, 1, 2, 0, 1,
			  GTK_FILL|GTK_EXPAND,GTK_SHRINK,0,0);

	label = gtk_label_new (_("Height"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
	gtk_table_attach(GTK_TABLE(table1), label, 2, 3, 0, 1,0,0,0,0);
	adj = (GtkAdjustment *)gtk_adjustment_new 
	  ((gfloat)Mascot->mail.win_height, 100, Mascot->height_root, 10.0, 10.0, 10.0);
	gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
			    GTK_SIGNAL_FUNC (cc_get_adj),
			    &tmp_mascot.mail.win_height);
	scale =  gtk_hscale_new (GTK_ADJUSTMENT(adj));
	gtk_scale_set_digits (GTK_SCALE (scale), 0);
	gtk_scale_set_draw_value (GTK_SCALE (scale), TRUE);
	gtk_table_attach (GTK_TABLE(table1), scale, 3, 4, 0, 1,
			  GTK_FILL|GTK_EXPAND,GTK_SHRINK,0,0);


	table1=gtk_table_new(1,1,FALSE);
	gtk_table_attach_defaults(GTK_TABLE(table), table1, 0, 1, 4, 5);

      label = gtk_label_new (_("Biff"));
      gtk_notebook_append_page (GTK_NOTEBOOK (conf_note), table, label);
    }

    // ¾
    i_resource++;
    {
      GtkWidget *entry;
      
      // 1x5Υơ֥
      table = gtk_table_new (2, 6, FALSE);
      
      frame = gtk_frame_new (_("Mascot Magnification"));
      gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
      gtk_table_attach(GTK_TABLE(table), frame, 0, 1, 0, 1,
		       GTK_FILL,GTK_SHRINK,0,0);
	

      table1 = gtk_table_new (2, 2, FALSE);
      gtk_container_set_border_width (GTK_CONTAINER (table1), 5);
      gtk_container_add (GTK_CONTAINER (frame), table1);
      gtk_table_set_row_spacings (GTK_TABLE(table1), 5);
      gtk_table_set_col_spacings (GTK_TABLE(table1), 5);

      label = gtk_label_new (_("Magnification[%]"));
      gtk_misc_set_alignment (GTK_MISC (label), 0, 1.0);
      gtk_table_attach(GTK_TABLE(table1), label, 0, 1, 0, 1,
		       GTK_FILL,GTK_FILL,0,0);

      adj = (GtkAdjustment *)gtk_adjustment_new 
	((gfloat)Mascot->magnify, 10, 400, 1.0, 10.0, 0.0);
      gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
			  GTK_SIGNAL_FUNC (cc_get_adj),
			  &tmp_mascot.magnify);
      scale =  gtk_hscale_new (GTK_ADJUSTMENT(adj));
      gtk_scale_set_digits (GTK_SCALE (scale), 0);
      gtk_scale_set_draw_value (GTK_SCALE (scale), TRUE);
      gtk_table_attach_defaults(GTK_TABLE(table1), scale, 1, 2, 0, 1);

      label = gtk_label_new (_("Interpolation Style"));
      gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
      gtk_table_attach(GTK_TABLE(table1), label, 0, 1, 1, 2,
		       GTK_SHRINK,GTK_SHRINK,0,0);

      combo = gtk_combo_new();
      gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(combo)->entry),FALSE);
      gtk_table_attach_defaults(GTK_TABLE(table1), combo, 1, 2, 1, 2);

      clabel = gtk_list_item_new_with_label (_("Nearest-Neighbor"));
      gtk_container_add (GTK_CONTAINER (GTK_COMBO(combo)->list),
			 clabel);
      gtk_widget_show(clabel);
      clabel = gtk_list_item_new_with_label (_("Tiles"));
      gtk_container_add (GTK_CONTAINER (GTK_COMBO(combo)->list),
			 clabel);
      gtk_widget_show(clabel);
      clabel = gtk_list_item_new_with_label (_("Bilinear"));
      gtk_container_add (GTK_CONTAINER (GTK_COMBO(combo)->list),
			 clabel);
      gtk_widget_show(clabel);
      clabel = gtk_list_item_new_with_label (_("Hyper"));
      gtk_container_add (GTK_CONTAINER (GTK_COMBO(combo)->list),
			 clabel);
      gtk_widget_show(clabel);
      switch(Mascot->ip_style){
      case MAG_IP_NEAREST:
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),
			  _("Nearest-Neighbor"));
	break;
      case MAG_IP_TILES:
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),
			  _("Tiles"));
	break;
      case MAG_IP_BILINEAR:
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),
			  _("Bilinear"));
	break;
      case MAG_IP_HYPER:
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),
			  _("Hyper"));
	break;
      }
      gtk_signal_connect (GTK_OBJECT(GTK_COMBO(combo)->entry),
			  "changed",
			  GTK_SIGNAL_FUNC (cc_ip_style),
			  NULL);


      frame = gtk_frame_new (_("Duet Animation"));
      gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
      gtk_table_attach(GTK_TABLE(table), frame, 1, 2, 0, 1,
		       GTK_FILL,GTK_FILL,0,0);

      table1 = gtk_table_new (1, 2, FALSE);
      gtk_container_set_border_width (GTK_CONTAINER (table1), 5);
      gtk_container_add (GTK_CONTAINER (frame), table1);
      gtk_table_set_row_spacings (GTK_TABLE(table1), 5);
      gtk_table_set_col_spacings (GTK_TABLE(table1), 5);

      check = gtk_check_button_new_with_label(_("Click"));
      gtk_table_attach(GTK_TABLE(table1), check, 0, 1, 0, 1,
		       GTK_FILL,GTK_SHRINK,0,0);
      if(Mascot->duet_use_click){
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),TRUE);
      }
      gtk_signal_connect (GTK_OBJECT (check), "toggled",
			  GTK_SIGNAL_FUNC (cc_get_toggle),
			  &tmp_mascot.duet_use_click);

      check = gtk_check_button_new_with_label(_("Random"));
      gtk_table_attach(GTK_TABLE(table1), check, 0, 1, 1, 2,
		       GTK_FILL,GTK_SHRINK,0,0);
      if(Mascot->duet_use_random){
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),TRUE);
      }
      gtk_signal_connect (GTK_OBJECT (check), "toggled",
			  GTK_SIGNAL_FUNC (cc_get_toggle),
			  &tmp_mascot.duet_use_random);


      
      frame = gtk_frame_new (_("Auto Install"));
      gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
      gtk_table_attach(GTK_TABLE(table), frame, 0, 2, 1, 2,
		       GTK_FILL,GTK_SHRINK,0,0);

      table1 = gtk_table_new (2, 2, FALSE);
      gtk_container_set_border_width (GTK_CONTAINER (table1), 5);
      gtk_container_add (GTK_CONTAINER (frame), table1);
      gtk_table_set_row_spacings (GTK_TABLE(table1), 5);
      gtk_table_set_col_spacings (GTK_TABLE(table1), 5);

      check = gtk_check_button_new_with_label(_("Auto Mascot Install to User Dir."));
      gtk_table_attach(GTK_TABLE(table1), check, 0, 2, 0, 1,
		       GTK_FILL,GTK_SHRINK,0,0);
      if(Mascot->flag_install){
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),TRUE);
      }
      gtk_signal_connect (GTK_OBJECT (check), "toggled",
			  GTK_SIGNAL_FUNC (cc_get_toggle),
			  &tmp_mascot.flag_install);

      label = gtk_label_new(_("User & Common Dir Consistency Check"));
      gtk_table_attach(GTK_TABLE(table1), label, 0, 1, 1, 2,
		       GTK_SHRINK,GTK_SHRINK,0,0);

      combo = gtk_combo_new();
      gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(combo)->entry),FALSE);
      gtk_table_attach_defaults(GTK_TABLE(table1), combo, 1, 2, 1, 2);
      clabel = gtk_list_item_new_with_label (_("Manual"));
      gtk_container_add (GTK_CONTAINER (GTK_COMBO(combo)->list),
			 clabel);
      gtk_widget_show(clabel);
      clabel = gtk_list_item_new_with_label (_("Auto Overwrite"));
      gtk_container_add (GTK_CONTAINER (GTK_COMBO(combo)->list),
			 clabel);
      gtk_widget_show(clabel);
      clabel = gtk_list_item_new_with_label (_("Ignore"));
      gtk_container_add (GTK_CONTAINER (GTK_COMBO(combo)->list),
			 clabel);
      gtk_widget_show(clabel);
      switch(Mascot->cons_check_mode){
      case CONS_MANUAL:
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),
			  _("Manual"));
	break;
      case CONS_AUTOOW:
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),
			  _("Auto Overwrite"));
	break;
      case CONS_IGNORE:
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),
			  _("Ignore"));
	break;
      }
      gtk_signal_connect (GTK_OBJECT(GTK_COMBO(combo)->entry),
			  "changed",
			  GTK_SIGNAL_FUNC (cc_cons_check_mode),
			  NULL);



      frame = gtk_frame_new (_("Default Fontset"));
      gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
      gtk_table_attach(GTK_TABLE(table), frame, 0, 2, 2, 3,
		       GTK_FILL,GTK_SHRINK,0,0);

      table1=gtk_table_new(3,2,FALSE);
      gtk_container_set_border_width (GTK_CONTAINER (table1), 5);
      gtk_container_add (GTK_CONTAINER (frame), table1);
      gtk_table_set_row_spacings (GTK_TABLE(table1), 5);

      label = gtk_label_new (_("Clock"));
      gtk_table_attach(GTK_TABLE(table1), label, 0, 1, 0, 1,
		       GTK_FILL,GTK_SHRINK,0,0);

      entry_deffontname_clk = gtk_entry_new ();
      gtk_table_attach_defaults (GTK_TABLE(table1), entry_deffontname_clk,
				 1, 2, 0, 1);
      gtk_entry_set_text(GTK_ENTRY(entry_deffontname_clk),
			 Mascot->deffontname_clk);
      gtk_entry_set_editable(GTK_ENTRY(entry_deffontname_clk),FALSE);

      button = gtk_button_new_with_label("...");
      gtk_table_attach (GTK_TABLE(table1), button, 2, 3, 0, 1, 
			GTK_SHRINK,GTK_SHRINK,0,0);
      gtk_signal_connect(GTK_OBJECT(button),"pressed",
			 GTK_SIGNAL_FUNC(create_font_selection_dialog), 
			 (gpointer *)CONF_DEF_FONT_CLK);

      label = gtk_label_new (_("Balloon"));
      gtk_table_attach(GTK_TABLE(table1), label, 0, 1, 1, 2,
		       GTK_FILL,GTK_SHRINK,0,0);

      entry_deffontname_bal = gtk_entry_new ();
      gtk_table_attach_defaults (GTK_TABLE(table1), entry_deffontname_bal,
				 1, 2, 1, 2);
      gtk_entry_set_text(GTK_ENTRY(entry_deffontname_bal),
			 Mascot->deffontname_bal);
      gtk_entry_set_editable(GTK_ENTRY(entry_deffontname_bal),FALSE);

      button = gtk_button_new_with_label("...");
      gtk_table_attach (GTK_TABLE(table1), button, 2, 3, 1, 2, 
			GTK_SHRINK,GTK_SHRINK,0,0);
      gtk_signal_connect(GTK_OBJECT(button),"pressed",
			 GTK_SIGNAL_FUNC(create_font_selection_dialog), 
			 (gpointer *)CONF_DEF_FONT_BAL);


      frame = gtk_frame_new (_("Sound Command"));
      gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
      gtk_table_attach(GTK_TABLE(table), frame, 0, 2, 3, 4,
		       GTK_FILL,GTK_SHRINK,0,0);
      
      table1 = gtk_table_new(2,1,FALSE);
      gtk_container_set_border_width (GTK_CONTAINER (table1), 5);
      gtk_container_add (GTK_CONTAINER (frame), table1);

      entry = gtk_entry_new ();
      if(tmp_mascot.sound_command){
	gtk_entry_set_text(GTK_ENTRY(entry),tmp_mascot.sound_command);
      }
      gtk_entry_set_editable(GTK_ENTRY(entry),TRUE);
      gtk_table_attach_defaults(GTK_TABLE(table1), entry, 0, 2, 0, 1);
      gtk_signal_connect (GTK_OBJECT(entry),
			  "changed",
			  GTK_SIGNAL_FUNC (cc_get_entry),
			  &tmp_mascot.sound_command);


      frame = gtk_frame_new (_("Nokkari-Chara Code Conversion (Redirect)"));
      gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
      gtk_table_attach(GTK_TABLE(table), frame, 0, 2, 4, 5,
		       GTK_FILL,GTK_SHRINK,0,0);
      
      table1 = gtk_table_new(4,1,FALSE);
      gtk_container_set_border_width (GTK_CONTAINER (table1), 5);
      gtk_container_add (GTK_CONTAINER (frame), table1);

      label = gtk_label_new (_("   To Nokkari-Chara "));
      gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
      gtk_table_attach(GTK_TABLE(table1), label, 0, 1, 0, 1,
		       GTK_FILL,GTK_SHRINK,0,0);

      entry = gtk_entry_new ();
      if(tmp_mascot.sjis_filter){
	gtk_entry_set_text(GTK_ENTRY(entry),tmp_mascot.sjis_filter);
      }
      gtk_entry_set_editable(GTK_ENTRY(entry),TRUE);
      gtk_table_attach_defaults(GTK_TABLE(table1), entry, 1, 2, 0, 1);
      gtk_signal_connect (GTK_OBJECT(entry),
			  "changed",
			  GTK_SIGNAL_FUNC (cc_get_entry),
			  &tmp_mascot.sjis_filter);

      label = gtk_label_new (_("   To MaCoPiX "));
      gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
      gtk_table_attach(GTK_TABLE(table1), label, 2, 3, 0, 1,
		       GTK_FILL,GTK_SHRINK,0,0);

      entry = gtk_entry_new ();
      if(tmp_mascot.euc_filter){
	gtk_entry_set_text(GTK_ENTRY(entry),tmp_mascot.euc_filter);
      }
      gtk_entry_set_editable(GTK_ENTRY(entry),TRUE);
      gtk_table_attach_defaults(GTK_TABLE(table1), entry, 3, 4, 0, 1);
      gtk_signal_connect (GTK_OBJECT(entry),
			  "changed",
			  GTK_SIGNAL_FUNC (cc_get_entry),
			  &tmp_mascot.euc_filter);



      table1=gtk_table_new(1,1,FALSE);
      gtk_table_attach_defaults(GTK_TABLE(table), table1, 0, 2, 5, 6);


      label = gtk_label_new (_("Misc."));

      gtk_notebook_append_page (GTK_NOTEBOOK (conf_note), table, label);
    }

    // 
    i_resource++;
    {
      GtkWidget *entry;
      
      // 1x4Υơ֥
      table = gtk_table_new (1, 4, FALSE);
      

      frame = gtk_frame_new (_("About This Program"));
      gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
      gtk_table_attach(GTK_TABLE(table), frame, 0, 1, 0, 1,
		       GTK_FILL,GTK_SHRINK,0,0);

      vbox = gtk_vbox_new(FALSE,0);
      gtk_container_add (GTK_CONTAINER (frame), vbox);
      gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);
      label = gtk_label_new ("macopix : Mascot Constructive Pilot for X , version "VERSION);
      gtk_misc_set_alignment (GTK_MISC (label), 0.5, 0.5);
      gtk_box_pack_start(GTK_BOX(vbox), label,FALSE, FALSE, 0);

#ifdef USE_GTK2
      label = gtk_label_new ("(compiled with Gtk+2.x)");
#else
      label = gtk_label_new ("(compiled with Gtk+1.x and Gdk_Pixbuf)");
#endif
      gtk_misc_set_alignment (GTK_MISC (label), 0.5, 0.5);
      gtk_box_pack_start(GTK_BOX(vbox), label,FALSE, FALSE, 0);

      label = gtk_label_new ("");
      gtk_misc_set_alignment (GTK_MISC (label), 0.5, 0.5);
      gtk_box_pack_start(GTK_BOX(vbox), label,FALSE, FALSE, 0);

      label = gtk_label_new ("Copyright(C) 2002-2004 K.Chimari <chimari@kurumi.sakura.ne.jp>");
      gtk_misc_set_alignment (GTK_MISC (label), 0.5, 0.5);
      gtk_box_pack_start(GTK_BOX(vbox), label,FALSE, FALSE, 0);

      label = gtk_label_new ("http://kurumi.sakura.ne.jp/~chimari/");
      gtk_misc_set_alignment (GTK_MISC (label), 0.5, 0.5);
      gtk_box_pack_start(GTK_BOX(vbox), label,FALSE, FALSE, 0);
      

      frame = gtk_frame_new (_("Resource File"));
      gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
      gtk_table_attach(GTK_TABLE(table), frame, 0, 1, 1, 2,
		       GTK_FILL,GTK_SHRINK,0,0);

      table1 = gtk_table_new(2,1,FALSE);
      gtk_container_set_border_width (GTK_CONTAINER (table1), 5);
      gtk_container_add (GTK_CONTAINER (frame), table1);

      entry = gtk_entry_new ();
      if(tmp_mascot.rcfile){
	gtk_entry_set_text(GTK_ENTRY(entry),tmp_mascot.rcfile);
      }
      gtk_entry_set_editable(GTK_ENTRY(entry),FALSE);
      gtk_table_attach_defaults(GTK_TABLE(table1), entry, 0, 2, 0, 1);
      
      //button=gtk_button_new_with_label(_("Save Resource"));
      //gtk_table_attach(GTK_TABLE(table1), button, 1, 2, 0, 1,
      //	       GTK_FILL,GTK_SHRINK,0,0);
      //gtk_signal_connect(GTK_OBJECT(button),"pressed",
      //		 GTK_SIGNAL_FUNC(ConfSaveRC), 
      //		 NULL);


      frame = gtk_frame_new (_("Menu File"));
      gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
      gtk_table_attach(GTK_TABLE(table), frame, 0, 1, 2, 3,
		       GTK_FILL,GTK_SHRINK,0,0);

      table1 = gtk_table_new(2,2,FALSE);
      gtk_container_set_border_width (GTK_CONTAINER (table1), 5);
      gtk_table_set_row_spacings (GTK_TABLE(table1), 5);
      gtk_table_set_col_spacings (GTK_TABLE(table1), 5);
      gtk_container_add (GTK_CONTAINER (frame), table1);

      entry = gtk_entry_new ();
      if(tmp_mascot.menu_file){
	gtk_entry_set_text(GTK_ENTRY(entry),tmp_mascot.menu_file);
      }
      gtk_entry_set_editable(GTK_ENTRY(entry),FALSE);
      gtk_table_attach_defaults(GTK_TABLE(table1), entry, 0, 2, 0, 1);
      
      label = gtk_label_new (_("Character Code"));
      gtk_misc_set_alignment (GTK_MISC (label), 0.5, 0.5);
      gtk_table_attach(GTK_TABLE(table1), label, 0, 1, 1, 2,
		       GTK_FILL,GTK_SHRINK,0,0);

      entry = gtk_entry_new ();
      if(tmp_mascot.menu_code){
	gtk_entry_set_text(GTK_ENTRY(entry),tmp_mascot.menu_code);
      }
      else{
	gtk_entry_set_text(GTK_ENTRY(entry),_("(Based on the locale environment)"));
      }
      gtk_entry_set_editable(GTK_ENTRY(entry),FALSE);
      gtk_table_attach_defaults(GTK_TABLE(table1), entry, 1, 2, 1, 2);


      table1=gtk_table_new(1,1,FALSE);
      gtk_table_attach_defaults(GTK_TABLE(table), table1, 0, 1, 3, 4);
    
      label = gtk_label_new (_("Info."));

      gtk_notebook_append_page (GTK_NOTEBOOK (conf_note), table, label);
    }
  }

  label = gtk_label_new (_("Resource"));
  gtk_notebook_append_page (GTK_NOTEBOOK (all_note), conf_note, label);
  }

 
  /////// ޥå̤ ///////
  {
  GtkWidget *conf_note;
  GtkWidget *label;

  conf_note = gtk_notebook_new ();
  gtk_notebook_set_tab_pos (GTK_NOTEBOOK (conf_note), GTK_POS_TOP);
  gtk_notebook_set_scrollable (GTK_NOTEBOOK (conf_note), TRUE);


  //  button=gtk_button_new_with_label(_("Save Mascot"));
  //gtk_table_attach(GTK_TABLE(conf_tbl), button, 0, 1, 1, 2,
  //		   GTK_FILL,GTK_SHRINK,0,0);
  //gtk_signal_connect(GTK_OBJECT(button),"pressed",
  //		     GTK_SIGNAL_FUNC(ConfSaveMascot), 
  //		     NULL);

  // Ρȥ֥å
  {
    gint i_mascot=0;
    GtkWidget *frame;
    GtkWidget *table;
    GtkWidget *label;
    GtkWidget *combo;
    GtkWidget *clabel;
    GtkWidget *table1;
    GtkWidget *table2;
    GtkWidget *check;
    GtkWidget *vbox;
    GtkWidget *hbox;
    GtkAdjustment *adj;
    GtkWidget *scale;
    GtkWidget *spinner;
    GtkWidget *button;
    GtkWidget *scrwin;

    
    // ư
    i_mascot++;
    {
      
      // 3x6Υơ֥
      table = gtk_table_new (3, 4, FALSE);

      hbox = gtk_hbox_new(FALSE,5);
      gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
      gtk_table_attach(GTK_TABLE(table), hbox, 0, 2, 0, 1,
		       GTK_FILL,GTK_SHRINK,0,0);
      label = gtk_label_new (_("Mode"));
      gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
      gtk_box_pack_start(GTK_BOX(hbox), label,FALSE, FALSE, 0);
  
      combo = gtk_combo_new();
      gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(combo)->entry),FALSE);
      gtk_box_pack_start(GTK_BOX(hbox), combo,FALSE, FALSE, 0);

      clabel = gtk_list_item_new_with_label (_("Fix Position"));
      gtk_container_add (GTK_CONTAINER (GTK_COMBO(combo)->list),
			 clabel);
      gtk_widget_show(clabel);
      clabel = gtk_list_item_new_with_label (_("Focus Follow"));
      gtk_container_add (GTK_CONTAINER (GTK_COMBO(combo)->list),
			 clabel);
      gtk_widget_show(clabel);
      if(Mascot->move==MOVE_FOCUS){
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),
			  _("Focus Follow"));
      }
      gtk_signal_connect (GTK_OBJECT(GTK_COMBO(combo)->entry),
			  "changed",
			  GTK_SIGNAL_FUNC (cc_move),
			  NULL);
	
    
      

      frame = gtk_frame_new (_("Fix Position"));
      gtk_table_attach(GTK_TABLE(table), frame, 0, 2, 1, 2,
		       GTK_FILL,GTK_SHRINK,0,0);
      gtk_container_set_border_width (GTK_CONTAINER (frame), 5);

      table1 = gtk_table_new(2,1,FALSE);
      gtk_container_add (GTK_CONTAINER (frame), table1);
      
      vbox = gtk_hbox_new(FALSE,0);
      gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);
      label = gtk_label_new (_("X"));
      gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
      gtk_box_pack_start(GTK_BOX(vbox), label,FALSE, FALSE, 0);
      adj = (GtkAdjustment *)gtk_adjustment_new 
	((gfloat)Mascot->xfix, 0,Mascot->width_root, 1.0, 1.0, 1.0);
      gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
			  GTK_SIGNAL_FUNC (cc_get_adj),
			  &tmp_mascot.xfix);
      spinner =  gtk_spin_button_new (adj, 0, 0);
      gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), FALSE);
      gtk_box_pack_start(GTK_BOX(vbox), spinner,FALSE, FALSE, 0);
      gtk_table_attach_defaults (GTK_TABLE(table1), vbox, 1, 2, 3, 4);

      vbox = gtk_hbox_new(FALSE,0);
      gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);
      label = gtk_label_new (_("Y"));
      gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
      gtk_box_pack_start(GTK_BOX(vbox), label,FALSE, FALSE, 0);
      adj = (GtkAdjustment *)gtk_adjustment_new 
	((gfloat)Mascot->yfix, 0, Mascot->height_root, 1.0, 1.0, 1.0);
      gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
			  GTK_SIGNAL_FUNC (cc_get_adj),
			  &tmp_mascot.yfix);
      spinner =  gtk_spin_button_new (adj, 0, 0);
      gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), FALSE);
      gtk_box_pack_start(GTK_BOX(vbox), spinner,FALSE, FALSE, 0);
      gtk_table_attach_defaults (GTK_TABLE(table1), vbox, 2, 3, 3, 4);
    
      
    
      frame = gtk_frame_new (_("Mascot Offset for Focus Follow"));
      gtk_table_attach (GTK_TABLE(table), frame, 0, 2, 2, 3,
			GTK_FILL,GTK_SHRINK,0,0);
      gtk_container_set_border_width (GTK_CONTAINER (frame), 5);

      table1 = gtk_table_new(2,1,FALSE);
      gtk_container_add (GTK_CONTAINER (frame), table1);
      
      vbox = gtk_hbox_new(FALSE,0);
      gtk_table_attach_defaults (GTK_TABLE(table1), vbox, 0, 1, 0, 1);
      gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);
      label = gtk_label_new (_("X"));
      gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
      gtk_box_pack_start(GTK_BOX(vbox), label,FALSE, FALSE, 0);
      adj = (GtkAdjustment *)gtk_adjustment_new 
	((gfloat)Mascot->xoff, 0,Mascot->width_root, 1.0, 1.0, 1.0);
      gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
			  GTK_SIGNAL_FUNC (cc_get_adj),
			  &tmp_mascot.xoff);
      spinner =  gtk_spin_button_new (adj, 0, 0);
      gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), FALSE);
      gtk_box_pack_start(GTK_BOX(vbox), spinner,FALSE, FALSE, 0);

      vbox = gtk_hbox_new(FALSE,0);
      gtk_table_attach_defaults (GTK_TABLE(table1), vbox, 1, 2, 0, 1);
      gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);
      label = gtk_label_new (_("Y"));
      gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
      gtk_box_pack_start(GTK_BOX(vbox), label,FALSE, FALSE, 0);
      adj = (GtkAdjustment *)gtk_adjustment_new 
	((gfloat)Mascot->yoff, 0, Mascot->height_root, 1.0, 1.0, 1.0);
      gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
			  GTK_SIGNAL_FUNC (cc_get_adj),
			  &tmp_mascot.yoff);
      spinner =  gtk_spin_button_new (adj, 0, 0);
      gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), FALSE);
      gtk_box_pack_start(GTK_BOX(vbox), spinner,FALSE, FALSE, 0);
   
     
      table1=gtk_table_new(1,1,FALSE);
      gtk_table_attach_defaults(GTK_TABLE(table), table1, 0, 2, 3,4);

      label = gtk_label_new (_("Move"));
      gtk_notebook_append_page (GTK_NOTEBOOK (conf_note), table, label);
    }

    // 
    i_mascot++;
    {
      GtkWidget *entry;
      
      // 2x4Υơ֥
      table = gtk_table_new (2, 5, FALSE);
      
      hbox = gtk_hbox_new(FALSE,5);
      gtk_table_attach(GTK_TABLE(table), hbox, 0, 1, 0, 1,
		       GTK_FILL,GTK_SHRINK,0,0);
      gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
      label = gtk_label_new (_("Mode"));
      gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
      gtk_box_pack_start(GTK_BOX(hbox), label,FALSE, FALSE, 0);

      combo = gtk_combo_new();
      gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(combo)->entry),FALSE);
      gtk_box_pack_start(GTK_BOX(hbox), combo,FALSE, FALSE, 0);

      clabel = gtk_list_item_new_with_label (_("No Clock"));
      gtk_container_add (GTK_CONTAINER (GTK_COMBO(combo)->list),
			 clabel);
      gtk_widget_show(clabel);
      clabel = gtk_list_item_new_with_label (_("Clock on Image"));
      gtk_container_add (GTK_CONTAINER (GTK_COMBO(combo)->list),
			 clabel);
      gtk_widget_show(clabel);
      clabel = gtk_list_item_new_with_label (_("Panel Clock"));
      gtk_container_add (GTK_CONTAINER (GTK_COMBO(combo)->list),
			 clabel);
      gtk_widget_show(clabel);
      if(Mascot->clkmode==CLOCK_PIXMAP){
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),
			  _("Clock on Image"));
      }
      else if(Mascot->clkmode==CLOCK_PANEL){
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),
			  _("Panel Clock"));
      }
      gtk_signal_connect (GTK_OBJECT(GTK_COMBO(combo)->entry),
			  "changed",
			  GTK_SIGNAL_FUNC (cc_clkmode),
			  NULL);
	

      hbox = gtk_hbox_new(FALSE,5);
      gtk_table_attach(GTK_TABLE(table), hbox, 1, 2, 0, 1,
		       GTK_FILL,GTK_SHRINK,0,0);
      gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
      label = gtk_label_new (_("Digit Type"));
      gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
      gtk_box_pack_start(GTK_BOX(hbox), label,FALSE, FALSE, 0);

      combo = gtk_combo_new();
      gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(combo)->entry),FALSE);
      gtk_box_pack_start(GTK_BOX(hbox), combo,FALSE, FALSE, 0);

      clabel = gtk_list_item_new_with_label (_("14:00:00"));
      gtk_container_add (GTK_CONTAINER (GTK_COMBO(combo)->list),
			 clabel);
      gtk_widget_show(clabel);
      clabel = gtk_list_item_new_with_label (_("14:00"));
      gtk_container_add (GTK_CONTAINER (GTK_COMBO(combo)->list),
			 clabel);
      gtk_widget_show(clabel);
      clabel = gtk_list_item_new_with_label (_("PM  2:00:00"));
      gtk_container_add (GTK_CONTAINER (GTK_COMBO(combo)->list),
			 clabel);
      gtk_widget_show(clabel);
      clabel = gtk_list_item_new_with_label (_("PM  2:00"));
      gtk_container_add (GTK_CONTAINER (GTK_COMBO(combo)->list),
			 clabel);
      gtk_widget_show(clabel);
      if(Mascot->clktype==CLOCK_TYPE_24S){
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),
			  _("14:00:00"));
      }
      else if(Mascot->clktype==CLOCK_TYPE_24M){
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),
			  _("14:00"));
      }
      else if(Mascot->clktype==CLOCK_TYPE_12S){
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),
			  _("PM  2:00:00"));
      }
      else if(Mascot->clktype==CLOCK_TYPE_12M){
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),
			  _("PM  2:00"));
      }
      gtk_signal_connect (GTK_OBJECT(GTK_COMBO(combo)->entry),
			  "changed",
			  GTK_SIGNAL_FUNC (cc_clktype),
			  NULL);
	

      frame = gtk_frame_new (_("Fontset"));
      gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
      gtk_table_attach(GTK_TABLE(table), frame, 0, 2, 1, 2,
		       GTK_FILL,GTK_SHRINK,0,0);
	
      table1 = gtk_table_new (2, 1, FALSE);
      gtk_container_add (GTK_CONTAINER (frame), table1);
      gtk_container_set_border_width (GTK_CONTAINER (table1), 5);

      entry_fontname_clk = gtk_entry_new ();
      gtk_table_attach_defaults (GTK_TABLE(table1), entry_fontname_clk,
				 0, 1, 0, 1);
      gtk_entry_set_text(GTK_ENTRY(entry_fontname_clk),Mascot->fontname_clk);
      gtk_entry_set_editable(GTK_ENTRY(entry_fontname_clk),FALSE);

      button = gtk_button_new_with_label("...");
      gtk_table_attach (GTK_TABLE(table1), button, 1, 2, 0, 1, 
			GTK_SHRINK,GTK_SHRINK,0,0);
      gtk_signal_connect(GTK_OBJECT(button),"pressed",
			 GTK_SIGNAL_FUNC(create_font_selection_dialog), 
			 (gpointer *)CONF_FONT_CLK);
   

      frame = gtk_frame_new (_("Size/Position"));
      gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
      gtk_table_attach(GTK_TABLE(table), frame, 0, 1, 2, 3,
		       GTK_FILL,GTK_SHRINK,0,0);
	
      table1 = gtk_table_new (5, 3, FALSE);
      gtk_container_set_border_width (GTK_CONTAINER (table1), 5);
      gtk_container_add (GTK_CONTAINER (frame), table1);
      gtk_table_set_col_spacings (GTK_TABLE(table1), 5);
      gtk_table_set_col_spacing (GTK_TABLE(table1), 0, 15);
      gtk_table_set_col_spacing (GTK_TABLE(table1), 2, 15);
      gtk_table_set_row_spacing (GTK_TABLE(table1), 0, 5);
      gtk_table_set_row_spacing (GTK_TABLE(table1), 1, 5);

      label = gtk_label_new (_("Panel Position"));
      gtk_table_attach_defaults (GTK_TABLE(table1), label, 0, 1,0, 1);
      gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
      label = gtk_label_new (_("X"));
      gtk_table_attach_defaults (GTK_TABLE(table1), label, 1, 2, 0, 1);
      gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
      adj = (GtkAdjustment *)gtk_adjustment_new 
	((gfloat)Mascot->clk_x, -Mascot->width, Mascot->width*2, 1.0, 
	 10.0, 0.0);
      gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
			  GTK_SIGNAL_FUNC (cc_get_adj),
			  &tmp_mascot.clk_x);
      spinner =  gtk_spin_button_new (adj, 0, 0);
      gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), FALSE);
      gtk_table_attach_defaults (GTK_TABLE(table1), spinner, 2, 3, 0, 1);
      label = gtk_label_new (_("Y"));
      gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
      gtk_table_attach_defaults (GTK_TABLE(table1), label, 3, 4, 0, 1);
      adj = (GtkAdjustment *)gtk_adjustment_new 
	((gfloat)Mascot->clk_y, -Mascot->height, Mascot->height*2, 1.0, 
	 10.0, 0.0);
      gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
			  GTK_SIGNAL_FUNC (cc_get_adj),
			  &tmp_mascot.clk_y);
      spinner =  gtk_spin_button_new (adj, 0, 0);
      gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), FALSE);
      gtk_table_attach_defaults (GTK_TABLE(table1), spinner, 4, 5, 0, 1);

      label = gtk_label_new (_("Text Offset"));
      gtk_table_attach_defaults (GTK_TABLE(table1), label, 0, 1,1, 2);
      gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
      label = gtk_label_new (_("X"));
      gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
      gtk_table_attach_defaults (GTK_TABLE(table1), label, 1, 2, 1, 2);
      adj = (GtkAdjustment *)gtk_adjustment_new 
	((gfloat)Mascot->clktext_x, 0, Mascot->width, 1.0, 10.0, 0.0);
      gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
			  GTK_SIGNAL_FUNC (cc_get_adj),
			  &tmp_mascot.clktext_x);
      spinner =  gtk_spin_button_new (adj, 0, 0);
      gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), FALSE);
      gtk_table_attach_defaults (GTK_TABLE(table1), spinner, 2, 3, 1, 2);
      label = gtk_label_new (_("Y"));
      gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
      gtk_table_attach_defaults (GTK_TABLE(table1), label, 3, 4, 1, 2);
      adj = (GtkAdjustment *)gtk_adjustment_new 
	((gfloat)Mascot->clktext_y, 0, Mascot->height, 1.0, 10.0, 0.0);
      gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
			  GTK_SIGNAL_FUNC (cc_get_adj),
			  &tmp_mascot.clktext_y);
      spinner =  gtk_spin_button_new (adj, 0, 0);
      gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), FALSE);
      gtk_table_attach_defaults (GTK_TABLE(table1), spinner, 4, 5, 1, 2);

      label = gtk_label_new (_("Border Width"));
      gtk_table_attach_defaults (GTK_TABLE(table1), label, 0, 1,2, 3);
      gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
      adj = (GtkAdjustment *)gtk_adjustment_new 
	((gfloat)Mascot->wclkbd, 0, 10, 1.0, 1.0, 0.0);
      gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
			  GTK_SIGNAL_FUNC (cc_get_adj),
			  &tmp_mascot.wclkbd);
      spinner =  gtk_spin_button_new (adj, 0, 0);
      gtk_table_attach_defaults (GTK_TABLE(table1), spinner, 2, 3, 2, 3);
      gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), FALSE);


      frame = gtk_frame_new (_("Shadow"));
      gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
      gtk_table_attach(GTK_TABLE(table), frame, 0, 1, 3, 4,
		       GTK_FILL,GTK_SHRINK,0,0);

      check = gtk_check_button_new_with_label(_("Drop Shadow"));
      gtk_container_add (GTK_CONTAINER (frame), check);
      if(Mascot->flag_clksd){
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),TRUE);
      }
      gtk_signal_connect (GTK_OBJECT (check), "toggled",
			  GTK_SIGNAL_FUNC (cc_get_toggle),
			  &tmp_mascot.flag_clksd);


      frame = gtk_frame_new (_("Color"));
      gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
      gtk_table_attach(GTK_TABLE(table), frame, 1, 2, 2, 4,
		       GTK_FILL,GTK_FILL,0,0);
	
      table1 = gtk_table_new (2, 4, FALSE);
      gtk_container_set_border_width (GTK_CONTAINER (table1), 5);
      gtk_container_add (GTK_CONTAINER (frame), table1);

      label = gtk_label_new (_("Text"));
      gtk_table_attach_defaults (GTK_TABLE(table1), label, 0, 1,0, 1);
      gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
      button = gtk_button_new();
      gtk_table_attach (GTK_TABLE(table1), button,1,2,0,1,1,1,0,0);
      gtk_widget_set_usize (button, 40, 25);
      gtk_container_set_border_width(GTK_CONTAINER (button), 5);
      change_bgcolor(button, *Mascot->colclk);
      gtk_signal_connect(GTK_OBJECT(button),"pressed",
			 GTK_SIGNAL_FUNC(create_color_selection_dialog), 
			 (gpointer *)CONF_COLOR_CLK);

      label = gtk_label_new (_("BG"));
      gtk_table_attach_defaults (GTK_TABLE(table1), label, 0, 1,1, 2);
      gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
      button = gtk_button_new();
      gtk_table_attach(GTK_TABLE(table1), button,1,2,1,2,1,1,0,0);
      gtk_widget_set_usize (button, 40, 25);
      gtk_container_set_border_width(GTK_CONTAINER (button), 5);
      change_bgcolor(button, *Mascot->colclkbg);
      gtk_signal_connect(GTK_OBJECT(button),"pressed",
			 GTK_SIGNAL_FUNC(create_color_selection_dialog), 
			 (gpointer *)CONF_COLOR_CLKBG);

      label = gtk_label_new (_("Border"));
      gtk_table_attach_defaults (GTK_TABLE(table1), label, 0, 1,2, 3);
      gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
      button = gtk_button_new();
      gtk_table_attach(GTK_TABLE(table1),button,1,2,2,3,1,1,0,0);
      gtk_widget_set_usize (button, 40, 25);
      gtk_container_set_border_width(GTK_CONTAINER (button), 5);
      change_bgcolor(button, *Mascot->colclkbd);
      gtk_signal_connect(GTK_OBJECT(button),"pressed",
			 GTK_SIGNAL_FUNC(create_color_selection_dialog), 
			 (gpointer *)CONF_COLOR_CLKBD);

      label = gtk_label_new (_("Shadow"));
      gtk_table_attach_defaults (GTK_TABLE(table1), label, 0, 1,3, 4);
      gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
      button = gtk_button_new();
      gtk_table_attach(GTK_TABLE(table1),button,1,2,3,4,1,1,0,0);
      gtk_widget_set_usize (button, 40, 25);
      gtk_container_set_border_width(GTK_CONTAINER (button), 5);
      change_bgcolor(button, *Mascot->colclksd);
      gtk_signal_connect(GTK_OBJECT(button),"pressed",
			 GTK_SIGNAL_FUNC(create_color_selection_dialog), 
			 (gpointer *)CONF_COLOR_CLKSD);


      table1=gtk_table_new(1,1,FALSE);
      gtk_table_attach_defaults(GTK_TABLE(table), table1, 0, 2, 4, 5);


      label = gtk_label_new (_("Clock"));

      gtk_notebook_append_page (GTK_NOTEBOOK (conf_note), table, label);
    }

   // դ
    i_mascot++;
    {
      
      // 2x3Υơ֥
      table = gtk_table_new (2, 3, FALSE);
      
      frame = gtk_frame_new (_("Fontset"));
      gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
      gtk_table_attach(GTK_TABLE(table), frame, 0, 2, 0, 1,
		       GTK_FILL,GTK_SHRINK,0,0);
	

      table1 = gtk_table_new (2, 1, FALSE);
      gtk_container_set_border_width (GTK_CONTAINER (table1), 5);
      gtk_container_add (GTK_CONTAINER (frame), table1);

      entry_fontname_bal = gtk_entry_new ();
      gtk_table_attach_defaults (GTK_TABLE(table1), entry_fontname_bal,
				 0, 1, 0, 1);
      gtk_entry_set_text(GTK_ENTRY(entry_fontname_bal),Mascot->fontname_bal);
      gtk_entry_set_editable(GTK_ENTRY(entry_fontname_bal),FALSE);

      button = gtk_button_new_with_label("...");
      gtk_table_attach (GTK_TABLE(table1), button, 1, 2, 0, 1, 
			GTK_SHRINK,GTK_SHRINK,0,0);
      gtk_signal_connect(GTK_OBJECT(button),"pressed",
			 GTK_SIGNAL_FUNC(create_font_selection_dialog), 
			 (gpointer *)CONF_FONT_BAL);
      

      frame = gtk_frame_new (_("Size/Position"));
      gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
      gtk_table_attach(GTK_TABLE(table), frame, 0, 1, 1, 2,
		       GTK_FILL,GTK_FILL,0,0);
	
      table1 = gtk_table_new (6, 3, FALSE);
      gtk_container_set_border_width (GTK_CONTAINER (table1), 5);
      gtk_container_add (GTK_CONTAINER (frame), table1);
      gtk_table_set_col_spacings (GTK_TABLE(table1), 5);
      gtk_table_set_col_spacing (GTK_TABLE(table1), 0, 15);
      gtk_table_set_col_spacing (GTK_TABLE(table1), 2, 15);
      gtk_table_set_row_spacing (GTK_TABLE(table1), 0, 5);
      gtk_table_set_row_spacing (GTK_TABLE(table1), 1, 5);

      label = gtk_label_new (_("Text Offset"));
      gtk_table_attach_defaults (GTK_TABLE(table1), label, 0, 1,0, 1);
      gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

      label = gtk_label_new (_("X"));
      gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
      gtk_table_attach (GTK_TABLE(table1), label, 1, 2, 0, 1,
			GTK_SHRINK,GTK_SHRINK,0,0);
      adj = (GtkAdjustment *)gtk_adjustment_new 
	((gfloat)Mascot->baltext_x, 0, 20, 1.0, 1.0, 0.0);
      gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
			  GTK_SIGNAL_FUNC (cc_get_adj),
			  &tmp_mascot.baltext_x);
      spinner =  gtk_spin_button_new (adj, 0, 0);
      gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), FALSE);
      gtk_table_attach (GTK_TABLE(table1), spinner, 2, 3, 0, 1,
			GTK_SHRINK,GTK_SHRINK,0,0);
      label = gtk_label_new (_("Y"));
      gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
      gtk_table_attach (GTK_TABLE(table1), label, 3, 4, 0, 1,
			GTK_SHRINK,GTK_SHRINK,0,0);
      adj = (GtkAdjustment *)gtk_adjustment_new 
	((gfloat)Mascot->baltext_y, 0, 20, 1.0, 1.0, 0.0);
      gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
			  GTK_SIGNAL_FUNC (cc_get_adj),
			  &tmp_mascot.baltext_y);
      spinner =  gtk_spin_button_new (adj, 0, 0);
      gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), FALSE);
      gtk_table_attach (GTK_TABLE(table1), spinner, 4, 5, 0, 1,
			GTK_SHRINK,GTK_SHRINK,0,0);


      label = gtk_label_new (_("Border Width"));
      gtk_table_attach_defaults (GTK_TABLE(table1), label, 0, 1,1, 2);
      gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
      adj = (GtkAdjustment *)gtk_adjustment_new 
	((gfloat)Mascot->wbalbd, 0, 10, 1.0, 1.0, 0.0);
      gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
			  GTK_SIGNAL_FUNC (cc_get_adj),
			  &tmp_mascot.wbalbd);
      spinner =  gtk_spin_button_new (adj, 0, 0);
      gtk_table_attach (GTK_TABLE(table1), spinner, 2, 3,1, 2,
			GTK_SHRINK,GTK_SHRINK,0,0);
      gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), FALSE);

      label = gtk_label_new (_("Default Position"));
      gtk_table_attach_defaults (GTK_TABLE(table1), label,0,1,2, 3);
      gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
      combo = gtk_combo_new();
      gtk_table_attach (GTK_TABLE(table1), combo, 2, 6, 2, 3,
			GTK_SHRINK,GTK_SHRINK,0,0);
      gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(combo)->entry),FALSE);
      clabel = gtk_list_item_new_with_label (_("Left"));
      gtk_container_add (GTK_CONTAINER (GTK_COMBO(combo)->list),
			 clabel);
      gtk_widget_show(clabel);
      clabel = gtk_list_item_new_with_label (_("Right"));
      gtk_container_add (GTK_CONTAINER (GTK_COMBO(combo)->list),
			 clabel);
      gtk_widget_show(clabel);
      if(Mascot->bal_defpos==BAL_POS_RIGHT){
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),
			  _("Right"));
      }
      gtk_signal_connect (GTK_OBJECT(GTK_COMBO(combo)->entry),
			  "changed",
			  GTK_SIGNAL_FUNC (cc_bal_defpos),
			  NULL);


      frame = gtk_frame_new (_("Color"));
      gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
      gtk_table_attach(GTK_TABLE(table), frame, 1, 2, 1, 2,
		       GTK_FILL,GTK_FILL,0,0);
	
      table1 = gtk_table_new (2, 3, FALSE);
      gtk_container_set_border_width (GTK_CONTAINER (table1), 5);
      gtk_container_add (GTK_CONTAINER (frame), table1);

      label = gtk_label_new (_("Text"));
      gtk_table_attach_defaults (GTK_TABLE(table1), label, 0, 1,0, 1);
      gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
      button = gtk_button_new();
      gtk_table_attach (GTK_TABLE(table1), button,1,2,0,1,1,1,0,0);
      gtk_widget_set_usize (button, 40, 25);
      gtk_container_set_border_width(GTK_CONTAINER (button), 5);
      change_bgcolor(button, *Mascot->colbal);
      gtk_signal_connect(GTK_OBJECT(button),"pressed",
			 GTK_SIGNAL_FUNC(create_color_selection_dialog), 
			 (gpointer *)CONF_COLOR_BAL);

      label = gtk_label_new (_("BG"));
      gtk_table_attach_defaults (GTK_TABLE(table1), label, 0, 1,1, 2);
      gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
      button = gtk_button_new();
      gtk_table_attach(GTK_TABLE(table1), button,1,2,1,2,1,1,0,0);
      gtk_widget_set_usize (button, 40, 25);
      gtk_container_set_border_width(GTK_CONTAINER (button), 5);
      change_bgcolor(button, *Mascot->colbalbg);
      gtk_signal_connect(GTK_OBJECT(button),"pressed",
			 GTK_SIGNAL_FUNC(create_color_selection_dialog), 
			 (gpointer *)CONF_COLOR_BALBG);

      label = gtk_label_new (_("Border"));
      gtk_table_attach_defaults (GTK_TABLE(table1), label, 0, 1,2, 3);
      gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
      button = gtk_button_new();
      gtk_table_attach(GTK_TABLE(table1),button,1,2,2,3,1,1,0,0);
      gtk_widget_set_usize (button, 40, 25);
      gtk_container_set_border_width(GTK_CONTAINER (button), 5);
      change_bgcolor(button, *Mascot->colbalbd);
      gtk_signal_connect(GTK_OBJECT(button),"pressed",
			 GTK_SIGNAL_FUNC(create_color_selection_dialog), 
			 (gpointer *)CONF_COLOR_BALBD);

      table1=gtk_table_new(1,1,FALSE);
      gtk_table_attach_defaults(GTK_TABLE(table), table1, 0, 2, 2, 3);

    
      label = gtk_label_new (_("Balloon"));

      gtk_notebook_append_page (GTK_NOTEBOOK (conf_note), table, label);
      }

    // 
    i_mascot++;
    {
      
      table = gtk_table_new (2, 3, FALSE);
      
      scrwin = gtk_scrolled_window_new (NULL, NULL);
      gtk_table_attach_defaults (GTK_TABLE(table), scrwin, 0, 2, 0, 1);
      gtk_container_set_border_width (GTK_CONTAINER (scrwin), 5);
      gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW(scrwin),
				      GTK_POLICY_NEVER,
				      GTK_POLICY_ALWAYS);

      make_pixmap_list(scrwin);

      hbox = gtk_hbox_new(FALSE,5);
      gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
      gtk_table_attach(GTK_TABLE(table), hbox, 0, 2, 2, 3,
		       GTK_SHRINK,GTK_SHRINK,0,0);
      button = gtk_button_new_with_label(_("Append"));
      gtk_box_pack_start(GTK_BOX(hbox), button,FALSE, FALSE, 0);
      gtk_signal_connect(GTK_OBJECT(button),"pressed",
			 GTK_SIGNAL_FUNC(create_add_image_dialog),
			 (gpointer)scrwin);
      

      button = gtk_button_new_with_label(_("Delete"));
      gtk_box_pack_start(GTK_BOX(hbox), button,FALSE, FALSE, 0);
      gtk_signal_connect(GTK_OBJECT(button),"pressed",
			 GTK_SIGNAL_FUNC(create_del_image_dialog),
			 (gpointer)scrwin);
      

      label = gtk_label_new (_("Images"));

      gtk_notebook_append_page (GTK_NOTEBOOK (conf_note), table, label);
    }

    // ˥
    i_mascot++;
    {
      GtkWidget *ptn_note;

      table = gtk_table_new (1, 2, FALSE);

      ptn_note = gtk_notebook_new ();
      gtk_notebook_set_tab_pos (GTK_NOTEBOOK (ptn_note), GTK_POS_RIGHT);
      gtk_notebook_set_scrollable (GTK_NOTEBOOK (ptn_note), TRUE);

      
      gtk_table_attach_defaults (GTK_TABLE(table), ptn_note, 0, 1, 0, 1);

      // Pattern Ͽnotebook
      {
	gint i_ptn=0;

	for(i_ptn=0;i_ptn<MAX_ANIME_PATTERN;i_ptn++){
	  flag_make_pattern_list[i_ptn]=FALSE;
	  flag_make_frame_list[i_ptn]=FALSE;
	}
	
	i_ptn=0;
	while(tmp_mascot.frame_pix[i_ptn][0]!=-1){
	  make_pattern_list(ptn_note, i_ptn);

	  i_ptn++;
	}
	pattern_num=i_ptn;
      }

      hbox = gtk_hbox_new(FALSE,5);
      gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
      gtk_table_attach(GTK_TABLE(table), hbox, 0, 1, 1, 2,
		       GTK_SHRINK,GTK_SHRINK,0,0);
      button = gtk_button_new_with_label(_("Append Pattern"));
      gtk_box_pack_start(GTK_BOX(hbox), button,FALSE, FALSE, 0);
      gtk_signal_connect(GTK_OBJECT(button),"pressed",
			 GTK_SIGNAL_FUNC(create_add_pattern_dialog),
			 (gpointer)ptn_note);
	  
      button = gtk_button_new_with_label(_("Copy Pattern"));
      gtk_box_pack_start(GTK_BOX(hbox), button,FALSE, FALSE, 0);
      gtk_signal_connect(GTK_OBJECT(button),"pressed",
			 GTK_SIGNAL_FUNC(create_copy_pattern_dialog),
			 (gpointer)ptn_note);
	  
      button = gtk_button_new_with_label(_("Delete Pattern"));
      gtk_box_pack_start(GTK_BOX(hbox), button,FALSE, FALSE, 0);
      gtk_signal_connect(GTK_OBJECT(button),"pressed",
			 GTK_SIGNAL_FUNC(create_del_pattern_dialog),
			 (gpointer)ptn_note);
	  
  
      
    
      label = gtk_label_new (_("Animation"));

      gtk_notebook_append_page (GTK_NOTEBOOK (conf_note), table, label);
  
    }

    // Biff
    i_mascot++;
    {
      GtkWidget *entry;
      GtkWidget *table2;

      // 1x2Υơ֥
      table = gtk_table_new (1, 3, FALSE);
      
      frame = gtk_frame_new (_("Biff Image"));
      // 忮
      gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
      gtk_table_attach(GTK_TABLE(table), frame, 0, 1, 0, 1,
		       GTK_FILL|GTK_EXPAND,GTK_SHRINK,0,0);
      
      
      table1 = gtk_table_new (4, 2, FALSE);
      gtk_container_set_border_width (GTK_CONTAINER (table1), 5);
      gtk_container_add (GTK_CONTAINER (frame), table1);
      gtk_table_set_row_spacings (GTK_TABLE(table1), 5);
      gtk_table_set_col_spacings (GTK_TABLE(table1), 5);
      
      
      label = gtk_label_new (_("Image File"));
      gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
      gtk_table_attach(GTK_TABLE(table1), label, 0, 1, 0, 1,0,0,0,0);
      
      table2 = gtk_table_new (2, 1, FALSE);
      gtk_table_attach (GTK_TABLE(table1), table2,
			1, 2, 0, 1,
			GTK_FILL,
			GTK_SHRINK,0,0);
      
      entry = gtk_entry_new ();
      gtk_table_attach (GTK_TABLE(table2), entry,
			0, 1, 0, 1,
			GTK_EXPAND | GTK_FILL,
			GTK_EXPAND | GTK_FILL,0,0);
      if(Mascot->mail.pix_file){
	gtk_entry_set_text(GTK_ENTRY(entry), 
			   g_basename(Mascot->mail.pix_file));
      }
      gtk_entry_set_editable(GTK_ENTRY(entry),FALSE);
      
      button = gtk_button_new_with_label("...");
      gtk_table_attach (GTK_TABLE(table2), button, 1, 2, 0, 1, 
			GTK_SHRINK,GTK_SHRINK,0,0);
      gtk_signal_connect(GTK_OBJECT(button),"pressed",
			 GTK_SIGNAL_FUNC(create_change_biff_image_dialog), 
			 (gpointer)entry);
      
      
      label = gtk_label_new (_("Position"));
      gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
      gtk_table_attach(GTK_TABLE(table1), label, 0, 1, 1, 2,
		       GTK_SHRINK,GTK_SHRINK,0,0);
      
      combo = gtk_combo_new();
      gtk_table_attach(GTK_TABLE(table1), combo, 1, 2, 1, 2,
		       GTK_SHRINK,GTK_SHRINK,0,0);
      gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(combo)->entry),FALSE);
      clabel = gtk_list_item_new_with_label (_("Left"));
      gtk_container_add (GTK_CONTAINER (GTK_COMBO(combo)->list),
			 clabel);
      gtk_widget_show(clabel);
      clabel = gtk_list_item_new_with_label (_("Right"));
      gtk_container_add (GTK_CONTAINER (GTK_COMBO(combo)->list),
			 clabel);
      gtk_widget_show(clabel);
      if(Mascot->mail.pix_pos==MAIL_PIX_RIGHT){
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),
			   _("Right"));
      }
      gtk_signal_connect (GTK_OBJECT(GTK_COMBO(combo)->entry),
			  "changed",
			  GTK_SIGNAL_FUNC (cc_mail_pixpos),
			  NULL);


      hbox = gtk_hbox_new(FALSE,5);
      gtk_table_attach(GTK_TABLE(table1), hbox, 2, 3, 1, 2,0,0,0,0);
      label = gtk_label_new (_("X"));
      gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
      gtk_box_pack_start(GTK_BOX(hbox), label,FALSE, FALSE, 0);
      
      adj = (GtkAdjustment *)gtk_adjustment_new 
	((gfloat)Mascot->mail.pix_x, (gfloat)(-Mascot->width),
	 (gfloat)(Mascot->width), 1.0, 1.0, 1.0);
      gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
			  GTK_SIGNAL_FUNC (cc_get_adj),
			  &tmp_mascot.mail.pix_x);
      spinner =  gtk_spin_button_new (adj, 0, 0);
      gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), FALSE);
      gtk_box_pack_start(GTK_BOX(hbox), spinner,FALSE, FALSE, 0);
      gtk_entry_set_editable(GTK_ENTRY(&GTK_SPIN_BUTTON(spinner)->entry),
			     FALSE);
      
      
      hbox = gtk_hbox_new(FALSE,5);
      gtk_table_attach(GTK_TABLE(table1), hbox, 3, 4, 1, 2,0,0,0,0);
      label = gtk_label_new (_("Y"));
      gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
      gtk_box_pack_start(GTK_BOX(hbox), label,FALSE, FALSE, 0);
      
      adj = (GtkAdjustment *)gtk_adjustment_new 
	((gfloat)Mascot->mail.pix_y, (gfloat)(-Mascot->height),
	 (gfloat)(Mascot->height), 1.0, 1.0, 1.0);
      gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
			  GTK_SIGNAL_FUNC (cc_get_adj),
			  &tmp_mascot.mail.pix_y);
      spinner =  gtk_spin_button_new (adj, 0, 0);
      gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), FALSE);
      gtk_box_pack_start(GTK_BOX(hbox), spinner,FALSE, FALSE, 0);
      gtk_entry_set_editable(GTK_ENTRY(&GTK_SPIN_BUTTON(spinner)->entry),
			     FALSE);
      

      frame = gtk_frame_new (_("Biff Action"));
      // 忮ư
      gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
      gtk_table_attach(GTK_TABLE(table), frame, 0, 1, 1, 2,
		       GTK_FILL|GTK_EXPAND,GTK_SHRINK,0,0);
      
      
      table1 = gtk_table_new (2, 3, FALSE);
      gtk_container_set_border_width (GTK_CONTAINER (table1), 5);
      gtk_container_add (GTK_CONTAINER (frame), table1);
      gtk_table_set_row_spacings (GTK_TABLE(table1), 5);
      
      label = gtk_label_new (_("Message"));
      gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
      gtk_table_attach(GTK_TABLE(table1), label, 0, 1, 0, 1,0,0,0,0);
	
      entry = gtk_entry_new ();
      gtk_signal_connect (GTK_OBJECT(entry),
			  "changed",
			  GTK_SIGNAL_FUNC (cc_get_entry),
			  &tmp_mascot.mail.word);
      gtk_table_attach (GTK_TABLE(table1), entry,
			1, 2, 0, 1,
			GTK_EXPAND | GTK_FILL,
			GTK_EXPAND | GTK_FILL,0,0);
      if(Mascot->mail.word){
	gtk_entry_set_text(GTK_ENTRY(entry), Mascot->mail.word);
      }
      gtk_entry_set_editable(GTK_ENTRY(entry),TRUE);
      
      label = gtk_label_new (_("Sound File"));
      gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
      gtk_table_attach(GTK_TABLE(table1), label, 0, 1, 1, 2,0,0,0,0);
      
      table2 = gtk_table_new (4, 1, FALSE);
      gtk_table_attach (GTK_TABLE(table1), table2,
			1, 2, 1, 2,
			GTK_FILL,
			GTK_SHRINK,0,0);
      
      entry = gtk_entry_new ();
      gtk_table_attach (GTK_TABLE(table2), entry,
			0, 1, 0, 1,
			GTK_EXPAND | GTK_FILL,
			GTK_EXPAND | GTK_FILL,0,0);
      if(Mascot->mail.sound){
	gtk_entry_set_text(GTK_ENTRY(entry), Mascot->mail.sound);
      }
      gtk_entry_set_editable(GTK_ENTRY(entry),FALSE);
      
      button = gtk_button_new_with_label("...");
      gtk_table_attach (GTK_TABLE(table2), button, 1, 2, 0, 1, 
			GTK_SHRINK,GTK_SHRINK,0,0);
      gtk_signal_connect(GTK_OBJECT(button),"pressed",
			 GTK_SIGNAL_FUNC(create_change_biff_sound_dialog), 
			 (gpointer)entry);
      
      button = gtk_button_new_with_label(_("Clear"));
      gtk_table_attach (GTK_TABLE(table2), button, 2, 3, 0, 1, 
			GTK_SHRINK,GTK_SHRINK,0,0);
      gtk_signal_connect (GTK_OBJECT(button),
			  "pressed",
			  GTK_SIGNAL_FUNC(clear_biff_sound),
			  (gpointer)entry);
      
      button = gtk_button_new_with_label(_("Test"));
      gtk_table_attach (GTK_TABLE(table2), button, 3, 4, 0, 1, 
			GTK_SHRINK,GTK_SHRINK,0,0);
      gtk_signal_connect (GTK_OBJECT(button),
			  "pressed",
			  GTK_SIGNAL_FUNC(test_biff_sound),
			  NULL);
      
      table1=gtk_table_new(1,1,FALSE);
      gtk_table_attach_defaults(GTK_TABLE(table), table1, 0, 1, 2, 3);
     

      label = gtk_label_new (_("Biff"));
      gtk_notebook_append_page (GTK_NOTEBOOK (conf_note), table, label);
    }

    // 
    i_mascot++;
    {
      GtkWidget *entry;
      
      // 1x4Υơ֥
      table = gtk_table_new (1, 2, FALSE);
      


      frame = gtk_frame_new (_("About This Mascot"));
      gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
      gtk_table_attach(GTK_TABLE(table), frame, 0, 1, 0, 1,
		       GTK_FILL,GTK_SHRINK,0,0);

      table1 = gtk_table_new(2,4,FALSE);
      gtk_container_set_border_width (GTK_CONTAINER (table1), 5);
      gtk_table_set_row_spacings (GTK_TABLE (table1), 5);
      gtk_table_set_col_spacings (GTK_TABLE (table1), 5);
      gtk_container_add (GTK_CONTAINER (frame), table1);

      label = gtk_label_new (_("Name"));
      gtk_misc_set_alignment (GTK_MISC (label), 0.5, 0.5);
      gtk_table_attach(GTK_TABLE(table1), label, 0, 1, 0, 1,
		       GTK_FILL,GTK_SHRINK,0,0);

      entry = gtk_entry_new ();
      if(tmp_mascot.name){
	gtk_entry_set_text(GTK_ENTRY(entry),tmp_mascot.name);
      }
      gtk_entry_set_editable(GTK_ENTRY(entry),TRUE);
      gtk_table_attach_defaults(GTK_TABLE(table1), entry, 1, 2, 0, 1);
      gtk_signal_connect (GTK_OBJECT(entry),
			  "changed",
			  GTK_SIGNAL_FUNC(cc_get_entry),
			  &tmp_mascot.name);

      label = gtk_label_new (_("File"));
      gtk_misc_set_alignment (GTK_MISC (label), 0.5, 0.5);
      gtk_table_attach(GTK_TABLE(table1), label, 0, 1, 1, 2,
		       GTK_FILL,GTK_SHRINK,0,0);

      entry = gtk_entry_new ();
      gtk_entry_set_text(GTK_ENTRY(entry),tmp_mascot.file);
      gtk_entry_set_editable(GTK_ENTRY(entry),FALSE);
      gtk_table_attach_defaults(GTK_TABLE(table1), entry, 1, 2, 1, 2);


      label = gtk_label_new (_("Character Code"));
      gtk_misc_set_alignment (GTK_MISC (label), 0.5, 0.5);
      gtk_table_attach(GTK_TABLE(table1), label, 0, 1, 2, 3,
		       GTK_FILL,GTK_SHRINK,0,0);

      entry = gtk_entry_new ();
      if(tmp_mascot.code){
	gtk_entry_set_text(GTK_ENTRY(entry),tmp_mascot.code);
      }
      else{
	gtk_entry_set_text(GTK_ENTRY(entry),_("(Based on the locale environment)"));
      }
      gtk_entry_set_editable(GTK_ENTRY(entry),FALSE);
      gtk_table_attach_defaults(GTK_TABLE(table1), entry, 1, 2, 2, 3);


      if(Mascot->copyright){
	label = gtk_label_new (Mascot->copyright);
	gtk_misc_set_alignment (GTK_MISC (label), 0.5, 0.5);
	gtk_table_attach_defaults(GTK_TABLE(table1), label, 0, 2, 3, 4);
      }


      table1=gtk_table_new(1,1,FALSE);
      gtk_table_attach_defaults(GTK_TABLE(table), table1, 0, 1, 1, 2);
    
      label = gtk_label_new (_("Info."));

      gtk_notebook_append_page (GTK_NOTEBOOK (conf_note), table, label);
    }
  }

  label = gtk_label_new (_("Mascot"));
  gtk_notebook_append_page (GTK_NOTEBOOK (all_note), conf_note, label);
  }
 
  // ˥塼
  {
    GtkWidget *table;
    GtkWidget *label;

    if(tmp_mascot.menu_total==0){
      table=create_new_menu_page();
    }
    else{
      table=create_menu_page();
    }
    
    label = gtk_label_new (_("Menu"));
      
    gtk_notebook_append_page (GTK_NOTEBOOK (all_note), table, label);
     
  }


  gtk_widget_show_all(conf_main);
  gdk_flush();
}

// Υ˥塼ڡκ
// ˥塼
GtkWidget * create_menu_page()
{
  GtkWidget *table;
  GtkWidget *button;
  GtkWidget *hbox;

  // 2x1Υơ֥
  table = gtk_table_new (2, 1, FALSE);

  cat_note = gtk_notebook_new ();
  gtk_notebook_set_tab_pos (GTK_NOTEBOOK (cat_note), GTK_POS_TOP);
  gtk_notebook_set_scrollable (GTK_NOTEBOOK (cat_note), TRUE);
  
  gtk_table_attach_defaults (GTK_TABLE(table), cat_note, 0, 1, 0, 1);
  
  // Category Ͽnotebook
  {
    gint i_cat=0;
    
    
    for(i_cat=0;i_cat<MAX_MENU_CATEGORY;i_cat++){
      flag_make_cat_list[i_cat]=FALSE;
      flag_make_tgt_list[i_cat]=FALSE;
    }
    
    for(i_cat=0;i_cat<tmp_mascot.menu_cat_max;i_cat++){
      make_cat_list(cat_note, i_cat);
    }
  }
  
  hbox = gtk_hbox_new(FALSE,5);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
  gtk_table_attach(GTK_TABLE(table), hbox, 0, 1, 1, 2,
		   GTK_SHRINK,GTK_SHRINK,0,0);
  
  button = gtk_button_new_with_label(_("Append Category"));
  gtk_box_pack_start(GTK_BOX(hbox), button,FALSE, FALSE, 0);
  gtk_signal_connect(GTK_OBJECT(button),"pressed",
		     GTK_SIGNAL_FUNC(create_add_cat_dialog),
		     NULL);
  
  button = gtk_button_new_with_label(_("Delete Category"));
  gtk_box_pack_start(GTK_BOX(hbox), button,FALSE, FALSE, 0);
  gtk_signal_connect(GTK_OBJECT(button),"pressed",
		     GTK_SIGNAL_FUNC(create_del_cat_dialog),
		     NULL);
  
  button = gtk_button_new_with_label(_("Merge Menu"));
  gtk_box_pack_start(GTK_BOX(hbox), button,FALSE, FALSE, 0);
  gtk_signal_connect(GTK_OBJECT(button),"pressed",
		     GTK_SIGNAL_FUNC(create_merge_cat_dialog),
		     NULL);

  return(table);
}

// Υ˥塼ڡκ
// ˥塼ʤ
GtkWidget * create_new_menu_page(GtkWidget *conf_note)
{
  GtkWidget *table;
  GtkWidget *label;
  GtkWidget *vbox;

  // 1x3Υơ֥
  table = gtk_table_new (1, 3, FALSE);


  vbox = gtk_vbox_new(FALSE,5);
  gtk_table_attach(GTK_TABLE(table), vbox, 0, 1, 0, 1,
		   GTK_SHRINK,GTK_SHRINK,0,0);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);
  label = gtk_label_new ("");
  gtk_misc_set_alignment (GTK_MISC (label), 0.5, 0.5);
  gtk_box_pack_start(GTK_BOX(vbox), label,FALSE, FALSE, 0);
  
  label = gtk_label_new (_("No menu files are loaded currently."));
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
  gtk_box_pack_start(GTK_BOX(vbox), label,FALSE, FALSE, 0);
  
  label = gtk_label_new (_("You can find a menu to create new one in the popup,"));
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
  gtk_box_pack_start(GTK_BOX(vbox), label,FALSE, FALSE, 0);
  
  label = gtk_label_new (_(" and edit it here."));
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
  gtk_box_pack_start(GTK_BOX(vbox), label,FALSE, FALSE, 0);
  
  return(table);
}

// եꥹ
void make_pixmap_list(GtkWidget *scrwin)
{
  int i_pix;
  char no_tmp[3];
  GtkWidget *label;
  GtkWidget *button;
  
  if(flag_make_pixmap_list)  gtk_widget_destroy(pixmap_table);
  else flag_make_pixmap_list=TRUE;

  pixmap_table = gtk_table_new (3, MAX_PIXMAP+2, FALSE);
  gtk_container_set_border_width (GTK_CONTAINER (pixmap_table), 5);

  //gtk_table_set_row_spacings (GTK_TABLE (pixmap_table), 1);
  //gtk_table_set_col_spacings (GTK_TABLE (pixmap_table), 1);
  gtk_scrolled_window_add_with_viewport
    (GTK_SCROLLED_WINDOW (scrwin), pixmap_table);
  
  label = gtk_label_new (_("No."));
  gtk_table_attach(GTK_TABLE(pixmap_table), label, 0, 1, 0, 1,
		   GTK_SHRINK,GTK_SHRINK,0,0);
  
  gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
	 
  label = gtk_label_new (_("Image File Name"));
  gtk_table_attach(GTK_TABLE(pixmap_table), label, 1, 2, 0, 1,
		   GTK_EXPAND,GTK_SHRINK,0,2);
  gtk_misc_set_alignment (GTK_MISC (label), 0.5, 0.5);
  
  for(i_pix=0;i_pix<tmp_mascot.nPixmap;i_pix++){
    sprintf(no_tmp,"%02d",i_pix);
    button = gtk_button_new_with_label(no_tmp);
    gtk_table_attach (GTK_TABLE(pixmap_table),
		      button, 0, 1, i_pix+1, i_pix+2,
		      GTK_SHRINK,GTK_SHRINK,0,2);
    gtk_signal_connect(GTK_OBJECT(button),"pressed",
		       GTK_SIGNAL_FUNC(TestPut), 
		       (gpointer)(i_pix));
  
    pixmap_entry[i_pix] = gtk_entry_new ();
    gtk_table_attach(GTK_TABLE(pixmap_table), pixmap_entry[i_pix],
		     1, 2, i_pix+1, i_pix+2,
		     GTK_FILL,GTK_SHRINK,0,2);
    gtk_entry_set_text(GTK_ENTRY(pixmap_entry[i_pix]),
		       g_basename(tmp_pixfile[i_pix]));
    gtk_entry_set_editable(GTK_ENTRY(pixmap_entry[i_pix]),FALSE);
	   
    
    button = gtk_button_new_with_label("...");
    gtk_table_attach (GTK_TABLE(pixmap_table), button, 
		      2, 3, i_pix+1, i_pix+2,
		      GTK_SHRINK,GTK_SHRINK,0,0);
    gtk_signal_connect(GTK_OBJECT(button),"pressed",
		       GTK_SIGNAL_FUNC(create_change_image_dialog), 
		       (gpointer)i_pix);
    
  }
  label=gtk_label_new("");
  gtk_table_attach_defaults(GTK_TABLE(pixmap_table), label, 
			    0, 3, MAX_PIXMAP+1, MAX_PIXMAP+2);
  gtk_widget_show_all(pixmap_table);
}


// ѥꥹ
void make_pattern_list(GtkWidget *ptn_note, int i_ptn)
{
  GtkWidget *label;
  GtkWidget *button;
  GtkAdjustment *adj;
  GtkWidget *spinner;
  GtkWidget *hbox;
  GtkWidget *entry;
  GtkWidget *frame;
  GtkWidget *table2;
  gchar bufferl[32];

  if(flag_make_pattern_list[i_ptn]) {
    gtk_widget_destroy(GTK_WIDGET(pattern_table[i_ptn]));
    flag_make_frame_list[i_ptn]=FALSE;
  }
  else flag_make_pattern_list[i_ptn]=TRUE;

  if(i_ptn==0){
    sprintf(bufferl, _("Base"));
  }
  else{
    sprintf(bufferl, "P.%02d", i_ptn);
  }
  
  pattern_table[i_ptn] = gtk_table_new (3, 5, FALSE);

  ptn_scrwin[i_ptn] = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_usize (ptn_scrwin[i_ptn], 30, 150);
  gtk_table_attach_defaults (GTK_TABLE(pattern_table[i_ptn]),
			     ptn_scrwin[i_ptn], 0, 3, 0, 1);
  gtk_container_set_border_width (GTK_CONTAINER (ptn_scrwin[i_ptn]), 5);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW(ptn_scrwin[i_ptn]),
				  GTK_POLICY_NEVER,
				  GTK_POLICY_ALWAYS);
	  
  make_frame_list(i_ptn);
	  
  hbox = gtk_hbox_new(FALSE,5);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
  gtk_table_attach(GTK_TABLE(pattern_table[i_ptn]), hbox, 0, 3, 1, 2,
		   GTK_SHRINK,GTK_SHRINK,0,0);
  button = gtk_button_new_with_label(_("Append Frame"));
  gtk_box_pack_start(GTK_BOX(hbox), button,FALSE, FALSE, 0);
  gtk_signal_connect(GTK_OBJECT(button),"pressed",
		     GTK_SIGNAL_FUNC(create_add_frame_dialog),
		     (gpointer)i_ptn);
	  
  button = gtk_button_new_with_label(_("Delete Frame"));
  gtk_box_pack_start(GTK_BOX(hbox), button,FALSE, FALSE, 0);
  gtk_signal_connect(GTK_OBJECT(button),"pressed",
		     GTK_SIGNAL_FUNC(create_del_frame_dialog),
		     (gpointer)i_ptn);
  
  button = gtk_button_new_with_label(_("Test Anime"));
  gtk_box_pack_start(GTK_BOX(hbox), button,FALSE, FALSE, 0);
  gtk_signal_connect(GTK_OBJECT(button),"pressed",
		     GTK_SIGNAL_FUNC(TestAnime),
		     (gpointer)i_ptn);
  
  if(i_ptn!=0){
      label = gtk_label_new (_(" Random"));
      gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
      gtk_box_pack_start(GTK_BOX(hbox), label,FALSE, FALSE, 0);
      adj = (GtkAdjustment *)gtk_adjustment_new 
	((gfloat)tmp_mascot.random_weight[i_ptn], 0, 99, 1.0, 1.0, 0.0);
      gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
			  GTK_SIGNAL_FUNC (cc_get_adj),
			  &tmp_mascot.random_weight[i_ptn]);
      spinner =  gtk_spin_button_new (adj, 0, 0);
      gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), FALSE);
      gtk_box_pack_start(GTK_BOX(hbox), spinner,FALSE, FALSE, 0);


      label = gtk_label_new (_(" Click"));
      gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
      gtk_box_pack_start(GTK_BOX(hbox), label,FALSE, FALSE, 0);
      adj = (GtkAdjustment *)gtk_adjustment_new 
	((gfloat)tmp_mascot.click_weight[i_ptn], 0, 99, 1.0, 1.0, 0.0);
      gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
			  GTK_SIGNAL_FUNC (cc_get_adj),
			  &tmp_mascot.click_weight[i_ptn]);
      spinner =  gtk_spin_button_new (adj, 0, 0);
      gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), FALSE);
      gtk_box_pack_start(GTK_BOX(hbox), spinner,FALSE, FALSE, 0);
    

      frame = gtk_frame_new (_("Duet Animation"));
      gtk_table_attach(GTK_TABLE(pattern_table[i_ptn]),
		       frame, 0, 3, 4, 5,
		       GTK_FILL,GTK_SHRINK,0,0);
      gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
	
      table2 = gtk_table_new(1,2,FALSE);
      gtk_container_set_border_width (GTK_CONTAINER (table2), 5);
      gtk_container_add (GTK_CONTAINER (frame), table2);

      hbox = gtk_hbox_new(FALSE,0);
      gtk_table_attach_defaults(GTK_TABLE(table2),
		       hbox, 0, 1, 0, 1);
      gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
      label = gtk_label_new (_("Mascot File"));
      gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
      gtk_box_pack_start(GTK_BOX(hbox), label,FALSE, FALSE, 0);
      duet_tgt_entry[i_ptn] = gtk_entry_new ();
      if(tmp_mascot.duet_tgt[i_ptn]){
	gtk_entry_set_text(GTK_ENTRY(duet_tgt_entry[i_ptn]),
			   tmp_mascot.duet_tgt[i_ptn]);
      }
      gtk_entry_set_editable(GTK_ENTRY(duet_tgt_entry[i_ptn]),TRUE);
      gtk_box_pack_start(GTK_BOX(hbox), duet_tgt_entry[i_ptn],TRUE, TRUE, 0);
      gtk_signal_connect (GTK_OBJECT(duet_tgt_entry[i_ptn]),
			  "changed",
			  GTK_SIGNAL_FUNC(cc_get_entry),
			  &tmp_mascot.duet_tgt[i_ptn]);
      button = gtk_button_new_with_label("...");
      gtk_box_pack_start(GTK_BOX(hbox), button,FALSE, FALSE, 0);
      gtk_signal_connect(GTK_OBJECT(button),"pressed",
			 GTK_SIGNAL_FUNC(create_change_duet_tgt_dialog), 
			 (gpointer)(i_ptn));
      label = gtk_label_new (_(" Pattern"));
      gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
      gtk_box_pack_start(GTK_BOX(hbox), label,FALSE, FALSE, 0);
      adj = (GtkAdjustment *)gtk_adjustment_new 
	((gfloat)tmp_mascot.duet_ptn[i_ptn], 1, MAX_ANIME_PATTERN-1,
	 1.0, 1.0, 0.0);
      gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
			  GTK_SIGNAL_FUNC (cc_get_adj),
			  &tmp_mascot.duet_ptn[i_ptn]);
      spinner =  gtk_spin_button_new (adj, 0, 0);
      gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), FALSE);
      gtk_box_pack_start(GTK_BOX(hbox), spinner,FALSE, FALSE, 0);

      hbox = gtk_hbox_new(FALSE,0);
      gtk_table_attach_defaults(GTK_TABLE(table2),
		       hbox, 0, 1, 1, 2);
      label = gtk_label_new (_("Message"));
      gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
      gtk_box_pack_start(GTK_BOX(hbox), label,FALSE, FALSE, 0);
      entry = gtk_entry_new ();
      if(tmp_mascot.duet_word[i_ptn]){
	gtk_entry_set_text(GTK_ENTRY(entry),tmp_mascot.duet_word[i_ptn]);
      }
      gtk_entry_set_editable(GTK_ENTRY(entry),TRUE);
      gtk_box_pack_start(GTK_BOX(hbox), entry,TRUE, TRUE, 0);
      gtk_signal_connect (GTK_OBJECT(entry),
			  "changed",
			  GTK_SIGNAL_FUNC(cc_get_entry),
			  &tmp_mascot.duet_word[i_ptn]);
      label = gtk_label_new (_(" Delay"));
      gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
      gtk_box_pack_start(GTK_BOX(hbox), label,FALSE, FALSE, 0);
      adj = (GtkAdjustment *)gtk_adjustment_new 
	((gfloat)tmp_mascot.duet_delay[i_ptn], 0, 99,
	 1.0, 1.0, 1.0);
      gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
			  GTK_SIGNAL_FUNC (cc_get_adj),
			  &tmp_mascot.duet_delay[i_ptn]);
      spinner =  gtk_spin_button_new (adj, 0, 0);
      gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), FALSE);
      gtk_box_pack_start(GTK_BOX(hbox), spinner,FALSE, FALSE, 0);
    

      hbox = gtk_hbox_new(FALSE,0);
      gtk_table_attach(GTK_TABLE(pattern_table[i_ptn]),
		       hbox, 0, 3, 2, 3,
		       GTK_FILL,GTK_SHRINK,0,0);
      gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
      label = gtk_label_new (_("Message"));
      gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
      gtk_box_pack_start(GTK_BOX(hbox), label,FALSE, FALSE, 0);
      entry = gtk_entry_new ();
      if(tmp_mascot.click_word[i_ptn]){
	gtk_entry_set_text(GTK_ENTRY(entry),tmp_mascot.click_word[i_ptn]);
      }
      gtk_entry_set_editable(GTK_ENTRY(entry),TRUE);
      gtk_box_pack_start(GTK_BOX(hbox), entry,TRUE, TRUE, 0);
      gtk_signal_connect (GTK_OBJECT(entry),
			  "changed",
			  GTK_SIGNAL_FUNC(cc_get_entry),
			  &tmp_mascot.click_word[i_ptn]);
    
      table2 = gtk_table_new (5, 1, FALSE);
      gtk_container_set_border_width (GTK_CONTAINER (table2), 5);
      gtk_table_set_col_spacing (GTK_TABLE(table2), 0, 0);
      gtk_table_attach(GTK_TABLE(pattern_table[i_ptn]),
		       table2, 0, 3, 3, 4,
		       GTK_FILL,GTK_SHRINK,0,0);

      label = gtk_label_new (_("Sound File"));
      gtk_table_attach(GTK_TABLE(table2),label, 0, 1, 0, 1,
		       GTK_SHRINK,GTK_SHRINK,0,0);
      gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
      click_sound_entry[i_ptn] = gtk_entry_new ();
      if(tmp_mascot.click_sound[i_ptn]){
	gtk_entry_set_text(GTK_ENTRY(click_sound_entry[i_ptn]),
			   tmp_mascot.click_sound[i_ptn]);
      }
      gtk_entry_set_editable(GTK_ENTRY(click_sound_entry[i_ptn]),FALSE);
      gtk_table_attach_defaults(GTK_TABLE(table2),
				click_sound_entry[i_ptn], 1, 2, 0, 1);
      button = gtk_button_new_with_label("...");
      gtk_table_attach(GTK_TABLE(table2),button, 2, 3, 0, 1,
		       GTK_SHRINK,GTK_SHRINK,0,0);
      gtk_signal_connect(GTK_OBJECT(button),"pressed",
			 GTK_SIGNAL_FUNC(create_change_click_sound_dialog), 
			 (gpointer)(i_ptn));
      button = gtk_button_new_with_label(_("Clear"));
      gtk_table_attach(GTK_TABLE(table2),button, 3, 4, 0, 1,
		       GTK_SHRINK,GTK_SHRINK,0,0);
      gtk_signal_connect (GTK_OBJECT(button),
			  "pressed",
			  GTK_SIGNAL_FUNC(clear_click_sound),
			  (gpointer)i_ptn);
      button = gtk_button_new_with_label(_("Test"));
      gtk_table_attach(GTK_TABLE(table2),button, 4, 5, 0, 1,
		       GTK_SHRINK,GTK_SHRINK,0,0);
      gtk_signal_connect (GTK_OBJECT(button),
			  "pressed",
			  GTK_SIGNAL_FUNC(test_click_sound),
			  (gpointer)i_ptn);
  }

  
  label = gtk_label_new (bufferl);
  gtk_notebook_insert_page (GTK_NOTEBOOK (ptn_note), 
  			    pattern_table[i_ptn], label, i_ptn);
  
  gtk_widget_show_all(ptn_note);
  
}

// ˥塼ѥƥ꡼ꥹ
void make_cat_list(GtkWidget *cat_note, int i_cat)
{
  GtkWidget *label;
  GtkWidget *button;
  GtkWidget *entry;
  GtkWidget *arrow;
  GtkWidget *hbox;
  gchar bufferl[32];


  if(flag_make_cat_list[i_cat]) {
    //gtk_widget_destroy(GTK_WIDGET(cat_table[i_cat]));
    gtk_notebook_remove_page (GTK_NOTEBOOK (cat_note), i_cat);
    gtk_widget_queue_draw(GTK_WIDGET(cat_note));
    flag_make_tgt_list[i_cat]=FALSE;
  }
  else flag_make_cat_list[i_cat]=TRUE;


  sprintf(bufferl, "C.%02d", i_cat);
  
  cat_table[i_cat] = gtk_table_new (4, 4, FALSE);


  // ƥ꡼̾
  {
      if(i_cat!=0){
	arrow= gtk_arrow_new(GTK_ARROW_LEFT,GTK_SHADOW_IN);
	button = gtk_button_new();
	gtk_container_add (GTK_CONTAINER (button), arrow);
	gtk_table_attach(GTK_TABLE(cat_table[i_cat]), button,
			 0, 1, 0, 1,
			 GTK_SHRINK,GTK_SHRINK,0,0);
	gtk_signal_connect (GTK_OBJECT(button),
			    "pressed",
			    GTK_SIGNAL_FUNC(mc_up_cat),
			    (gpointer)i_cat);
      }

      hbox = gtk_hbox_new(FALSE,5);
      gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
      gtk_table_attach(GTK_TABLE(cat_table[i_cat]), hbox, 1, 3, 0, 1,
		       GTK_FILL,GTK_SHRINK,0,0);

      label = gtk_label_new (_("Category"));
      gtk_box_pack_start(GTK_BOX(hbox), label,FALSE, FALSE, 0);
      gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
      entry = gtk_entry_new ();
      gtk_box_pack_start(GTK_BOX(hbox), entry,FALSE, FALSE, 0);
      if(tmp_mascot.menu_cat[i_cat]){
	gtk_entry_set_text(GTK_ENTRY(entry),tmp_mascot.menu_cat[i_cat]);
      }
      gtk_entry_set_editable(GTK_ENTRY(entry),TRUE);
      gtk_signal_connect (GTK_OBJECT(entry),
      			  "changed",
			  GTK_SIGNAL_FUNC(cc_get_entry),
			  &tmp_mascot.menu_cat[i_cat]);

      if(i_cat!=tmp_mascot.menu_cat_max-1){
	arrow= gtk_arrow_new(GTK_ARROW_RIGHT,GTK_SHADOW_IN);
	button = gtk_button_new();
	gtk_container_add (GTK_CONTAINER (button), arrow);
	gtk_table_attach(GTK_TABLE(cat_table[i_cat]), button,
			 3, 4, 0, 1,
			 GTK_SHRINK,GTK_SHRINK,0,0);
	gtk_signal_connect (GTK_OBJECT(button),
			    "pressed",
			    GTK_SIGNAL_FUNC(mc_down_cat),
			    (gpointer)i_cat);
      }
    
    
  }

  cat_scrwin[i_cat] = gtk_scrolled_window_new (NULL, NULL);
  gtk_table_attach_defaults (GTK_TABLE(cat_table[i_cat]),
			     cat_scrwin[i_cat], 0, 4, 1, 2);
  gtk_container_set_border_width (GTK_CONTAINER (cat_scrwin[i_cat]), 5);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW(cat_scrwin[i_cat]),
				  GTK_POLICY_NEVER,
				  GTK_POLICY_ALWAYS);
  
  make_tgt_list(i_cat);
	  

  hbox = gtk_hbox_new(FALSE,5);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
  gtk_table_attach(GTK_TABLE(cat_table[i_cat]), hbox, 0, 4, 2, 3,
		   GTK_SHRINK,GTK_SHRINK,0,0);
  button = gtk_button_new_with_label(_("Append Mascot"));
  gtk_box_pack_start(GTK_BOX(hbox), button,FALSE, FALSE, 0);
  gtk_signal_connect(GTK_OBJECT(button),"pressed",
  		     GTK_SIGNAL_FUNC(create_add_tgt_dialog),
  		     (gpointer)i_cat);
	  
  button = gtk_button_new_with_label(_("Delete Mascot"));
  gtk_box_pack_start(GTK_BOX(hbox), button,FALSE, FALSE, 0);
  gtk_signal_connect(GTK_OBJECT(button),"pressed",
  		     GTK_SIGNAL_FUNC(create_del_tgt_dialog),
  		     (gpointer)i_cat);
  

  label = gtk_label_new (bufferl);
  gtk_notebook_insert_page (GTK_NOTEBOOK (cat_note), 
			    cat_table[i_cat], label, i_cat);
  gtk_widget_show_all(cat_note);
  
  while (g_main_iteration(FALSE));
  gdk_flush();
  
}


// ѥʤե졼ꥹ
void make_frame_list(int i_ptn)
{
  int i_frm;
  char no_tmp[3];
  GtkWidget *label;
  GtkWidget *button;
  GtkAdjustment *adj;
  GtkWidget *spinner;
  
  
  if(flag_make_frame_list[i_ptn])  gtk_widget_destroy(frame_table[i_ptn]);
  else flag_make_frame_list[i_ptn]=TRUE;

  frame_table[i_ptn] = gtk_table_new (7, MAX_ANIME_FRAME+3, FALSE);
  gtk_container_set_border_width (GTK_CONTAINER (frame_table[i_ptn]), 5);
  
  //gtk_table_set_row_spacings (GTK_TABLE (pixmap_table), 1);
  //gtk_table_set_col_spacings (GTK_TABLE (pixmap_table), 1);
  gtk_scrolled_window_add_with_viewport
    (GTK_SCROLLED_WINDOW (ptn_scrwin[i_ptn]), frame_table[i_ptn]);
  
  label = gtk_label_new (_("No."));
  gtk_table_attach(GTK_TABLE(frame_table[i_ptn]), label, 0, 1, 0, 1,
		   GTK_FILL,GTK_SHRINK,0,0);
  gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0);
	 
  label = gtk_label_new (_("Image"));
  gtk_table_attach(GTK_TABLE(frame_table[i_ptn]), label, 1, 2, 0, 1,
		   GTK_FILL,GTK_SHRINK,0,0);
  gtk_misc_set_alignment (GTK_MISC (label), 0.5, 0);
  
  label = gtk_label_new (_("Min"));
  gtk_table_attach(GTK_TABLE(frame_table[i_ptn]), label, 2, 3, 0, 1,
		   GTK_FILL,GTK_SHRINK,0,0);
  gtk_misc_set_alignment (GTK_MISC (label), 0.5, 0);
  
  label = gtk_label_new (_("Max"));
  gtk_table_attach(GTK_TABLE(frame_table[i_ptn]), label, 3, 4, 0, 1,
			     GTK_FILL,GTK_SHRINK,0,0);
  gtk_misc_set_alignment (GTK_MISC (label), 0.5, 0);
  
  label = gtk_label_new (_("Block Loop"));
  gtk_table_attach(GTK_TABLE(frame_table[i_ptn]), label, 4, 7, 0, 1,
		   GTK_FILL,GTK_SHRINK,0,0);
  gtk_misc_set_alignment (GTK_MISC (label), 0.5, 0.0);
  
  label = gtk_label_new (_("Next"));
  gtk_table_attach(GTK_TABLE(frame_table[i_ptn]), label, 4, 5, 1, 2,
		   GTK_FILL,GTK_SHRINK,0,0);
  gtk_misc_set_alignment (GTK_MISC (label), 0.5, 1.0);
  
  label = gtk_label_new (_("Min"));
  gtk_table_attach(GTK_TABLE(frame_table[i_ptn]), label, 5, 6, 1, 2,
		   GTK_FILL,GTK_SHRINK,0,0);
  gtk_misc_set_alignment (GTK_MISC (label), 0.5, 1.0);
  
  label = gtk_label_new (_("Max"));
  gtk_table_attach(GTK_TABLE(frame_table[i_ptn]), label, 6, 7, 1, 2,
		   GTK_FILL,GTK_SHRINK,0,0);
  gtk_misc_set_alignment (GTK_MISC (label), 0.5, 1.0);
  
  i_frm=0;
  for(i_frm=0;i_frm<tmp_mascot.frame_num[i_ptn];i_frm++){
    sprintf(no_tmp,"%02d",i_frm);
    button = gtk_button_new_with_label(no_tmp);
    gtk_table_attach (GTK_TABLE(frame_table[i_ptn]),
		      button, 0, 1, i_frm+2, i_frm+3,
		      GTK_FILL,GTK_SHRINK,0,2);
    gtk_signal_connect(GTK_OBJECT(button),"pressed",
		       GTK_SIGNAL_FUNC(TestPut2), 
		       (gpointer)&tmp_mascot.frame_pix[i_ptn][i_frm]);

    // Image
    adj = (GtkAdjustment *)gtk_adjustment_new 
      ((gfloat)tmp_mascot.frame_pix[i_ptn][i_frm], 0,
       (gfloat)tmp_mascot.nPixmap-1, 1.0, 1.0, 0.0);
    gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
			GTK_SIGNAL_FUNC (cc_get_adj),
			&tmp_mascot.frame_pix[i_ptn][i_frm]);
    spinner =  gtk_spin_button_new (adj, 0, 0);
    gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), FALSE);
    gtk_entry_set_editable(GTK_ENTRY(&GTK_SPIN_BUTTON(spinner)->entry),
			   FALSE);
    gtk_table_attach(GTK_TABLE(frame_table[i_ptn]), spinner,
		     1, 2, i_frm+2, i_frm+3,
		     GTK_FILL,GTK_SHRINK,0,0);


    // Min
    adj = (GtkAdjustment *)gtk_adjustment_new 
      ((gfloat)tmp_mascot.frame_min[i_ptn][i_frm], 1,999, 1.0, 1.0, 0.0);
    gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
			GTK_SIGNAL_FUNC (cc_get_adj),
			&tmp_mascot.frame_min[i_ptn][i_frm]);
    spinner =  gtk_spin_button_new (adj, 0, 0);
    gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), FALSE);
    gtk_entry_set_editable(GTK_ENTRY(&GTK_SPIN_BUTTON(spinner)->entry),
			   FALSE);
    gtk_table_attach(GTK_TABLE(frame_table[i_ptn]), spinner,
		     2, 3, i_frm+2, i_frm+3,
		     GTK_FILL,GTK_SHRINK,0,0);

  
    // Max
    adj = (GtkAdjustment *)gtk_adjustment_new 
      ((gfloat)tmp_mascot.frame_max[i_ptn][i_frm], 1,999, 1.0, 1.0, 0.0);
    gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
			GTK_SIGNAL_FUNC (cc_get_adj),
			&tmp_mascot.frame_max[i_ptn][i_frm]);
    spinner =  gtk_spin_button_new (adj, 0, 0);
    gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), FALSE);
    gtk_entry_set_editable(GTK_ENTRY(&GTK_SPIN_BUTTON(spinner)->entry),
			   FALSE);
    gtk_table_attach(GTK_TABLE(frame_table[i_ptn]), spinner,
		     3, 4, i_frm+2, i_frm+3,
		     GTK_FILL,GTK_SHRINK,0,0);

  
    // Block Next
    adj = (GtkAdjustment *)gtk_adjustment_new 
      ((gfloat)tmp_mascot.frame_loop[i_ptn][i_frm].next, -1,
       tmp_mascot.frame_num[i_ptn]-1, 1.0, 1.0, 0.0);
    gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
			GTK_SIGNAL_FUNC (cc_get_adj),
			&tmp_mascot.frame_loop[i_ptn][i_frm].next);
    spinner =  gtk_spin_button_new (adj, 0, 0);
    gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), FALSE);
    gtk_entry_set_editable(GTK_ENTRY(&GTK_SPIN_BUTTON(spinner)->entry),
			   FALSE);
    gtk_table_attach(GTK_TABLE(frame_table[i_ptn]), spinner,
		     4, 5, i_frm+2, i_frm+3,
  		     GTK_FILL,GTK_SHRINK,0,0);

    // Block Min
    adj = (GtkAdjustment *)gtk_adjustment_new 
      ((gfloat)tmp_mascot.frame_loop[i_ptn][i_frm].min, 0,999, 1.0, 1.0, 0.0);
    gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
			GTK_SIGNAL_FUNC (cc_get_adj),
			&tmp_mascot.frame_loop[i_ptn][i_frm].min);
    spinner =  gtk_spin_button_new (adj, 0, 0);
    gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), FALSE);
    gtk_entry_set_editable(GTK_ENTRY(&GTK_SPIN_BUTTON(spinner)->entry),
			   FALSE);
    gtk_table_attach(GTK_TABLE(frame_table[i_ptn]), spinner,
		     5, 6, i_frm+2, i_frm+3,
		     GTK_FILL,GTK_SHRINK,0,0);
  
    // Block Max
    adj = (GtkAdjustment *)gtk_adjustment_new 
      ((gfloat)tmp_mascot.frame_loop[i_ptn][i_frm].max, 0,999, 1.0, 1.0, 0.0);
    gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
			GTK_SIGNAL_FUNC (cc_get_adj),
			&tmp_mascot.frame_loop[i_ptn][i_frm].max);
    spinner =  gtk_spin_button_new (adj, 0, 0);
    gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), FALSE);
    gtk_entry_set_editable(GTK_ENTRY(&GTK_SPIN_BUTTON(spinner)->entry),
			   FALSE);
    gtk_table_attach(GTK_TABLE(frame_table[i_ptn]), spinner,
		     6, 7, i_frm+2, i_frm+3,
		     GTK_FILL,GTK_SHRINK,0,0);
  
  }
  label=gtk_label_new("");
  gtk_table_attach_defaults(GTK_TABLE(frame_table[i_ptn]), label, 
			    0, 7, MAX_ANIME_FRAME+2, MAX_ANIME_FRAME+3);


  gtk_widget_show_all(frame_table[i_ptn]);
}


// ƥ꡼⥿åȥꥹ
void make_tgt_list(int i_cat)
{
  int i_tgt;
  char no_tmp[3];
  GtkWidget *label;
  GtkWidget *button;
  GtkWidget *entry;
  GtkWidget *arrow;

  if(flag_make_tgt_list[i_cat])  gtk_widget_destroy(tgt_table[i_cat]);
  else flag_make_tgt_list[i_cat]=TRUE;

  tgt_table[i_cat] = gtk_table_new (6, MAX_MENU_CATEGORY+2, FALSE);
  gtk_container_set_border_width (GTK_CONTAINER (tgt_table[i_cat]), 5);
  
  gtk_scrolled_window_add_with_viewport
    (GTK_SCROLLED_WINDOW (cat_scrwin[i_cat]), tgt_table[i_cat]);
  
  label = gtk_label_new (_("No."));
  gtk_table_attach(GTK_TABLE(tgt_table[i_cat]), label, 1, 2, 0, 1,
		   GTK_FILL,GTK_SHRINK,0,0);
  gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0);
	 
  label = gtk_label_new (_("Name"));
  gtk_table_attach(GTK_TABLE(tgt_table[i_cat]), label, 2, 3, 0, 1,
		   GTK_FILL,GTK_SHRINK,0,0);
  gtk_misc_set_alignment (GTK_MISC (label), 0.5, 0);
  
  label = gtk_label_new (_("File"));
  gtk_table_attach(GTK_TABLE(tgt_table[i_cat]), label, 3, 5, 0, 1,
		   GTK_FILL,GTK_SHRINK,0,0);
  gtk_misc_set_alignment (GTK_MISC (label), 0.5, 0);
  
  
  for(i_tgt=0;i_tgt<tmp_mascot.menu_tgt_max[i_cat];i_tgt++){
    
    if(i_tgt!=0){

      arrow= gtk_arrow_new(GTK_ARROW_UP,GTK_SHADOW_IN);
      button = gtk_button_new();
      gtk_container_add (GTK_CONTAINER (button), arrow);
      gtk_table_attach(GTK_TABLE(tgt_table[i_cat]), button,
		       0, 1, i_tgt+1, i_tgt+2,
		       GTK_SHRINK,GTK_SHRINK,0,0);
      gtk_signal_connect(GTK_OBJECT(button),"pressed",
    		       GTK_SIGNAL_FUNC(mc_up_tgt), 
    		       (gpointer)(i_cat*MAX_MENU_TARGET+i_tgt));
    }

    sprintf(no_tmp,"%02d",i_tgt);
    label = gtk_label_new (no_tmp);
    gtk_table_attach (GTK_TABLE(tgt_table[i_cat]),
		      label, 1, 2, i_tgt+1, i_tgt+2,
		      GTK_FILL,GTK_SHRINK,0,2);

    // Name
    entry = gtk_entry_new ();
    if(tmp_mascot.menu_tgt_name[i_cat][i_tgt]){
      gtk_entry_set_text(GTK_ENTRY(entry),tmp_mascot.menu_tgt_name[i_cat][i_tgt]);
    }
    gtk_entry_set_editable(GTK_ENTRY(entry),FALSE);
    gtk_table_attach(GTK_TABLE(tgt_table[i_cat]), entry,
		     2, 3, i_tgt+1, i_tgt+2,
		     GTK_FILL,GTK_SHRINK,0,0);


    // File
    entry = gtk_entry_new ();
    if(tmp_mascot.menu_tgt[i_cat][i_tgt]){
      gtk_entry_set_text(GTK_ENTRY(entry),tmp_mascot.menu_tgt[i_cat][i_tgt]);
    }
    gtk_entry_set_editable(GTK_ENTRY(entry),FALSE);
    gtk_table_attach(GTK_TABLE(tgt_table[i_cat]), entry,
		     3, 4, i_tgt+1, i_tgt+2,
		     GTK_FILL,GTK_SHRINK,0,0);

    button = gtk_button_new_with_label("...");
    gtk_table_attach(GTK_TABLE(tgt_table[i_cat]), button,
		     4, 5, i_tgt+1, i_tgt+2,
		     GTK_SHRINK,GTK_SHRINK,0,0);
    gtk_signal_connect(GTK_OBJECT(button),"pressed",
    		       GTK_SIGNAL_FUNC(create_change_tgt_dialog), 
    		       (gpointer)(i_cat*MAX_MENU_TARGET+i_tgt));

    if(i_tgt!=tmp_mascot.menu_tgt_max[i_cat]-1){
       arrow= gtk_arrow_new(GTK_ARROW_DOWN,GTK_SHADOW_IN);
       button = gtk_button_new();
       gtk_container_add (GTK_CONTAINER (button), arrow);
       gtk_table_attach(GTK_TABLE(tgt_table[i_cat]), button,
			5, 6, i_tgt+1, i_tgt+2,
			GTK_SHRINK,GTK_SHRINK,0,0);
       gtk_signal_connect(GTK_OBJECT(button),"pressed",
			  GTK_SIGNAL_FUNC(mc_down_tgt), 
			  (gpointer)(i_cat*MAX_MENU_TARGET+i_tgt));
    }

  }

  label=gtk_label_new("");
  gtk_table_attach_defaults(GTK_TABLE(tgt_table[i_cat]), label, 
			    0, 7, MAX_ANIME_FRAME+2, MAX_ANIME_FRAME+3);


  gtk_widget_show_all(tgt_table[i_cat]);
}


  


// ݥåץåץ˥塼
GtkWidget * make_popup_menu(void)
{
  GtkWidget *popup_menu; 
  GtkWidget *open_menu; 
  GtkWidget *save_menu; 
  GtkWidget *new_menu; 
  GtkWidget *cat_menu; 
  GtkWidget *popup_button;
  GtkWidget *biff_check;
  GtkWidget *sig_check;
  GtkWidget *bar;


  popup_menu = gtk_menu_new();

  open_menu=make_open_menu();

  popup_button =gtk_menu_item_new_with_label (_("Open"));
  gtk_widget_show (popup_button);
  gtk_container_add (GTK_CONTAINER (popup_menu), popup_button);
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(popup_button),open_menu);

  save_menu=make_save_menu();

  popup_button =gtk_menu_item_new_with_label (_("Save"));
  gtk_widget_show (popup_button);
  gtk_container_add (GTK_CONTAINER (popup_menu), popup_button);
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(popup_button),save_menu);

  new_menu=make_new_menu();

  popup_button =gtk_menu_item_new_with_label (_("New"));
  gtk_widget_show (popup_button);
  gtk_container_add (GTK_CONTAINER (popup_menu), popup_button);
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(popup_button),new_menu);



  popup_button =gtk_menu_item_new_with_label (_("Config"));
  gtk_widget_show (popup_button);
  gtk_container_add (GTK_CONTAINER (popup_menu), popup_button);
  gtk_signal_connect (GTK_OBJECT (popup_button), "activate",
                      GTK_SIGNAL_FUNC (create_config_dialog),
                      NULL);

  bar =gtk_menu_item_new();
  gtk_widget_show (bar);
  gtk_container_add (GTK_CONTAINER (popup_menu), bar);

  biff_check =gtk_check_menu_item_new_with_label (_("Biff Check"));
  gtk_widget_show (biff_check);
  gtk_container_add (GTK_CONTAINER (popup_menu), biff_check);
  if(Mascot->mail.flag){
    gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(biff_check),TRUE);
  }
  else{
    gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(biff_check),FALSE);
  }
  gtk_signal_connect (GTK_OBJECT (biff_check), "toggled",
                      GTK_SIGNAL_FUNC (mail_flag_toggle),
                      NULL);

  bar =gtk_menu_item_new();
  gtk_widget_show (bar);
  gtk_container_add (GTK_CONTAINER (popup_menu), bar);

  sig_check =gtk_check_menu_item_new_with_label (_("Time Signal"));
  gtk_widget_show (sig_check);
  gtk_container_add (GTK_CONTAINER (popup_menu), sig_check);
  if(Mascot->signal.flag){
    gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(sig_check),TRUE);
  }
  else{
    gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(sig_check),FALSE);
  }
  gtk_signal_connect (GTK_OBJECT (sig_check), "toggled",
                      GTK_SIGNAL_FUNC (check_menu_get_toggle),
                      &Mascot->signal.flag);


  bar =gtk_menu_item_new();
  gtk_widget_show (bar);
  gtk_container_add (GTK_CONTAINER (popup_menu), bar);

  cat_menu=make_cat_menu();
  
  popup_button =gtk_menu_item_new_with_label (_("Mascot Launcher"));
  gtk_widget_show (popup_button);
  gtk_container_add (GTK_CONTAINER (popup_menu), popup_button);
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(popup_button),cat_menu);
  if(Mascot->menu_total==0){
    gtk_widget_set_state(popup_button, GTK_STATE_INSENSITIVE);
  }

  bar =gtk_menu_item_new();
  gtk_widget_show (bar);
  gtk_container_add (GTK_CONTAINER (popup_menu), bar);

  popup_button =gtk_menu_item_new_with_label (_("Exit"));
  gtk_widget_show (popup_button);
  gtk_container_add (GTK_CONTAINER (popup_menu), popup_button);
  gtk_signal_connect (GTK_OBJECT (popup_button), "activate",
                      GTK_SIGNAL_FUNC (gtk_main_quit),
                      NULL);


  return(popup_menu);
}

GtkWidget * make_open_menu(void)
{
  GtkWidget *popup_menu; 
  GtkWidget *popup_button;
  GtkWidget *bar;
  GtkWidget *launcher_menu; 
  GtkWidget *develop_menu; 
   
  popup_menu = gtk_menu_new();

  popup_button =gtk_menu_item_new_with_label (_("Open Mascot"));
  gtk_widget_show (popup_button);
  gtk_container_add (GTK_CONTAINER (popup_menu), popup_button);
  gtk_signal_connect (GTK_OBJECT (popup_button), "activate",
                      GTK_SIGNAL_FUNC (create_file_selection_dialog),
                      NULL);

  bar =gtk_menu_item_new();
  gtk_widget_show (bar);
  gtk_container_add (GTK_CONTAINER (popup_menu), bar);

  launcher_menu=make_open_launcher_menu();

  popup_button =gtk_menu_item_new_with_label (_("Launcher Menu"));
  gtk_widget_show (popup_button);
  gtk_container_add (GTK_CONTAINER (popup_menu), popup_button);
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(popup_button),launcher_menu);


  bar =gtk_menu_item_new();
  gtk_widget_show (bar);
  gtk_container_add (GTK_CONTAINER (popup_menu), bar);

  develop_menu=make_open_develop_menu();

  popup_button =gtk_menu_item_new_with_label (_("For Developper"));
  gtk_widget_show (popup_button);
  gtk_container_add (GTK_CONTAINER (popup_menu), popup_button);
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(popup_button),develop_menu);

  return(popup_menu);
}

GtkWidget * make_save_menu(void)
{
  GtkWidget *popup_menu; 
  GtkWidget *menu_menu; 
  GtkWidget *develop_menu; 
  GtkWidget *popup_button;
  GtkWidget *bar;

  popup_menu = gtk_menu_new();

  popup_button =gtk_menu_item_new_with_label (_("Save Mascot"));
  gtk_widget_show (popup_button);
  gtk_container_add (GTK_CONTAINER (popup_menu), popup_button);
  gtk_signal_connect (GTK_OBJECT (popup_button), "activate",
		      GTK_SIGNAL_FUNC (MenuSaveMascot),
		      NULL);

  popup_button =gtk_menu_item_new_with_label (_("Save Mascot As..."));
  gtk_widget_show (popup_button);
  gtk_container_add (GTK_CONTAINER (popup_menu), popup_button);
  gtk_signal_connect (GTK_OBJECT (popup_button), "activate",
		      GTK_SIGNAL_FUNC (create_save_mascot_dialog),
		      NULL);

  bar =gtk_menu_item_new();
  gtk_widget_show (bar);
  gtk_container_add (GTK_CONTAINER (popup_menu), bar);

  menu_menu=make_menu_menu();
  
  popup_button =gtk_menu_item_new_with_label (_("Launcher Menu"));
  gtk_widget_show (popup_button);
  gtk_container_add (GTK_CONTAINER (popup_menu), popup_button);
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(popup_button),menu_menu);


  bar =gtk_menu_item_new();
  gtk_widget_show (bar);
  gtk_container_add (GTK_CONTAINER (popup_menu), bar);

  popup_button =gtk_menu_item_new_with_label (_("Save Resource"));
  gtk_widget_show (popup_button);
  gtk_container_add (GTK_CONTAINER (popup_menu), popup_button);
  gtk_signal_connect (GTK_OBJECT (popup_button), "activate",
		      GTK_SIGNAL_FUNC (create_save_rc_dialog),
		      NULL);

  bar =gtk_menu_item_new();
  gtk_widget_show (bar);
  gtk_container_add (GTK_CONTAINER (popup_menu), bar);

  develop_menu=make_develop_menu();
  
  popup_button =gtk_menu_item_new_with_label (_("For Developper"));
  gtk_widget_show (popup_button);
  gtk_container_add (GTK_CONTAINER (popup_menu), popup_button);
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(popup_button),develop_menu);

  bar =gtk_menu_item_new();
  gtk_widget_show (bar);
  gtk_container_add (GTK_CONTAINER (popup_menu), bar);

  popup_button =gtk_menu_item_new_with_label (_("Save All"));
  gtk_widget_show (popup_button);
  gtk_container_add (GTK_CONTAINER (popup_menu), popup_button);
  gtk_signal_connect (GTK_OBJECT (popup_button), "activate",
		      GTK_SIGNAL_FUNC (MenuSaveAll),
		      NULL);

  return(popup_menu);
}


GtkWidget * make_new_menu(void)
{
  GtkWidget *popup_menu; 
  GtkWidget *popup_button;
  GtkWidget *bar;
   
  popup_menu = gtk_menu_new();

  popup_button =gtk_menu_item_new_with_label (_("Create New Mascot"));
  gtk_widget_show (popup_button);
  gtk_container_add (GTK_CONTAINER (popup_menu), popup_button);
  gtk_signal_connect (GTK_OBJECT (popup_button), "activate",
                      GTK_SIGNAL_FUNC (create_new_mascot_dialog),
                      NULL);

  bar =gtk_menu_item_new();
  gtk_widget_show (bar);
  gtk_container_add (GTK_CONTAINER (popup_menu), bar);

  popup_button =gtk_menu_item_new_with_label (_("Create New Launcher Menu"));
  gtk_widget_show (popup_button);
  gtk_container_add (GTK_CONTAINER (popup_menu), popup_button);
  gtk_signal_connect (GTK_OBJECT (popup_button), "activate",
                      GTK_SIGNAL_FUNC (create_new_menu_selection_dialog),
                      NULL);

  return(popup_menu);
}


GtkWidget * make_menu_menu(void)
{
  GtkWidget *popup_menu; 
  GtkWidget *popup_button;
   
  popup_menu = gtk_menu_new();

  popup_button =gtk_menu_item_new_with_label (_("Save"));
  gtk_widget_show (popup_button);
  gtk_container_add (GTK_CONTAINER (popup_menu), popup_button);
  gtk_signal_connect (GTK_OBJECT (popup_button), "activate",
		      GTK_SIGNAL_FUNC (create_save_menu_dialog),
		      NULL);
  if(Mascot->menu_total==0){
    gtk_widget_set_state(popup_button, GTK_STATE_INSENSITIVE);
  }

  popup_button =gtk_menu_item_new_with_label (_("Set as Default"));
  gtk_widget_show (popup_button);
  gtk_container_add (GTK_CONTAINER (popup_menu), popup_button);
  gtk_signal_connect (GTK_OBJECT (popup_button), "activate",
		      GTK_SIGNAL_FUNC (MenuSaveDefMenu),
		      NULL);
  if(Mascot->menu_total==0){
    gtk_widget_set_state(popup_button, GTK_STATE_INSENSITIVE);
  }

  popup_button =gtk_menu_item_new_with_label (_("Remove from Default"));
  gtk_widget_show (popup_button);
  gtk_container_add (GTK_CONTAINER (popup_menu), popup_button);
  gtk_signal_connect (GTK_OBJECT (popup_button), "activate",
		      GTK_SIGNAL_FUNC (MenuDelDefMenu),
		      NULL);

  return(popup_menu);
}


GtkWidget * make_open_launcher_menu(void)
{
  GtkWidget *popup_menu; 
  GtkWidget *popup_button;
   
  popup_menu = gtk_menu_new();

  popup_button =gtk_menu_item_new_with_label (_("File Select"));
  gtk_widget_show (popup_button);
  gtk_container_add (GTK_CONTAINER (popup_menu), popup_button);
  gtk_signal_connect (GTK_OBJECT (popup_button), "activate",
                      GTK_SIGNAL_FUNC (create_menu_selection_dialog),
                      NULL);

  popup_button =gtk_menu_item_new_with_label (_("Launcher"));
  gtk_widget_show (popup_button);
  gtk_container_add (GTK_CONTAINER (popup_menu), popup_button);
  gtk_signal_connect (GTK_OBJECT (popup_button), "activate",
                      GTK_SIGNAL_FUNC (create_smenu_dialog2),
                      NULL);

  return(popup_menu);
}


GtkWidget * make_open_develop_menu(void)
{
  GtkWidget *popup_menu; 
  GtkWidget *popup_button;
   
  popup_menu = gtk_menu_new();

  popup_button =gtk_menu_item_new_with_label (_("Convert from Nokkari-Chara"));
  gtk_widget_show (popup_button);
  gtk_container_add (GTK_CONTAINER (popup_menu), popup_button);
  gtk_signal_connect (GTK_OBJECT (popup_button), "activate",
                      GTK_SIGNAL_FUNC (create_nkr_selection_dialog),
                      NULL);

  return(popup_menu);
}


GtkWidget * make_develop_menu(void)
{
  GtkWidget *popup_menu; 
  GtkWidget *popup_button;
   
  popup_menu = gtk_menu_new();

  popup_button =gtk_menu_item_new_with_label (_("Save for Release"));
  gtk_widget_show (popup_button);
  gtk_container_add (GTK_CONTAINER (popup_menu), popup_button);
  gtk_signal_connect (GTK_OBJECT (popup_button), "activate",
                      GTK_SIGNAL_FUNC (create_save_release_mascot_dialog),
                      NULL);

  popup_button =gtk_menu_item_new_with_label (_("Convert to Nokkari-Chara"));
  gtk_widget_show (popup_button);
  gtk_container_add (GTK_CONTAINER (popup_menu), popup_button);
  gtk_signal_connect (GTK_OBJECT (popup_button), "activate",
                      GTK_SIGNAL_FUNC (create_save_nokkari_dialog),
                      NULL);

  return(popup_menu);
}



GtkWidget * make_cat_menu(void)
{
  GtkWidget *popup_menu; 
  GtkWidget *popup_button;
  GtkWidget *bar;
  GtkWidget *tgt_menu; 
  int i_cat;
    

  popup_menu = gtk_menu_new();

  popup_button =gtk_menu_item_new_with_label (_("Random Change"));
  gtk_widget_show (popup_button);
  gtk_container_add (GTK_CONTAINER (popup_menu), popup_button);
  gtk_signal_connect (GTK_OBJECT (popup_button), "activate",
		      GTK_SIGNAL_FUNC (AllRandomChangeMascotMenu),
		      NULL);

  bar =gtk_menu_item_new();
  gtk_widget_show (bar);
  gtk_container_add (GTK_CONTAINER (popup_menu), bar);

  for(i_cat=0;i_cat<Mascot->menu_cat_max;i_cat++){
    tgt_menu=make_tgt_menu(i_cat);

    popup_button =gtk_menu_item_new_with_label (Mascot->menu_cat[i_cat]);
    gtk_widget_show (popup_button);
    gtk_container_add (GTK_CONTAINER (popup_menu), popup_button);
    gtk_menu_item_set_submenu(GTK_MENU_ITEM(popup_button),tgt_menu);
    //    gtk_signal_connect (GTK_OBJECT (popup_button), "activate",
    //			GTK_SIGNAL_FUNC (MenuSaveMascot),
    //			NULL);
  }

  return(popup_menu);
}

GtkWidget * make_tgt_menu(int i_cat)
{
  GtkWidget *popup_menu; 
  GtkWidget *popup_button;
  GtkWidget *bar;
  int i_tgt;
    

  popup_menu = gtk_menu_new();

  popup_button =gtk_menu_item_new_with_label (_("Random Change"));
  gtk_widget_show (popup_button);
  gtk_container_add (GTK_CONTAINER (popup_menu), popup_button);
  gtk_signal_connect (GTK_OBJECT (popup_button), "activate",
		      GTK_SIGNAL_FUNC (CatRandomChangeMascotMenu),
		      (gpointer)i_cat);


  bar =gtk_menu_item_new();
  gtk_widget_show (bar);
  gtk_container_add (GTK_CONTAINER (popup_menu), bar);

  for(i_tgt=0;i_tgt<Mascot->menu_tgt_max[i_cat];i_tgt++){
    popup_button 
      =gtk_menu_item_new_with_label(Mascot->menu_tgt_name[i_cat][i_tgt]);
    gtk_widget_show (popup_button);
    gtk_container_add (GTK_CONTAINER (popup_menu), popup_button);
    gtk_signal_connect (GTK_OBJECT (popup_button), "activate",
    			GTK_SIGNAL_FUNC (ChangeMascotMenu),
    			Mascot->menu_tgt[i_cat][i_tgt]);
  }

  return(popup_menu);
}

GtkWidget * make_clock(void){
  GtkWidget *clock_vbox;
  GtkWidget *clock_drawing_area;

  clock_main = gtk_window_new(GTK_WINDOW_POPUP);
  gtk_widget_set_app_paintable(clock_main, TRUE);
  gtk_widget_set_events(GTK_WIDGET (clock_main), 
			GDK_FOCUS_CHANGE_MASK | 
			GDK_BUTTON_MOTION_MASK | 
			GDK_BUTTON_RELEASE_MASK | 
			GDK_BUTTON_PRESS_MASK | 
			GDK_EXPOSURE_MASK);
  gtk_widget_realize(clock_main);
  gdk_window_set_decorations(clock_main->window, 0);
  gdk_window_set_override_redirect(clock_main->window,TRUE);

  clock_vbox = gtk_hbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER (clock_main), clock_vbox);
  gtk_widget_show(clock_vbox);

  clock_drawing_area = gtk_drawing_area_new();
  gtk_drawing_area_size (GTK_DRAWING_AREA(clock_drawing_area), 1, 1);
  gtk_box_pack_start(GTK_BOX(clock_vbox), clock_drawing_area,
		     TRUE, TRUE, 0);
  gtk_widget_show(clock_drawing_area);


  tooltip = gtk_tooltips_new();

  return(clock_drawing_area); 
}


//ޥåѹ
void ChangeMascot(){

  gdk_color_free(Mascot->colclk);
  gdk_color_free(Mascot->colclkbg);
  gdk_color_free(Mascot->colclkbd);
  gdk_color_free(Mascot->colclksd);
  gdk_color_free(Mascot->colbal);
  gdk_color_free(Mascot->colbalbd);
  gdk_color_free(Mascot->colbalbg);

  InitMascot(Mascot);
  ReadMascot(Mascot,FALSE);
  LoadPixmaps(win_main, Mascot->w_drawing, Mascot, Mascot->sprites);
  ReInitGC(Mascot);
  gtk_widget_unmap(balloon_main);
  flag_balloon=FALSE;
  gtk_widget_unmap(biff_pix);
  LoadBiffPixmap(biff_pix, Mascot);
  

  if(Mascot->clkmode!=CLOCK_NO) clock_update(Mascot, TRUE);
  if(Mascot->clkmode==CLOCK_PANEL){
    gtk_widget_map(clock_main);
  }
  else{
    gtk_widget_unmap(clock_main);
  }

  if(Mascot->move==MOVE_FIX){
    MoveMascot(Mascot,Mascot->xfix,Mascot->yfix);
  }
  else{
    MoveToFocus(Mascot,TRUE);
  }
}


// Τäꥭإޥåѹ
void NkrChangeMascot(){
  InitMascot(Mascot);

  NkrRead(Mascot);

  LoadPixmaps(win_main, Mascot->w_drawing, Mascot, Mascot->sprites);
  ReInitGC(Mascot);
  gtk_widget_unmap(balloon_main);
  flag_balloon=FALSE;
  gtk_widget_unmap(biff_pix);
  LoadBiffPixmap(biff_pix, Mascot);
  
  Mascot->yoff=Mascot->height - Mascot->yoff;

  gtk_widget_unmap(clock_main);
  MoveToFocus(Mascot,TRUE);
}



// եå
void create_cons_dialog(typMascot *mascot,
			gchar *target_file, 
			time_t user_mtime,
			time_t common_mtime,
			gboolean menu_flag)
{
  GtkWidget *cons_main;
  GtkWidget *cons_tbl;
  GtkWidget *cons_tbl2;
  GtkWidget *cons_text;
  GtkWidget *vbox;
  GtkWidget *label;
  GtkWidget *button;
  GtkWidget *check;
  gchar *tmp_text=NULL;
  gchar tmp_time[128];
  struct tm *tm_ptr;
  consType *cdata;


  // WinۤϽŤΤExpose٥򤹤٤ƽƤ
  while (g_main_iteration(FALSE));

  Mascot->flag_menu=TRUE;

  cdata=g_malloc0(sizeof(consType));

#ifdef USE_GTK2  
  cons_main = gtk_window_new(GTK_WINDOW_TOPLEVEL);
#else
  cons_main = gtk_window_new(GTK_WINDOW_DIALOG);
#endif
  gtk_window_set_title(GTK_WINDOW(cons_main), 
		       _("MaCoPiX : Consistency Check for Common & User Dir."));
  gtk_widget_realize(cons_main);
  gtk_signal_connect(GTK_OBJECT(cons_main),"destroy",
		     GTK_SIGNAL_FUNC(close_cons), 
		     GTK_WIDGET(cons_main));
  gtk_container_set_border_width (GTK_CONTAINER (cons_main), 5);
  
  // 6x3Υơ֥
  cons_tbl = gtk_table_new (6, 3, FALSE);
  gtk_container_add (GTK_CONTAINER (cons_main), cons_tbl);

  vbox = gtk_vbox_new(FALSE,5);
  gtk_table_attach(GTK_TABLE(cons_tbl), vbox, 0, 6, 0, 1,
		   GTK_SHRINK,GTK_SHRINK,0,0);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);


  label = gtk_label_new(_("WARNING"));
  gtk_misc_set_alignment (GTK_MISC (label), 0.5, 0.5);
  gtk_box_pack_start(GTK_BOX(vbox), label,FALSE, FALSE, 0);

  label = gtk_label_new("");
  gtk_misc_set_alignment (GTK_MISC (label), 0.5, 0.5);
  gtk_box_pack_start(GTK_BOX(vbox), label,FALSE, FALSE, 0);

  if(menu_flag){
    tmp_text=g_strconcat(_("Menu file : "), "\"", target_file, "\"", NULL);
  }
  else{
    tmp_text=g_strconcat(_("Mascot file : "), "\"", target_file, "\"", NULL);
  }
  label = gtk_label_new (tmp_text);
  gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
  gtk_box_pack_start(GTK_BOX(vbox), label,FALSE, FALSE, 0);
  label = gtk_label_new(_("  File in User Dir is older than the corresponded one in Common Dir."));
  gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
  gtk_box_pack_start(GTK_BOX(vbox), label,FALSE, FALSE, 0);

  // 2x2Υơ֥
  cons_tbl2 = gtk_table_new (2, 2, FALSE);
  gtk_box_pack_start(GTK_BOX(vbox), cons_tbl2,FALSE, FALSE, 0);


  label = gtk_label_new(_("     [User Dir]"));
  gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
  gtk_table_attach(GTK_TABLE(cons_tbl2), label, 0, 1, 0, 1,
		   GTK_SHRINK,GTK_SHRINK,0,0);
  tm_ptr=gmtime(&user_mtime);
  sprintf(tmp_time, _("     %4d/%02d/%02d %02d:%02d:%02d"),
	  tm_ptr->tm_year+1900,tm_ptr->tm_mon+1,tm_ptr->tm_mday,
	  tm_ptr->tm_hour,tm_ptr->tm_min,tm_ptr->tm_sec);
  label = gtk_label_new(tmp_time);
  gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
  gtk_table_attach(GTK_TABLE(cons_tbl2), label, 1, 2, 0, 1,
		   GTK_SHRINK,GTK_SHRINK,0,0);
  
  label = gtk_label_new(_("      [Common Dir]"));
  gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
  gtk_table_attach(GTK_TABLE(cons_tbl2), label, 0, 1, 1, 2,
		   GTK_SHRINK,GTK_SHRINK,0,0);
  tm_ptr=gmtime(&common_mtime);
  sprintf(tmp_time, _("     %4d/%02d/%02d %02d:%02d:%02d"),
	  tm_ptr->tm_year+1900,tm_ptr->tm_mon+1,tm_ptr->tm_mday,
	  tm_ptr->tm_hour,tm_ptr->tm_min,tm_ptr->tm_sec);
  label = gtk_label_new(tmp_time);
  gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
  gtk_table_attach(GTK_TABLE(cons_tbl2), label, 1, 2, 1, 2,
		   GTK_SHRINK,GTK_SHRINK,0,0);

  label = gtk_label_new(_("Do you want to overwite the newer file to User Dir?"));
  gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
  gtk_box_pack_start(GTK_BOX(vbox), label,FALSE, FALSE, 0);
  
  
  check = gtk_check_button_new_with_label(_("Don't ask this from the next time."));
  gtk_box_pack_start(GTK_BOX(vbox), check, FALSE, FALSE, 0);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),FALSE);

  cdata->dialog=GTK_WIDGET(cons_main);
  cdata->auto_check=GTK_WIDGET(check);
  cdata->filename=target_file;
  cdata->flag_ow=FALSE;
  cdata->flag_auto=FALSE;

  button=gtk_button_new_with_label(_("OK"));
  gtk_table_attach(GTK_TABLE(cons_tbl), button, 4, 5, 2, 3,
		   GTK_FILL,GTK_SHRINK,0,0);
  gtk_signal_connect(GTK_OBJECT(button),"pressed",
		     GTK_SIGNAL_FUNC(ow_cons), 
		     (gpointer)cdata);


  button=gtk_button_new_with_label(_("Cancel"));
  gtk_table_attach(GTK_TABLE(cons_tbl), button, 5, 6, 2, 3,
		   GTK_FILL,GTK_SHRINK,0,0);
  gtk_signal_connect(GTK_OBJECT(button),"pressed",
		     GTK_SIGNAL_FUNC(noow_cons), 
		     (gpointer)cdata);
  
  gtk_widget_show_all(cons_main);
  
  gtk_main();

  gdk_flush();

  mascot->flag_consow=cdata->flag_ow;
  if(cdata->flag_auto){
    if(mascot->flag_consow){
      mascot->cons_check_mode=CONS_AUTOOW;
    }
    else{
      mascot->cons_check_mode=CONS_IGNORE;
    }
  }
  else{
    mascot->cons_check_mode=CONS_MANUAL;
  }

  g_free(cdata);
}



// ư˥塼
void create_smenu_dialog(typMascot *mascot, gboolean flag_popup)
{
  GtkWidget *main;
  GtkWidget *table;
  GtkWidget *table1;
  GtkWidget *scrwin;
  GtkWidget *button;
  GtkWidget *vscrollbar;
  typScanMenu *smenu;
  gint i_menu;
  gboolean update_flag=TRUE;

  smenu=g_malloc0(sizeof(typScanMenu));
  selected_smenu=0;  

  ScanMenu(smenu,FALSE);

  if(smenu->max_menu==0){
#ifdef GTK_MSG
    popup_message(POPUP_TIMEOUT*5,
		  _("No Menu Files are installed!!\n"),
		  _("Please install one menu file at least\n"),
		  _(" or appoint a mascot file in option in order to start MaCoPiX!\n"),		  
		  NULL);
#else
    g_print("\n");
    g_print(_("No Menu Files are installed!!\n"));
    g_print(_("Please install one menu file at least\n"));
    g_print(_(" or appoint a mascot file in option in order to start MaCoPiX!\n"));
#endif
    exit(1);
  }

  // WinۤϽŤΤExpose٥򤹤٤ƽƤ
  while (g_main_iteration(FALSE));

  mascot->flag_menu=TRUE;

  
#ifdef USE_GTK2  
  main = gtk_window_new(GTK_WINDOW_TOPLEVEL);
#else
  main = gtk_window_new(GTK_WINDOW_DIALOG);
#endif
  if(flag_popup){
    gtk_window_set_title(GTK_WINDOW(main), 
			 _("MaCoPiX : Launcher Menu Selection"));
  }
  else{
    gtk_window_set_title(GTK_WINDOW(main), 
			 _("MaCoPiX : Start Menu Selection"));
  }
  gtk_widget_realize(main);
  gtk_signal_connect(GTK_OBJECT(main),"destroy",
		     GTK_SIGNAL_FUNC(close_smenu), 
  		     GTK_WIDGET(main));
  gtk_container_set_border_width (GTK_CONTAINER (main), 5);
  
  // 2x2Υơ֥


  table = gtk_table_new (4, 3, FALSE);
  gtk_table_set_col_spacings (GTK_TABLE(table), 100);
  gtk_table_set_row_spacings (GTK_TABLE(table), 7);
  gtk_container_add (GTK_CONTAINER (main), table);
  
  scrwin = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_usize (scrwin, SMENU_WIN_WIDTH, SMENU_WIN_HEIGHT);
  gtk_table_attach_defaults (GTK_TABLE(table), scrwin, 0, 4, 0, 1);
  gtk_container_set_border_width (GTK_CONTAINER (scrwin), 5);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW(scrwin),
				  GTK_POLICY_NEVER,
				  GTK_POLICY_ALWAYS);

  make_smenu_list(scrwin, smenu);


  button=gtk_button_new_with_label(_("OK"));
  gtk_table_attach(GTK_TABLE(table), button, 2, 3, 1, 2,
		   GTK_FILL,GTK_SHRINK,0,0);
  gtk_signal_connect(GTK_OBJECT(button),"pressed",
		     GTK_SIGNAL_FUNC(gtk_main_quit), 
		     NULL);
  button=gtk_button_new_with_label(_("Cancel"));
  gtk_table_attach(GTK_TABLE(table), button, 3, 4, 1, 2,
		   GTK_FILL,GTK_SHRINK,0,0);
  gtk_signal_connect(GTK_OBJECT(button),"pressed",
		     GTK_SIGNAL_FUNC(close_smenu), 
  		     GTK_WIDGET(main));
  
  gtk_widget_show_all(main);
  
  gtk_main();

  gdk_flush();

  if(selected_smenu==-1){
    if(!flag_popup) exit(1);
  }
  else{
    if(smenu->dir[selected_smenu]==SMENU_DIR_USER){
      mascot->menu_file=g_strconcat(g_get_home_dir(),"/",USER_DIR,
				    smenu->file[selected_smenu],NULL);
    }
    else if(smenu->dir[selected_smenu]==SMENU_DIR_COMMON){
      mascot->menu_file=g_strconcat(COMMON_DIR,
				    smenu->file[selected_smenu],NULL);
    }
    else{
      mascot->menu_file=g_strdup(smenu->file[selected_smenu]);
    }

    if(flag_popup){// Popup
      gtk_widget_destroy(PopupMenu);
      ReadMenu(mascot,0,NULL);
      PopupMenu=make_popup_menu();
    }
    gtk_widget_destroy(main);
  }
    
  g_free(smenu);
}


// ư˥塼ꥹ
void make_smenu_list(GtkWidget *scrwin, typScanMenu *smenu)
{
  int i_menu;
  gchar tmp[15];
  GtkWidget *check;
  GtkWidget *label;
  GtkWidget *button;
  GtkWidget *smenu_table;
  GSList *group = NULL;
  
  smenu_table = gtk_table_new (5, MAX_MENU_CATEGORY2+2, FALSE);
  gtk_container_set_border_width (GTK_CONTAINER (smenu_table), 5);

  gtk_scrolled_window_add_with_viewport
    (GTK_SCROLLED_WINDOW (scrwin), smenu_table);
 
  gtk_table_set_col_spacings (GTK_TABLE (smenu_table), 7);
  gtk_table_set_row_spacings (GTK_TABLE (smenu_table), 7);
 
  label = gtk_label_new (_("File"));
  gtk_table_attach(GTK_TABLE(smenu_table), label, 1, 2, 0, 1,
		   GTK_EXPAND,GTK_SHRINK,0,2);
  gtk_misc_set_alignment (GTK_MISC (label), 0.5, 0.5);

  label = gtk_label_new (_("Dir."));
  gtk_table_attach(GTK_TABLE(smenu_table), label, 2, 3, 0, 1,
		   GTK_EXPAND,GTK_SHRINK,0,2);
  gtk_misc_set_alignment (GTK_MISC (label), 0.5, 0.5);

  label = gtk_label_new (_("Entry"));
  gtk_table_attach(GTK_TABLE(smenu_table), label, 3, 4, 0, 1,
		   GTK_EXPAND,GTK_SHRINK,0,2);
  gtk_misc_set_alignment (GTK_MISC (label), 0.5, 0.5);

  label = gtk_label_new (_("Category"));
  gtk_table_attach(GTK_TABLE(smenu_table), label, 4, 5, 0, 1,
		   GTK_EXPAND|GTK_FILL,GTK_SHRINK,0,2);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  
  for(i_menu=0;i_menu<smenu->max_menu;i_menu++){
    check = gtk_radio_button_new(group);
    group=gtk_radio_button_group(GTK_RADIO_BUTTON(check));
    gtk_table_attach (GTK_TABLE(smenu_table),
		      check, 0, 1, i_menu+1, i_menu+2,
		      GTK_SHRINK,GTK_SHRINK,0,2);
    gtk_signal_connect (GTK_OBJECT (check), "toggled",
			GTK_SIGNAL_FUNC (check_menu_get_smenu),
			(gpointer *)i_menu);
    if(i_menu==0){
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),TRUE);
    }
    else{
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),FALSE);
    }

    label = gtk_label_new (smenu->file[i_menu]);
    gtk_table_attach(GTK_TABLE(smenu_table), label,
		     1, 2, i_menu+1, i_menu+2,
		     GTK_FILL,GTK_SHRINK,0,2);
    gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.0);
	   
    if(smenu->dir[i_menu]==SMENU_DIR_USER){
      label = gtk_label_new (_("User"));
    }
    else if(smenu->dir[i_menu]==SMENU_DIR_COMMON){
      label = gtk_label_new (_("Common"));
    }
    else{
      label = gtk_label_new (_("Unknown"));
    }
    gtk_table_attach(GTK_TABLE(smenu_table), label,
		     2, 3, i_menu+1, i_menu+2,
		     GTK_FILL,GTK_SHRINK,0,2);
    gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.0);


    if(smenu->flag_combine[i_menu]){
      sprintf(tmp, _("%4d categories"),smenu->num[i_menu]);
    }
    else{
      sprintf(tmp, _("%4d mascots"),smenu->num[i_menu]);
    }
    label = gtk_label_new (tmp);
    gtk_table_attach(GTK_TABLE(smenu_table), label,
		     3, 4, i_menu+1, i_menu+2,
		     GTK_FILL,GTK_SHRINK,0,2);
    gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.0);

    if(smenu->flag_combine[i_menu]){
      label = gtk_label_new (_("-- Combined Menu --"));
    }
    else{
      label = gtk_label_new (smenu->cat[i_menu]);
    }
    gtk_table_attach(GTK_TABLE(smenu_table), label,
		     4, 5, i_menu+1, i_menu+2,
		     GTK_FILL,GTK_SHRINK,0,2);
    gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.0);

    
  }
  label=gtk_label_new("");
  gtk_table_attach_defaults(GTK_TABLE(smenu_table), label, 
			    0, 3, MAX_MENU_CATEGORY2+1, MAX_MENU_CATEGORY2+2);
  gtk_widget_show_all(smenu_table);

}


void popup_message(gint delay, ...){
  va_list args;
  gchar *msg1;
  GtkWidget *dialog;
  GtkWidget *label;
  GtkWidget *button;
  gint timer;

  va_start(args, delay);

  dialog = gtk_dialog_new();
  gtk_container_border_width(GTK_CONTAINER(dialog),5);
  gtk_window_set_title(GTK_WINDOW(dialog),_("MaCoPiX Message"));
  
  timer=gtk_timeout_add(delay*1000, close_popup, (gpointer)dialog);

  gtk_signal_connect(GTK_OBJECT(dialog),"destroy",
		     GTK_SIGNAL_FUNC(destroy_popup), 
		     (gpointer *)timer);

  while(1){
    msg1=va_arg(args,gchar*);
    if(!msg1) break;
   
    label=gtk_label_new(msg1);
    gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),
		       label,TRUE,TRUE,0);
  }

  va_end(args);

  gtk_widget_show_all(dialog);
  gtk_main();

  flagChildDialog=FALSE;
}
