//  MaCoPiX = Mascot Construnctive Pilot for X
//                                (ActX / Gtk+ Evolution)
//    A unified desktop mascot program
//    for UNIX / X Window System with Gdk Environment
//
//       main.h  : Configuration header  for  MaCoPiX
//                                         copyright K.Chimari 2002-4
//
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
// 
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
// 
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#ifndef MAIN_H
#define MAIN_H 1

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif  

#include<stdio.h>
#include<stdlib.h>
#include<time.h>
#include<unistd.h>
#include<sys/stat.h>
#include<sys/types.h>

#include<gtk/gtk.h>
#include<gdk-pixbuf/gdk-pixbuf.h>
//#include <gdk_imlib.h>

#include "version.h"
#include "configfile.h"
#include "intl.h"
#include "libpop.h"

// ޥåȥեѳĥ
#define MASCOT_EXTENSION "*.mcpx"

// ˥塼եѳĥ
#define MENU_EXTENSION "*.menu"

// եѳĥ
#define PNG_EXTENSION "*.png"
#define GIF_EXTENSION "*.gif"
#define XPM_EXTENSION "*.xpm"

// ꥽եѳĥ
#define RC_EXTENSION "*.rc"

// Τäꥭեѳĥ
#define NKR_EXTENSION "*.ini"

// Τäꥭ BMPեĥ
#define BMP_EXTENSION "*.bmp"

// Ŀꥻ֥ǥ쥯ȥ
//  (homeΤХǥ쥯ȥ)
#define USER_DIR ".macopix/"
#define PIXDIR "pixmap/"
#define SOUNDDIR "sound/"

// Ŀѥ֥ե
//  (USER_DIR˺ : ޥå¸ѥ᡼¸)
#define USER_RCFILE "macopix.rc"

// ƥ꡼Υƥݥ͡
#define TMP_CATEGORY_NAME "(New Category)"

// ޥåȤΥǥեȥ
#define DEF_CODE1 "EUC-JP"
#define DEF_CODE2 "SJIS-WIN"


// ե
#ifdef USE_GTK2

#define FONT_CLK "Sans 14"
#define FONT_BAL "Sans 10"

#else

#define FONT_CLK "-alias-fixed-bold-r-normal-*-*-160-*-*-c-*-*"
#define FONT_BAL "-alias-fixed-bold-r-normal-*-*-120-*-*-c-*-*"

#endif



// ׹ [msec]
#define INTERVAL 100


// CLOCK_MODE
enum{ CLOCK_NO,
	CLOCK_PIXMAP,
	CLOCK_PANEL
	}ClockMode;


//ANIME
#define MAX_PIXMAP   30
#define MAX_ANIME_FRAME   30
#define MAX_ANIME_PATTERN 10


//MENU
#define MAX_MENU_CATEGORY   20
#define MAX_MENU_CATEGORY2  99
#define MAX_MENU_TARGET     40

//DEFAULT PARAMETER for Clock & Balloon
#define INIT_CLK_POS   20
#define INIT_CLK_TEXT   5
#define INIT_CLK_BORDER 2

#define INIT_BAL_TEXT   3
#define INIT_BAL_BORDER 1


// Home Position Υեå
//  OS, Wndow Manager, XVersionѲ뤫?
#define ROOTOFF_X 0
#define ROOTOFF_Y (-10)

// Home Position Mode
enum{ HOMEPOS_NEVER, HOMEPOS_FOCUS, HOMEPOS_OUT } HomePos;


// MOVE mode
enum{
  MOVE_FIX,
    MOVE_FOCUS
    }MoveMode;

// Focus Follow 
enum{ FF_SIDE_LEFT, FF_SIDE_RIGHT } FFPos;



// Balloon Position
enum{
  BAL_POS_LEFT,
    BAL_POS_RIGHT
    } PosBalloon;

// Balloon Mode
enum{BALLOON_NORMAL,
       BALLOON_MAIL,
       BALLOON_POPERROR,
       BALLOON_SOCKMSG,
       BALLOON_DUET
       } TypBalloon;

// Biff Balloonμǥ޿
#define BALLOON_EXPIRE    150

// Socket Balloonμǥ޿
#define SOCK_BALLOON_EXPIRE    100

// ޥåSocketȿǥ쥤 ޿
#define DEF_DUET_DELAY    20

// Duet Anime mode
enum{
  DUET_CLICK,
    DUET_RANDOM
    }DuetAnimeMode;


// Interpolation Style for Magnification
enum{	 MAG_IP_NEAREST,
	 MAG_IP_TILES,
	 MAG_IP_BILINEAR,
	 MAG_IP_HYPER
	   } TypInterpolate;


//Clock 
enum{ CLOCK_TYPE_24S, 
	CLOCK_TYPE_24M, 
	CLOCK_TYPE_12S, 
	CLOCK_TYPE_12M } ClockType;

//DEFAULT COLOR
#define COLOR_CLK_R 0xffff
#define COLOR_CLK_G 0x0000
#define COLOR_CLK_B 0x0000

#define COLOR_CLKSD_R 0x7fff
#define COLOR_CLKSD_G 0x7fff
#define COLOR_CLKSD_B 0x7fff

#define COLOR_CLKBG_R 0xffff
#define COLOR_CLKBG_G 0xcfff
#define COLOR_CLKBG_B 0xcfff

#define COLOR_CLKBD_R 0xcfff
#define COLOR_CLKBD_G 0x7fff
#define COLOR_CLKBD_B 0x7fff


#define COLOR_BAL_R 0xffff
#define COLOR_BAL_G 0x0000
#define COLOR_BAL_B 0x0000

#define COLOR_BALBG_R 0xffff
#define COLOR_BALBG_G 0xffff
#define COLOR_BALBG_B 0xffff

#define COLOR_BALBD_R 0x0000
#define COLOR_BALBD_G 0x0000
#define COLOR_BALBD_B 0x0000


// ꥦɥ Callback
#define CONF_FONT_CLK 0
#define CONF_FONT_BAL 1
#define CONF_DEF_FONT_CLK 2
#define CONF_DEF_FONT_BAL 3
#define INIT_DEF_FONT_CLK 4
#define INIT_DEF_FONT_BAL 5

#define CONF_COLOR_CLK   00
#define CONF_COLOR_CLKBG 01
#define CONF_COLOR_CLKBD 02
#define CONF_COLOR_CLKSD 03
#define CONF_COLOR_BAL   10
#define CONF_COLOR_BALBG 11
#define CONF_COLOR_BALBD 12


// ᥤ
#define DEF_MAIL_INTERVAL 60

#ifdef USE_GTK2
#define DEF_MAIL_FILTER  "nkf -wum"
#else
#define DEF_MAIL_FILTER  "nkf -eum"
#endif

#define DEF_SJIS_FILTER  "nkf -s -Lw"

#define DEF_EUC_FILTER  "nkf -e -Lu"

enum{ MAIL_NO, MAIL_LOCAL, MAIL_POP3, MAIL_APOP, MAIL_QMAIL, MAIL_PROCMAIL } MailStatus;

enum{ MAIL_PIX_LEFT, MAIL_PIX_RIGHT } MailPixPos;

#define POP3_PORT_NO         110       /* pop3 port */

#define POP3_OK              0         /* pop3 ok */
#define POP3_OK_NORMAL       0         /* pop3 ok */
#define POP3_OK_FS_OVER      1         /* pop3 ok but FS overflow */

#define POP3_ERROR           (-1)      /* pop3 port */
#define POP3_ERROR_MESSAGE   "POP access error"

#define POP3_MAX_FS  40
#define SPAM_MARK    "X-Spam-Flag: YES"
#define SPAM_CHECK   TRUE

#define PROCMAILRC "/.procmailrc"
#define MH_MAIL_DIR "/Mail"
#define PROCMAIL_LOG "/procmail.log"


enum{ NO_MAIL, OLD_MAIL, NEW_MAIL, KEEP_NEW_MAIL } MailStatus;
// mail status; array subscripts

#define BIFF_WIN_WIDTH  400  // Default_Size of Biff Window
#define BIFF_WIN_HEIGHT 250


#define NKR_WIN_WIDTH  400  // Size of NKR Convert Log Window
#define NKR_WIN_HEIGHT 150


#define SMENU_WIN_WIDTH  500  // Size of SMENU Window
#define SMENU_WIN_HEIGHT 200

// 
#define CURSOR_NORMAL   GDK_TCROSS
#define CURSOR_PUSH     GDK_CROSS_REVERSE
#define CURSOR_DRAG_H   GDK_SB_H_DOUBLE_ARROW
#define CURSOR_DRAG_F   GDK_PLUS
#define CURSOR_BIFF     GDK_QUESTION_ARROW
#define CURSOR_CLK      GDK_ARROW

// 顼ݥåץåפΥॢ[sec]
#define POPUP_TIMEOUT 2


// 
enum{ SIGACT_NO, SIGACT_CLICK, SIGACT_CHANGE } SignalAction;


// Consistency Check
enum{ CONS_MANUAL, CONS_AUTOOW, CONS_IGNORE } ConsMode;

// ˥塼ξ
enum{ SMENU_DIR_COMMON, SMENU_DIR_USER } ScanMenuDir;


// Ѵؿ
#define RANDOMIZE() srand(time(NULL)+getpid())
#define RANDOM(x)  (rand()%(x))

// ֥å롼ѹ¤
typedef struct{
  int next;
  int seq;
  int seqend;
  int min;
  int max;
}BlockLoop;


// եѹ¤
typedef struct{
  //gchar **xpm_data;
  gchar *filename;
  GdkPixmap *pixmap;
  GdkBitmap *mask;

}typSprite;

// 빽¤
typedef struct _typCursor typCursor;
struct _typCursor{
  GdkCursor *normal;
  GdkCursor *push;
  GdkCursor *drag_f;
  GdkCursor *drag_h;
  GdkCursor *biff;
  GdkCursor *clk;
};

// ѹ¤
typedef struct _typSignal typSignal;
struct _typSignal{
  gint type;
  gchar *com;
  gboolean flag;
};

// ˥塼ѹ¤
typedef struct _typScanMenu typScanMenu;
struct _typScanMenu{
  gchar *file[MAX_MENU_CATEGORY2];
  gint  dir[MAX_MENU_CATEGORY2];
  gint  num[MAX_MENU_CATEGORY2];
  gchar *cat[MAX_MENU_CATEGORY2];
  gboolean flag_combine[MAX_MENU_CATEGORY2];
  gint  max_menu;
};


// ᥤѹ¤
typedef struct _typMail typMail;
struct _typMail{
  gboolean flag;
  gint  type;
  gchar *pop_id;
  gchar *pop_pass;
  gchar *pop_server;
  gint  pop_port;
  gboolean  pop_child_fl;
  gchar *file;
  gchar *polling;
  gchar *mailer;
  gchar *filter;
  gint  interval;
  gchar *pix_file;
  gint  pix_pos;
  gint  pix_x;
  gint  pix_y;
  gchar *word;
  gchar *sound;
  off_t    size;
  time_t   last_check;
  int      count;            // mailcount in server 
  int      new_count;
  int      fetched_count;    // fetched fs this access
  int      displayed_count;  // displayed fs
  signed int      status;
  signed int      pop3_fs_status;
  gint proc_id;
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GtkWidget *w_draw;
  gboolean drag;
  gchar *fs_max;
  gint win_width;
  gint win_height;
  gboolean spam_check;
  gchar *spam_mark;
  gint spam_count;
};


typedef struct{
  char *file;
  char *rcfile;
  gchar *inifile;
  gchar *name;
  gchar *copyright;
  int nPixmap;
  int x;
  int y;
  int xfix;
  int yfix;
  int height;
  int width;
  gint magnify;
  gint ip_style;
  int height_root;
  int width_root;
  gboolean flag_install;
  gboolean flag_common;
  gboolean flag_ow;
  gboolean flag_ow_ini;
  gboolean drag;
  gboolean clk_drag;
#ifdef USE_GTK2
  PangoFontDescription  *fontclk;
  PangoFontDescription  *fontbal;
#else
  GdkFont *fontclk;
  GdkFont *fontbal;
#endif
  gchar *fontname_bal;  
  gchar *fontname_clk;  
  gchar *deffontname_bal;  
  gchar *deffontname_clk;  
  typSprite *sprites;
  int clkmode;
  int clk_x;
  int clk_y;
  int clktext_x;
  int clktext_y;
  int wclkbd;
  int wbalbd;
  int baltext_x;
  int baltext_y;
  int balseq;
  gint balwidth;
  gint balheight;
  GtkWidget *w_drawing;
  GtkWidget *w_clkdraw;
  GtkWidget *w_baldraw;
  GdkGC *gc_main[2];
  GdkGC *gc_mainsd[2];
  GdkGC *gc_clk[2];
  GdkGC *gc_clksd[2];
  GdkGC *gc_clkbg[2];
  GdkGC *gc_clkbd[2];
  GdkGC *gc_bal[2];
  GdkGC *gc_balbg[2];
  GdkGC *gc_balbd[2];
  GdkGC *gc_balmask[2];
  GdkColor *colclk;
  GdkColor *colclksd;
  GdkColor *colclkbg;
  GdkColor *colclkbd;
  GdkColor *colbal;
  GdkColor *colbalbg;
  GdkColor *colbalbd;
  gboolean flag_clksd;
  gint clktype;
  gboolean clk_pm;
  char digit[20];  
  int anime_ptn;
  int anime_frm;
  int anime_seq;
  int anime_seqend;
  int frame_num[MAX_ANIME_PATTERN];
  int frame_pix[MAX_ANIME_PATTERN][MAX_ANIME_FRAME];
  int frame_min[MAX_ANIME_PATTERN][MAX_ANIME_FRAME];
  int frame_max[MAX_ANIME_PATTERN][MAX_ANIME_FRAME];
  BlockLoop frame_loop[MAX_ANIME_PATTERN+1][MAX_ANIME_FRAME];
  int random_weight[MAX_ANIME_PATTERN];
  int click_weight[MAX_ANIME_PATTERN];
  char *click_word[MAX_ANIME_PATTERN];
  int random_total;
  int click_total;
  gint move;
  gboolean focus_autobar;
  gint bar_size;
  gint bar_offset;
  gint xoff;
  gint yoff;
  gint homepos;
  gint home_x;
  gint home_y;
  gint ff_side;
  gint offset;
  gboolean flag_xp;
  gint offsetp;
  gboolean flag_menu;
  gint pixmap_page;
  gint bal_page;
  gint clk_page;
  gint bal_mode;
  gint bal_defpos;
  gint bal_pos;
  gchar *menu_file;
  gchar *menu_cat[MAX_MENU_CATEGORY];
  gchar *menu_tgt[MAX_MENU_CATEGORY][MAX_MENU_TARGET];
  gchar *menu_tgt_name[MAX_MENU_CATEGORY][MAX_MENU_TARGET];
  gint menu_cat_max;
  gint menu_tgt_max[MAX_MENU_CATEGORY];
  gint menu_total;
  gchar *sound_command;
  gchar *click_sound[MAX_ANIME_PATTERN];
  typSignal signal;
  typMail mail;
  gboolean flag_consow;
  gint cons_check_mode;
  gchar *sjis_filter;
  gchar *euc_filter;
  gchar *sockmsg;
  gboolean duet_open;
  gchar   *duet_file;
  gchar   *duet_tgt[MAX_ANIME_PATTERN];
  gint     duet_ptn[MAX_ANIME_PATTERN];
  gchar   *duet_word[MAX_ANIME_PATTERN];
  gint     duet_delay[MAX_ANIME_PATTERN];
  gint     duet_seq;
  gint     duet_mode;
  gboolean duet_use_click;
  gboolean duet_use_random;
  typCursor cursor;
  gchar    *code;  
  gchar    *menu_code;  
}typMascot;

#endif
