//  MaCoPiX = Mascot Construnctive Pilot for X
//                                (ActX / Gtk+ Evolution)
//    A unified desktop mascot program
//    for UNIX / X Window System with Gdk Environment
//
//     main.c  : The Main code  for  MaCoPiX
//                                         copyright K.Chimari 2002-4
//
//      Gtk+ > 1.2.6           (or Gtk+ > 2.2.0)
//      Gdk-pixbuf  > 0.7.0(?) (or Gtk+ > 2.2.0)
//      GNU GetText > 0.10.0                     are necessary.
//
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
// 
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
// 
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "main.h"
#include <gdk/gdkx.h>
#include <X11/Xutil.h>
#include <string.h>
#include <dirent.h>

#include "sockmsg.h"

// *** GLOBAL ARGUMENT ***
typMascot *Mascot;
GtkWidget *win_main, *clock_main, *balloon_main, *conf_main, *biff_pix;
GtkWidget *PopupMenu; 
GdkDrawable *pixmap_main[2]={NULL,NULL}, 
    *pixmap_clk[2]={NULL,NULL},
      *pixmap_bal[2]={NULL,NULL};
gboolean FlagInstalledMenu=FALSE;

// ץ饤Ƚ
static typSprite sprite_void[MAX_PIXMAP];



//Callbacks
extern GdkGC *CreatePen();
extern void MoveMascot();
extern void drag_begin();
extern void drag_end();
extern void clk_drag_begin();
extern void clk_drag_end();
extern void biff_drag_begin();
extern void biff_drag_end();
extern gint dw_configure_main();
extern gint dw_configure_biff_pix();
extern gint dw_configure_clk();
extern gint dw_configure_bal();
extern gint dw_expose_main();
extern gint dw_expose_biff_pix();
extern gint dw_expose_clk();
extern gint dw_expose_bal();
extern void window_motion();
extern void clk_window_motion();
extern void biff_window_motion();
extern void focus_in();
extern void focus_out();
extern gint time_update();
extern void NkrChangeMascot();


//GUI
extern GtkWidget * make_popup_menu();
extern GtkWidget * make_clock();
extern void create_cons_dialog();
extern void create_smenu_dialog();



//Pixmap
extern void LoadPixmaps();
extern void LoadBiffPixmap();


//BALLOON
extern GtkWidget * make_balloon();


// UTILS
extern void copy_file();
extern void check_common_dir();


// Mail
extern gint SetMailChecker();
extern GtkWidget * make_biff_pix();

// SockMsg
extern SockMsgInitResult sockmsg_init2(gchar *mascotname);



// Prototype of functions in this file
gchar* all_random_menu_mascot_file();
void ReadMenu();
void SaveMenu();
void ScanMenu();
gboolean ScanMenu2();
void ReadRC();
void SaveRC();
void SaveDefMenu();
void ReadMascot();
void MascotInstall();
gchar* FullPathMascotFile();
gboolean FullPathMascotCehck();
gchar* FullPathPixmapFile();
gchar* FullPathSoundFile();
gchar* FullPathRcFile();
gchar* ReadMascotName();
void SaveMascot();
void RemoveFontFromSaveData();
void InitMascot();
void InitMascot0();
void get_option();
void get_rc_option();
void usage();
void print_common_dir();

#ifdef USE_GTK2
gchar *x_locale_to_utf8(const gchar *srcstr, gssize len,
	gsize *r, gsize *w, GError **error, gchar *locale)
{
	gchar *res;
	GIConv converter;

	// Default Code described in mascot file
	if(locale){
	  converter = g_iconv_open ("UTF-8//IGNORE", locale);
	  res = g_convert_with_iconv (srcstr, len, converter, r, w, error);
	  g_iconv_close(converter);
	  if (res){
	    return res;
	  }
	}

	// 2nd  current locale
	res = g_locale_to_utf8 (srcstr, len, r, w, error);
	if (res) {
	  locale=NULL;
	  return res;
	}
	
	// 3rd  MaCoPiX default (EUC-JP)
	converter = g_iconv_open ("UTF-8//IGNORE", DEF_CODE1);
	res = g_convert_with_iconv (srcstr, len, converter, r, w, error);
	g_iconv_close(converter);
	locale=g_strdup(DEF_CODE1);
	return (res);
}

gchar *x_locale_from_utf8(const gchar *srcstr, gssize len,
	gsize *r, gsize *w, GError **error, gchar *locale)
{
	gchar *res;
	gchar *tmp_locale;
	GIConv converter;
	
	
	// Default Code described in mascot file
	if(locale){
	  tmp_locale=g_strconcat(locale,"//IGNORE",NULL);
	  converter = g_iconv_open (tmp_locale,"UTF-8");
	  g_free(tmp_locale);
	  res = g_convert_with_iconv (srcstr, len, converter, r, w, error);
	  g_iconv_close(converter);
	  if (res) 
	    return res;
	}

	// 2nd  current locale
	res = g_locale_to_utf8 (srcstr, len, r, w, error);
	if (res) 
		return res;
	
	// 3rd  MaCoPiX default (EUC-JP)
	converter = g_iconv_open (DEF_CODE1 "//IGNORE","UTF-8");
	res = g_convert_with_iconv (srcstr, len, converter, r, w, error);
	g_iconv_close(converter);
	return (res);
}
#endif

gchar* all_random_menu_mascot_file(typMascot *mascot)
{
  int i_cat, i_tgt, i_all=0, dest_total, dest_cat=0, dest_tgt=0;

  dest_total=RANDOM(mascot->menu_total);

  for(i_cat=0;i_cat<mascot->menu_cat_max;i_cat++){
    for(i_tgt=0;i_tgt<mascot->menu_tgt_max[i_cat];i_tgt++){
      if(i_all==dest_total){
	dest_cat=i_cat;
	dest_tgt=i_tgt;
      }
      i_all++;
    }
  }
  
  return(mascot->menu_tgt[dest_cat][dest_tgt]);
}


// ˥塼եɤ߹
void ReadMenu(typMascot *mascot, gint offset_i_cat, gchar *merge_file)
{
  ConfigFile *cfgfile;
  gchar *filename=NULL, *filename2=NULL, *filename0=NULL;
  gchar tmp0[10], f_tmp0[10];
  int i_cat, i_tgt;
  gboolean flag_end=FALSE, install_flag=FALSE;
  gint m_place=0;
  struct stat statbuf;
  time_t user_mtime=0, common_mtime=0;

  mascot->flag_consow=FALSE;

  if(!mascot->menu_file){     // ˥塼ʤ
    mascot->menu_total=0;
    mascot->menu_cat_max=0;
    return;
  }

  
  /// ˥塼ե֤õ
    
  // 1. Current
  if(!merge_file){
    filename = g_strdup(mascot->menu_file);
  }
  else{
    filename = g_strdup(merge_file);
  }
  
  if(access(filename,F_OK)==0){
    m_place=1;
  }

  if(mascot->flag_ow){
    // 4.  Common Directory
    if(m_place==0){
      filename = g_strconcat(COMMON_DIR,g_basename(mascot->menu_file), NULL);
      if(access(filename,F_OK)==0){
	m_place=4;
      }
    }

    // 3. USER Directory
    if(m_place==0){
      filename = g_strconcat(g_get_home_dir(),"/",USER_DIR, 
			     g_basename(mascot->menu_file), NULL);
      if(access(filename,F_OK)==0){
	m_place=3;
      }
    }
  }
  else{
    // 3. USER Directory
    if(m_place==0){
      filename = g_strconcat(g_get_home_dir(),"/",USER_DIR, 
			     g_basename(mascot->menu_file), NULL);
      if(access(filename,F_OK)==0){
	m_place=3;
      }
    }
    
    // 4.  Common Directory
    if(m_place==0){
      filename = g_strconcat(COMMON_DIR,g_basename(mascot->menu_file), NULL);
      if(access(filename,F_OK)==0){
	m_place=4;
      }
    }
  }



  // ߤĤʤ
  if(m_place==0){
    g_print(_("Cannot Find Menu File %s\n"),g_basename(mascot->menu_file));
    exit(1);
  }

  
  // 桼 ǥ쥯ȥˤΥե뤬ʤä饳ԡ
  if((m_place==1)||(m_place==4)){
    if(mascot->flag_install){
      if(mascot->flag_common){
	check_common_dir();
	filename2 = g_strconcat(COMMON_DIR, 
				g_basename(mascot->menu_file), NULL);
      }
      else{
	filename2 = g_strconcat(g_get_home_dir(),"/",USER_DIR, 
				g_basename(mascot->menu_file), NULL);
      }
      if((access(filename2,F_OK)!=0)||(mascot->flag_ow)){
	if(strcmp(filename,filename2)!=0){
	  g_print(_("Installing %s -> %s\n"),filename,filename2);
	  copy_file(filename,filename2);
	  install_flag=TRUE;
	  FlagInstalledMenu=TRUE;
	}
      }
    }
  }

  // Consistency Check
  if(mascot->cons_check_mode!=CONS_IGNORE){
    if(m_place!=4){
      filename0 = g_strconcat(COMMON_DIR,g_basename(mascot->menu_file), NULL);
      if(access(filename0,F_OK)==0){
	stat(filename0, &statbuf);
	common_mtime=statbuf.st_mtime;
      }
      filename2 = g_strconcat(g_get_home_dir(),"/",USER_DIR, 
			      g_basename(mascot->menu_file), NULL);
      if(access(filename2,F_OK)==0){
	stat(filename2, &statbuf);
	user_mtime=statbuf.st_mtime;
      }
      
      stat(filename, &statbuf);
      if((user_mtime==statbuf.st_mtime)&&(user_mtime<common_mtime)){
	// Menu file in User Dir is older 
	// than the corresponded one in Common Dir.
	if(mascot->cons_check_mode==CONS_MANUAL){
	  create_cons_dialog(mascot,g_basename(filename),
			     user_mtime,common_mtime,TRUE);
	}
	else if(mascot->cons_check_mode==CONS_AUTOOW){
	  mascot->flag_consow=TRUE;
	}
	if(mascot->flag_consow){
	  g_print(_("Installing %s -> %s\n"),filename0,filename2);
	  // Copy Common -> User
	  copy_file(filename0,filename2);
	  install_flag=TRUE;
	  FlagInstalledMenu=TRUE;
	}
      }
    }
  }

  
  if(offset_i_cat==0){  // ̾ɤ߹
    mascot->menu_file=g_strdup(filename);
    mascot->menu_total=0;
    mascot->menu_cat_max=0;// ­ǤϤʤΤmergeǤ⥯ꥢǤ롣
  }
  cfgfile = xmms_cfg_open_file(filename);
  

  if (cfgfile) {
#ifdef USE_GTK2
    if(!xmms_cfg_read_string(cfgfile, "General", "code",&mascot->menu_code))
      mascot->menu_code = NULL;
#endif

    for(i_cat=offset_i_cat;i_cat<MAX_MENU_CATEGORY;i_cat++){
      
      sprintf(f_tmp0,"Menu%02d",(i_cat-offset_i_cat));
      if(!xmms_cfg_read_string(cfgfile, f_tmp0, "Name",
			       &mascot->menu_cat[i_cat]))
	mascot->menu_cat[i_cat]=NULL;
#ifdef USE_GTK2
      if(mascot->menu_cat[i_cat]){
      	mascot->menu_cat[i_cat]=
      	  x_locale_to_utf8(mascot->menu_cat[i_cat],-1,NULL,NULL,NULL,mascot->menu_code);
	if(!mascot->menu_cat[i_cat]) 
	  mascot->menu_cat[i_cat]=g_strdup(_("(Invalid Character Code)"));
      }
#endif
      
      for(i_tgt=0;i_tgt<MAX_MENU_TARGET;i_tgt++){
	sprintf(tmp0,"file%02d",i_tgt);
	if(!xmms_cfg_read_string(cfgfile, f_tmp0, tmp0,
				 &mascot->menu_tgt[i_cat][i_tgt])){
	  if(i_tgt==0){
	    if(i_cat==0){
	      g_print(_(" Cannot read the Menu File correctly!!\n"));
	      exit(1);
	    }
	    flag_end=TRUE;
	    mascot->menu_cat_max=i_cat;
	    break;
	  }
	  else{
	    mascot->menu_tgt_max[i_cat]=i_tgt;

	    break;
	  }
	}
	else{
	  if(FlagInstalledMenu)
	    MascotInstall(mascot,mascot->menu_tgt[i_cat][i_tgt]);
	  mascot->menu_tgt_name[i_cat][i_tgt]
	    =ReadMascotName(mascot, mascot->menu_tgt[i_cat][i_tgt]);
	  mascot->menu_total++;
	}
      }
      if(flag_end) break;
    }
    xmms_cfg_free(cfgfile);
  }

  if(install_flag)   mascot->menu_file=g_strdup(filename2);

  g_free(filename);
  g_free(filename0);
  g_free(filename2);

  mascot->flag_consow=FALSE;

  /*for(i_cat=0;i_cat<mascot->menu_cat_max;i_cat++){
    g_print(" Category : %s \n", mascot->menu_cat[i_cat]);
    
    for(i_tgt=0;i_tgt<mascot->menu_tgt_max[i_cat];i_tgt++){
      g_print("     File : %s \n", mascot->menu_tgt[i_cat][i_tgt]);
    }    
    }*/

}


// ˥塼եθ
void ScanMenu(typScanMenu *smenu, gboolean flag_print)
{
  DIR *dirp;
  struct dirent *entry;
  struct stat statbuf;
  gchar *dirname=NULL, *cwdname=NULL;
  gchar *cp, *extp;
  gint i_menu=0;

  if(flag_print){
    g_print(_(" ================== Installed Menus ================== \n"));
  }

  getcwd(cwdname,1024);
  extp=g_strdup(MENU_EXTENSION);
  extp++;

  smenu->max_menu=0;
  
  /// ˥塼ե֤õ
  
  // Common Directory
  dirname = g_strdup(COMMON_DIR);
  if((dirp = opendir(dirname)) == NULL){
    if(flag_print){
      g_print(_("   !!! Common Directory - %s - does not exist.\n"), dirname);
    }
  }
  else{
    if(flag_print){
      g_print(_("  [Common Directory]\n"));
    }
    chdir(dirname);

    while((entry = readdir(dirp))!=NULL){
      stat(entry->d_name, &statbuf);
      if(S_ISREG(statbuf.st_mode)){
	cp=entry->d_name;
	cp+=strlen(entry->d_name)-strlen(MENU_EXTENSION)+1;
	if(!strcmp(extp,cp)){ // ĥҤ .menuä
	  smenu->file[i_menu]=g_strdup(entry->d_name);
	  if(ScanMenu2(smenu,i_menu)){
	    if(flag_print){
	      if(smenu->flag_combine[i_menu]){
		g_print(_("  %20s *  %2d categories  -- Combined Menu --\n"),
			smenu->file[i_menu], smenu->num[i_menu]);
	      }
	      else{
		g_print(_("  %20s :  %2d mascots    [%s]\n"),
			smenu->file[i_menu], smenu->num[i_menu], 
			smenu->cat[i_menu]);
	      }
	    }

	    smenu->dir[i_menu]=SMENU_DIR_COMMON;
	    i_menu++;
	  }
	}
      }
    }
  }

  if(flag_print){
    g_print("\n");
  }

  // USER Directory
  dirname = g_strconcat(g_get_home_dir(),"/",USER_DIR, NULL);
  if((dirp = opendir(dirname)) == NULL){
    if(flag_print){
      g_print(_("  !!! User Directory - %s - does not exist.\n"), dirname);
    }
  }
  else{
    if(flag_print){
      g_print(_("  [User Directory]\n"));
    }
    chdir(dirname);

    while((entry = readdir(dirp))!=NULL){
      stat(entry->d_name, &statbuf);
      if(S_ISREG(statbuf.st_mode)){
	cp=entry->d_name;
	cp+=strlen(entry->d_name)-strlen(MENU_EXTENSION)+1;
	if(!strcmp(extp,cp)){ // ĥҤ .menuä
	  smenu->file[i_menu]=g_strdup(entry->d_name);
	  if(ScanMenu2(smenu,i_menu,entry->d_name)){
	    if(flag_print){
	      if(smenu->flag_combine[i_menu]){
		g_print(_("  %20s *  %2d categories  -- Combined Menu --\n"),
			smenu->file[i_menu], smenu->num[i_menu]);
	      }
	      else{
		g_print(_("  %20s :  %2d mascots    [%s]\n"),
			smenu->file[i_menu], smenu->num[i_menu], 
			smenu->cat[i_menu]);
	      }
	    }
	    
	    smenu->dir[i_menu]=SMENU_DIR_USER;
	    i_menu++;
	  }
	}
      }
    }
  }

  smenu->max_menu=i_menu;

  chdir(cwdname);
  g_free(dirname);
  g_free(cwdname);

}


gboolean ScanMenu2(typScanMenu *smenu,gint i_menu)
{
  ConfigFile *cfgfile;
  int i_cat, i_tgt; 
  gchar tmp0[10], f_tmp0[10];
  gchar *dummy=NULL;
  gboolean flag_end=FALSE;
  gchar *menu_code;

  smenu->flag_combine[i_menu]=FALSE;
  smenu->num[i_menu]=0;

  cfgfile = xmms_cfg_open_file(smenu->file[i_menu]);
  
  if (cfgfile) {
#ifdef USE_GTK2
    if(!xmms_cfg_read_string(cfgfile, "General", "code",&menu_code))
      menu_code = NULL;
#endif

    for(i_cat=0;i_cat<MAX_MENU_CATEGORY;i_cat++){

      sprintf(f_tmp0,"Menu%02d",i_cat);
      if(xmms_cfg_read_string(cfgfile, f_tmp0, "Name", &dummy)){
	if(i_cat==0){
#ifdef USE_GTK2
	  if(dummy){
	    dummy=x_locale_to_utf8(dummy,-1,NULL,NULL,NULL,menu_code);
	    if(!dummy) dummy=g_strdup(_("(Invalid Character Code)"));
	  }
#endif
	  smenu->cat[i_menu]=g_strdup(dummy);
	}
      }
	
      for(i_tgt=0;i_tgt<MAX_MENU_TARGET;i_tgt++){
	sprintf(tmp0,"file%02d",i_tgt);
	if(!xmms_cfg_read_string(cfgfile, f_tmp0, tmp0, &dummy)){
	  if(i_tgt==0){
	    if(i_cat==0){
	      // Not Menu File
	      return(FALSE);
	    }
	    else if(i_cat==1){
	      // Simple Menu
	      flag_end=TRUE;
	      break;
	    }
	    else{
	      // Combined Menu
	      smenu->num[i_menu]=i_cat;
	      smenu->flag_combine[i_menu]=TRUE;
	      flag_end=TRUE;
	      break;
	    }
	  }
	  else{
	    smenu->num[i_menu]=i_tgt;

	    break;
	  }
	}
      }
      if(flag_end) break;
    }

    xmms_cfg_free(cfgfile);
    g_free(dummy);
  }
  return(TRUE);
}



// ޥåȥեν񤭹
void SaveMenu(typMascot *mascot)
{
  ConfigFile *cfgfile;
  gchar *filename;
  gchar tmp0[10], f_tmp0[10];
  int i_cat, i_tgt;
#ifdef USE_GTK2
  gchar *tmp_conv=NULL;
#endif

  
  filename = g_strdup(mascot->menu_file);
  cfgfile = xmms_cfg_open_file(filename);
  //if (!cfgfile)  cfgfile = xmms_cfg_new();
  cfgfile = xmms_cfg_new();

#ifdef USE_GTK2
  if(mascot->menu_code)
    xmms_cfg_write_string(cfgfile, "General", "code", mascot->menu_code);
#endif

  for(i_cat=0;i_cat<mascot->menu_cat_max;i_cat++){
     
    sprintf(f_tmp0,"Menu%02d",i_cat);
#ifdef USE_GTK2
    if(mascot->menu_cat[i_cat]){
      tmp_conv=
	x_locale_from_utf8(mascot->menu_cat[i_cat],-1,NULL,NULL,NULL,mascot->menu_code);
      if(!tmp_conv) tmp_conv=g_strdup(_("(Invalid Character Code)"));
    }
    xmms_cfg_write_string(cfgfile, f_tmp0, "Name",tmp_conv);
#else
    xmms_cfg_write_string(cfgfile, f_tmp0, "Name",mascot->menu_cat[i_cat]);
#endif

    for(i_tgt=0;i_tgt<mascot->menu_tgt_max[i_cat];i_tgt++){
    
      sprintf(tmp0,"file%02d",i_tgt);
      xmms_cfg_write_string(cfgfile, f_tmp0, tmp0, 
			    mascot->menu_tgt[i_cat][i_tgt]);
    }

    
  }

  xmms_cfg_write_file(cfgfile, filename);
  xmms_cfg_free(cfgfile);

  g_free(filename);
#ifdef USE_GTK2
  g_free(tmp_conv);
#endif
  
}



// եɤ߹
// ޤǤǥեȤʤΤget_option˼¹Ԥ
// ư˷ ޥåȤѹƤ¸ѥ᡼
void ReadRC(typMascot *mascot, gboolean def_flag)
{
  ConfigFile *cfgfile;
  gchar *filename;
  gchar *field_tmp=NULL;

  // USER_DIRʤȤϺ  : 餯ưΤ
  filename = g_strconcat(g_get_home_dir(), "/",USER_DIR, NULL);
  if (access(filename, F_OK) != 0) {
    g_print(_("Creating User-Dir %s .\n"),
	    filename);
    mkdir(filename,(S_IRWXU|S_IRGRP|S_IROTH));
  }
  filename = g_strconcat(g_get_home_dir(), "/",USER_DIR, PIXDIR, NULL);
  if (access(filename, F_OK) != 0) {
    g_print(_("Creating User-PixmapDir %s .\n"),
	    filename);
    mkdir(filename,(S_IRWXU|S_IRGRP|S_IROTH|S_IXGRP|S_IXOTH));
  }
  filename = g_strconcat(g_get_home_dir(), "/",USER_DIR, SOUNDDIR, NULL);
  if (access(filename, F_OK) != 0) {
    g_print(_("Creating User-SoundDir %s .\n"),
	    filename);
    mkdir(filename,(S_IRWXU|S_IRGRP|S_IROTH|S_IXGRP|S_IXOTH));
  }

  if(!mascot->rcfile){
    mascot->rcfile = g_strconcat(g_get_home_dir(), "/",
				 USER_DIR,USER_RCFILE, NULL);
  }
  else{
    mascot->rcfile = FullPathRcFile(mascot->rcfile);
  }
  filename = g_strdup(mascot->rcfile);
  cfgfile = xmms_cfg_open_file(filename);

  
  if (cfgfile) {
    if(def_flag) field_tmp=g_strdup("Default-General");
    else         field_tmp=g_strdup("General");

    if(!xmms_cfg_read_boolean(cfgfile, field_tmp, "auto_install",
			      &mascot->flag_install))
      mascot->flag_install=TRUE;
    if(!xmms_cfg_read_int(cfgfile, field_tmp, "magnify",
			  &mascot->magnify))
      mascot->magnify=100;
    if(!xmms_cfg_read_int(cfgfile, field_tmp, "ip_style",
			  &mascot->ip_style))
      mascot->ip_style=MAG_IP_BILINEAR;
    if(!xmms_cfg_read_string(cfgfile, field_tmp, "font_clock",
			  &mascot->deffontname_clk))
      mascot->deffontname_clk=g_strdup(FONT_CLK);
    if(!xmms_cfg_read_string(cfgfile, field_tmp, "font_balloon",
			  &mascot->deffontname_bal))
      mascot->deffontname_bal=g_strdup(FONT_BAL);
    if(!xmms_cfg_read_string(cfgfile, field_tmp, "menu",
			  &mascot->menu_file))
      mascot->menu_file=NULL;
    if(!xmms_cfg_read_string(cfgfile, field_tmp, "sound_command",
			  &mascot->sound_command))
      mascot->sound_command=NULL;
    if(!xmms_cfg_read_int(cfgfile, field_tmp, "cons_check_mode",
			  &mascot->cons_check_mode))
      mascot->cons_check_mode=CONS_MANUAL;
    if(!xmms_cfg_read_string(cfgfile, field_tmp, "sjis_filter",
			     &mascot->sjis_filter))
      mascot->sjis_filter=g_strdup(DEF_SJIS_FILTER);
    if(!xmms_cfg_read_string(cfgfile, field_tmp, "euc_filter",
			     &mascot->euc_filter))
      mascot->euc_filter=g_strdup(DEF_EUC_FILTER);

    // Focus Movement etc.
    if(def_flag) field_tmp=g_strdup("Default-Move");
    else         field_tmp=g_strdup("Move");

    if(!xmms_cfg_read_boolean(cfgfile, field_tmp, "relative_x",
			      &mascot->flag_xp))
      mascot->flag_xp=FALSE;
    if(!xmms_cfg_read_int(cfgfile, field_tmp, "offset",&mascot->offset))
      mascot->offset=0;
    if(!xmms_cfg_read_int(cfgfile, field_tmp, "offsetp",&mascot->offsetp))
      mascot->offsetp=0;
    if(!xmms_cfg_read_int(cfgfile, field_tmp, "ff_side",&mascot->ff_side))
      mascot->ff_side=FF_SIDE_RIGHT;
    if(!xmms_cfg_read_boolean(cfgfile, field_tmp, "autobar",
			      &mascot->focus_autobar))
      mascot->focus_autobar=TRUE;
    if(!xmms_cfg_read_int(cfgfile, field_tmp, "bar_size",&mascot->bar_size))
      mascot->bar_size=0;
    if(!xmms_cfg_read_int(cfgfile, field_tmp, "bar_offset",&mascot->bar_offset))
      mascot->bar_offset=0;
    if(!xmms_cfg_read_int(cfgfile, field_tmp, "homepos",&mascot->homepos))
      mascot->homepos=HOMEPOS_NEVER;
    if(!xmms_cfg_read_int(cfgfile, field_tmp, "home_x",&mascot->home_x))
      mascot->home_x=0;
    if(!xmms_cfg_read_int(cfgfile, field_tmp, "home_y",&mascot->home_y))
      mascot->home_y=0;

    // 
    if(def_flag) field_tmp=g_strdup("Default-Signal");
    else         field_tmp=g_strdup("Signal");

    if(!xmms_cfg_read_int(cfgfile, field_tmp, "type",&mascot->signal.type))
      mascot->signal.type=SIGACT_NO;
    if(!xmms_cfg_read_string(cfgfile, field_tmp, "command",&mascot->signal.com))
      mascot->signal.com=NULL;


    // Biff
    if(def_flag) field_tmp=g_strdup("Default-Biff");
    else         field_tmp=g_strdup("Biff");

    if(!xmms_cfg_read_int(cfgfile, field_tmp, "type",&mascot->mail.type))
      mascot->mail.type=MAIL_NO;
    if(!xmms_cfg_read_string(cfgfile, field_tmp, "pop-id",
			      &mascot->mail.pop_id))
      mascot->mail.pop_id=NULL;
    if(!xmms_cfg_read_string(cfgfile, field_tmp, "pop-pass",
			    &mascot->mail.pop_pass))
      mascot->mail.pop_pass=NULL;
    if(!xmms_cfg_read_string(cfgfile, field_tmp, "pop-server",
			     &mascot->mail.pop_server))
      mascot->mail.pop_server=NULL;
    if(!xmms_cfg_read_int(cfgfile, field_tmp, "pop-port",
			  &mascot->mail.pop_port))
      mascot->mail.pop_port=POP3_PORT_NO;
    if(!xmms_cfg_read_string(cfgfile, field_tmp, "file",
			     &mascot->mail.file))
      mascot->mail.file=NULL;
    if(!xmms_cfg_read_string(cfgfile, field_tmp, "filter",
			     &mascot->mail.filter))
      mascot->mail.filter=g_strdup(DEF_MAIL_FILTER);
    if(!xmms_cfg_read_string(cfgfile, field_tmp, "polling",
			     &mascot->mail.polling))
      mascot->mail.polling=NULL;
    if(!xmms_cfg_read_string(cfgfile, field_tmp, "mailer",
			     &mascot->mail.mailer))
      mascot->mail.mailer=NULL;
    if(!xmms_cfg_read_int(cfgfile, field_tmp, "interval",
			     &mascot->mail.interval))
      mascot->mail.interval=DEF_MAIL_INTERVAL;
    if(!xmms_cfg_read_int(cfgfile, field_tmp, "win-width",
			     &mascot->mail.win_width))
      mascot->mail.win_width=BIFF_WIN_WIDTH;
    if(!xmms_cfg_read_int(cfgfile, field_tmp, "win-height",
			     &mascot->mail.win_height))
      mascot->mail.win_height=BIFF_WIN_HEIGHT;
    if(!xmms_cfg_read_boolean(cfgfile, field_tmp, "spam-check",
			     &mascot->mail.spam_check))
      mascot->mail.spam_check=SPAM_CHECK;
    if(!xmms_cfg_read_string(cfgfile, field_tmp, "spam-mark",
			     &mascot->mail.spam_mark))
      mascot->mail.spam_mark=g_strdup(SPAM_MARK);


    // ǥ奨åȥ˥
    if(def_flag) field_tmp=g_strdup("Default-Duet");
    else         field_tmp=g_strdup("Duet");

    if(!xmms_cfg_read_boolean(cfgfile, field_tmp, "use_click",
			  &mascot->duet_use_click))
      mascot->duet_use_click=TRUE;
    if(!xmms_cfg_read_boolean(cfgfile, field_tmp, "use_random",
			      &mascot->duet_use_random))
      mascot->duet_use_random=TRUE;

    

    xmms_cfg_free(cfgfile);
  }
  else{
    // USER_RCFILEʤȤϺ : 餯ưΤ
    mascot->flag_install=TRUE;
    mascot->flag_ow=FALSE;
    mascot->flag_ow_ini=FALSE;
    mascot->magnify=100;
    mascot->ip_style=MAG_IP_BILINEAR;
    mascot->deffontname_clk=g_strdup(FONT_CLK);
    mascot->deffontname_bal=g_strdup(FONT_BAL);
    mascot->cons_check_mode=CONS_MANUAL;
    mascot->sjis_filter=g_strdup(DEF_SJIS_FILTER);
    mascot->euc_filter=g_strdup(DEF_EUC_FILTER);

    mascot->flag_xp=FALSE;
    mascot->offset=0;
    mascot->offsetp=0;
    mascot->ff_side=FF_SIDE_RIGHT;
    mascot->focus_autobar=TRUE;
    mascot->bar_size=0;
    mascot->bar_offset=0;
    mascot->homepos=HOMEPOS_NEVER;
    mascot->home_x=0;
    mascot->home_y=0;
    
    mascot->signal.type=SIGACT_NO;
    mascot->signal.com=NULL;

    mascot->mail.type=MAIL_NO;
    mascot->mail.pop_id=NULL;
    mascot->mail.pop_pass=NULL;
    mascot->mail.pop_server=NULL;
    mascot->mail.file=NULL;
    mascot->mail.filter=g_strdup(DEF_MAIL_FILTER);
    mascot->mail.pop_port=POP3_PORT_NO;
    mascot->mail.polling=NULL;
    mascot->mail.mailer=NULL;
    mascot->mail.interval=DEF_MAIL_INTERVAL;
    mascot->mail.win_width=BIFF_WIN_WIDTH;
    mascot->mail.win_height=BIFF_WIN_HEIGHT;
    mascot->mail.spam_check=SPAM_CHECK;
    mascot->mail.spam_mark=g_strdup(SPAM_MARK);

    mascot->duet_use_click=TRUE;
    mascot->duet_use_random=TRUE;
    
    SaveRC(mascot,TRUE);
    SaveRC(mascot,FALSE);
  }
  g_free(field_tmp);
  g_free(filename);

}

// եν񤭹
void SaveRC(typMascot *mascot,  gboolean def_flag)
{
  ConfigFile *cfgfile;
  gchar *filename;
  gchar *field_tmp=NULL;

  filename = g_strdup(mascot->rcfile);
  cfgfile = xmms_cfg_open_file(filename);
  if (!cfgfile)  cfgfile = xmms_cfg_new();

  
  // General Setup
  if(def_flag) field_tmp=g_strdup("Default-General");
  else         field_tmp=g_strdup("General");
  xmms_cfg_write_string(cfgfile, field_tmp, "prog_ver",VERSION);
  xmms_cfg_write_boolean(cfgfile, field_tmp, "auto_install",mascot->flag_install);
  xmms_cfg_write_int(cfgfile, field_tmp, "magnify",mascot->magnify);
  xmms_cfg_write_int(cfgfile, field_tmp, "ip_style",mascot->ip_style);
  xmms_cfg_write_string(cfgfile, field_tmp, "font_clock",mascot->deffontname_clk);
  xmms_cfg_write_string(cfgfile, field_tmp, "font_balloon",mascot->deffontname_bal);
  xmms_cfg_write_string(cfgfile, field_tmp, "sjis_filter",mascot->sjis_filter);
  xmms_cfg_write_string(cfgfile, field_tmp, "euc_filter",mascot->euc_filter);
  //if(mascot->menu_file) xmms_cfg_write_string(cfgfile, field_tmp, "menu",
  //					      mascot->menu_file);
  //else     xmms_cfg_remove_key(cfgfile,field_tmp, "menu");
  if(mascot->sound_command) 
    xmms_cfg_write_string(cfgfile, field_tmp, "sound_command",mascot->sound_command);
  else     xmms_cfg_remove_key(cfgfile,field_tmp, "sound_command");
  xmms_cfg_write_int(cfgfile, field_tmp, "cons_check_mode",mascot->cons_check_mode);

  // Focus Movement etc.

  if(def_flag) field_tmp=g_strdup("Default-Move");
  else         field_tmp=g_strdup("Move");
  xmms_cfg_write_boolean(cfgfile, field_tmp, "relative_x",mascot->flag_xp);
  xmms_cfg_write_int(cfgfile, field_tmp, "offset",mascot->offset);
  xmms_cfg_write_int(cfgfile, field_tmp, "offsetp",mascot->offsetp);
  xmms_cfg_write_int(cfgfile, field_tmp, "ff_side",mascot->ff_side);

  xmms_cfg_write_boolean(cfgfile, field_tmp, "autobar",mascot->focus_autobar);
  xmms_cfg_write_int(cfgfile, field_tmp, "bar_size",mascot->bar_size);
  xmms_cfg_write_int(cfgfile, field_tmp, "bar_offset",mascot->bar_offset);
  xmms_cfg_write_int(cfgfile, field_tmp, "homepos",mascot->homepos);
  xmms_cfg_write_int(cfgfile, field_tmp, "home_x",mascot->home_x);
  xmms_cfg_write_int(cfgfile, field_tmp, "home_y",mascot->home_y);

  // 
  if(def_flag) field_tmp=g_strdup("Default-Signal");
  else         field_tmp=g_strdup("Signal");

  xmms_cfg_write_int(cfgfile, field_tmp, "type",mascot->signal.type);
  if(mascot->signal.com)
    xmms_cfg_write_string(cfgfile, field_tmp, "command",mascot->signal.com);
  else xmms_cfg_remove_key(cfgfile,field_tmp, "command");

  // Biff

  if(def_flag) field_tmp=g_strdup("Default-Biff");
  else         field_tmp=g_strdup("Biff");

  xmms_cfg_write_int(cfgfile, field_tmp, "type",mascot->mail.type);
  if(mascot->mail.pop_id)
    xmms_cfg_write_string(cfgfile, field_tmp, "pop-id",mascot->mail.pop_id);
  else xmms_cfg_remove_key(cfgfile,field_tmp, "pop-id");
  if(mascot->mail.pop_pass)
    xmms_cfg_write_string(cfgfile, field_tmp, "pop-pass",
			  mascot->mail.pop_pass);
  else xmms_cfg_remove_key(cfgfile,field_tmp, "pop-pass");
  if(mascot->mail.pop_server)
    xmms_cfg_write_string(cfgfile, field_tmp, "pop-server",
			  mascot->mail.pop_server);
  else xmms_cfg_remove_key(cfgfile,field_tmp, "pop-server");
  if(mascot->mail.pop_port!=POP3_PORT_NO)
    xmms_cfg_write_int(cfgfile, field_tmp, "pop-port",
		       mascot->mail.pop_port);
  else xmms_cfg_remove_key(cfgfile,field_tmp, "pop-port");
  if(mascot->mail.file)
    xmms_cfg_write_string(cfgfile, field_tmp, "file",
			  mascot->mail.file);
  else xmms_cfg_remove_key(cfgfile,field_tmp, "file");
  if(mascot->mail.polling)
    xmms_cfg_write_string(cfgfile, field_tmp, "polling",
			  mascot->mail.polling);
  else xmms_cfg_remove_key(cfgfile,field_tmp, "polling");
  if(mascot->mail.mailer)
    xmms_cfg_write_string(cfgfile, field_tmp, "mailer",
			  mascot->mail.mailer);
  else xmms_cfg_remove_key(cfgfile,field_tmp, "mailer");
  if(mascot->mail.filter)
    xmms_cfg_write_string(cfgfile, field_tmp, "filter",
			  mascot->mail.filter);
  else xmms_cfg_remove_key(cfgfile,field_tmp, "filter");
  xmms_cfg_write_int(cfgfile, field_tmp, "interval",mascot->mail.interval);
  xmms_cfg_write_int(cfgfile, field_tmp, "win-width",mascot->mail.win_width);
  xmms_cfg_write_int(cfgfile, field_tmp, "win-height",mascot->mail.win_height);
  xmms_cfg_write_boolean(cfgfile, field_tmp, "spam-check",mascot->mail.spam_check);
  if(mascot->mail.spam_mark)
    xmms_cfg_write_string(cfgfile, field_tmp, "spam-mark",
			  mascot->mail.spam_mark);
  else xmms_cfg_remove_key(cfgfile,field_tmp, "spam-mark");


  // Duet˥
  if(def_flag) field_tmp=g_strdup("Default-Duet");
  else         field_tmp=g_strdup("Duet");

  xmms_cfg_write_boolean(cfgfile, field_tmp, "use_click",
			 mascot->duet_use_click);
  xmms_cfg_write_boolean(cfgfile, field_tmp, "use_random",
			 mascot->duet_use_random);


  xmms_cfg_write_file(cfgfile, filename);
  xmms_cfg_free(cfgfile);


  

  // POP桼񤭹ͽ꤬뤿ǥեȤǥ桼Τߤ
  // rwѡߥå( chmod 600 )Ȥ
  if((chmod(filename,(S_IRUSR | S_IWUSR ))) != 0){
    g_print("Cannot Chmod Resource File %s!  Please check!!!\n",filename);
  }


  g_free(field_tmp);
  g_free(filename);
}


// ǥեȥ˥塼RC-file¸
void SaveDefMenu(typMascot *mascot,  gboolean def_flag)
{
  ConfigFile *cfgfile;
  gchar *filename;
  gchar *field_tmp=NULL;

  filename = g_strdup(mascot->rcfile);
  cfgfile = xmms_cfg_open_file(filename);
  if (!cfgfile)  cfgfile = xmms_cfg_new();

  
  // General Setup
  if(def_flag) field_tmp=g_strdup("Default-General");
  else         field_tmp=g_strdup("General");
  if(mascot->menu_file) xmms_cfg_write_string(cfgfile, field_tmp, "menu",
  					      mascot->menu_file);
  else     xmms_cfg_remove_key(cfgfile,field_tmp, "menu");


  xmms_cfg_write_file(cfgfile, filename);
  xmms_cfg_free(cfgfile);


  // POP桼񤭹ͽ꤬뤿ǥեȤǥ桼Τߤ
  // rwѡߥå( chmod 600 )Ȥ
  if((chmod(filename,(S_IRUSR | S_IWUSR ))) != 0){
    g_print("Cannot Chmod Resource File %s!  Please check!!!\n",filename);
  }


  g_free(field_tmp);
  g_free(filename);
}


// ޥåȥեɤ߹
void ReadMascot(typMascot *mascot, gboolean def_flag)
{
  ConfigFile *cfgfile;
  gchar *filename=NULL, *filename2=NULL, *filename0=NULL;
  gchar tmp[64], tmp0[64];
  int i_pix=0, i_ptn=0, i_frm=0;
  gint i_tmp;
  gchar *f_tmp0=NULL;
  gint place=0;
  gboolean install_flag=FALSE;
  struct stat statbuf;
  time_t common_mtime=0,user_mtime=0;
  gint col_tmp;
#ifdef USE_GTK2
  gchar *tmp_conv=NULL;
#endif
  

  mascot->random_total=0;
  mascot->click_total=0;
  mascot->flag_consow=FALSE;

  
  /// ޥåȥե֤õ

  // 2. Current
  if(place==0){
    filename = g_strdup(mascot->file);
    if(access(filename,F_OK)==0){
      place=2;
    }
  }
  
  if(mascot->flag_ow){
    // 4.  Common Directory
    if(place==0){
      filename = g_strconcat(COMMON_DIR,g_basename(mascot->file), NULL);
      if(access(filename,F_OK)==0){
	place=4;
      }
    }

    // 1. ˥塼Ʊ
    if(place==0){
      if(mascot->menu_file){
	filename = g_strconcat(g_dirname(mascot->menu_file),"/",
			       g_basename(mascot->file),NULL);
	if(access(filename,F_OK)==0){
	  place=1;
	}
      }
    }
    
    // 3. USER Directory
    if(place==0){
      filename = g_strconcat(g_get_home_dir(),"/",USER_DIR, 
			     g_basename(mascot->file), NULL);
      if(access(filename,F_OK)==0){
	place=3;
      }
    }
  }
  else{
    // 1. ˥塼Ʊ
    if(place==0){
      if(mascot->menu_file){
	filename = g_strconcat(g_dirname(mascot->menu_file),"/",
			       g_basename(mascot->file),NULL);
	if(access(filename,F_OK)==0){
	  place=1;
	}
      }
    }
    
    // 3. USER Directory
    if(place==0){
      filename = g_strconcat(g_get_home_dir(),"/",USER_DIR, 
			     g_basename(mascot->file), NULL);
      if(access(filename,F_OK)==0){
	place=3;
      }
    }
  
    // 4.  Common Directory
    if(place==0){
      filename = g_strconcat(COMMON_DIR,g_basename(mascot->file), NULL);
      if(access(filename,F_OK)==0){
	  place=4;
      }
    }
  }

  if(place==0){
    g_print(_("Cannot Find Mascot File %s\n"),g_basename(mascot->file));
    exit(1);
  }

  
  // ޥåȤUser DirrectoryؤΥ󥹥ȡ
  if((place==1)||(place==2)||(place==4)){
    if((mascot->flag_install)&&(!FlagInstalledMenu)){
      if(mascot->flag_common){
	check_common_dir();
	filename2 = g_strconcat(COMMON_DIR, 
				g_basename(mascot->file), NULL);
      }
      else{
	filename2 = g_strconcat(g_get_home_dir(),"/",USER_DIR, 
				g_basename(mascot->file), NULL);
      }
      if((access(filename2,F_OK)!=0)||(mascot->flag_ow)){
	if(strcmp(filename,filename2)!=0){
	  g_print(_("Installing %s -> %s\n"),filename,filename2);
	  copy_file(filename,filename2);
	  install_flag=TRUE;
	}
      }
    }
  }

  // Consistency Check
  if(mascot->cons_check_mode!=CONS_IGNORE){
    if(place!=4){
      filename0 = g_strconcat(COMMON_DIR,g_basename(mascot->file), NULL);
      if(access(filename0,F_OK)==0){
	stat(filename0, &statbuf);
	common_mtime=statbuf.st_mtime;
      }
      filename2 = g_strconcat(g_get_home_dir(),"/",USER_DIR, 
			      g_basename(mascot->file), NULL);
      if(access(filename2,F_OK)==0){
	stat(filename2, &statbuf);
	user_mtime=statbuf.st_mtime;
      }
      
      stat(filename, &statbuf);
      if((user_mtime==statbuf.st_mtime)&&(user_mtime<common_mtime)){
	// Menu file in User Dir is older 
	// than the corresponded one in Common Dir.
	if(mascot->cons_check_mode==CONS_MANUAL){
	  create_cons_dialog(mascot,g_basename(filename),
			     user_mtime,common_mtime,FALSE);
	}
	else if(mascot->cons_check_mode==CONS_AUTOOW){
	  mascot->flag_consow=TRUE;
	}
	if(mascot->flag_consow){
	  g_print(_("Installing %s -> %s\n"),filename0,filename2);
	  // Copy Common -> User
	  copy_file(filename0,filename2);
	  install_flag=TRUE;
	}
      }
    }
  }


  mascot->file=g_strdup(filename);
  cfgfile = xmms_cfg_open_file(filename);
  

  
  if (cfgfile) {
    // General
    if(def_flag)      f_tmp0=g_strdup("Default-General");
    else              f_tmp0=g_strdup("General");
    
#ifdef USE_GTK2
    if(!xmms_cfg_read_string(cfgfile, f_tmp0, "code",&mascot->code))
      mascot->code = NULL;
#endif

    if(!xmms_cfg_read_string(cfgfile, f_tmp0, "name",&mascot->name))
      mascot->name=NULL;
#ifdef USE_GTK2
    if(mascot->name){
      mascot->name=
	x_locale_to_utf8(mascot->name,-1,NULL,NULL,NULL,mascot->code);
      if(!mascot->name) mascot->name=g_strdup(_("(Invalid Character Code)"));
      
    }
#endif
    if(!xmms_cfg_read_string(cfgfile, f_tmp0, "copyright",&mascot->copyright))
      mascot->copyright=NULL;


    // Focus Movement etc.
    
    if(def_flag)      f_tmp0=g_strdup("Default-Move");
    else              f_tmp0=g_strdup("Move");
    
    if(!xmms_cfg_read_int(cfgfile, f_tmp0, "move",&mascot->move))
      mascot->move=MOVE_FIX;
    if(!xmms_cfg_read_int(cfgfile, f_tmp0, "xoff",&mascot->xoff))
      mascot->xoff=0;
    if(!xmms_cfg_read_int(cfgfile, f_tmp0, "yoff",&mascot->yoff))
      mascot->yoff=0;
    if(!xmms_cfg_read_int(cfgfile, f_tmp0, "fix_x",&mascot->xfix))
      mascot->x=0;
    if(!xmms_cfg_read_int(cfgfile, f_tmp0, "fix_y",&mascot->yfix))
      mascot->y=0;

    // Clock
    if(def_flag)     f_tmp0=g_strdup("Default-Clock");
    else             f_tmp0=g_strdup("Clock");

    if(!xmms_cfg_read_int(cfgfile, f_tmp0, "x",&mascot->clk_x))
      mascot->clk_x=INIT_CLK_POS;
    if(!xmms_cfg_read_int(cfgfile, f_tmp0, "y",&mascot->clk_y))
      mascot->clk_y=INIT_CLK_POS;
    if(!xmms_cfg_read_int(cfgfile, f_tmp0, "text_x",&mascot->clktext_x))
      mascot->clktext_x=INIT_CLK_TEXT;
    if(!xmms_cfg_read_int(cfgfile, f_tmp0, "text_y",&mascot->clktext_y))
      mascot->clktext_x=INIT_CLK_TEXT;
    if(!xmms_cfg_read_int(cfgfile, f_tmp0, "border",&mascot->wclkbd))
      mascot->wclkbd=INIT_CLK_BORDER;
    if(!xmms_cfg_read_int(cfgfile, f_tmp0, "mode",&mascot->clkmode))
      mascot->clkmode=CLOCK_NO;
    if(!xmms_cfg_read_int(cfgfile, f_tmp0, "type",&mascot->clktype))
      mascot->clktype=CLOCK_TYPE_24S;
    if(!xmms_cfg_read_boolean(cfgfile, f_tmp0, "shadow",&mascot->flag_clksd))
      mascot->flag_clksd=TRUE;
    if(!xmms_cfg_read_string(cfgfile, f_tmp0, "font",&mascot->fontname_clk))
      mascot->fontname_clk=NULL;
    //      mascot->fontname_clk=g_strconcat(FONT_CLK,NULL);


    // Balloon
    if(def_flag)    f_tmp0=g_strdup("Default-Balloon");
    else            f_tmp0=g_strdup("Balloon");

    if(!xmms_cfg_read_int(cfgfile, f_tmp0, "text_x",&mascot->baltext_x))
      mascot->baltext_x=INIT_BAL_TEXT;
    if(!xmms_cfg_read_int(cfgfile, f_tmp0, "text_y",&mascot->baltext_y))
      mascot->baltext_y=INIT_BAL_TEXT;
    if(!xmms_cfg_read_int(cfgfile, f_tmp0, "border",&mascot->wbalbd))
      mascot->wbalbd=INIT_BAL_BORDER;
    if(!xmms_cfg_read_int(cfgfile, f_tmp0, "position",&mascot->bal_defpos))
      mascot->bal_defpos=BAL_POS_LEFT;
    if(!xmms_cfg_read_string(cfgfile, f_tmp0, "font",&mascot->fontname_bal))
      mascot->fontname_bal=NULL;
    //      mascot->fontname_bal=g_strconcat(FONT_BAL,NULL);

    // Color for Clock
    if(def_flag)  f_tmp0=g_strdup("Default-ClockColor");
    else          f_tmp0=g_strdup("ClockColor");

    if(!xmms_cfg_read_int(cfgfile, f_tmp0, "text_r", &col_tmp))
      col_tmp=COLOR_CLK_R;
    mascot->colclk->red=col_tmp;
    if(!xmms_cfg_read_int(cfgfile, f_tmp0, "text_g", &col_tmp))
      col_tmp=COLOR_CLK_G;
    mascot->colclk->green=col_tmp;
    if(!xmms_cfg_read_int(cfgfile, f_tmp0, "text_b", &col_tmp))
      col_tmp=COLOR_CLK_B;
    mascot->colclk->blue=col_tmp;
                                                                                
    if(!xmms_cfg_read_int(cfgfile, f_tmp0, "shadow_r", &col_tmp))
      col_tmp=COLOR_CLKSD_R;
    mascot->colclksd->red=col_tmp;
    if(!xmms_cfg_read_int(cfgfile, f_tmp0, "shadow_g", &col_tmp))
      col_tmp=COLOR_CLKSD_G;
    mascot->colclksd->green=col_tmp;
    if(!xmms_cfg_read_int(cfgfile, f_tmp0, "shadow_b", &col_tmp))
      col_tmp=COLOR_CLKSD_B;
    mascot->colclksd->blue=col_tmp;

    if(!xmms_cfg_read_int(cfgfile, f_tmp0, "bg_r", &col_tmp))
      col_tmp=COLOR_CLKBG_R;
    mascot->colclkbg->red=col_tmp;
    if(!xmms_cfg_read_int(cfgfile, f_tmp0, "bg_g", &col_tmp))
      col_tmp=COLOR_CLKBG_G;
    mascot->colclkbg->green=col_tmp;
    if(!xmms_cfg_read_int(cfgfile, f_tmp0, "bg_b", &col_tmp))
      col_tmp=COLOR_CLKBG_B;
    mascot->colclkbg->blue=col_tmp;
 
    if(!xmms_cfg_read_int(cfgfile, f_tmp0, "border_r", &col_tmp))
      col_tmp=COLOR_CLKBD_R;
    mascot->colclkbd->red=col_tmp;
    if(!xmms_cfg_read_int(cfgfile, f_tmp0, "border_g", &col_tmp))
      col_tmp=COLOR_CLKBD_G;
    mascot->colclkbd->green=col_tmp;
    if(!xmms_cfg_read_int(cfgfile, f_tmp0, "border_b", &col_tmp))
      col_tmp=COLOR_CLKBD_B;
    mascot->colclkbd->blue=col_tmp;


    // Color for Balloon
    if(def_flag)  f_tmp0=g_strdup("Default-BalloonColor");
    else          f_tmp0=g_strdup("BalloonColor");

    if(!xmms_cfg_read_int(cfgfile, f_tmp0, "text_r", &col_tmp))
      col_tmp=COLOR_BAL_R;
    mascot->colbal->red=(uint)col_tmp;
    if(!xmms_cfg_read_int(cfgfile, f_tmp0, "text_g", &col_tmp))
      col_tmp=COLOR_BAL_G;
    mascot->colbal->green=(uint)col_tmp;
    if(!xmms_cfg_read_int(cfgfile, f_tmp0, "text_b", &col_tmp))
      col_tmp=COLOR_BAL_B;
    mascot->colbal->blue=(uint)col_tmp;
       
    if(!xmms_cfg_read_int(cfgfile, f_tmp0, "bg_r", &col_tmp))
      col_tmp=COLOR_BALBG_R;
    mascot->colbalbg->red=(uint)col_tmp;
    if(!xmms_cfg_read_int(cfgfile, f_tmp0, "bg_g", &col_tmp))
      col_tmp=COLOR_BALBG_G;
    mascot->colbalbg->green=(uint)col_tmp;
    if(!xmms_cfg_read_int(cfgfile, f_tmp0, "bg_b", &col_tmp))
      col_tmp=COLOR_BALBG_B;
    mascot->colbalbg->blue=(uint)col_tmp;

    if(!xmms_cfg_read_int(cfgfile, f_tmp0, "border_r", &col_tmp))
      col_tmp=COLOR_BALBD_R;
    mascot->colbalbd->red=(uint)col_tmp;
    if(!xmms_cfg_read_int(cfgfile, f_tmp0, "border_g", &col_tmp))
      col_tmp=COLOR_BALBD_G;
    mascot->colbalbd->green=(uint)col_tmp;
    if(!xmms_cfg_read_int(cfgfile, f_tmp0, "border_b", &col_tmp))
      col_tmp=COLOR_BALBD_B;
    mascot->colbalbd->blue=(uint)col_tmp;


    // Biffѥǡ
    if(def_flag)   f_tmp0=g_strdup("Default-Biff");
    else           f_tmp0=g_strdup("Biff");

    if(!xmms_cfg_read_string(cfgfile, f_tmp0, "pix-file",&filename0))
      // BiffѲե
      mascot->mail.pix_file=NULL;
    else
      mascot->mail.pix_file=FullPathPixmapFile(mascot, filename0);


    if(!xmms_cfg_read_int(cfgfile, f_tmp0, "pix-pos",&mascot->mail.pix_pos))
      mascot->mail.pix_pos=MAIL_PIX_RIGHT;
    if(!xmms_cfg_read_int(cfgfile, f_tmp0, "pix-x",&mascot->mail.pix_x))
      mascot->mail.pix_x=0;
    if(!xmms_cfg_read_int(cfgfile, f_tmp0, "pix-y",&mascot->mail.pix_y))
      mascot->mail.pix_y=0;

    if(!xmms_cfg_read_string(cfgfile, f_tmp0, "word",&mascot->mail.word))
      // BiffѤդå
      mascot->mail.word=NULL;
#ifdef USE_GTK2
    if(mascot->mail.word){
      mascot->mail.word=
	x_locale_to_utf8(mascot->mail.word,
			 -1,NULL,NULL,NULL,mascot->code);
      if(!mascot->mail.word) mascot->mail.word=g_strdup(_("(Invalid Character Code)"));
      
    }
#endif
   
    if(!xmms_cfg_read_string(cfgfile, f_tmp0, "sound",&mascot->mail.sound))
      // Biff忮ѥե
      mascot->mail.sound=NULL;




    // Pixmapǡ
    if(def_flag)   f_tmp0=g_strdup("Default-Pixmap");
    else           f_tmp0=g_strdup("Pixmap");
    
    for(i_pix=0;i_pix<MAX_PIXMAP;i_pix++){
      mascot->sprites[i_pix].pixmap=NULL;
      mascot->sprites[i_pix].mask=NULL;
      sprintf(tmp, "pixmap%02d", i_pix);
      if(!xmms_cfg_read_string(cfgfile, f_tmp0, tmp, &filename0)){
      	mascot->sprites[i_pix].filename=NULL;
	break;
      }
      else{
	mascot->sprites[i_pix].filename=
	  FullPathPixmapFile(mascot, filename0);
      }

    }
	
    // Animationǡ
    // ƥѥΥե졼0pixե̾ʤȤ
    for(i_ptn=0;i_ptn<MAX_ANIME_PATTERN;i_ptn++){
      if(def_flag)  sprintf(tmp0, "Default-Pattern%02d", i_ptn);
      else          sprintf(tmp0, "Pattern%02d", i_ptn);
      if(!xmms_cfg_read_int(cfgfile, tmp0, "random_weight",
			    &mascot->random_weight[i_ptn])) 
	// ॢ˥Ť
	mascot->random_weight[i_ptn]=0;
      mascot->random_total+=mascot->random_weight[i_ptn];

      if(!xmms_cfg_read_int(cfgfile, tmp0, "click_weight",
			    &mascot->click_weight[i_ptn]))
	// å˥Ť
	mascot->click_weight[i_ptn]=0;
      mascot->click_total+=mascot->click_weight[i_ptn];
      
      if(!xmms_cfg_read_string(cfgfile, tmp0, "click_word",
			      &mascot->click_word[i_ptn]))
	// Х롼ɽѥƥ
	mascot->click_word[i_ptn]=NULL;
#ifdef USE_GTK2
      else if(mascot->click_word[i_ptn]){
	mascot->click_word[i_ptn]=
	  x_locale_to_utf8(mascot->click_word[i_ptn],
			   -1,NULL,NULL,NULL,mascot->code);
	if(!mascot->click_word[i_ptn]) 
	  mascot->click_word[i_ptn]=g_strdup(_("(Invalid Character Code)"));
			   
      }
#endif
   
      if(!xmms_cfg_read_string(cfgfile, tmp0, "click_sound",
			      &mascot->click_sound[i_ptn]))
	// åѥե
	mascot->click_sound[i_ptn]=NULL;
   

      if(!xmms_cfg_read_string(cfgfile, tmp0, "duet_tgt",
			      &mascot->duet_tgt[i_ptn]))
	// ǥ奨åȥ˥
	mascot->duet_tgt[i_ptn]=NULL;

      if(!xmms_cfg_read_int(cfgfile, tmp0, "duet_ptn",
			    &mascot->duet_ptn[i_ptn]))
	mascot->duet_ptn[i_ptn]=2;
   
      if(!xmms_cfg_read_string(cfgfile, tmp0, "duet_word",
			      &mascot->duet_word[i_ptn]))
	mascot->duet_word[i_ptn]=NULL;
#ifdef USE_GTK2
      else if(mascot->duet_word[i_ptn]){
	mascot->duet_word[i_ptn]=
	  x_locale_to_utf8(mascot->duet_word[i_ptn],
			   -1,NULL,NULL,NULL,mascot->code);
	if(!mascot->duet_word[i_ptn]) 
	  mascot->duet_word[i_ptn]=g_strdup(_("(Invalid Character Code)"));
			   
      }
#endif
   
      if(!xmms_cfg_read_int(cfgfile, tmp0, "duet_delay",
			    &mascot->duet_delay[i_ptn]))
	mascot->duet_delay[i_ptn]=DEF_DUET_DELAY;
      

    
      // ƥե졼
      for(i_frm=0;i_frm<MAX_ANIME_FRAME;i_frm++){
	// pixmapɤ᤿Ȥե졼롼
	sprintf(tmp, "pix%02d", i_frm);
	if(xmms_cfg_read_int(cfgfile, tmp0, tmp,
			     &mascot->frame_pix[i_ptn][i_frm])){
	  
	  sprintf(tmp, "min%02d", i_frm);
	  if(!xmms_cfg_read_int(cfgfile, tmp0, tmp,
				 &mascot->frame_min[i_ptn][i_frm]))
	    // minimum
	    mascot->frame_min[i_ptn][i_frm]=1;
	
	  sprintf(tmp, "max%02d", i_frm);
	  if(!xmms_cfg_read_int(cfgfile, tmp0, tmp,
				 &mascot->frame_max[i_ptn][i_frm]))
	    // maximum
	    mascot->frame_max[i_ptn][i_frm]=1;

	  if(mascot->frame_min[i_ptn][i_frm]>mascot->frame_max[i_ptn][i_frm]){
	    i_tmp=mascot->frame_max[i_ptn][i_frm];
	    mascot->frame_max[i_ptn][i_frm]=mascot->frame_min[i_ptn][i_frm];
	    mascot->frame_min[i_ptn][i_frm]=i_tmp;
	  }
      
	  // Block Loop Next Frame ꤵƤ min maxɤ
	  sprintf(tmp, "loop%02dnext", i_frm);
	  if(xmms_cfg_read_int(cfgfile, tmp0, tmp,
				 &mascot->frame_loop[i_ptn][i_frm].next)){

	    sprintf(tmp, "loop%02dmin", i_frm);
	    if(!xmms_cfg_read_int(cfgfile, tmp0, tmp,
				&mascot->frame_loop[i_ptn][i_frm].min))
	      // Block Loop Minimum
	      mascot->frame_loop[i_ptn][i_frm].min=1;

	    sprintf(tmp, "loop%02dmax", i_frm);
	    if(!xmms_cfg_read_int(cfgfile, tmp0, tmp,
				&mascot->frame_loop[i_ptn][i_frm].max))
	      // Block Loop Maximum
	      mascot->frame_loop[i_ptn][i_frm].max=1;

	    if( mascot->frame_loop[i_ptn][i_frm].min
		> mascot->frame_loop[i_ptn][i_frm].max){
	      i_tmp= mascot->frame_loop[i_ptn][i_frm].max;
	      mascot->frame_loop[i_ptn][i_frm].max
		= mascot->frame_loop[i_ptn][i_frm].min;
	      mascot->frame_loop[i_ptn][i_frm].min=i_tmp;
	    }

	  }
	  else{
	    mascot->frame_loop[i_ptn][i_frm].next=-1;
	  }

	  if(i_frm==MAX_ANIME_FRAME-1){
	    //mascot->frame_pix[i_ptn][i_frm+1]=-1;
	    mascot->frame_num[i_ptn]=MAX_ANIME_FRAME;
	  }
	}
	else{  // pixmap꤬ʤȤϽλ
	  mascot->frame_pix[i_ptn][i_frm]=-1;
	  mascot->frame_num[i_ptn]=i_frm;
	  break;
	}
      }
      
      if(i_frm==0){
	break;
      }
    }
  xmms_cfg_free(cfgfile);
  }

  if(install_flag) mascot->file=g_strdup(filename2);



  g_free(f_tmp0);
  g_free(filename);
  g_free(filename2);
#ifdef USE_GTK2
  g_free(tmp_conv);
#endif

  mascot->flag_consow=FALSE;
}


// ޥåȤΥ󥹥ȡ :  ˥塼Υ󥹥ȡ˻
void MascotInstall(typMascot *mascot, gchar *mascotfile)
{
  ConfigFile *cfgfile;
  gchar *filename=NULL, *filename2=NULL;
  gchar *pixfilename=NULL, *pixfile=NULL, *pixfilename2=NULL;
  gchar tmp[64];
  int i_pix=0;
  gchar *f_tmp0=NULL;
  gint place=0,p_place=0;

  
  /// ޥåȥե֤õ

  // 2. Current
  if(place==0){
    filename = g_strdup(mascotfile);
    if(access(filename,F_OK)==0){
      place=2;
    }
  }
  
  if(mascot->flag_ow){
    // 4.  Common Directory
    if(place==0){
      filename = g_strconcat(COMMON_DIR,mascotfile, NULL);
      if(access(filename,F_OK)==0){
	place=4;
      }
    }

    // 1. ˥塼Ʊ
    if(place==0){
      if(mascot->menu_file){
	filename = g_strconcat(g_dirname(mascot->menu_file),"/",
			       mascotfile,NULL);
	if(access(filename,F_OK)==0){
	  place=1;
	}
      }
    }
    
    // 3. USER Directory
    if(place==0){
      filename = g_strconcat(g_get_home_dir(),"/",USER_DIR, 
			     mascotfile, NULL);
      if(access(filename,F_OK)==0){
	place=3;
      }
    }
  }
  else{
    // 1. ˥塼Ʊ
    if(place==0){
      if(mascot->menu_file){
	filename = g_strconcat(g_dirname(mascot->menu_file),"/",
			       mascotfile,NULL);
	if(access(filename,F_OK)==0){
	  place=1;
	}
      }
    }
    
    // 3. USER Directory
    if(place==0){
      filename = g_strconcat(g_get_home_dir(),"/",USER_DIR, 
			     mascotfile, NULL);
      if(access(filename,F_OK)==0){
	place=3;
      }
    }
  
    // 4.  Common Directory
    if(place==0){
      filename = g_strconcat(COMMON_DIR,mascotfile, NULL);
      if(access(filename,F_OK)==0){
	place=4;
      }
    }
  }

  if(place==0){
    g_print(_("Cannot Find Mascot File %s\n"),mascotfile);
    exit(1);
  }

  
  if((place==1)||(place==2)||(place==4)){
    if(mascot->flag_install){
      if(mascot->flag_common){
	check_common_dir();
	filename2 = g_strconcat(COMMON_DIR, mascotfile, NULL);
      }
      else{
	filename2 = g_strconcat(g_get_home_dir(),"/",USER_DIR, 
				mascotfile, NULL);
      }
      if((access(filename2,F_OK)!=0)||(mascot->flag_ow)){
	if(strcmp(filename,filename2)!=0){
	  g_print(_("Installing %s -> %s\n"),filename,filename2);
	  copy_file(filename,filename2);
	}
      }
    }

    // Pixmapǡ
    if(mascot->flag_install){
      cfgfile = xmms_cfg_open_file(filename);
      if (cfgfile) {
	// Pixmapǡ
	f_tmp0=g_strdup("Pixmap");
    
	for(i_pix=0;i_pix<MAX_PIXMAP;i_pix++){
	  sprintf(tmp, "pixmap%02d", i_pix);
	  p_place=0;
	  if(xmms_cfg_read_string(cfgfile, f_tmp0, tmp, &pixfile)){
	    /// ե֤õ
  
	    // 1. ޥåȥեƱ
	    if(p_place==0){
	      pixfilename = g_strconcat(g_dirname(filename), 
					"/",pixfile, NULL);
	      if(access(pixfilename,F_OK)==0){
		p_place=1;
	      }
	    }

	    if(mascot->flag_ow){
	      // 4.  Common Directory
	      if(p_place==0){
		pixfilename = g_strconcat(COMMON_DIR,PIXDIR, 
					  pixfile, NULL);
		if(access(pixfilename,F_OK)==0){
		  p_place=4;
		}
	      }

	      // 3. USER Pixmap Directory
	      if(p_place==0){
		pixfilename = g_strconcat(g_get_home_dir(),"/",
					  USER_DIR,PIXDIR, 
					  pixfile, NULL);
		if(access(pixfilename,F_OK)==0){
		  p_place=3;
		}
	      }
	    }
	    else{
	      // 3. USER Pixmap Directory
	      if(p_place==0){
		pixfilename = g_strconcat(g_get_home_dir(),"/",
					  USER_DIR,PIXDIR, 
					  pixfile, NULL);
		if(access(pixfilename,F_OK)==0){
		  p_place=3;
		}
	      }

	      // 4.  Common Directory
	      if(p_place==0){
		pixfilename = g_strconcat(COMMON_DIR,PIXDIR, 
					  pixfile, NULL);
		if(access(pixfilename,F_OK)==0){
		  p_place=4;
		}
	      }
	    }

	      
	    if(p_place==0){
	      g_print(_("Cannot Find Image %s\n"),pixfile);
	      exit(1);
	    }
  
	    if(p_place==1){
	      if(mascot->flag_install){
		if(mascot->flag_common){
		  check_common_dir();
		  pixfilename2 = g_strconcat(COMMON_DIR,PIXDIR,
					     pixfile, NULL);
		}
		else{
		  pixfilename2 = g_strconcat(g_get_home_dir(),"/",
					     USER_DIR,PIXDIR,
					     pixfile, NULL);
		}
		if((access(pixfilename2,F_OK)!=0)||(mascot->flag_ow)){
		  if(strcmp(pixfilename,pixfilename2)!=0){
		    g_print(_("Installing %s -> %s\n"),
			    pixfilename,pixfilename2);
		    copy_file(pixfilename,pixfilename2);
		  }
		}
	      }
	    }
	  }
	}
	xmms_cfg_free(cfgfile);

      }
    }
  }
}


gchar * FullPathMascotFile(typMascot *mascot, gchar *mascotfile)
{
  gchar *filename=NULL;
  gint place=0;

  
  /// ޥåȥե֤õ

  // 2. Current
  if(place==0){
    filename = g_strdup(mascotfile);
    if(access(filename,F_OK)==0){
      place=2;
    }
  }
  
  // 1. ˥塼Ʊ
  if(place==0){
    if(mascot->menu_file){
      filename = g_strconcat(g_dirname(mascot->menu_file),"/",
			     mascotfile,NULL);
      if(access(filename,F_OK)==0){
	place=1;
      }
    }
  }

  // 3. USER Directory
  if(place==0){
    filename = g_strconcat(g_get_home_dir(),"/",USER_DIR, 
			   mascotfile, NULL);
    if(access(filename,F_OK)==0){
      place=3;
    }
  }
  
  // 4.  Common Data Directory
  if(place==0){
    filename = g_strconcat(COMMON_DIR,mascotfile, NULL);
    if(access(filename,F_OK)==0){
      place=4;
    }
  }

  if(place==0){
    g_print(_("Cannot Find Mascot File %s\n"),
	    mascotfile);
    exit(1);
  }


  
  return(filename);
}


gboolean FullPathMascotCheck(typMascot *mascot, gchar *mascotfile)
{
  gchar *filename=NULL;
  gint place=0;
  ConfigFile *cfgfile;
  gchar *f_tmp0=NULL;
  gchar *pix0=NULL;
  gboolean flag_mf=FALSE;


  
  /// ޥåȥե֤õ

  // 2. Current
  if(place==0){
    filename = g_strdup(mascotfile);
    if(access(filename,F_OK)==0){
      place=2;
    }
  }
  
  // 1. ˥塼Ʊ
  if(place==0){
    if(mascot->menu_file){
      filename = g_strconcat(g_dirname(mascot->menu_file),"/",
			     mascotfile,NULL);
      if(access(filename,F_OK)==0){
	place=1;
      }
    }
  }

  // 3. USER Directory
  if(place==0){
    filename = g_strconcat(g_get_home_dir(),"/",USER_DIR, 
			   mascotfile, NULL);
    if(access(filename,F_OK)==0){
      place=3;
    }
  }
  
  // 4.  Common Data Directory
  if(place==0){
    filename = g_strconcat(COMMON_DIR,mascotfile, NULL);
    if(access(filename,F_OK)==0){
      place=4;
    }
  }

  
  if(place!=0){
    cfgfile = xmms_cfg_open_file(filename);
  
    if (cfgfile) {
      // Pixmap00λ꤬ȤХޥåȥեǧ
      f_tmp0=g_strdup("Pixmap");
      
      if(xmms_cfg_read_string(cfgfile, f_tmp0, "pixmap00",&pix0))
	flag_mf=TRUE;
      
      xmms_cfg_free(cfgfile);
    }
  }


  if(flag_mf){
    Mascot->file=filename;
    return(TRUE);
  }
  else{
    return(FALSE);
  }
}


gchar *FullPathPixmapFile(typMascot *mascot, gchar *pixfile)
{
  gchar *pixfilename=NULL, *pixfilename0=NULL, *pixfilename2=NULL;
  gint p_place=0;
  

  /// ե֤õ
  
  // 2. եѥ
  if(p_place==0){
    pixfilename = g_strdup(pixfile);
    if(access(pixfilename,F_OK)==0){
      p_place=2;
    }
  }
  
  // 1. ޥåȥեƱ
  if(p_place==0){
    pixfilename = g_strconcat(g_dirname(mascot->file), 
			      "/",pixfile, NULL);
    if(access(pixfilename,F_OK)==0){
      p_place=1;
    }
  }
  
  if(mascot->flag_ow){
    // 4.  Common Data Directory
    if(p_place==0){
      pixfilename = g_strconcat(COMMON_DIR,PIXDIR, 
				pixfile, NULL);
      if(access(pixfilename,F_OK)==0){
	p_place=4;
      }
    }

    // 3. USER Pixmap Directory
    if(p_place==0){
      pixfilename = g_strconcat(g_get_home_dir(),"/",
				USER_DIR,PIXDIR, 
				pixfile, NULL);
      if(access(pixfilename,F_OK)==0){
	p_place=3;
      }
    }
  }
  else{
    // 3. USER Pixmap Directory
    if(p_place==0){
      pixfilename = g_strconcat(g_get_home_dir(),"/",
				USER_DIR,PIXDIR, 
				pixfile, NULL);
      if(access(pixfilename,F_OK)==0){
	p_place=3;
      }
    }
  
    // 4.  Common Data Directory
    if(p_place==0){
      pixfilename = g_strconcat(COMMON_DIR,PIXDIR, 
				pixfile, NULL);
      if(access(pixfilename,F_OK)==0){
	p_place=4;
      }
    }
  }

	      
  if(p_place==0){
    g_print(_("Cannot Find Image %s\n"),pixfile);
    exit(1);
  }

  // 3,4ˤʤUSER Pixmap Dir˥ԡ
  if((p_place==1)||(p_place==2)){
    if((mascot->flag_install)&&(!FlagInstalledMenu)){
      if(mascot->flag_common){
	check_common_dir();
	pixfilename2 = g_strconcat(COMMON_DIR,PIXDIR,
				   g_basename(pixfile), NULL);
      }
      else{
	pixfilename2 = g_strconcat(g_get_home_dir(),"/",
				   USER_DIR,PIXDIR,
				   g_basename(pixfile), NULL);
      }
      if((access(pixfilename2,F_OK)!=0)||(mascot->flag_ow)){
	if(strcmp(pixfilename,pixfilename2)!=0){
	  g_print(_("Installing %s -> %s\n"),pixfilename,pixfilename2);
	  copy_file(pixfilename,pixfilename2);
	  pixfilename=pixfilename2;
	}
      }
    }
  }
  else if(mascot->flag_consow){  //Consistency Check
    pixfilename2  = g_strconcat(g_get_home_dir(),"/",
				USER_DIR,PIXDIR,
				g_basename(pixfile), NULL);
    pixfilename0  = g_strconcat(COMMON_DIR,PIXDIR,
			       g_basename(pixfile), NULL);
    if((access(pixfilename0,F_OK)==0)&&(access(pixfilename2,F_OK)==0)){
      g_print(_("Installing %s -> %s\n"),
	      pixfilename0,pixfilename2);
      copy_file(pixfilename0,pixfilename2);
      pixfilename=pixfilename2;
    }
    else{
      pixfilename0  = g_strconcat(COMMON_DIR, g_basename(pixfile), NULL);
      if((access(pixfilename0,F_OK)==0)&&(access(pixfilename2,F_OK)==0)){
	g_print(_("Installing %s -> %s\n"),
		pixfilename0,pixfilename2);
	copy_file(pixfilename0,pixfilename2);
	pixfilename=pixfilename2;
      }
    }
  }

  return(pixfilename);
}


/// ɥե֤õ
gchar *FullPathSoundFile(typMascot *mascot, gchar *wavfile){
  gchar *wavfilename=NULL,*wavfilename2=NULL;
  gint s_place=0;


  /// ե֤õ
  
  // 2. եѥ
  if(s_place==0){
    wavfilename = g_strdup(wavfile);
    if(access(wavfilename,F_OK)==0){
      s_place=2;
    }
  }
  
  // 1. ޥåȥեƱ
  if(s_place==0){
    wavfilename = g_strconcat(g_dirname(mascot->file), 
			      "/",wavfile, NULL);
    if(access(wavfilename,F_OK)==0){
      s_place=1;
    }
  }
  
  if(mascot->flag_ow){
    // 4.  Common Data Directory
    if(s_place==0){
      wavfilename = g_strconcat(COMMON_DIR,SOUNDDIR, 
				wavfile, NULL);
      if(access(wavfilename,F_OK)==0){
	s_place=4;
      }
    }

    // 3. USER Sound Directory
    if(s_place==0){
      wavfilename = g_strconcat(g_get_home_dir(),"/",
				USER_DIR,SOUNDDIR, 
				wavfile, NULL);
      if(access(wavfilename,F_OK)==0){
	s_place=3;
      }
    }
  }
  else{
    // 3. USER Sound Directory
    if(s_place==0){
      wavfilename = g_strconcat(g_get_home_dir(),"/",
				USER_DIR,SOUNDDIR, 
				wavfile, NULL);
      if(access(wavfilename,F_OK)==0){
	s_place=3;
      }
    }
    
    // 4.  Common Data Directory
    if(s_place==0){
      wavfilename = g_strconcat(COMMON_DIR,SOUNDDIR, 
				wavfile, NULL);
      if(access(wavfilename,F_OK)==0){
	s_place=4;
      }
    }
  }

	      
  if(s_place==0){
    g_print(_("Cannot find sound file %s\n"),wavfile);
    exit(1);
  }

  // 3,4ˤʤUSER Sound Dir˥ԡ
  if((s_place==1)||(s_place==2)){
    if((mascot->flag_install)&&(!FlagInstalledMenu)){
      if(mascot->flag_common){
	check_common_dir();
	wavfilename2 = g_strconcat(COMMON_DIR,SOUNDDIR,
				   g_basename(wavfile), NULL);
      }
      else{
	wavfilename2 = g_strconcat(g_get_home_dir(),"/",
				   USER_DIR,SOUNDDIR,
				   g_basename(wavfile), NULL);
      }
      if((access(wavfilename2,F_OK)!=0)||(mascot->flag_ow)){
	if(strcmp(wavfilename,wavfilename2)!=0){
	  g_print(_("Installing %s -> %s\n"),wavfilename,wavfilename2);
	  copy_file(wavfilename,wavfilename2);
	  wavfilename=wavfilename2;
	}
      }
    }
  }
  /*
  // Consistency Check
  if(mascot->flag_consow){
    wavfilename2 = g_strconcat(g_get_home_dir(),"/",
			       USER_DIR,SOUNDDIR,
			       g_basename(wavfile), NULL);
    wavfilename  = g_strconcat(COMMON_DIR,SOUNDDIR,
			       g_basename(wavfile), NULL);
    if(access(wavfilename,F_OK)==0){
      g_print(_("Installing %s -> %s\n"),wavfilename,wavfilename2);
      copy_file(wavfilename,wavfilename2);
      wavfilename=wavfilename2;
    }
  }
  */

  return(wavfilename);
}


/// ꥽եõ
// եѥǤƤƥǤ뤫
// Ǥʤ USERDIRõ
// ĤʤХǥեȤRCFILE֤Ф褤
gchar  *FullPathRcFile(gchar *rcfile){
  gchar *filename1;

    
  // 1. ޥå fileƱ Directory
  if(access(rcfile,F_OK)==0){
    filename1 = g_strdup(rcfile);
  }
  else{
    filename1 = g_strconcat(g_get_home_dir(),"/",
			    USER_DIR,rcfile, NULL);
    if(access(filename1,F_OK)!=0){
      g_print(_("Cannot find resource file %s.\n"),rcfile);
      g_print(_("Loading default resource file...\n"));
      filename1 = g_strconcat(g_get_home_dir(), "/",USER_DIR,
			      USER_RCFILE, NULL);
    }
  }
  return(filename1);
}


// ޥå̾ɤ߹
gchar * ReadMascotName(typMascot *mascot, gchar *mascotfile)
{
  ConfigFile *cfgfile;
  gchar *filename=NULL;
  gchar *f_tmp0=NULL;
  gchar *mascotname=NULL;
  gchar *code=NULL;

  filename=FullPathMascotFile(mascot, mascotfile);
  
  cfgfile = xmms_cfg_open_file(filename);
  
  if (cfgfile) {
    // General
    f_tmp0=g_strdup("General");
    
#ifdef USE_GTK2
    if(!xmms_cfg_read_string(cfgfile, f_tmp0, "code",&code))
      mascot->code = NULL;
#endif

    if(!xmms_cfg_read_string(cfgfile, f_tmp0, "name",&mascotname))
      mascotname = g_strconcat("(",g_basename(mascotfile),")", NULL);
#ifdef USE_GTK2
    if(mascotname){
      mascotname=x_locale_to_utf8(mascotname,-1,NULL,NULL,NULL,code);
      if(!mascotname) 
	mascotname=g_strdup(_("(Invalid Character Code)"));
    }
#endif
    
    xmms_cfg_free(cfgfile);
  }
  g_free(f_tmp0);
  g_free(filename);
  g_free(code);

  return(mascotname);
}


// ޥåȥեν񤭹
void SaveMascot(typMascot *mascot, gboolean def_flag)
{
  ConfigFile *cfgfile;
  gchar *filename;
  gchar tmp[64], tmp0[64];
  int i_pix=0, i_ptn=0, i_frm=0;
  gchar *f_tmp=NULL;
#ifdef USE_GTK2
  gchar *tmp_conv=NULL;
#endif



  
  //filename = g_strconcat(g_get_home_dir(), "/kanabo.age", NULL);
  filename = g_strdup(mascot->file);
  cfgfile = xmms_cfg_open_file(filename);
  if (!cfgfile)  cfgfile = xmms_cfg_new();

  // General 
  if(def_flag) f_tmp=g_strdup("Default-General");
  else         f_tmp=g_strdup("General");
  
  xmms_cfg_write_string(cfgfile, f_tmp, "prog_ver",VERSION);

#ifdef USE_GTK2
  if(mascot->code){
    xmms_cfg_write_string(cfgfile, f_tmp, "code",mascot->code);
  }
  else{
    xmms_cfg_remove_key(cfgfile,f_tmp, "code");
  }

  if(mascot->name){
    tmp_conv=
      x_locale_from_utf8(mascot->name,-1,NULL,NULL,NULL,mascot->code);
    xmms_cfg_write_string(cfgfile, f_tmp, "name",tmp_conv);
  }
#else
  if(mascot->name)
    xmms_cfg_write_string(cfgfile, f_tmp, "name",mascot->name);
#endif
  if(mascot->copyright)
    xmms_cfg_write_string(cfgfile, f_tmp, "copyright",mascot->copyright);


  // Focus Movement etc.
  if(def_flag) f_tmp=g_strdup("Default-Move");
  else         f_tmp=g_strdup("Move");

  xmms_cfg_write_int(cfgfile, f_tmp, "move",mascot->move);
  xmms_cfg_write_int(cfgfile, f_tmp, "xoff",mascot->xoff);
  xmms_cfg_write_int(cfgfile, f_tmp, "yoff",mascot->yoff);
  xmms_cfg_write_int(cfgfile, f_tmp, "fix_x",mascot->xfix);
  xmms_cfg_write_int(cfgfile, f_tmp, "fix_y",mascot->yfix);

  


  // Clock
  if(def_flag) f_tmp=g_strdup("Default-Clock");
  else         f_tmp=g_strdup("Clock");

  xmms_cfg_write_int(cfgfile, f_tmp, "mode",mascot->clkmode);
  xmms_cfg_write_int(cfgfile, f_tmp, "type",mascot->clktype);
  xmms_cfg_write_int(cfgfile, f_tmp, "x",mascot->clk_x);
  xmms_cfg_write_int(cfgfile, f_tmp, "y",mascot->clk_y);
  xmms_cfg_write_int(cfgfile, f_tmp, "text_x",mascot->clktext_x);
  xmms_cfg_write_int(cfgfile, f_tmp, "text_y",mascot->clktext_y);
  xmms_cfg_write_int(cfgfile, f_tmp, "border",mascot->wclkbd);
  xmms_cfg_write_boolean(cfgfile, f_tmp, "shadow",mascot->flag_clksd);
  xmms_cfg_write_string(cfgfile, f_tmp, "font",mascot->fontname_clk);


  // Balloon
  if(def_flag) f_tmp=g_strdup("Default-Balloon");
  else         f_tmp=g_strdup("Balloon");

  xmms_cfg_write_int(cfgfile, f_tmp, "text_x",mascot->baltext_x);
  xmms_cfg_write_int(cfgfile, f_tmp, "text_y",mascot->baltext_y);
  xmms_cfg_write_int(cfgfile, f_tmp, "border",mascot->wbalbd);
  xmms_cfg_write_int(cfgfile, f_tmp, "position",mascot->bal_defpos);
  xmms_cfg_write_string(cfgfile, f_tmp, "font",mascot->fontname_bal);

  // Color for Clock
  if(def_flag) f_tmp=g_strdup("Default-ClockColor");
  else         f_tmp=g_strdup("ClockColor");

  xmms_cfg_write_int(cfgfile, f_tmp, "text_r",mascot->colclk->red);
  xmms_cfg_write_int(cfgfile, f_tmp, "text_g",mascot->colclk->green);
  xmms_cfg_write_int(cfgfile, f_tmp, "text_b",mascot->colclk->blue);
  xmms_cfg_write_int(cfgfile, f_tmp, "shadow_r",mascot->colclksd->red);
  xmms_cfg_write_int(cfgfile, f_tmp, "shadow_g",mascot->colclksd->green);
  xmms_cfg_write_int(cfgfile, f_tmp, "shadow_b",mascot->colclksd->blue);
  xmms_cfg_write_int(cfgfile, f_tmp, "bg_r",mascot->colclkbg->red);
  xmms_cfg_write_int(cfgfile, f_tmp, "bg_g",mascot->colclkbg->green);
  xmms_cfg_write_int(cfgfile, f_tmp, "bg_b",mascot->colclkbg->blue);
  xmms_cfg_write_int(cfgfile, f_tmp, "border_r",mascot->colclkbd->red);
  xmms_cfg_write_int(cfgfile, f_tmp, "border_g",mascot->colclkbd->green);
  xmms_cfg_write_int(cfgfile, f_tmp, "border_b",mascot->colclkbd->blue);


  // Color for Balloon
  if(def_flag) f_tmp=g_strdup("Default-BalloonColor");
  else         f_tmp=g_strdup("BalloonColor");

  xmms_cfg_write_int(cfgfile, f_tmp, "text_r",mascot->colbal->red);
  xmms_cfg_write_int(cfgfile, f_tmp, "text_g",mascot->colbal->green);
  xmms_cfg_write_int(cfgfile, f_tmp, "text_b",mascot->colbal->blue);
  xmms_cfg_write_int(cfgfile, f_tmp, "bg_r",mascot->colbalbg->red);
  xmms_cfg_write_int(cfgfile, f_tmp, "bg_g",mascot->colbalbg->green);
  xmms_cfg_write_int(cfgfile, f_tmp, "bg_b",mascot->colbalbg->blue);
  xmms_cfg_write_int(cfgfile, f_tmp, "border_r",mascot->colbalbd->red);
  xmms_cfg_write_int(cfgfile, f_tmp, "border_g",mascot->colbalbd->green);
  xmms_cfg_write_int(cfgfile, f_tmp, "border_b",mascot->colbalbd->blue);


  // Biffǡ
  if(def_flag) f_tmp=g_strdup("Default-Biff");
  else         f_tmp=g_strdup("Biff");

  // BiffѲե
  if(mascot->mail.pix_file) 
    xmms_cfg_write_string(cfgfile, f_tmp, "pix-file",mascot->mail.pix_file);
  else
    xmms_cfg_remove_key(cfgfile,f_tmp, "pix-file");

  xmms_cfg_write_int(cfgfile, f_tmp, "pix-pos",mascot->mail.pix_pos);
  xmms_cfg_write_int(cfgfile, f_tmp, "pix-x",mascot->mail.pix_x);
  xmms_cfg_write_int(cfgfile, f_tmp, "pix-y",mascot->mail.pix_y);

  // BiffѤդå
#ifdef USE_GTK2
  if(mascot->mail.word){
    tmp_conv=
      x_locale_from_utf8(mascot->mail.word,-1,NULL,NULL,NULL,mascot->code);
    xmms_cfg_write_string(cfgfile, f_tmp, "word",tmp_conv);
  }
#else
  if(mascot->mail.word) 
    xmms_cfg_write_string(cfgfile, f_tmp, "word",mascot->mail.word);
#endif
  else
    xmms_cfg_remove_key(cfgfile,f_tmp, "word");

  // Biff忮ե
  if(mascot->mail.sound) 
    xmms_cfg_write_string(cfgfile, f_tmp, "sound",mascot->mail.sound);
  else
    xmms_cfg_remove_key(cfgfile, f_tmp, "sound");


  
  // Pixmapǡ
  if(def_flag) f_tmp=g_strdup("Default-Pixmap");
  else         f_tmp=g_strdup("Pixmap");

  for(i_pix=0;i_pix<MAX_PIXMAP;i_pix++){
    sprintf(tmp, "pixmap%02d", i_pix);
    
    if(mascot->sprites[i_pix].filename){
      xmms_cfg_write_string(cfgfile, f_tmp, tmp,
			    (char *)g_basename(mascot->sprites[i_pix].filename));
    }
    else{
      xmms_cfg_remove_key(cfgfile, f_tmp, tmp);
    }
      
  }
	
  // Animationǡ
  for(i_ptn=0;i_ptn<MAX_ANIME_PATTERN;i_ptn++){
    
  if(def_flag) sprintf(tmp0, "Default-Pattern%02d", i_ptn);
  else         sprintf(tmp0, "Pattern%02d", i_ptn);
    
    if(mascot->random_weight[i_ptn]!=0){ // ॢ˥Ť
      xmms_cfg_write_int(cfgfile, tmp0, "random_weight",
			 mascot->random_weight[i_ptn]);
    }
    else{
      xmms_cfg_remove_key(cfgfile,tmp0, "random_weight");
    }
  
    if(mascot->click_weight[i_ptn]!=0){ // å˥Ť
      xmms_cfg_write_int(cfgfile, tmp0, "click_weight",
			 mascot->click_weight[i_ptn]);
    }
    else{
      xmms_cfg_remove_key(cfgfile,tmp0, "click_weight");
    }
    
#ifdef USE_GTK2
  if(mascot->click_word[i_ptn]){
    tmp_conv=
      x_locale_from_utf8(mascot->click_word[i_ptn],-1,NULL,NULL,NULL,mascot->code);
    xmms_cfg_write_string(cfgfile, tmp0, "click_word",tmp_conv);
  }
#else
    if(mascot->click_word[i_ptn]){ // Х롼ѥƥ
      xmms_cfg_write_string(cfgfile, tmp0, "click_word",
			    (gchar *)mascot->click_word[i_ptn]);
    }
#endif
    else{
      xmms_cfg_remove_key(cfgfile,tmp0, "click_word");
    }
    
    if(mascot->click_sound[i_ptn]){ // åե
      xmms_cfg_write_string(cfgfile, tmp0, "click_sound",
			    (gchar *)mascot->click_sound[i_ptn]);
    }
    else{
      xmms_cfg_remove_key(cfgfile,tmp0, "click_sound");
    }
   
    if(mascot->duet_tgt[i_ptn]){ // ǥ奨åȥ˥
      xmms_cfg_write_string(cfgfile, tmp0, "duet_tgt",
			    (gchar *)mascot->duet_tgt[i_ptn]);
      xmms_cfg_write_int(cfgfile, tmp0, "duet_ptn",
			 mascot->duet_ptn[i_ptn]);
#ifdef USE_GTK2
      if(mascot->duet_word[i_ptn]){
	tmp_conv=
	  x_locale_from_utf8(mascot->duet_word[i_ptn],-1,NULL,NULL,NULL,mascot->code);
	xmms_cfg_write_string(cfgfile, tmp0, "duet_word",tmp_conv);
      }
#else
      if(mascot->duet_word[i_ptn]){ 
	xmms_cfg_write_string(cfgfile, tmp0, "duet_word",
			      (gchar *)mascot->duet_word[i_ptn]);
      }
#endif
      xmms_cfg_write_int(cfgfile, tmp0, "duet_delay",
			 mascot->duet_delay[i_ptn]);
    }
    else{
      xmms_cfg_remove_key(cfgfile,tmp0, "duet_tgt");
      xmms_cfg_remove_key(cfgfile,tmp0, "duet_ptn");
      xmms_cfg_remove_key(cfgfile,tmp0, "duet_word");
      xmms_cfg_remove_key(cfgfile,tmp0, "duet_delay");
    }
    

    
    // ƥե졼
    for(i_frm=0;i_frm<MAX_ANIME_FRAME;i_frm++){
      if(mascot->frame_pix[i_ptn][i_frm]!=-1){
	// Pixmap
	sprintf(tmp, "pix%02d", i_frm);
	xmms_cfg_write_int(cfgfile, tmp0, tmp,
			   mascot->frame_pix[i_ptn][i_frm]);
	
	// minimum
	sprintf(tmp, "min%02d", i_frm);
	xmms_cfg_write_int(cfgfile, tmp0, tmp,
			   mascot->frame_min[i_ptn][i_frm]);
	
	// maximum
	sprintf(tmp, "max%02d", i_frm);
	xmms_cfg_write_int(cfgfile, tmp0, tmp,
			   mascot->frame_max[i_ptn][i_frm]);
      
	if(mascot->frame_loop[i_ptn][i_frm].next!=-1){
	  // Block Loop Next Frame
	  sprintf(tmp, "loop%02dnext", i_frm);
	  xmms_cfg_write_int(cfgfile, tmp0, tmp,
			     mascot->frame_loop[i_ptn][i_frm].next);
	
	  // Block Loop Minimum
	  sprintf(tmp, "loop%02dmin", i_frm);
	  xmms_cfg_write_int(cfgfile, tmp0, tmp,
			     mascot->frame_loop[i_ptn][i_frm].min);
	  
	  // Block Loop Maximum
	  sprintf(tmp, "loop%02dmax", i_frm);
	  xmms_cfg_write_int(cfgfile, tmp0, tmp,
			     mascot->frame_loop[i_ptn][i_frm].max);
	}
	else{
	  sprintf(tmp, "loop%02dnext", i_frm);
	  xmms_cfg_remove_key(cfgfile,tmp0,tmp);

	  sprintf(tmp, "loop%02dmin", i_frm);
	  xmms_cfg_remove_key(cfgfile,tmp0,tmp);

	  sprintf(tmp, "loop%02dmax", i_frm);
	  xmms_cfg_remove_key(cfgfile,tmp0,tmp);
	}
      }
      else{
	sprintf(tmp, "pix%02d", i_frm);
	xmms_cfg_remove_key(cfgfile,tmp0,tmp);

	sprintf(tmp, "min%02d", i_frm);
	xmms_cfg_remove_key(cfgfile,tmp0,tmp);

	sprintf(tmp, "max%02d", i_frm);
	xmms_cfg_remove_key(cfgfile,tmp0,tmp);

	sprintf(tmp, "loop%02dnext", i_frm);
	xmms_cfg_remove_key(cfgfile,tmp0,tmp);
	
	sprintf(tmp, "loop%02dmin", i_frm);
	xmms_cfg_remove_key(cfgfile,tmp0,tmp);
	
	sprintf(tmp, "loop%02dmax", i_frm);
	xmms_cfg_remove_key(cfgfile,tmp0,tmp);
      }
    }
  }
	 
  if(!def_flag){
    if(!xmms_cfg_read_string(cfgfile, "Default-General","prog_ver",&f_tmp)){
      xmms_cfg_write_file(cfgfile, filename);
      xmms_cfg_free(cfgfile);
      SaveMascot(mascot,TRUE);
    }
    else{
      xmms_cfg_write_file(cfgfile, filename);
      xmms_cfg_free(cfgfile);
    }
  }
  else{
    xmms_cfg_write_file(cfgfile, filename);
    xmms_cfg_free(cfgfile);
  }

  g_free(f_tmp);
  g_free(filename);
#ifdef USE_GTK2
  g_free(tmp_conv);
#endif
}


// ޥå̾ɤ߹
void RemoveFontFromSaveData(typMascot *mascot, gboolean def_flag)
{
  ConfigFile *cfgfile;
  gchar *filename=NULL;
  gchar *f_tmp=NULL;

  filename = g_strdup(mascot->file);
  cfgfile = xmms_cfg_open_file(filename);
  
  if (cfgfile) {
    // Balloon
    if(def_flag) f_tmp=g_strdup("Default-Balloon");
    else         f_tmp=g_strdup("Balloon");

    xmms_cfg_remove_key(cfgfile, f_tmp, "font");

    // Clock
    if(def_flag) f_tmp=g_strdup("Default-Clock");
    else         f_tmp=g_strdup("Clock");

    xmms_cfg_remove_key(cfgfile, f_tmp, "font");
    xmms_cfg_write_file(cfgfile, filename);

    xmms_cfg_free(cfgfile);
  }

  g_free(f_tmp);
  g_free(filename);
}


void InitMascot(typMascot *mascot)
{
  int i_ptn,i_frm;
  SockMsgInitResult sockres;

  // Default Color for GUI
  GdkColor init_colclk = {0, COLOR_CLK_R, COLOR_CLK_G, COLOR_CLK_B};
  GdkColor init_colclksd = {0, COLOR_CLKSD_R, COLOR_CLKSD_G, COLOR_CLKSD_B};
  GdkColor init_colclkbg = {0, COLOR_CLKBG_R, COLOR_CLKBG_G, COLOR_CLKBG_B};
  GdkColor init_colclkbd = {0, COLOR_CLKBD_R, COLOR_CLKBD_G, COLOR_CLKBD_B};

  GdkColor init_colbal = {0, COLOR_BAL_R, COLOR_BAL_G, COLOR_BAL_B};
  GdkColor init_colbalbg = {0, COLOR_BALBG_R, COLOR_BALBG_G, COLOR_BALBG_B};
  GdkColor init_colbalbd = {0, COLOR_BALBD_R, COLOR_BALBD_G, COLOR_BALBD_B};

  // ޥåȥ å
  if(mascot->duet_open){
    duet_sv_done(mascot->duet_file,TRUE);
    mascot->duet_open=FALSE;
  }
  {
    sockres = duet_sv_init((gchar *)g_basename(mascot->file));
    switch (sockres) {
    case SOCKMSG_ERROR:
      mascot->duet_open=FALSE;
      break;
    case SOCKMSG_OPENED:
      // Ǥ˥åȤ¸ߡ
      //mascot->duet_open=FALSE;
      mascot->duet_open=TRUE;
      mascot->duet_file=g_strdup(g_basename(mascot->file));
      duet_set_mascot(mascot);
      break;
    default:
      mascot->duet_open=TRUE;
      mascot->duet_file=g_strdup(g_basename(mascot->file));
      duet_set_mascot(mascot);

      break;
    }
  }
  
  
  mascot->xoff=0;
  mascot->yoff=0;
  mascot->x=0;
  mascot->y=0;
  mascot->xfix=0;
  mascot->yfix=0;


  mascot->anime_ptn=0;
  mascot->anime_frm=0;
  mascot->anime_seq=0;
  mascot->anime_seqend=-1;
  mascot->random_total=0;
  mascot->click_total=0;

  mascot->clkmode=CLOCK_NO;
  mascot->clkmode=CLOCK_TYPE_24S;
  mascot->clk_x=INIT_CLK_POS;
  mascot->clk_y=INIT_CLK_POS;
  mascot->clktext_x=INIT_CLK_TEXT;
  mascot->clktext_y=INIT_CLK_TEXT;
  mascot->flag_clksd=TRUE;
  mascot->wclkbd = INIT_CLK_BORDER;
  mascot->fontname_clk = NULL;


  mascot->baltext_x=INIT_BAL_TEXT;
  mascot->baltext_y=INIT_BAL_TEXT;
  mascot->wbalbd = INIT_BAL_BORDER;
  mascot->bal_defpos = BAL_POS_LEFT;
  mascot->bal_pos=mascot->bal_defpos;
  mascot->fontname_bal = NULL;

  mascot->colclk=g_malloc0(sizeof(GdkColor));
  mascot->colclksd=g_malloc0(sizeof(GdkColor));
  mascot->colclkbg=g_malloc0(sizeof(GdkColor));
  mascot->colclkbd=g_malloc0(sizeof(GdkColor));

  mascot->colbal=g_malloc0(sizeof(GdkColor));
  mascot->colbalbg=g_malloc0(sizeof(GdkColor));
  mascot->colbalbd=g_malloc0(sizeof(GdkColor));

  mascot->colclk=gdk_color_copy(&init_colclk);
  mascot->colclksd=gdk_color_copy(&init_colclksd);
  mascot->colclkbg=gdk_color_copy(&init_colclkbg);
  mascot->colclkbd=gdk_color_copy(&init_colclkbd);

  mascot->colbal=gdk_color_copy(&init_colbal);
  mascot->colbalbg=gdk_color_copy(&init_colbalbg);
  mascot->colbalbd=gdk_color_copy(&init_colbalbd);

  /*
  mascot->colclk->pixel=0;
  mascot->colclksd->pixel=0;
  mascot->colclkbg->pixel=0;
  mascot->colclkbd->pixel=0;

  mascot->colbal->pixel=0;
  mascot->colbalbg->pixel=0;
  mascot->colbalbd->pixel=0;
  */

  mascot->mail.pix_file=NULL;
  mascot->mail.pix_pos=MAIL_PIX_RIGHT;
  mascot->mail.pix_x=0;
  mascot->mail.pix_y=0;
  mascot->mail.word=NULL;
  mascot->mail.sound=NULL;

  mascot->duet_seq=-1;
  mascot->duet_mode=DUET_RANDOM;

  mascot->code=NULL;

  for(i_ptn=0;i_ptn<MAX_ANIME_PATTERN;i_ptn++){
      mascot->frame_num[i_ptn]=0;
      mascot->random_weight[i_ptn]=0;
      mascot->click_weight[i_ptn]=0;
      mascot->click_word[i_ptn]=NULL;
      mascot->click_sound[i_ptn]=NULL;
      mascot->duet_tgt[i_ptn]=NULL;
      mascot->duet_ptn[i_ptn]=1;
      mascot->duet_word[i_ptn]=NULL;
      mascot->duet_delay[i_ptn]=DEF_DUET_DELAY;
    for(i_frm=0;i_frm<MAX_ANIME_FRAME;i_frm++){
      mascot->frame_pix[i_ptn][i_frm]=-1;
      mascot->frame_min[i_ptn][i_frm]=0;
      mascot->frame_max[i_ptn][i_frm]=0;
      mascot->frame_loop[i_ptn][i_frm].next=-1;
      mascot->frame_loop[i_ptn][i_frm].min=0;
      mascot->frame_loop[i_ptn][i_frm].max=0;
      mascot->frame_loop[i_ptn][i_frm].seq=0;
      mascot->frame_loop[i_ptn][i_frm].seqend=0;
    }
  }

}



void InitMascot0(typMascot *mascot){
  int i_page;
  Window rootwin;

  int x_root, y_root, width_root, height_root, border, depth;
  // Root Window礭
  XGetGeometry(GDK_WINDOW_XDISPLAY(win_main->window),
	       GDK_ROOT_WINDOW(),
	       &rootwin,
	       &x_root,
	       &y_root,
	       &width_root,
	       &height_root,
	       &border,
	       &depth);

  mascot->duet_open=FALSE;
  mascot->duet_file=NULL;

  mascot->width_root=width_root;
  mascot->height_root=height_root;

  mascot->pixmap_page=1;
  mascot->bal_page=1;
  mascot->clk_page=1;
  
  mascot->balwidth=0;
  mascot->balheight=0;
  mascot->clk_drag=FALSE;

  mascot->flag_menu=FALSE;

  for(i_page=0;i_page<2;i_page++){
    mascot->gc_main[i_page] = NULL;
    mascot->gc_mainsd[i_page] = NULL;
    mascot->gc_clk[i_page] = NULL;
    mascot->gc_clksd[i_page] = NULL;
    mascot->gc_clkbg[i_page] = NULL;
    mascot->gc_clkbd[i_page] = NULL;
    mascot->gc_bal[i_page] = NULL;
    mascot->gc_balbg[i_page] = NULL;
    mascot->gc_balbd[i_page] = NULL;
    mascot->gc_balmask[i_page] = NULL;
  }

  mascot->sprites=sprite_void;

  mascot->mail.proc_id=-1;
  mascot->mail.pixmap=NULL;
  mascot->mail.mask=NULL;
  mascot->mail.drag=FALSE;
  mascot->mail.fs_max=NULL;

  mascot->clk_pm=FALSE;

  InitMascot(mascot);

}

void get_option(int argc, char **argv, typMascot *mascot)
{
  int i_opt;
  int valid=1;
  gchar *filename=NULL;

  mascot->file=NULL;
  mascot->flag_common=FALSE;
  
  //if(argc<2) usage();


  i_opt = 1;
  while((i_opt < argc)&&(valid==1)) {
    // --- X offset
    if((strcmp(argv[i_opt],"-o") == 0)||
	    (strcmp(argv[i_opt],"--offset") == 0)){ 
      if(i_opt+1 < argc ) {
	char* chkRF;
	i_opt++;
	mascot->offset=strtol(argv[i_opt],&chkRF,10);
	if((mascot->flag_xp='%')==*chkRF){
	  mascot->offsetp=mascot->offset;
	  mascot->offset=0;
	  if((mascot->offsetp<0 )||(100<mascot->offsetp))mascot->offsetp=10;
	}
	else{
	  mascot->flag_xp=FALSE;
	}
	i_opt++;
      }
      else{
	valid = 0;
      }
    }
    // --- Menu File
    else if((strcmp(argv[i_opt],"-m") == 0)||
	    (strcmp(argv[i_opt],"--menu") == 0)){ 
      if(i_opt+1 < argc ) {
	i_opt++;
	mascot->menu_file=g_strdup(argv[i_opt]);
	i_opt++;
      }
      else{
	valid = 0;
      }
    }
    // --- Install Menu File
    else if((strcmp(argv[i_opt],"--install-user-menu") == 0)){ 
      if(i_opt+1 < argc ) {
	mascot->flag_install=TRUE;
	mascot->flag_common=FALSE;
	mascot->flag_ow=TRUE;
	mascot->flag_ow_ini=TRUE;
	i_opt++;
	mascot->menu_file=g_strdup(argv[i_opt]);
	i_opt++;
      }
      else{
	valid = 0;
      }
    }
    // --- Install Mascot File
    else if((strcmp(argv[i_opt],"--install-user-mascot") == 0)){ 
      if(i_opt+1 < argc ) {
	mascot->flag_install=TRUE;
	mascot->flag_common=FALSE;
	mascot->flag_ow=TRUE;
	mascot->flag_ow_ini=TRUE;
	i_opt++;
	if(!FullPathMascotCheck(mascot,argv[i_opt])){
	  g_print(_("Option \"%s\" is not found. Ignoring...\n"),argv[i_opt]);
	}
	i_opt++;
      }
      else{
	valid = 0;
      }
    }
    // --- Install Menu File to Common Directory
    else if((strcmp(argv[i_opt],"--install-common-menu") == 0)){ 
      if(i_opt+1 < argc ) {
	mascot->flag_install=TRUE;
	mascot->flag_common=TRUE;
	mascot->flag_ow=TRUE;
	mascot->flag_ow_ini=TRUE;
	i_opt++;
	mascot->menu_file=g_strdup(argv[i_opt]);
	i_opt++;
      }
      else{
	valid = 0;
      }
    }
    // --- Install Mascot File to Common Directory
    else if((strcmp(argv[i_opt],"--install-common-mascot") == 0)){ 
      if(i_opt+1 < argc ) {
	mascot->flag_install=TRUE;
	mascot->flag_common=TRUE;
	mascot->flag_ow=TRUE;
	mascot->flag_ow_ini=TRUE;
	i_opt++;
	if(!FullPathMascotCheck(mascot,argv[i_opt])){
	  g_print(_("Option \"%s\" is not found. Ignoring...\n"),argv[i_opt]);
	}
	i_opt++;
      }
      else{
	valid = 0;
      }
    }
    // --- Magnification [%]
    else if((strcmp(argv[i_opt],"-mg") == 0)||
	    (strcmp(argv[i_opt],"--mag") == 0)){ 
      if(i_opt+1 < argc ) {
	i_opt++;
	mascot->magnify=atoi(argv[i_opt]);
	if(mascot->magnify<10 )mascot->magnify=10;
	if(mascot->magnify>400 )mascot->magnify=400;
	i_opt++;
      }
      else{
	valid = 0;
      }
    }
    // --- Interporation Style [%]
    else if((strcmp(argv[i_opt],"-i") == 0)||
	    (strcmp(argv[i_opt],"--ip-style") == 0)){ 
      if(i_opt+1 < argc ) {
	i_opt++;
	mascot->ip_style=atoi(argv[i_opt]);
	if((mascot->ip_style<MAG_IP_NEAREST)||
	   (mascot->ip_style>MAG_IP_HYPER))
	  mascot->ip_style=MAG_IP_BILINEAR;
	i_opt++;
      }
      else{
	valid = 0;
      }
    }
    // ư󥹥ȡ ON  
    else if ((strcmp(argv[i_opt], "-a") == 0)||
	     (strcmp(argv[i_opt], "--auto-install") == 0)){
      mascot->flag_install=TRUE;
      i_opt++;
    }
    // ư󥹥ȡ OFF
    else if ((strcmp(argv[i_opt], "-na") == 0)||
	     (strcmp(argv[i_opt], "--no-auto-install") == 0)){
      mascot->flag_install=FALSE;
      i_opt++;
    }
    // 񤭼ư󥹥ȡ ON  
    else if ((strcmp(argv[i_opt], "-O") == 0)||
	     (strcmp(argv[i_opt], "--over-write") == 0)){
      mascot->flag_ow=TRUE;
      mascot->flag_ow_ini=TRUE;
      i_opt++;
    }
    // Biffǽ ON  
    else if ((strcmp(argv[i_opt], "-b") == 0)||
	     (strcmp(argv[i_opt], "--biff") == 0)){
      mascot->mail.flag=TRUE;
      i_opt++;
    }
    // ǽ ON  
    else if ((strcmp(argv[i_opt], "-s") == 0)||
	     (strcmp(argv[i_opt], "--signal") == 0)){
      mascot->signal.flag=TRUE;
      i_opt++;
    }
    // --- Resource File
    else if((strcmp(argv[i_opt],"-r") == 0)||
	    (strcmp(argv[i_opt],"--rcfile") == 0)){ 
      if(i_opt+1 < argc ) {
	i_opt++;
	// mascot->rcfile=g_strconcat(argv[i_opt],NULL);
	i_opt++;
      }
      else{
	valid = 0;
      }
    }
    // Socket Message Mode ON
    else if((strcmp(argv[i_opt],"--sockmsg") == 0)){
      //Do Nothing
      i_opt++;
    }
    // Duet Anime Mode [Click] OFF
    else if((strcmp(argv[i_opt],"--no-duet-click") == 0)||
	    (strcmp(argv[i_opt],"-nc") ==0)){
      mascot->duet_use_click=FALSE;
      i_opt++;
    }
    // Duet Anime Mode [Random] OFF
    else if((strcmp(argv[i_opt],"--no-duet-random") == 0)||
	    (strcmp(argv[i_opt],"-nr") ==0)){
      mascot->duet_use_random=FALSE;
      i_opt++;
    }
    // 귿ʳΥץ
    else{
      // MascotFileǤ뤫ɤΥå
      // Mascot->file ؤν񤭹ߤԤ
      if(!FullPathMascotCheck(mascot,argv[i_opt])){
	g_print(_("Option \"%s\" is not found. Ignoring...\n"),argv[i_opt]);
      }
      i_opt++;
    }
  }
  
  g_free(filename);
  //if(!flag_file)   exit(0);
}

void get_rc_option(int argc, char **argv, typMascot *mascot)
{
  int i_opt;
  int valid=1;
  

  i_opt = 1;
  while((i_opt < argc)&&(valid==1)) {
    // --- إץå
    if ((strcmp(argv[i_opt], "-h") == 0) ||
        (strcmp(argv[i_opt], "--help") == 0)) {
      i_opt++;
      usage();
      exit(0);
    }
    // --- ̥ǥ쥯ȥɽ
    else if((strcmp(argv[i_opt],"-c") == 0)||
	    (strcmp(argv[i_opt],"--common-dir") == 0)){ 
      print_common_dir();
    }
    // --- ꥽ե
    else if((strcmp(argv[i_opt],"-r") == 0)||
       (strcmp(argv[i_opt],"--rcfile") == 0)){ 
      if(i_opt+1 < argc ) {
	i_opt++;
	mascot->rcfile=g_strdup(argv[i_opt]);
	i_opt++;
      }
      else{
	valid = 0;
      }
    }
    i_opt++;
  }
  
}

void print_common_dir(void)
{
  g_print(_("macopix COMMON DIR:%s\n"),COMMON_DIR);
  exit(0);
}

void usage(void)
{
  typScanMenu *smenu;

  smenu=g_malloc0(sizeof(typScanMenu));

  g_print(_(" macopix : Mascot Constructive Pilot for X   Ver"VERSION"\n"));
  g_print(_("  [usage] %% macopix [options] (mascot file)\n"));
  g_print(_("     -h, --help               : Print this message\n"));
  g_print(_("     -c, --common-dir         : Print COMMON Directory\n"));
  g_print(_("     -b, --biff               : Turn on the biff function\n"));
  g_print(_("     -s, --signal             : Turn on the time signal\n"));
  g_print(_("     -o, --offset offset[%%]   : Set offset-value for Focus Following\n"));
  g_print(_("     -r, --rcfile rc-file     : Set the resource file\n"));
  g_print(_("     -m, --menu   menu-file   : Set the file for quick menu\n"));
  g_print(_("     -mg --mag    magnify     : Set magnification percentage of mascot\n"));
  g_print(_("     -i, --ip-style (0|1|2|3) : Set interpolation style for magnification\n"));
  g_print(_("     -a, --auto-install       : Set mascot auto install ON\n"));
  g_print(_("     -na --no-auto-install    : Set mascot auto install OFF\n"));
  g_print(_("     -O, --over-write         : Permit to overwrite files in user dir\n"));
  g_print(_("     --install-user-mascot (mascot)  : Mascot Installation to User Dir.\n"));
  g_print(_("     --install-user-menu (menu)      : Menu Installation to User Dir.\n"));
  g_print(_("     --install-common-mascot (mascot): Mascot Installation to Common Dir.\n"));
  g_print(_("     --install-common-menu (menu)    : Menu Installation to Common Dir.\n"));
  g_print(_("     --sockmsg                : Start MaCoPiX as Socket Message Receiver\n"));
  g_print(_("     --message \"(text)\"       : Send Message to Socket Message Receiver\n"));
  g_print(_("     -nc --no-duet-click      : Duet Animation [Click] OFF\n"));
  g_print(_("     -nr --no-duet-random     : Duet Animation [Random] OFF\n"));

  g_print("\n");

  ScanMenu(smenu, TRUE);

}


int main(int argc, char **argv)
{
  GtkWidget *vbox;
  GtkWidget *drawing_area;
  GtkStyle *style;
  gint timer;
#ifndef USE_GTK2
  gchar *rcfile=NULL;
#endif
  SockMsgInitResult sockres;
  int i_opt = 1;
  gchar *msg = NULL;
  gboolean sockmsg_flag=FALSE;

  // GetText
  setlocale (LC_ALL, "");
  bindtextdomain (PACKAGE, LOCALEDIR);
  textdomain (PACKAGE);
#ifdef USE_GTK2
  bind_textdomain_codeset(PACKAGE, "UTF-8");
#endif

  while(i_opt < argc) {
    if((strcmp(argv[i_opt],"--message") == 0)){
      msg = argv[i_opt + 1];
      sockmsg_flag=TRUE;
    }
    else if((strcmp(argv[i_opt],"--sockmsg") == 0)){
      sockmsg_flag=TRUE;
    }
    i_opt++;
  }


  if (sockmsg_flag){
    sockres = sockmsg_init();
    switch (sockres) {
    case SOCKMSG_ERROR:
      return -1;
    case SOCKMSG_OPENED:
      {
	if (msg == NULL)
	  sockmsg_send_msg(_("Macopix already running in SockMsg Mode"));
	else
	  sockmsg_send_msg(msg);
	return 0;
      }
    default:
      if (msg != NULL){
	g_print(_("Macopix not running in SockMsg Mode\n"));
	return -1;
      }
      break;
    }
  }



  RANDOMIZE();    /* Ͻ */

  Mascot=g_malloc0(sizeof(typMascot));

  get_rc_option(argc, argv, Mascot);

  gtk_set_locale();

  gtk_init(&argc, &argv);

#ifndef USE_GTK2
  rcfile=g_strconcat(g_get_home_dir(),"/.gtkrc",NULL);
  gtk_rc_parse(rcfile);
  g_free(rcfile);
#endif

  ReadRC(Mascot,FALSE);

  Mascot->mail.flag=FALSE;
  Mascot->signal.flag=FALSE;
  Mascot->flag_consow=FALSE;
  get_option(argc, argv, Mascot);


  // Gdk-Pixbufǻ
  gdk_rgb_init();

  // ImlibѤ
  //gdk_imlib_init();
  //gtk_widget_push_visual(gdk_imlib_get_visual());
  //gtk_widget_push_colormap(gdk_imlib_get_colormap());

  // ˥塼ɤ߹ߤȺ
  Mascot->menu_code=NULL;
  ReadMenu(Mascot,0,NULL);
  PopupMenu=make_popup_menu();
  
  if(!Mascot->file){
    if(Mascot->menu_file){
      Mascot->file=g_strdup(all_random_menu_mascot_file(Mascot));
    }
    else{
      // ư˥塼
      create_smenu_dialog(Mascot,FALSE);
      ReadMenu(Mascot,0,NULL);
      PopupMenu=make_popup_menu();
      Mascot->file=g_strdup(all_random_menu_mascot_file(Mascot));
    }
  }


  win_main = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_app_paintable(win_main, TRUE);
  gtk_window_set_title(GTK_WINDOW(win_main), "MaCoPiX");



  gtk_window_set_policy(GTK_WINDOW(win_main), FALSE, FALSE, TRUE);
  gtk_window_set_wmclass(GTK_WINDOW(win_main), "MaCoPiX", "MaCoPiX");
  
  gtk_signal_connect(GTK_OBJECT(win_main), "destroy",
		     GTK_SIGNAL_FUNC(gtk_main_quit),NULL);


  gtk_widget_set_events(GTK_WIDGET (win_main), 
			GDK_FOCUS_CHANGE_MASK | 
			GDK_BUTTON_MOTION_MASK | 
			GDK_BUTTON_RELEASE_MASK | 
			GDK_BUTTON_PRESS_MASK | 
			GDK_EXPOSURE_MASK);

  gtk_widget_realize(win_main);

  gdk_window_set_decorations(win_main->window, 0);
  gdk_window_set_override_redirect(win_main->window,TRUE);

  
  vbox = gtk_hbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER (win_main), vbox);
  gtk_widget_show(vbox);

  gtk_signal_connect(GTK_OBJECT (win_main), "focus_in_event",
		     GTK_SIGNAL_FUNC (focus_in), NULL);
  gtk_signal_connect(GTK_OBJECT (win_main), "focus_out_event",
		     GTK_SIGNAL_FUNC (focus_out), NULL);
  gtk_signal_connect(GTK_OBJECT (win_main), "button_press_event",
		     GTK_SIGNAL_FUNC (drag_begin), (gpointer)Mascot);
  gtk_signal_connect(GTK_OBJECT (win_main), "button_release_event",
		     GTK_SIGNAL_FUNC (drag_end), (gpointer)Mascot);
  gtk_signal_connect(GTK_OBJECT (win_main), "motion_notify_event",
		     GTK_SIGNAL_FUNC (window_motion), (gpointer)Mascot);


  style = gtk_widget_get_style(win_main);

  drawing_area = gtk_drawing_area_new();
  gtk_drawing_area_size (GTK_DRAWING_AREA(drawing_area), 10, 10);
  gtk_box_pack_start(GTK_BOX(vbox), drawing_area, TRUE, TRUE, 0);
  gtk_widget_show(drawing_area);


  InitMascot0(Mascot);
  ReadMascot(Mascot,FALSE);
  Mascot->w_baldraw=make_balloon();
  Mascot->w_clkdraw=make_clock();
  LoadPixmaps(win_main, drawing_area, Mascot, Mascot->sprites);

  Mascot->flag_ow=FALSE;
  
  // Windowѷ
  gtk_signal_connect(GTK_OBJECT(drawing_area), "configure_event",
		     GTK_SIGNAL_FUNC(dw_configure_main), (gpointer)Mascot);
  // ŤʤäκϢ
  gtk_signal_connect(GTK_OBJECT(drawing_area), "expose_event",
		     GTK_SIGNAL_FUNC(dw_expose_main), (gpointer)Mascot);

  Mascot->mail.w_draw=make_biff_pix();
  LoadBiffPixmap(biff_pix, Mascot);
  
  
  gtk_signal_connect(GTK_OBJECT(Mascot->w_clkdraw), "configure_event",
		     GTK_SIGNAL_FUNC(dw_configure_clk), (gpointer)Mascot);
  gtk_signal_connect(GTK_OBJECT(Mascot->w_baldraw), "configure_event",
		     GTK_SIGNAL_FUNC(dw_configure_bal), (gpointer)Mascot);
  gtk_signal_connect(GTK_OBJECT(Mascot->w_clkdraw), "expose_event",
		     GTK_SIGNAL_FUNC(dw_expose_clk), (gpointer)Mascot);
  gtk_signal_connect(GTK_OBJECT(Mascot->w_baldraw), "expose_event",
		     GTK_SIGNAL_FUNC(dw_expose_bal), (gpointer)Mascot);
  gtk_signal_connect(GTK_OBJECT(Mascot->mail.w_draw), "configure_event",
		     GTK_SIGNAL_FUNC(dw_configure_biff_pix), (gpointer)Mascot);
  gtk_signal_connect(GTK_OBJECT(Mascot->mail.w_draw), "expose_event",
		     GTK_SIGNAL_FUNC(dw_expose_biff_pix), (gpointer)Mascot);

  gtk_signal_connect(GTK_OBJECT (clock_main), "button_press_event",
		     GTK_SIGNAL_FUNC (clk_drag_begin), (gpointer)Mascot);
  gtk_signal_connect(GTK_OBJECT (clock_main), "button_release_event",
		     GTK_SIGNAL_FUNC (clk_drag_end), (gpointer)Mascot);
  gtk_signal_connect(GTK_OBJECT (clock_main), "motion_notify_event",
		     GTK_SIGNAL_FUNC (clk_window_motion), (gpointer)Mascot);

  gtk_signal_connect(GTK_OBJECT (biff_pix), "button_press_event",
		     GTK_SIGNAL_FUNC (biff_drag_begin), (gpointer)Mascot);
  gtk_signal_connect(GTK_OBJECT (biff_pix), "button_release_event",
		     GTK_SIGNAL_FUNC (biff_drag_end), (gpointer)Mascot);
  gtk_signal_connect(GTK_OBJECT (biff_pix), "motion_notify_event",
		     GTK_SIGNAL_FUNC (biff_window_motion), (gpointer)Mascot);


  // ׹
  timer=gtk_timeout_add(INTERVAL, time_update, (gpointer)Mascot);


  // 
  if(Mascot->move==MOVE_FIX){
    MoveMascot(Mascot,Mascot->xfix,Mascot->yfix);
  }
  else{
    MoveMascot(Mascot,-Mascot->height-100,-Mascot->width-100);
  }
    
  // 
  Mascot->cursor.normal=gdk_cursor_new(CURSOR_NORMAL);
  Mascot->cursor.push  =gdk_cursor_new(CURSOR_PUSH);
  Mascot->cursor.drag_h=gdk_cursor_new(CURSOR_DRAG_H);
  Mascot->cursor.drag_f=gdk_cursor_new(CURSOR_DRAG_F);
  Mascot->cursor.biff  =gdk_cursor_new(CURSOR_BIFF);
  Mascot->cursor.clk   =gdk_cursor_new(CURSOR_CLK);
  gdk_window_set_cursor(win_main->window,Mascot->cursor.normal);
  gdk_window_set_cursor(biff_pix->window,Mascot->cursor.biff);
  gdk_window_set_cursor(clock_main->window,Mascot->cursor.clk);


  gtk_widget_show(win_main);
  gtk_widget_show(balloon_main);
  gtk_widget_unmap(balloon_main);
  gtk_widget_show(clock_main);
  if(Mascot->clkmode!=CLOCK_PANEL){
    gtk_widget_unmap(clock_main);
  }
  gtk_widget_show(biff_pix);
  gtk_widget_unmap(biff_pix);

  SetMailChecker((gpointer)Mascot);

  if(sockmsg_flag) sockmsg_set_mascot(Mascot);

  gtk_main();

  if(sockmsg_flag) sockmsg_done();
  if(Mascot->duet_open) duet_sv_done(Mascot->duet_file,TRUE);

  return 0;
}
  
  
