//  MaCoPiX = Mascot Construnctive Pilot for X
//                                (ActX / Gtk+ Evolution)
//    A unified desktop mascot program
//    for UNIX / X Window System with Gdk Environment
//
//  utils.c  : Utility function  for  MaCoPiX
//                                copyright K.Chimari 2002-4
//
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
// 
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
// 
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//

#include "main.h"

// Prototype of functions in this file
void copy_file();
void check_common_dir();

void copy_file(gchar *src, gchar *dest)
{
  FILE *src_fp, *dest_fp;
  gchar *buf;
  gint n_read;

  if(strcmp(src,dest)==0) return;
  
  buf=g_malloc0(sizeof(gchar)*1024);


  if ((src_fp = fopen(src, "rb")) == NULL) {
    g_print(_("Cannot open copy source file %s"),src);
    exit(1);
  }

  if ((dest_fp = fopen(dest, "wb")) == NULL) {
    g_print(_("Cannot open copy destination file %s"),dest);
    exit(1);
  }

  while (!feof(src_fp)){
    n_read = fread(buf, sizeof(gchar), sizeof(buf), src_fp);
    fwrite(buf, n_read, 1, dest_fp);
  }
  fclose(dest_fp);
  fclose(src_fp);

  chmod(dest, S_IRUSR|S_IWUSR|S_IRGRP|S_IROTH);

  g_free(buf);
}
 

void check_common_dir(void){
    struct stat st;

    if (access(COMMON_DIR, F_OK) == 0) {
	if (stat(COMMON_DIR, &st)<0){
	    fprintf(stderr,_("Cannot read status of directry %s .\n"),COMMON_DIR);
	    exit(1);
	}
	if (! S_ISDIR(st.st_mode)) {
	    fprintf(stderr,_("%s is not directory.\n"),COMMON_DIR);
	    exit(1);
	}
    }
    else{
	fprintf(stderr,_("Creating the common directory \"%s\"\n"),COMMON_DIR);
	mkdir(COMMON_DIR,(S_IRWXU|S_IRWXG|S_IRWXO));
	mkdir(COMMON_DIR PIXDIR,(S_IRWXU|S_IRWXG|S_IRWXO));
	mkdir(COMMON_DIR SOUNDDIR,(S_IRWXU|S_IRWXG|S_IRWXO));
    }

}
