/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/*MACMAIN.C******************************************************************/
#define EXTERN
/* EXTERN is defined null, so mage.h will do initial declarations */
/* the scope of definition is just this file, not defined for later files*/

#include "MAGE.h" /*which invokes include for MAGE.HDR */
/* MACMAIN.C is the ONLY file that defines EXTERN, */
           /* so declarations are idempotent */
/*include "MAGE.hdr" done in MAGE.h for subroutine prototypes*/
#include "MAGELIST.h"
#include "MAGEANGL.h"
#include "MAGEBBOX.h"
#include <SIOUX.h>   /*980701*/

#include "MAGEMENU.h"
#include "MAGETABL.h"

void adjustzoom(void);

/***** main *****************************************************************/
void    main()
{      
   /*980701*/
   /*CodeWarrior makes available their SIOUX console and menu options*/
   /*which MAGE exploits only for a convenient debug and errors console*/
   /*Howver, to use SIOUX at all, one must do some SIOUX tentkeeping*/
   /*see CodeWarrior Documentation/Library Doc/MSL C Ref.pdf pg 167-176*/
   /*NOTE: there is SIOUXHandleOneEvent() in Mage's HandleEvent() */
   SIOUXSettings.standalone = FALSE;
   SIOUXSettings.setupmenus = FALSE;
   SIOUXSettings.initializeTB = FALSE;

   mainsetup();  /* MACINIT.C */ /****initializecomputer*****/
        
   for (;;)
   {/*Master endless loop: program is event controlled*/
       HandleEvent();             /*MACMAIN.C*/
   }/*Master endless loop: program is event controlled*/
}
/*___main____________________________________________________________________*/
 
/****makecursorwait()**************************/
void    makecursorwait()  /*Mac specific */ /*m*/
{
    SetCursor(*waitcursor); /*m*/
    Lcursoractive = 0;
}
/*___makecursorwait()_________________________*/

/****makecursoractive()************************/
void    makecursoractive() /*Mac specific */ /*m*/
{
    switch(Ncursorchoice)  /*980804*/
    {
       case 0: 
          
          if(Ltexteditable) SetCursor(*texteditcursor);
          else if(Lflat) SetCursor(*xyscrollcursor);
          else if(Lhorizon) SetCursor(*yrotcursor);
          else SetCursor(*magecursor);/*m*/ 
          break;
       case 1: SetCursor(*planecursor);/*m*/ break;
       case 2: SetCursor(*shipcursor);/*m*/ break;
       case 3: SetCursor(*bunnycursor);/*m*/ break;
       default: SetCursor(*magecursor);/*m*/ break;
    }
    Lcursoractive = 1;
}
/*___makecursoractive()________________________*/
/****makecursorxyrot()**************************/
void    makecursorxyrot() /*Mac specific */ /*m*/
{
/*m*/    SetCursor(*xyrotcursor);
         Lcursoractive = 1;
}
/*___makecursorxyrot()_________________________*/
/****makecursorzrot()**************************/
void    makecursorzrot() /*Mac specific */ /*m*/
{
/*m*/    SetCursor(*zrotcursor);
         Lcursoractive = 1;
}
/*___makecursorzrot()_________________________*/
/****makecursorflatland()**************************/
void    makecursorflatland() /*Mac specific */ /*m*/
{
/*m*/    SetCursor(*flatlandcursor);
         Lcursoractive = 1;
}
/*___makecursorflatland()_________________________*/

/****makecursoredit()**************************/
void    makecursoredit()  /*Mac specific */ /*m*/
{
    SetCursor(*editcursor); /*m*/
    Lcursoractive = 1;
}
/*___makecursoredit()_________________________*/

/**** HandleMouseDown ***************************************************/
 /*    Take care of mouseDown events.*/ /*Mac specific */ /*m*/
void    HandleMouseDown(theEvent)
    EventRecord    *theEvent;
{
    WindowPtr    theWindow, oldPort;
    //int            windowCode,istarth,istartv,ireturn;/*980623*/
    int            windowCode,ireturn;/*980623*/

/*m*/    windowCode = FindWindow (theEvent->where, &theWindow);
    

    switch (windowCode)
    {
        case inSysWindow: 
/*m*/       SystemClick (theEvent, theWindow);
        break;
        
        case inMenuBar:
            HandleMenu(MenuSelect(theEvent->where)); /*MACMENU.C*/
            AdjustMenus(); /*MACMENU.C*/
        break;
        
        case inDrag:
/*m*/       DragWindow(theWindow, theEvent->where, &dragRect);
            if (theWindow == (WindowPtr)grafWindow) 
            {
/*m*/            GetPort(&oldPort);
/*m*/            SetPort(grafWindow);
/*m*/            DrawControls(grafWindow);
                 redrawvec();     /*MACDRAW.C*/
/*m*/            SetPort(oldPort);  
            }
        break;
            
        case inContent:
           {
                if (theWindow != FrontWindow())
/*m*/                SelectWindow(theWindow);
                else
                {
                    if (theWindow == (WindowPtr)grafWindow)
                    {
/*m*/                    SetPort(grafWindow);
                         DografContentClick( theEvent ); /*MACMAIN.C*/
                    }
                    if (theWindow == textWindow)
                    {
/*m*/                    SetPort(textWindow);
                         DotextContentClick( theEvent->where ); /*MACWIND.C*/
                    }
                    if (theWindow == captWindow)
                    {
/*m*/                    SetPort(captWindow);
                         DocaptContentClick( theEvent->where ); /*MACWIND.C*/
                    }
                    if (theWindow == tableWindow)
                    {
/*m*/                    SetPort(tableWindow);
                         DotableContentClick( theEvent->where ); /*MACWIND.C*/
                    }
                }
            }
        break;
          
        case inGoAway:
/*m*/       if (TrackGoAway(theWindow, theEvent->where))
            {
/*m*/           HideWindow(theWindow);
                AdjustMenus(); /*MACMENU.C*/
            }
        break;
        case inGrow:
            {
                growawindow(theWindow,theEvent->where);  /*MACWIND.C*/
            }
            break;
            case inZoomIn:
            {
                if (theWindow == grafWindow )
                {
/*m*/               GetPort(&oldPort);
/*m*/               SetPort(grafWindow);
/*m*/               MoveWindow(grafWindow,Gorigleft-RWIDTH,Gorigtop,1);
/*m*/               SizeWindow(grafWindow,Gorigright-(Gorigleft-RWIDTH),
                                                Gorigbottom-Gorigtop,0xff);
/*m*/               EraseRect(&grafWindow->portRect);
/*m*/               InvalRect(&grafWindow->portRect);
/*m*/               KillControls(grafWindow);
                    resizeGrafWindow(); /*MACINIT.C*/
                    if(Lkinfile)  /*a kinemage is present*/
                        SetsinGrafWindow(); /*MAGEBBOX.C*/
/*m*/               SetPort(oldPort);
                }
            }
            break;
            case inZoomOut:
            {
                if (theWindow == grafWindow )
                {
/*m*/               GetPort(&oldPort);
/*m*/               SetPort(grafWindow);
                    //980918
                    if(   (grafWindow->portRect.right - grafWindow->portRect.left) 
                        < (screenBits.bounds.right)
                        ||(grafWindow->portRect.bottom - grafWindow->portRect.top)
                        < (screenBits.bounds.bottom-38)  )
                    {
/*m*/                 MoveWindow(grafWindow,0,38,1);
/*m*/                 SizeWindow(grafWindow,screenBits.bounds.right,
                                                screenBits.bounds.bottom-38,0xff);
                    }
                    else
                    {
/*m*/                 MoveWindow(grafWindow,Gorigleft-RWIDTH,Gorigtop,1);
/*m*/                 SizeWindow(grafWindow,Gorigright-(Gorigleft-RWIDTH),
                                                Gorigbottom-Gorigtop,0xff);
                    }
                    //980918
/*m*/               EraseRect(&grafWindow->portRect);
/*m*/               InvalRect(&grafWindow->portRect);
/*m*/               KillControls(grafWindow);
                    ireturn = resizeGrafWindow();   /*MACINIT.C*/
                    if( !ireturn) ireturn = restoreGrafWindow(); /*MACINIT.C*/
                    if(ireturn)
                    {
                        if(Lkinfile) /*a kinemage is present*/
                            SetsinGrafWindow();  /*MAGEBBOX.C*/
                    }
                    else 
                    {
/*c*/                   sprintf(alertstr,"Failed to restore"
                            "offscreen bitmap! Goodbye...");
                        alertstr2[0]='\0';alertstr3[0]='\0';
                        DoMageDLOGreport(1); /*MACDLOG.C*/
/*c*/                   ExitToShell();
                    }

/*m*/               SetPort(oldPort);
                }
            }
            break;
    }
}
/*___ HandleMouseDown _______________________________________________________*/

/**** HandleEvent ********************************************************/
/*The main event dispatcher, called repeatedly by main, handles only one event.*/
void    HandleEvent()
{
    int           ok,i;
    EventRecord   theEvent;
    WindowPtr     theWindow, oldPort;

    OSErr         myErr;
    Boolean       SIOUXDidEvent;  /*980701*/
    
    static unsigned long nevents = 0;
    nevents++;
    
    HiliteMenu(0); /*m*/ 
    if(Lappleevents == 0) SystemTask();  /*m*/
             /* Handle desk accessories, use with GetNextEvent() */  

    if     (textWindow == FrontWindow() ) TEIdle(textText);
    else if(captWindow == FrontWindow() ) TEIdle(captText);

    if(Lappleevents==0) ok = GetNextEvent( everyEvent, &theEvent);          /*m*/
    else                ok = WaitNextEvent(everyEvent, &theEvent, 0xFFFF, nil); /*m*/
    
    if(ok)/*980701*/
    {
        SIOUXDidEvent = SIOUXHandleOneEvent(&theEvent);
    }
    if(ok && !SIOUXDidEvent)/*980701*/
    {/*ok*/

      switch (theEvent.what)   //980915 .what UInt16; .message UInt32
      {/*switch*/
        
        case osEvt:  //980915 operating system event
           switch ((theEvent.message >> 24) & 0x00FF)
           {/*osEvt switch*/
               case suspendResumeMessage:
                   if((theEvent.message & resumeFlag) == 0)
                   {
                       //printf("osEvt to suspend MAGE\n");
                       HiliteControl(vtextScroll,255); /*MACBAR*/
                       HiliteControl(vcaptScroll,255);  
                       HiliteControl(vgrafzoom,255); 
                       HiliteControl(vgrafzclip,255);
                       HiliteControl(vgrafztran,255);
                   }
                   else
                   {
                       //printf("osEvt to resume MAGE\n");
                       if (captWindow == FrontWindow()) 
                       {
                          HiliteControl(vcaptScroll,0); /*MACBAR*/
                       }
                       if (textWindow == FrontWindow()) 
                       {
                          HiliteControl(vtextScroll,0); /*MACBAR*/
                      }
                       if (grafWindow == FrontWindow()) 
                       {
                          HiliteControl(vgrafzoom,0); /*MACBAR*/
                          HiliteControl(vgrafzclip,0); 
                          HiliteControl(vgrafztran,0);
                       }
                   }
               break;
               case mouseMovedMessage:
                   ;
               break;
           }/*osEvt switch*/

        break;
        
        case kHighLevelEvent:
            if(Lappleevents)
            {
                // makecursorwait(); /*MACMAIN.C*/   //980916
                myErr = AEProcessAppleEvent( (EventRecord *)&theEvent );
                  /*calls std named handlers in MACFILE.C*/
                  /*HandleAEOpenDoc(),HandleAEQuitApp(),HandleAEIgnore()*/

            }
        break;
                         
        
        case mouseDown:
            if ((theEvent.modifiers & shiftKey) != 0)
                Lshiftkey = 1;
            else
                Lshiftkey = 0;

            if(Lcursoractive)
                HandleMouseDown(&theEvent); /*MACMAIN.C*/
        break;

        case mouseUp:
            if(Lcursoractive) makecursoractive(); /*MACMAIN.C*/
                /*if active, make sure is not a rotation cursor*/
        break;
                    
        case keyDown: 
          if(   Ltexteditable
             && (textWindow==FrontWindow()||captWindow==FrontWindow()) )
          {
            if ((theEvent.modifiers & cmdKey) != 0)
            {
               HandleMenu(MenuKey((char) (theEvent.message & charCodeMask)));
            }
            else if(textWindow == FrontWindow() )
            {
               TEKey(BitAnd(theEvent.message, charCodeMask),textText);
            }
            else if(captWindow == FrontWindow() )
            {
               TEKey(BitAnd(theEvent.message, charCodeMask),captText);
            }
            Lpruneactive = 1;
          }
          else
          {
            if ((theEvent.modifiers & shiftKey) != 0)
                Lshiftkey = 1;
            else
                Lshiftkey = 0;
                
            if ((theEvent.modifiers & cmdKey) != 0)
            {
                AdjustMenus(); /*MACMENU.C*/              /*MACMENU.C*/
                HandleMenu(MenuKey((char) (theEvent.message & charCodeMask)));
            }
            else  HandlekeyDown(&theEvent); /*MACMAIN.C*/
          }
        break;

        case keyUp: 
            if ((theEvent.modifiers & shiftKey) != 0)
                Lshiftkey = 0;
        
        case autoKey:
        break;
            
        case updateEvt:
             GetPort(&oldPort);                /*m*/
             SetPort(theWindow = (WindowPtr)theEvent.message); /*m*/
              BeginUpdate(theWindow);          /*m*/
              InvalRect(&theWindow->portRect); /*m*/
              if (theWindow == textWindow)
              {/*always keep visible text updated*/ /*990113*/
                     /*first set Scroll Bar, then text will clean up the absent*/
                     /*horizontal scroll area at the window bottom*/
                     settextScrollBar(); /*MACWIND.C*/
                     gettextTextarea();  /*MACWIND.C*/
                     settextTextarea();  /*MACWIND.C*/
                     HLock((Handle)textText);       /*m*/
                        TEActivate(textText);          /*m*/
                        TEUpdate(&textdRect,textText); /*m*/
                     HUnlock((Handle)textText);     /*m*/
                  if (textWindow == FrontWindow())  /*990113*/
                  {
                     if(!Ltextsize) 
                     {  /*there are no lines off window to scroll to*/
                        /* un-hilite scroll bar */
                        HLock((Handle)vtextScroll);     /*m*/ 
                          HiliteControl(vtextScroll,0);   /*m*/
                          HiliteControl(vtextScroll,255); /*m*/
                        HUnlock((Handle)vtextScroll);   /*m*/
                     }
                     else
                     {
                        ; /*scroll bar always highlighted by settextScrollBar()*/
                     }
                  }
                  else
                  {
                       /* un-hilite scroll bar */
                      HLock((Handle)vtextScroll);     /*m*/ 
                       HiliteControl(vtextScroll,0);   /*m*/
                       HiliteControl(vtextScroll,255); /*m*/
                      HUnlock((Handle)vtextScroll);   /*m*/
                  
                  }
                  ValidRect(&textWindow->portRect); /*m*/
                   /*tell window manager window is ok*/
              }
              if (theWindow == captWindow)
              {
                      setcaptScrollBar();      /*MACWIND.C*/  
                      getcaptTextarea();       /*MACWIND.C*/
                      setcaptTextarea();       /*MACWIND.C*/
                      HLock((Handle)captText); /*m*/
                      TEActivate(captText);     /*m*/
                      TEUpdate(&captdRect,captText); /*m*/
                      HUnlock((Handle)captText);     /*m*/

                  if (captWindow == FrontWindow())  /*990113*/
                  {
                      if(!Lcaptsize) 
                      {    /*there are no lines off window to scroll to*/
                           /* un-hilite scroll bar */
                           HiliteControl(vcaptScroll,255); /*m*/ 
                      }
                  }
                  else
                  {
                      /* un-hilite scroll bar */
                      HiliteControl(vcaptScroll,0);   /*m*/ 
                      HiliteControl(vcaptScroll,255); /*m*/ 
                  }
                  ValidRect(&captWindow->portRect); /*m*/ 
                  /*tell window manager window is ok*/
              }
              if (theWindow == (WindowPtr)grafWindow)
              {
                     if(Lzoom)  
                     {
                         hilitegrafcntlbar(&vgrafzoom);  /*MACBAR.C*/
                         writezoomvalue();
                     }
                     if(Lzclip) 
                     {
                         hilitegrafcntlbar(&vgrafzclip); /*MACBAR.C*/
                         writezclipvalue(izclipold[0]);/*970915*/
                     }
                     if(Lztran) 
                     {
                         hilitegrafcntlbar(&vgrafztran); /*MACBAR.C*/
                         writeztranvalue(iztranold[0]);/*970915*/
                     }                  
                     placewindowresizemark(); /*MACWIND.C*/
                     if(nbondrot > 0)
                     { 
                         for(i=1; i<=nbondrot; i++) 
                         { 
                           if(bondrotptr[i]->level > 0 || bondrotptr[i]->level== -1)
                           {/*independent rotation or first of a ganged set of rotations*/

                             hilitegrafcntlbar(&hgrafbondrot[i]);  /*MACBAR.C*/
                             writebondrotvalue(i);              
                           }
                         } 
                     } 
                  /*if (grafWindow == FrontWindow())*/ /*990113*/
                  {
                      SetsinGrafWindow(); /*MAGEBBOX.C*/
                      redrawvec(); /*MACDRAW.C*/
                  }
                  ValidRect(&grafWindow->portRect); /*m*/
                  /*tell window manager window is ok*/
              }
              if (theWindow == tableWindow)
              {
                  settableScrollBars();      /*MACWIND.C*/  
                      /*includes setting tableWindow clipRect */
                      /*includes (un)highlighting scroll bars*/
                  redrawtable();  /*____DRAW.c*/
                  ValidRect(&tableWindow->portRect); /*m*/ 
                  /*tell window manager window is ok*/
              }
              EndUpdate(theWindow); /*m*/
              SetPort(oldPort);     /*m*/
        break;

        case activateEvt:  /* mainly hilite scroll bars */
            theWindow = (WindowPtr)theEvent.message; /*m*/
                 GetPort(&oldPort);                  /*m*/
                 SetPort(theWindow = (WindowPtr)theEvent.message); /*m*/
                 BeginUpdate(theWindow);             /*m*/
                 InvalRect(&theWindow->portRect);    /*m*/
                 if (theWindow == textWindow)
                 {
                     settextScrollBar(); /*MACWIND.C*/
                 }
                 if (theWindow == captWindow) 
                 {
                     setcaptScrollBar(); /*MACWIND.C*/
                 }
                 if (theWindow == (WindowPtr)grafWindow) 
                 {
                    if(Lzoom)   hilitegrafcntlbar(&vgrafzoom);  /*MACBAR.C*/
                    if(Lzclip)  hilitegrafcntlbar(&vgrafzclip); /*MACBAR.C*/
                    if(Lztran)  hilitegrafcntlbar(&vgrafztran); /*MACBAR.C*/
                 }
                 if (theWindow == tableWindow) 
                 {
                     settableScrollBars(); /*MACWIND.C*/
                     /*includes setting tableWindow clipRect */
                     /*redrawtable();*/  /*____DRAW.c*/
                 }
                 EndUpdate(theWindow);
            SetPort(oldPort);
        break;

      }/*switch*/
     }/*ok*/ 
}
/*___ HandleEvent _______________________________________________________*/

/**** HandlekeyDown **********************************************************/
 /*    Take care of keyDown events.*/
void    HandlekeyDown(EventRecord    *theEvent)
{
        long charCode;
        float factor;
        
        charCode = BitAnd(theEvent->message, charCodeMask); /* ascii code */
//printf("charCode %ld\n",charCode);

        if(charCode==81) /* Q */
        {
            trytoquitMAGE();  /*____MENU.c*/
        }


        if( ((charCode==97)||(charCode==65)) & (nanimate > 1) ) 
        {/* press 'a' or 'A' to do animation*/
             adjustanimate(1); /*MAGEBBOX.C*/
             redrawvec();      /*MACDRAW.C*/
        }
        else if( ((charCode==98)||(charCode==66)) & (nnanimate > 1) ) 
        {/* press 'b' or 'B' to do animation*/
             adjustanimate(2); /*MAGEBBOX.C*/
             redrawvec();      /*MACDRAW.C*/
        }

        /* s toggles keepstereo */
        if(charCode==115 && !Lcompareon) 
        {
            Lkeepstereo = !Lkeepstereo;
            if(Lkeepstereo) Lstereo = 1;
            else            Lstereo = 0;
            resetmenuchecks(); /*MACMENU.C calls AdjustMenus();*/
            /*if(LTBstereo) SetsinGrafWindow();*/ /*970408*/
            if(LTBstereo) InvalRect(&grafWindow->portRect); /*m*//*970408*/
            redrawvec();       /*MACDRAW.C*/
        }

        /* t only can select thinline itself*/ /*981114*/
        if(charCode==116)
        {
            /*Lkeepthinline = !Lkeepthinline;*/ /*981114*/
            /*if(Lkeepthinline) Lthin = 1;*/ /*981114*/
            /*else              Lthin = 0;*/ /*981114*/
            Lthin = 1; /*981114*/
            Lonewidth = 0; /*981114*/
            Lmultiwidth = 0; /*981114*/
            resetmenuchecks();/*MACMENU.C calls AdjustMenus();*/
            redrawvec();      /*MACDRAW.C*/
        }

        /* p toggles perspective */ /*981114*/
        if(charCode==112)
        {
            /*Lkeepperspective = !Lkeepperspective;*/ /*981114*/
            /*if(Lkeepperspective) Lperspec = 1;*/ /*981114*/
            /*else                 Lperspec = 0;*/ /*981114*/
            Lperspec = !Lperspec; /*981114*/
            resetmenuchecks(); /*MACPMENU.C calls AdjustMenus();*/
            redrawvec();       /*MACDRAW.C*/
        }
        /* q toggles double-sized markers */ /*000804*/
        if(charCode==113)
        {
            Lscalemarkers = !Lscalemarkers;
            /*resetmenuchecks();no menu item yet*/ /*MACPMENU.C calls AdjustMenus();*/
            rescalekinemage();  /*MAGEINPT*/
            redrawvec();       /*MACDRAW.C*/
        }
        
        /* c toggles +,- stereo angle */
        if(charCode==99)
        {
            stereoangle = -stereoangle;
            redrawvec(); /*MACDRAW.C*/
        }
        /* d toggles dragline pick-up/new */
        if(charCode==100)
        {
            Ladddrag = !Ladddrag;
            redrawvec(); /*MACDRAW.C*/
        }

        /* k toggles kaleidoscope==plotonly mode */
        if(charCode==107)
        {
            setplotonly(); /*MAGEMENU.C*/ /*toggles kaleidoscope mode*/
        }
        
        /* l (el) toggles between point color and list color */
        if(charCode==108)
        {
           setlistcolordominance(); /*MAGEMENU.C*/
        }
        
        if(Lztran)
        {
            factor = 0.0;
            if(charCode==122) factor = +1.0;
                   /*press 'z' to do small step translate in +z*/
            if(charCode==90) factor = +10.0; 
                   /*press 'Z' to do big step translate in +z*/
            if(charCode==120) factor = -1.0;
                   /* press 'x' to do small step translate in -z*/
            if(charCode==88) factor = -10.0;
                   /* press 'X' to do big step translate iz*/
            if(factor > 0.01 || factor < -0.01)
            {
                fxcenternew = fxcenternew + factor*a13;
                fycenternew = fycenternew + factor*a23;
                fzcenternew = fzcenternew + factor*a33;                        
                rescalekinemage();  /*MAGEINPT.C*/
                redrawvec();        /*MACDRAW.C*/
            }
        }
        /* u invokes general update Dialog */
        if(charCode==117 && Lkinfile ) DoupdateDialog(); /*MAGEDLOG*/

        /* e toggles between Lens on and Lens off *//*971109*/
        if(charCode==101)
        {
           setLens(); /*MAGEMENU.C*/
        }

        /* f toggles scroll state, either xy rotations or xy tranlations */
        if(charCode==102)
        {
            setflat();
        }
        /* F invokes Find == search dialog */
        if(charCode==70 && Lkinfile)
        {
            DoSearchDialog(); /*MUXMDLOG*/
            /*redrawvec();*/ /*___DRAW.c*/
        }

        /* G invokes Find Again == search again for same strings */
        if(charCode==71 && Lkinfile)
        {
            DoSearchAgain(); /*MAGEUTIL*/
            /*redrawvec();*/ /*___DRAW.c*/
        }
        /* h toggles maintain horizon state, only y rotation*/
        if(charCode==104)
        {
            sethorizon();
        }

        /* m blanks measures lines & dots, does not remove old values */
        /*does disable measures operation, i.e. Lmeasureson==0, button==off*/
        /*but potentiates a new measures sequence for a new Lmeasureson==1*/
        /*effectively NOP if hit when measures button is off*/
        /*971204*/
        if(charCode==109)
        {
           potentiateMeasures(); /*MAGEMENU.C*/
        }

        /* n for +90 ninty*/  /*971104*/
        if(charCode==110)
        {
           getrot(157,0); /*MAGEDRAW*/
           redrawvec();
        }
        /* N for -90 Ninty*/  /*971104*/
        if(charCode==78)
        {
           getrot(-157,0); /*MAGEDRAW*/
           redrawvec();
        }

        if(nbondrot > 0)
        {
           /*<- one degree less of current bondrotation*/ /*970917*/
           if(charCode==28) grafbondrotarrow(-1.0);
           /*-> one degree more of current bondrotation*/ /*970917*/
           if(charCode==29) grafbondrotarrow(+1.0);
           /*-> plot current H vs V bondrot angles*/ /*970918*/
           if(LbondrotHplot > 0 && LbondrotVplot > 0 && charCode==31) 
              dobondrotplotter();
           /*-> graph current H vs V bondrot angles*/ /*001002*/
           if(LbondrotHplot > 0 && LbondrotVplot > 0 && charCode==30) 
              dobondrotgrapher();
        }


        if(charCode==49) /* 1 zooms by one unit*/
        {
           zoom = zoom +0.01;
           if(zoom > 10.04) zoom = 10.04;/*maximum*/
           adjustzoom();
        }
        if(charCode==50) /* 2 zooms by ten units*/
        {
           zoom = zoom +0.1;
           if(zoom > 10.04) zoom = 10.04;/*maximum*/
           adjustzoom();
        }
        if(charCode==51) /* 3 zooms by one unit*/
        {
           zoom = zoom -0.01;
           if(zoom < .04) zoom = .04;/*minimum*/
           adjustzoom();
        }
        if(charCode==52) /* 4 zooms by ten units*/
        {
           zoom = zoom -0.1;
           if(zoom < .04) zoom = .04;/*minimum*/
           adjustzoom();
        }

}
/*___HandlekeyDown()_________________________________________________________*/

/****adjustzoom()*************************************************************/
void adjustzoom()
{
   SetControlValue(vgrafzoom, (int)(zoom*(8192-32)/10) );
   scalenew = Scale*zoom;
   writezoomvalue();
   rescalekinemage();
   redrawvec();
}
/*___adjustzoom()____________________________________________________________*/

/******DografContentClick*****************************************************/
void    DografContentClick(EventRecord    *theEvent)
{       /*this stuff is handled in PC MAGE in MainWndProc() of MPCMAGE.C */
   Point            where;
   short            partcode, varyValue;
   ControlHandle    theControl;
   //int                 ion, next, ifind, jset, jlist,i,iflag,index;/*980623*/
   int                 ion, jset, jlist,i,iflag;/*980623*/
   int    lineshifted, shiftWorth, moveHeight, shiftPlace;
   int    maxValue,minValue,startValue,endValue;   /*over-rides for zclip range */        
   float    theta;


#ifdef __POWERPC__     //980917 
    ControlActionUPP zoomerupp,zcliperupp,ztranerupp,brotterupp; //980917   
#endif

#define HYPERTEXTTRANSFER
#ifdef HYPERTEXTTRANSFER
/*990923*/ TEHandle texthandle;
           Rect textdummyRect;
      textdummyRect.left      = -104; /*must be at least as large as*/
      textdummyRect.top       = -104; /*first character, i.e. 20 */
      textdummyRect.right     =   -4; /*for NOT visible text, set the*/
      textdummyRect.bottom    =   -4; /*dest rect off screen*/
#endif

    jset = 0;
    jlist = 0;
    where = theEvent->where;
    GlobalToLocal(&where);
    partcode = FindControl(where,grafWindow,&theControl);    
    HLock((Handle)theControl);
    if(partcode == kControlCheckBoxPart) /*980623*/
    {/*begin adjust display state */
        /*PC Mage buttons in case WM_COMMAND of MainWndProc() MPCMAIN.c*/
        /*MUX MAGE buttons in buttonscallback() in MUXMBBOX.c */
        /*PC and MUXM toggle buttons change their own state, Mac's don't */
        
        /*first: get the current toggle state of whoever got clicked */
        startValue = GetControlValue (theControl);/*980623*/
        if   (startValue == 1)    ion = 0;  /* toggle off-on */
        else                      ion = 1;
       
        //SetCtlValue(theControl, ion);  /* sets box X on or off*/ /*980623*/
        SetControlValue(theControl, ion);  /* sets box X on or off*/ /*980623*/
        /*during the scan through all boxes, unset those that never show X */
            
        /* beware: check boxes actually defined even when not created,*/
        /* so search by same hierarchy that created them */
        
        /*buttonboxscan((long)theControl, ion); */ /*980610 */   /*MAGEBBOX.c*/
        buttonboxscan((ControlHandle)theControl, ion); /*980610*/ /*MAGEBBOX.c*/

        redrawvec(); /*MACDRAW.c*/
        
    }/*endof adjust display state */
    
    else if(partcode == kControlIndicatorPart)/*980623*/
    {   /* track the thumb box */ /*values over-ride external*/
        if(theControl == vgrafzoom) {maxValue=8192;minValue=32;} 
                                  /*orig maxValue=8192;minValue=391; */
        else if(theControl == vgrafzclip) {maxValue=800;minValue=10;}
        else if(theControl == vgrafztran) {maxValue=500;minValue=-500;}
        else if(nbondrot > 0)  {maxValue = 360; minValue = 0;} /*981013*/
         startValue = GetControlValue (theControl);/*980623*/
         varyValue = TrackControl(theControl,where,NULL);
         endValue = GetControlValue(theControl);/*980623*/
         /* thumb box going up:   (startValue - endValue) positive */
         /* thumb box going down: (startValue - endValue) negative */
         lineshifted = (startValue - endValue);
         shiftWorth = lineshifted; /* integer arithmetic */
         shiftPlace = startValue - shiftWorth; /*compute new thumb setting*/
         if ((startValue - shiftWorth) <= minValue) shiftPlace = minValue;
         if ((startValue - shiftWorth) >= maxValue) shiftPlace = maxValue;
         if ((endValue - minValue) <= 1) shiftPlace = minValue;
         if ((maxValue - endValue) < 1) shiftPlace = maxValue; 
                                                 /*ware end state!*/
         moveHeight = lineshifted;
         SetControlValue(theControl, shiftPlace); /* move thumb *//*980623*/
         if(theControl == vgrafzoom)
         {
            zoom = shiftPlace/ ( (maxValue - minValue)/10.0 );/*970410*/
            writezoomvalue(); /*MACBAR.C*/
            scalenew = Scale*zoom;
            rescalekinemage(); /*MAGEINPT.C*/

         }
         else if(theControl == vgrafzclip)
         {
            izclipold[0] = shiftPlace;/*970915*/
            izclip = shiftPlace*fzclip;
            writezclipvalue(shiftPlace); /*MACBAR.C*/
         }
         else if(theControl == vgrafztran)
         {
            iztranold[0] = shiftPlace; /*970915*/
            iztran = shiftPlace*fzclip; /*970905*/
            writeztranvalue(shiftPlace); /*MACBAR.C*//*970915*/
         }
         else if(nbondrot > 0)
         {
            for(i=1; i<=nbondrot; i++)
            {
                if(theControl == hgrafbondrot[i]) 
                {
                    bondrotptr[i]->angle = bondrotptr[i]->angle + 180.0;
                    if(bondrotptr[i]->angle > 360) 
                        bondrotptr[i]->angle = bondrotptr[i]->angle - 360;
                    theta = ((float)shiftPlace - bondrotptr[i]->angle);/*981013*/
                    bondrotptr[i]->angle = (float)(shiftPlace - 180);/*981013*/

                    writebondrotvalue(i); /*MACBAR.C*/
/*------------------*/
                    /*some bondrot options substitute */
                    /*or do not require dobondrot()*/
                    if(bondrotptr[i]->option > 0 ) 
                        iflag = bondrotoptioner(i);/*MACBAR.c*/ /*981010*/
                    else iflag = 1;
                    
                    /*do bond rotation matrix update and apply */
                    if(iflag==1) dobondrot(i,theta);  /*MAGEANGL.C*/
                  else if(iflag==4) dodockrot(1,theta);
                  else if(iflag==5) dodockrot(2,theta);
                  else if(iflag==6) dodockrot(3,theta);
                  else if(iflag==7) dodocktran(1,theta);
                  else if(iflag==8) dodocktran(2,theta);
                  else if(iflag==9) dodocktran(3,theta);
                  else if(iflag==10) dogangrotscan(i,theta);
/*------------------*/
                    rescalekinemage();
                    break;
                }
            }
        }
        redrawvec(); /*MACDRAW.C*/
    }
    else if(partcode != 0)
    {/*not in the thumb, may be on scroll arrows, or track region*/
#ifdef __POWERPC__     //980917  ref same tracking routines in MACBAR.c
        zoomerupp  = NewControlActionProc(grafzoomer);
        zcliperupp = NewControlActionProc(grafzcliper);
        ztranerupp = NewControlActionProc(grafztraner);
        brotterupp = NewControlActionProc(grafbondrotter);

        if(theControl == vgrafzoom) 
            varyValue = TrackControl(theControl,where,zoomerupp);
        else if(theControl == vgrafzclip) 
            varyValue = TrackControl(theControl,where,zcliperupp);
        else if(theControl == vgrafztran) 
            varyValue = TrackControl(theControl,where,ztranerupp);
        else if(nbondrot > 0)
        {
            for(i=1; i<=nbondrot; i++)
            {
              if(theControl == hgrafbondrot[i]) 
              {
                varyValue = TrackControl(theControl,where,brotterupp);                                         
                break;
              }                        
            }
        }
#else     //980917  ref same tracking routines in MACBAR.c
        if(theControl == vgrafzoom) 
            varyValue = TrackControl(theControl,where,(ControlActionUPP)grafzoomer);
        else if(theControl == vgrafzclip) 
            varyValue = TrackControl(theControl,where,(ControlActionUPP)grafzcliper);
        else if(theControl == vgrafztran) 
            varyValue = TrackControl(theControl,where,(ControlActionUPP)grafztraner);
        else if(nbondrot > 0)
        {
            for(i=1; i<=nbondrot; i++)
            {
              if(theControl == hgrafbondrot[i]) 
              {
                varyValue = TrackControl(theControl,where,(ControlActionUPP)grafbondrotter);                                         
                break;
              }                        
            }
        }
#endif
    }/*not in the thumb, may be on scroll arrows, or track region*/
    
    else
    {/*begin mouse rotation*/  /*equivalent to PC WMLButtonDown() */
        ipick = 2;        
        mousexold = where.h;
        mouseyold = where.v;
        pickx = where.h;
        picky = where.v;
        if(Lflat)
        {/*flatland scrolling*/
            makecursorflatland();
            irotxy = 1;
        }
        else
        {/*3D rotations*/
            /*mouse at & below center does x,y rotations, near top edge does z*/
            if( picky > (GHEIGHT/6) )
            {
                irotxy = 1;
            }
            else
            {
                irotxy = 0;
            }
            if(irotxy==1) makecursorxyrot(); /*___MAIN.C*/
            else          makecursorzrot();  /*___MAIN.C*/
        }
        
        Drawgraf();  /*MACDRAW.C*/ /*tracks mouse movement*/
            /*the only place where this routine is called*/

        if(Lpick)
        {
            if(Lconstruct4on && Lpoint==4) /*971122*/
            { 
                DoconstructDialog(); /*MACDLOG.c*/
                /*this may not be the place for this since mouse movements*/
                /*could interfere with finishing the constructline */
                redrawvec(); /*MACDRAW.C*/
            }
            else if(Lconstruct5on && Lpoint==5)
            {
                DoConstructFifthDialog(); /*MAGEDLOG.c*/
                redrawvec(); /*MACDRAW.C*/
            }/*971122*/
            if(Lpickcoloron) DocolorshowDialog(); /*___DLOG.C*/
            if(Lpickshowon)  DopickshowDialog();  /*___DLOG.C*/
#ifdef HYPERTEXTTRANSFER
/*990923  for hypertextdialog ??????  pointID --> System Scrap*/ 
            /*get picked pointID into system scrap*/
            texthandle = TENew(&textdummyRect, &textdummyRect); /*m*/ 
            /*TESetText(comstr,comstr[0],texthandle);*/
            /*constr[256] should be a pascal string at this point*/
            recondition(comstr);
            TEInsert(comstr,sizeof(comstr),texthandle);
               /*sometimes hangs for 20 sec*/
            condition(comstr); /*get it back to pascal form*/
            TESetSelect(0,32767,texthandle);
            TECopy(texthandle);  /*copy to private clipboard*/
            ZeroScrap();  /*m*/ /*clear the system clipboard*/
            TEToScrap(); /*copy private clipboard to system clipboard*/
            TEDispose(texthandle);
#endif
        }
    }/*endof mouse rotation*/
    HUnlock((Handle)theControl);
}         
/*___DografContentClick______________________________________________________*/

/****countredraws()***********************************************************/
void    countredraws()
{
            Point iplace;
            int idelx,idely, Lnew;
            float    rate;
static        int xold,yold;
Handle  aHandle; //980920
long    Tlength; //980920
        
    Lnew = 1;            
    Lcount = 0;
    ncountticks = TickCount(); /*long*/
    icountticks = ncountticks; /*start with same number for both*/
        /*icountticks will be reset as get intermediates*/
    {
        /* not testing if mouse still down */
/*m*/        SetPort(grafWindow);
/*m*/        GetMouse(&iplace);
            if(Lnew)
            {/*establish mouse position at beginning of mouse down episode*/
                   Lnew = 0; 
                xold = iplace.h;
                yold = iplace.v;               
            }
            if (iplace.h != xold || iplace.h == xold)  /*always chosen*/
                /* simulate mouse has moved */
            {    /*begin-mouse has moved */
                /* get deltas and call for new rotation matrix */
                idelx = iplace.h - xold;
                idely = iplace.v - yold; 
                getrot(idelx,idely);    /*MAGEDRAW.C*/ 
                xold = iplace.h;
                yold = iplace.v;

                redrawvec(); /*MACDRAW.C*/ 

            }/*endof-mouse has moved */
    }
    postdrawticks = (TickCount() - icountticks);
    icountticks = TickCount();
    
    totalrunticks = (TickCount() - ncountticks);
    rate = 1.0/( totalrunticks/60.0 ) ;

    aHandle = TEGetText(textText);     //980920
    Tlength = GetHandleSize(aHandle);   //980920


         sprintf(alertstr,"timing in ticks = 1/60 sec: "
            "\015predraw = %ld, preloop = %ld"
            ",\015 firstloop = %ld, secondloop = %ld"
            ",\015 pastcopy = %ld, postdraw = %ld"
            " \015\015totalrun = %ld,                rate = %.3f per sec"
            ,predrawticks,preloopticks,firstloopticks,secondloopticks
            ,postcopyticks,postdrawticks,totalrunticks,rate
            );
         sprintf(alertstr2,   
            "\015\015number of 2-D move-draws = %ld, out of %ld triples "
            "\015 (text has %ld chars)"
            //,nmovedraws,nxyz,ntotaltext   //980920
            ,nmovedraws,nxyz,Tlength        //980920
            );
         alertstr3[0]='\0';
         DoMageDLOGreport(1); /*alertstr,alertstr2,alertstr3*/ /*___DLOG.C*/
}
/*___countredraws()__________________________________________________________*/

/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****getgrafmousexy()******************************************************/
void    getgrafmousexy() /*puts mouse coord into common mousex,mousey*/
{
    Point iplace;
        
/*m*/    SetPort(grafWindow);
/*m*/    GetMouse(&iplace);
        mousex = iplace.h;
        mousey = iplace.v;
}
/*___getgrafmousexy()_____________________________________________________*/

/****mousestilldown()****************************/
Boolean        mousestilldown()
{
    return(StillDown() );
}
/*___mousestilldown()___________________________*/

/****theclockcount()*****************************/
long    theclockcount()
{
    return( TickCount() );
}
/*___theclockcount()____________________________*/

/****keyanimate()************************************************************/
int   keyanimate()  /* check if key = 'a' or 'b' is pressed */
{
    int    ireturn;
    EventRecord    theevent;
    long charCode;
    
  /*get any keydown event, then delete it so it will be found only  once*/  
  if( GetNextEvent(keyDownMask,&theevent) )  
  {
        charCode = BitAnd(theevent.message, charCodeMask); /* ascii code */
        if( (charCode == 97) & (nanimate > 1) ) /* press 'a' to do animation*/
        {
             adjustanimate(1); /*MAGEBBOX.C*/ 
             ireturn = 1;
        }
        else if( (charCode == 98) & (nnanimate > 1) ) /* press 'b' to do animation*/
        {
             adjustanimate(2); /*MAGEBBOX.C*/
             ireturn = 1;
        }
        else if(nbondrot > 0 )
        {
           /*<- one degree less of current bondrotation*/ /*970917*/
           if(charCode==28) 
           {
              grafbondrotarrow(-1.0); /*MAGEANGL*/
              ireturn = 1;
           }
           /*-> one degree more of current bondrotation*/ /*970917*/
           if(charCode==29)
           {
              grafbondrotarrow(+1.0); /*MAGEANGL*/
              ireturn = 1;
           }
           if(charCode==31 && LbondrotHplot > 0 && LbondrotVplot > 0 ) 
           {/*down arrow plot 2 angles on screen fixed plot*/
              dobondrotplotter(); /*MAGEANGL*/
              ireturn = 1;
           }
           if(charCode==30 && LbondrotHplot > 0 && LbondrotVplot > 0 ) 
           {/*up arrow graph hit on 2D plot to 2 angle rotations*/
              dobondrotgrapher(); /*MAGEANGL*/
              ireturn = 1;
           }
        }
        /* e toggles between Lens on and Lens off *//*971109*/
        if(charCode==101)
        {
           setLens(); /*MAGEMENU.C*/
        }

        else ireturn=0;
  }  
  else ireturn=0;
  return(ireturn);
}
/*___keyanimate()___________________________________________________________*/

/****emptyeventque()*********************************************************/
void    emptyeventque()   /*get rid of extra key strokes accummulated */
{
/*m*/    FlushEvents(everyEvent, 0); 
}
/*___emptyeventque()________________________________________________________*/

/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/

/****condition()*************common name: MAC & PC*****/
void    condition(char chstr[256])
{
/*m*/    CtoPstr(chstr);
}
/*___condition()______________________________________*/

/****recondition()*************common name: MAC & PC*****/
void    recondition(char chstr[256])
{
/*m*/    PtoCstr((unsigned char *)chstr);
}
/*___recondition()______________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/

/****waste()*******************************************************************/
void waste(long nsec)
{
   long ticksatstart; /*timing in ticks = 1/60 sec:*/
   int j;
   ticksatstart = theclockcount(); /*from last startup, good for ~1 year*/
   while( (theclockcount() - ticksatstart) < 60*nsec)
   {
      for(j=-32000; j<32000; j++) 
         ;/*waste a little time*/
   }
   
}
/*___waste()__________________________________________________________________*/
