/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/*MACDRAW.c*/
#include "MAGE.h"
#include "MAGELIST.h"
#include "MAGETABL.h"


/**** SetUptableWindow() *****************************************************/
void    SetUptableWindow()
{
    int tablewinleft, tablewintop, tablewinright, tablewinbottom;
  Rect            vTScrollRect,hTScrollRect;
  int maxWide = 0; /*tablewide*/
  int maxHigh = 0; /*tablehigh*/
    
    /* set up on-screen table window */
    dragRect = screenBits.bounds;
    
    tablewinleft = BORDER;
    
    if(screenBits.bounds.bottom > GHEIGHT+CHEIGHT+TOPBAR+MIDBAR+BOTTOMBAR)
       tablewinbottom            = GHEIGHT+CHEIGHT+TOPBAR+MIDBAR+BOTTOMBAR;
    else 
       tablewinbottom = screenBits.bounds.bottom - BOTTOMBAR;
    
    tablewintop = tablewinbottom - CHEIGHT;
    
    if(screenBits.bounds.right > (TWIDTH+GWIDTH+BWIDTH+ZWIDTH+RWIDTH+MARGIN+BORDER) )
       tablewinright            = (TWIDTH+GWIDTH+BWIDTH+ZWIDTH+RWIDTH+BORDER);
    else 
       tablewinright = screenBits.bounds.right - MARGIN - BORDER;
    
    SetRect( &windowBounds,
            tablewinleft,    tablewintop,
            tablewinright,    tablewinbottom );/*m*/


    if(Lcolor)
    {/*color*/
        tableWindow = NewCWindow( 0L, &windowBounds, "\pKINEMAGE Table"
             , true,zoomDocProc, (WindowPtr)-1L, false, 0 );/*m*/
    }/*color*/
    else
    {/*Black & White*/
       tableWindow = NewWindow( 0L, &windowBounds, "\pKINEMAGE Table"
            , true, documentProc, (WindowPtr)-1L, false, 0);/*m*/
    }/*Black & White*/


    SetPort(tableWindow);/*m*/
        
  maxWide = 10000;
  maxHigh = 10000;
    /* define vertical scroll bar */
    SetRect(&vTScrollRect,  (*tableWindow).portRect.right-15,
                            (*tableWindow).portRect.top-1,
                            (*tableWindow).portRect.right+1,
                            (*tableWindow).portRect.bottom-14);/*m*/
    vtableScroll = NewControl(tableWindow,&vTScrollRect,"\p",true,
                                    //minValue,minValue,maxValue,
                                    0,0,
                                    maxHigh,
                                    scrollBarProc,2);/*m*/
    /* define vertical scroll bar */
    SetRect(&hTScrollRect,  (*tableWindow).portRect.left,
                            (*tableWindow).portRect.bottom-15,
                            (*tableWindow).portRect.right-14,
                            (*tableWindow).portRect.bottom+1);/*m*/
    htableScroll = NewControl(tableWindow,&hTScrollRect,"\p",true,
                                    //minValue,minValue,maxValue,
                                    0,0,
                                    maxWide,
                                    scrollBarProc,1);/*m*/
        
        
    HLock((Handle)MagePalette);

       SetPalette(tableWindow,MagePalette,TRUE); /*m*/ 
       ActivatePalette(tableWindow); /*m*/
    HUnlock((Handle)MagePalette);

    /*Table probably need its own font controls*/
    
}
/*___SetUptableWindow()______________________________________________________*/

/****createtablescrollbars()**************************************************/
void createtablescrollbars(void)
{
;
}
/*___createtablescrollbars()_________________________________________________*/


/******tableScroller*********************************************************/
pascal void    tableScroller(ControlHandle theControl,short partcode)
{
    /*theControl should have been locked by calling routine */
    int tablesize=0,tablewindowsize=0,tableinterval=0,tableoutsize=0;
    int tableoffset=0; /*offset of absolute table zero coord*/

    int oneStep=0, imove=0;
    int maxValue =10000, minValue =0;/*std set values at ends of scroll bar*/
    int onePage = 0; /*measure of the part of table seen in the window*/
    int extraSteps = 0; /*measures that part of table not seen in window*/
    int startValue = GetControlValue(theControl); /*starting place of thumb*/
    int shiftPlace; /*resulting place of thumb*/
/*
         #    #<- tableoffset
         #
         #
         #
       * #  *<- tableoffset
       * #
       * #
       * #
       * #
       * #
       * #
-------*0#------                 = <- 0
-------* #                       =
-------* #                       = *<- shiftPlace
-------* #                       =
-------* #                       =
-------* #                       =
-------* #                       = #<- shiftPlace
-------* #                       =
-------* #                       =
-------*-#-tablewindowsize  --   = <- maxValue
-------* #                  --
-------* #                  --
-------* #                  --
-------* #                  --
-------* #                  --
-------* #                  --
-------* #                  --
-------*                    --
-------*                    --
-------*                    --
-------*                    --
-------                     --
-------                     --
-------                     --
-------                     --
-------                     --
-------                     --
---------tablesize          ----tableoutsize
*/
/* tableoutsize = tablesize - tablewindowsize */
/*         table in pixels         :: Scroll Bar Window in units to maxValue*/
/* tableoffset     : tableoutsize  :: shiftPlace: maxValue  */
/* tableoutsize    : tableinterval :: maxValue  : oneStep   */
/* tablewindowsize : tableinterval :: onePage   : oneStep   */
/* tablewindowsize : tableoutsize  :: onePage   : maxValue  */
/* (tablewindowsize/tableoutsize)  ==   (onePage/maxValue)  */    

/* 1 - (tablewindowsize/tableoutsize) ==  1 - (onePage/maxValue) */    

/* (tableoutsize-tablewindowsize)/tableoutsize == (maxValue-onePage)/maxValue*/
/*                 tableextra/tableoutsize    ==    extraSteps/maxValue      */
/* extraSteps = maxValue*tableextra/tableoutsize */
/* extraSteps = maxValue*(tableoutsize - tablewindowsize)/tableoutsize  */
    if(theControl == vtableScroll)
    {
       tablesize = tablehigh; /*full table size in this direction*/
       tablewindowsize 
         = (*tableWindow).portRect.bottom - (*tableWindow).portRect.top - 22;
       tableinterval = tablerowheight; /*all rows== height of last, except #0*/
    }
    else /*htableScroll*/
    {
       tablesize = tablewide; /*full table size in this direction*/
       tablewindowsize 
         = (*tableWindow).portRect.right - (*tableWindow).portRect.left - 22;
       tableinterval = tablecolwidth; /*all cols== width of last, except #0 */
    }
    tableoutsize = tablesize - tablewindowsize;

    oneStep = maxValue*tableinterval/tableoutsize;
    onePage = tablewindowsize*oneStep/tableinterval;
    extraSteps = maxValue*(tableoutsize - tablewindowsize)/tableoutsize; 
    
    imove = 0;
    shiftPlace = startValue; /*on basis of minValue to maxValue: 10000*/
      switch(partcode)
      {
         case kControlUpButtonPart:
           if (startValue > minValue)
           {
             if(tableoutsize > 0)
                 shiftPlace = startValue -oneStep;
             if( shiftPlace < minValue) shiftPlace = minValue;
           }
           break;
         case kControlPageUpPart:
           if (startValue > minValue)
           {
             if(startValue >= onePage)
                 shiftPlace = startValue - onePage;
             else  shiftPlace = minValue;
             if( shiftPlace < minValue) shiftPlace = minValue;
           }
           break;
         case kControlDownButtonPart:
           if (startValue < maxValue)
           {
             if(tableoutsize > 0)
                 shiftPlace = startValue +oneStep;
             if( shiftPlace > maxValue) shiftPlace = maxValue;
           }
           break;
         case kControlPageDownPart:
           if (startValue < maxValue)
           {
             if(maxValue - startValue >= onePage)
                 shiftPlace = startValue + onePage;
             else  shiftPlace = maxValue;
             if( shiftPlace > maxValue) shiftPlace = maxValue;
           }
           break;
      }
    if((tablesize-tablewindowsize) > 0)
    {/*something offscreen to scroll to, set zero point of table*/
     /*ratio of slider space == shiftPlace/maxValue*/
     /* tableoffset     : tableoutsize     :: shiftPlace: maxValue  */

        tableoffset  = -tableoutsize*shiftPlace/maxValue;
    }
    if(tableoffset > 0) tableoffset = 0;/*offset of absolute table zero coord*/

    if(shiftPlace == minValue) tableoffset = 0;
    else if(shiftPlace == maxValue)
    { 
         if((tablesize - tablewindowsize) > 0)
             tableoffset = -(tablesize-tablewindowsize);
         else tableoffset = 0;
    }
    if(theControl == vtableScroll)
    {
       tablezerohigh = tableoffset;
    }
    else /*htableScroll*/
    {
       tablezerowide = tableoffset;
    }
    redrawtable();

    SetControlValue(theControl, shiftPlace); /* move thumb */
}
/*___tableScroller__________________________________________________________*/
 
/******settableScrollBars*******************************************************/
void    settableScrollBars()
{     /*includes setting tableWindow clipRect */
    Rect            ScrollRect;

   tablewindowhigh
       = (*tableWindow).portRect.bottom - (*tableWindow).portRect.top - 22;
   tablewindowwide
       = (*tableWindow).portRect.right - (*tableWindow).portRect.left - 22;
   
   SetRect(&ScrollRect,(*tableWindow).portRect.left,
                       (*tableWindow).portRect.top,
                       (*tableWindow).portRect.right,
                       (*tableWindow).portRect.bottom);/*m*/
   ClipRect(&ScrollRect); /*current port should be == tableWindow*/
    
    HLock((Handle)vtableScroll);
    HLock((Handle)htableScroll);

        SetRect(&ScrollRect,(*tableWindow).portRect.right-15,
                            (*tableWindow).portRect.top-1,
                            (*tableWindow).portRect.right+1,
                            (*tableWindow).portRect.bottom-14);/*m*/
        (**vtableScroll).contrlRect = ScrollRect;
        SetRect(&ScrollRect,(*tableWindow).portRect.left,
                            (*tableWindow).portRect.bottom-15,
                            (*tableWindow).portRect.right-14,
                            (*tableWindow).portRect.bottom+1);/*m*/
        (**htableScroll).contrlRect = ScrollRect;
    
        DrawControls(tableWindow);
        DrawGrowIcon(tableWindow);

    if (tableWindow != FrontWindow())  
    {/* un-hilite scroll bars if window not front */
        HiliteControl(vtableScroll,255);
        HiliteControl(htableScroll,255);
    }
    else  /* hilite scroll bars of front window, and redo scroll bar */
    {

        if((tablehigh - tablewindowhigh) < 0) 
        {    /*there are no rows off window to scroll to*/
             /* un-hilite scroll bar */
             HiliteControl(vtableScroll,255); /*m*/ 
             tablezerohigh = 0; /*reset table origin*/
        }
        else HiliteControl(vtableScroll,0); /*m*/ 
        
        if((tablewide - tablewindowwide) < 0) 
        {    /*there are no cols off window to scroll to*/
             /* un-hilite scroll bar */
             HiliteControl(htableScroll,255); /*m*/ 
             tablezerowide = 0; /*reset table origin*/
        }
        else HiliteControl(htableScroll,0); /*m*/ 
    }
    HUnlock((Handle)vtableScroll);
    HUnlock((Handle)htableScroll);


}
/*___settableScrollBars()_____________________________________________________*/

/****gettablewinedges()*******************************************************/
void gettablewinedges(int* left, int* top, int* right, int* bottom)
{
   *left  = (*tableWindow).portRect.left;
   *top   = (*tableWindow).portRect.top;
   *right = (*tableWindow).portRect.right;
   *bottom= (*tableWindow).portRect.bottom;
}
/*___gettablewinedges()_____________________________________________________*/

/******DotableContentClick()***************************************************/
void    DotableContentClick(Point    where)
{
   ControlHandle    theControl;
   long   direction;
   short  partcode, varyValue;
   int    movePlace, shiftPlace;
#ifdef __POWERPC__  
    ControlActionUPP cscrollerupp; 
#endif
  
   int  maxValue=10000;
   int  minValue = 0;
   int  startValue=0, endValue=0;
   int  tablesize, tablewindowsize;
   int Nblank = 0; /*000410*/
   
   GlobalToLocal(&where);
   partcode = FindControl(where,tableWindow,&theControl);
   HLock((Handle)theControl);
   if(partcode != 0)
   {/*click was in an active scroll bar*/
    if(theControl == vtableScroll)
    {
       tablesize = tablehigh;
       tablewindowsize 
         = (*tableWindow).portRect.bottom - (*tableWindow).portRect.top - 16;
    }
    else if(theControl == htableScroll)
    {
       tablesize = tablewide;
       tablewindowsize 
         = (*tableWindow).portRect.right - (*tableWindow).portRect.left - 16;
    }
    if(partcode)  {direction = GetControlReference(theControl);}
    if(partcode == kControlIndicatorPart)
    {/* track the thumb box */
         startValue = GetControlValue (theControl);
         varyValue = TrackControl(theControl,where,NULL);
         endValue = GetControlValue(theControl);

         shiftPlace = endValue;
         if(shiftPlace > maxValue) shiftPlace = maxValue;
         else if(shiftPlace < minValue) shiftPlace = minValue;
         
         if((tablesize-tablewindowsize) > 0)
         {/*something offscreen to scroll to*/
            movePlace =
               -((tablesize-tablewindowsize)*(endValue-minValue))
                /(maxValue-minValue);
         }
         if(movePlace < -(tablesize-tablewindowsize) ) 
            movePlace = -(tablesize-tablewindowsize);
         else if(movePlace > 0) movePlace = 0;
         
         if(shiftPlace == minValue) movePlace = 0;
         else if(shiftPlace == maxValue)
         {  
            if((tablesize - tablewindowsize) > 0)
               movePlace = -(tablesize-tablewindowsize);
            else movePlace = 0;
         }
         SetControlValue(theControl, shiftPlace); /* move thumb */
         if(theControl == vtableScroll)
         {
            tablezerohigh = movePlace;
         }
         else
         {
            tablezerowide = movePlace;
         }
         redrawtable();
    }/* track the thumb box */
    else if(partcode != 0) 
    {/* not in the thumb, may be on scroll arrows, or region*/
#ifdef __POWERPC__     //980917  ref same tracking routines in MACWIND.c
      cscrollerupp  = NewControlActionProc(tableScroller);
      varyValue = TrackControl(theControl,where,cscrollerupp);
#else
      varyValue=TrackControl(theControl,where,(ControlActionUPP)tableScroller);
#endif
    }/* not in the thumb, may be on scroll arrows, or region*/
   }/*click was in an active scroll bar*/
   else 
   {/*may be a click within the table itself*/
      tablepickx = where.h;
      tablepicky = where.v;
      Ltablepicked = 2; /*lurk for a pick*/
      Ltablecellnewlypicked = 0; /*communicate back to calling routine*/
      redrawtable();
         
      /*if(Ltablepicked==1 && Ltablecellnewlypicked==1)*/
      if(Ltablepicked==1)
      {/*table initiated pick of a cell*/
         /*tabletographics always active in this direction*/
#ifdef OLDPICKBYCOORDCODE
           pickx = -32000; /*set graphics mouseposition to something absurd*/
           picky = -32000; /*since we are going to invoke the */
           ipick = 2; /* regular picking mechanism with a known pickpoint */
           Lpick = 1; /* and depend on it not getting a valid graphics pick*/
                      /* which would override the previous known point*/
           redrawvec(); /*establishes where pick is*/
           redrawvec(); /*need another update of graphics to do pick effect*/
           /*finished operations on the graphics window*/
           /*all table initiated operations done*/
#endif /*OLDPICKBYCOORDCODE*/
#ifdef NEVERPICKDONEONEBYONE
          /*invoke FIND with the cell's point ID,*/
          /*both table and graphics use same global pickedpointptr*/
          getptIDstring(search1str, pickedpointptr); /*MAGELIST.c*/
          for(isearch1=0;isearch1<256;isearch1++)
          {
             if(search1str[isearch1]==' ') Nblank++; /*000410*/
             if(search1str[isearch1]=='\0') break;
          }/*isearch1 is size of pointID str*/  
          if(isearch1 == Nblank) isearch1 = 0;  /*000410*/
          search2str[0] = '\0';
          isearch2 = 0;
          /*DoSearchDialog();*/ /*MACDLOG.c --> MAGEDLOG.c --> MAGEUTIL.c/mysearchpointID()*/
          Lsearchbegin = 1;
          if(isearch1 > 0) /*000410*/
             mysearchpointID(1); /*MAGEUTIL.c for justone hit*/
#endif /*NEVERPICKDONEONEBYONE*/
          if(Ltablemarkers) removetablemarkpoints();
          markfromtablecellsID(1); /*MAGETABL.c flag==1 for ptID matching*/  

          redrawvec(); /*establishes where pick is*/
          Ltablepicked = 0; /*used in MAGEDRAW.c/drawvec()*/
          Ltablecellnewlypicked = 0;
      }/*table initiated pick of a cell*/
   }/*may be a click within the table itself*/
   Ltablepicked = 0;
   Ltablecellnewlypicked = 0;
   HUnlock((Handle)theControl);
}
/*___DotableContentClick()__________________________________________________*/

/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/

/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/

/****stringtotable()**********************common name: MAC & PC**************/
void    stringtotable(char string[256],int ix,int iy,int icolor)
{/*presumes SetPort(tableWindow);*/
   MoveTo(ix,iy); /*m*/
   if(Lcolor) 
   {
        PmForeColor(icolor); /*m*/ /*uses MAGE palette*/
   }
   else PmForeColor(0);   /* black */ /*m*/
   TextSize(infofontsize);
   condition(string); /*4_7x:stored now aways unconditioned*/
   DrawString((unsigned char *)string); /*m*/
   TextSize(oldfontsize);
}
/*___stringtotable__________________________________________________________*/

/****wordstotable()************************common name: MAC & PC*************/
int wordstotable(char commentstr[256],int ix,int iy,int icolor,int bcolor,int ipass)
{/*presumes SetPort(tableWindow);*/ 

   int   j,k,kk,oldright,newright,maxright,cellleft,width,Lbkg,Lembedded;
   short Thisfont,Thissize,Thisface,myfont,linehigh;
   
   ipass = ipass; /*instead of if(ipass != 0) before each DrawText() call*/
   if(icolor >= 0 && icolor <= 255)
   {/*within 256 palette: a visible color*/
      if(Ltablecellgetwidth || Ltablecellispicked)
           Lbkg = 1; 
      else Lbkg = 0;
   
      MoveTo(ix,iy); /*Mac move to absolute coords, Move(x,y) is to relative x,y*/
   
      /*MAGE should already have adjusted icolor & bcolor for Lcolor or B&W*/
      PmForeColor(icolor); /*m*/ /*uses MAGE palette*/
    
      if(commentstr[3] != '\0') 
      {/*string longer than zero length*/
         Thisfont = commentstr[0];
         Thisface = commentstr[1];
         Thissize = commentstr[2];

         TextSize(tablefontsize); /*m*/ /*for table window*/
         TextFace(0); /*m*/
         TextFont(0); /*m*/
         myfont = 0;
         if(Thisfont != 0) {myfont=Thisfont; TextFont(Thisfont);} /*m*/
         if(Thisface != 0) TextFace(Thisface); /*m*/
         if(Thissize != 0) TextSize(Thissize); /*m*/

         linehigh = tablefontsize;
         
         Lembedded = 0;
         width = 0;
         maxright = oldright = newright = cellleft = ix;
         k = 3;
         for(j=3;j<=255;j++)
         {/*loop over all characters in the string*/

           if(   Lembedded==1 
              && (!(Lsuperpick && Ltablecellispicked)
                 || (Ltablecellgetwidth) ) )
           {
              if(commentstr[j]=='>')
              {
                  k = j+1;
                  Lembedded = 0;
              }
           }
           else
           {/*accept this character*/
             kk = j;
             if(commentstr[j]=='\\')
             {
                  if(Lbkg) 
                  {/*bkg rectangle from previous right side to new right edge*/
                     width = TextWidth(commentstr,k,kk-k);
                     newright = oldright + width;
                     if(maxright < newright) maxright = newright;
                     PmForeColor(bcolor);
            rectangletoscreen(oldright, iy-linehigh, newright,iy, bcolor);
                     oldright = newright;
                     PmForeColor(icolor);
                  }
                 DrawText(commentstr,k,kk-k); /*clean out earlier*/
                 TextFont(23);

                  if(Lbkg) 
                  {/*bkg rectangle from previous right side to new right edge*/
                     width = TextWidth(commentstr,j+1,1);/*the symbol*/
                     newright = oldright + width;
                     if(maxright < newright) maxright = newright;
                     PmForeColor(bcolor);
            rectangletoscreen(oldright, iy-linehigh, newright,iy, bcolor);
                     oldright = newright;
                     PmForeColor(icolor);
                  }

                 DrawText(commentstr,j+1,1);/*draw symbol*/
                 TextFont(myfont);
                 j=j+1;
                 k=j+1;
                 /*kk  set after j augmented by loop*/
             }
             else if(commentstr[j]=='\015') 
             {
                  if(Lbkg) 
                  {/*bkg rectangle from previous right side to new right edge*/
                     width = TextWidth(commentstr,k,kk-k+1);
                     newright = oldright + width;
                     if(maxright < newright) maxright = newright;
                     PmForeColor(bcolor);
            rectangletoscreen(oldright, iy-linehigh, newright,iy, bcolor);
            /*rectangletoscreen must leave pen at lower left == oldright,iy */
                     oldright = newright = cellleft;
                     PmForeColor(icolor);
                  }
                  /*if k==kk EOL is only char to be printed, which it does!*/
                  DrawText(commentstr,k,kk-k+1);
                  MoveTo(ix,iy = (iy + linehigh));
                  k = j+1  ;
             }
             else if(commentstr[j]=='{' /*}*/) 
             {
                  kk = j-1;
                  if(Lbkg) 
                  {/*bkg rectangle from previous right side to new right edge*/
                     width = TextWidth(commentstr,k,kk-k+1);
                     newright = oldright + width;
                     if(maxright < newright) maxright = newright;
                     PmForeColor(bcolor);
            rectangletoscreen(oldright, iy-linehigh, newright,iy, bcolor);
            /*rectangletoscreen must leave pen at lower left == oldright,iy */
                     iy = iy + linehigh/3; /*keep box in sync with pen*/
                     oldright = newright;
                     PmForeColor(icolor);
                  }
                  DrawText(commentstr,k,kk-k+1);
                  Move(0, + linehigh/3); /*presume downs==ups before bkg drawn*/
                  k = j+1;
             }
             else if(/*{*/ commentstr[j]=='}')
             {
                  kk = j-1;
                  if(Lbkg) 
                  {/*bkg rectangle from previous right side to new right edge*/
                     width = TextWidth(commentstr,k,kk-k+1);
                     newright = oldright + width;
                     if(maxright < newright) maxright = newright;
                     PmForeColor(bcolor);
            rectangletoscreen(oldright, iy-linehigh, newright,iy, bcolor);
                     iy = iy - linehigh/3; /*keep box in sync with pen*/
                     oldright = newright;
                     PmForeColor(icolor);
                  }
                  DrawText(commentstr,k,kk-k+1);
                  Move(0, - linehigh/3); /*presume downs==ups before bkg drawn*/
                  k = j+1;
             }
             else if(commentstr[j]=='<')
             {
                  kk = j-1;
                  if(Lbkg) 
                  {/*bkg rectangle from previous right side to new right edge*/
                     width = TextWidth(commentstr,k,kk-k+1);
                     newright = oldright + width;
                     if(maxright < newright) maxright = newright;
                     PmForeColor(bcolor);
            rectangletoscreen(oldright, iy-linehigh, newright,iy, bcolor);
            /*rectangletoscreen must leave pen at lower left == oldright,iy */
                     oldright = newright;
                     PmForeColor(icolor);
                     Ltableextrapass = 1; /*< here means extra in a picked cell*/
                  }
                  DrawText(commentstr,k,kk-k+1);
                  k = j+1;
                  Lembedded = 1;
                     
             }
             else if(commentstr[j]=='>')
             {
                  kk = j-1;
                  if(Lbkg) 
                  {/*bkg rectangle from previous right side to new right edge*/
                     width = TextWidth(commentstr,k,kk-k+1);
                     newright = oldright + width;
                     if(maxright < newright) maxright = newright;
                     PmForeColor(bcolor);
            rectangletoscreen(oldright, iy-linehigh, newright,iy, bcolor);
            /*rectangletoscreen must leave pen at lower left == oldright,iy */
                     oldright = newright;
                     PmForeColor(icolor);
                  }
                  DrawText(commentstr,k,kk-k+1);
                  k = j+1;
                  Lembedded = 0;
             }
             else if(commentstr[j] == '\0')
             {
                 break;
             }
           }/*accept this character*/
         }/*loop over all characters in the string*/
         if(k<kk)
         {/*reached end of string, finish out anything still to be written*/
                  if(Lbkg) 
                  {/*bkg rectangle from previous right side to new right edge*/
                     width = TextWidth(commentstr,k,kk-k);
                     newright = oldright + width;
                     if(maxright < newright) maxright = newright;
                     PmForeColor(bcolor);
            rectangletoscreen(oldright, iy-linehigh, newright,iy, bcolor);
                     oldright = newright;
                     PmForeColor(icolor);
                  }
             DrawText(commentstr,k,kk-k);
         }
         TextFont(0); /*system font*/
         TextFace(0); /*normal*/
         TextSize(oldfontsize);
            
         if(tablewordwidth < maxright-cellleft)
         {
            tablewordwidth = maxright-cellleft;
         }
      }/*string longer than zero length*/
   }/*within 256 palette: a visible color*/
   return(iy); /*latest y coord used*/
}
/*___wordstotable()__________________________________________________________*/

/****rectangletoscreen()******************************************************/
void rectangletoscreen(int left,int top,int right,int bottom, int color)
{
    PolyHandle shape;
  
    PmForeColor(color);
    
    shape = OpenPoly();
      MoveTo(left,bottom);
      LineTo(right,bottom);
      LineTo(right,top);
      LineTo(left,top);
      LineTo(left,bottom);
    ClosePoly();
    PaintPoly(shape);
    KillPoly(shape);
}
/*___rectangletoscreen()_____________________________________________________*/

/****redrawtable()*****************common name: MAC & PC*********************/
void    redrawtable()
{

      dodrawtable(1);

      if(Ltablepicked>0 || Ltablegraphpicked>0) 
      {/*pick invoked call needs second pass to show full state of picks*/
         dodrawtable(1); /*put flag on picked cell(s) only*/
         /*finished operations on the table*/
         /*all graph initiated operations done*/
         Ltablegraphpicked = 0;
         /*but still may have table initiated operations to pass to graph*/
         /*Ltablepicked is the flag for table to graph picking*/
      }
}
/*___redrawtable()__________________________________________________________*/

/****dodrawtable()*****************common name: MAC & PC*********************/
void    dodrawtable(int ipass)
{
static        Rect theRect;
   SetRect(&theRect,  (*tableWindow).portRect.left,
                      (*tableWindow).portRect.top,
                      (*tableWindow).portRect.right,
                      (*tableWindow).portRect.bottom);/*m*/


   SetPort(tableWindow); /*m*/


   ForeColor(blackColor); /*m*/
   BackColor(whiteColor); /*m*/ 
   EraseRect(&theRect); /*m*/
   
   Ltableextrapass = 0;
   drawtable(ipass);  /*MAGETABL.c*/
   if(ipass==1 && Lsuperpick && Ltableextrapass)
   {
      drawtable(2);
      Ltableextrapass = 0;
   }
   settableScrollBars();      /*MACWIND.C*/
   /*includes setting tableWindow clipRect */  
   /*do after drawtable so scroll bars overwrite any lapped table entries*/

}
/*___dodrawtable()__________________________________________________________*/

