#include "MAGE.h"
#include "MAGELIST.h"

#define EXTERNANGL
#include "MAGEANGL.h"
#include "MAGEFLAG.h"
#include "MAGEBBOX.h"

void doxrayplotter(pointstructptr, float, int*, int*); 

/****domeasures()*************************************************************/
void    domeasures()
{
static  int       nmeasures = 0;
        double    angle,dihedral;
        float     sumx,sumy,sumz,fxyztemp[3];        
static  struct pointstruct* measurelinepointptr;/*keeps track of which of */     
static  struct pointstruct* measuredotspointptr; /*the 1-to-4 points have  */
                                                /* been reached */
static  double    SUMX,SUMY,SUMZ;

        if(Lnewmeasures)
        {
            nmeasures = 0;
            Lnewmeasures = 0;
            anglemeasure = 0.0;
            dihedralmeasure = 0.0;
            measuregrupptr->on = 1; /* enable display of this measures group*/
            measurelinelistptr->on = 0; /*start with list of points off */
            measuredotslistptr->on = 0; /*start with list of average dots off*/
            measurelinepointptr = measurelinelistptr->firstpointptr;
            measuredotspointptr = measuredotslistptr->firstpointptr;
            SUMX=SUMY=SUMZ=0.0; /*971204*/
        }
        
            nmeasures++; /*up to four successive picked points */
            SUMX = SUMX + pickedpointptr->fx;
            SUMY = SUMY + pickedpointptr->fy;
            SUMZ = SUMZ + pickedpointptr->fz;
        if(nmeasures <= 5)
        {/*points for lines increase up to 4*/

            if(nmeasures == 1)
            {/*first of a new series*/ 
                measurelinepointptr = measurelinelistptr->firstpointptr;
            }
            else if(nmeasures <= 4)
            {/*continuing*/
                measurelinepointptr = measurelinepointptr->nextptr; 
            }
            if(nmeasures <= 4)
                measurelinelistptr->lastpointptr = measurelinepointptr; 
                /*added to show list*/
            if(nmeasures == 2)
            {
                measuredotspointptr = measuredotslistptr->firstpointptr;
                measuredotslistptr->lastpointptr = measuredotspointptr; 
                    /*added to show list*/
            }        
            else if(nmeasures >  2 && nmeasures <=  5)
            {
                measuredotspointptr = measuredotspointptr->nextptr;
                measuredotslistptr->lastpointptr = measuredotspointptr; 
                    /*added to show list*/
            }
            /* store vectors along the picked path as Move-Draw-Draw-Draw*/
            /* then up to 3 Dots for the average of 2, 3, 4 picked points*/
            /* these are in the different list structures */
        }/*points for lines increase up to 4*/
        /*store values temporarily in case pickvec is a measures point*/
        fxyztemp[0] = pickedpointptr->fx;
        fxyztemp[1] = pickedpointptr->fy;
        fxyztemp[2] = pickedpointptr->fz;
            
        if(nmeasures > 1) /* for all later picks after first */
        {
            /*NOTE measure lines are drawn from last picked back */
            /* to the earlier picked ones*/
            thispointptr = measurelinelistptr->lastpointptr;
            while( thispointptr != NULL )
            {
                thispointptr->fx = (thispointptr->previousptr)->fx;
                thispointptr->fy = (thispointptr->previousptr)->fy;
                thispointptr->fz = (thispointptr->previousptr)->fz;
                thispointptr->ix = (thispointptr->previousptr)->ix;
                thispointptr->iy = (thispointptr->previousptr)->iy;
                thispointptr->iz = (thispointptr->previousptr)->iz;
                thispointptr->colorwidth 
                    = (thispointptr->previousptr)->colorwidth;
                thispointptr->type = VECTOR; /*pickable DrawTo*/
                
                thispointptr = thispointptr->previousptr;
                if(thispointptr == measurelinelistptr->firstpointptr)
                    thispointptr = NULL;
            }
        }
        /* put last pick point into working list at first position*/
        (measurelinelistptr->firstpointptr)->fx = fxyztemp[0];
        (measurelinelistptr->firstpointptr)->fy = fxyztemp[1];
        (measurelinelistptr->firstpointptr)->fz = fxyztemp[2];
        calcintegerpoints(measurelinelistptr->firstpointptr);/*MAGELIST*/
        (measurelinelistptr->firstpointptr)->colorwidth = 0; /*use list's*/
        (measurelinelistptr->firstpointptr)->type = (VECTOR|MOVETO_P);
                                                   /*pickable MoveTo*/
        if(nmeasures >= 2)  
        {   
            /*NOTE measure dots are calc over each time */
            /*calculate average, put into first dot position*/
            (measuredotslistptr->firstpointptr)->fx
                = (  (measurelinelistptr->firstpointptr)->fx
                   +((measurelinelistptr->firstpointptr)->nextptr)->fx )/2;
            (measuredotslistptr->firstpointptr)->fy
                = (  (measurelinelistptr->firstpointptr)->fy
                   +((measurelinelistptr->firstpointptr)->nextptr)->fy )/2;
            (measuredotslistptr->firstpointptr)->fz
                = (  (measurelinelistptr->firstpointptr)->fz
                   +((measurelinelistptr->firstpointptr)->nextptr)->fz )/2;

            measurelinelistptr->on = 1; /*turn list of points on for first line*/
            measuredotslistptr->on = 1; /*turn list of average dots on */
            calcintegerpoints(measuredotslistptr->firstpointptr);/*MAGELIST*/
            (measuredotslistptr->firstpointptr)->colorwidth = 0;
        }
        
        if(nmeasures >= 3)  /*calculate angle*/
        {
            /*going backwards, so first three give latest angle*/
/*.*/        angle = angle3pt(  
                (measurelinelistptr->firstpointptr)->fx
               ,(measurelinelistptr->firstpointptr)->fy
               ,(measurelinelistptr->firstpointptr)->fz
               ,((measurelinelistptr->firstpointptr)->nextptr)->fx
               ,((measurelinelistptr->firstpointptr)->nextptr)->fy
               ,((measurelinelistptr->firstpointptr)->nextptr)->fz
               ,(((measurelinelistptr->firstpointptr)->nextptr)->nextptr)->fx
               ,(((measurelinelistptr->firstpointptr)->nextptr)->nextptr)->fy
               ,(((measurelinelistptr->firstpointptr)->nextptr)->nextptr)->fz);
            anglemeasure = (float)angle; /* transfer by common storage */
            
            /*calculate average of 3, */
            /* put into dots position beyond average of 2 */
            ((measuredotslistptr->firstpointptr)->nextptr)->fx 
              =( (measurelinelistptr->firstpointptr)->fx
                +((measurelinelistptr->firstpointptr)->nextptr)->fx
                +(((measurelinelistptr->firstpointptr)->nextptr)->nextptr)->fx
               )/3;
            ((measuredotslistptr->firstpointptr)->nextptr)->fy 
              =( (measurelinelistptr->firstpointptr)->fy
                +((measurelinelistptr->firstpointptr)->nextptr)->fy
                +(((measurelinelistptr->firstpointptr)->nextptr)->nextptr)->fy
               )/3;
            ((measuredotslistptr->firstpointptr)->nextptr)->fz 
              =( (measurelinelistptr->firstpointptr)->fz
                +((measurelinelistptr->firstpointptr)->nextptr)->fz
                +(((measurelinelistptr->firstpointptr)->nextptr)->nextptr)->fz
               )/3;
        
            calcintegerpoints((measuredotslistptr->firstpointptr)->nextptr);
                /*MAGELIST*/
            ((measuredotslistptr->firstpointptr)->nextptr)->colorwidth = 0;
        }
        
        if(nmeasures >= 4)  /*calculate dihedral*/  /*971204*/
        {
/*.*/        dihedral = dihedral4pt(
                (measurelinelistptr->firstpointptr)->fx
               ,(measurelinelistptr->firstpointptr)->fy
               ,(measurelinelistptr->firstpointptr)->fz
               ,((measurelinelistptr->firstpointptr)->nextptr)->fx
               ,((measurelinelistptr->firstpointptr)->nextptr)->fy
               ,((measurelinelistptr->firstpointptr)->nextptr)->fz
               ,(((measurelinelistptr->firstpointptr)->nextptr)->nextptr)->fx
               ,(((measurelinelistptr->firstpointptr)->nextptr)->nextptr)->fy
               ,(((measurelinelistptr->firstpointptr)->nextptr)->nextptr)->fz
               ,(measurelinelistptr->lastpointptr)->fx
               ,(measurelinelistptr->lastpointptr)->fy
               ,(measurelinelistptr->lastpointptr)->fz);
                                
            dihedralmeasure = (float)dihedral; /* transfer by common storage */
            
            /*calculate average of 4, */
            /*put into dots position beyond average of 3 */
            sumx = 0.0;
            sumy = 0.0;
            sumz = 0.0;
            thispointptr = measurelinelistptr->firstpointptr;
            while(thispointptr != NULL)
            {
                sumx = sumx + thispointptr->fx;
                sumy = sumy + thispointptr->fy;
                sumz = sumz + thispointptr->fz;
                if(thispointptr == measurelinelistptr->lastpointptr)
                    thispointptr = NULL;
                else thispointptr = thispointptr->nextptr;
            }
         (((measuredotslistptr->firstpointptr)->nextptr)->nextptr)->fx = sumx/4;
         (((measuredotslistptr->firstpointptr)->nextptr)->nextptr)->fy = sumy/4;
         (((measuredotslistptr->firstpointptr)->nextptr)->nextptr)->fz = sumz/4;
            calcintegerpoints(
                ((measuredotslistptr->firstpointptr)->nextptr)->nextptr );
                /*MAGELIST*/
         (((measuredotslistptr->firstpointptr)->nextptr)->nextptr)->colorwidth
                 = 0;
        }/*nmeasures >= 4*/  
        if(nmeasures >= 5)  /*971204*/
        {/*nmeasures >= 5*/  
            (measuredotslistptr->lastpointptr)->fx = (float)SUMX/nmeasures;
            (measuredotslistptr->lastpointptr)->fy = (float)SUMY/nmeasures;
            (measuredotslistptr->lastpointptr)->fz = (float)SUMZ/nmeasures;   
            calcintegerpoints(measuredotslistptr->lastpointptr);   
            (measuredotslistptr->lastpointptr)->colorwidth = 0;  
            sprintf(word,"avg of %d pts",nmeasures);/* Dot for average point*/
            storeptIDstring(word, measuredotslistptr->lastpointptr);/*MAGELIST*/
        }/*nmeasures >= 5*/ /*971204*/
}
/*___domeasures()____________________________________________________________*/

/****angle3pt()*************************************************************/
double    angle3pt(    double p1x,double p1y,double p1z,
                    double p2x,double p2y,double p2z,
                    double p3x,double p3y,double p3z )
{
        double    ax,ay,az,bx,by,bz;
        double    amag,bmag,dot;
        double    angle;
        
            /* angle defined between two vectors with a common base*/
            /* so subtract middle point from the two end points */
            ax = p1x - p2x;
            ay = p1y - p2y;
            az = p1z - p2z;
            bx = p3x - p2x;
            by = p3y - p2y;
            bz = p3z - p2z;
            
        /* these have to be normalized by dividing by their magnitudes, */
        /*this can be done either before taking the dot product or after*/
/*.*/    dot = (double)dotproduct(ax,ay,az,bx,by,bz);
/*c*/    amag = sqrt(ax*ax + ay*ay + az*az);
/*c*/    bmag = sqrt(bx*bx + by*by + bz*bz);
        if(amag*bmag <0.0001) 
        {
            angle = 0.0;
        }    
/*c*/    else angle = acos( dot/(amag*bmag) );
        angle = angle*360.0/(2*3.14159);
        return(angle);
}
/*___angle3pt()____________________________________________________________*/

/****crossproduct()***********************************************************/
void    crossproduct(    double ax,double ay,double az,
                        double bx,double by,double bz)
{
    double gx,gy,gz;
    gx = (ay)*(bz) - (az)*(by);
    gy = (az)*(bx) - (ax)*(bz);
    gz = (ax)*(by) - (ay)*(bx);
    /*(*rx) = gx;*/
    /*(*ry) = gy;*/
    /*(*rz) = gz;*/
    dblx = gx;
    dbly = gy;
    dblz = gz;
    if(Ltest>1) 
    { 
        sprintf(alertstr,"cross product:"
                         CRLF"%f = %f = %f x %f - %f x %f"
                         CRLF"%f = %f = %f x %f - %f x %f"
                         CRLF"%f = %f = %f x %f - %f x %f"
                        ,dblx,gx,ay,bz,az,by
                        ,dbly,gy,az,bx,ax,bz
                        ,dblz,gz,ax,by,ay,bx               );
        dosinglealert(3); /*____DLOG.C*/
    }
}
/*___crossproduct()__________________________________________________________*/

/****dotproduct()***********************************************************/
double        dotproduct(    double ax,double ay,double az,
                        double bx,double by,double bz )
{
    double answer;
    
    answer = ax*bx + ay*by + az*bz;
    return(answer);
}
/*___dotproduct()__________________________________________________________*/

/****dihedral4pt()************************************************************/
double    dihedral4pt(  double p1x,double p1y,double p1z,
                        double p2x,double p2y,double p2z,
                        double p3x,double p3y,double p3z,
                        double p4x,double p4y,double p4z )
{
        double    angle,angledhdrl,dot,dmag,emag,fmag;
        double    ax,ay,az,bx,by,bz,cx,cy,cz;
        double    dx,dy,dz,ex,ey,ez;
        double    fx,fy,fz;
        
        /* a,b,c 3 vectors between 4 points, */
        /* d,e   2 crossproduct vectors referenced as pointers*/
        /* f     a crossproduct vector  referenced as pointer */
        /* if d = a x b and e = b x c, then d orth a & b, e orth b & c */
        /* d & e both perpendicular to b */
        /* so d dot e is the dihedral, that is */
        /*   same angle as a to c if a & c were projected on a plane*/
        
        /* angle defined between two vectors with a common base*/
        /* so subtract middle point from the two end points */
        ax = p1x - p2x;
        ay = p1y - p2y;
        az = p1z - p2z;
        bx = p3x - p2x;
        by = p3y - p2y;
        bz = p3z - p2z;
            
        /* d = a x b */
/*.*/    crossproduct(ax,ay,az,bx,by,bz); /*return vector is dblx,dbly,dblz */
        dx = dblx;
        dy = dbly;
        dz = dblz;
        
        /* angle defined between two vectors with a common base*/
        /* so subtract middle point from the two end points, */
        /* redefining b for cross product around third point (b = -b)*/
        bx = p2x - p3x;   /* -b as far as d is concerned */
        by = p2y - p3y;
        bz = p2z - p3z;
        cx = p4x - p3x;
        cy = p4y - p3y;
        cz = p4z - p3z;
        
        /* e = b x c */
/*.*/    crossproduct(bx,by,bz,cx,cy,cz); /*return vector is dblx,dbly,dblz */
        ex = dblx;
        ey = dbly;
        ez = dblz;
        
        /*Now for d dot e  pass values to dotproduct()*/
/*.*/    dot = dotproduct(dx,dy,dz,ex,ey,ez);
        /*normalization factors*/
/*c*/    dmag = sqrt( (dx)*(dx) + (dy)*(dy) + (dz)*(dz) );
/*c*/    emag = sqrt( (ex)*(ex) + (ey)*(ey) + (ez)*(ez) );
        if(dmag*emag <0.0001) 
        {
            angle = 0.0;
        }    
/*c*/    else angle = acos( dot/(dmag*emag) );
        angledhdrl = angle*360.0/(2*3.14159);
        if(Ltest)
        {
           sprintf(alertstr,"angle = %f  radians\015angle = %f  degrees"
                        ,angle,angledhdrl);
           dosinglealert(3); /*MACDLOG.C*/ /*MPCDLOG.C*/
        }
        
        /* Now, need to establish correct handedness */
        /* d x -b is vector pointing in same sort of direction as orig a */
        /* f = d x -b = d x b as b was redefined for e calculation */
/*.*/    crossproduct(dx,dy,dz,bx,by,bz); /*return vector is dblx,dbly,dblz */
        fx = dblx;
        fy = dbly;
        fz = dblz;
        
        /*Now for f dot e  pass values to dotproduct()*/
/*.*/    dot = dotproduct(fx,fy,fz,ex,ey,ez);

        /*normalization factors*/
/*c*/    fmag = sqrt( (fx)*(fx) + (fy)*(fy) + (fz)*(fz) );

        if(fmag*emag <0.0001) 
        {
            angle = 0.0;
        }    
/*c*/    else angle = acos( dot/(fmag*emag) );
        if(Ltest) { sprintf(alertstr,    "angle = %f  radians",angle );
             dosinglealert(3); /*MACDLOG.C*/ /*MPCDLOG.C*/
        }

        angle = angle*360.0/(2*3.14159);
        if(angle > 90.0) angledhdrl = -angledhdrl;
        if(Ltest) { sprintf(alertstr,    "signed angle = %f  degrees"
                        ,angledhdrl);
             dosinglealert(3); /*MACDLOG.C*/ /*MPCDLOG.C*/
        }

        return(angledhdrl);

}
/*___dihedral4pt()__________________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****dodrawline()************************************************************/
void    dodrawline()
{
   float    fvectorx,fvectory,fvectorz,veclength;
   float    fmiddlex,fmiddley,fmiddlez;/*971124SplitLine*/
   float    length,delx,dely,delz,startx,starty,startz;
   int      ndots,j;
   char     startID[256];
   
   if(Lnewdrawline)
   {
      numberline = 0;
      Lnewdrawline = 0;
      drawnewlistptr->on = 0; /*start with drawn lines off*/ 
      drawgrupptr->on = 1; /* enable display */
   }
   numberline++;
   if((thispointptr = allocpointstructure(drawnewlistptr)) == NULL)/*MAGELIST*/
   {/*allocation failed*/
      sprintf(alertstr,"failed to alloc a drawline point");
      alertstr2[0]='\0';alertstr3[0]='\0';
        DoMageDLOGreport(2); /*forced message*/ /*___DLOG.C*/ 
        numberline--;
        return;
   }/*allocation failed*/
   /*can construct another point */
   maxnxyz++;

   /*if(Lshiftkey)*/ /*shift for screen position pseudo pick 960211*/
   /*{*/ /*001029 this never did work well & interacts badly with docking*/
   /*    thispointptr->fx = x2;*/
   /*    thispointptr->fy = y2;*/
   /*    thispointptr->fz = z2;*/
   /*}*/
   /*else*/
   {
       thispointptr->fx = pickedpointptr->fx;
       thispointptr->fy = pickedpointptr->fy;
       thispointptr->fz = pickedpointptr->fz;
   }
   calcintegerpoints(thispointptr); /*MAGELIST*/
   thispointptr->colorwidth = 0; /*use list's default color*/
   
   thispointptr->type = (VECTOR|MOVETO_P);
       /*P== MoveTo, presume start of new line*/
       /*then if it isn't, type will be changed below*/
   
   if(   (((pickedpointptr->STATUS) & STATICFLAG) == STATICFLAG)
      || (((pickedpointptr->listptr)->STATUS) & STATICFLAG) == STATICFLAG)
   {
      thispointptr->STATUS = thispointptr->STATUS | STATICFLAG;
   }
   prelastdrawnpointptr = lastdrawnpointptr;
   lastdrawnpointptr = pickedpointptr;
   
   /*copy pointID into new position(n) in com array from pickvec position*/
   /*stored pointID string NOT conditioned */
   /*copy char str from storage */
   getptIDstring(word, pickedpointptr);
   /*store directly in giant character array */
   storeptIDstring( (char*)word,thispointptr);

   /*if a Point, the next entry will define a line and */
   /* constructing the actual, possibly shortened, drawn line */
   if(Lpoint > 1) /*Lnewlabels or Ldraglabel never lets Lpoint>0 */
   {/*second of Point-Line sequence*/
      if(LSplitLine)    /*971124SplitLine*/
      {/*calculate the lines midpoint for later use*/
       fmiddlex=(float)((thispointptr->fx+(thispointptr->previousptr)->fx)/2.0);
       fmiddley=(float)((thispointptr->fy+(thispointptr->previousptr)->fy)/2.0);
       fmiddlez=(float)((thispointptr->fz+(thispointptr->previousptr)->fz)/2.0);      
      }/*971124SplitLine*/
      
      if(shortenline > 0.0001 || shortenline < -0.0001) 
      /* i.e. surely non-zero */
      {/*shorten line between last two entered triples and update*/
      
          fvectorx = thispointptr->fx - (thispointptr->previousptr)->fx;
          fvectory = thispointptr->fy - (thispointptr->previousptr)->fy;
          fvectorz = thispointptr->fz - (thispointptr->previousptr)->fz;
          veclength = (float)sqrt(fvectorx*fvectorx + 
                                  fvectory*fvectory + 
                                  fvectorz*fvectorz  );
          /*normalize: */
          fvectorx = fvectorx/veclength;
          fvectory = fvectory/veclength;
          fvectorz = fvectorz/veclength;
          /*add to n-1, subtract from n to make */
          /*shortened line end positions*/
      
          (thispointptr->previousptr)->fx = 
              (thispointptr->previousptr)->fx + shortenline*fvectorx;
          (thispointptr->previousptr)->fy = 
              (thispointptr->previousptr)->fy + shortenline*fvectory;
          (thispointptr->previousptr)->fz = 
              (thispointptr->previousptr)->fz + shortenline*fvectorz;
          calcintegerpoints(thispointptr->previousptr);
          (thispointptr->previousptr)->colorwidth = 0; 
          
          thispointptr->fx = thispointptr->fx - shortenline*fvectorx;
          thispointptr->fy = thispointptr->fy - shortenline*fvectory;
          thispointptr->fz = thispointptr->fz - shortenline*fvectorz;
          calcintegerpoints(thispointptr);
          thispointptr->colorwidth = 0; /*use list's default color*/
              /*use list's default color*/
        
      }/*shorten line between last two entered triples and update*/
       
      /* store vectors as (Move-Draw)s, 2 entries per drawline*/
      /* but done sequentially as they come in as Point, Line */
      /* if shortened usually don't allow picking, set Ldrawunpickable */
      if(Ldrawunpickable == 1 )
      {
          (thispointptr->previousptr)->type = (VECTOR|MOVETO_P|UNPICKABLE);
              /*Point==Move,Unpickable*/
          thispointptr->type = (VECTOR|UNPICKABLE);
              /*Line==Draw, Unpickable*/
      }
      else
      {
           (thispointptr->previousptr)->type = (VECTOR|MOVETO_P);
               /* Point == Move */
           thispointptr->type = (VECTOR);  /* Line == Draw */            
      }
      if(Larrowline)
      {/*ARROW is a list and point type, set for tail and head points*/
         thispointptr->type = (thispointptr->type | ARROW);
         (thispointptr->previousptr)->type 
             = ((thispointptr->previousptr)->type | ARROW);
      }
      drawnewlistptr->on = 1; /*insure: drawn lines are on*/ 
      drawmarker1listptr->on = 0; /*turn off point indicater*/   
      drawmarker2listptr->on = 0; /*turn off point indicater*/  
      drawmarker3listptr->on = 0; /*turn off point indicater*/  
      drawmarker4listptr->on = 0; /*turn off point indicater*/ 
      Lpoint = 0; 
      if(LSplitLine && !Ldottedline)    /*SplitLine*/
      {/*allocate another pt and reassign a P-L-L sequence*/
        numberline++;
        if((thispointptr=allocpointstructure(drawnewlistptr))==NULL)/*MAGELIST*/
        {/*allocation failed*/
          sprintf(alertstr,"failed to alloc a drawline point");
          alertstr2[0]='\0';alertstr3[0]='\0';
          DoMageDLOGreport(2); /*forced message*/ /*___DLOG.C*/ 
          numberline--;
          return;
        }/*allocation failed*/
        /*can construct another point */
        maxnxyz++;
        /*new pt has all properties of the previous last pt, except color*/
        thispointptr->fx = (thispointptr->previousptr)->fx;
        thispointptr->fy = (thispointptr->previousptr)->fy;
        thispointptr->fz = (thispointptr->previousptr)->fz;
        thispointptr->type = (thispointptr->previousptr)->type;
        thispointptr->colorwidth = 1; /*red finish*/
        getptIDstring(word, (thispointptr->previousptr));
        storeptIDstring( (char*)word,thispointptr);
        thispointptr->STATUS = (thispointptr->previousptr)->STATUS;
        thispointptr->STYLE  = (thispointptr->previousptr)->STYLE;
        
        /*previous last pt is same except located at midpoint of line*/ 
        (thispointptr->previousptr)->fx = fmiddlex;
        (thispointptr->previousptr)->fy = fmiddley;
        (thispointptr->previousptr)->fz = fmiddlez;
        (thispointptr->previousptr)->colorwidth = 3; /*DrawTo so blue start*/
      }/*971124SplitLine*/
      else if(Ldottedline)
      {/*making dotted line*/
         /*make the two end points of this drawline be dots*/
         if(Ldrawunpickable == 1 )
          thispointptr->type=(thispointptr->previousptr)->type=(DOT|UNPICKABLE);
         else
          thispointptr->type = (thispointptr->previousptr)->type = DOT;
         if(LSplitLine)

         {
            thispointptr->colorwidth = 1; /*red finish*/
            (thispointptr->previousptr)->colorwidth = 3; /*blue start*/
         }
         /*compute number of dots to see if more needed inbetween ends*/
         delx = (thispointptr->fx - (thispointptr->previousptr)->fx);
         dely = (thispointptr->fy - (thispointptr->previousptr)->fy);
         delz = (thispointptr->fz - (thispointptr->previousptr)->fz);
         length = delx*delx + dely*dely + delz*delz;
         if(length > 0) length = (float)sqrt(length); /*length is a float*/
         ndots = (int)(length*4); /*dots per unit length*/
         if(ndots > 2)
         {/*create additional points*/
            /*remember starting point coords to compute intermediates*/
            startx = (thispointptr->previousptr)->fx;
            starty = (thispointptr->previousptr)->fy;
            startz = (thispointptr->previousptr)->fz;
            getptIDstring(startID, (thispointptr->previousptr));
            for(j=1;j<=(ndots-2);j++)
            {/*new intermediate points constructed from effective finish point*/
               numberline++;
               if((thispointptr=allocpointstructure(drawnewlistptr))==NULL)
               {/*allocation failed*/ /*MAGELIST*/
                 sprintf(alertstr,"failed to alloc a drawline point");
                 alertstr2[0]='\0';alertstr3[0]='\0';
                 DoMageDLOGreport(2); /*forced message*/ /*___DLOG.C*/ 
                 numberline--;
                 return;
               }/*allocation failed*/
               /*can construct another point, old thispoint now previous point*/
               maxnxyz++;
               /*new pt has all properties of the previous last pt because*/
               /* it becomes the old finish point moved ahead in the pt list*/
               thispointptr->fx = (thispointptr->previousptr)->fx;
               thispointptr->fy = (thispointptr->previousptr)->fy;
               thispointptr->fz = (thispointptr->previousptr)->fz;
               thispointptr->type = (thispointptr->previousptr)->type;
               getptIDstring(word, (thispointptr->previousptr));
               storeptIDstring( (char*)word,thispointptr);
               thispointptr->STATUS = (thispointptr->previousptr)->STATUS;
               thispointptr->STYLE  = (thispointptr->previousptr)->STYLE;
               thispointptr->colorwidth=(thispointptr->previousptr)->colorwidth;

               /*point now left one behind in the list needs new coord */
               /*(and color?)*/
               (thispointptr->previousptr)->fx = startx + j*(delx/(ndots-1));
               (thispointptr->previousptr)->fy = starty + j*(dely/(ndots-1));
               (thispointptr->previousptr)->fz = startz + j*(delz/(ndots-1));
               if(LSplitLine)
               {
                 if(j<(ndots/2))
                 {
                   storeptIDstring((char*)startID,(thispointptr->previousptr));
                   (thispointptr->previousptr)->colorwidth = 3; /*blue*/
                 }
                 else (thispointptr->previousptr)->colorwidth = 1; /*red*/
               }
            }/*each new intermediate point*/
         }/*create additional points*/
      }/*making dotted line*/
   }/*second of Point-Line sequence*/
 /*if(Lnewlabelson == 1 || Ldraglabelson==1)*/ 
   if(Lnewlabelson == 1) 
   {
      thispointptr->type = (LABEL);  /* Label */ 
      drawnewlistptr->on = 1; /*insure: drawn lines are on*/ 
      drawmarker1listptr->on = 0; /*turn off point indicater*/   
      drawmarker2listptr->on = 0; /*turn off point indicater*/  
      drawmarker3listptr->on = 0; /*turn off point indicater*/
      drawmarker4listptr->on = 0; /*turn off point indicater*/ 
      Lpoint = 0;
   }
   rescalekinemage(); 
}
/*___dodrawline()____________________________________________________________*/

/****doeraseline()************************************************************/
void    doeraseline()
{
   /*int        n;*/

   /*n = nxyz + NMARKERS + MAXMEASURES + 3*NDRAWPOINT + numberline;*/
   if(Lpoint > 0 && (Lconstruct4on || Lconstruct5on) ) 
   {
      Lpoint = 0;
   }
   else if(  (Lpoint > 0 && numberline >= 1)
           ||(  (( drawnewlistptr->lastpointptr)!=NULL)   
              &&(((drawnewlistptr->lastpointptr->type)&VECTOR)==0) ) 
          )
           /*||(  (((drawnewlistptr->lastpointptr->type)&VECTOR)==0)   */
           /*   &&(((drawnewlistptr->lastpointptr->type)&STORED)==0) ) */
   {/*point start is one position, as is a label*/
      numberline = numberline - 1;
      maxnxyz--;
      Lpoint = 0;
      if(drawnewlistptr->lastpointptr != NULL)
      {/*there is at least one point in the drawnew list*/
         destroypointstructure(drawnewlistptr->lastpointptr); /*MAGELIST*/
         /*this routine takes care of reconnection and parent updating*/
         /* it also protects itself against NULL pointptrs! */
      }/*there is at least one point in the drawnew list*/
   }
   else if(numberline >= 2)
   {/*full point-line is 2 positions*/
      numberline = numberline - 2;
      maxnxyz--;
      maxnxyz--;
      Lpoint = 0;
      if(drawnewlistptr->lastpointptr != NULL)
      {/*there is at least one point in the drawnew list*/
         destroypointstructure(drawnewlistptr->lastpointptr); /*MAGELIST*/
         /*this routine takes care of reconnection and parent updating*/
      }/*there is at least one point in the drawnew list*/
      if(drawnewlistptr->lastpointptr != NULL)
      {/*there is at least one point in the drawnew list*/
         destroypointstructure(drawnewlistptr->lastpointptr); /*MAGELIST*/
         /*this routine takes care of reconnection and parent updating*/
      }/*there is at least one point in the drawnew list*/
   }
   if(numberline <  0) 
   {
      numberline = 0;
      drawnewlistptr->lastpointptr = NULL;  /*this should be redundant*/
      drawnewlistptr->firstpointptr = NULL; /*this should be redundant*/
          /*reset show list*/ 
            
            drawnewlistptr->on = 0; /*turn off list*/ /*960527*/ 
            maxnxyz = nxyz + NMARKERS + MAXMEASURES + 3*NDRAWPOINT;

   }
   drawmarker1listptr->on = 0; /*turn off marker1*/
   drawmarker2listptr->on = 0; /*turn off marker2*/
   drawmarker3listptr->on = 0; /*turn off marker3*/
   drawmarker4listptr->on = 0; /*turn off marker4*/ /*971122*/
}
/*___doeraseline()__________________________________________________________*/

/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****doconstructline()*******************************************************/
void    doconstructline()
{
           float  fvectorx,fvectory,fvectorz,veclength;
   static  float  fcxyz[3][7]; 
           double angledhdrl,cmag;
           double ax,ay,az,bx,by,bz,cx,cy,cz;
           float  costheta; /*for projection to tangent plane*/
   static  int    fixedstate;
           int    nth; 
   double A1X,A1Y,A1Z,A2X,A2Y,A2Z,ADX,ADY,ADZ,ART; /*for perpendicular*/
   double B1X,B1Y,B1Z,B2X,B2Y,B2Z; /*for perpendicular*/

   int       ntines,nrepeat;
   
   if     (Lconstruct4on) nth = 4;
   else if(Lconstruct5on) nth = 5;/*971122*/

   if(Lpoint<nth)
   {       
        if(Lnewdrawline)
        {
            numberline = 0;
            Lnewdrawline = 0;
            drawnewlistptr->on = 0; /*start with drawn lines off*/ /*960527*/
            drawgrupptr->on = 1; /* enable display */
        }
        /* get this last picked point into coordinate list at new position */
        
        fcxyz[0][Lpoint] = pickedpointptr->fx;
        fcxyz[1][Lpoint] = pickedpointptr->fy;
        fcxyz[2][Lpoint] = pickedpointptr->fz;

               
        /*Wait for 3 or 4 entries to define a line before */
        /* constructing the actual, possibly shortened, drawn line */
        
        /*use point indicator to signel when enough points entered */
        if((Lconstruct4on) && Lpoint==3 )
        {
           Lpoint=4; 
        }
        if( Lconstruct5on && Lpoint==4 )
        {
           Lpoint=5;
        }
        /*At fruition, this will be intercepted at a successful pick report in*/
        /* ____MAIN after Drawgraf() with Lpick==TRUE, then Dialog box called*/
   }
   else
   {/*Lpoint==4||Lpoint==5*/
    if(   (((pickedpointptr->STATUS) & STATICFLAG) == STATICFLAG)
       || (((pickedpointptr->listptr)->STATUS) & STATICFLAG) == STATICFLAG)
         fixedstate = 1;
    else fixedstate = 0;  
        /*constructed points fixed crt last point picked*/

    if(  (Lconstructperpendicular)
       ||(distconstruct != 0 && angleconstruct != 0) )
    {/*distconstruct and angleconstruct both non-zero*/
       /*or doing Lconstructperpendicular*/    
     if(LconstructMultiple) /*971126ARROW*/
     {
        ntines = (int)(360/dihedralconstruct);
     }
     else
     {
        ntines = 1;
     }/*971126ARROW*/

     for(nrepeat = 1; nrepeat<=ntines; nrepeat++)/*971126ARROW*/
     {/*nrepeat of constructline, dihedral incremented*/ /*971126ARROW*/

      /*for any construction mode: common code to alloc two new points*/
      /*since always draw both ends of the new line*/ /*971122*/
           /* called 4th time from DoconstructDialog() with values for */
           /* distconstruct, angleconstruct, dihedralconstruct*/
           /*now have 3 entries to define a line, can */
           /* construct the actual, possibly shortened, drawn line */
           /* called 5th time from DoConstructFifthDialog()*/ /*971122*/
           numberline = numberline + 2;
           /*n = nxyz + NMARKERS + MAXMEASURES + 3*NDRAWPOINT + numberline;*/
           /*970410*/
        
        /*#1... making 2 new points: n-1 and n ...*/
        if((thispointptr = allocpointstructure(drawnewlistptr)) == NULL)
        {/*allocation failed*/ /*MAGELIST*/
            sprintf(alertstr,"failed to alloc a 1st constructline point");
             alertstr2[0]='\0';alertstr3[0]='\0';
             DoMageDLOGreport(2); /*forced message*/ /*___DLOG.C*/ 
             numberline--;
             return;
        }/*allocation failed*/
        /*can construct another point */
        
        if(fixedstate)
        {
           thispointptr->STATUS = thispointptr->STATUS | STATICFLAG;
        }
        thispointptr->type = (VECTOR|MOVETO_P);/*default simple Point == Move */
        
        /*#2... making 2 new points: n-1 and n ...*/
        if((thispointptr = allocpointstructure(drawnewlistptr)) == NULL)
        {/*allocation failed*/ /*MAGELIST*/
            sprintf(alertstr,"failed to alloc a 2nd constructline point");
             alertstr2[0]='\0';alertstr3[0]='\0';
             DoMageDLOGreport(2); /*forced message*/ /*___DLOG.C*/ 
             numberline--;
             return;
        }/*allocation failed*/
        /*can construct another point */
        
        if(fixedstate)
        {
           thispointptr->STATUS = thispointptr->STATUS | STATICFLAG;
        }
        thispointptr->type = (VECTOR); /*default simple Line == Draw */
        
        /*get this last picked point into coordinate list at new position*/
        ((drawnewlistptr->lastpointptr)->previousptr)->fx = pickedpointptr->fx;
        ((drawnewlistptr->lastpointptr)->previousptr)->fy = pickedpointptr->fy;
        ((drawnewlistptr->lastpointptr)->previousptr)->fz = pickedpointptr->fz;
           /*ptIDs... making 2 new points: n-1 and n ...*/
           /*copy pointID into new position(n-1)  from pickvec position*/
        /*copy pointID into new position(n) in com array from pickvec position*/
        /*stored pointID string NOT conditioned */
        /*copy char str from storage */
        getptIDstring(word, pickedpointptr);
        /*store directly in giant character array */
        storeptIDstring(word,(drawnewlistptr->lastpointptr)->previousptr);
        calcintegerpoints( (drawnewlistptr->lastpointptr)->previousptr );
        
        /*create a new ptID for the second new point: n */
        sprintf(word,"construc");
        storeptIDstring(word,drawnewlistptr->lastpointptr);

      if((Lconstruct4on) && !Lconstructperpendicular) 
      {/*construct at distance,angle,dihedral*/ 
           
           /*calculate the new line from points 1,2,3, */
           /* dist 3-4, angle 2-3-4, dihedral 1-2-3-4 */
           /* cross:  (2->3)X(2->1) ==> (2->5), aXb ==> c at dihedral 90*/
           ax = fcxyz[0][3] - fcxyz[0][2];
           ay = fcxyz[1][3] - fcxyz[1][2];
           az = fcxyz[2][3] - fcxyz[2][2];
           bx = fcxyz[0][1] - fcxyz[0][2];
           by = fcxyz[1][1] - fcxyz[1][2];
           bz = fcxyz[2][1] - fcxyz[2][2];
           /* c = a x b */
/*.*/      crossproduct(ax,ay,az,bx,by,bz);/*return vector is dblx,dbly,dblz*/
           cx = dblx;cy = dbly;cz = dblz;
           /*normalization factor*/
/*
        printf("cross product:"
                         CRLF"%f = %f x %f - %f x %f"
                         CRLF"%f = %f x %f - %f x %f"
                         CRLF"%f = %f x %f - %f x %f"
                        ,dblx,ay,bz,az,by
                        ,dbly,az,bx,ax,bz
                        ,dblz,ax,by,ay,bx               );
*/
           cmag = sqrt( (cx)*(cx) + (cy)*(cy) + (cz)*(cz) );

           if(Lconstructprojection)
           {/*project line from sphere of radius dist to tangent plane*/
              costheta = (float)cos( (double)(angleconstruct)*3.14159*2/360);
              if(costheta > .00001)
              cmag = cmag*costheta;
           }

           /*place c at correct distance*/
           if(cmag > 0.000001)
           {
               cx = cx*distconstruct/cmag;
               cy = cy*distconstruct/cmag;
               cz = cz*distconstruct/cmag;
           }
           /*place c at correct distance from 3rd point,*/
           /* as xproduct it is at a dihedral of 90 to a vector*/
           cx = cx + fcxyz[0][3];
           cy = cy + fcxyz[1][3];
           cz = cz + fcxyz[2][3];
           /*load actual array with only-distance-set point*/
           thispointptr->fx = (float)cx;
           thispointptr->fy = (float)cy;
           thispointptr->fz = (float)cz;
           /*rotate around 2->3 for correct dihedral*/
           
           /*angledhdrl = dihedralconstruct - 90.0;*/
           angledhdrl = nrepeat*dihedralconstruct - 90.0; /*971126ARROW*/
           
           ax = fcxyz[0][2];
           ay = fcxyz[1][2];
           az = fcxyz[2][2];
           bx = fcxyz[0][3];
           by = fcxyz[1][3];
           bz = fcxyz[2][3];
           doaxisrot(&(thispointptr->fx),&(thispointptr->fy),&(thispointptr->fz)
                 ,(float)angledhdrl, ax, ay, az
                                   , bx, by, bz);
           /* cross:  (3->4)X(3->2) ==> (3->6), aXb ==> c at dihedral 90*/
           ax = thispointptr->fx - fcxyz[0][3];
           ay = thispointptr->fy - fcxyz[1][3];
           az = thispointptr->fz - fcxyz[2][3];
           bx = fcxyz[0][2] - fcxyz[0][3];
           by = fcxyz[1][2] - fcxyz[1][3];
           bz = fcxyz[2][2] - fcxyz[2][3];
           /* c = a x b */
/*.*/      crossproduct(ax,ay,az,bx,by,bz);/*return vector is dblx,dbly,dblz*/
           cx = dblx;cy = dbly;cz = dblz;
           /*normalization factor*/

/*c*/      cmag = sqrt( (cx)*(cx) + (cy)*(cy) + (cz)*(cz) );
           if(cmag > 0.000001)
           {
               cx = cx/cmag;
               cy = cy/cmag;
               cz = cz/cmag;
           }

           /*rotate around 3->6 for correct angle*/
           angledhdrl = 90.0 - angleconstruct;
           ax = fcxyz[0][3];
           ay = fcxyz[1][3];
           az = fcxyz[2][3];
           cx = cx + fcxyz[0][3];
           cy = cy + fcxyz[1][3];
           cz = cz + fcxyz[2][3];
           bx = cx;
           by = cy;
           bz = cz;
           doaxisrot(&(thispointptr->fx),&(thispointptr->fy),&(thispointptr->fz)
                 ,(float)angledhdrl, ax, ay, az
                                   , bx, by, bz);
 
           /*stop for now and see if this is reasonable so far*/
           if((shortenline > 0.0001 || shortenline < 0.0001)) 
           /* i.e. surely non-zero */
           {    /*shorten line between last two entered triples and update*/
                
                fvectorx = thispointptr->fx - (thispointptr->previousptr)->fx;
                fvectory = thispointptr->fy - (thispointptr->previousptr)->fy;
                fvectorz = thispointptr->fz - (thispointptr->previousptr)->fz;

                veclength = (float)sqrt(   fvectorx*fvectorx +
                                    fvectory*fvectory + 
                                    fvectorz*fvectorz  );
                /*normalize: */
                if(veclength > 0.000001)
                {
                    fvectorx = fvectorx/veclength;
                    fvectory = fvectory/veclength;
                    fvectorz = fvectorz/veclength;
                }
                /*add to n-1, subtract from n to make */
                /*shortened line end positions*/
                
                (thispointptr->previousptr)->fx 
                    = (thispointptr->previousptr)->fx + shortenline*fvectorx;
                (thispointptr->previousptr)->fy 
                    = (thispointptr->previousptr)->fy + shortenline*fvectory;
                (thispointptr->previousptr)->fz
                    = (thispointptr->previousptr)->fz + shortenline*fvectorz;
                calcintegerpoints(thispointptr->previousptr);
                (thispointptr->previousptr)->colorwidth = 0;
                
                thispointptr->fx = thispointptr->fx - shortenline*fvectorx;
                thispointptr->fy = thispointptr->fy - shortenline*fvectory;
                thispointptr->fz = thispointptr->fz - shortenline*fvectorz;
              
                calcintegerpoints(thispointptr);
                thispointptr->colorwidth = 0;
           }
           /* load integer display list */
            
           /*maxnxyz = n;*/
           maxnxyz = nxyz + NMARKERS + MAXMEASURES + 3*NDRAWPOINT + numberline;
           /*970410*/ 
           /* store vectors as (Move-Draw)s, 2 entries per drawline*/
           /* but done sequentially as they come in as Point, Line */
           /* originally, if shortened, don't allow picking */
           /*if(shortenline > 0.0001 )*/
           if(Ldrawunpickable == 1) /*explicitly control unpickable-ness*/
           {
                (thispointptr->previousptr)->type=(VECTOR|MOVETO_P|UNPICKABLE);
                    /*Point==Move,Unpickable*/
                thispointptr->type = (VECTOR|UNPICKABLE);  
                    /* Line == Draw, Unpickable */
           }
           else
           {
                (thispointptr->previousptr)->type = (VECTOR|MOVETO_P);  
                    /* Point == Move */
                thispointptr->type = (VECTOR);  /* Line == Draw */            
           }

           if(Lconstructdot) 
           {/*dot at end instead of line*/
              thispointptr->type = (DOT); /*dot*/
           }

           drawnewlistptr->on = 1; /*insure: drawn lines are on*/ /*960527*/
    
      }/*construct at distance,angle,dihedral*/
      else if(Lconstruct4on)
      {/*construct perpendicular from point to line*/    
        /*perpendicular from 3rd point to line of points 1 and 2 */
        A1X = fcxyz[0][1];A1Y = fcxyz[1][1];A1Z = fcxyz[2][1];
        A2X = fcxyz[0][2];A2Y = fcxyz[1][2];A2Z = fcxyz[2][2];
        B1X = fcxyz[0][3];B1Y = fcxyz[1][3];B1Z = fcxyz[2][3];
        ADX = A2X - A1X;ADY = A2Y - A1Y;ADZ = A2Z - A1Z;
/*arbitrary point on line A 
   B2X = A1X + ADX*ART;B2Y = A1Y + ADY*ART;B2Z = A1Z + ADZ*ART;
      
   direction components of line B1 --- B2  
   BDX = A1X-B1X+ADX*ART; BDY = A1Y-B1Y+ADY*ART; BDZ = A1Z-B1Z+ADZ*ART;
   for this to be perpendicular to line A, sum of product of components ==0
   ADX*(A1X-B1X+ADX*ART)+ADY*(A1Y-B1Y+ADY*ART)+ADZ*(A1Z-B1Z+ADZ*ART)=0;
   rearrange
   ADX*A1X-ADX*B1X+ADX*ADX*ART
   +ADY*A1Y-ADY*B1Y+ADY*ADY*ART
   +ADZ*A1Z-ADZ*B1Z+ADZ*ADZ*ART=0;
   regroup
   ART*(ADX*ADX++ADY*ADY+ADZ*ADZ)
         =ADX*B1X-ADX*A1X+ADY*B1Y-ADY*A1Y+ADZ*B1Z-ADZ*A1Z;
*/
         ART =  (ADX*B1X-ADX*A1X+ADY*B1Y-ADY*A1Y+ADZ*B1Z-ADZ*A1Z)
               /(ADX*ADX+ADY*ADY+ADZ*ADZ);

         B2X = A1X + ADX*ART;
         B2Y = A1Y + ADY*ART;
         B2Z = A1Z + ADZ*ART;

         (thispointptr->previousptr)->type 
             = (thispointptr->previousptr)->type |VECTOR|MOVETO_P;

         thispointptr->fx = (float)B2X;
         thispointptr->fy = (float)B2Y;
         thispointptr->fz = (float)B2Z;
         thispointptr->type = thispointptr->type |VECTOR;
         calcintegerpoints(thispointptr);
         
         drawnewlistptr->on = 1;

      }/*construct perpendicular from point to line*/    
      else if(Lconstruct5on && LPerpendicularToPlane)
      {
         DoPerpendicularToPlane(fcxyz);
      }
      else if(Lconstruct5on && LPerpendicularBetweenLines)
      {
         DoPerpendicularBetweenLines(fcxyz);
      }
      else if(Lconstruct5on && LShortestBetweenLinesegments)
      {
         DoShortestBetweenLinesegments(fcxyz);
      }
      drawnewlistptr->on = 1;
     }/*nrepeat of constructline, dihedral incremented*/ /*971126ARROW*/
    }/*distconstruct and angleconstruct both non-zero*/
       /*or doing Lconstructperpendicular*/    
   }/*Lpoint==4||Lpoint==5*/
}
/*___doconstructline()______________________________________________________*/

/****doaxisrot()*************************************************************/
void  doaxisrot(float* fxptr,float* fyptr,float* fzptr
,float theta,double ax,double ay,double az,double bx,double by,double bz)
{
    double xx,yy,zz,cosn1,cosn2,cosn3,costheta,sintheta;
    double fx1,fy1,fz1,fx2,fy2,fz2;
    double a11,a12,a13,a21,a22,a23,a31,a32,a33;
    
    xx = bx - ax;
    yy = by - ay;
    zz = bz - az;
    if(xx*xx + yy*yy + zz*zz > 0.000001)
    {
        cosn1 = (xx)/sqrt(xx*xx + yy*yy + zz*zz);
        cosn2 = (yy)/sqrt(xx*xx + yy*yy + zz*zz);
        cosn3 = (zz)/sqrt(xx*xx + yy*yy + zz*zz);
    }
    while(theta >  360) theta = theta - 360;
    while(theta < -360) theta = theta + 360;
    if(theta >  180) theta = theta - 360;
    if(theta < -180) theta = theta + 360;
    costheta = cos( (double)theta*3.14159*2/360);
    sintheta = sin( (double)theta*3.14159*2/360);

a11=( cosn1*cosn1 + (1-cosn1*cosn1)*costheta);
a12=( cosn1*cosn2*(1-costheta) + cosn3*sintheta );
a13=( cosn1*cosn3*(1-costheta) - cosn2*sintheta );

a21=( cosn1*cosn2*(1-costheta) - cosn3*sintheta );
a22=( cosn2*cosn2 + (1-cosn2*cosn2)*costheta);
a23=( cosn2*cosn3*(1-costheta) + cosn1*sintheta );

a31=( cosn1*cosn3*(1-costheta) + cosn2*sintheta );
a32=( cosn2*cosn3*(1-costheta) - cosn1*sintheta );
a33=( cosn3*cosn3 + (1-cosn3*cosn3)*costheta);
/*det=a11*(a22*a33-a23*a32)-a12*(a21*a33-a23*a31)+a13*(a21*a32-a22*a31);*/

        fx1 = ( *fxptr - bx );
        fy1 = ( *fyptr - by );
        fz1 = ( *fzptr - bz );

        fx2 = (   fx1*a11 + fy1*a21 + fz1*a31 );
        fy2 = (   fx1*a12 + fy1*a22 + fz1*a32 );
        fz2 = (   fx1*a13 + fy1*a23 + fz1*a33 );

        *fxptr = (float)(fx2 + bx); 
        *fyptr = (float)(fy2 + by); 
        *fzptr = (float)(fz2 + bz); 
}
/*___doaxisrot()____________________________________________________________*/    
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****dobondrot()*************************************************************/
void    dobondrot(int i,float theta)
{
   double xx,yy,zz,cosn1,cosn2,cosn3,costheta,sintheta;
   int   n;
   double fx1,fy1,fz1,fx2,fy2,fz2;
   double a11,a12,a13,a21,a22,a23,a31,a32,a33;
   static int Lnew=1, Lold=0; /*981107*/
   float center=parameter[9]; /*001106*/
   pointstruct* thepointptr;
   pointstruct* thelastpointptr;
   liststruct*  thelistptr;     /*970905*/

   Lnewstuffactive = 1; /*for warning about write-out before quiting, etc.*/

   if(Lcontrolon) Lnew = 0; /*981107*/
   else           Lnew = 1;
    
   xx = (bondrotptr[i]->headpointptr)->fx - (bondrotptr[i]->tailpointptr)->fx;
   yy = (bondrotptr[i]->headpointptr)->fy - (bondrotptr[i]->tailpointptr)->fy;
   zz = (bondrotptr[i]->headpointptr)->fz - (bondrotptr[i]->tailpointptr)->fz;
   cosn1 = (xx)/sqrt(xx*xx + yy*yy + zz*zz);
   cosn2 = (yy)/sqrt(xx*xx + yy*yy + zz*zz);
   cosn3 = (zz)/sqrt(xx*xx + yy*yy + zz*zz);
   while(theta >  360) theta = theta - 360;
   while(theta < -360) theta = theta + 360;
   if(theta >  180) theta = theta - 360;
   if(theta < -180) theta = theta + 360;
   costheta = cos( (double)theta*3.14159*2.0/360.0);
   sintheta = sin( (double)theta*3.14159*2.0/360.0);

   a11=( cosn1*cosn1 + (1-cosn1*cosn1)*costheta);
   a12=( cosn1*cosn2*(1-costheta) + cosn3*sintheta );
   a13=( cosn1*cosn3*(1-costheta) - cosn2*sintheta );

   a21=( cosn1*cosn2*(1-costheta) - cosn3*sintheta );
   a22=( cosn2*cosn2 + (1-cosn2*cosn2)*costheta);
   a23=( cosn2*cosn3*(1-costheta) + cosn1*sintheta );

   a31=( cosn1*cosn3*(1-costheta) + cosn2*sintheta );
   a32=( cosn2*cosn3*(1-costheta) - cosn1*sintheta );
   a33=( cosn3*cosn3 + (1-cosn3*cosn3)*costheta);

/*
   det=a11*(a22*a33-a23*a32)-a12*(a21*a33-a23*a31)+a13*(a21*a32-a22*a31);
*/

   /*scope is usually taken as starting from the 3rd point input */
   /* to the point preceeding the vectorlist that defines the */
   /* end of the scope */
   /*In order to combine rotations rather than stack them hierachically*/
   /* one can define that several rotations have exactly the same scope*/
   /* e.g. to simulate precession motion */
   /* thus several successive bondrot axes can all have the scope of the*/
   /* last one in the series.  scopeinstance is therefore always pointing*/
   /* to a bondrot definition that occurred later */
   if(bondrotptr[i]->scopeinstance != 0) 
        n = bondrotptr[i]->scopeinstance;
   else n = i; /*the current bondrotptr index */
   thepointptr = bondrotptr[n]->firstpointptr;
   thelastpointptr  = bondrotptr[n]->lastpointptr;
   if(thelastpointptr == NULL) thepointptr = NULL; /*wierd end, so abort*/
      /*a failed clone just previous to the end of scope will do this*/
   while(thepointptr != NULL)
   {/*loop over all points in scope*/
      /*new coord = (transto000,* matrix elements, transback)*/
      /*matrix components from Rogers & Adams pg. 55 */

      fx1 = ( thepointptr->fx - (bondrotptr[i]->headpointptr)->fx );
      fy1 = ( thepointptr->fy - (bondrotptr[i]->headpointptr)->fy );
      fz1 = ( thepointptr->fz - (bondrotptr[i]->headpointptr)->fz );

      fx2 =          (   fx1*a11
                       + fy1*a21
                       + fz1*a31
                     );

      fy2 =          (   fx1*a12
                       + fy1*a22
                       + fz1*a32
                     );

      fz2 =          (   fx1*a13
                       + fy1*a23
                       + fz1*a33
                     );

      thepointptr->fx = (float)(fx2 + (bondrotptr[i]->headpointptr)->fx);
      thepointptr->fy = (float)(fy2 + (bondrotptr[i]->headpointptr)->fy);
      thepointptr->fz = (float)(fz2 + (bondrotptr[i]->headpointptr)->fz);
/*----------------*/
      if(thepointptr == beginselectionpointptr)
      {
         Lbeginselection = 1;
      }      
      if(   bondrotptr[i]->option == 3 && Lbeginselection)
      {/*selection of some by parameters*/
        if(thepointptr == endselectionpointptr)
        {
           Lbeginselection = 0;/*981008*/
        }
        if(   thepointptr->listptr->on
           && thepointptr->listptr->sgrpptr->on
           && thepointptr->listptr->sgrpptr->grupptr->on/*test only ON objects*/
           &&(   !Lcontrolon   /*test all points */
              || ((thepointptr->type) & PRUNED) == PRUNED ) )/*only OFF points*/
        {/*show points within min ... max limits*/ /*981010*/
          if(parameter[2] > 0.00001)
          {/*distmax*/
             if(((sqrt(  (thepointptr->fx -parameter[6])
                      *(thepointptr->fx -parameter[6])
                     + (thepointptr->fy -parameter[7])
                      *(thepointptr->fy -parameter[7])
                     + (thepointptr->fz -parameter[8])
                      *(thepointptr->fz -parameter[8]) ) ) )
                > parameter[2])
             {/*out by distmax, inclusive OR on the PRUNED flag*/
                 thepointptr->type=(thepointptr->type) | PRUNED;
             }/*add PRUNED flag*/
             else
             {/*within distmax, AND everything but the PRUNED flag*/
                 thepointptr->type = (thepointptr->type) & (32767-PRUNED);
             }/*remove PRUNED flag*/
          }/*distmax*/
          if(parameter[1] > 0.00001)
          {/*distmin*/
             if(((sqrt(  (thepointptr->fx -parameter[3])
                      *(thepointptr->fx -parameter[3])
                     + (thepointptr->fy -parameter[4])
                      *(thepointptr->fy -parameter[4])
                     + (thepointptr->fz -parameter[5])
                      *(thepointptr->fz -parameter[5]) ) ) )
                < parameter[1])
             {/*out by distmin, inclusive OR on the PRUNED flag*/
                     thepointptr->type = (thepointptr->type) | PRUNED; 
             }/*add PRUNED flag*/
             else
             {/*passed: is NOT below minimum*/ /*981107*/
               if(parameter[2] > 0.00001)
               {/*already tested to see if NOT above maximum*/
                  ; /*NOP, let previous test stand for all NOT below minimum*/
               }
               else
               {/*Allow anything that is NOT below minimum*/
                 thepointptr->type = (thepointptr->type) & (32767-PRUNED);
                 /*allow all >distmin*/  /*remove PRUNED flag*/
                 /* AND everything but the PRUNED flag*/
               }/*Allow anything that is NOT below minimum*/

             }/*passed: is NOT below minimum*/ /*981107*/
          }/*distmin*/
          if(  ((thepointptr->type) & PRUNED) == 0) /*981107*/
          {/*passed tests, plot points projected like rays onto flat film*/
             doxrayplotter(thepointptr,center,&Lnew,&Lold);  /*981107*/ 
                /*dobondrot() sets,stores Lnew,Lold; */
                /*doxrayplotter() uses,changes them*/        
          }/*passed tests, plot points projected like rays onto flat film*/
            /*981107*/
        }/*show points within min ... max limits*/
      }/*selection of some by parameters*/
/*--------------*/
    
      if(thepointptr == thelastpointptr)
      {/*end of scope*/
         thepointptr = NULL;
      }
      else if(thepointptr == (thepointptr->listptr)->lastpointptr)
      {/*at last point in a list*/
         /*970903 MAGE keeps track of all lists as a linked list during */
         /* allocliststructure() so only need to go up to the list level*/
         
         if((thepointptr->listptr)->nextptr != NULL) 
         {/*there is a next list: get first point of next list*/ 
            thelistptr = (thepointptr->listptr)->nextptr;
            thepointptr = thelistptr->firstpointptr;
            if(thepointptr == NULL) /*list with NO points*/
            {
               while(   (thepointptr == NULL) /*current point*/
                     && (thelistptr->nextptr != NULL) ) /*next list*/
               {/*search for a non-NULL point in the scope*/
                 thelistptr = thelistptr->nextptr; /*next list*/
                 thepointptr = thelistptr->firstpointptr;
               }
            }
         }
         else
         {/*NO  more lists, no more points to rotate*/
            /*somehow thelastpointptr failed to be found*/
            thepointptr = NULL;
         }
      }/*at last point in a list*/
      else
      { 
         thepointptr = thepointptr->nextptr;
      }
   }/*loop over all points in scope*/
}
/*___dobondrot()____________________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****reinitialbondrots()*************************************************/
void reinitialbondrots()
{
  int i;
  float theta,thetain,thetaout;
  
  if(nbondrot > 0)
  {
       for(i=1; i<=nbondrot; i++)
       {
              if(bondrotptr[i]->origangle<0.0) 
                  thetain = 360 + bondrotptr[i]->origangle;
              else thetain = bondrotptr[i]->origangle;
              if(bondrotptr[i]->angle<0.0) 
                  thetaout = 360 + bondrotptr[i]->angle;
              else thetaout = bondrotptr[i]->angle;
              theta = thetain - thetaout;
              if(theta >  180.0) theta =  theta - 360;
              if(theta < -180.0) theta =  theta + 360;
              dobondrot(i,theta);
              bondrotptr[i]->angle = bondrotptr[i]->origangle;
       }
       SetsinGrafWindow();       /*MAGEBBOX.C*/
       
       if(Lupdate && !Linhibiton)
       {/*update from remote program: e.g. dots by PROBE*/
          sprintf(word,"\""); /*ditto mark*/
          doupdate(1,word); /*____OUT.c*/  /*970522*/
          /* 1: deletes old dots before reloading them*/
          UpdateAppendedSets(); /*MAGEBBOX.c*/ /*970905*/ /*was below bracket*/
       }

       Lrecalculate = 1;
       rescalekinemage();    /*MAGEINPT.C*/
       redrawvec();          /*MUXMDRAW.C*/
  }
}
/*___reinitialbondrots()________________________________________________*/

/****restorebondrots()*************************************************/
void restorebondrots(int istart, int iend)
{
  int i;
  float theta,thetain,thetaout;
  
       for(i=istart; i<=iend; i++)
       {
              if(bondrotptr[i]->origangle<0.0) 
                  thetain = 360 + bondrotptr[i]->origangle;
              else thetain = bondrotptr[i]->origangle;
              if(bondrotptr[i]->angle<0.0) 
                  thetaout = 360 + bondrotptr[i]->angle;
              else thetaout = bondrotptr[i]->angle;
              theta = thetain - thetaout;
              if(theta >  180) theta =  theta - 360;
              if(theta < -180) theta =  theta + 360;
              dobondrot(i,theta);
              bondrotptr[i]->angle = bondrotptr[i]->origangle;
       }
}
/*___restorebondrots()________________________________________________*/

/****initrot()*****initialize stored rotation matrix*************************/
void    initrot()
{
    int        i;
    
    for(i=1; i<=MAXRESETS ; i++)
    {
        ma[i][1] = 1.0;  
        ma[i][2] = 0.0;
        ma[i][3] = 0.0;
        ma[i][4] = 0.0;
        ma[i][5] = -1.0;  /* handedness of screen coordinates, */
        ma[i][6] = 0.0;        /* y mapped down from upper left, we map y up*/
        ma[i][7] = 0.0;
        ma[i][8] = 0.0;
        ma[i][9] = 1.0;
     }
 }
/*___initrot()______________________________________________________________*/

/****resetrot()*****reset rotation matrix, etc ******************************/
void    resetrot(int i)
{
    int j;  /* resetting is tricky since matrix, centering, zcliping can all*/
            /*  be set separately.  So undefined ones for a particular i  */
            /*  are reset to the 1st resetting */
    
    if(i <= MAXRESETS)/*980630*/
    {
        iviewset = i;
    /*---------------------------------*/
        if(Lreset[i]) j = i;
        else          j = 1;

        a11 = ma[j][1];
        a12 = ma[j][2];
        a13 = ma[j][3];
        a21 = ma[j][4];
        a22 = ma[j][5];
        a23 = ma[j][6];
        a31 = ma[j][7];
        a32 = ma[j][8];
        a33 = ma[j][9];
    /*---------------------------------*/
        if(Lzoomer[i]!=0) j = i;
        else           j = 1;
        if(Lzoomer[j] < 0) 
        {/* span value, span of screen: calculate appropriate zoom*/
           zoom = oldmaxwide/(Scale * zoomold[j]) ;
        }
        else
        {
           zoom = zoomold[j]; /*update current stored zoom value*/
        }
        scalenew = Scale*zoom;
        /*Lzoom = Lzoomer[j];*/
/*Zx*/  resetgrafzoomBar(); 
      /*izoomold[0] = izoomold[j];*/ /*update current stored zoom value */
        /*zoom itself holds this value  */
    /*---------------------------------*/
        if(Lcenter[i]) j = i;
        else           j = 1;
        fxcenternew = fxcenterold[j];
        fycenternew = fycenterold[j];
        fzcenternew = fzcenterold[j];
        fxcenterold[0] = fxcenterold[j]; /*update current stored center value*/
        fycenterold[0] = fycenterold[j]; 
        fzcenterold[0] = fzcenterold[j]; 
    /*----------------------------------*/
        if(Lzcliper[i]) j = i;
        else            j = 1;
        Lzclip = Lzcliper[j];
        izclip = (int)(izclipold[j]*fzclip); 
        resetgrafzclipBar(izclipold[j]);  /*___BAR.C*/
        izclipold[0] = izclipold[j]; /*update current stored zclip value */
    /*----------------------------------*/
        if(Lztraner[i]) j = i;
        else            j = 1;
        Lztran = Lztraner[j];
        iztran = (int)(iztranold[j]*fzclip); 
        resetgrafztranBar(iztranold[j]);  /*___BAR.C*/ 
        iztranold[0] = iztranold[j]; /*update current stored ztran value*/
    /*----------------------------------*/

    /*flatland only changes ixtran, iytran reset to zero anyway*/
        ixtran = 0;
        iytran = 0;

        checkcurrentviewmenu(i);  /*___MENU.C*/

        rescalekinemage(); /*MAGEINPT.c*/
    }
}
/*___resetrot()_____________________________________________________________*/

/****setrotview()*****reset rotation matrix, etc ****************************/
void    setrotview(int i)
{    
    iviewset = i; /*current last-set view */
    Lreset[i] = 1;  /* there is ith matrix */
    Lview[i] = 1;   /* there is ith view */
    
    ma[i][1] = a11;
    ma[i][2] = a12;
    ma[i][3] = a13;
    ma[i][4] = a21;
    ma[i][5] = a22;
    ma[i][6] = a23;
    ma[i][7] = a31;
    ma[i][8] = a32;
    ma[i][9] = a33;

    /*Lzoomer[i] set by calling routine  981013 */
    if(Lzoomer[i] >0)
        zoomold[i] = zoom;
    else if(Lzoomer[i] < 0)
        /*zoom = oldmaxwide/(Scale * zoomold[j]) ;*/
        zoomold[i] = oldmaxwide/(Scale * zoom);
    else  zoomold[i] = 1.0;/*arbitrary default, Lzoomer should be +-1*/
        
    /*scaleold[i] = scalenew;*/

    Lcenter[i] = 1;

    fxcenterold[i] = fxcenternew;
    fycenterold[i] = fycenternew;
    fzcenterold[i] = fzcenternew;

    if(Lzclip)  Lzcliper[i] = 1;
    else        Lzcliper[i] = 0;
    Lzcliper[i] = 1; /*artifact: Lzclip always==1*/
    izclipold[i] = izclipold[0]; /*stored current unscaled value*/ 
    

    if(Lztran) Lztraner[i] = 1;
    else       Lztraner[i] = 0;
    Lztraner[i] = 1; /*artifact: Lztran always==1*/
    iztranold[i] = iztranold[0]; /*stored current unscaled value*/ 
    
}
/*___setrotview()____________________________________________________________*/

/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****dodocktran()*************************************************************/
void    dodocktran(int i,float trans)
{
   float factorx,factory,factorz;     
   pointstruct* thepointptr;
   pointstruct* thelastpointptr;
   liststruct*  thelistptr;
   grupstruct*  thegrupptr;
    
/*beware: trans == bondrot theta, so rolls over at +-180*/ /*991202*/
   if(trans < -358) trans = +1;
   else if(trans > +358) trans = -1;
   /*translations damped by 0.1 for all methods, */
   /*see MAGEUTIL/getrot() for additional mouse motion damping*/
   if(i == 1)
   {/*screen oriented x motion*/
      factorx = (float)(0.1*trans)*a11;
      factory = (float)(0.1*trans)*a21;
      factorz = (float)(0.1*trans)*a31;
   }/*screen oriented x motion*/
   if(i == 2)
   {/*screen oriented y motion*/
     factorx = (float)(0.1*trans)*a12;
     factory = (float)(0.1*trans)*a22;
     factorz = (float)(0.1*trans)*a32;
   }/*screen oriented y motion*/
   if(i == 3)
   {/*screen oriented z motion*/
     factorx = (float)(0.1*trans)*a13;
     factory = (float)(0.1*trans)*a23;
     factorz = (float)(0.1*trans)*a33;
   }/*screen oriented z motion*/
    
   /*scope set by @beginselect and @endselect */
    
   thepointptr = beginselectionpointptr;
   thelastpointptr  = endselectionpointptr;
    
   /*first, update the gnomon points*/  
   thegrupptr = ((thepointptr->listptr)->sgrpptr)->grupptr;
   while(thegrupptr->bondrot == DOCKSET)
   {
      thegrupptr->pointx[0] = thegrupptr->pointx[0] + factorx;
      thegrupptr->pointx[1] = thegrupptr->pointx[1] + factory;
      thegrupptr->pointx[2] = thegrupptr->pointx[2] + factorz;

      thegrupptr->pointy[0] = thegrupptr->pointy[0] + factorx;
      thegrupptr->pointy[1] = thegrupptr->pointy[1] + factory;
      thegrupptr->pointy[2] = thegrupptr->pointy[2] + factorz;

      thegrupptr->pointz[0] = thegrupptr->pointz[0] + factorx;
      thegrupptr->pointz[1] = thegrupptr->pointz[1] + factory;
      thegrupptr->pointz[2] = thegrupptr->pointz[2] + factorz;

      thegrupptr->position[0] = thegrupptr->position[0] + factorx;
      thegrupptr->position[1] = thegrupptr->position[1] + factory;
      thegrupptr->position[2] = thegrupptr->position[2] + factorz;
      thegrupptr = thegrupptr->nextptr;
      if(thegrupptr == NULL) break;
   } 
   /*matrix elements are from the global current rotation matrix*/
   while(thepointptr != NULL)
   {/*loop over all points in scope*/
                thepointptr->fx = thepointptr->fx + factorx;
                thepointptr->fy = thepointptr->fy + factory;
                thepointptr->fz = thepointptr->fz + factorz;                        

      if(thepointptr == thelastpointptr)
      {/*end of scope*/
         thepointptr = NULL;
      }
      else if(thepointptr == (thepointptr->listptr)->lastpointptr)
      {/*at last point in a list*/
         /*970903 MAGE keeps track of all lists as a linked list during */
         /* allocliststructure() so only need to go up to the list level*/

         if((thepointptr->listptr)->nextptr != NULL)
         {/*there is a next list: get first point of next list*/
            thelistptr = (thepointptr->listptr)->nextptr;
            thepointptr = thelistptr->firstpointptr;
            if(thepointptr == NULL) /*list with NO points*/
            {
               while(   (thepointptr == NULL) /*current point*/
                     && (thelistptr->nextptr != NULL) ) /*next list*/
               {/*search for a non-NULL point in the scope*/
                 thelistptr = thelistptr->nextptr; /*next list*/
                 thepointptr = thelistptr->firstpointptr;
               }
            }
         }
         else
         {/*NO  more lists, no more points to rotate*/
            /*somehow thelastpointptr failed to be found*/
            thepointptr = NULL;
         }
      }/*at last point in a list*/
      else
      {
         thepointptr = thepointptr->nextptr;
      }
   }/*loop over all points in scope*/
}
/*___dodocktran()____________________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****dodockrot()*************************************************************/
void    dodockrot(int i,float theta)
{
 
    pointstruct* thepointptr;
    pointstruct* thelastpointptr;
    liststruct*  thelistptr;
    grupstruct*  thegrupptr;
    
    float fx1,fy1,fz1,fx2,fy2,fz2,centerx,centery,centerz;

    double detmatrix;

/*Docking rotations are screen oriented, original coordinates are actually */
/*in screen orientation.  Back rotate the chosen screen axes by the */
/*inverse of the global matrix then apply a general axis rotation to the */
/*original coords, offseting for the effective origin of the rotated set*/

    /* sin and cos of current delta angle of this axis */

      fx1 = 0.0;
      fy1 = 0.0;
      fz1 = 0.0;
      fx2 = 0.0;
      fy2 = 0.0;
      fz2 = 0.0;

    if     (i==1) fx1 = 1.0; /*screen x axis*/
    else if(i==2) fy1 = 1.0; /*screen y axis*/
    else if(i==3) fz1 = 1.0; /*screen z axis*/

    {/*calculate inverse rotation matrix*/
                detmatrix = a11*a22*a33+a12*a23*a31+a13*a21*a32
                           -a13*a22*a31-a11*a23*a32-a12*a21*a33;
                ma[0][1] = (float)((+a22*a33-a23*a32)/detmatrix);
                ma[0][4] = (float)((-a21*a33+a23*a31)/detmatrix);
                ma[0][7] = (float)((+a21*a32-a22*a31)/detmatrix);
                ma[0][2] = (float)((-a12*a33+a13*a32)/detmatrix);
                ma[0][5] = (float)((+a11*a33-a13*a31)/detmatrix);
                ma[0][8] = (float)((-a11*a32+a12*a31)/detmatrix);
                ma[0][3] = (float)((+a12*a23-a13*a22)/detmatrix);
                ma[0][6] = (float)((-a11*a23+a13*a21)/detmatrix);
                ma[0][9] = (float)((+a11*a22-a12*a21)/detmatrix);
             /*11=[1];12=[2];13=[3];21=[4];22=[5];23=[6];31=[7];32=[8];33=[9];*/
             /*use otherwise unused 0th matrix entries */
    }/*calculate inverse rotation matrix*/

/*back rotate the selected axis*/
              fx2 = (fx1*ma[0][1] + fy1*ma[0][4] + fz1*ma[0][7]);
              fy2 = (fx1*ma[0][2] + fy1*ma[0][5] + fz1*ma[0][8]);
              fz2 = (fx1*ma[0][3] + fy1*ma[0][6] + fz1*ma[0][9]);



    /*scope set by @beginselect and @endselect */
    
    thepointptr = beginselectionpointptr;
    thelastpointptr  = endselectionpointptr;

    /*centerx = beginselectionpointptr->fx;*/
    /*centery = beginselectionpointptr->fy;*/
    /*centerz = beginselectionpointptr->fz;*/
    /*use current center of the screen as center of the rotation*/ /*991202*/
    centerx = fxcenternew;
    centery = fycenternew;
    centerz = fzcenternew;

   /*first, update the gnomon points*/  
   thegrupptr = ((thepointptr->listptr)->sgrpptr)->grupptr;
   while(thegrupptr->bondrot == DOCKSET)
   {
      thegrupptr->pointx[0] = thegrupptr->pointx[0] - centerx;
      thegrupptr->pointx[1] = thegrupptr->pointx[1] - centery;
      thegrupptr->pointx[2] = thegrupptr->pointx[2] - centerz;
      doaxisrot(&(thegrupptr->pointx[0]),&(thegrupptr->pointx[1]),&(thegrupptr->pointx[2])
                     ,theta,(double)0.0,(double)0.0,(double)0.0
                           ,(double)fx2,(double)fy2,(double)fz2);/*MAGEANGL*/
      thegrupptr->pointx[0] = thegrupptr->pointx[0] + centerx;
      thegrupptr->pointx[1] = thegrupptr->pointx[1] + centery;
      thegrupptr->pointx[2] = thegrupptr->pointx[2] + centerz;
      
      thegrupptr->pointy[0] = thegrupptr->pointy[0] - centerx;
      thegrupptr->pointy[1] = thegrupptr->pointy[1] - centery;
      thegrupptr->pointy[2] = thegrupptr->pointy[2] - centerz;
      doaxisrot(&(thegrupptr->pointy[0]),&(thegrupptr->pointy[1]),&(thegrupptr->pointy[2])
                     ,theta,(double)0.0,(double)0.0,(double)0.0
                           ,(double)fx2,(double)fy2,(double)fz2);/*MAGEANGL*/
      thegrupptr->pointy[0] = thegrupptr->pointy[0] + centerx;
      thegrupptr->pointy[1] = thegrupptr->pointy[1] + centery;
      thegrupptr->pointy[2] = thegrupptr->pointy[2] + centerz;
      
      thegrupptr->pointz[0] = thegrupptr->pointz[0] - centerx;
      thegrupptr->pointz[1] = thegrupptr->pointz[1] - centery;
      thegrupptr->pointz[2] = thegrupptr->pointz[2] - centerz;
      doaxisrot(&(thegrupptr->pointz[0]),&(thegrupptr->pointz[1]),&(thegrupptr->pointz[2])
                     ,theta,(double)0.0,(double)0.0,(double)0.0
                           ,(double)fx2,(double)fy2,(double)fz2);/*MAGEANGL*/
      thegrupptr->pointz[0] = thegrupptr->pointz[0] + centerx;
      thegrupptr->pointz[1] = thegrupptr->pointz[1] + centery;
      thegrupptr->pointz[2] = thegrupptr->pointz[2] + centerz;
      
      thegrupptr->position[0] = thegrupptr->position[0] - centerx;
      thegrupptr->position[1] = thegrupptr->position[1] - centery;
      thegrupptr->position[2] = thegrupptr->position[2] - centerz;
      doaxisrot(&(thegrupptr->position[0]),&(thegrupptr->position[1]),&(thegrupptr->position[2])
                     ,theta,(double)0.0,(double)0.0,(double)0.0
                           ,(double)fx2,(double)fy2,(double)fz2);/*MAGEANGL*/
      thegrupptr->position[0] = thegrupptr->position[0] + centerx;
      thegrupptr->position[1] = thegrupptr->position[1] + centery;
      thegrupptr->position[2] = thegrupptr->position[2] + centerz;

      thegrupptr = thegrupptr->nextptr;
      if(thegrupptr == NULL) break;
   } 
    
    while(thepointptr != NULL)
    {/*loop over all points in scope*/
      thepointptr->fx = thepointptr->fx - centerx;
      thepointptr->fy = thepointptr->fy - centery;
      thepointptr->fz = thepointptr->fz - centerz;


      doaxisrot(&(thepointptr->fx),&(thepointptr->fy),&(thepointptr->fz)
                     ,theta,(double)0.0,(double)0.0,(double)0.0
                           ,(double)fx2,(double)fy2,(double)fz2);/*MAGEANGL*/

      thepointptr->fx = thepointptr->fx + centerx;
      thepointptr->fy = thepointptr->fy + centery;
      thepointptr->fz = thepointptr->fz + centerz;

      if(thepointptr == thelastpointptr)
      {/*end of scope*/
         thepointptr = NULL;
      }
      else if(thepointptr == (thepointptr->listptr)->lastpointptr)
      {/*at last point in a list*/
         /*970903 MAGE keeps track of all lists as a linked list during */
         /* allocliststructure() so only need to go up to the list level*/

         if((thepointptr->listptr)->nextptr != NULL)
         {/*there is a next list: get first point of next list*/
            thelistptr = (thepointptr->listptr)->nextptr;
            thepointptr = thelistptr->firstpointptr;
            if(thepointptr == NULL) /*list with NO points*/
            {
               while(   (thepointptr == NULL) /*current point*/
                     && (thelistptr->nextptr != NULL) ) /*next list*/
               {/*search for a non-NULL point in the scope*/
                 thelistptr = thelistptr->nextptr; /*next list*/
                 thepointptr = thelistptr->firstpointptr;
               }
            }
         }
         else
         {/*NO  more lists, no more points to rotate*/
            /*somehow thelastpointptr failed to be found*/
            thepointptr = NULL;
         }
      }/*at last point in a list*/
      else
      {
         thepointptr = thepointptr->nextptr;
      }

    }/*loop over all points in scope*/
}
/*___dodockrot()____________________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/

/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****dogangrotscan()**********************************************************/
void    dogangrotscan(int ifirst,float theta)
{
  int i;
  
  /*slider control points to first of a set of bondrotations distinguished*/
  /*by identical names*/
  /*scan all bondrots, picking out those with this option flagged*/
  /*and that have a name identical to this one*/
  for(i=ifirst; i<=nbondrot; i++)
  {
     if(bondrotptr[i]->level == -2 || bondrotptr[i]->level == -1)
     {/*one of a ganged set of rotations*/
        if(strncmp(bondrotptr[i]->name,bondrotptr[ifirst]->name,MAXNAMECHAR)==0)
        {/*one of THIS set of rotations*/
           dobondrot(i, theta);
        }
     }
  }
}
/*___dogangrotscan()_________________________________________________________*/

/****bondrotoptioner()*******************************************************/
int bondrotoptioner(int i) /*981010*/
{
   float thetheta,theangle;
   int ireturn; /*set ireturn == 1 for dobondrot() also*/

   theangle = bondrotptr[i]->angle; /*970917*/
   
   if(bondrotptr[i]->option == 2 )
   {
      restorebondrots(i-1,i-1); /*MAGEANGL*/
      restorebondrots(i-2,i-2);
      /*bring 2 preceeding angles back to initial settings*/
      /*reverse order helps samescope rotations return to actual start*/
      /*set previous two angles as precession angle components*/

      thetheta =
       (float)(bondrotptr[i+1]->angle*sin( (double)theangle*3.14159*2.0/360.0));/*970917*/
      bondrotptr[i-2]->angle = thetheta;
      dobondrot(i-2,thetheta);    /*MAGEANGL*/
      thetheta =
       (float)(bondrotptr[i+1]->angle*cos( (double)theangle*3.14159*2.0/360.0));/*970917*/
      bondrotptr[i-1]->angle = thetheta;
      dobondrot(i-1,thetheta);
      writebondrotvalue(i-2); /*____BAR.C*/
      writebondrotvalue(i-1); /*____BAR.C*/
      ireturn = 0; /*dobondrot() already done*/
   }
   else if(bondrotptr[i]->option == 1)
   {/*do nothing more than just change value of angle, e.g. mu */
      ireturn = 0;
   }
   else if(bondrotptr[i]->option == 4) /*dodockrot(1,(float)theta)*/
   {/*x docking rotation*/
      ireturn = 4;
   }
   else if(bondrotptr[i]->option == 5) /*dodockrot(2,(float)theta)*/
   {/*y docking rotation*/
      ireturn = 5;
   }
   else if(bondrotptr[i]->option == 6) /*dodockrot(3,(float)theta)*/
   {/*z docking rotation*/
      ireturn = 6;
   }
   else if(bondrotptr[i]->option == 7) /*dodocktran(1,(float)theta)*/
   {/*x docking translation*/
      ireturn = 7;
   }
   else if(bondrotptr[i]->option == 8) /*dodocktran(2,(float)theta)*/
   {/*y docking translation*/
      ireturn = 8;
   }
   else if(bondrotptr[i]->option == 9) /*dodocktran(3,(float)theta)*/
   {/*z docking translation*/
      ireturn = 9;
   }
   else if(bondrotptr[i]->option == 10)
   {/*ganged rotations*/
      ireturn = 10;
   }

   else ireturn = 1; /*presume need yet to do dobondrot()*/
   return(ireturn);
}
/*____bondrotoptioner()______________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****bondrotbyoption()********************************************************/
void bondrotbyoption(int iflag, float theta) /*001005*/
{
   int i=0,it = 0;
   float angle = 0;
   
   for(i=1; i<=nbondrot; i++)
   {
      if(bondrotptr[i]->option == iflag)
      {
         it = i;
         break;
      }
   }
   if(it > 0 && iflag >= 4 && iflag <=9)
   {/*found it*/
      angle = bondrotptr[it]->angle; /*present displayed slider value*/
      angle = angle + theta; /*add in change to value*/
      /*adjust to be within -180 -- +180 range*/
      while(angle > 180 || angle < -180)
      {
         if(angle > 180) angle = angle - 360;
         else if(angle < -180) angle = angle + 360;
      }
      bondrotptr[it]->angle = angle; /*new value*/
      resetgrafbondrotBar(it);

      if     (iflag==4) dodockrot(1,(float)theta);
      else if(iflag==5) dodockrot(2,(float)theta);
      else if(iflag==6) dodockrot(3,(float)theta);
      else if(iflag==7) dodocktran(1,(float)theta);
      else if(iflag==8) dodocktran(2,(float)theta);
      else if(iflag==9) dodocktran(3,(float)theta);
   }
}
/*___bondrotbyoption()_______________________________________________________*/

/****dobondrotrouter()********************************************************/
void dobondrotrouter(int i, float theta)                  
{/*some bondrot options substitute, or do not require dobondrot()*/
   int iflag;
                  
   if(bondrotptr[i]->option > 0 ) 
       iflag = bondrotoptioner(i); /*MAGEANGL.c*/ /*981010*/
   else iflag = 1;
   /*do bond rotation matrix update and apply */
/*printf("dobondrotrouter: dodockrot(%d, %.3f)\n",iflag,theta);*/
   if(iflag==1) dobondrot(i,theta);  /*MAGEANGL.C*/
      /* rotation done on float array entries ! */                   
   else if(iflag==4) dodockrot(1,(float)theta);
   else if(iflag==5) dodockrot(2,(float)theta);
   else if(iflag==6) dodockrot(3,(float)theta);
   else if(iflag==7) dodocktran(1,(float)theta);
   else if(iflag==8) dodocktran(2,(float)theta);
   else if(iflag==9) dodocktran(3,(float)theta);
   else if(iflag==10) dogangrotscan(i,(float)theta);
   resetgraphedrotamer(i); /*MAGEANGL.c, checks for this graphing*/
   /*need this since can get here without invoking resetgrafbondrotBar()*/
}
/*___dobondrotrouter_________________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****grafbondrotarrow()*******************************************************/
void grafbondrotarrow(float theta)
{
   bondrotptr[icurrentrotation]->angle 
      = bondrotptr[icurrentrotation]->angle + theta;
   if(bondrotptr[icurrentrotation]->angle >  180.0) 
      bondrotptr[icurrentrotation]->angle = -179.0;
   if(bondrotptr[icurrentrotation]->angle < -180.0) 
      bondrotptr[icurrentrotation]->angle =  179.0;
   resetgrafbondrotBar(icurrentrotation); /*____BAR.c*/
   dobondrotrouter(icurrentrotation,theta);/*MAGEANGL.c*/
   if(Lupdate && !Linhibiton)
   {/*update from remote program: e.g. dots by PROBE*/
       sprintf(word,"\""); /*ditto mark*/
       doupdate(1,word); /*MUXMOUT.c*/  /*970522*/
       /* 1: deletes old dots before reloading them*/
       UpdateAppendedSets(); /*MAGEBBOX.c*/ /*970905*/ /*was below bracket*/
   }
   rescalekinemage(); /*MAGEINPT.C*/
                      /* rescale rebuilds from float arrary*/
   redrawvec(); /*MAGEDRAW.c*/
} 
/*___grafbondrotarrow()_____________________________________________________*/

/****dobondrotgrapher()******************************************************/
void dobondrotgrapher()  /*001002*/
{
   float theta=0,thetain=0,thetaout=0,angle=0;
   int i=0,j=0;

  if(pickedpointptr != NULL)
  {/*picked point exists*/
   if(  (LbondrotHplot > 0 && LbondrotVplot > 0)
      &&((pickedpointptr->STATUS & SCREENFLAG) == SCREENFLAG) )
   {/*screen oriented and sized plot is present and was site of last pick*/
      for(j=1; j<=2; j++)
      {/*map pick x to angle plotted horizontally and y to vertical one*/
         if(j==1)
         {
            i = LbondrotHplot;
            angle = pickedpointptr->fx;
         }
         else
         {
            i = LbondrotVplot;
            angle = pickedpointptr->fy;
         }
         if(angle<0.0) 
              thetain = 360 + angle;
         else thetain = angle;
         if(bondrotptr[i]->angle<0.0) 
              thetaout = 360 + bondrotptr[i]->angle;
         else thetaout = bondrotptr[i]->angle;
         theta = thetain - thetaout;
         if(theta >  180) theta =  theta - 360;
         if(theta < -180) theta =  theta + 360;
         dobondrot(i,theta);
         bondrotptr[i]->angle = angle;
         resetgrafbondrotBar(i); /*___BAR.C*/ /*001005*/
      }
      if(Lupdate && !Linhibiton)
      {/*update from remote program: e.g. dots by PROBE*/
         sprintf(word,"\""); /*ditto mark*/
         doupdate(1,word); /*MUXMOUT.c*/  /*970522*/
         /* 1: deletes old dots before reloading them*/
         UpdateAppendedSets(); /*MAGEBBOX.c*/ /*970905*/ /*was below bracket*/
      }
      rescalekinemage(); /*MAGEINPT.c*/ /*rescale rebuilds from float array*/
      redrawvec(); /*MAGEDRAW.c*/
   }/*screen oriented and sized plot is present and was site of last pick*/
  }/*picked point exists*/
}
/*___dobondrotgrapher()_____________________________________________________*/

/****resetgraphedrotamer()***************************************************/
void resetgraphedrotamer(int i)  /*001007*/
{/*update the plotted ROTAMER*/
   if(i == LbondrotHplot)
   {
      (drawnewlistptr->firstpointptr)->fx = bondrotptr[LbondrotHplot]->angle;
   }
   if(i == LbondrotVplot)
   {
      (drawnewlistptr->firstpointptr)->fy = bondrotptr[LbondrotVplot]->angle;
   }
}
/*___resetgraphedrotamer()__________________________________________________*/

/****dobondrotplotter()******************************************************/
void dobondrotplotter()  /*971011*/
{
   allocpointstructure(drawnewlistptr);
   if((bondrotptr[LbondrotHplot]->angle) >= 180)
      thispointptr->fx = (bondrotptr[LbondrotHplot]->angle) -360 ;
   else
      thispointptr->fx = (bondrotptr[LbondrotHplot]->angle);
   if((bondrotptr[LbondrotVplot]->angle) >= 180)
      thispointptr->fy = (bondrotptr[LbondrotVplot]->angle) -360 ;
   else
      thispointptr->fy = (bondrotptr[LbondrotVplot]->angle);
   thispointptr->fz = 0.0;
   thispointptr->type = DOT;
   thispointptr->STATUS = thispointptr->STATUS | SCREENFLAG | STATICFLAG;
   sprintf(word,"%.2f,%.2f"
            ,bondrotptr[LbondrotHplot]->angle
            ,bondrotptr[LbondrotVplot]->angle);
   storeptIDstring(word, thispointptr); /*MAGELIST*/
   numberline++;
   maxnxyz++;
   rescalekinemage(); /*MAGEINPT.C*/
       /* rescale rebuilds from float arrary*/
   redrawvec(); /*MAGEDRAW.c*/
}
/*___dobondrotplotter()_____________________________________________________*/

/****doxrayplotter()******************************************************/
void doxrayplotter(pointstructptr ptptr, float ctr, int* Lnew, int* Lold)
{/*xray from XL at origin to film, Ewald ctr +z axis, film same distance -z*/
 /*reciprocal lattice point on Ewald sphere at x,y,z*/
   static struct grupstruct* spotgrupptr;
   static struct sgrpstruct* spotsgrpptr;
   static struct liststruct* spotlistptr;
   
   /*NEEDS better protections against missing/naming structures */
   
   /*first, need group in which to hold these projected points*/
   if(*Lold==0)
   {
      getnewgroup(); /*sets to itself the glabal: thisgrupptr */
         /* and becomes lastgrupptr so MAGEDRAW will find it*/
      spotgrupptr = thisgrupptr;
      sprintf(spotgrupptr->name," FILM SPOTS");/*note blank 1st char*/
      spotgrupptr->STATUS = spotgrupptr->STATUS | DOMINANT;
      spotgrupptr->on = 1;
      
      getnewsubgroup(); /*sets to itself the glabal: thissgrpptr */
      spotsgrpptr = thissgrpptr;
      spotsgrpptr->grupptr = spotgrupptr; /*acknowledge parent*/
      spotgrupptr->lastsgrpptr = spotsgrpptr;
         /* adjust pointer in parent group to include this subgroup */
      spotgrupptr->firstsgrpptr = spotsgrpptr;/*parent only has this subgroup*/
      spotsgrpptr->on = 1;
      
      getnewlist(); /*sets to itself the glabal: thislistptr */
      spotlistptr = thislistptr;
      spotlistptr->sgrpptr = spotsgrpptr; /*acknowledge parent*/
      spotlistptr->sgrpptr = spotsgrpptr; /*acknowledge parent*/
      spotsgrpptr->lastlistptr = spotlistptr;
         /* adjust pointer in parent subgroup to include this list */
      spotsgrpptr->firstlistptr = spotlistptr;/*parent only has this list */
      spotlistptr->on = 1;
      *Lnew = 0;
      *Lold = 1;
      SetsinGrafWindow();
   }
   else if(*Lnew==1)
   {
      destroyliststructure(spotlistptr);
      thissgrpptr = spotsgrpptr;
      getnewlist(); /*sets to itself the glabal: thislistptr */
      spotlistptr = thislistptr;
      spotlistptr->sgrpptr = spotsgrpptr; /*acknowledge parent*/
      spotsgrpptr->lastlistptr = spotlistptr;
         /* adjust pointer in parent subgroup to include this list */
      spotsgrpptr->firstlistptr = spotlistptr;/*parent only has this list */
      spotlistptr->on = 1;
      *Lnew = 0;     
   }
   allocpointstructure(spotlistptr);
   thispointptr->fx = ptptr->fx + (ptptr->fx*ptptr->fz)/(ctr - ptptr->fz);
   thispointptr->fy = ptptr->fy + (ptptr->fy*ptptr->fz)/(ctr - ptptr->fz);
   thispointptr->fz = -ctr;
   thispointptr->type = DOT;
   getptIDstring(word, ptptr);
   storeptIDstring(word, thispointptr); /*MAGELIST*/
   calcintegerpoints(thispointptr); /*MAGELIST*/
/*
printf("on film: {%s}  %d, %d, %d pruned%d? %d\n"
  , word, thispointptr->ix,thispointptr->iy,thispointptr->iz
  ,PRUNED,thispointptr->type);
*/
}
/*___doxrayplotter()_____________________________________________________*/

