/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/*MAGEDLOG.c*/

#include "MAGE.h"
#include "MAGELIST.h"
#include "MAGEANGL.h"
#include "MAGEFLAG.h"  /*971025 perpendicular*/
#include "MAGEBBOX.h"

#define EXTERNDLOG
#include "MAGEDLOG.h"

#include "MAGEMENU.h"
#include "MAGETABL.h"

/****cleargenericflags()*****************************************************/
void cleargenericflags()
{
 Ldlog_option  = 0;
 Ldlog_subject = 0;
 Ldlog_paramA  = 0;
 Ldlog_textA   = 0;
 Ldlog_paramB  = 0;
 Ldlog_textB   = 0;
 Ldlog_paramC  = 0;
 Ldlog_textC   = 0;
 Ldlog_paramD  = 0;
 Ldlog_textD   = 0;

 Ldlog_info    = 0;
 
 Ldlog_checkA  = 0;
 Ldlog_checkB  = 0;
 Ldlog_checkC  = 0;
 Ldlog_checkD  = 0;
 Ldlog_checkE  = 0;
 
 Ldlog_radioA  = 0;
 Ldlog_radioB  = 0;
 Ldlog_radioC  = 0;
 Ldlog_radioD  = 0;
 Ldlog_radioE  = 0;
 
 sprintf(dlog_OKstr,"OK");
 sprintf(dlog_cancelstr,"CANCEL");
 sprintf(dlog_optionstr," ");      /*970408*/
 sprintf(dlog_textAstr,"           "); /*can use for additional message*/
 sprintf(dlog_textBstr,"           "); /*can use for additional message*/
 sprintf(dlog_textCstr,"           "); /*can use for additional message*/
 sprintf(dlog_textDstr,"           "); /*can use for additional message*/
 
 ACTIVE_DLOG = 0;
 Ldlog_OKHIT = 0;
 Ldlog_cancelHIT = 0;
 Ldlog_optionHIT = 0;
}
/*___cleargenericflags()____________________________________________________*/

/****colorshow_update()******************************************************/
void colorshow_update(int listcolor, int pointcolor)
{
       if(pickedlistptr->colorset != 0)
       {/*this list is part of a named colorset, change color of all members*/
          adjustcolorset(pickedlistptr->colorset, listcolor);
       }

	pickedlistptr->color = listcolor;
	pickedpointptr->colorwidth
		=pointcolor|((pickedpointptr->colorwidth)&~31);
		/* ~31:one's compliment of 31, i.e. bits 1->0,0->1*/
	redrawvec(); /* redraw to show changes */
}
/*___colorshow_update()_____________________________________________________*/

/****dosinglealert()*********************************************************/
void    dosinglealert(int mode) /*only alertstr has current information*/
{
 if(Ltest||Lformattest)
  {
     alertstr2[0]='\0'; 
            alertstr3[0]='\0'; 
#ifdef UNIX_X11
            printf("%s\n",alertstr); /*UNIX has functional console window*/
                                     /*which doesn't overlap graphics*/
                                     /*and allows program to be ^c killed*/
#else
            DoMageDLOGreport(mode); /*mode 2 for abort, 3 for toggle debug*/
#endif
 }
}
/*___dosinglealert()________________________________________________________*/

/****DokineDialog()**********************************************************/
void    DokineDialog(void)
{
  if(!ACTIVE_DLOG)
     {
         cleargenericflags(); /*MAGEDLOG.c*/
         kineDialog();        /*MAGEDLOG.c*/
         DogenericDialog();   /*____DLOG.c*/
#ifndef UNIX_X11 /*called after DLOG_OKHIT_CB */ 
         EndkineDialog();     /*MAGEDLOG*/
#endif
     }
}
/*___DokineDialog()_________________________________________________________*/

/****kineDialog()************************************************************/
void    kineDialog()
{
    sprintf(dlog_subjectstr,"Kinemage choose");
    Ldlog_subject = 1;
    if(atEOF) sprintf(dlog_infostr,"this kinemage = %d, next = %d, at EOF",
                            thiskinenum,kinemagenum);
    else      sprintf(dlog_infostr,"this kinemage = %d, next = %d "       ,
                            thiskinenum,kinemagenum);
    Ldlog_info = 1;
    
    sprintf(dlog_paramAstr,"0"); 
        /*set 0 so simple return will return to first kinemage*/
    Ldlog_paramA = 1;
    sprintf(dlog_textAstr,"choose kinemage number"); 
    Ldlog_textA = 1;
    sprintf(dlog_optionstr,"NEXT");
    Ldlog_option = 1;
    Lnextkine = 0;
    Lcancel = 0;
    ACTIVE_DLOG = KINE_DLOG;
}
/*___kineDialog()___________________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****EndkineDialog()*********************************************************/    
void    EndkineDialog()
{    
 if(Ldlog_OKHIT)
 {
     /* interpret dlog_paramstr as kinemage number */
     nextkinenum = intfromstr(dlog_paramAstr);
     /*if(nextkinenum < 0) nextkinenum = 0;*/ /*971129 become permissive*/
     findkinemage();  /*MAGEFILE.C*/  /*971129*/
 }
 else if(Ldlog_optionHIT)
 {
     /* just take the next kinemage */
     nextkinenum = kinemagenum; /* There is a next number known*/
     Lnextkine = 1; /* take whatever is next */
     findkinemage();  /*MAGEFILE.C*/  /*971129*/
 }
 else if(Ldlog_cancelHIT)
 {
     /* don't change anything, just stay with current kinemage */
     Lcancel = 1;
 }
 ACTIVE_DLOG = 0;
}
/*___EndkineDialog()________________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****DocursorDialog()********************************************************/
void    DocursorDialog(void) /*980804*/
{
  if(!ACTIVE_DLOG)
     {
         cleargenericflags(); /*MAGEDLOG.c*/
         cursorDialog();        /*MAGEDLOG.c*/
         DogenericDialog();   /*____DLOG.c*/
#ifndef UNIX_X11 /*called after DLOG_OKHIT_CB */ 
         EndcursorDialog();     /*MAGEDLOG*/
#endif
     }
}
/*___DocursorDialog()_______________________________________________________*/

/****cursorDialog()**********************************************************/
void    cursorDialog() /*980804*/
{
    sprintf(dlog_subjectstr,"cursor choice");
    Ldlog_subject = 1;

    dlog_radioAint = 0;
    dlog_radioBint = 0;
    dlog_radioCint = 0;
    
    if     (Ncursorchoice == 0) dlog_radioAint = 1;
    else if(Ncursorchoice == 1) dlog_radioBint = 1;
    else if(Ncursorchoice == 2) dlog_radioCint = 1;
      
    sprintf(dlog_radioAstr,"mage cursor"); 
    Ldlog_radioA = 1;
    sprintf(dlog_radioBstr,"plane cursor"); 
    Ldlog_radioB = 1;
    sprintf(dlog_radioCstr,"ship cursor"); 
    Ldlog_radioC = 1;

    ACTIVE_DLOG = CURSOR_DLOG;
}
/*___cursorDialog()_________________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****EndcursorDialog()*******************************************************/    
void    EndcursorDialog() /*980804*/
{    
 if(Ldlog_OKHIT)
 {
    if     (dlog_radioAint == 1) Ncursorchoice = 0;
    else if(dlog_radioBint == 1) Ncursorchoice = 1;
    else if(dlog_radioCint == 1) Ncursorchoice = 2;
    else                         Ncursorchoice = 0;
 }
 else if(Ldlog_cancelHIT)
 {
     /* don't change anything, just stay with current kinemage */
 }
 ACTIVE_DLOG = 0;
}
/*___EndcursorDialog()______________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/

/****DostereoDialog()********************************************************/
void    DostereoDialog()
{
   if(!ACTIVE_DLOG)
  {
      cleargenericflags();  /*MAGEDLOG.c*/
      stereoDialog();       /*MAGEDLOG.c*/
      DogenericDialog();    /*____DLOG.c*/
#ifndef UNIX_X11 /*called after DLOG_OKHIT_CB */ 
            EndstereoDialog();    /*MAGEDLOG.c*/
            /*970408*/ /*build redrawvec() etc. into EndstereoDialog*/
#endif
        }
}
/*___DostereoDialog()_______________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****stereoDialog()**********************************************************/
void    stereoDialog()
{
 sprintf(dlog_subjectstr,"Stereo parameters");
 Ldlog_subject = 1;
 sprintf(dlog_infostr,"                             default  current"
                        CRLF" full angle:            %.2f     %.2f"
                        CRLF" full separation:    %d         %d"
                        ,defaultangle,stereoangle,ieyedefault,ieyewide);
 Ldlog_info = 1;
 
 sprintf(dlog_paramAstr,"%.2f",stereoangle);
 Ldlog_paramA = 1;
 sprintf(dlog_textAstr,"set full stereo angle (degrees)");
 Ldlog_textA = 1;
 
 sprintf(dlog_paramBstr,"%d",ieyewide);
 Ldlog_paramB = 1;
 sprintf(dlog_textBstr,"set full separation (pixels)");
 Ldlog_textB = 1;
 
 sprintf(dlog_paramCstr,"%d",TBYoffset); /*970603*/
 Ldlog_paramC = 1;
 sprintf(dlog_textCstr,"TB Y offset (pixels)");
 Ldlog_textC = 1;

 sprintf(dlog_paramDstr,"%d",ieyeposition);
 Ldlog_paramD = 1;
 sprintf(dlog_textDstr,"set perspective eye position (pixels)");
 Ldlog_textD = 1;

 dlog_checkAint = LTBstereo;
 sprintf(dlog_checkAstr,"Top/Bottom for StereoGraphics CrystalEyes");
 Ldlog_checkA = 1;
/*rotation around eye position adds considerable load to inner loop*/
/*requires back calc of eyeposition as a center in object space*/
/*which then has to be subtracted before, added after, each points rotation*/
/*
 dlog_checkBint = Lrotateye;
 sprintf(dlog_checkBstr,"rotate around eye position");
 Ldlog_checkB = 1;
*/ 
 dlog_checkBint = Lcenterinfo;
 sprintf(dlog_checkBstr,"ptID and dist near center line");
 Ldlog_checkB = 1;

 sprintf(dlog_optionstr,"use defaults");
 Ldlog_option = 1;
 ACTIVE_DLOG = STEREO_DLOG;
}
/*___stereoDialog()_________________________________________________________*/

/****EndstereoDialog()*******************************************************/
void    EndstereoDialog()
{
 ACTIVE_DLOG = 0;
 if(Ldlog_OKHIT) 
 {
      stereoangle = floatfromstr(dlog_paramAstr);
      ieyewide = intfromstr(dlog_paramBstr);
      LTBstereo = dlog_checkAint;
      TBYoffset = intfromstr(dlog_paramCstr);
      ieyeposition = intfromstr(dlog_paramDstr);
      /*Lrotateye = dlog_checkBint;*/
      Lcenterinfo = dlog_checkBint;
         /*ON: write ptID and dist near center line*/
      adjuststereo(); /*MAGEMENU*/
 }
 else if(Ldlog_optionHIT)
 {
      stereoangle = defaultangle;
      ieyewide = ieyedefault;
      /*does NOT change stereo state, so windows, etc. stays the same*/
      
      ieyeposition = ieyeposdefault;
      /*Lrotateye = 0;*/ /*default: rotate around image object's center*/
      Lcenterinfo = 0; /*ON: write ptID and dist near center line*/
      redrawvec();  /*on spec.*/
 }
 else if(Ldlog_cancelHIT)
 {
      Lcancel = 1; /* don't change anything, just stay with current values */
 }
}
/*___EndstereoDialog()______________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/

/*****DodrawlineDialog*******************************************************/
void    DodrawlineDialog()
{
     if(!ACTIVE_DLOG) 
     {
         cleargenericflags();  /*MAGEDLOG.c*/
         drawlineDialog();     /*MAGEDLOG.c*/
         DogenericDialog();    /*MACDLOG.c*/
#ifndef UNIX_X11 /*called after DLOG_OKHIT_CB */ 
         EnddrawlineDialog();  /*MAGEDLOG.c*/
#endif
         SetsinGrafWindow();       /*MAGEBBOX.c*/
#ifdef MACINTOSH
         DrawControls(grafWindow); /*m*/
#endif
         redrawvec();              /*____DRAW*/ 
     }
}
/*___DodrawlineDialog_______________________________________________________*/

/****drawlineDialog()********************************************************/
void    drawlineDialog()  /*971129*/
{
 /*initial preferences if draw new not previously invoked */
 if(!Ldrawline)
 {
      Ldrawlineon = 0;
      if(shortenline >.00001 || shortenline < -.00001) Ldrawunpickable = 1;
      else Ldrawunpickable = 0;
 }
 
 sprintf(dlog_subjectstr
         ,"draw new: New Group of user-drawn lines and/or labels");
 Ldlog_subject = 1;
 sprintf(dlog_paramAstr,"%.2f",shortenline);
 Ldlog_paramA = 1;
 sprintf(dlog_textAstr,"shorten lines by this amount");
 Ldlog_textA = 1;
 dlog_checkAint = Ldrawunpickable;
 sprintf(dlog_checkAstr,"line ends unpickable");
 Ldlog_checkA = 1;
 dlog_checkBint = Lmonitor;
 sprintf(dlog_checkBstr,"Monitor last line length");
 Ldlog_checkB = 1;

 dlog_checkCint = LSplitLine;/*971124SplitLine*/
 sprintf(dlog_checkCstr,"DrawLine in 2 parts");
 Ldlog_checkC = 1;

 dlog_checkDint = Ldottedline;
 sprintf(dlog_checkDstr,"dotted line");
 Ldlog_checkD = 1;

 dlog_checkEint = Larrowline;
 sprintf(dlog_checkEstr,"arrow");
 Ldlog_checkE = 1;

#define MOVEDTODRAWHELP
#ifdef MOVEDTODRAWHELP /*971122*/ 
 sprintf(dlog_infostr
      ,"Labels - pick 1: pointID -> label at that point"
      CRLF"Drawnlines - pick 1,2: get line 1->2"
      CRLF"constructlines - pick 1,2,3: get line 3->4: with specified length, "
      "angle, and dihedral"
      CRLF"Draglines - pick 1: and drag out line anywhere "
      "(can pick end and drag again)"
  );
 Ldlog_info = 1;
#endif

 /*sprintf(dlog_optionstr,"OFF");*/  /*971129*/
 /*Ldlog_option = 1;*/
 sprintf(dlog_OKstr,"OK");  /*971129*/
 
 ACTIVE_DLOG = DRAWNEW_DLOG;
}
/*___drawlineDialog()_______________________________________________________*/

/****EnddrawlineDialog()*****************************************************/
void    EnddrawlineDialog()  /*971129*/
{
 
 if(Ldlog_cancelHIT) ; /*do nothing, ignore any changes*/ 
 else if(Ldlog_OKHIT) 
 {
                /*maybe wanted to change shortenline value*/
                /*maybe unpickable is set/unset*/
                /*maybe monitor last line is set/unset*/
           shortenline = floatfromstr(dlog_paramAstr); /*MAGEUTIL.C*/
           Ldrawunpickable = dlog_checkAint;
           Lmonitor = dlog_checkBint;
           if(Lmonitor) Lmonitoron = 1;
           else         Lmonitoron = 0;

           LSplitLine  = dlog_checkCint; /*971124SplitLine*/
           Ldottedline = dlog_checkDint; /*990710*/
           Larrowline  = dlog_checkEint;
 }
 resetmenuchecks(); /*MAGEMENU*/  /*971010*/ 
 ACTIVE_DLOG = 0; 
}
/*___EnddrawlineDialog()____________________________________________________*/

/****DoConstructFifthDialog()************************************************/
void    DoConstructFifthDialog()  /*971122*/
{
 if(!ACTIVE_DLOG) 
 {
    cleargenericflags();  /*MAGEDLOG.c*/
    ConstructFifthDialog();       /*MAGEDLOG.c*/
    DogenericDialog();    /*____DLOG.c*/
#ifndef UNIX_X11 /*called after DLOG_OKHIT_CB */ 
    EndConstructFifthDialog();    /*MAGEDLOG.c*/
#endif
 }
}
/*___DoConstructFifthDialog()_______________________________________________*/

/****ConstructFifthDialog()**************************************************/
void    ConstructFifthDialog()  /*971122*/
{
 sprintf(dlog_subjectstr
    ,"Construct line to 5th pt, or line 5--6 based on previous 4 points");
 Ldlog_subject = 1;
 
 dlog_radioAint = LPerpendicularToPlane; 
 sprintf(dlog_radioAstr,"Perpendicular from 4th pt to plane 1--2--3");
 Ldlog_radioA = 1;
 
 dlog_radioBint = LPerpendicularBetweenLines;  
 sprintf(dlog_radioBstr,"Perpendicular between lines 1--2 & 3--4");
 Ldlog_radioB = 1;
 
 dlog_radioCint = LShortestBetweenLinesegments;  
 sprintf(dlog_radioCstr,"Shortest distance between segments 1--2 & 3--4");
 Ldlog_radioC = 1;
 
 ACTIVE_DLOG = CONSTRUCTFIFTH_DLOG;
}
/*___ConstructFifthDialog()_________________________________________________*/

/****EndConstructFifthDialog()***********************************************/
void    EndConstructFifthDialog()  /*971122*/
{
  if(Ldlog_OKHIT) 
  {
    LPerpendicularToPlane = dlog_radioAint;
    LPerpendicularBetweenLines = dlog_radioBint;
    LShortestBetweenLinesegments = dlog_radioCint;
    Lconstructperpendicular = 1;
    doconstructline();    /*MAGEANGL.C*/
  }
  else if(Ldlog_cancelHIT)
  {
    LPerpendicularToPlane = 0;
    LPerpendicularBetweenLines = 0;
    LShortestBetweenLinesegments = 0;
  }
  Lconstructperpendicular = 0;
  LPerpendicularToPlane = 0;
  LPerpendicularBetweenLines = 0;
  LShortestBetweenLinesegments = 0;
  drawmarker1listptr->on = 0; /*turn off point indicaters*/
  drawmarker2listptr->on = 0;
  drawmarker3listptr->on = 0;
  drawmarker4listptr->on = 0;
  Lpoint = 0;

  ACTIVE_DLOG = 0;
}
/*___EndConstructFifthDialog()______________________________________________*/

/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*//*****DoSearchDialog*********************************************************/
/* is done in a platform specific way because it is reentrant               */
/*___DoSearchDialog_________________________________________________________*/  
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****SearchDialog()**********************************************************/
void    SearchDialog()
{
 sprintf(dlog_subjectstr
    ,"Search pointID character strings for a combination of partial strings");
 Ldlog_subject = 1;
 sprintf(dlog_paramAstr,"%s",search1str);
 Ldlog_paramA = 1;
 sprintf(dlog_textAstr,"Primary character string");
 Ldlog_textA = 1;
 sprintf(dlog_paramBstr,"%s",search2str);
 Ldlog_paramB = 1;
 sprintf(dlog_textBstr,"Optional additional character string");
 Ldlog_textB = 1;

 sprintf(dlog_paramCstr," "); /*keep this blank*/
 Ldlog_paramC = 0; /*don't show this box*/
 Ldlog_textC = 1; /*use dlog_textCstr for NOT FOUND message*/
 
 if( Lmarkers) /*markers are in maxgrp+1 if there was room */
 {       
     /*if there are markers available and nothing is on that*/
     /*will flag that a search was successful, turn markers on*/
     if(!Lnewlabelson && !Lpickon && !markergrupptr->on)
     {
          dlog_checkAint = 1;
          /*markergrupptr->on = 1;*/ /*force markers group on*/ /*not yet, 990119*/
     }
     else dlog_checkAint = markergrupptr->on; /*as it was*/
     sprintf(dlog_checkAstr,"markers on");
     Ldlog_checkA = 1;
 }
 else
 {     
     dlog_checkAint = 0; /*no markers possible*/
     sprintf(dlog_checkAstr," ");
     Ldlog_checkA = 0;
 }
 dlog_checkBint = Lpickon;
 sprintf(dlog_checkBstr,"pickcenter on");
 Ldlog_checkB = 1;

 if(Ltablepresent)
 {
    dlog_checkCint = Ltablesearch; /*000324*/
    sprintf(dlog_checkCstr,"search table cells");
    Ldlog_checkC = 1;
 }

 dlog_radioAint = Lsearchbegin=1; 
 sprintf(dlog_radioAstr,"Search from beginning");
 Ldlog_radioA = 1;
 dlog_radioBint = !Lsearchbegin;  
 sprintf(dlog_radioBstr,"Find next occurrence");
 Ldlog_radioB = 1;
 
 sprintf(dlog_OKstr,"Find");
 sprintf(dlog_cancelstr,"CANCEL");
 
 
 sprintf(dlog_optionstr,"Mark found pt again");
 Ldlog_option = 1;
 
 sprintf(dlog_infostr,"marker, pickcenter, or label can be placed"
         CRLF"  use draw-new to set up for label");
 Ldlog_info = 1;

 ACTIVE_DLOG = FIND_DLOG;
}
/*___SearchDialog()_________________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****EndSearchDialog()*******************************************************/
void    EndSearchDialog()
{
 int Lfound = 0; /*000324*/
 int Nblank = 0; /*000410*/
 
 if(Ldlog_OKHIT) 
 {
    markergrupptr->on = dlog_checkAint; 
    Lpickon = dlog_checkBint;
    if(Ltablepresent) {Ltablesearch = dlog_checkCint;}
    Lsearchbegin = dlog_radioAint; /* 1 search from beginning*/
                                   /* 0 find next occurrence*/
    if(Lsearchbegin || !Lsearchatend)
    {/*can do a search*/
      /*recondition(dlog_paramAstr);*/ /*MACMAIN.C, dummied in ___MAIN.C*/
                                   /*MAC: changes P to C string */   
         /*970818 done in MACDLOG/genericDialog() */
      
      sprintf(search1str,"%s",dlog_paramAstr); 

      for(isearch1=0; search1str[isearch1]!='\0';isearch1++) /*count char*/ /*980630*/
      {
         if(search1str[isearch1]==' ') Nblank++; /*000410*/
      }
      if(Nblank == isearch1) isearch1 = 0; /*Do NOT search for field of blank(s) */

      /*recondition(dlog_paramBstr);*/ /*970818 done in MACDLOG/genericDialog() */
      sprintf(search2str,"%s",dlog_paramBstr); 
      for(isearch2=0; search2str[isearch2]!='\0';isearch2++){ ; } /*count char*/
         /*980630*/
      
      if(isearch1 > 0) /*at least one char in essential string */
      {
          if(Ltablepresent && Ltablesearch)
          {/*search table cell contents: <comment> flag==1*/
             Lfound = searchtablecells(1); /*MAGETABL.c*/  /*000324*/
             if(Lfound) /*000411*/
             {/*back pick this table cell to its corresponding points in graphics*/
                removetablemarkpoints();
                markfromtablecellsID(1); /*MAGETABL.c flag==1 for ptID matching*/      
             }
          }
          else
          {
             Lfound = mysearchpointID(1);/*MAGEUTIL.c for justone hit*/
          }
          
          if(Lfound) /*000324*/
          {
              Lsearched = 0; /*successful, so let dialog end*/
          }
          else 
          {
              sprintf(dlog_textCstr,"NOT FOUND");
              Lsearchatend = 1;
              Ldlog_textC = 1;
              Lsearched = 1; /*still searching, do dialog again*/
          }
      }
      else 
      {
          sprintf(dlog_textCstr,"NO SEARCH STRING");
          Ldlog_textC = 1;
          Lsearched = 1; /*still searching, do dialog again*/
      }
    }/*can do a search*/
    else
    {
        sprintf(dlog_textCstr,"AT END OF FILE");
        Ldlog_textC = 1;
        Lsearched = 1; /*still searching, do dialog again*/
    }
 }
 else if(Ldlog_optionHIT)
 {
     Lpick = 1; /* flag for successful pick */
     ipick = 0; /*so will not try to find a pickpoint by cursor x,y*/
     Lprepick = 1; /*so will know to apply pick process to pickvec */
     pickvec = jsearch;
     /*ipickgrp=ngrpsearch;*/
     /*ipickset=nsetsearch;*/
     /*ipicklist=nlistsearch;*/
     pickedlistptr=searchlistptr; /*960529*/
     pickedsgrpptr=searchlistptr->sgrpptr;
     pickedgrupptr=(searchlistptr->sgrpptr)->grupptr;
     Lsearched = 0; /*really should be successful, so let dialog end*/
 }
 else if(Ldlog_cancelHIT)
 {
      Lcancel = 1; /* don't change anything, just quit */
      Lsearched = 0; /* let dialog end */
 }
 if(Lpickon && !Lcancel)
 {
     if(Lmeasureson)  Lmeasureson=0; 
     if(Ldrawlineon)  Ldrawlineon=0; 
     if(Lnewlabelson) Lnewlabelson=0; 
     if(Ldraglineon)  Ldraglineon=0; 
     if(Lconstruct4on) Lconstruct4on=0;  /*971122*/
     if(Lconstruct5on) Lconstruct5on=0;  /*971122*/
     if(Lpickshowon) Lpickshowon=0;  /*990408*/
     if(Lpickcoloron) Lpickcoloron=0;
     if(Lpruneon) Lpruneon = 0;
     if(Lpunchon) Lpunchon = 0;
     if(Lsuperpunchon) Lsuperpunchon = 0;
 }

 ACTIVE_DLOG = 0;
 if(Lsearched)
 {
    /*do some minimal house cleaning for another cycle*/
    Ldlog_OKHIT = 0;
    Ldlog_optionHIT = 0;
    Ldlog_cancelHIT = 0;

    /*SearchDialog();*/ /*put up dialog box again*/ /*971001*/
    /*DogenericDialog();*/    /*____DLOG.c*/ /*971001*/
 }
}
/*___EndSearchDialog()______________________________________________________*/

/****DoViewsDialog()*********************************************************/
void    DoViewsDialog(int j)
{
     if(!ACTIVE_DLOG)
     {
         cleargenericflags();  /*MAGEDLOG.c*/
         ViewsDialog(j);/*NOTE the int j */   /*MAGEDLOG.c*/
         DogenericDialog();    /*MPCDLOG.c*/
#ifndef UNIX_X11  /*called after DLOG_OKHIT_CB*/
         EndViewsDialog();     /*MAGEDLOG.c*/
#endif
     }
}
/*___DoViewsDialog()________________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****ViewsDialog()***********************************************************/
void    ViewsDialog(int j)
{

 if(j==0)
 {/*work out best choice for this next view number*/
     for(j=1;j<=MAXRESETS;j++)      
         if(Lview[j]==0) break;
     if(j>MAXRESETS) j=MAXRESETS;
     sprintf(dlog_subjectstr
        ,"Make current aspect a numbered view, or delete old view");
     Ldlog_subject = 1;
 }/*work out best choice for this next view number*/
 else
 {/*use the given number which was probably out of range*/  
    /*so the user can see why the earlier view update request failed*/
    sprintf(dlog_subjectstr
     ,"%d Out-Of-Range: Erase then type a number between 1 and %d",j,MAXRESETS);
    Ldlog_subject = 1;
 }/*use the given number which was probably out of range*/  

 sprintf(dlog_paramAstr,"%d",j);  /*old Mac 6 */
 Ldlog_paramA = 1;
 sprintf(dlog_textAstr,"Make view as currently seen be this number");
 Ldlog_textA = 1;

 sprintf(dlog_paramBstr,"%s",viewcom[iviewset]); /*old Mac 7 */
 Ldlog_paramB = 1;
 sprintf(dlog_textBstr,"View ID");
 Ldlog_textB = 1;




 sprintf(dlog_paramCstr,"last selected:"); 
 Ldlog_paramC = 1;
 if(iviewset == 1) 
      sprintf(dlog_textCstr,"can't delete view1");  /*old Mac 4 */      
 else if(iviewset == MAXRESETS)
      sprintf(dlog_textCstr,"view%-d (reader's view)",MAXRESETS);
 else sprintf(dlog_textCstr,"View%1d %s",iviewset,viewcom[iviewset]);
 Ldlog_textC = 1;

 sprintf(dlog_optionstr,"Delete last selected view");
 Ldlog_option = 1;        

 sprintf(dlog_radioAstr,"store zoom value directly as a scaling value");
 Ldlog_radioA = 1;
 sprintf(dlog_radioBstr,"calculate span of image area from zoom value");
 Ldlog_radioB = 1;
 if(Lzoomer[j] >= 0)
 {
     dlog_radioAint = 1;
     dlog_radioBint = 0;
 }
 else
 {
     dlog_radioAint = 0;
     dlog_radioBint = 1;
 }


 ACTIVE_DLOG = VIEW_DLOG;
}
/*___ViewsDialog()__________________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/

/****EndViewsDialog()********************************************************/
void    EndViewsDialog()
{
 int    i,j=0;
 if(Ldlog_OKHIT) /*make this view be a new & current one*/
 {
     j = intfromstr(dlog_paramAstr);
   /*recondition(dlog_paramBstr);*/ /*MAC: P to C string,(dummied)in ___MAIN.C*/
   /*970818 done in MACDLOG/genericDialog() */
     sprintf(temps,"%s",dlog_paramBstr); 
     if(j>0 && j< MAXRESETS)
     {/*requested view number in range*/
         if(dlog_radioAint)
             Lzoomer[j] =  1; /*zoom itself*/ /*980929*/
         else
             Lzoomer[j] = -1; /*span from which to calculate zoom*/
              
         /*MAC & PC use integers, MUXM uses Widget for theitem*/
         if     (j==1) theitem = reset1Item;
         else if(j==2) theitem = reset2Item;
         else if(j==3) theitem = reset3Item;
         else if(j==4) theitem = reset4Item;
         else if(j==5) theitem = reset5Item;
         else if(j==6) theitem = reset6Item;
         else if(j==7) theitem = reset7Item;
         else if(j==8) theitem = reset8Item;
         else if(j==9) theitem = reset9Item;
         else if(j==10) theitem = reset10Item;
         else if(j==11) theitem = reset11Item;
         else if(j==12) theitem = reset12Item;
         else if(j==13) theitem = reset13Item;
         else if(j==14) theitem = reset14Item;
         else if(j==15) theitem = reset15Item;
         else if(j==16) theitem = reset16Item;
         else if(j==17) theitem = reset17Item;
         else if(j==18) theitem = reset18Item;
         else if(j==19) theitem = reset19Item;
         else if(j==20) theitem = reset20Item;
         else if(j==21) theitem = reset21Item;
         else if(j==22) theitem = reset22Item;
         else if(j==23) theitem = reset23Item;
         else if(j==24) theitem = reset24Item;
         else if(j==25) theitem = reset25Item;
         else if(j==26) theitem = reset26Item;
         else if(j==27) theitem = reset27Item;
         else if(j==28) theitem = reset28Item;
         else if(j==29) theitem = reset29Item;
         else if(j==30) theitem = reset30Item;
         else if(j==31) theitem = reset31Item;
         else if(j==32) theitem = reset32Item;
         else if(j==33) theitem = reset33Item;
         else if(j==34) theitem = reset34Item;
         else if(j==35) theitem = reset35Item;
         else if(j==36) theitem = reset36Item;
         else if(j==37) theitem = reset37Item;
         else if(j==38) theitem = reset38Item;
         else if(j==39) theitem = reset39Item;
         else if(j==40) theitem = reset40Item;
         else if(j==41) theitem = reset41Item;
         else if(j==42) theitem = reset42Item;
         else if(j==43) theitem = reset43Item;
         else if(j==44) theitem = reset44Item;
         else if(j==45) theitem = reset45Item;
         else if(j==46) theitem = reset46Item;
         else if(j==47) theitem = reset47Item;
         else if(j==48) theitem = reset48Item;
         else if(j==49) theitem = reset49Item;
         else if(j==50) theitem = reset50Item;
         else if(j==51) theitem = reset51Item;
         else if(j==52) theitem = reset52Item;
         else if(j==53) theitem = reset53Item;
         else if(j==54) theitem = reset54Item;
         else if(j==55) theitem = reset55Item;
         else if(j==56) theitem = reset56Item;
         else if(j==57) theitem = reset57Item;
         else if(j==58) theitem = reset58Item;
         else if(j==59) theitem = reset59Item;
         else if(j==60) theitem = reset60Item;
         else if(j==61) theitem = resetRItem;
         for(i=0;i<MAXVIEWIDCHAR;i++) viewcom[j][i] = temps[i];
         viewcom[j][MAXVIEWIDCHAR] = '\0';
         Lview[j] = 1;
         sprintf(temps,"View%d %s",j,viewcom[j]);
         condition(temps);/*MAC: C to P string, (dummied) in ___MAIN.C*/
         setviewidentifier(j,temps);  /*980919*/
         /*uncheck all Views, check new one */
         checkcurrentviewmenu(j); /*____MENU.C, goes by integer*/
         AdjustMenus();           /*____MENU.C*/        
         setrotview(j);           /*MAGEANGL.C*/
         Lnewviewactive = 1; /*flag on exit for changed kin*/ /*971129*/
       ACTIVE_DLOG = 0;/*NOTE: case Ldlog_OKHIT may have to open dialog again!*/
     }/*requested view number in range*/
     else
     {/*view number out of range, e.g. mouse select didn't clear field*/
         fprintf(stderr,"%d : view number out of range, try again...\n",j);
         ACTIVE_DLOG = 0;/*NOTE: set==0 so system will open dialog again!*/
         DoViewsDialog(j); /*send the out-of-range j value */
     }/*view number out of range, e.g. mouse select didn't clear field*/
/*
printf("just did reset view %d\n",j);
*/
 }
 else if(Ldlog_optionHIT) /*delete view*/
 {
     if(iviewset>1)
     {
         if(iviewset==1) theitem = reset1Item;
         if(iviewset==2) theitem = reset2Item;
         if(iviewset==3) theitem = reset3Item;
         if(iviewset==4) theitem = reset4Item;
         if(iviewset==5) theitem = reset5Item;
         if(iviewset==6) theitem = reset6Item;
         if(iviewset==7) theitem = reset7Item;
         if(iviewset==8) theitem = reset8Item;
         if(iviewset==9) theitem = reset9Item;
         if(iviewset==10) theitem = reset10Item;
         if(iviewset==11) theitem = reset11Item;
         if(iviewset==12) theitem = reset12Item;
         if(iviewset==13) theitem = reset13Item;
         if(iviewset==14) theitem = reset14Item;
         if(iviewset==15) theitem = reset15Item;
         if(iviewset==16) theitem = reset16Item;
         if(iviewset==17) theitem = reset17Item;
         if(iviewset==18) theitem = reset18Item;
         if(iviewset==19) theitem = reset19Item;
         if(iviewset==20) theitem = reset20Item;
         if(iviewset==21) theitem = reset21Item;
         if(iviewset==22) theitem = reset22Item;
         if(iviewset==23) theitem = reset23Item;
         if(iviewset==24) theitem = reset24Item;
         if(iviewset==25) theitem = reset25Item;
         if(iviewset==26) theitem = reset26Item;
         if(iviewset==27) theitem = reset27Item;
         if(iviewset==28) theitem = reset28Item;
         if(iviewset==29) theitem = reset29Item;
         if(iviewset==30) theitem = reset30Item;
         if(iviewset==31) theitem = reset31Item;
         if(iviewset==32) theitem = reset32Item;
         if(iviewset==33) theitem = reset33Item;
         if(iviewset==34) theitem = reset34Item;
         if(iviewset==35) theitem = reset35Item;
         if(iviewset==36) theitem = reset36Item;
         if(iviewset==37) theitem = reset37Item;
         if(iviewset==38) theitem = reset38Item;
         if(iviewset==39) theitem = reset39Item;
         if(iviewset==40) theitem = reset40Item;
         if(iviewset==41) theitem = reset41Item;
         if(iviewset==42) theitem = reset42Item;
         if(iviewset==43) theitem = reset43Item;
         if(iviewset==44) theitem = reset44Item;
         if(iviewset==45) theitem = reset45Item;
         if(iviewset==46) theitem = reset46Item;
         if(iviewset==47) theitem = reset47Item;
         if(iviewset==48) theitem = reset48Item;
         if(iviewset==49) theitem = reset49Item;
         if(iviewset==50) theitem = reset50Item;
         if(iviewset==51) theitem = reset51Item;
         if(iviewset==52) theitem = reset52Item;
         if(iviewset==53) theitem = reset53Item;
         if(iviewset==54) theitem = reset54Item;
         if(iviewset==55) theitem = reset55Item;
         if(iviewset==56) theitem = reset56Item;
         if(iviewset==57) theitem = reset57Item;
         if(iviewset==58) theitem = reset58Item;
         if(iviewset==59) theitem = reset59Item;
         if(iviewset==60) theitem = reset60Item;
         if(iviewset==61) theitem = resetRItem;
         Lview[iviewset] = 0;
         for(i=0;i<=MAXVIEWIDCHAR;i++) viewcom[iviewset][i] = '\0'; 
         sprintf(temps,"View%d %s",iviewset,viewcom[iviewset]);
         condition(temps);
         setviewidentifier(j,temps);  /*980919*/
         /*uncheck all Views, not check any: i=0 */
         checkcurrentviewmenu(0); /*____MENU.C, goes by integer*/
         AdjustMenus(); /*____MENU.C*/
         Lnewviewactive = 1; /*flag on exit for changed kin*/ /*971129*/
     }
     ACTIVE_DLOG = 0;/*NOTE: case Ldlog_OKHIT may have to open dialog again!*/
 }
 else if(Ldlog_cancelHIT) /*cancel*/
 {
     ; /*no action */
     ACTIVE_DLOG = 0;/*NOTE: case Ldlog_OKHIT may have to open dialog again!*/
 }
}
/*___EndViewsDialog()_______________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/*****DoChangeCheckDialog****************************************************/
void    DoChangeCheckDialog()
{
   if(!ACTIVE_DLOG)
  {
     cleargenericflags();    /*MAGEDLOG.c*/
     ChangeCheckDialog();    /*MAGEDLOG.c*/
     DogenericDialog();      /*____DLOG.c*/
#ifndef UNIX_X11 /*called after DLOG_OKHIT_CB*/
     EndChangeCheckDialog(); /*MAGEDLOG.c*/
#endif
  }
}
/*___DoChangeCheckDialog____________________________________________________*/

/****ChangeCheckDialog()*****************************************************/
void     ChangeCheckDialog()  /*971129  modified*/
{
 /*figure out why this change-check was invoked*/
 if(Lpruneactive) /*prune-punch-recolored and maybe pick-showed*/
 {
     intpass = 5; /*modified kinemage: write out whole thing*/
      sprintf(dlog_subjectstr
              ,"kinemage has been modified: write out whole thing?");
 }
 else if(Ldrawactive || Lclosedrawline) /* has new draw stuff*/
 {
     intpass = 5; /* draw new: write out whole thing*/
     sprintf(dlog_subjectstr
             ,"draw_new items have been made: write new kinemage?");
 }
 else if(Lnewviewactive) /*has new views created*/
 {
     intpass = 5; /* new views: write out whole thing*/
     sprintf(dlog_subjectstr
             ,"new views have been made: write new kinemage?");
 }
 else if(Lnewstuffactive) /*has new stuff added to kinemage*/
 {
     intpass = 5; /* new stuff: write out whole thing*/
     sprintf(dlog_subjectstr
             ,"new additions or changes have been made: write new kinemage?");
 }
 else 
 {
     intpass = 5; /* changes: write out whole kinemage*/
     sprintf(dlog_subjectstr
             ,"changes have been made: write new kinemage?");
 }

 Ldlog_subject = 1;
 
 sprintf(dlog_optionstr,"proceed, no write");
 Ldlog_option = 1;
 
 ACTIVE_DLOG = CHANGE_DLOG;
}
/*___ChangeCheckDialog()____________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****EndChangeCheckDialog()**************************************************/
void     EndChangeCheckDialog()  /*971129 modified*/
{        
/*LChangeCheckCode (global) 3 for turnoff draw-new*/
/*intpass (global) 3 for write draw-new parts*/
 ACTIVE_DLOG = 0;
 if(Ldlog_cancelHIT)
 {
      Lgetnewfile = 0;
      LquitMAGE = 0;
      Lclosedrawline = 0;
      Lgetkinemagechoice = 0;
      Lgetnextkinemage   = 0;
	  ireturnflag = 0;   /*no action */
 }
 else if(Ldlog_optionHIT) 
 {
      Lpruneactive = 0;
      Ldrawactive = 0;
      Lnewviewactive = 0;
      Lnewstuffactive = 0;

      if(Lgetnewfile) OpenNewFile(); /*____DLOG.c*/
      else if(LquitMAGE) quitMAGE(); /*MACMENU,MPCMAIN,MUXMMENU*/
      else if(Lclosedrawline) closedrawline(); /*MAGEMENU*/
      else if(Lgetnextkinemage) getnextkinemage(); /*MAGEFILE.C*/
      else if(Lgetkinemagechoice) getkinemagechoice(); /*MAGEUTIL*/
 }
 else if(Ldlog_OKHIT) 
 {
      writeoutput(intpass); /*____OUT.c*/
 }
}
/*___EndChangeCheckDialog()__________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****DoSetgraffontsDialog()**************************************************/
void    DoSetgraffontsDialog()
{
  if(!ACTIVE_DLOG)
  {
       cleargenericflags();         /*MAGEDLOG.c*/
       SetgraffontsDialog();        /*MAGEDLOG.c*/
       DogenericDialog();           /*____DLOG.c*/
#ifndef UNIX_X11 /*called after DLOG_OKHIT_CB*/
      EndSetgraffontsDialog();     /*MAGEDLOG.c*/
       redrawvec();/*????????*/
#endif
       if(Ltablepresent) redrawtable();
  }
}
/*___DoSetgraffontsDialog()_________________________________________________*/

/****SetgraffontsDialog()****************************************************/
void    SetgraffontsDialog()
{
 sprintf(dlog_subjectstr,"On-Screen characters, font sizes.");
 Ldlog_subject = 1;
 
 sprintf(dlog_paramAstr,"%d",(int)infofontsize);
 Ldlog_paramA = 1;
 sprintf(dlog_textAstr,"info font size: pointID, distance measures");
 Ldlog_textA = 1;
 
 sprintf(dlog_paramBstr,"%d",(int)labelsfontsize);
 Ldlog_paramB = 1;
 sprintf(dlog_textBstr,"labels font size");
 Ldlog_textB = 1;
 
 sprintf(dlog_paramCstr,"%d",(int)wordsfontsize);
 Ldlog_paramC = 1;
 sprintf(dlog_textCstr,"words text font size");
 Ldlog_textC = 1;

 sprintf(dlog_paramDstr,"%d",(int)tablefontsize);
 Ldlog_paramD = 1;
 sprintf(dlog_textDstr,"table cell font size");
 Ldlog_textD = 1;

 ACTIVE_DLOG = FONT_DLOG;
}
/*___SetgraffontsDialog()___________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****EndSetgraffontsDialog()*************************************************/
void    EndSetgraffontsDialog()
{
 if(Ldlog_cancelHIT)
 {
      ireturnflag = 0;   /*no action */
 }
 else if(Ldlog_OKHIT) 
 {
      infofontsize   = intfromstr(dlog_paramAstr);
      labelsfontsize = intfromstr(dlog_paramBstr);
      wordsfontsize  = intfromstr(dlog_paramCstr);
      tablefontsize  = intfromstr(dlog_paramDstr);
      Linfofontsize   = 1; /*can't tell which one(s) changed*/
      Llabelsfontsize = 1; /*so flag all of them as protected*/
      Lwordsfontsize  = 1; /*by virtue of being deliberately set*/
      Ltablefontsize  = 1;

 }
 ACTIVE_DLOG = 0;
}
/*___EndSetgraffontsDialog()________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/*****DoPostScriptDialog*****************************************************/
void    DoKipOutputDialog() /*NOT USED 001118*/
{
     if(!ACTIVE_DLOG) 
     {
         cleargenericflags();    /*MAGEDLOG.c*/
         KipOutputDialog();     /*MAGEDLOG.c*/
         DogenericDialog();      /*____DLOG.c*/
#ifndef UNIX_X11  /* called after DLOG_OKHIT_CB*/ 
         EndKipOutputDialog();  /*MAGEDLOG.c*/
#endif
     }
}
/*___DoKipOutputDialog_____________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****KipOutputDialog()********************************************************/
void    KipOutputDialog() /*NOT USED 001118*/
{
 sprintf(dlog_subjectstr,"Write new file with this kinemage,"
 CRLF" along with all others in the current kinemage file."
 );
 Ldlog_subject = 1;
 
 dlog_checkAint = Lvisibleout;
 sprintf(dlog_checkAstr,"Write only the Visible Parts currently on screen.");
 Ldlog_checkA = 1;

 
 sprintf(dlog_infostr  
 ,"MAGE then will read from the newly created kinemage file and resume at"
 CRLF"view 1 of what had been the current kinemage.");
 Ldlog_info = 1;
 
 ACTIVE_DLOG = KIPOUTPUT_DLOG;
}
/*___KipOutputDialog()_______________________________________________________*/

/****EndKipOutputDialog()*****************************************************/
void    EndKipOutputDialog() /*NOT USED 001118*/
{
 if(Ldlog_OKHIT) 
 {
    Lvisibleout = dlog_checkAint;
    ireturnflag = 1; /*global, to deal with both modal & non-modal Dialogs*/
    /*Mac and PC specific routines call writeoutput(5)*/
    /*UNIX genericdlogrouter calls writeoutput(5)*/
 }
 else /*(Ldlog_cancelHIT),(Ldlog_optionHIT)*/
 {
      ireturnflag = 0;   /*no action */
 }
 ACTIVE_DLOG = 0;
}
/*___EndKipOutputDialog()_____________________________________________________*/

/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/*****DoPostScriptDialog*****************************************************/
void    DoPostScriptDialog()
{
     if(!ACTIVE_DLOG) 
     {
         cleargenericflags();    /*MAGEDLOG.c*/
         PostScriptDialog();     /*MAGEDLOG.c*/
         DogenericDialog();      /*____DLOG.c*/
#ifndef UNIX_X11  /* called after DLOG_OKHIT_CB*/ 
         EndPostScriptDialog();  /*MAGEDLOG.c*/
#endif
     }
}
/*___DoPostScriptDialog_____________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****PostScriptDialog()******************************************************/
void    PostScriptDialog()
{
 sprintf(dlog_subjectstr,"Write file with Postscript graphics image,"
 CRLF" default use RGB palette and regular triangles (if any)."
 );
 Ldlog_subject = 1;
 
 dlog_checkAint = LRGBPS;
 sprintf(dlog_checkAstr,"RGB Mage palette instead of derived CMYK");
 Ldlog_checkA = 1;

 dlog_radioAint = !LspecialPS;
 sprintf(dlog_radioAstr,"standard regular triangles");
 Ldlog_radioA = 1;
 dlog_radioBint =  LspecialPS;
 sprintf(dlog_radioBstr,"special effect, swoopy triangles");
 Ldlog_radioB = 1;
 
 sprintf(dlog_infostr  
 ,"Postscript recalculates image using floating point rotation."
 CRLF"swoopy triangles make perforated ribbon faces");
 Ldlog_info = 1;
 
 ACTIVE_DLOG = POSTSCR_DLOG;
}
/*___PostScriptDialog()_____________________________________________________*/

/****EndPostScriptDialog()***************************************************/
void    EndPostScriptDialog()
{
 if(Ldlog_OKHIT) 
 {
      LRGBPS = dlog_checkAint;
      LspecialPS = dlog_radioBint;
      /*Lpostscript = 1;*/  /*DO NOT set this drawvec controls until*/
      /*Lspecialloop = 1;*/ /*a valid PostScript output file is opened*/
      ireturnflag = 1;
      /*UNIX genericdlogrouter calls writeoutput(6)*/
 }
 else /*(Ldlog_cancelHIT),(Ldlog_optionHIT)*/
 {
      ireturnflag = 0;   /*no action */
 }
 ACTIVE_DLOG = 0;
}
/*___EndPostScriptDialog()___________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/*****DoRaster3DDialog()*****************************************************/
void    DoRaster3DDialog()
{
     if(!ACTIVE_DLOG) 
     {
         cleargenericflags();    /*MAGEDLOG.c*/
         Raster3DDialog();     /*MAGEDLOG.c*/
         DogenericDialog();      /*____DLOG.c*/
#ifndef UNIX_X11  /* called after DLOG_OKHIT_CB*/ 
         EndRaster3DDialog();  /*MAGEDLOG.c*/
#endif
     }
}
/*___DoRaster3DDialog()_____________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****Raster3DDialog()********************************************************/
void    Raster3DDialog()
{
 sprintf(dlog_subjectstr
 ,"Write file for rendering in "
 CRLF" (default) Raster3D (http://www.bmsc.washington.edu/raster3d)"
 CRLF" or POV-Ray (http://www.povray.org)");
 Ldlog_subject = 1;
 
 dlog_checkAint = 0;
 sprintf(dlog_checkAstr,"Output to file for POV-Ray");
 Ldlog_checkA = 1;


 dlog_checkBint = LR3Dappend;
 sprintf(dlog_checkBstr,"expect to append to existing render file");
 Ldlog_checkB = 1;

 dlog_radioAint = LR3Dstrokedtext;
 sprintf(dlog_radioAstr,"Use stroked font, for text in rendered image");
 Ldlog_radioA = 1;

 dlog_radioBint = !LR3Dstrokedtext;
 sprintf(dlog_radioBstr,"bit mapped INVISIBLE text embedded in Raster3D render file");
 Ldlog_radioB = 1;

 sprintf(dlog_infostr  
 ,"MAGE recalculates image using floating point rotation."
 CRLF"render file header can be edited for further options");
 Ldlog_info = 1;
 
 ACTIVE_DLOG = RASTER3D_DLOG;
}
/*___Raster3DDialog()_______________________________________________________*/

/****EndRaster3DDialog()*****************************************************/
void    EndRaster3DDialog()
{
 if(Ldlog_OKHIT) 
 {
      LR3Dappend = dlog_checkBint;
      LR3Dstrokedtext =  dlog_radioAint; /*optional for Raster3D*/
      /*LR3Dshadow = dlog_radioDint;*/
      Lspecialloop = 1; /*control within MAGEDRAW/drawvec()*/
      ireturnflag = 1;
      if(dlog_checkAint)
      {/*over-ride for output for POV_ray renderer*/
         Lraster3Drender = 2;
         LR3Dstrokedtext = 1; /*forced for POV-Ray*/
#ifndef UNIX_X11
         writeoutput(9); /*____OUT.C*/
#endif
      }
      else
      {
         Lraster3Drender = 1;
#ifndef UNIX_X11
         writeoutput(8); /*____OUT.C*/
#endif
      }
 }
 else /*(Ldlog_cancelHIT),(Ldlog_optionHIT)*/
 {
      Lspecialloop = 0;
      Lraster3Drender = 0;
 }
 ACTIVE_DLOG = 0;
}
/*___EndRaster3DDialog()____________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/*****DocoordformatDialog****************************************************/
void    DocoordformatDialog()
{
  if(!ACTIVE_DLOG)
  {
     cleargenericflags();       /*MAGEDLOG.c*/
     coordformatDialog();       /*MAGEDLOG.c*/
     DogenericDialog();         /*____DLOG.c*/
#ifndef UNIX_X11 /* called after DLOG_OKHIT_CB*/ 
    EndcoordformatDialog();    /*MAGEDLOG.c*/
#endif
   }
}
/*___DocoordformatDialog____________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****coordformatDialog()*****************************************************/
void    coordformatDialog()
{
 sprintf(dlog_subjectstr,"Output rotated coordinates");
 Ldlog_subject = 1;

 dlog_radioAint = Lkinformat;
 sprintf(dlog_radioAstr,"kinemage format");
 Ldlog_radioA = 1;
 dlog_radioBint =  !Lkinformat;
 sprintf(dlog_radioBstr,"PDB format coords");
 Ldlog_radioB = 1;

 sprintf(dlog_infostr,"kinemage format gives all rotated parts as a .kin file"
       CRLF"PDB format just gives the atoms at vector heads (L type points)");
 Ldlog_info = 1;

 ACTIVE_DLOG = ROTFORMAT_DLOG;
}
/*___coordformatDialog()____________________________________________________*/

/****EndcoordformatDialog()**************************************************/
void    EndcoordformatDialog()
{
 if(Ldlog_cancelHIT)
 {
      ireturnflag = 0;   /*no action */
 }
 else if(Ldlog_optionHIT)
 {
      ireturnflag = 0;   /*no action */
 }
 else if(Ldlog_OKHIT)
 {
      Lkinformat = dlog_radioAint;
      ireturnflag = 1;
 }
 ACTIVE_DLOG = 0;
}
/*___EndcoordformatDialog()_________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/*****DodetailDialog*********************************************************/
void    DodetailDialog()
{
     if(!ACTIVE_DLOG) 
     {
         cleargenericflags();  /*MAGEDLOG.c*/
         detailDialog();       /*MAGEDLOG.c*/
         DogenericDialog();    /*____DLOG.c*/
#ifndef UNIX_X11  /*called after DLOG_OKHIT_CB */
         EnddetailDialog();    /*MAGEDLOG.c*/
#endif
     }
}
/*___DodetailDialog_________________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****detailDialog()**********************************************************/
void    detailDialog()   /*960808*/
{
 sprintf(dlog_subjectstr,"level of detail: current full update rate %f"
             ,updaterate);
 Ldlog_subject = 1;
 sprintf(dlog_infostr,"level of detail lowered when update rate lower than:"
                        CRLF"                           default  current"
                        CRLF" update rate limit:      %.2f     %.2f"
                         ,updateratelimitdefault, updateratelimit);
 Ldlog_info = 1;
 sprintf(dlog_paramAstr,"%.2f",updateratelimit );
 Ldlog_paramA = 1;
 sprintf(dlog_textAstr,"update rate limit ( updates per second)");
 Ldlog_textA = 1;
 sprintf(dlog_optionstr,"use default");
 Ldlog_option = 1;
 ACTIVE_DLOG = DETAIL_DLOG;
}
/*___detailDialog()_________________________________________________________*/

/****EnddetailDialog()*******************************************************/
void    EnddetailDialog() /*960808*/
{
 if(Ldlog_OKHIT) 
 {
      updateratelimit = floatfromstr(dlog_paramAstr);
 }
 else if(Ldlog_optionHIT)
 {
      updateratelimit = updateratelimitdefault;
 }
 else if(Ldlog_cancelHIT)
 {
      Lcancel = 1; /* don't change anything, just stay with current values */
 }
 ACTIVE_DLOG = 0;
}
/*___EnddetailDialog()______________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****DoupdateDialog()********************************************************/
void    DoupdateDialog()
{
    if(!ACTIVE_DLOG)
    {
      cleargenericflags();  /*MAGEDLOG.c*/
      updateDialog();       /*MAGEDLOG.c*/
      DogenericDialog();    /*____DLOG.c*/
#ifndef UNIX_X11 /*called after DLOG_OKHIT_CB */ 
            EndupdateDialog();    /*MAGEDLOG.c*/
            /*970408*/ /*build redrawvec() etc. into EndupdateDialog*/
#endif
        }
}
/*___DoupdateDialog()_______________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****updateDialog()**********************************************************/
void    updateDialog()
{

   if(!Lpipeactive && nbondrot > 0)
   {/*has rotations for Probe to calculate dots*/
       sprintf(dlog_subjectstr,"Invoke another program to update kinemage");
       Ldlog_subject = 1;

      if(input_command_line[0] == '\0') 
      {
         dlog_radioAint = 0; 
         dlog_radioBint = 1; /*new probe*/
         dlog_radioCint = 0;
         dlog_radioDint = 0;
         dlog_radioEint = 0;
      }
      else
      {
         dlog_radioAint = 1; /*presume stored probe*/
         dlog_radioBint = 0;
         dlog_radioCint = 0;
         dlog_radioDint = 0;
         dlog_radioEint = 0;
      }

      sprintf(dlog_radioAstr,"Probe command from kinemage (if available)");
      Ldlog_radioA = 1;
 
      sprintf(dlog_radioBstr
              ,"Probe to calc dots around present rotation group");
      Ldlog_radioB = 1;
   }
#ifdef UNIX_X11
   else if(Lpipeactive)
   {/*active pipe takes precedence*/
      sprintf(dlog_subjectstr,"a pipe is active...");
      Ldlog_subject = 1;

      dlog_radioAint = 0; 
      dlog_radioBint = 0;
      dlog_radioCint = 0;
      dlog_radioDint = 0;
      dlog_radioEint = 1; /*update from live pipe*/
   }
#endif /*UNIX_X11*/
   else
   {/*can't do Probe, no active pipe, try for Prekin*/
      sprintf(dlog_subjectstr,"Invoke another program to update kinemage"
      CRLF" NO rotations, internal data not available to invoke Probe.");
      Ldlog_subject = 1;

      dlog_radioAint = 0; 
      dlog_radioBint = 0;
      dlog_radioCint = 1; /*new prekin*/
      dlog_radioDint = 0;
      dlog_radioEint = 0;
   }

   sprintf(dlog_radioCstr,"e.g. Prekin to set up rotations for a sidechain");
   Ldlog_radioC = 1;
 
   sprintf(dlog_radioDstr
           ,"e.g. Prekin to set up rotations of a mutated sidechain");
   Ldlog_radioD = 1;

#ifdef UNIX_X11
   sprintf(dlog_radioEstr
           ,"update through active pipe from virtual file");
   Ldlog_radioE = 1;
#endif /*UNIX_X11*/
   sprintf(dlog_OKstr,"OK");
   sprintf(dlog_cancelstr,"CANCEL dialog");
   sprintf(dlog_optionstr,"QUIT UPDATING"); /*001029*/
   Ldlog_option = 1;
   ACTIVE_DLOG = UPDATE_DLOG;
}
/*___updateDialog()_________________________________________________________*/

/****EndupdateDialog()*******************************************************/
void    EndupdateDialog()
{
 ACTIVE_DLOG = 0;
 if(Ldlog_OKHIT) 
 {
      if(dlog_radioAint)
          DoupdateProbeDialog(0); /* 0: inputed probe setup*/

      if(dlog_radioBint)
           DoupdateProbeDialog(1); /* 1: new probe setup*/

      if(dlog_radioCint)
           DoupdatePrekinDialog(1); /* 1: new prekin setup, just rotation*/

      if(dlog_radioDint)
           DoupdatePrekinDialog(2); /* 2: new prekin setup, mutation*/

#ifdef UNIX_X11
      if(dlog_radioEint)
           DoupdatePipeDialog(Lpipeactive); /*0: initiate, 1: could close*/
#endif /*UNIX_X11*/
 }
 else if(Ldlog_optionHIT)
 {
    if(Lpipeactive)
    {/*active pipe, should be killed properly*/
       DoupdatePipeDialog(Lpipeactive); /*0: initiate, 1: could close*/
    }
    /*stop doing one-at-a-time updates*/
    Lupdate = 0; /*turn off updating*/
 }
 else if(Ldlog_cancelHIT)
 {
      Lcancel = 1; /* don't change anything, just stay with current values */
 }
}
/*___EndupdateDialog()______________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/

/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****DoupdateProbeDialog()***************************************************/
void    DoupdateProbeDialog(int Lnew)
{
   if(!ACTIVE_DLOG)
   {
      cleargenericflags();  /*MAGEDLOG.c*/
      updateProbeDialog(Lnew);       /*MAGEDLOG.c*/
      DogenericDialog();    /*____DLOG.c*/
#ifndef UNIX_X11 /*called after DLOG_OKHIT_CB */ 
      EndupdateProbeDialog();    /*MAGEDLOG.c*/

            /*970408*/ /*build redrawvec() etc. into EndupdateDialog*/
#endif
   }
}
/*___DoupdateProbeDialog()__________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****updateProbeDialog()*****************************************************/
void    updateProbeDialog(int Lnew)
{
 int  i=0,j=0,k=0,numrestemp=0;
 grupstruct* thelastbondrotgrupptr = NULL;
 char local_command_line[256];
 float fxmin=0,fxmax=0,fymin=0,fymax=0,fzmin=0,fzmax=0;
 float fxmid=0,fymid=0,fzmid=0,fdist=0;
 
 sprintf(dlog_subjectstr,"Invoke another program (Probe) to update kinemage"
                         "(can edit command line)");
 Ldlog_subject = 1;

 if(Lprobeactive)
 {/*last appended stuff most likely are obselete dots from a probe run*/
     dlog_checkAint = Ldeleteappend = 1; /*optional for doupdate*/; 
     sprintf(dlog_checkAstr,"delete last appended stuff: probe dots(?)");
     Ldlog_checkA = 1;
 }
 else
 {   
     dlog_checkAint = Ldeleteappend = 0; /*optional for doupdate*/
     sprintf(dlog_checkAstr,"delete last appended stuff, if any.");
     Ldlog_checkA = 1;
 }
 
 dlog_checkBint = Lignorecaption = 1; /*MAGEINPT/GetStuffFromFile*/; 
 sprintf(dlog_checkBstr,"ignore any new caption text");
 Ldlog_checkB = 1;
 
 
 /*presumption that doing an update of dots around a rotation group sc */
 if(Lnew ==1)
 {/*Lnew ==1: see if can identify all sc that have rotatable bonds*/
    update_res_probe = 0; /*track residue number*/
    update_res_num_index = 0; /*count characters of string of res nums*/
    fxmin =  9999; /*scope of mobile coordinates limits probe's search*/
    fymin =  9999;
    fzmin =  9999;
    fxmax = -9999;
    fymax = -9999;
    fzmax = -9999;
    thisgrupptr = firstgrupptr;
    while( thisgrupptr != NULL)
    {/*check all groups*/
      if(thisgrupptr->bondrot != 0) /*has a subgroup with bondrots*/
      {/*has a subgroup with bondrots*/
        thelastbondrotgrupptr = thisgrupptr; /*remember last one for its name*/
        thissgrpptr = thisgrupptr->firstsgrpptr;
        while(thissgrpptr != NULL)
        {/*check all subgroups*/
           if(thissgrpptr->bondrot != 0)
           {/*may be a subgroup describing the rotations of a residue*/
              /*find res num in subgroup name*/
              i = 0;
              for(j=0; j<MAXNAMECHAR; j++)
              {
                 if( isdigit( thissgrpptr->name[j] ) )
                 {
                    word[i] = thissgrpptr->name[j];
                    i++;
                 } 
                 else if( thissgrpptr->name[j] == '\0')
                 {
                    word[i] = '\0';
                    break;
                 }
              }
              numrestemp   = intfromstr(word);
              if(numrestemp != update_res_probe)
              {/*new number, add to set of rotating sidechains*/
                 update_res_probe   = numrestemp;
                 k=update_res_num_index;
                 if(k > 0)
                 {
                    update_res_num_str[k] = ',';
                    k++;
                 }
                 for(j=0; j<MAXNAMECHAR; j++)
                 {/*pull out that residue number and add to string of res nums*/
                    if( isdigit( thissgrpptr->name[j] ) )
                    {
                       update_res_num_str[k] = thissgrpptr->name[j];
                       k++;
                    } 
                    else if( thissgrpptr->name[j] == '\0')
                    {
                       update_res_num_str[k] = '\0';
                       update_res_num_index = k;
                       break;
                    }
                 }
              }/*new number, add to set of rotating sidechains*/
              LOK = 1; /*OK did find a rotation subgroup*/
              /*now find the scope of coordinates of mobile points*/
              thislistptr = thissgrpptr->firstlistptr;
              while(thislistptr != NULL)
              {
                 if(thislistptr->bondrot != 0)
                 {
                    thispointptr = thislistptr->firstpointptr;
                    while(thispointptr != NULL)
                    {
                       if(   ((thispointptr->STATUS & NOXYZ) != NOXYZ)
                           &&((thispointptr->STATUS & DUMMY) != DUMMY) )
                       {/*presumeably point has a valid coordinate*/
                          if     (thispointptr->fx < fxmin) fxmin = thispointptr->fx;
                          else if(thispointptr->fx > fxmax) fxmax = thispointptr->fx;
                          if     (thispointptr->fy < fymin) fymin = thispointptr->fy;
                          else if(thispointptr->fy > fymax) fymax = thispointptr->fy;
                          if     (thispointptr->fz < fzmin) fzmin = thispointptr->fz;
                          else if(thispointptr->fz > fzmax) fzmax = thispointptr->fz;
                       }
                       
                       if(thispointptr == thislistptr->lastpointptr) thispointptr = NULL;
                       else thispointptr = thispointptr->nextptr;
                    }
                 }
                 if(thislistptr == thissgrpptr->lastlistptr) thislistptr = NULL;
                 else thislistptr = thislistptr->nextptr;
              }
           }/*may be a subgroup describing the rotations of a residue*/

          if(thissgrpptr == thisgrupptr->lastsgrpptr) thissgrpptr = NULL;
          else thissgrpptr = thissgrpptr->nextptr;
        }/*check all subgroups*/
      }/*has a subgroup with bondrots*/
      thisgrupptr = thisgrupptr->nextptr;
    }/*check all groups*/

    if(LOK)
    {/*rotation found*/
       if(Lkinpdbfile)
       {/*kinemage contained original pdbfile name*/
          sprintf(update_file_name,"%s",kinpdbfilestr);
       }/*kinemage contained original pdbfile name*/
       else
       {/*try to get pdb file name from group name*/
          sprintf(update_file_name,"%s"
             ,thelastbondrotgrupptr->name);
             /*(,((thisbondrotlistptr->sgrpptr)->grupptr)->name);*/
       }/*try to get pdb file name from group name*/
       /*scope of coordinates defines a box*/
       fxmid = (fxmax + fxmin)/2;
       fymid = (fymax + fymin)/2;
       fzmid = (fzmax + fzmin)/2;

       fdist =   (fxmax-fxmin)*(fxmax-fxmin)
                +(fymax-fymin)*(fymax-fymin)
                +(fzmax-fzmin)*(fzmax-fzmin); /*sq of diagonal of box*/
       if(fdist > 0) fdist = (float)sqrt((double)(fdist/2)); /* half diagonal*/
       else fdist = 0;
       fdist = fdist + 10; /*arbitrary additional radius of probe interest*/
       sprintf(local_command_line,"probe -quiet -drop -both -stdbonds"
        " \"(file1 within %.2f of %.2f, %.2f, %.2f not water not(%s sc)),file2\" "
        " \"file2\" "
        " %s - "
        ,fdist,fxmid,fymid,fzmid
        ,update_res_num_str,update_file_name
       );
       /*inside first pattern might be: "within %.2f of %.2f,%.2f,%.2f"*/
       /*where distance ~8 and x,y,z from ctr of rot or last picked pt*/
       /*now use center of box holding all mobile points*/
    }/*rotation found*/
    else
    {
        local_command_line[0] = '\0';
    }
    Lnew = 0;
 }/*Lnew ==1: see if can identify all sc that have rotatable bonds*/
 else if(Lnew==0  && input_command_line[0] != '\0')
 {/*Show inputed command line*/
    sprintf(local_command_line,"%s",input_command_line);
 }
 else 
 {/*Show same commandline as used before*/
   Lnew = 0; /*don't mess with update_command_line str*/
   sprintf(local_command_line,"%s",update_command_line);
 }

 sprintf(dlog_optionstr,"show previously used command string");
 Ldlog_option = 1;

 sprintf(dlog_infostr,"%s",local_command_line);
 Ldlog_info = 1;
 
 ACTIVE_DLOG = UPDATEPROBE_DLOG;
}
/*___updateProbeDialog()____________________________________________________*/

/****EndupdateProbeDialog()**************************************************/
void    EndupdateProbeDialog()
{
 ACTIVE_DLOG = 0;
 if(Ldlog_OKHIT) 
 {
      sprintf(update_command_line,"%s",dlog_infostr);
      Lupdate = 1; /*so updating can occur upon demand*/
      mycheckitem(kludgeMenu,remoteupdateItem,Lupdate); /*___MENU.C*/
      Linhibitbutton = 1; /*probe called each angle update*/
      Linhibiton = 0; /*this can be inhibited by right panel button*/
      /*Lappend = 1;*/ /*taken care of by doupdate()*/

      Ldeleteappend = dlog_checkAint; 
      Lignorecaption = dlog_checkBint; 
      
      if(nbondrot>0)
      { 
         doupdate(1, update_command_line); /*____OUT.c*/
         Lnewstuffactive = 1; /*protection: asks for output before closing*/
         Lprobeactive = 1; /*tracks probe as last called update*/
         Ldeleteappend = 1; /*maybe didn't delete appended stuff from earlier*/
            /*but after this, delete probe dots before getting updated dots*/
      }
      /* 1 for put out rotation group coords to remote program*/
      SetsinGrafWindow();

	  redrawvec();
 }
 else if(Ldlog_optionHIT)
 {
      DoupdateProbeDialog(-1);  /*redo the dialog, -1: show same commandline*/
      /* 0 flags inputed commandline*/
 }
 else if(Ldlog_cancelHIT)
 {
      Lcancel = 1; /* don't change anything, just stay with current values */
 }
}
/*___EndupdateProbeDialog()_________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/

/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****DoupdatePrekinDialog()***************************************************/
void    DoupdatePrekinDialog(int Lnew)
{
   if(!ACTIVE_DLOG)
   {
      cleargenericflags();  /*MAGEDLOG.c*/
      updatePrekinDialog(Lnew);       /*MAGEDLOG.c*/
      DogenericDialog();    /*____DLOG.c*/
#ifndef UNIX_X11 /*called after DLOG_OKHIT_CB */ 
      EndupdatePrekinDialog();    /*MAGEDLOG.c*/
            /*970408*/ /*build redrawvec() etc. into EndupdateDialog*/
#endif
   }
}
/*___DoupdatePrekinDialog()__________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****updatePrekinDialog()*****************************************************/
void    updatePrekinDialog(int Lnew)
{
 int   j,k,kk,Lnum;
 char local_command_line[256];
 
 if(Lnew != 2)
 {/*just setup for general case, e.g. with a rotation*/
    sprintf(dlog_subjectstr,"Invoke another program (Prekin) to update kinemage"
                         "(can edit command line)");
 }/*just setup for general case, e.g. with a rotation*/
 else
 {/*setup for doing a mutation*/
    sprintf(dlog_subjectstr
       ,"Invoke Prekin to mutate a residue and give it rotatable bonds"
    CRLF"Edit the command line: replace ala with desired mutation.");
 }/*setup for doing a mutation*/
 Ldlog_subject = 1;

 if(Lprobeactive)
 {/*last appended stuff most likely are obselete dots from a probe run*/
     dlog_checkAint = Ldeleteappend = 1; /*optional for doupdate*/; 
     sprintf(dlog_checkAstr,"delete last appended stuff: probe dots(?)");
     Ldlog_checkA = 1;
 }
 else
 {   
     dlog_checkAint = Ldeleteappend = 0; /*optional for doupdate*/
     sprintf(dlog_checkAstr,"delete last appended stuff, if any.");
     Ldlog_checkA = 1;
 }
 
 /*presumption: make a rotation group sc */

 if(Lnew >= 1)
 {/*see if can identify a putative sc from the last picked point*/
    if(pickedpointptr != NULL)
    {/*find res num in point name*/
       /*copy char str from storage */
       getptIDstring(numstr, pickedpointptr);
       /*PREKIN makes only 2 types of pointID: */
       /*{ ca  arg  nnnn } for rotation std pdb fragment */
       /* 012345678901234 */
       /*{ ca  arg  _n..._ ....} for expanded regular prekin point ID*/
       /* where _ is forced blank and ... is continuation of number*/
       /*start in 10 which is blank or start of 4 digit res number*/
       /* go on to either 13 or 14, or hit blank or non-digit character*/
       k=0;
       Lnum = 0;
       for(j=10; j<15; j++)
       {/*look only in prekin field of digits in this pointID*/
          if( Lnum == 0 && isdigit( numstr[j] ) )
          {/*field starts with a number, maybe it is a residue number*/
             k = 0; /*reset here for emphasis*/
             Lnum = 1;
             word[k] = numstr[j];
             k++;
          } 
          else if( Lnum == 1 && isdigit( numstr[j] ))
          {/*continuing a numeric field*/
             word[k] = numstr[j];
             k++;
          }
          else if(   Lnum && (!isdigit(numstr[j])) ) 
          {/*anyother char ends a numeric field*/
             word[k] = '\0';
             break; /*successfully found a number*/
          }
          else  /*Lnum NOT set*/
          {/*yet another character not contributing to a number */
             ; /*NOP*/
          }
       }/*find first field of digits in this pointID*/
       if(Lnum)
       {/*dropped through when still accummulating a number*/
           k++;
           word[k] = '\0'; /*use this as a residue number*/
       }
       else
       {/*dropped through and never found a number*/
           word[0] = '\0'; /*null string, should yield residue = 0 */
       }
    }/*find res num in point name*/
    else word[0] = '\0';  /*NO picked point, let residue = 0 */
    update_res_num   = intfromstr(word);
    
    if(Lkinpdbfile)
    {/*kinemage file contained name for original pdb file*/
       sprintf(update_file_name,"%s",kinpdbfilestr);
    }/*kinemage file contained name for original pdb file*/
    else
    {/*try to generate pdb file name from group name*/
       if(pickedpointptr != NULL)  /*971223*/
          sprintf(numstr,"%s"
             ,(((pickedpointptr->listptr)->sgrpptr)->grupptr)->name);
       else if(firstgrupptr != NULL)
          sprintf(numstr,"%s",firstgrupptr->name);
       else numstr[0] = '\0';
       k=0;
       kk=0;
       if(numstr[0] != '\0') /*971223*/
       {
          if(numstr[0] == '*' ||numstr[0] == '%' ||numstr[0] == ' ') kk=1;
          /*animate controls or leading blank*/
          for(j=kk; j<MAXNAMECHAR; j++)
          {
             if( (numstr[j] == ' '&& k>0) || numstr[j] == '\0') 
             {/*blanks after characters or end-of-string*/
                break;
             }
             else
             {
                word[k] = numstr[j];
                k++;
             }
          }
       }
       word[k] = '\0';
       sprintf(update_file_name,"%s",word);
    }/*try to generate pdb file name from group name*/

    if(Lnew == 1)
    {/*just set up for rotation*/
       sprintf(local_command_line,"prekin %s - -scope -show  \"sc,hy\" "
                      " -rotate %d -append "
                      ,update_file_name,update_res_num
                        );
    }/*just set up for rotation*/
    else
    {/*set up for mutation*/

       sprintf(local_command_line,"prekin %s - -scope -show  \"sc,hy\" "
                      " -mutate %d ala -append "
                      ,update_file_name,update_res_num
                        );
    }/*set up for mutation*/
    Lnew=0; /*Not effectively used, commandline existance rules 981125 */
 }/*see if can identify a putative sc from the last picked point*/
 else if(Lnew==0 && input_command_line[0] != '\0')
 {/*Show inputed command line*/
    sprintf(local_command_line,"%s",input_command_line);
 }
 else
 {/*Show same commandline as used before*/
   Lnew = 0; /*don't mess with update_command_line str*/

   sprintf(local_command_line,"%s",update_command_line);
 }

 sprintf(dlog_optionstr,"show previously used command string");
 Ldlog_option = 1;

 sprintf(dlog_infostr,"%s",local_command_line);
 Ldlog_info = 1;
 
 ACTIVE_DLOG = UPDATEPREKIN_DLOG;
}
/*___updatePrekinDialog()____________________________________________________*/

/****EndupdatePrekinDialog()**************************************************/
void    EndupdatePrekinDialog()
{
 ACTIVE_DLOG = 0;
 if(Ldlog_OKHIT) 
 {
      sprintf(update_command_line,"%s",dlog_infostr);
      /*Lappend = 1;*/ /*will be taken care of by doupdate*/
      Lupdate = 1; /*so ONE updating can occur*/
      /*mycheckitem(kludgeMenu,remoteupdateItem,Lupdate);*/ /*___MENU.C*/
         /*do NOT check menu since prekin update is single shot*/
      Ldeleteappend = dlog_checkAint; /*optional for doupdate*/      
      Linhibitbutton = 0; /*prekin only called once*/
      Linhibiton = 0; /*NO need for inhibition by right panel button*/

      doupdate(0, update_command_line); /*____OUT.c*/
      /* 0 for NO put out of coords to remote program*/
      Lupdate = 0;
      Lnewstuffactive = 1; /*protection: asks for output before closing*/
      Lprobeactive = 0; /*probe will have no longer done the last update*/
      SetsinGrafWindow();

	  redrawvec();
 }
 else if(Ldlog_optionHIT)
 {
      DoupdatePrekinDialog(-1);  /*redo the dialog, -1: show same commandline*/
      /* 0 flags inputed commandline*/
 }
 else if(Ldlog_cancelHIT)
 {
      Lcancel = 1; /* don't change anything, just stay with current values */
 }
}
/*___EndupdatePrekinDialog()_________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/

/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****DoupdatePipeDialog()*****************************************************/
void    DoupdatePipeDialog(int Lpiper)
{
    if(!ACTIVE_DLOG)
    {
      cleargenericflags();  /*MAGEDLOG.c*/
      updatePipeDialog(Lpiper);       /*MAGEDLOG.c*/
      DogenericDialog();    /*____DLOG.c*/
#ifndef UNIX_X11 /*called after DLOG_OKHIT_CB */ 
            EndupdatePipeDialog();    /*MAGEDLOG.c*/
            /*970408*/ /*build redrawvec() etc. into EndupdateDialog*/
#endif
        }
}
/*___DoupdatePipeDialog()____________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****updatePipeDialog()*******************************************************/
void    updatePipeDialog(int Lpiper)
{

 if(Lpiper == 0)
 {/*expect to do an initialtion*/
    sprintf(dlog_subjectstr
          ,"Initiate an active pipe from which to update kinemage"
          CRLF"         (can edit command line)");
 }/*expect to do an initialtion*/
 else if(Lpiper > 0)
 {/*active pipe*/
    sprintf(dlog_subjectstr
       ,"pipe is active"
    CRLF"command line not an issue");
 }/*active pipe*/
 else if(Lpiper < 0)
 {
 
 }
 Ldlog_subject = 1;

 if(Lpiper==0 && Lprobeactive)
 {/*last appended stuff most likely are obselete dots from a probe run*/
     dlog_checkAint = Ldeleteappend = 1; /*optional for doupdate*/; 
     sprintf(dlog_checkAstr,"delete last appended stuff: probe dots(?)");
     Ldlog_checkA = 1;
 }
 else if(Lpiper==0)
 {   
     dlog_checkAint = Ldeleteappend = 0; /*optional for doupdate*/
     sprintf(dlog_checkAstr,"delete last appended stuff, if any.");
     Ldlog_checkA = 1;
 }
 else
 {   
     dlog_checkAint = Ldeleteappend; /*optional for doupdate*/
     sprintf(dlog_checkAstr,"delete last appended stuff, if any.");
     Ldlog_checkA = 1;
 }
 
 if(Lpipeactive)
 { 
     dlog_checkBint = 0; 
     sprintf(dlog_checkBstr,"flush pipe");
     Ldlog_checkB = 1;

     dlog_checkCint = 0; 
     sprintf(dlog_checkCstr,"KILL active pipe!");
     Ldlog_checkC = 1;

 } 
 
 /*no presumptions: incoming update could be anything*/

 if(Lpiper==0 && input_command_line[0] != '\0')
 {/*Show inputed command line*/
    sprintf(update_command_line,"%s",input_command_line);
 }
 else if(Lpiper==0)
 {/*invent command line to initiate pipe*/
    sprintf(update_command_line,"tail -f simout.kin");
 }/*invent command line to initiate pipe*/
 else
 {/*unclear what to put here*/
    ;
 }
 if(Lpiper==0)
 {
    sprintf(dlog_optionstr,"show command string again");
 }
 else
 {
    sprintf(dlog_optionstr," ");
 }
 Ldlog_option = 1;

 sprintf(dlog_infostr,"%s",update_command_line);
 Ldlog_info = 1;
 
 ACTIVE_DLOG = UPDATEPIPE_DLOG;
}
/*___updatePipeDialog()______________________________________________________*/

/****EndupdatePipeDialog()****************************************************/
void    EndupdatePipeDialog()
{
 ACTIVE_DLOG = 0;
 if(Ldlog_OKHIT) 
 {
   if(Lpipeactive && dlog_checkBint)
   {/*request to flush pipe*/
      flushpipe(); /*____PIPE.c*/
   }
   else if(Lpipeactive && dlog_checkCint)
   {/*request to KILL pipe*/
      doupdatefrompipe(999, "\""); /*____PIPE.c*/
   }
   else
   {
      sprintf(update_command_line,"%s",dlog_infostr);
      /*Lappend = 1;*/ /*will be taken care of by doupdatefrompipe()*/
      Lupdate = 1; /*so ONE updating can occur*/
      mycheckitem(kludgeMenu,remoteupdateItem,Lupdate); /*___MENU.C*/
      Ldeleteappend = dlog_checkAint; /*optional for doupdatefrompipe*/      
      Lcontrol = 1; /*request another update from the pipe, i.e. single step*/
      Lcontrolon = 0; /*Lpipebufferloaded used as flag*/
      Linhibitbutton = 1; /*pipe can pause, if running on auto update*/
      Linhibiton = 0; /*start out running, otherwise: single step mode*/
      
      doupdatefrompipe(-1, update_command_line); /*____OUT.c*/
      /*-1 to initiate pipe*/
      /* !=1 for NO put out of coords to remote program*/
      /*successfule open sets Lpipeactive==1*/
      
      Lnewstuffactive = 1; /*protection: asks for output before closing*/
      Lprobeactive = 0; /*probe will have no longer done the last update*/
   }    
      SetsinGrafWindow();
	  redrawvec();
 }
 else if(Ldlog_optionHIT)
 {
      sprintf(update_command_line,"%s",dlog_infostr);
      DoupdatePipeDialog(0);  /*redo the dialog, -1: show same commandline??*/
 }
 else if(Ldlog_cancelHIT)
 {
      Lcancel = 1; /* don't change anything, just stay with current values */
 }
}
/*___EndupdatePipeDialog()___________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/

/****DoShortestBetweenLinesegments()*****************************************/
void DoShortestBetweenLinesegments(float fcxyz[3][7]) /*971122*/
{
   DoPerpendicularBetweenLines(fcxyz);
   /*which is fine to start with, but if mutual perpendicular is not in the*/
   /*scope of both of the line segments, then the Mickey Mouse stuff...*/
   /*which has not been written*/
}
/*___DoShortestBetweenLinesegments()________________________________________*/

/****DoPerpendicularBetweenLines()*******************************************/
void DoPerpendicularBetweenLines(float fcxyz[3][7]) /*971122*/
{

double A1X,A1Y,A1Z,A2X,A2Y,A2Z,ADX,ADY,ADZ,AMAG,ART;
double B1X,B1Y,B1Z,B2X,B2Y,B2Z,BDX,BDY,BDZ,BMAG,BRT;
double C1X,C1Y,C1Z,C2X,C2Y,C2Z,CDX,CDY,CDZ,CMAG,CRT;
double B[NMATRIX+1],D[NMATRIX+1];
int    jrow,icol;

    /*line A has ends A1X,Y,Z  A2X,Y,Z and direction ADX,Y,Z
      line B has ends B1X,Y,Z  B2X,Y,Z and direction BDX,Y,Z
      line C has ends C1X,Y,Z  C2X,Y,Z and direction CDX,Y,Z
      where line C is the putative perpendicular to A and B 
      Define point C1X,Y,Z to be on A and C2X,Y,Z to be on B
      A x B  gives CDX,Y,Z, solve for C1X,Y,Z and C2X,Y,Z 
    */
    A1X = fcxyz[0][1];
    A1Y = fcxyz[1][1];
    A1Z = fcxyz[2][1];
    A2X = fcxyz[0][2];
    A2Y = fcxyz[1][2];
    A2Z = fcxyz[2][2];
    B1X = fcxyz[0][3];
    B1Y = fcxyz[1][3];
    B1Z = fcxyz[2][3];
    B2X = fcxyz[0][4];
    B2Y = fcxyz[1][4];
    B2Z = fcxyz[2][4];
    ADX = A2X - A1X;
    ADY = A2Y - A1Y;
    ADZ = A2Z - A1Z;
    AMAG = sqrt( ADX*ADX + ADY*ADY + ADZ*ADZ);
    BDX = B2X - B1X;
    BDY = B2Y - B1Y;
    BDZ = B2Z - B1Z;    
    BMAG = sqrt( BDX*BDX + BDY*BDY + BDZ*BDZ);
    
    
    

    /*A x B  gives CDX,Y,Z  returned in dblx,dbly,dblz*/
    crossproduct( (ADX)/AMAG,(ADY)/AMAG,(ADZ)/AMAG
                      ,(BDX)/BMAG,(BDY)/BMAG,(BDZ)/BMAG ); /*.*/

    CDX = dblx;
    CDY = dbly;
    CDZ = dblz;
         
    CMAG = sqrt( CDX*CDX + CDY*CDY + CDZ*CDZ);
         
/*         
printf("CMAG == %f\n",CMAG);         
*/         
    if(CMAG == 0.0)
    {/*parallel lines*/

printf("lines are parallel, try construction to drop a perpendicular from point to line\n");         

    }
    else
    {/*lines not parallel*/

         CDX = CDX/CMAG;
         CDY = CDY/CMAG;
         CDZ = CDZ/CMAG;

    /*equation of a line: point C1 on line A  
      (C1X - A1X)/ADX = (C1Y - A1Y)/ADY = (C1Z - A1Z)/ADZ
      C1X - ADX*ART = A1X ...
      equation of a line: point C2 on line B  
      (C2X - B1X)/BDX = (C2Y - B1Y)/BDY = (C2Z - B1Z)/BDZ
      C2X - BDX*BRT = B1X ...
      equation of a line with points C1 and C2
      (C2X - C1X)/CDX = (C2Y - C1Y)/CDY = (C2Z - C1Z)/CDZ
      C2X - C1X - CDX*CRT = 0 ...
      Normal equation, terms in variables by column:
       1   2   3   4   5   6   7   8   9
      C1X C1Y C1Z C2X C2Y C2Z ART BRT CRT  =   B
       1   0   0   0   0   0 -ADX  0   0   =  A1X
       0   1   0   0   0   0 -ADY  0   0   =  A1Y
       0   0   1   0   0   0 -ADZ  0   0   =  A1Z
       0   0   0   1   0   0   0 -BDX  0   =  B1X
       0   0   0   0   1   0   0 -BDY  0   =  B1Y
       0   0   0   0   0   1   0 -BDZ  0   =  B1Z
      -1   0   0   1   0   0   0   0 -CDX  =   0
       0  -1   0   0   1   0   0   0 -CDY  =   0
       0   0  -1   0   0   1   0   0 -CDZ  =   0
    */
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
    /*load matrix components into A, 9x9 matrix*/

A[1][1]= 1;A[1][2]= 0;A[1][3]= 0;A[1][4]=0;A[1][5]=0;A[1][6]=0;A[1][7]=-ADX;A[1][8]=0;A[1][9]=0;
A[2][1]= 0;A[2][2]= 1;A[2][3]= 0;A[2][4]=0;A[2][5]=0;A[2][6]=0;A[2][7]=-ADY;A[2][8]=0;A[2][9]=0;
A[3][1]= 0;A[3][2]= 0;A[3][3]= 1;A[3][4]=0;A[3][5]=0;A[3][6]=0;A[3][7]=-ADZ;A[3][8]=0;A[3][9]=0;

A[4][1]= 0;A[4][2]= 0;A[4][3]= 0;A[4][4]=1;A[4][5]=0;A[4][6]=0;A[4][7]=0;A[4][8]=-BDX;A[4][9]=0;
A[5][1]= 0;A[5][2]= 0;A[5][3]= 0;A[5][4]=0;A[5][5]=1;A[5][6]=0;A[5][7]=0;A[5][8]=-BDY;A[5][9]=0;
A[6][1]= 0;A[6][2]= 0;A[6][3]= 0;A[6][4]=0;A[6][5]=0;A[6][6]=1;A[6][7]=0;A[6][8]=-BDZ;A[6][9]=0;

A[7][1]=-1;A[7][2]= 0;A[7][3]= 0;A[7][4]=1;A[7][5]=0;A[7][6]=0;A[7][7]=0;A[7][8]=0;A[7][9]=-CDX;
A[8][1]= 0;A[8][2]=-1;A[8][3]= 0;A[8][4]=0;A[8][5]=1;A[8][6]=0;A[8][7]=0;A[8][8]=0;A[8][9]=-CDY;
A[9][1]= 0;A[9][2]= 0;A[9][3]=-1;A[9][4]=0;A[9][5]=0;A[9][6]=1;A[9][7]=0;A[9][8]=0;A[9][9]=-CDZ;

/*
for(j=1;j<=9;j++)
printf("A %.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f\n"
,A[j][1],A[j][2],A[j][3],A[j][4],A[j][5],A[j][6],A[j][7],A[j][8],A[j][9]);
*/      
    if(matrixinvert(9))
    {
/*
for(j=1;j<=9;j++)
printf("C %.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f\n"
,C[j][1],C[j][2],C[j][3],C[j][4],C[j][5],C[j][6],C[j][7],C[j][8],C[j][9]);
*/      
      /*load Barray*/
      B[1]=A1X;B[2]=A1Y;B[3]=A1Z;B[4]=B1X;B[5]=B1Y;B[6]=B1Z;B[7]=0;B[8]=0;B[9]=0;
/*
printf("B %.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f\n"
,B[1],B[2],B[3],B[4],B[5],B[6],B[7],B[8],B[9]);
*/
      /*solve for line components*/
      for(jrow=1;jrow<=9;jrow++)
      {  
        D[jrow] = 0.0;
        for(icol=1; icol<=9;icol++)
        {
          D[jrow] = D[jrow] + C[jrow][icol]*B[icol];
          /*where for a given row, multiply C's by col times B by row==col*/
        }
      }
/*
printf("D %.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f\n"
,D[1],D[2],D[3],D[4],D[5],D[6],D[7],D[8],D[9]);
*/
      C1X = D[1];

      C1Y = D[2];
      C1Z = D[3];
      C2X = D[4];
      C2Y = D[5];
      C2Z = D[6];
      ART = D[7];
      BRT = D[8];
      CRT = D[9];
    }
         (thispointptr->previousptr)->fx = (float)C1X;
         (thispointptr->previousptr)->fy = (float)C1Y;
         (thispointptr->previousptr)->fz = (float)C1Z;
         calcintegerpoints(thispointptr->previousptr);
         thispointptr->fx = (float)C2X;
         thispointptr->fy = (float)C2Y;
         thispointptr->fz = (float)C2Z;
         calcintegerpoints(thispointptr); /*971122*/         
if(Ltest)
{         
printf("AMAG %.3f, BMAG %.3f, CMAG %.3f\n",AMAG,BMAG,CMAG);
printf("ART %.3f, BRT %.3f, CRT %.3f\n",ART,BRT,CRT);
printf("CDX  %.3f, CDY  %.3f, CDZ  %.3f\n",CDX,CDY,CDZ);
printf("C1 %.3f,%.3f,%.3f, C2 %.3f,%.3f,%.3f\n",C1X,C1Y,C1Z,C2X,C2Y,C2Z);
}


    }/*lines not parallel*/
}
/*___DoPerpendicularBetweenLines()__________________________________________*/

/****matrixinvert()**********************************************************/
int matrixinvert(int N)
{
   /*MATINV.SUB pg 427, Programming in Basic for Engineers, Kamal B. Rojiani*/
   /*1988 PWS-KENT (Wadsworth) Boston  ISBN 0-534-91899-9                   */
   /*double A[ROWA][COLA]; */ /* matrix  ROWA == COLA */
   /*double C[ROWA][COLA]; */ /* inverse of A */
   /*double DET;*/ /*determinant*/ /*980610*/ /*orig. not initialized before being used*/
   double DET = 1.0; /*determinant = product of PIVOTs */ /*980610*/
   double TEMP,PIVOT,MULTIPLIER;
   int    NPIVOT = 0; /*number of times rows are pivited*/
   int    ROWA,COLA,ROWC;

   int i,j,PASS,MAXROW,ROW,COL;

   if(N>NMATRIX)
   {
      return(0);
   }
   ROWA = N;
   COLA = N;
   ROWC = N;

   /*store identity matrix in C, this will be replaced by the inverse*/
   for(i=1; i<= ROWC; i++)
   {
     for(j=1; j<= ROWC; j++)
     {
        if(i==j) C[i][j] = 1;
        else     C[i][j] = 0;
     }
   }
   /*computation*/
   for(PASS=1; PASS<= COLA; PASS++)
   {/*PASS*/
     /*partial pivoting, For each pass find the largest element in the column*/
     /*containing the pivot element.  The pivot column is PASS.  MAXROW is */
     /*row containing the largest element in the pivot column.  */
     /*It is initially set equal to the pivot row.*/
     
     MAXROW = PASS;
     for(ROW = PASS; ROW<= ROWA; ROW++)
     {
        if(abs((int)A[ROW][PASS]) > abs((int)A[MAXROW][PASS])) MAXROW = ROW;
     }
     if(MAXROW != PASS)
     {/*Interchange pivot row*/ 
       /*with row containing largest element in the */
       /*pivot column in both A and C */
       NPIVOT++;
       for(COL=1; COL<= COLA; COL++)
       {
          TEMP = A[PASS][COL];
          A[PASS][COL] = A[MAXROW][COL];
          A[MAXROW][COL] = TEMP;
          TEMP = C[PASS][COL];
          C[PASS][COL] = C[MAXROW][COL];
          C[MAXROW][COL] = TEMP;
       }
     }/*Interchange pivot row*/ 
     /*Compute determinant and check for singularity */
     /*Determinant is the product of the pivot elements*/
     /*Pivot element is A[PASS][PASS] */
     PIVOT = A[PASS][PASS];
     DET = DET*PIVOT;
     if(DET == 0.0)
     {/*matrix is singular*/
        printf("matrix singular\n");
        return(0);
     }/*matrix is singular*/
     /*Normalization. Divide pivot row by the pivot element*/
     /* so pivot element is reduced to 1 */
     for(COL=1; COL <= COLA; COL++)
     {
        A[PASS][COL] = A[PASS][COL]/PIVOT;
        C[PASS][COL] = C[PASS][COL]/PIVOT;
     }
     /*Elimination. Reduce all elements in pivot column to zero*/
     for(ROW=1; ROW<= ROWA; ROW++)
     {/*ROW*/
       if(ROW != PASS)  /*what happens if ROW==PASS???? */
       {
         MULTIPLIER = A[ROW][PASS];
         for(COL=1; COL<= COLA; COL++)
         {/*COL*/
           A[ROW][COL] = A[ROW][COL] - A[PASS][COL]*MULTIPLIER;
           C[ROW][COL] = C[ROW][COL] - C[PASS][COL]*MULTIPLIER;
               /*MULTIPLIER is how information from A gets into C */
         }/*COL*/
       }
     }/*ROW*/
   }/*PASS*/  
   if(NPIVOT%2) DET = -DET; /*if NPIVOT odd ... */
   return(1); /*1 for success*/   
}
/*___matrixinvert()_________________________________________________________*/

/****DoPerpendicularToPlane()************************************************/
void DoPerpendicularToPlane(float fcxyz[3][7])
{

double A1X,A1Y,A1Z,A2X,A2Y,A2Z;
double B1X,B1Y,B1Z,B2X,B2Y,B2Z;
double C1X,C1Y,C1Z;
double T,AP,BP,CP,DP,PI;
    
    PI = 3.14159;/*971103*/ /*Matrix inverter can't handle point 0,0,0*/
    /*and is flaky if any coord == 0, sooooo add PI to all coord*/
    /*and hope that that doesn't inadventantly set some coord==0 */
    
    /*three points A1X,Y,Z   A2X,Y,Z   B1X,Y,Z define a plane*/
    /*fourth point  B2X,Y,Z is not on this plane, find perpendicular*/
    /*from this point to the plane at C1X,Y,Z */
    
    A1X = fcxyz[0][1]+PI;
    A1Y = fcxyz[1][1]+PI;
    A1Z = fcxyz[2][1]+PI;
    A2X = fcxyz[0][2]+PI;
    A2Y = fcxyz[1][2]+PI;
    A2Z = fcxyz[2][2]+PI;
    B1X = fcxyz[0][3]+PI;
    B1Y = fcxyz[1][3]+PI;
    B1Z = fcxyz[2][3]+PI;
    B2X = fcxyz[0][4]+PI;
    B2Y = fcxyz[1][4]+PI;
    B2Z = fcxyz[2][4]+PI;

    
    /*Equation of a plane from the earliest 3 points
      A1X*AP + A1Y*BP + A1Z*CP + DP = 0

      A2X*AP + A2Y*BP + A2Z*CP + DP = 0
      B1X*AP + B1Y*BP + B1Z*CP + DP = 0
      rearrange into normal equation form:
      A1X*AP + A1Y*BP + A1Z*CP = -DP
      A2X*AP + A2Y*BP + A2Z*CP = -DP
      B1X*AP + B1Y*BP + B1Z*CP = -DP
            [AP]   [-DP]             [-DP] = [AP]
      [   ]*[BP] = [-DP]   so  [ i ]*[-DP] = [BP]  
            [CP]   [-DP]             [-DP] = [CP]
      load 3x3 matrix  A
    */
    A[1][1] = A1X; A[1][2] = A1Y; A[1][3] = A1Z;
    A[2][1] = A2X; A[2][2] = A2Y; A[2][3] = A2Z;
    A[3][1] = B1X; A[3][2] = B1Y; A[3][3] = B1Z;
/*
printf("A %.3f,%.3f,%.3f\n",A[1][1],A[1][2],A[1][3]);
printf("A %.3f,%.3f,%.3f\n",A[2][1],A[2][2],A[2][3]);
printf("A %.3f,%.3f,%.3f\n",A[3][1],A[3][2],A[3][3]);
*/
    matrixinvert(3); 
/*
printf("C %.3f,%.3f,%.3f\n",C[1][1],C[1][2],C[1][3]);
printf("C %.3f,%.3f,%.3f\n",C[2][1],C[2][2],C[2][3]);
printf("C %.3f,%.3f,%.3f\n",C[3][1],C[3][2],C[3][3]);
*/
    /*
      now C is inverse of A
      AP = C[1][1]*(-DP) + C[1][2]*(-DP) + C[1][3]*(-DP)
      BP = C[2][1]*(-DP) + C[2][2]*(-DP) + C[2][3]*(-DP)
      CP = C[3][1]*(-DP) + C[3][2]*(-DP) + C[3][3]*(-DP)
      and equation of plane is
      X*AP + Y*BP + Z*CP + DP = 0
        X*(-DP)*(C[1][1] + C[1][2] + C[1][3])
       +Y*(-DP)*(C[2][1] + C[2][2] + C[2][3])
       +Z*(-DP)*(C[3][1] + C[3][2] + C[3][3])
       = -DP
      multiply through by -DP
        X*(C[1][1] + C[1][2] + C[1][3])
       +Y*(C[2][1] + C[2][2] + C[2][3])
       +Z*(C[3][1] + C[3][2] + C[3][3])
       = 1
      direction components of normal to this plane:
    */
    AP =  (C[1][1] + C[1][2] + C[1][3]);
    BP =  (C[2][1] + C[2][2] + C[2][3]);
    CP =  (C[3][1] + C[3][2] + C[3][3]);
    /*for a given case
      A1X*AP + A1Y*BP + A1Z*CP = -DP
    */
    DP =  -A1X*AP - A1Y*BP - A1Z*CP;
    /*
      find line through point B2X,B2Y,B2Z that has these direction components
      and then find point on the plane where this line intersects the plane.
      C1X = B2X + AP*T
      C1Y = B2Y + BP*T
      C1Z = B2Z + CP*T
      C1X*AP + C1Y*BP + C1Z*CP + D = 0;
      
      AP*(B2X + AP*T) + BP*(B2Y + BP*T) + CP*(B2Z + CP*T) + DP = 0;
      AP*B2X + AP*AP*T + BP*B2Y + BP*BP*T + CP*B2Z + CP*CP*T + DP = 0;
      T*(AP*AP + BP*BP + CP*CP) = -D -AP*B2X -BP*B2Y -CP*B2Z
      T = (-DP -AP*B2X -BP*B2Y -CP*B2Z)/(AP*AP + BP*BP + CP*CP)
      substituting results from above
    */
    T =   (-DP -B2X*AP-B2Y*BP-B2Z*CP)/( AP*AP+BP*BP+CP*CP );
    C1X = B2X + AP*T;
    C1Y = B2Y + BP*T;
    C1Z = B2Z + CP*T;

         thispointptr->fx = (float)(C1X-PI);
         thispointptr->fy = (float)(C1Y-PI);
         thispointptr->fz = (float)(C1Z-PI);
         calcintegerpoints(thispointptr); /*971122*/
/*
printf(" %.3f,%.3f,%.3f   ,%.3f,%.3f,%.3f   ,%.3f,%.3f,%.3f\n"
,A1X,A1Y,A1Z,A2X,A2Y,A2Z,B1X,B1Y,B1Z);
printf(" %.3f,%.3f,%.3f   ,%.3f,%.3f,%.3f\n"
,B2X,B2Y,B2Z,C1X,C1Y,C1Z);
*/

}
/*___DoPerpendicularToPlane()_______________________________________________*/


/*971025perpendicular*/


/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****DopickmarkerDialog()***************************************************/
void    DopickmarkerDialog()
{
    if(!ACTIVE_DLOG)
    {
      cleargenericflags();  /*MAGEDLOG.c*/
      pickmarkerDialog();       /*MAGEDLOG.c*/
      DogenericDialog();    /*____DLOG.c*/
#ifndef UNIX_X11 /*called after DLOG_OKHIT_CB */ 
            EndpickmarkerDialog();    /*MAGEDLOG.c*/
#endif
        }
}
/*___DopickmarkerDialog()__________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****pickmarkerDialog()*****************************************************/
void    pickmarkerDialog()
{
   sprintf(dlog_subjectstr,"optional extended axial line through pick marker"
                     CRLF"Use for correlating across 2D, flatland, graphs");
   Ldlog_subject = 1;

   if((Lpickmarkcriteria & 64) ==  64) dlog_checkAint = 1;
   else dlog_checkAint = 0; 
   sprintf(dlog_checkAstr,"pick markers made of narrow lines");
   Ldlog_checkA = 1;

   if((Lpickmarkcriteria & 128) == 128) dlog_checkBint = 1;
   else dlog_checkBint = 0; 
   sprintf(dlog_checkBstr,
      "pick markers seem behind, rather than in front of things");
   Ldlog_checkB = 1;


   dlog_radioAint = 0; 
   dlog_radioBint = 0;
   dlog_radioCint = 0;
   dlog_radioDint = 0;
   dlog_radioEint = 0;

   if     ((Lpickmarkcriteria &  2049) ==  2049) dlog_radioAint = 1; 
   else if((Lpickmarkcriteria &  4098) ==  4098) dlog_radioBint = 1;
   else if((Lpickmarkcriteria &  8196) ==  8196) dlog_radioCint = 1;
   else if((Lpickmarkcriteria &  8200) ==  8200) dlog_radioDint = 1;
   else {Lpickmarkcriteria = 0; dlog_radioEint = 1;}

   sprintf(dlog_radioAstr,
      "pick marker with extended line in X axial directions.");
   Ldlog_radioA = 1;
   sprintf(dlog_radioBstr,
      "pick marker with extended line in Y axial directions.");
   Ldlog_radioB = 1;
   sprintf(dlog_radioCstr,
      "pick marker with extended line in Z axial directions.");
   Ldlog_radioC = 1;
   sprintf(dlog_radioDstr,
      "pick marker with extended lines in +X,+Z axial directions.");
   Ldlog_radioD = 1;
   sprintf(dlog_radioEstr,
      "Usual pick marker with NO extended lines.");
   Ldlog_radioE = 1;

 
   sprintf(dlog_infostr,
     "pick marker line extends to actual data limits in that axial direction.");
   Ldlog_info = 1;

   ACTIVE_DLOG = PICKMARKER_DLOG;
}
/*___pickmarkerDialog()____________________________________________________*/

/****EndpickmarkerDialog()**************************************************/
void    EndpickmarkerDialog()
{
  ACTIVE_DLOG = 0;
  if(Ldlog_OKHIT) 
  {
     /*first set the axial extent, if any, of the pick markers*/
     if     (dlog_radioAint == 1) Lpickmarkcriteria = 1+ 2048; /*2049*/
     else if(dlog_radioBint == 1) Lpickmarkcriteria = 2+ 4096; /*4098*/
     else if(dlog_radioCint == 1) Lpickmarkcriteria = 4+ 8192; /*8196*/
     else if(dlog_radioDint == 1) Lpickmarkcriteria = 8+ 8192; /*8200*/
     else Lpickmarkcriteria = 0;
     /*then OR in width and apparant postion */
     if(dlog_checkAint == 1) Lpickmarkcriteria = Lpickmarkcriteria |  64;
     if(dlog_checkBint == 1) Lpickmarkcriteria = Lpickmarkcriteria | 128;
	 redrawvec();
  }
  else if(Ldlog_cancelHIT)
  {
     Lcancel = 1; /* don't change anything, just stay with current values */
  }
}
/*___EndpickmarkerDialog()_________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****DoAdvancedHelpDialog()***************************************************/
void    DoAdvancedHelpDialog(int ichoice)
{
   if(!ACTIVE_DLOG)
   {
      cleargenericflags();  /*MAGEDLOG.c*/
      AdvancedHelpDialog(ichoice);         /*MAGEDLOG.c*/
      DogenericDialog();    /*____DLOG.c*/
#ifndef UNIX_X11 /*called after DLOG_OKHIT_CB */ 
      EndAdvancedHelpDialog(ichoice);      /*MAGEDLOG.c*/
#endif
   }
}
/*___DoAdvancedHelpDialog()__________________________________________________*/

/****AdvancedHelpDialog()*****************************************************/
void    AdvancedHelpDialog(int ichoice)
{
   if(ichoice == 1)
   {
      sprintf(dlog_subjectstr,
      "WARNING: THIS WILL ADD THINGS TO YOUR TEXT, if in doubt: CANCEL."
      CRLF"Help information is appended to text window, scroll down to see it.");
   }
   else
   {
      sprintf(dlog_subjectstr,
      "WARNING: THIS WILL ADD THINGS TO YOUR KINEMAGE, if in doubt: CANCEL."
      CRLF"Internally generated kinemage put into graphics.");
   }
   Ldlog_subject = 1;
   
   dlog_radioAint = 1; 
   dlog_radioBint = 0;
   dlog_radioCint = 0;
   dlog_radioDint = 0;
   dlog_radioEint = 0;

   if(ichoice == 1)
   {   
      sprintf(dlog_radioAstr,"Mage @keywords listed in text window");
      Ldlog_radioA = 1; 
      sprintf(dlog_radioBstr,
         "Group, Subgroup, List, and Point Properties in text window");
      Ldlog_radioB = 1;
      sprintf(dlog_radioCstr,"Mage Help Menu Items in text window");
      Ldlog_radioC = 1;
      sprintf(dlog_radioDstr,"About Mage Hypertext in text window");
      Ldlog_radioD = 1;
      sprintf(dlog_radioEstr,"About Mage Docking in text window");
      Ldlog_radioE = 1;
   
      ACTIVE_DLOG = MAKETEXTHELP_DLOG;
   }
   else
   {
      sprintf(dlog_radioAstr,"Internally generated palette kinemage");
      Ldlog_radioA = 1; 
      sprintf(dlog_radioBstr,"Internally generated demo kinemage");
      Ldlog_radioB = 1;
      sprintf(dlog_radioCstr," ");
      Ldlog_radioC = 0;
      sprintf(dlog_radioDstr," ");
      Ldlog_radioD = 0;
      sprintf(dlog_radioEstr," ");
      Ldlog_radioE = 0;
   
      ACTIVE_DLOG = MAKEKINEMAGE_DLOG;
   }
}
/*___AdvancedHelpDialog()____________________________________________________*/

/****EndAdvancedHelpDialog()**************************************************/
void    EndAdvancedHelpDialog(int ichoice)
{
   int Lchoice = 0, IOK=0;
   
   ACTIVE_DLOG = 0;
   if(Ldlog_OKHIT) 
   {/*Ldlog_OKHIT*/
      if     (Ldlog_radioA && dlog_radioAint) {Lchoice = 1;}
      else if(Ldlog_radioB && dlog_radioBint) {Lchoice = 2;}
      else if(Ldlog_radioC && dlog_radioCint) {Lchoice = 3;}
      else if(Ldlog_radioD && dlog_radioDint) {Lchoice = 4;}
      else if(Ldlog_radioE && dlog_radioEint) {Lchoice = 5;}

      if(ichoice == 1)
      {
         dohelpintextwin(Lchoice);  /*MAGEHELP.c*/
         Lnewstuffactive = 1; /*so will be warned to save kinemage*/
      }
      else
      {/*ichoice!=1 make an internal kinemage*/
#ifndef OLD68KMAC /*defined in MAGE.h*/
         IOK = 1;
#else
         if(Lchoice == 1) IOK = 1;
         else
         {
            sprintf(alertstr
              ,"68K Macintosh lacks room to store this example kinemage");
            alertstr2[0]='\0';alertstr3[0]='\0';
            DoMageDLOGreport(2); /*forced message*/ /*___DLOG.C*/ 
            IOK = 0;
            Lcancel=1; /*don't change anything, just stay with current values*/
         }
#endif /*NOT OLD68KMAC defined in MAGE.h*/
         if(IOK)
         {/*IOK*/
            if(Lkinfile==0 || Lkinfile==2) 
            {/*No kinefile OR no kinefile but internally generated text*/
               Lappend = 0;
               Lkinfile = 3; /*for internally generated kinemage*/
            }
            else 
            {/*Lkinfile==1, and there is a kinemage file open*/
             /*OR Lkinfile==3 for an internally generated kinemage*/
             /*leave Lkinfile set to what it was and append new stuff*/
               Lappend = 1;
            }
            Linternal = 1; 
            /*MAGEINPT/GetStuffFromFile(): c = getinternalkinemage(Ninternal)*/
            Ninternal = Lchoice;
            entry();  /*MAGEFILE.c calls GetStuffFromFile()*/
            Linternal = 0; /*restore*/
            AdjustMenus();
            sprintf(NameStr,"magedemo.kin");
            Lnewstuffactive = 1; /*so will be warned to save kinemage*/
         }/*IOK*/
      }/*ichoice!=1 make an internal kinemage*/
      
   }/*Ldlog_OKHIT*/
   else if(Ldlog_cancelHIT)
   {
      Lcancel = 1; /*don't change anything, just stay with current values*/
   }
}
/*___EndAdvancedHelpDialog()_________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
