/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/*   MAGEHELP.C   */
#include "MAGE.h"

 static char*  magekeywords[] = 
{"\r"
,"keywords start with @\r"
,"alternates sometimes shown, but preferred form is listed first\r"
,"See 'Properties' listing for object keyword parameters and point attributes\r"
,"--------text section------\r"
,"'@' of a real keyword must be first character of a new line\r"
," keywords here are marked ' so this text can be read in Mage\r"
,"'@text       starts text section\r"
,"'@mage #.##    MAGE version (can come before @text), \r"
,"          only keyword recognized WITHIN text section\r"
,"'@kinemage #   ESSENTIAL keyword to end text and start kinemage input\r"
,"--------------------------\r"
,"--------kinemage input----\r"
," # indicates an integer needed, #.## a floating point number.\r"
,"'@start   control for reading from a sustained active pipe: start a frame\r"
,"       recognized by pipe handler code\r"
,"'@frame # frame number of image from a sustained active pipe, override  \r"
,"'@finish  control for reading from a sustained active pipe: finish a frame\r"
,"'@done    control for reading from a sustained active pipe, close pipe   \r"
,"\r"
,"'@mage #.##\r"
,"'@prekin #.##\r"
,"'@caption   --->chars to caption until next recognized keyword---\r"
,"'@text      --->any text appended until next recognized keyword (5_75+)\r"
,"\r"
," ---MAGE object hierarchy: group, subgroup, list, (sets of points) points\r"
," points can be in connected line sets, or specify triangles, spheres, etc.\r"
,"'@group    {name} [parameters... all on one line...]\r"
,"'@subgroup {name} [parameters... all on one line...]     (@set)\r"
,"'@____list {name} [parameters... all on one line...]\r"
,"    some type of list is ESSENTIAL for a kinemage\r"
,"'@vectorlist   (@vector)\r"
,"'@labellist    (@label)\r"
,"'@wordlist     (@word)\r"
,"'@dotlist      (@dot)\r"
,"'@balllist     (@ball)\r"
,"'@spherelist   (@sphere)\r"
,"'@trianglelist (@triangle)\r"
,"'@ribbonlist   (@ribbon)\r"
,"'@arrowlist    (@arrow)\r"
,"'@marklist     (@mark)\r"
,"'@ringlist     (@ring)\r"
,"'@fanlist      (@fan)\r"
,"\r"
,"---MAGE  points---follow @____list line on the next line \r"
,"{pointID} [attributes... separated by spaces, commas, new-lines, etc.] x y z\r"
,"--trailing triple: x,y,z defines scope of a point, x,y,z only required thing\r"
,"----table cells only: 'tablecell' or 'noxyz' can stand for triple\r"
,"Generally, list type determines meaning of all its points,\r"
,"  but point attributes can force different meanings within a list\r"
,"  for advanced, special purpose, complicated kinemages.\r"
,"\r"
,"'@kinemage #'    ends this kinemage input\r"
,"'@noscale\r"
,"'@scale #.##\r"
,"'@compare       side-by-side of sequential animate groups, overrides stereo\r"
,"             stereo is reader's choice: menu and keyboard s key\r"
,"'@stereoangle #.##   + for wall-eye, - for cross-eye, also under menu control\r"
,"             + vs - toggled by keyboard c key\r"
,"'@onewidth      default is multiwidth, also menu control\r"
,"'@thinline\r"
,"'@perspective\r"
,"'@plotonly\r"
,"'@flat       @xytranslation\r"
,"'@pickcenter\r"
,"'@zclipoff\r"
,"'@whitebackground   (@whiteback)  (@whitebkg)\r"
,"'@viewid {string}   @1viewid {string}\r"
,"'@2viewid {string}\r"
,"'...\r"
,"'@##viewid {string}\r"
,"'@zoom #.##        @1zoom #.##\r"
,"'@2zoom #.##\r"
,"'...\r"
,"'@##zoom #.##\r"
,"'@span #.##        @1span #.##\r"
,"'@2span #.##\r"
,"'...\r"
,"'@##span #.##\r"
,"'@center #.## #.## #.##    @1center #.## #.## #.##\r"
,"'@2center #.## #.## #.##\r"
,"'...\r"
,"'@##center #.## #.## #.##\r"
,"'@matrix   #.## #.## #.##  #.## #.## #.##  #.## #.## #.##   @1matrix ... \r"
,"'@2matrix  #.## #.## #.##  #.## #.## #.##  #.## #.## #.##\r"
,"'...\r"
,"'@##matrix #.## #.## #.##  #.## #.## #.##  #.## #.## #.##\r"
,"'@zslab   #        @1zslab  #    @zclip #    @1zclip #\r"
,"'@2zslab  #        @2zclip  #\r"
,"'...                     ...\r"




,"'@##zslab #        @##zclip #\r"
,"'@ztran   #        @1ztran #\r"
,"'@2ztran  # \r"
,"'...\r"
,"'@##ztran #\r"
,"\r"
,"'@localrotation #.## #.## #.##  #.## #.## #.##  #.## #.## #.## \r"
,"   a.k.a: @localrotat ...  @localmatrix ...\r"
,"'@endlocalrotation  @endlocalrot @endlocalmatrix\r"
,"'@localprecenter  #.## #.## #.##    @localcenter ...  applied before matrix\r"
,"'@localpostcenter #.## #.## #.##                      applied after  matrix\r"
,"'@endlocalcenter    @endlocalcen @endlocalprecen @endlocalpostcen\r"
,"\r"
,"'@gnomon #.## #.## #.##  #.## #.## #.##  #.## #.## #.##  #.## #.## #.##\r"
,"   place after the @group... line: to belong to that group\r"
,"   points on 3 axes and center (ok if each on separate line)\r"
,"   used by Docking routines to track change to a mobile group\r"
,"   MAGE will add to existing gnomon info or create anew if needed\r"
,"\r"
,"'@fontsizeinfo   #   @fontsizeinfo  # \r"
,"'@fontsizelabels #   @fontsizelabel # \r"
,"'@fontsizewords  #   @fontsizeword  # \r"
,"'@tablefontsize  #   @fontsizetable # \r"
,"'@tablewrap #       number of columns across before wrap line below\r"
,"'@tablecolscale   #.##   scale calculated column width\r"
,"'@tablemarkradius #.## square marker radius for table selected graphics points\r"
,"'@tablefancore    #.##    inner radius of table value fan on graphics point\r"
,"'@tablefanradius  #.##  outer radius of table fan at a graphics point,\r"
,"   this is multiplied by point radius to represent the cell value\r"
,"\r"
,"'@beginselect    keyword starts selection range, re: bondrot selection\r"
,"'@endselect      keyword ends selection range, re: bondrot selection\r"
,"\r"
,"'@listcolordominant  @listcolordom  usually point color is dominant: key 'l'\r"
,"'@lens #.##      parameter of lens radius for lists marked \"lens\": key 'e'\r"
,"'@command \"xxx yy z\" character string to be used for remote update cmd \r"
,"'@control  creates a control button Lcontrol, which toggles Lcontrolon \r"
,"'@title {arbitrary kinemage title} \r"
,"'@copyright {date and author(s) } \r"
,"'@pdbfile {filename.pdb} optional actual name to use for prekin or probe\r"
,"   must be before any @group... line to apply to whole kinemage\r"
,"'@grouppdbfile {filename.pdb} specific group pdb to use for prekin or probe\r"
,"  must follow @group... line to apply to that group\r"
,"\r"
,"'@colorset {name} color   unique name and standard color as char strings\r"
," usage:  @____list {listname} color= {name}   ... anywhere in kinemage\r"
,"'@master {name}   forces named master buttons in inputed order\r"
,"'@pointmaster 'C' {name}  character 'C' associated with master= {name}\r"
," usage:  {ptID} 'C' #.## #.## #.##  \r"
,"'@nowfind {string} invokes FIND, input on the fly from an appended file\r"
,"    \r"
,"\r"
,"'@parameter #.##  get up to 10 parameters to play with, e.g. diffractometer\r"
,"\r"
,"-----obselete or violating reader's prerogatives----------\r"
,"'(@float   #.##)\r"
,"'(@integer #)\r"
,"'(@ignore)   allowed kinemage file to also be a, e.g., PS300 CHAOS display file \r"
,"'(@keepstereo)   valid reader's choice but over-ridden by author's compare \r"
,"'(@keepthinline) artifact as author's choice, reader can use keyboard 't'\r"
,"'(@keepperspective)  (@keepperspec) artifact  as author's choice, keyboard 'p'\r"
,"'(@specialps)    obselete: PostScript output now on menu\r"
,"'(@projection)   construct line length * 1/cos(angle) obselete: now menu choice\r"
,"'(@constructdot) construct line puts dot at end instead of a line:  menu choice\r"
,"'(@multibin (#)) obselete, no effect\r"
,"'(@zoomonly)     obselete, no effect\r"
,"'(@sideclip)     obselete, no effect\r"
,"\r"
,"END\r"
};
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/*MAGESETS.c*/
/*interpretgroupkeyword(),interpretsubgroupkeyword(),interpretlistkeyword()*/
 static char*  mageobjectparameters[] = 
{"\r"
,"--------mage group parameters------\r"
,"'@group {name} [param...]\r"
,"animate  (*prefix)\r"
,"2animate (%prefix)\r"
,"off\r"
,"dominant (no buttons for member subgroups and lists)\r"
,"nobutton (for this group)\r"
,"recessiveon  (dominant if off, recessive if on)\r"
,"master= {name} (common master name) (see NOTES)\r"
,"instance= {name} (name of a proceeding group) (see NOTES)\r"
,"clone= {name} (name of a proceeding group) (see NOTES)\r"
,"moview # (number of a Menu VIEW)\r"
,"lens  (applied to member points)\r"
,"float (obselete now always do floating point perspective calc:\r"
,"table  (members put into table)\r"
,"header (members are column headers of table)\r"
,"\r"
,"--------mage subgroup parameters------\r"
,"'@subgroup {name} [param...]\r"
,"off\r"
,"dominant (no buttons for member lists)\r"
,"nobutton (for this subgroup)\r"
,"recessiveon  (dominant if off, recessive if on)\r"
,"master= {name} (common master name) (see NOTES)\r"
,"instance= {name} (name of a proceeding subgroup) (see NOTES)\r"
,"clone= {name} (name of a proceeding subgroup) (see NOTES)\r"
,"lens  (applied to member points)\r"
,"\r"
,"--------mage list types------\r"
,"vectorlist   (Point x,y,z -->Line x,y,z -->Line x,y,z ...)\r"
,"labellist    (pointID displayed at x,y,z)\r"
,"wordlist     (<comment> ,inc. new lines, displayed at x,y,z)\r"
,"dotlist      (line width # pixels at x,y,z\r"
,"balllist(    (disk [highlight] [shortened lines], center at x,y,z)\r"
,"spherelist   (stacked disks [highlight] [shortened lines] at x,y,z)\r"
,"trianglelist (filled-in triangle)\r"
,"ribbonlist   (sets of 2 filled-in triangles have same normal)\r"
,"arrowlist    (Tail point x,y,z -->Head x,y,z  with 4 tines ...)\r"
,"marklist     (screen-oriented squares around x,y,z)\r"
,"ringlist     (screen-oriented annulus around x,y,z)\r"
,"fanlist      (screen-oriented, weighted feathers fan from x,y,z)\r"
,"\r"
,"--------mage list parameters------\r"
,"'@_____list {name} [param...]\r"
,"off\r"
,"nobutton (for this list)\r"
,"color= name  colour= name (mage palette named colors)\r"
,"master= {name} (common master name) (see NOTES)\r"
,"instance= {name} (name of a proceeding list) (see NOTES)\r"
,"clone= {name} (name of a proceeding list) (see NOTES)\r"
,"lens  (applied to member points)\r"
,"detail\r"
,"radius= #  (ball, sphere, mark, ring, arrow-head)\r"
,"angle= # (arrow-head tine angle)\r"
,"width= # (pixel width of lines)\r"
,"static  (dynamic rotations not applied to members of this list)\r"
,"nozclip (applied to points in this list)\r"
,"nohi nohighlight\r"
,"face (for characters in wordlist)\r"
,"font (for characters in wordlist)\r"
,"size (for characters in wordlist)\r"
,"\r"
,"--------list parameters for bond rotations--------\r"
,"see @beginselect and @endselect for artificial scope\r"
,"  otherwise scope of bondrot is from first point of list to last point\r"
,"  before bondrot of equal or lower number, or end of file  \r"
," Starting angle is arbitrary as far as MAGE is concerned,\r"
," should be actual dihedral\r"
,"bondrot   #.#  (starting angle, one of ganged rotations)\r"
,"0bondrot  #.#  (starting angle, trunk) \r"
,"1bondrot  #.#  (starting angle, first branch)\r"
,"2bondrot  #.#  (starting angle, later branch)\r"
,"3bondrot  #.#  (starting angle, ...)\r"
,"4bondrot  #.#  (starting angle)\r"
,"5bondrot  #.#  (starting angle)\r"
,"6bondrot  #.#  (starting angle)\r"
,"7bondrot  #.#  (starting angle)\r"
,"8bondrot  #.#  (starting angle)\r"
,"9bondrot  #.#  (starting angle)\r"
,"parameter    (Lbrotoption 1)\r"
,"precession   (Lbrotoption 2)\r"
,"selection    (Lbrotoption 3)\r"
,"xrotation    (Lbrotoption 4)\r"
,"yrotation    (Lbrotoption 5)\r"
,"zrotation    (Lbrotoption 6)\r"
,"xtranslation (Lbrotoption 7)\r"
,"ytranslation (Lbrotoption 8)\r"
,"ztranslation (Lbrotoption 9)\r"
,"samescope2   (2 bondrots have the same scope as first of 2)\r"
,"samescopt3   (3 bondrots have the same scope as first of 3)\r"
,"samescope4   (4 bondrots have the same scope as first of 4)\r"
,"hplot      (bondrot value ploted horizontally)\r"
,"vplot      (bondrot value ploted vertically)\r"
,"pattern  c... (MAXBONDPATT==37 characters== 0...A or R,Y,G on UNIX slider)\r"
,"phirotation  (Lbrotoption 10  ganged rotation of same-named bondrot lists)\r"
,"\r"
,"--------mage point attributes------\r"
,"point attributes are usually separated by white space\r"
,"as a matter of style and ease of editing, do separate all by white space\r"
,"but sometimes worth maximal compression to use storage, transmission, etc.\r"
,"----------points---follow @____list line on the next line \r"
,"{pointID} [attributes... separated by spaces, commas, new-lines, etc.] x y z\r"
,"{   final } does not require white space before next attribute.\r"
,"--trailing triple: x,y,z defines scope of a point, x,y,z only required thing\r"
,"----table cells only: 'tablecell' or 'noxyz' can stand for triple\r"
,"<comment>   saved and outputted for all point types\r"
,"  written to screen for wordlists, written in cell in table groups\r"
,"  if present, written in lower left screen when label is picked\r"
,"--------single character flags, all except P need trailing white space\r"
," P defines new beginning of Point-->Line-->Line-->... polyline in vectorlist\r"
," P synonyms are p M m     i.e. in Move-->Draw, exception: P ends itself\r"
,"   presumed for first point of a vectorlist.  L for 'Line' not essential.\r"
," L synonyms are l D d \r"
," U (or u) flags point as unpickable, see menu superpick item\r"
," B (or b) ball at this point in a vectorlist\r"
," T (or t) point is to be interpreted as part of a triangle in a vectorlist\r"
,"\r"
," 'c' single quotes around single character identifier for pointmaster\r"
,"\r"
,"--------multiple character attributes------- need surrounding white space\r"
," colorname   any of mage palette color names; colorname! forces pt color.\r"
," width1  (or thin) for forced one pixel wide lines\r"
," width2  (width#, where #= 1...7)  forced # pixel wide lines\r"
," r= f    point radius for points that are balls, spheres, rings, etc.\r"
," dummy (or DUMMY)  point is NOT used for setting min,max x,y,z extents\r"
," tablecell (or  noxyz  or  NOXYZ)  substitutes for x, y, z triple \r"
," ghost (or GHOST) point is seen but not in special output (like PDB) \r"
,"\r"
,"NOTES:\r"
,"   master:\r"
,"The same master can refer to groups,subgroups,lists, each of which can\r"
,"have multiple masters, but only 32 unique masters total.\r"
,"Multiple masters are restrictive: all have to be ON for object to be ON\r"
,"   instance:\r"
,"Object merely redisplayed at original coordinates, color can be different\r"
,"but inherits masters, etc.\r"
,"   clone:\r"
,"Object actually copied, can have changed coords, etc. new object in output.\r"
,"\r"
,"\r"
,"END\r"
};

/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
 static char*  magehypertext[] = 
{"\r"
,"--------mage hypertext help------\r"
,"    The hypertext capabilities of MAGE text has two interrelated functions.\r"
,"    One is for a system of questions presented to the reader that are each \r"
,"answered in a dialog box that gives the reader access to information from \r"
,"the most recently picked points.\r"
,"    The other is facility to instruct MAGE to move around in the kinemage \r"
,"by jumps to specific kinemages and views, find pointID text strings, turn \r"
,"on and off masters, and reset bond rotations.  Of course, these moves can \r" 
,"be part of a scheme of questions.  However, they confer an enormous power \r"
,"to the reader, particularly because the text, including the hypertext, can \r"
,"be edited during the session!  \r"
#ifndef OLD68KMAC /*defined in MAGE.h*/
,"    For Questions, kinemage number and View number are carried forward from \r"
,"the last time they were set during the linear input of the TEXT window \r"  
,"material.  Thus kinemage and view can be presumed for the go-to-graphics \r"
,"option of a new question.  However, if these are to re-defined for the \r"
,"current question, this must be done before any master-button or FIND \r"
,"controls are specified.  This dependence on the order of controls is \r"
,"NOT hypertext-like and might frustrate the reader/lecturer if they try to \r"
,"jump around in the text.  The author must balance readability and flow \r"
,"of the text with robustness. \r"
,"\r"
,"Format: starts with '*{'  includes [options]   ends with '}*' \r"
,"Questions start with Q: but Mage keeps track of the question number. \r"
,"*{Q: text of question... }* \r"
,"Thus, if the second question in the kinemage is:\r"
,"*{Q: Which is the active Ser?}* \r"
,"Mage shows this in the text, with room for the answer in the underlined space\r"
,"*{Q: 2  Which is the active Ser?}*___________________________ \r"
,"\r"
,"Change instructions to Mage include:\r"
,"*{kinemage #, view #, alloff, master={name} on, find {string} }* \r"
,"abreviations: kinemage kin k, view v, master m, find f\r"
,"'alloff' turns all masters off, masters are individually set 'on' or 'off' \r"
,"\r"
,"Bond rotations can be set (and edited and reset!):\r"
,"*{rot={name 1} #.#, rot={name 2} #.# ...}*  abr: 'rot=','rot ','r ' \r"
,"where 'name 1' == the bondrot identifier string seen on the slider bar\r"
,"and #.# is the new value for that rotation angle\r"
,"If Update by PROBE active, hypertext 'rot' triggers an update.\r"
,"PREKIN after version 5.74 makes hypertext commands\r"
," for rot/mutated residues\r"
,"\r"
#else
,"--old 68K Mac has limited text here--\r"
#endif
,"END\r"
};

/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
 static char*  magedocking[] = 
{"\r"
,"---mage docking help------Visual based docking and superposition----\r"
,"Tools menu item: 'Docking Scope' sets what ever groups currently 'ON'\r"
,"to be mobile (they must be contiguous in the kinemage data structure) while \r"
,"all other groups become the stabile, reference set.\r"
,"(One can still set up by hand appropriate bond rotation/translation commands\r"
," in the kinemage file itself as once was the only way to do docking.)\r"
,"A set of sliders appears in the far right panel which move the \r"
,"mobile set relative to the reference set.\r"
,"Less precise but more facile: holding down the shift key will restrict \r"
,"drag motions to move only the mobile group.\r"
,"Holding down the ctrl (PC:alt) key does xy scrolling instead of rotations\r"
,"thus, holding down both shift and ctrl keys scrolls the mobile group(s)\r"
,"relative to the reference set.\r"
,"The saved kinemage has the modified coordinates of the mobile set.\r"
,"The slider values are not updated by the mouse docking operations and\r"
,"resetting the sliders does NOT reset the docking changes.   However, MAGE\r"
,"saves the relative changes with each mobile group and outputs\r"
,"a keyword entry that can be used to externally reproduce the docking.\r"
,"'@gnomon #.## #.## #.##  #.## #.## #.##  #.## #.## #.##  #.## #.## #.##\r"
,"   place after the @group... line: to belong to that group\r"
,"   points on 3 axes and center (ok if each on separate line)\r"
,"   used by Docking routines to track change to a mobile group\r"
,"   MAGE will add to existing gnomon info or create anew if needed\r"
,"(Since a kinemage can be made from either a subset or superset of the \r"
,"information in a PDB coordinate file, there is no general translation from\r"
,"a modified kinemage to a modified PDB file.)\r"
,"\r"
#ifndef OLD68KMAC /*defined in MAGE.h*/
,"(Small PROBE contact analysis update requires inventing the appropriate\r"
," command line, also requires the pointIDs of the mobile groups to contain \r"
," PDB information needed by PROBE.  This would be convenient for docking but\r"
," is NOT automatic (so far) in this version of MAGE.)\r"
,"\r"
#else
,"--old 68K Mac has limited text here--\r"
#endif
,"END\r"
};

/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
 static char*  magehelp[] = 
{"\r"
,"--------mage general help------\r"
,"helpless\r"
,"END\r"
};

/*
showing the present 20 colors.  The set of 12 colors that span the hues around a spectral color-wheel are laid out at left.  Gray is the most neutral to use along with a color scale (as, for instance, in the palette).  Colors must be called by name in the kinemage files.  Rotate to see the five levels of color depth-cuing.\r"
,"Choose the 'white backgrd' differently defined there: depth cuing is then by saturation rather than intensity; both 'white' and the default become black; and pinktint, bluetint, etc. become dark rather than pale colors.\r"
*/
 static char*  magepalette[] = 
{"@caption\r"
,"Palette test, \r"
,"@perspective\r"
,"@group {colors}\r"
,"@vectorlist {hotpink} color=hotpink\r"
,"{hotp1}P -7 10 10 {hotp2} 4 10 10\r"
,"{hotp1}P -7 10 5 {hotp2} 4 10 5\r"
,"{hotp1}P -7 10 0 {hotp2} 4 10 0\r"
,"{hotp1}P -7 10 -5 {hotp2} 4 10 -5\r"
,"{hotp1}P -7 10 -10 {hotp2} 4 10 -10\r"
,"@vectorlist {magenta} color= magenta\r"
,"{m1}P -7 8 10 {m2} 4 8 10\r"
,"{m1}P -7 8 5 {m2} 4 8 5\r"
,"{m1}P -7 8 0 {m2} 4 8 0\r"
,"{m1}P -7 8 -5 {m2} 4 8 -5\r"
,"{m1}P -7 8 -10 {m2} 4 8 -10\r"
,"@vectorlist {purple} color=purple\r"
,"{pur1}P -7 6 10 {pur2} 4 6 10\r"
,"{pur1}P -7 6 5 {pur2} 4 6 5\r"
,"{pur1}P -7 6 0 {pur2} 4 6 0\r"
,"{pur1}P -7 6 -5 {pur2} 4 6 -5\r"
,"{pur1}P -7 6 -10 {pur2} 4 6 -10\r"
,"@vectorlist {blue} color=blue\r"
,"{b1}P -7 4 10 {b2} 4 4 10 \r"
,"{b1}P -7 4 5 {b2} 4 4 5 \r"
,"{b1}P -7 4 0 {b2} 4 4 0 \r"
,"{b1}P -7 4 -5 {b2} 4 4 -5 \r"
,"{b1}P -7 4 -10 {b2} 4 4 -10 \r"
," @vectorlist {sky} color=sky\r"
,"{sky1}P -7 2 10 {sky2} 4 2 10 \r"
,"{sky1}P -7 2 5 {sky2} 4 2 5 \r"
,"{sky1}P -7 2 0 {sky2} 4 2 0 \r"
,"{sky1}P -7 2 -5 {sky2} 4 2 -5 \r"
,"{sky1}P -7 2 -10 {sky2} 4 2 -10\r" 
,"@vectorlist {cyan} color=cyan\r"
,"{c1}P -7 0 10 {c2} 4  0 10 \r"
,"{c1}P -7 0 5 {c2} 4  0 5 \r"
,"{c1}P -7 0 0 {c2} 4  0 0 \r"
,"{c1}P -7 0 -5 {c2} 4  0 -5 \r"
,"{c1}P -7 0 -10 {c2} 4  0 -10 \r"
,"@vectorlist {sea} color=sea\r"
,"{sea1}P -7 -2 10 {sea2} 4 -2 10 \r"
,"{sea1}P -7 -2 5 {sea2} 4 -2 5 \r"
,"{sea1}P -7 -2 0 {sea2} 4 -2 0 \r"
,"{sea1}P -7 -2 -5 {sea2} 4 -2 -5 \r"
,"{sea1}P -7 -2 -10 {sea2} 4 -2 -10 \r"
,"@vectorlist {green} color=green\r"
,"{g1}P -7 -4 10 {g2} 4 -4 10\r"
,"{g1}P -7 -4 5 {g2} 4 -4 5\r"
,"{g1}P -7 -4 0 {g2} 4 -4 0\r"
,"{g1}P -7 -4 -5 {g2} 4 -4 -5\r"
,"{g1}P -7 -4 -10 {g2} 4 -4 -10\r"
,"@vectorlist {lime} color=lime\r"
,"{l1}P -7 -6 10 {l2} 4 -6 10\r"
,"{l1}P -7 -6 5 {l2} 4 -6 5\r"
,"{l1}P -7 -6 0 {l2} 4 -6 0\r"
,"{l1}P -7 -6 -5 {l2} 4 -6 -5\r"
,"{l1}P -7 -6 -10 {l2} 4 -6 -10\r"

,"@vectorlist {yellow} color=yellow\r"
,"{y1}P -7 -8 10 {y2} 4 -8 10 \r"
,"{y1}P -7 -8 5 {y2} 4 -8 5 \r"
,"{y1}P -7 -8 0 {y2} 4 -8 0 \r"
,"{y1}P -7 -8 -5 {y2} 4 -8 -5 \r"
,"{y1}P -7 -8 -10 {y2} 4 -8 -10 \r"
,"@vectorlist {gold} color=gold\r"
,"{gold1}P -7 -10 10 {gold2} 4 -10 10\r"
,"{gold1}P -7 -10 5 {gold2} 4 -10 5\r"
,"{gold1}P -7 -10 0 {gold2} 4 -10 0\r"
,"{gold1}P -7 -10 -5 {gold2} 4 -10 -5\r"
,"{gold1}P -7 -10 -10 {gold2} 4 -10 -10\r"
,"@vectorlist {orange} color=orange\r"
,"{or1}P -7 -12 10 {or2} 4 -12 10\r"
,"{or1}P -7 -12 5 {or2} 4 -12 5\r"
,"{or1}P -7 -12 0 {or2} 4 -12 0\r"
,"{or1}P -7 -12 -5 {or2} 4 -12 -5\r"
,"{or1}P -7 -12 -10 {or2} 4 -12 -10\r"
,"@vectorlist {red} color=red \r"
,"{r1}P -7 -14 10 {r2} 4 -14 10 \r"
,"{r1}P -7 -14 5 {r2} 4 -14 5 \r"
,"{r1}P -7 -14 0 {r2} 4 -14 0 \r"
,"{r1}P -7 -14 -5 {r2} 4 -14 -5 \r"
,"{r1}P -7 -14 -10 {r2} 4 -14 -10 \r"

,"@vectorlist {pink} color=pink\r"
,"{pk1}P 8 10 10 {pk2}16 10 10\r"
,"{pk1}P 8 10 5 {pk2}16 10 5\r"
,"{pk1}P 8 10 0 {pk2}16 10 0\r"
,"{pk1}P 8 10 -5 {pk2}16 10 -5\r"
,"{pk1}P 8 10 -10 {pk2}16 10 -10\r"
,"@vectorlist {pinktint} color=pinktint\r"
,"{pkt1}P 8 8 10 {pkt2} 16 8 10\r"
,"{pkt1}P 8 8 5 {pkt2} 16 8 5\r"
,"{pkt1}P 8 8 0 {pkt2} 16 8 0\r"
,"{pkt1}P 8 8 -5 {pkt2} 16 8 -5\r"
,"{pkt1}P 8 8 -10 {pkt2} 16 8 -10\r"
,"@vectorlist {white}\r"
,"{w3}P 8 6 10 {w4} 16 6 10\r"
,"{w3}P 8 6 5 {w4} 16 6 5\r"
,"{w3}P 8 6 0 {w4} 16 6 0\r"
,"{w3}P 8 6 -5 {w4} 16 6 -5\r"
,"{w3}P 8 6 -10 {w4} 16 6 -10\r"
,"@vectorlist {black}\r"
,"{w3}P 8 4 10 {w4} 16 4 10\r"
,"{w3}P 8 4 5 {w4} 16 4 5\r"
,"{w3}P 8 4 0 {w4} 16 4 0\r"
,"{w3}P 8 4 -5 {w4} 16 4 -5\r"
,"{w3}P 8 4 -10 {w4} 16 4 -10\r"
,"@vectorlist {default}\r"
,"{w3}P 8 2 10 {w4} 16 2 10\r"
,"{w3}P 8 2 5 {w4} 16 2 5\r"
,"{w3}P 8 2 0 {w4} 16 2 0\r"
,"{w3}P 8 2 -5 {w4} 16 2 -5\r"
,"{w3}P 8 2 -10 {w4} 16 2 -10\r"
,"@vectorlist {bluetint} color=bluetint\r"
,"{bt1}P 8 -2 10 {bt2} 16 -2 10\r"
,"{bt1}P 8 -2 5 {bt2} 16 -2 5\r"
,"{bt1}P 8 -2 0 {bt2} 16 -2 0\r"
,"{bt1}P 8 -2 -5 {bt2} 16 -2 -5\r"
,"{bt1}P 8 -2 -10 {bt2} 16 -2 -10\r"
,"@vectorlist {greentint} color=greentint\r"
,"{gt1}P 8 -4 10 {gt2} 16 -4 10\r"
,"{gt1}P 8 -4 5 {gt2} 16 -4 5\r"
,"{gt1}P 8 -4 0 {gt2} 16 -4 0\r"
,"{gt1}P 8 -4 -5 {gt2} 16 -4 -5\r"
,"{gt1}P 8 -4 -10 {gt2} 16 -4 -10\r"
,"@vectorlist {yellowtint} color=yellowtint\r"
,"{yt3}P 8 -6 10 {yt4} 16 -6 10\r"
,"{yt3}P 8 -6 5 {yt4} 16 -6 5\r"
,"{yt3}P 8 -6 0 {yt4} 16 -6 0\r"
,"{yt3}P 8 -6 -5 {yt4} 16 -6 -5\r"
,"{yt3}P 8 -6 -10 {yt4} 16 -6 -10\r"
,"@vectorlist {gray} color=gray\r"
,"{gra1}P 8 -10 10 {gra2} 16 -10 10\r"
,"{gra1}P 8 -10 5 {gra2} 16 -10 5\r"
,"{gra1}P 8 -10 0 {gra2} 16 -10 0\r"
,"{gra1}P 8 -10 -5 {gra2} 16 -10 -5\r"
,"{gra1}P 8 -10 -10 {gra2} 16 -10 -10\r"
,"@vectorlist {brown} color=brown\r"
,"{br1}P 8 -12 10 {br2} 16 -12 10\r"
,"{br1}P 8 -12 5 {br2} 16 -12 5\r"
,"{br1}P 8 -12 0 {br2} 16 -12 0\r"
,"{br1}P 8 -12 -5 {br2} 16 -12 -5\r"
,"{br1}P 8 -12 -10 {br2} 16 -12 -10\r"
,"@group dominant {labels}\r"
,"@labellist {colorlabl} color=gray\r"
,"{hotpink} -8 10 10\r"
,"{magenta} -8 8 10\r"
,"{purple} -8 6 10\r"
,"{blue} -8 4 10\r"
,"{sky} -8 2 10\r"
,"{cyan} -8 0 10\r"
,"{sea} -8 -2 10\r"
,"{green} -8 -4 10\r"
,"{lime} -8 -6 10\r"
,"{yellow} -8 -8 10\r"
,"{gold} -8 -10 10\r"
,"{orange} -8 -12 10\r"
,"{red} -8 -14 10\r"
,"{pink} 7 10 10\r"
,"{pinktint} 7 8 10\r"
,"{white} 7 6 10\r"
,"{black} 7 4 10\r"
,"{default} 7 2 10\r"
,"{bluetint} 7 -2 10\r"
,"{greentint} 7 -4 10\r"
,"{yellowtint} 7 -6 10\r"
,"{gray} 7 -10 10\r"
,"{brown} 7 -12 10\r"
,"@finish\r"
};

 static char*  magedemo[] = 
{" \r"
#ifndef OLD68KMAC /*defined in MAGE.h*/
,"@text\r"
,"Question example:\r"
,"*{Q: How far does the Sulfur move?}*\r"
,"(Write out and read in again so Input Text parser can recognize question.)\r"
,"\r"
,"@caption\r"
,"Alternate conformations found for Met 52 of file 5PTI (Wlodawer et al., 1984).\r" 
,"Conf. A in gold and conf. B in orange. \r"
,"The two can be compared either by switching between them with 'ANIMATE', \r"
,"or by turning both on at the same time. \r"
,"The change is primarily in the Chi2 angle. \r"
,"N, O atoms are color-coded balls, S atoms are spheres.\r"

,"@viewid {side}\r"
,"@zoom 1.14\r"
,"@zslab 240\r"
,"@center 23.36 17.5 -6.12\r"
,"@matrix \r"
,"-.427847 -.896668 -.113723 .589963 -.181724 -.786715 .684757 -.403687 .60675\r"
,"@2viewid {down cb-cg}\r"
,"@2zoom 1.14\r"
,"@2zslab 360\r"
,"@2center 23.541 17.007 -5.538\r"
,"@2matrix\r"
,"-.358812 -.788558 -.499429 .415252 .344339 -.842019 .835955 -.509516 .203896\r"
,"@pointmaster 'A' {arrow}\r"
,"@group {51-53 mc} \r"
,"@labellist off {label}\r"
,"{ Met 52} 23.975, 16.86, -5.592\r"
,"@wordlist off {title}\r"
,"{title} <Alternate \r"
,"conformations \r"
,"of Met 52> 22.63, 17.94, -4.74\r"
,"@subgroup dominant {main ch}\r"
,"@balllist {n} color= sky radius= .1 <marked with balls>\r"
,"{n met 52} 24.405, 16.565, -4.212\r"
,"{n arg  53} 25.206, 18.931, -5.556\r"
,"@balllist {o} color= red radius= .1\r"
,"{o met 52} 25.254, 17.714, -7.432\r"
,"{o cys  51} 26.397, 15.689, -4.871\r"
,"@vectorlist {main ch} color= gray \r"
,"{ca cys 51} P 25.822, 15.753, -2.493 {c cys 51} L 25.591, 15.998, -3.994 \r"
,"{o cys 51} L 26.397, 15.689, -4.871\r"
,"{c cys 51} P 25.591, 15.998, -3.994 {n met 52} L 24.405, 16.565, -4.212 \r"
,"{ca met 52} L 23.975, 16.86, -5.592\r"
,"{c met 52} L 24.865, 17.909, -6.259\r"
,"{o met 52} L 25.254, 17.714, -7.432\r"
,"{c met 52} P 24.865, 17.909, -6.259 {n arg 53} L 25.206, 18.931, -5.556 \r"
,"{ca arg 53} L 26.111, 19.97, -6.044 \r"

,"@group dominant {conf A} animate\r"
,"@spherelist {S} color= yellow master= {S atoms} radius= .2\r"
,"{sd a met 52} 21.684, 14.673, -6.752\r"
,"@vectorlist {sc a} color= gold master= {side ch}\r"
,"{ca met 52} P 23.975, 16.860, -5.592 {cb met 52} L 22.481, 17.237, -5.692 \r"
,"{cg a met 52} L 21.619, 16.002, -5.527\r"
,"{sd a met 52} L 21.684, 14.673, -6.752\r"
,"{ce a met 52} L 20.896, 15.481, -8.152\r"
,"@arrowlist {A} color= magenta radius= 0.3 angle= 30\r"
,"{sd a met 52} L 'A' 21.684, 14.673, -6.752\r" 
,"{sd b met 52} L 'A' 19.845 ,16.563, -5.694\r"

,"@group dominant {conf B} animate\r"
,"@spherelist {S} color= yellow master= {S atoms} radius= .2\r"
,"{sd b met 52} 19.845 ,16.563, -5.694\r"
,"@vectorlist {sc b} color= orange master= {side ch}\r"
,"{ca met 52} P 23.975, 16.860, -5.592 {cb met 52} L 22.481, 17.237, -5.692\r"
,"{cg b met 52} L 21.536, 16.149, -5.278\r"
,"{sd b met 52} L 19.845 ,16.563, -5.694\r"
,"{ce b met 52} L 19.639, 18.241, -5.038\r"
,"@arrowlist {A} color= magenta radius= 0.3 angle= 30\r"
,"{sd b met 52} L 'A' 19.845 ,16.563, -5.694\r"
,"{sd a met 52} L 'A' 21.684, 14.673, -6.752\r" 
#endif /*NOT OLD68KMAC defined in MAGE.h*/

,"@finish \r"
};



/****dohelpintextwin()********************************************************/
void dohelpintextwin(int ihelp)
{
   int more = 0, j=0, Nth=0; 
   if(!Lkinfile) {cleartexts();}
   if(Limittext==0)
   {/*text window not full*/
      more = 1; /*text less than 32768*/
      if(ihelp == 3)
      {/*dump the help menus to the text window*/
         Linternal = 1;
         inserttexts(CRLF);
         inserttexts(CRLF"----------Keyboard Shortcuts----------"CRLF);
         menuaboutsecrets();  /*Keyboard Shortcuts*/
         inserttexts(CRLF"----------Output Help----------"CRLF);
         menuaboutwrite(); /*Output Help*/
         inserttexts(CRLF"----------Edit Help----------"CRLF);
         menuaboutedit();  /*Edit Help*/
         inserttexts(CRLF"----------Display Help----------"CRLF);
         menuaboutoptions();  /*Display Help*/
         inserttexts(CRLF"----------Special Display Help----------"CRLF);
         menuaboutspecial();  /*Special Display Help*/
         inserttexts(CRLF"----------Tools Help----------"CRLF);
         menuaboutOther(); /*Tools Help*/
         inserttexts(CRLF"----------Kludges: More Tools----------"CRLF);
         menuaboutkluges();  /*Kludges: More Tools*/
         inserttexts(CRLF"----------Mouse Operations----------"CRLF);
         menuaboutmouse();  /*Mouse Operations*/
         inserttexts(CRLF"----Docking and More Mouse Operations----"CRLF);
         menuaboutdocking();  /*Mouse Operations*/
         inserttexts(CRLF"----------Window Resizing----------"CRLF);
         menuaboutresize();  /*Window Resizing*/
         inserttexts(CRLF"----------Table Help----------"CRLF);
         menuabouttable();  /*Table Help*/
         Linternal = 0; /*restore*/
      }/*dump the help menus to the text window*/
      else
      {/*write text from stored arrays, character-by-character*/

         while(more)
         {/*loop over all text for this call*/
            for(j=0; j<255; j++) /*save a space for safety '\0' */
            {/*load transfer string*/
               if(ihelp == 1)
               {
                  temps[j] =  magekeywords[Nth][j];
               }
               else if(ihelp == 2)
               {
                  temps[j] =  mageobjectparameters[Nth][j];
               }
               else if(ihelp == 4)
               {
                  temps[j] =  magehypertext[Nth][j];
               }
               else if(ihelp == 5)
               {
                  temps[j] =  magedocking[Nth][j];
               }
               else
               {
                  temps[j] =  magehelp[Nth][j];
               }
               if(temps[j] == '\r')
               {/*ASCII Carraige Return*/
                  temps[j] = EOL; /*platform specific End-Of-Line character*/
               }
               if(temps[j] == '\0'){ break;} /*separate end of text piece*/
            }/*load transfer string*/
            /*check for END before inserttexts() which can reset temps[]*/
            if(temps[0] =='E' && temps[1] =='N' && temps[2] =='D'){more = 0;}
            temps[j+1] = '\0'; /*safety if runs off end of temps str*/
            inserttexts(temps); /*checks and sets Limittext*/
            Nth++; /*local, not static, so will get reset ==0 on new call*/
         }/*loop over all text for this call*/
      }/*write text from stored arrays, character-by-character*/
      /*set Lkinfile so could write out just this text*/
      Lkinfile = 2;
      AdjustMenus();
      sprintf(NameStr,"magetext.txt");
#ifdef MACINTOSH
      /*now do stupid dance to invoke activate window*/
      ShowWindow(captWindow); 
      SelectWindow(captWindow);
      ShowWindow(textWindow); 
      SelectWindow(textWindow);
#endif
   }/*text window not full*/
}
/*___dohelpintextwin()_______________________________________________________*/

/****getinternalkinemage()****************************************************/
char getinternalkinemage(int ikin)
{
   static int Nth=0; /*counts record lines*/
   static int jth=0; /*counts char of each record line*/
   static char check[]={'@','f','i','n','i','s','h'};
   static int iend=0,Lfinish=0;
   char creturn = ' ';
   
   if(ikin == 1)
   {
      creturn =  magepalette[Nth][jth];
   }
   else 

   {
      creturn =  magedemo[Nth][jth];
   }
/*printf("%d,%d,%d:%c ",Nth,jth,iend,creturn);*/
   jth++; /*set for next character on a line*/
          /*set here, so can reset to 0 if at EOL*/
   /*mickey mouse stuff to reset Nth indicator at end of kinemage*/
   /*  so another one could be done this same run*/
   /*current char number is jth-1 */
   if( ((jth-1) < 7) && (creturn  == check[jth-1]) )
   {/*must get perfect match of first 7 char of line, 0--6*/
      if(iend == 6) 
      {/*6th char==h, @finish recognized, reset line counter*/
       /*but mage parser needs a white space to trigger keyword*/
       /*recognization*/
       Lfinish = 1;
/*printf(" finish ");*/
      }
      else
      {
         iend++;
      }
   }
   
   if(creturn == '\r')
   {/*ASCII Carriage Return used in stored kinemage to end a line*/
      jth = 0; /*ready to begin next line*/
      iend = 0;
      if(Lfinish)
      {/*white space for sure*/
         Nth = 0; /*ready for next kinemage*/
         Lfinish = 0;  /*GetStuffFromFile() should not call again*/
      }
      else
      {
         Nth++; /*next line*/
      }
   }
/*printf("%d,%d,%d:%c \n",Nth,jth,iend,creturn);*/
   return(creturn);
}
/*___getinternalkinemage()___________________________________________________*/
