/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/***MAGEINIT.C***************************************************************/
/*MAGE
 * shows KINEMAGEs
 *
 *  MAGE: Attribution Notice:
 * MAGE program: copyright c David C. Richardson, 
 *     1991,1992,1993,1994,1995,1996,1997,1998,1999,2000
 *                                     all rights reserved
 *            Little River Institute, 5820 Old Stony Way, Durham, NC 27705
 *
 * First use was for the Interactive Graphics Appendix to Protein Science,
 *                                           Journal of the Protein Society.
 * Use and distribution for non-profit educational and research purposes
 * encouraged.  Rewrites for this and other platforms encouraged for similar
 * use and distribution.
 *            David C. Richardson, dcr@kinemage.biochem.duke.edu
 *    Biochemistry Dept., Duke University, Durham, North Carolina 27710, USA
 * Concept and MAGE   Developed by David C. Richardson and Jane S. Richardson
 *        "Kinemage" name invented by Caroline P. Usher
 * Grateful acknowledgement of many years of support from NIH, grant GM15000
 * which included visualization of protein structures and the development of
 * CHAOS: display program written in E&S PS300 function-net language,
 * CHAosIN Fortran program,  etc.
 *
 *   Although this code obviously bears resemblance to many examples of
 *    .c code, one hopes this combination and construction departs from the
 *    examples far enough so that there is no danger of copywrite infringement,
 *    nor blame for failings, going back to earlier work.
 *   On the other hand, there is a real intellectual debt owed.
 *   In particular:
 *     Think C development system, examples, and manual, Symantec Corp. 1989 +
 *            and several timely hints from Think C technical Support!
 *     Apple Inside Macintosh, Addison-Wesley, 1985
 *          (the essentual and eventually preferred ref)
 *     Several suggestions and a look at real code by Warren Robinett
 *     Using the Macintosh Toolbox with C,
 *            F.A.Huxham, D.Burnard,J.Takatsuka 2nd Ed. Sybex,1989
 *     Macintosh C Programming Primer, Vol. II, D. Mark, Addison-Wesley, 1990
 *     Macintosh C Programming Primer, Vol. I 2nd Ed,  Mark & Reed, 
 *            Addison-Wesley,1992.  Particularly for AppleEvents
 *     Roger Sayle, RasMol author, for making rasmol produce kinemage files,
 *         and whose code showed me really how to use Apple Events!
 *     Robert Weiss who began making useful suggestions even before he signed
 *         on to help rewrite MAGE for the PC. (== coauthor for first PC_MAGE)
 *     Borland C++, Borland International, Inc. 1991
 *      (but MAGE tries to be vanilla C as much as possible)
 *     Microsoft Windows Programmer's Reference, for version 3,  1990
 *     UNIX and MOTIF: 
 *     Power Programming Motif, E.F.Johnson & K. Reichard, 2nd Ed. 1993
 *       MIS Press, New York.
 *     OSF/Motif Programmer's Reference, OSF, 1990, Prentice Hall
 *     O'Reilly pub X window system manuals, esp Vol 1,2 (Xlib), 4,5 (Xtlib)
 *     Doug Hoffman for UNIX Makefile magic and Bogus Linnux.
 *     Brian Thomas & Michael Prisant for help getting LINUX going.
 *     Mike Word for real Encapsulated PostScript and many tips and ideas
 *      that helped me rebuild MAGE to be more object oriented.
 *      Also did much of the UNIX MAGE-Probe interactive, interprogram real-time
 *      updates, which is used for MAGE-PREKIN as well.
 *     Brent Presley for porting PCMAGE to 32bit Visual C++ code and helping
 *       reconcile that version of MAGE on all platforms.     971001
 *     Mac MAGE-PREKIN AppleEvent interprogram stuff drew heavily from:
 *     "ReverSever" (PREKIN) "ReverClient" (MAGE), Ultimate Mac Programming, 
 *       Volume I, Copyright 1994, Dave Mark and Donald Olson: "code is free..."
 * Files: various MAGE____.c routines, MAC____.c, MPC____.c, MUX____.c, etc.
 *  &  platform specific libraries like: ANSI & MacTraps from THINK-C library.
 * Mac Files are grouped, esp Main,Draw that call each other during
 *  critical speed use, i.e. for the real time rotation.
 * Files are Refered to by comments. 
 * AMAC... is for mac routines that can't be copied over to PC robustly.
 * MAC...  is for mac routines that can be copied.
 * MAGE... is for routines used by both Mac and PC and UNIX.
 * MPC...  is for PC routines that can be copied.
 * PCW...  is for PC Windows routines that probably can't be copied robustly.
 * UNIX versions are even more confusing, see top of MAGE.H
 *
 *  Coding follows Allman (BSD) indent style (Eric Allman, Berkeley)
 *  With some attempt to lead and trail subroutines so they can be seen easily
 *  and try to stay <=80 col so any editor, printer, or email is robust.
 *
 *Subroutine calls flagged by comment indicating source file of subroutine,
 * or if a C routine, etc. Beware: this is not always accurate! 
 * Some common C functions, like sprintf, are not always flagged.
 *To translate from English: alertstr[256],alertstr2[256],alertstr3[256] used
 * for comments to the reader.  Sometimes word[256] printed to alertstr2[256].
 * AMACMAGE.proj.rsrc and PCWMAGE.RC need translation.
 * check other sprintf calls here in MAGEINIT.C  
 ****************************************************************************/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/*MAGEINIT.C*****************************************************************/
/*initial routines */

#include "MAGE.h"
#include "MAGELIST.h"
#include "MAGEBBOX.h"
#include "MAGETABL.h"

#include <string.h>

/****getmageversion()*****************************************************/
void getmageversion()   /*common version number: MAGEMAIN.C */
{
       /* "details,ribbons,triangles,spheres"  */
       /*  CRLF"zoomless fixed points, subscripts, line color&width, PS"*/
       /*  CRLF"groups,subgroups,lists,points as structures. Docking"*/
       /*  "Mac & SGI checked T/B stereo for Crystal_Eyes"*/
       /*  "UNIX remote updating of kinemage" */
       /*  "32bit PCMAGE" 971001*/

/*COMPILE IN CHANGED DATE AND MAGE VERSION*/
         sprintf(temps,"dated:  001120" );
         MAGEVERSION = (float)5.79; /*display format only has 2 decimal places*/
/*CAN TINKER WITH (SO NEEDS TO BE CHECKED) this word character string to put in*/
/* x or other version number modifiers to be displayed on banner */
         sprintf(word," %.2f ",MAGEVERSION);
         
#ifdef EGAM
         sprintf(version,"EGAM version %s, %s",word,temps);
#else
#ifdef __MWERKS__         /*__MWERKS__ compiler specific*/
#if defined(powerc)  
         sprintf(version,"MAGE CW_PPC version %s, %s",word,temps);
#else
         sprintf(version,"MAGE CW_68K version %s, %s",word,temps);
#endif
#else
         sprintf(version,"MAGE version %s, %s",word,temps);
#endif
#endif
#ifdef MACINTOSH
  sprintf(modification,"sets colors to 256, quit restores original color mode"
	  CRLF" Feedback to mage@kinemage.biochem.duke.edu");
#endif
#ifdef PCWINDOWS
    sprintf(modification," PC MAGE for Windows95/98/NT/2000"
    CRLF" written by David C. Richardson and Brent K. Presley"
	CRLF" Feedback to mage@kinemage.biochem.duke.edu");
#endif
#ifdef UNIX_X11
    sprintf(modification," UNIX X11, Motif (or Lesstif)"
		CRLF" Feedback to mage@kinemage.biochem.duke.edu");
    /*sprintf(modification," UNIX X11,MOTIF,IRIX6.5"*/
#endif
#ifdef UNIX_PEX
    sprintf(modification," UNIX PEX alpha test"
		CRLF" Feedback to mage@kinemage.biochem.duke.edu"); /*980712*/
#endif
}
/*___getmageversion()____________________________________________________*/

/****mageinitialvalues()***************************************************/
void    mageinitialvalues()
{
  /*------------initial dialog allows change--------------------------*/
    MAXNUM = 4000;   /*atoms and points total stored per kinemage*/
    MAXDRAWS = 3500; /*moveto and drawto points at any time*/

  /*------------------------------------------------------------------*/


    MAXWORDCOM = 3500; /*total number of characters comment or wordlist*/
                        /*originally 23500 but anything will do */
    MAXCOM = 9000; /*starting total number all ptID characters*/ /*960511*/
    nwordcom = 1; /*starts at 1, since 0 means no comment or wordlist*/
    ncom = 1; /*starts at 1, since 0 means no ptIDs */ /*960511*/
              /* com[0]=='\0' dummy so run out of room without crashing*/
  /*--set array pointers==NULL so can tell if allocate them-----------*/

    memset(it,0,7);   /* optimized */
    /*for (i = 0; i < 7; ++i)it[i] = NULL;*/
    itpointptr = NULL;
    linkit = NULL;
    thelink[0] = NULL;
    thelink[1] = NULL;
    com = NULL;
    wordcom = NULL;
  /*------------------------------------------------------------------*/
    
    /*maxValue=10000; 981010*/
    /*minValue = 0;   981010*/
    width = 5;
if(IUX)
{
    GWIDTH = 800;   /* UNIX effective graphics area window width */
    GHEIGHT = 800;  /* graphics window height*/
    GZDEEP = 800;
}
else /*if(IMAC||IPC)*/
{
    GWIDTH = 400;   /* Mac effective graphics area window width */
    GHEIGHT = 400;  /* graphics window height*/
    GZDEEP = 400;
}
    WIDTH =  GWIDTH; /*GWIDTH & GHEIGHT adjusted when make grafWindow*/
    HEIGHT = GHEIGHT;/* WIDTH & HEIGHT reset then also */

    oldmaxwide=GWIDTH;
    CHEIGHT = 80;   /* caption window height */
    MHEIGHT = 60;   /* message place height (UNIX) */
    TWIDTH = 580;   /*reasonable width for a text window*/ /*980919 */
    MARGIN =  20;   /*minimal space to right of text, caption windows*/ /*980919*/
    TOPBAR =  42;   /*Space for junk at top, Mac needs 38*/ /*980919*/
    BOTTOMBAR= 6;  /*PC does in fact need space allowance here*/ /*980919*/
    MIDBAR =  32;   /*allows for Caption Bar between text and Caption*/ /*980919*/
    BORDER =   6;
if(IUX)
{
    BWIDTH = 125;   /*200 buttons,slider area width in graphics window*/
    ZWIDTH =  45;   /* 60 for zoom, zclip, ztran scroll bars */
}
else
{
    BWIDTH = 100;   /* buttons,slider area width in Mac graphics window*/
                    /*on Mac graphics screen: 100 for buttons with labels */
    ZWIDTH =  30;   /* 30 for zoom, zclip, ztran scroll bars */
}
    RWIDTH =   0;   /*variable:  0 initially for bondrotation scroll bars */
    ROTSWIDTH=100;  /*Mac allowance for bondrotation scroll bars, PC resets*/
    ROTWINDWIDTH=200; /*constant for bondrotsliders separate UNIX window*/
    ROTSLIDERWIDTH=20; /*constant for bondrotsliders bar thickness UNIX */
    izclip = 200;
        /*std screen box 400x400x400, 0 at ctr, zclip 200 from ctr*/
    /*fzclip = 1.0;*/ /*factor==1.0 for std box, scale if screen box resized */
    fzclip = (float)GZDEEP/(float)400;/*std izclip defined in std screen box*/
    /*fzclip mediates between internal izclip value adjusted for box expansion*/
    /* and external izclip which pretends to be in a 400x400x400 box */
    zoom = 1.0;
    iztran = 0;

    Lstereo = 0;
    LTBstereo = 0;  /*970408*/
#ifdef UNIX_X11
    TBYoffset = 35; /*970607*/ /*SGI value on IRIS*/
#else
    TBYoffset = 21; /*970603*/ /*Mac value on Old Bill*/
#endif
    defaultangle = 6.0;
    stereoangle = defaultangle;
    ieyedefault = GWIDTH/2;
    ieyewide = ieyedefault;
    ieyeposdefault = 2000;
    ieyeposition = ieyeposdefault;
    Lmiddle = 1;
    Lrotateye = 0; /*ON: rotation around eye position*/
    Lcenterinfo = 0; /*ON: write ptID and dist near center line*/
    Lrecalculate = 0;
    Lmultibins = 0;
    multibins = 1;
    Lmoview = 0;
    Lkeepstereo = 0;
    Lkeepthinline = 0;
    Scale = 1.0;

    nbondrot = 0;  /*initially should be 0, no provision for bond rotation*/
    distuser = 0.0;  /*distance and angle preferences for constructing lines*/
    angleuser = 0.0;
    dihedraluser = 0.0;
    diststored = (float)1.54; /*distance and angles stored for construction*/
    anglestored = (float)109.6;
    dihedralstored = (float)120.0;
    distarrow = (float)0.30; /*distance (length) of tine stored for arrow*/
    anglearrow = (float)30.0; /*angle of tine stored for arrow*/
    dihedralarrow = (float)90.0; /*360/90 == 4 tines on arrowhead*/
    Ldrawunpickable = 0; 
    shortenline = 0.0; /*draw new amount to shorten lines, e.g. H-bonds*/

    ibigfont = 0;  /*ibigtype=40 for PC with clunky old big type font*/
           /* moves the rightside screen messages ibigfont pixels left*/

    zoomfac = 1.0; /*slider uses this directly*/
    slabfac = 2.0; /*slider uses this * 100*/
    tranfac =0.0;  /*slider uses this * 100*/
    Initialized = 0;
    SliderWidth = 0;

    Loriginatctr = 0;
    ixctr = GWIDTH/2;
    iyctr = GHEIGHT/2;
    izctr = GZDEEP/2;

    textHeight = 1;
    captHeight = 1;
    widMax = 1;
    nxyz = 1;
    nmovedraws=0;
    ntotaltext=0;
    
    /*sprintf(draglinestr,"dragline");*/ /*960603*/
    /*condition(draglinestr);*/
    Lkinformat = 1; /*output for rotated parts*/    
    Lformattest = 0; /*MAGE does best it can silently unless this on */
    Lflat = 0; /*ON: mouse does translations rather than rotations*/
    Lscroll = 0; /*xy rotations instead of translation by mouse*/
    Lhorizon = 0; /*ON: mouse only rotates around vertical y axis*/
    Lpickmarkcriteria=0;/*FLAGs: pickmarker extentions in axial directions*/
    Lpostscript = 0;
    Lspecialloop = 0;
    Lnewlabels = 0;
    Lnewlabelson = 0;
    Lmonitor = 0;
    Lprocessing = 0;
    Liveoffscreenbitmap = 0; /*flag for off-screen bitmap */ 
    Lquesanswers = 0; /*flag for questions in text part of kinemage*/

	memset(alertstr,'\0',MAXALERTSTR);/*optimized array initialization*/
	memset(word,'\0',256);    /* optimized array initialization */
	memset(temps,'\0',256);   /* optimized array initialization */
    /* for(n=0; n<256; n++) alertstr[n] = '\0';*/ /*clear alert report*/
    /* for(n=0; n<256; n++) word[n] = '\0';  */ /* clear alert report */
    /* for(n=0; n<256; n++) temps[n] = '\0';  */ /* clear alert report */ 

/*icommax = 0;  960511 */ /*maximum allocated pointID array*/

    firstlistptr = NULL;
    thislistptr = NULL;
    lastlistptr = NULL;
    firstsgrpptr = NULL;
    thissgrpptr = NULL;
    lastsgrpptr = NULL;
    firstgrupptr = NULL;
    thisgrupptr = NULL;
    lastgrupptr = NULL;
    firstmasterptr = NULL;
    lastmasterptr = NULL;
    firstbboxptr = NULL;
    lastbboxptr = NULL;

drawgrupptr = NULL;
measuregrupptr = NULL;
animbboxptr = NULL;
anim2bboxptr = NULL;
pickbboxptr = NULL;
picktablebboxptr = NULL;
pickshowbboxptr = NULL;
pickcolorbboxptr = NULL;
zclipbboxptr = NULL;
drawlabelsbboxptr = NULL;
drawlinebboxptr = NULL;
construct4bboxptr = NULL; /*971122*/
construct5bboxptr = NULL; /*971122*/
draglinebboxptr = NULL;
monitorbboxptr = NULL;
eraselinebboxptr = NULL;
prunebboxptr = NULL;
punchbboxptr = NULL;
undopbboxptr = NULL;


    updateratelimitdefault = 5.0; /*970508 has shift-key over-ride*/
 
Lappend = 0; /*new file makes new kinemage unless Lappend flagged*/
Lupdate = 0;
Linhibiton = 0; /*inhibits update call to remote program*/
Linhibitbutton = 0;
Ldeleteappend = 0;
Lignorecaption = 0; /*set to avoid accummulating probe captions*/
update_res_num = 0;
update_file_name[0] = '\0';
update_command_line[0] = '\0';
input_command_line[0] = '\0';
firstappendgrupptr = NULL;
lastappendgrupptr = NULL;
activebondrotlistptr = NULL;
lensFactor = 7.0;
killradius = 20;
Lfloat = 1; /*1: float perspective, 0: NOT floating point in inner loop*/

tablefontsize  = 14; /*default set before any @tablefontsize !!!!*/
tablecolscale = (float)1.3; /*default set here to be before any @tablescale !!!!*/
Ltablepresent = 0; /*but input must determine if a table is present*/
tablemarkradius = (float)0.2;
tablefanradius = (float)0.4;
tablefancore = (float)0.1;
Lpipeactive = 0; 
Lpipebufferloaded = 0;
Lstartinpipe = 0; 
Ldonewithpipe = 0;

Linfofontsize   = 0; /*0: no deliberate font size control*/
Llabelsfontsize = 0; /*, resize them with window*/
Lwordsfontsize  = 0;
Ltablefontsize  = 0;
Ldockingscope   = 0;

Lscalemarkers = 0; /*000804*/
}
/*___mageinitialvalues()____________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****setMageinitDLOGreport()*************************************************/
void    setMageinitDLOGreport(void)
{                                          /*950110 CRLF */
            sprintf(alertstr,
            "MAGE: copyright \251 2000 by David C. Richardson, "
            CRLF"Little River Institute, 5820 Old Stony Way, "
                   "Durham NC 27705 "
            CRLF"       dcr@kinemage.biochem.duke.edu"      
            CRLF"Biochemistry Dept., Duke University, "
                   "North Carolina 27710, USA"
            );
            sprintf(alertstr2,
            "%s"
            CRLF"%s"
            CRLF"MAGE may be freely copied and distributed."
            ,version,modification
            );
            if(fp != NULL)
            {/*990129*/
               if(Lkintitle) sprintf(word,"CURRENT KINEMAGE: %d - %s"
                   ,thiskinenum,kintitlestr);
               else sprintf(word," ");
               if(Lkincopyright) sprintf(temps,"copyright: %s",kincopyrightstr);
               else sprintf(temps," ");
               sprintf(alertstr3,"CURRENT INPUT FILE:"CRLF"%s"CRLF"%s"CRLF"%s"
                       ,NameStr,word,temps);
            }
            else if(Lkinfile > 1)
            {
               sprintf(alertstr3,
                 "Showing internally generated text and/or kinemage");
            }   
            else
            {
               sprintf(alertstr3, " ");
            }
}            
/*___setMageinitDLOGreport()________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****clearfocusxyzstr()******************************************************/
void    clearfocusxyzstr()
{
    sprintf(focusxyzstr,"\0"); /* clear focusxyzstr for it to be used */
    condition(focusxyzstr);       /* for x,y,z report on graph screen */
}
/*___clearfocusxyzstr()_____________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/

/****allocdisplayarrays()****************************************************/
void    allocdisplayarrays(int more)
{
/*    int    it[7][MAXDRAWS];  */   /* size = 2*MAXDRAWS*7 9310:7->8 */
/*    long   linkit[MAXDRAWS];  */   /* size = 4*MAXDRAWS*8 9310:7->8 */
/*    pointstructptr* itpointptr[MAXDRAWS] */

    int  j, ifail, recycle, moretry;
    int   *ittemp[7];
    long  *linkittemp;
    pointstructptr* itpointptrtemp = NULL;

    /*more==0 for first call to allocate initial arrays*/
    moretry = more;
    recycle = 1;
    while(recycle==1)
    {/*recycle allocation trials*/
      ifail = 0;
      if( (MAXDRAWS+more) < 0) ifail = 1; /*increase rolls number to negative*/
      if(ifail == 0)
      {/*not failed yet*/
        for(j = 0; j < 7 ; j++)
        {/*it[0-7]*/
            if(more==0)
            {
                it[j] = (int *)malloc(sizeof(int)*(long)MAXDRAWS);
                if(it[j]==NULL) ifail = 1;
            }
            else
            {
                ittemp[j] = (int *)realloc(it[j],sizeof(int)*(long)(MAXDRAWS+more));
                if(ittemp[j]==NULL) ifail = 1;
            }
        }/*it[0-6]*/
      }/*not failed yet*/
      if(ifail == 0)
      {/*not failed yet*/
        /*now do linkit*/
        {/*linkit*/
            if(more==0)
            {
                linkit = (long *)malloc(sizeof(long)*(long)MAXDRAWS);
                if(linkit==NULL) ifail = 1;
            }
            else
            {
                linkittemp = (long *)realloc(linkit,sizeof(long)*(long)(MAXDRAWS+more));
                if(linkittemp==NULL) ifail = 1;
            }
        }/*linkit*/
      }/*not failed yet*/
      if(ifail == 0)
      {/*not failed yet*/
        {/*itpointptr*/  
            if(more==0)
            {
                itpointptr = (pointstructptr*)malloc(
                                              sizeof(pointstructptr)*MAXDRAWS);
                if(itpointptr==NULL) ifail = 1;
            }
            else
            {
                itpointptrtemp = (pointstructptr*)realloc(itpointptr
                                    ,sizeof(pointstructptr)*(MAXDRAWS+more));
                if(itpointptrtemp==NULL) ifail = 1;
            }
        }/*itpointptr*/
      }/*not failed yet*/

        if(more>0 && ifail==1)
        {/*failed to do a reallocation, reduce request and try again*/
            more = more/2;
            if(more > 3) recycle = 1;
            else    recycle = 0;
        }
        else
             recycle = 0;
    }/*recycle allocation trials*/

    if(more>0 && ifail==0)
    {/*reassign pointers*/
        for(j=0;j< 7;j++) it[j] = ittemp[j];
        linkit = linkittemp;
        itpointptr = itpointptrtemp;
        MAXDRAWS = MAXDRAWS+(long)more; /*increase limit*/
    }

    if(more==0 && ifail)
    {/*failure at first load, report real trouble*/
        fprintf(stderr,"failure at first load of display arrays\n");
    }

    if(Ltest && !Limitmaxdraws) /*970410*/
              /*970104 only report failure in test mode so not cycle on*/
              /*updating graphics window after dialog box*/
    {
        if(more>0 && ifail>0)
            sprintf(alertstr,"+%d reallocation failed, MAXDRAWS remains: %ld"
             ,moretry,MAXDRAWS);
        else
            sprintf(alertstr,"MAXDRAWS== %ld",MAXDRAWS);

        sprintf(alertstr2,
           "alloc: it[0]==%ld, it[1]==%ld, it[2]==%ld, it[3]==%ld"CRLF
           "alloc: it[4]==%ld, it[5]==%ld, it[6]==%ld, linkit==%ld"CRLF
           "alloc: itpointptr==%ld"
         ,it[0],it[1],it[2],it[3],it[4],it[5],it[6],linkit,itpointptr);

        sprintf(alertstr3," ");
        DoMageDLOGreport(2); /*___DLOG.C*/ /*alertstr,alertstr2,alertstr3*/
        Limitmaxdraws=1; /*970410*/
            /*reset to 0 in MAGEINPT so each kinemage reports once*/
    }
    if(ifail&&more==0)
    {
        sprintf(alertstr,"allocation of more display space failed");  /*950110*/
        sprintf(alertstr2,"expect truncated image");
#ifdef MACINTOSH
        sprintf(alertstr3
                     ,"Perhaps preferred size too small: Before launching MAGE:"
                          CRLF"one click on MAGE, choose Info under File Menu: "
                          CRLF"change preferred size to, e.g., 2000 ");
#else
        sprintf(alertstr3," ");
#endif
        DoMageDLOGreport(2); /*___DLOG.C*/ /*alertstr,alertstr2,alertstr3*/
        /*cleanup();*/
        /*exit(EXIT_FAILURE);*/
    }
}
/*___allocdisplayarrays()___________________________________________________*/

/****allocwordcomarray()*****************************************************/
void    allocwordcomarray(int more)
{
/* char  *wordcom;  pointer to array, for wordcom[MAXWORDCOM], size=MAXWORDCOM*/
/* the comment or wordlist character array  */

    int  ifail, recycle, moretry;
    char *wordcomtemp;

    /*more==0 for first call to allocate initial arrays*/
    moretry = more;
    recycle = 1;
    while(recycle==1)
    {/*recycle allocation trials*/
        ifail = 0;
        if( (MAXWORDCOM+more) < 0) ifail = 1;
        if(ifail==0)
        {
            if(more==0)
            {
                wordcom = (char *)malloc(sizeof(char)*MAXWORDCOM);
                if(wordcom==NULL) ifail = 1;
                else wordcom[0] = '\0'; /*place for zero length strings*/
            }
            else
            {
            wordcomtemp=(char *)realloc(wordcom,sizeof(char)*(MAXWORDCOM+more));
            if(wordcomtemp==NULL) ifail = 1;
            }
        }
        if(more>0 && ifail==1)
        {/*failed to do a reallocation, reduce request and try again*/
            more = more/2;
            if(more > 3) recycle = 1;
            else    recycle = 0;
        }
        else
             recycle = 0;
    }/*recycle allocation trials*/

    if(more>0 && ifail==0)  wordcom = wordcomtemp; /*reassign pointer*/
    if(more>0 && ifail==0) MAXWORDCOM = MAXWORDCOM + more; /*increase limit*/
    if(( Ltest||ifail) && !Limitmaxwordcom) /*970410*/
    {
        if(more>0 && ifail>0)
            sprintf(alertstr,"+%d reallocation failed, MAXWORDCOM remains: %d"
            ,moretry,MAXWORDCOM);
        else
            sprintf(alertstr,"MAXWORDCOM == %d",MAXWORDCOM);
        sprintf(alertstr2,"alloc: wordcom==%ld",wordcom );
        sprintf(alertstr3," ");
        DoMageDLOGreport(2); /*___DLOG.C*/  /*alertstr,alertstr2,alertstr3*/
        Limitmaxwordcom=1;/*970410*/
            /*reset to 0 in MAGEINPT so each kinemage reports only once*/
    }
    if(ifail&&more==0)
    {
        sprintf(alertstr,"allocation of more comment space failed");  /*950110*/
        sprintf(alertstr2,"expect truncated words");
#ifdef MACINTOSH
        sprintf(alertstr3,"Perhaps preferred size too small: Before launching MAGE:"
                          CRLF"one click on MAGE, choose Info under File Menu: "
                          CRLF"change preferred size to, e.g., 2000 ");
#else
        sprintf(alertstr3," ");
#endif
        DoMageDLOGreport(2); /*___DLOG.C*/ /*alertstr,alertstr2,alertstr3*/
        /*cleanup();*/
        /*exit(EXIT_FAILURE);*/
    }
}
/*___allocwordcomarray()____________________________________________________*/

/****alloccomarray()*****************************************************/
void    alloccomarray(int more)
{
/* char  *com;  pointer to array, for com[MAXCOM], size=MAXCOM*/
/*long  MAXCOM*/  /*970410*/
/* the comment or wordlist character array  */

    int  ifail, recycle, moretry;
    char *comtemp;

    /*more==0 for first call to allocate initial arrays*/
    moretry = more;
    recycle = 1;
    while(recycle==1)
    {/*recycle allocation trials*/
        ifail = 0;
            if(more==0)
            {
                com = (char *)malloc(sizeof(char)*MAXCOM);
                if(com==NULL) ifail = 1;
                com[0] = '\0'; /*place for zero length strings*/
            }
            else
            {
            comtemp=(char *)realloc(com,sizeof(char)*(MAXCOM+more));
            if(comtemp==NULL) ifail = 1;
            }
        if(more>0 && ifail==1)
        {/*failed to do a reallocation, reduce request and try again*/
            more = more/2;
            if(more > 3) recycle = 1;
            else    recycle = 0;
        }
        else recycle = 0;
    }/*recycle allocation trials*/

    if(more>0 && ifail==0)  com = comtemp; /*reassign pointer*/
    if(more>0 && ifail==0) MAXCOM = MAXCOM + more; /*increase limit*/
    if( (Ltest||ifail) && !Limitmaxcom) /*970410*/
    {
        if(more>0 && ifail>0)
            sprintf(alertstr,"+%d reallocation failed, MAXCOM remains: %d"
            ,moretry,MAXCOM);
        else
            sprintf(alertstr,"MAXCOM == %d",MAXCOM);
        sprintf(alertstr2,"alloc: com==%ld",com );
        sprintf(alertstr3," "); 
        DoMageDLOGreport(2); /*___DLOG.C*/  /*alertstr,alertstr2,alertstr3*/
        Limitmaxcom = 1; /*970410*/
            /*reset to 0 in MAGEINPT so each kinemage reports once*/
    }
    if(ifail&&more==0)
    {/*initial failure*/
        sprintf(alertstr,"allocation of ptID space failed");  /*950110*/
        sprintf(alertstr2,"expect truncated words");
#ifdef MACINTOSH
        sprintf(alertstr3
                     ,"Perhaps preferred size too small: Before launching MAGE:"
                          CRLF"one click on MAGE, choose Info under File Menu: "
                          CRLF"change preferred size to, e.g., 2000 ");
#else
        sprintf(alertstr3," ");
#endif
        DoMageDLOGreport(2); /*___DLOG.C*/ /*alertstr,alertstr2,alertstr3*/
        /*cleanup();*/
        /*exit(EXIT_FAILURE);*/
    }/*initial failure*/
    if(ifail==0 && more==0)
    {/*initial success*/
        com[0] = '\0'; /*use this as dummy if later run out of room*/
                       /*new ptIDs start at com[1]...*/
    }/*initial success*/
}
/*___alloccomarray()____________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****alloclinkarrays()*******************************************************/
void    alloclinkarrays(void)
{
/*these arrays come in sets that have to be of the same size since they*/
/* are indexed the same way, and subject to random access */

    int  j, ifail;

        ifail = 0;

        for(j = 0; j <= 1 ; j++)
        {
                thelink[j] = (long *)malloc(sizeof(long)*1000L);
                if(thelink[j]==NULL) ifail = ifail+1;
        }

    if(Ltest)
    {
        sprintf(alertstr," ");

        sprintf(alertstr2,"alloc: "
         CRLF"thelink[0]==%ld,thelink[1]==%ld"
         ,(long)thelink[0],(long)thelink[1]);
        sprintf(alertstr3," ");
        DoMageDLOGreport(2); /*___DLOG.C*/ /*alertstr,alertstr2,alertstr3*/
    }
    if(ifail)
    {
        sprintf(alertstr,"allocation of link list space failed");
        sprintf(alertstr2," ");
        sprintf(alertstr3," ");
        DoMageDLOGreport(2); /*___DLOG.C*/ /*alertstr,alertstr2,alertstr3*/
        /*cleanup();*/
        /*exit(EXIT_FAILURE);*/
    }
}
/*___alloclinkarrays()_______________________________________________________*/

/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****cleanup()***************************************************************/
void cleanup(void)  
{
    int i;
    
    if(Ltablepresent > 0) cleanuptable(); /*old table to be destroyed*/
    
    for (i = 0; i < 7; ++i)
    {
        if (it[i] != NULL) free(it[i]);
    }
	if (com != NULL) free(com);
	if (wordcom != NULL) free(wordcom);
	if (itpointptr != NULL) free(itpointptr);
	if (linkit != NULL) free(linkit);
    if (thelink[0] != NULL) free(thelink[0]);
	if (thelink[1] != NULL) free(thelink[1]);

	killmasters();
	killcolorsets();
	killmeasures();
	killdrawline();
	if(nbondrot > 0)
        {/*nbondrot>0*/

            for(i=1; i<=nbondrot; i++)
            {/*loop over bondrots*/
                if(bondrotptr[i] != NULL)
                {
                  if(bondrotptr[i]->level > 0 || bondrotptr[i]->level== -1)
                  {/*independent rotation or first of a ganged set of rotations*/
                    /*only these have sliders*/
                    
                    erasebondrotvalue(i);
                    /*removes any previous kinemage bond rotation text*/

#ifdef UNIX_MOTIF
                    XtDestroyWidget(hgrafbondrot[i]);
                    XtDestroyWidget(bondrotvalue[i]);
                    /*XtDestroyWidget(bondrotstart[i]);*/ /*950617*/
                    /*XtDestroyWidget(bondrotname[i]);*/ /*950617*/
#endif
                    
                  }/*independent rotation or first of a ganged set of rotations*/

				  destroybondrotliststructure(bondrotptr[i]);
                }

                bondrotptr[i] = NULL;
                
            }/*loop over bondrots*/
        }/*nbondrot>0*/
	killgroups(); /* MAGELIST.C */
	if(Lpipeactive)
	{
	   doupdatefrompipe(999," "); /*close pipes____PIPE.c*/  /*991216*/
	   destroyallpipebuff(); /*____PIPE.c*/  /*991216*/
	}
}
/*___cleanup()______________________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/

