
/*let MAGELIST.c be the only routine to define MAGELIST*/
/*then  MAGELIST will mean extern for all other routines */
#ifdef  MAGELIST
#undef  MAGELIST
#define MAGELIST
#else
#define MAGELIST extern
#endif

#define MAXBONDPATT    37 /*# char in pattern describing rotation restrictions*/

#define MAXNAMECHAR    14 /*# char excluding terminator of group,etc names*/
/*because of master by name, group, subgroup, and list names must have*/
/*same maximum number of characters */

MAGELIST int maxlists,maxalloclists,maxsgrps,maxallocsgrps,maxgrups,maxallocgrups;

 typedef struct moreinfostruct {
	 struct moreinfostruct* moreinfoptr;
     int   it;
     float f1;
     float f2;
     float f3;
 }moreinfostruct;

 typedef struct pointstruct {
     struct moreinfostruct* moreinfoptr;
     struct pointstruct* previousptr;
     struct pointstruct* nextptr;
     struct liststruct*  listptr;
	 long  nameoffset;/*use offset so name char array can be*/
         /*reallocated to hold more ptIDnames*/
         /*use subroutines to store and retrieve ptIDs*/
         /*so mechanism hidden under, e.g. "thispointptr"*/
     long  wordoffset;
     unsigned int type; 
     unsigned int STATUS;
     unsigned int STYLE;
     int   colorwidth; 
     int   ix;
     int   iy;
     int   iz;
     float fx;
     float fy;
     float fz;
     float radius;
     char masterchar;
  }pointstruct;

 typedef pointstruct* pointstructptr;
 typedef pointstructptr* pointptrarray;
 MAGELIST pointptrarray itpointptr;
 MAGELIST pointstructptr prunepoint1ptr[11];
 MAGELIST pointstructptr prunepoint2ptr[11];
 MAGELIST int prunepointflag[11]; 


 MAGELIST struct pointstruct* firstpointptr;
 MAGELIST struct pointstruct* thispointptr;
 MAGELIST struct pointstruct* lastpointptr;
 MAGELIST struct pointstruct* pickedpointptr;
 MAGELIST struct pointstruct* lastdrawnpointptr;
 MAGELIST struct pointstruct* prelastdrawnpointptr;
 MAGELIST struct pointstruct* lastscaledpointptr;
 MAGELIST struct pointstruct* origpointptr;
 MAGELIST struct pointstruct* searchpointptr;
  
  MAGELIST struct pointstruct* beginselectionpointptr;
  MAGELIST struct pointstruct* endselectionpointptr;
  MAGELIST int Lbeginselection;
  MAGELIST int Ldockingscope;
  MAGELIST int Ndockingbondrot;

 typedef struct liststruct {
     ControlHandle button;
          /*ControlHandle typedef--> HWND for PC, -->Widget for MUX */
	 struct pointstruct* firstpointptr;
     struct pointstruct* lastpointptr;
     struct sgrpstruct* sgrpptr; 
     struct liststruct* previousptr;
     struct liststruct* nextptr;
     struct liststruct* instanceptr;
     unsigned int type; 
     unsigned int STATUS;
     unsigned int STYLE;
     int   on; 
     int   color; 
     int   width;
     int   owncolor;
     int   bondrot;
     
     unsigned int master;
     unsigned int colorset;
     float radius;
     float angle; /*000804*/
     char  wordsfont;
     char  wordsface;
     char  wordssize;
     char  name[MAXNAMECHAR+2];
 }liststruct;


 MAGELIST struct liststruct* firstlistptr;
 MAGELIST struct liststruct* thislistptr;
 MAGELIST struct liststruct* lastlistptr;
 MAGELIST struct liststruct* pickedlistptr;
 MAGELIST struct liststruct* marker1listptr;
 MAGELIST struct liststruct* marker2listptr;
 MAGELIST struct liststruct* markergnom1listptr; /*gnomon list vectors*/
 MAGELIST struct liststruct* markergnom2listptr; /*gnomon list labels*/
 MAGELIST struct liststruct* marker1origlistptr;
 MAGELIST struct liststruct* marker2origlistptr;
 MAGELIST struct liststruct* markergnom1origlistptr;/*gnomon list vectors*/
 MAGELIST struct liststruct* markergnom2origlistptr;/*gnomon list labels*/
 MAGELIST struct liststruct* thismarkerlistptr;     /*only used in MAGEDRAW ??*/
 MAGELIST struct liststruct* thismarkeroriglistptr; /*only used in MAGEDRAW ??*/
 MAGELIST struct liststruct* tablemarkerlistptr;

 MAGELIST struct liststruct* measurelinelistptr;
 MAGELIST struct liststruct* measuredotslistptr;
 MAGELIST struct liststruct* drawmarkeroriglistptr;
 MAGELIST struct liststruct* drawmarker1listptr;
 MAGELIST struct liststruct* drawmarker2listptr;
 MAGELIST struct liststruct* drawmarker3listptr;
 MAGELIST struct liststruct* drawmarker4listptr; /*971122*/
 MAGELIST struct liststruct* drawnewlistptr;
 MAGELIST struct liststruct* searchlistptr;
 MAGELIST struct liststruct* origlistptr;

 typedef struct sgrpstruct {
	 ControlHandle button;
          /*ControlHandle typedef--> HWND for PC, -->Widget for MUX */
     struct grupstruct* grupptr;
     struct liststruct* firstlistptr;
     struct liststruct* lastlistptr;
     struct sgrpstruct* previousptr;
     struct sgrpstruct* nextptr;
     struct sgrpstruct* instanceptr;
     unsigned int STATUS;
     unsigned int type;

     int   on; 
     int   balllists; 
     int   bondrot;
     unsigned int master;
     char  name[MAXNAMECHAR+2];
 }sgrpstruct;


 MAGELIST struct sgrpstruct* firstsgrpptr;
 MAGELIST struct sgrpstruct* thissgrpptr;
 MAGELIST struct sgrpstruct* lastsgrpptr;
 MAGELIST struct sgrpstruct* pickedsgrpptr;
 MAGELIST struct sgrpstruct* markersgrpptr;
 MAGELIST struct sgrpstruct* measuresgrpptr;
 MAGELIST struct sgrpstruct* drawmarkersgrpptr;
 MAGELIST struct sgrpstruct* drawnewsgrpptr;
 MAGELIST struct sgrpstruct* searchsgrpptr;
 MAGELIST struct sgrpstruct* tablemarkersgrpptr;
 
 typedef struct grupstruct {
     ControlHandle button;
          /*ControlHandle typedef--> HWND for PC, -->Widget for MUX */
     struct sgrpstruct* firstsgrpptr;
     struct sgrpstruct* lastsgrpptr;
	 struct grupstruct* previousptr;
     struct grupstruct* nextptr;
     struct grupstruct* instanceptr;
     float pointx[3];/*pt on each axis*/
     float pointy[3];/*pt on each axis*/
     float pointz[3];/*pt on each axis*/
     float position[3];/*, and at origin*/
     unsigned int STATUS;
     unsigned int type;
     int   on; 
     
     int   balllists; 
     int   bondrot;
     int   animate;
     int   moview;
     int   info;
     unsigned int master;
     char  name[MAXNAMECHAR+2];/*allow animate flag & \0 ending*/
     char  pdbfilestr[256]; /*groups can refer to a pdb file*/
 }grupstruct;


 MAGELIST struct grupstruct* firstgrupptr;
 MAGELIST struct grupstruct* thisgrupptr;
 MAGELIST struct grupstruct* lastgrupptr;
 MAGELIST struct grupstruct* pickedgrupptr;
 MAGELIST struct grupstruct* markergrupptr;
 MAGELIST struct grupstruct* measuregrupptr;
 MAGELIST struct grupstruct* drawgrupptr;
 MAGELIST struct grupstruct* searchgrupptr;
 MAGELIST struct grupstruct* nextanimategrupptr;

 MAGELIST struct grupstruct* firstappendgrupptr; /*970521*/
 MAGELIST struct grupstruct* lastappendgrupptr;
 MAGELIST struct grupstruct* tablemarkergrupptr;

 typedef struct masterstruct {
     ControlHandle button;
          /*ControlHandle typedef--> HWND for PC, -->Widget for MUX */
	 struct masterstruct* previousptr;
     struct masterstruct* nextptr;
     unsigned int STATUS;
     int   on; 
     int   indent;
     int   space;
     unsigned int   mask;
     char  name[MAXNAMECHAR+2];/*allow \0 ending*/
     char  masterchar; /*single char pointmaster code */ /*991210*/
 }masterstruct;

 MAGELIST struct masterstruct* firstmasterptr;
 MAGELIST struct masterstruct* lastmasterptr;
 MAGELIST struct masterstruct* thismasterptr;
 
 MAGELIST  int    nmaster,Lmaster; 

 typedef struct colorsetstruct {
     struct colorsetstruct* previousptr;
     struct colorsetstruct* nextptr;
     int   color; 
     unsigned int   mask;
     char  name[MAXNAMECHAR+2];/*allow \0 ending*/
 }colorsetstruct;
 MAGELIST struct colorsetstruct* firstcolorsetptr;
 MAGELIST struct colorsetstruct* lastcolorsetptr;
 MAGELIST struct colorsetstruct* thiscolorsetptr;
 MAGELIST  int    ncolorset,Lcolorset; 

#define MAXBONDROT 100  /*number of bond rotations provided*/
MAGELIST ControlHandle  hgrafbondrot[MAXBONDROT+1];
MAGELIST    int     nbondrot,Lbondrotscope;
MAGELIST    int     Lbrotoption,Lsamescope;

#ifdef PCWINDOWS
#define MAGEBONDROTID 100     /* up to MAXBONDROT ( = 10 ) 10 --- 19 */
  MAGELIST HWND bondrotWindow[MAXBONDROT+1];
#endif /*PCWINDOWS*/

#ifdef UNIX_X11
/*slider Widgets == ControlHandle  hgrafbondrot[MAXBONDROT+1];*/
MAGELIST  Widget bondrotvalue[MAXBONDROT+1], bondrotstart[MAXBONDROT+1];
MAGELIST  Widget bondrotname[MAXBONDROT+1]; 
MAGELIST  Widget bondrotscope[MAXBONDROT+1]; 
MAGELIST  Widget bondrotdivide[MAXBONDROT+1]; 
MAGELIST  GC bondrotpatterngc[MAXBONDROT+1]; 
#endif /*UNIX_X11*/
MAGELIST  char bondrotpattern[MAXBONDROT+1][MAXBONDPATT+1]; 
MAGELIST  int  bondrotgoodcolor[MAXBONDROT+1]; 
MAGELIST  int  bondrotbadcolor[MAXBONDROT+1]; 
MAGELIST  int  bondrotblahcolor[MAXBONDROT+1]; 
MAGELIST  int  bondrotgoodmax[MAXBONDROT+1]; 
MAGELIST  int  bondrotbadmin[MAXBONDROT+1]; 
MAGELIST  int  Lpattern; /*input flag*/

 typedef struct bondrotliststruct {
     struct pointstruct* firstpointptr; /*scope of rotation*/
     struct pointstruct* lastpointptr;
     struct pointstruct* tailpointptr;/*"bond"axis of rotation*/
     struct pointstruct* headpointptr;
     struct sgrpstruct* sgrpptr; 
     struct bondrotliststruct* previousptr;
     struct bondrotliststruct* nextptr;
     int    level;
     int    option;
     int    scopeinstance;
     float  origangle;
     float  angle;
     char   name[MAXNAMECHAR+2];
 }bondrotliststruct;

 MAGELIST struct bondrotliststruct* firstbondrotlistptr;
 MAGELIST struct bondrotliststruct* thisbondrotlistptr;
 MAGELIST struct bondrotliststruct* lastbondrotlistptr;
 MAGELIST struct bondrotliststruct* activebondrotlistptr;

 typedef bondrotliststruct* bondrotliststructptr;
 MAGELIST bondrotliststructptr bondrotptr[MAXBONDROT+1];

/*prototypes*/
struct moreinfostruct*  allocmoreinfostructure(void);
void destroymoreinfostructure(moreinfostruct* victimptr);

struct pointstruct*   allocpointstructure(liststruct*);
struct pointstruct*   alloclonelypointstructure();
int    copypointstructure(pointstruct*, pointstruct*);
struct pointstruct*  insertpointstructure(pointstruct*,int);
void destroypointstructure(pointstruct*);

int allocspecialintpoint(liststruct*, int, int, int, int);

int  allocliststructure(void);
void destroyliststructure(liststruct* victimptr);

int  allocsgrpstructure(void);
void destroysgrpstructure(sgrpstruct* victimptr);

int  allocgrupstructure(void);
void destroygrupstructure(grupstruct* victimptr);

void killgroups(void);
void killappendedgroups(void);

int  allocmasterstructure(void);
void destroymasterstructure(masterstruct* victimptr);
void killmasters(void);

int  alloccolorsetstructure(void);
void destroycolorsetstructure(colorsetstruct* victimptr);
void killcolorsets(void);
void    adjustcolorset(unsigned int, int);
void    resetcolorset(int);


struct bondrotliststruct*  allocbondrotliststructure(void);
void destroybondrotliststructure(bondrotliststruct* victimptr);

void storeptIDstring(char* thestring, pointstruct* thepointptr);
void getptIDstring(char* thestring, pointstruct* thepointptr);
void recoverptIDstring(char* thestring, pointstruct* thepointptr); /*970920*/
void storecommentstring(char* thestring, pointstruct* thepointptr);
void getcommentstring(char* thestring, pointstruct* thepointptr);
void calcintegerpoints(pointstruct* thepointptr);
void calcintegerfixedpoints(pointstruct* thepointptr);
void calcintegerscreenpoints(pointstruct* thepointptr); /*971011*/

/*prototypes that would be expected to be in MAGE.hdr, BUT...*/
void    fantoscreen(int,int,int,int,pointstruct*); 
   /*needs MAGELIST.h: struct pointstruct*  */
void    stackeddiskssphere(int,int,long,int);
void    surfacetriangle(int,int,int,int
         ,int,int,int,int,int,int,int
         ,pointstructptr,pointstructptr,pointstructptr);


/*prototypes moved from MAGEPOST.C on 970705*/
void postscripter(
long i,int penwidth,int icolor
 ,int ideepque, int idecue
 ,double sinangle[3],double cosangle[3]
 ,int ixseting[3],int iyset,int izset, int *postscriptcnt, int *inewpoint
 ,float eyeposition);
void fcheckzclip(float,float,float,float,float,float,float*,float*,
   float*,float*,float*,float*,int); /*used for postscript and raster3Drender*/
void finishpostscript(int*);
void loadpointpostscript(long,int,int,pointstructptr
    ,pointstructptr,pointstructptr); /*used for postscript and raster3Drender*/

void raster3Drender(
long i,int* oldcolordepth,int* oldpenwidth,int icolor
 ,int ipen,int ideepcue,int idecue,double sinangle[3],double cosangle[3]
 ,int ixseting[3],int iyset,int izset, int *inewpoint, float eyeposition);
void raster3Drenderfinish(void);
void raster3Dtextpreviewer(float,float,float,float,int,int,char[256]);

