/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/*MAGEOUT.C   MAGE general calls mostly doing writeouts */

#include "MAGE.h"
#include "MAGELIST.h"
#include "MAGEPOST.h"
#include "MAGEFLAG.h"
#include "MAGEANGL.h"
#include "MAGEBBOX.h"
#include "MAGETABL.h"

void writeindividuallist(void);
void writeindividualpoint(int);
void writepointID(void);
static int  Lbeginselectionout=0; /*beginselectionpointptr */

/****commandfrompointID()*****************************************************/
void commandfrompointID(void)
{
   char command[256];

   getptIDstring(word, pickedpointptr);
   sprintf(command,"echo \"@start\" >>simout.kin\n"); 
   system(command);
   sprintf(command,"echo \"@nowfind {%s}\" >>simout.kin\n",word); 
   system(command);
   sprintf(command,"echo \"@finish\" >>simout.kin\n"); 
   system(command);
}
/*___commandfrompointID()____________________________________________________*/

/****writepointID()***********************************************************/
void    writepointID()
{
   fprintf(fpout,"@start\n"); /*c*/
   getptIDstring(word, pickedpointptr);
   fprintf(fpout,"@nowfind {%s}\n",word); /*c*/
   fprintf(fpout,"@finish\n"); /*c*/
   fclose(fpout);
}
/*___writepointID()__________________________________________________________*/

/****writematrix()************************************************************/
void    writematrix() /*write current view*/
{
    int  iout;
        
    fprintf(fpout,"@%dviewid {%s}\n",iviewset,viewcom[iviewset]);
    fprintf(fpout,"@%dzoom %.2f \n",iviewset,zoom);
    iout = izclipold[0];/*970915*/
    fprintf(fpout,"@%dzslab %d\n",iviewset,iout);
    iout = iztranold[0];/*970915*/
    fprintf(fpout,"@%dztran %d\n",iviewset,iout); /*970909*/
                           
    fprintf(fpout,"@%dcenter %.3f %.3f %.3f\n"
                          ,iviewset,fxcenternew,fycenternew,fzcenternew);
    fprintf(fpout,"@%dmatrix\n",iviewset);
    fprintf(fpout,"%8.5f ",a11);
    fprintf(fpout,"%8.5f ",-a12);      /*  1  2  3            1   0   0   */
    fprintf(fpout,"%8.5f ",a13);       /*  7  8  9            0   0   1   */
    fprintf(fpout,"%8.5f ",a21);       /*  4  5  6       X    0  -1   0   */
    fprintf(fpout,"%8.5f ",-a22);
    fprintf(fpout,"%8.5f ",a23);       /* screen handedness correction: */
    fprintf(fpout,"%8.5f ",a31);       /* back correct so written matrix*/
    fprintf(fpout,"%8.5f ",-a32);      /* is correct for input to this, */
    fprintf(fpout,"%8.5f\n",a33);      /* or any program                */
    fclose(fpout);
}
/*___writematrix()___________________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****writefocus()*************************************************************/
void    writefocus()
{
            recondition(focusxyzstr);
            fprintf(fpout,"%s\n",focusxyzstr); /*c*/
            condition(focusxyzstr);
            fclose(fpout);
}
/*___writefocus()____________________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****writerotated()***********************************************************/
void      writerotated()
{/*this only works if the rotated groups/sections are still active*/
   if(beginselectionpointptr != NULL)
   {/*expect selection from begin and end selection*/ 
      Lbeginselectionout = 1; /*flag to write @beginselect*/
   }
   Lnewstuffactive = 0;
   if(Lkinformat)
   {   
       fprintf(fpout,"@text rotated stuff\n"
                     "@kinemage 1\n"
                     "@caption MAGE rotated and outputted\n");
   }
   thisgrupptr = firstgrupptr;
   while(thisgrupptr != NULL)
   {/*loop-over-groups*/
      if(thisgrupptr->bondrot != 0) /*inc thisgrupptr->bondrot==DOCKSET */
      {/*rotated-group*/
        if(Lkinformat)
        {/*Lkinformat*/
            fprintf(fpout,"@group {%s}\n",thisgrupptr->name);
            if(thisgrupptr->pdbfilestr[0] != '\0')
            {
               fprintf(fpout,"@grouppdbfile {%s}\n",thisgrupptr->pdbfilestr);
            }
            if(  (  thisgrupptr->pointx[0] >  (float)1.0001 
                  ||thisgrupptr->pointx[0] <  (float)0.9999)
               ||(  thisgrupptr->pointx[1] >  (float)0.0001 
                  ||thisgrupptr->pointx[1] < -(float)0.0001)
               ||(  thisgrupptr->pointx[2] >  (float)0.0001 
                  ||thisgrupptr->pointx[2] < -(float)0.0001)
                  
               ||(  thisgrupptr->pointy[0] >  (float)0.0001 
                  ||thisgrupptr->pointy[0] < -(float)0.0001)
               ||(  thisgrupptr->pointy[1] >  (float)1.0001 
                  ||thisgrupptr->pointy[1] <  (float)0.9999)
               ||(  thisgrupptr->pointy[2] >  (float)0.0001 
                  ||thisgrupptr->pointy[2] < -(float)0.0001)
                  
               ||(  thisgrupptr->pointz[0] >  (float)0.0001 
                  ||thisgrupptr->pointz[0] < -(float)0.0001)
               ||(  thisgrupptr->pointz[1] >  (float)0.0001 
                  ||thisgrupptr->pointz[1] < -(float)0.0001)
               ||(  thisgrupptr->pointz[2] >  (float)1.0001 
                  ||thisgrupptr->pointz[2] <  (float)0.9999)

               ||(  thisgrupptr->position[0] >  (float)0.0001 
                  ||thisgrupptr->position[0] < -(float)0.0001)
               ||(  thisgrupptr->position[1] >  (float)0.0001 
                  ||thisgrupptr->position[1] < -(float)0.0001)
               ||(  thisgrupptr->position[2] >  (float)0.0001 
                  ||thisgrupptr->position[2] < -(float)0.0001) )
            {/*initial values: 1,0,0  0,1,0  0,0,1  0,0,0 */
               fprintf(fpout,"@gnomon\n"
                  " %.3f %.3f %.3f\n"
                  " %.3f %.3f %.3f\n"
                  " %.3f %.3f %.3f\n"
                  " %.3f %.3f %.3f\n"
                  ,thisgrupptr->pointx[0]
                  ,thisgrupptr->pointx[1]
                  ,thisgrupptr->pointx[2]
                  ,thisgrupptr->pointy[0]
                  ,thisgrupptr->pointy[1]
                  ,thisgrupptr->pointy[2]
                  ,thisgrupptr->pointz[0]
                  ,thisgrupptr->pointz[1]
                  ,thisgrupptr->pointz[2]
                  ,thisgrupptr->position[0]
                  ,thisgrupptr->position[1]
                  ,thisgrupptr->position[2]
                  );
            }
        }/*Lkinformat*/
        thissgrpptr = thisgrupptr->firstsgrpptr;
        while(thissgrpptr != NULL)
        {/*loop-over-subgroups*/
          if(thissgrpptr->bondrot != 0 || thisgrupptr->bondrot==DOCKSET)
          {/*rotated-subgroup*/
            if(Lkinformat)
            {
                fprintf(fpout,"@subgroup {%s}\n",thissgrpptr->name);
            }
            thislistptr = thissgrpptr->firstlistptr;
            while(thislistptr != NULL)
            {/*loop-over-lists*/              
              if(thislistptr->bondrot != 0 || thisgrupptr->bondrot==DOCKSET)  
              {/*rotated-list*/ /*Sheep from Goats criteria*/

                  writeindividuallist(); /*MAGEOUT.c*/
                
              }/*rotated-list*/
              if(thislistptr == thissgrpptr->lastlistptr) thislistptr = NULL;
              else thislistptr = thislistptr->nextptr;
            }/*loop-over-lists*/              
          }/*rotated-subgroup*/
          if(thissgrpptr == thisgrupptr->lastsgrpptr) thissgrpptr = NULL;
          else thissgrpptr = thissgrpptr->nextptr;
        }/*loop-over-subgroups*/
      }/*rotated-group*/
      thisgrupptr = thisgrupptr->nextptr;
   }/*loop-over-groups*/
   fprintf(fpout,"\n");
   fclose(fpout);
}
/*___writerotated()__________________________________________________________*/
/*name[n],&ncnt[n],atom[n],res[n],sub[n],&num[n],rins[n],&x[n],&y[n],&z[n]*/
/*format(a6,i5,1x,a5,a3,1x,a1,i4,a1,3x,3&8.3)*/
/*  these next lines are 84 char long, they contain 80 char templates */
/*0123456789_123456789_123456789_123456789_123456789_123456789_123456789_123456789*/
/*123456789_123456789_123456789_123456789_123456789_123456789_123456789_123456789_*/
/*atom      1  n   arg a   1      26.465  27.452  -2.490  1.00 25.18      4pti  89*/
/*atom      2  ca  arg a   1      25.497  26.862  -1.573  1.00 17.63      4pti  90*/
/*  --name*6 record designator: atom or hetatom recognized  */
/*  --ncnt:i5 atom number: moved blindly to output file  */
/*  --atom*5 includes atomname*4 and alt-conformation-indicator*1,  */ 
/*  --res*3 residue name  */
/*  --sub*1 chain ID: subunit designator  */
/*  --num:i4 residue number  */
/*  --rins*1 inserted residue indicator  */
/*  --x,y,z coord of the atom  */

/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****writedrawnew()**********************************************************/
int        writedrawnew()
{
   int     ireturn;
   char    dname[26],hold[256],colorstr[32],buttonstr[32],masterstr[256];
   int     hasvectorlist,hasdotlist,haslabellist,hasarrowlist,haswierdlist;
   unsigned long mask;
   char    hiliteness[26],staticness[26],onoffstr[16]; 
    
   /*in any case, this attempt to write a file with the drawnew */
   /*stuff relieves MAGE of worrying about saving drawnew stuff*/
   Ldrawactive = 0;  /*worry flag*/
   hasvectorlist = 0;
   hasdotlist    = 0;
   haslabellist  = 0;
   hasarrowlist  = 0;
   haswierdlist  = 0;
   /*scan to see what type of lists are present */
   thispointptr = drawnewlistptr->firstpointptr;
   while(thispointptr != NULL)
   {/*scan all points in drawnew list*/   
     if( !((thispointptr->type) & PRUNED) ) /*survived pruning*/
     {/*survived pruning*/
        if(       (  (thispointptr->type) & VECTOR  ) 
                &&(  (thispointptr->type) & VARIANT1) == 0 
                &&(  (thispointptr->type) & VARIANT2) == 0 
                &&(  (thispointptr->type) & VARIANT3) == 0 )
            /*plain vector*/
            hasvectorlist = 1;
       else if(   (  (thispointptr->type) & DOT     ) ) /*dot*/
            hasdotlist = 1;  
       else if(   (  (thispointptr->type) & LABEL   ) ) /*label*/
            haslabellist = 1;
       else if(   (  (thispointptr->type) & ARROW   ) ) /*arrow*/
            hasarrowlist = 1;
       else if(   (  (thispointptr->type) & STORED  ) )
            haswierdlist = 1;
       else haswierdlist = 1;
     }/*survived pruning*/
     /*NOTE: ARROW == (VECTOR | VARIANT3) see MAGEFLAG.h*/
     if(thispointptr == drawnewlistptr->lastpointptr)  
           thispointptr = NULL;
     else thispointptr = thispointptr->nextptr;

   }/*scan all points in drawnew list*/
          
   if(haswierdlist)
   {
       sprintf(alertstr,"something besides vectors, labels, dots"
                        " in draw new stuff!");
       dosinglealert(0); /*____DLOG.C*/
   }
   if(hasvectorlist || haslabellist || hasdotlist || hasarrowlist)
   {/*has vectors or labels or dots or arrows*/
       thislistptr = drawnewsgrpptr->firstlistptr; 
       /*NOTE: only one list of draw stuff*/
       interpretcolor(thislistptr->color);  
          /*color name string put into global "word[]"*/ 
       sprintf(temps," color= %s",word);
       sprintf(colorstr,"%s",temps);

       if(thislistptr->STATUS & NOBUTTON) sprintf(buttonstr," nobutton");
	        else buttonstr[0]='\0';

       masterstr[0]='\0'; /*clear str to hold place for masters*/ 

       if(thislistptr->master > 0) /*master button for this one*/
       {
           thismasterptr = firstmasterptr;
           while(thismasterptr != NULL)
           {
               mask = thismasterptr->mask;
               /*mask = 1<<(i-1);*/ /*see ajustmaster() in MAGEBBOX.c*/
               if((thislistptr->master)&mask)
               {
                  sprintf(hold,"%s master= {%s}"
                      ,masterstr,thismasterptr->name);
                  sprintf(masterstr,"%s",hold); /*combined->masterstr*/
               }
               thismasterptr = thismasterptr->nextptr;
           }
       }
       if(thislistptr->on == 0) sprintf(onoffstr," off ");
       else onoffstr[0]='\0';
       
       if(thislistptr->radius > 0.001) 
       /*only allow positive values now*/
       {
           sprintf(dname," radius= %.3f ",thislistptr->radius); 
       }
       else dname[0]='\0';

       if( (thislistptr->STATUS & STATICFLAG) == STATICFLAG)
       {
          sprintf(staticness," static");
       }
       if( (thislistptr->STATUS & SCREENFLAG) == SCREENFLAG)
       {
          sprintf(staticness," screen");
       }
       else staticness[0]='\0';
       /*Thus screen is a more rigorous form of static */
       /*but in any case, they are incompatible types */

       if( (thislistptr->STATUS & NOHILITEFLAG) == NOHILITEFLAG)
       {
          sprintf(hiliteness," nohilite");
       }
       else hiliteness[0]='\0';
       
       if(hasvectorlist) 
       {/*vector output*/
           fprintf(fpout,"@vectorlist {%s}%s%s%s%s%s%s%s\n"
             ,thislistptr->name,colorstr,buttonstr,masterstr,onoffstr
             ,dname,hiliteness,staticness); /*using the one list name is*/
           thispointptr = thislistptr->firstpointptr;
           while(thispointptr != NULL)
           {
             if( !((thispointptr->type) & PRUNED) )/*survived pruning*/
             {/*survived pruning*/
               if(  (  (thispointptr->type) & VECTOR  ) 
                  &&(  (thispointptr->type) & VARIANT1) == 0 
                  &&(  (thispointptr->type) & VARIANT2) == 0 
                  &&(  (thispointptr->type) & VARIANT3) == 0 )
               {/*write plain vector point*/
                   writeindividualpoint(0); /*iPointFlag==0*/
               }/*write plain vector point*/
             }/*survived pruning*/
             if(thispointptr == thislistptr->lastpointptr)
                   thispointptr = NULL;
             else thispointptr = thispointptr->nextptr;
           }
       }/*vector output*/

       if(haslabellist)
       {/*label output*/
           fprintf(fpout,"@labellist {labels}%s%s%s%s%s%s%s\n"
             ,colorstr,buttonstr,masterstr,onoffstr
             ,dname,hiliteness,staticness); /*invent list name*/
           thispointptr = thislistptr->firstpointptr;
           while(thispointptr != NULL)
           {
             if( !((thispointptr->type) & PRUNED) )/*survived pruning*/
             {/*survived pruning*/
               if( (thispointptr->type) & LABEL ) /*label*/
               {/*write label point*/
                  writeindividualpoint(0); /*iPointFlag==0*/
               }/*write label point*/
             }/*survived pruning*/
             if(thispointptr == thislistptr->lastpointptr)
                   thispointptr = NULL;
             else thispointptr = thispointptr->nextptr;
           }
       }/*label output*/
       if(hasdotlist)
       {/*dot output*/
           fprintf(fpout,"@dotlist {dots}%s%s%s%s%s%s%s\n"
             ,colorstr,buttonstr,masterstr,onoffstr
             ,dname,hiliteness,staticness); /*invent list name*/
           thispointptr = thislistptr->firstpointptr;
           while(thispointptr != NULL)
           {
             if( !((thispointptr->type) & PRUNED) )/*survived pruning*/
             {/*survived pruning*/
               if( (thispointptr->type) & DOT ) /*dot*/
               {/*write dot point*/
                  writeindividualpoint(0); /*iPointFlag==0*/
               }/*write dot point*/
             }/*survived pruning*/
             if(thispointptr == thislistptr->lastpointptr)
                   thispointptr = NULL;
             else thispointptr = thispointptr->nextptr;
           }
       }/*dot output*/
       if(hasarrowlist)
       {/*arrow output*/
         sprintf(dname," radius= %.3f angle= %.3f ",distarrow,anglearrow); 
         /*globals: length of tine, angle of tine,*/
         /*implicit: dihedralarrow==90: 4 tines*/
           fprintf(fpout,"@arrowlist {arrows}%s%s%s%s%s%s%s\n"
             ,colorstr,buttonstr,masterstr,onoffstr
             ,dname,hiliteness,staticness); /*invent list name*/
           thispointptr = thislistptr->firstpointptr;
           while(thispointptr != NULL)
           {
             if( !((thispointptr->type) & PRUNED) )/*survived pruning*/
             {/*survived pruning*/
               if( (thispointptr->type) & ARROW ) /*arrow*/
               {/*write dot point*/
                  writeindividualpoint(0); /*iPointFlag==0*/
               }/*write dot point*/
             }/*survived pruning*/
             if(thispointptr == thislistptr->lastpointptr)
                   thispointptr = NULL;
             else thispointptr = thispointptr->nextptr;
           }
       }/*arrow output*/
       fprintf(fpout,"\n");
       ireturn = 1;
   }/*has vectors or labels or dots or arrows*/
   else
   {
        ireturn = 0;
   }
   /*fclose(fpout);*/ /*Don't close here, writedrawnew can be part of output*/
   return(ireturn);
}
/*___writedrawnew()_________________________________________________________*/

/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****writepruned()***********************************************************/
int    writepruned()    /*960316 viewout stuff*/
{/*output whole (modified) kinemage and all other kins in its file*/

   int       ireturn,i,j,isurvived;
   char      aname[26],bname[26],cname[26],extraname[26];
   char      hold[256];
   unsigned long mask;
   float     mx[10];    
   int Lfirsttablegroup = 1; /*until encounter a first table group*/


   Lpruneactive = 0; /* worry flags*/
   Ldrawactive = 0;
   Lnewviewactive = 0;
   Lnewstuffactive = 0;

   if(beginselectionpointptr != NULL)
   {/*expect selection from begin and end selection*/ 
      Lbeginselectionout = 1; /*flag to write @beginselect*/
   }

#ifdef SINGLEKINOUT
//   if(   thiskinenum == 0 || thiskinenum == 1 
//      || Lkinemagecount==1 && thiskinenum==kinemagenum)
//   {/*first or only kinemage in this file, write text */
//       writetext();  /*MACOUT.C*/
//   }
#endif

   fprintf(fpout,"@kinemage %d\n",thiskinenum);
   writecaption();  /*MACOUT.C  MPCOUT.C*/
   /*fprintf(fpout,"\n");*/ /*ensure next keyword on a new line*/  
   /*990124 remove, writetext and writecaption should ensure final EOL char*/
   
   /*if(Lspanofview) fprintf(fpout,"@xxxx %.2f\n",spanofview);*/ /*980920*/
   
   if(LLensflagset) fprintf(fpout,"@lens %.2f\n",lensFactor); /*970917*/
   if(Listcolordominant) fprintf(fpout,"@listcolordominant\n"); /*970917*/
   if(update_command_line[0] != '\0') fprintf(fpout,"@command {%s}\n",update_command_line);
   else if(input_command_line[0] != '\0') fprintf(fpout,"@command {%s}\n",input_command_line);
   /*970917 then 990404*/
           
   if(Lonewidth) fprintf(fpout,"@onewidth\n");
   if(Lthin) fprintf(fpout,"@thinline\n");
   if(Lperspec)  fprintf(fpout,"@perspective\n");
   if(Lwhitebkg) fprintf(fpout,"@whitebackground\n"); /*990125*/
   
   for(i=1; i< MAXRESETS ;i++)
   {
      if(Lview[i])
      {/*Lview*/
               /*---------------------------------*/
               if(viewcom[i][0] != '\0') /*not null string*/
               {
                   if(i==1) fprintf(fpout,"@viewid {%s}\n",viewcom[i]);
                  else if(i<10) fprintf(fpout,"@%1dviewid {%s}\n",i,viewcom[i]);
                   else fprintf(fpout,"@%2dviewid {%s}\n",i,viewcom[i]);

               }
               if(Lzoomer[i]!=0)/*980929*/
               {
                 if(Lzoomer[i]>0)/*980929*/
                 {
                   if(i==1) fprintf(fpout,"@zoom %.2f\n",zoomold[i]);
                   else if(i<10) fprintf(fpout,"@%1dzoom %.2f\n",i,zoomold[i]);
                   else fprintf(fpout,"@%2dzoom %.2f\n",i,zoomold[i]);
                 }
                 else
                 {/* span of screen from which to calc zoom*/
                   if(i==1) fprintf(fpout,"@span %.2f\n",zoomold[i]);
                   else if(i<10) fprintf(fpout,"@%1dspan %.2f\n",i,zoomold[i]);
                   else fprintf(fpout,"@%2dspan %.2f\n",i,zoomold[i]);
                 }/*980929*/
               }
               /*---------------------------------*/
               if(Lzcliper[i])
               {
                   if(i==1) fprintf(fpout,"@zslab %d\n",izclipold[i]);
                   else if(i<10) fprintf(fpout,"@%1dzslab %d\n"
                                             ,i,izclipold[i]);
                   else fprintf(fpout,"@%2dzslab %d\n",i,izclipold[i]);
               }
               /*----------------------------------*/
                if(Lztraner[i])  /*970909*/
               {
                   if(i==1) fprintf(fpout,"@ztran %d\n",iztranold[i]);
                   else if(i<10) fprintf(fpout,"@%1dztran %d\n"
                                             ,i,iztranold[i]);
                   else fprintf(fpout,"@%2dztran %d\n",i,iztranold[i]);
              }
               /*----------------------------------*/
               if(Lcenter[i])
               {
                   if(i==1) fprintf(fpout,"@center %.3f %.3f %.3f\n"
                              ,fxcenterold[i],fycenterold[i],fzcenterold[i]);
                   else if(i<10) fprintf(fpout,"@%1dcenter %.3f %.3f %.3f\n"
                              ,i,fxcenterold[i],fycenterold[i],fzcenterold[i]);
                   else fprintf(fpout,"@%2dcenter %.3f %.3f %.3f\n"
                              ,i,fxcenterold[i],fycenterold[i],fzcenterold[i]);
               }
               /*----------------------------------*/
               if(Lreset[i])
               {
                   j = i;
                   mx[1] =  ma[j][1];
                   mx[2] = -ma[j][2];    /*  1  2  3            1   0   0   */
                   mx[3] =  ma[j][3];    /*  4  5  6       X    0  -1   0   */
                   mx[4] =  ma[j][4];    /*  7  8  9            0   0   1   */
                   mx[5] = -ma[j][5];
                   mx[6] =  ma[j][6];    /* Mac handedness correction :   */
                   mx[7] =  ma[j][7];    /* back correct so written matrix*/
                   mx[8] = -ma[j][8];    /* is correct for input to this, */
                   mx[9] =  ma[j][9];    /* or any program                */

                   if(i==1) fprintf(fpout,"@matrix\n");
                   else if(i<10)fprintf(fpout,"@%1dmatrix\n",i);
                   else         fprintf(fpout,"@%2dmatrix\n",i);
                   fprintf(fpout,"%f %f %f %f %f %f %f %f %f\n",
                      mx[1],mx[2],mx[3],mx[4],mx[5],mx[6],mx[7],mx[8],mx[9]);
               }
               /*---------------------------------*/
      }/*Lview*/
   }
   if(firstmasterptr != NULL) /*there are masters*/ /*970513*/
   {
      thismasterptr = firstmasterptr;
      while(thismasterptr != NULL)
      {
         fprintf(fpout,"@master {%s}\n",thismasterptr->name);          
         thismasterptr = thismasterptr->nextptr;
      }
      /*scan through again looking for pointmasters*/  /*991210*/
      thismasterptr = firstmasterptr;
      while(thismasterptr != NULL)
      {
         if(thismasterptr->masterchar != '\0')
         {
            fprintf(fpout,"@pointmaster '%c' {%s}\n"
               ,thismasterptr->masterchar,thismasterptr->name);
         }          
         thismasterptr = thismasterptr->nextptr;
      }

   }
   if(firstcolorsetptr != NULL) /*there are colorsets*/ /*991104*/
   {
      thiscolorsetptr = firstcolorsetptr;
      while(thiscolorsetptr != NULL)
      {
         interpretcolor(thiscolorsetptr->color); /*returns in word*/
         fprintf(fpout,"@colorset {%s} %s\n",thiscolorsetptr->name,word);          
         thiscolorsetptr = thiscolorsetptr->nextptr;
      }
   }

     thisgrupptr = firstgrupptr;
     while(thisgrupptr != NULL)
     {/*BIG loop-over-groups*/
      isurvived = 0; /*set to NOT survive, must be persuaded to live*/

      /*check for survival of self and at least one child*/
      if(thisgrupptr->on > -50) /*survived pickshow deletion*/
      {/*for this group: group survived pickshow*/
        thissgrpptr = thisgrupptr->firstsgrpptr;
        while(thissgrpptr != NULL)
        {/*for this group: test for subgroup survival*/
          thislistptr = thissgrpptr->firstlistptr;
          while(thislistptr != NULL)
          {/*for this group: test for list survival*/
              if(thislistptr->on > -50) /*survived pickshow deletion*/
              {/*for this group: list survived pickshow*/
                   thispointptr = thislistptr->firstpointptr;
                   while(thispointptr != NULL)
                   {/*for this group: test for point survival*/
                      /*since a surviving point is the ultimate and only true*/
                      /*survival test, check for bond rotation lists here*/
                      /*some of them have no points but all must be kept*/
                      if(  !((thispointptr->type) & PRUNED) /*survived pruning*/
                         || (thislistptr->bondrot != 0)    )/*? bondrot list*/
                      {/*for this group: point survived pruning*/
                          isurvived = 1;
                      }/*for this group: point survived pruning*/
                      if(thispointptr == thislistptr->lastpointptr)
                           thispointptr = NULL;
                      else thispointptr = thispointptr->nextptr;
                   }/*for this group: test for point survival*/
              }/*for this group: list survived pickshow*/
              if(thislistptr == thissgrpptr->lastlistptr) thislistptr = NULL;
              else thislistptr = thislistptr->nextptr;
          }/*for this group: test for list survival*/
        /*if(thissgrpptr = thisgrupptr->lastsgrpptr) thissgrpptr = NULL;*/ /*980630*/
          if(thissgrpptr == thisgrupptr->lastsgrpptr) thissgrpptr = NULL;/*980630*/
          else thissgrpptr = thissgrpptr->nextptr;        
        }/*for this group: test for subgroup survival*/

       /*for this group: check for groups not to be included in a kinemage*/
       if(thisgrupptr==markergrupptr ||thisgrupptr==measuregrupptr)isurvived =0;
       if(Lvisibleout && thisgrupptr->on == 0) isurvived = 0; /*off: don't output*/
      }/*for this group: group survived pickshow*/
      
      
      
      
      if(isurvived)
      {/*BIG this group survived*/

       {/*this group: output first line*/

        /*actually, before the first line of the first table group*/
        if( (thisgrupptr->type & TABLEFLAG) == TABLEFLAG)
        {/*table group*/
           if(Lfirsttablegroup)
           {
              fprintf(fpout,"@tablewrap %d\n",tablecolmod);   
              fprintf(fpout,"@tablecolscale %.2f\n",tablecolscale);   
              fprintf(fpout,"@tablefontsize %d\n",tablefontsize);        
              fprintf(fpout,"@tablemarkradius %.2f\n",tablemarkradius); 
              fprintf(fpout,"@tablefanradius %.2f\n",tablefanradius);
              fprintf(fpout,"@tablefancore %.2f\n",tablefancore);       
              Lfirsttablegroup = 0;
              if( (thisgrupptr->type & TABLECOLHEAD) == TABLECOLHEAD)
              {
                 sprintf(extraname," table header");
              }
              else
              {
                 sprintf(extraname," table");
              }
           }
           else
           {
              sprintf(extraname," table");
           }
        }/*table group*/
        else extraname[0] = '\0';
        
        /*dominance and button stuff for a group*/
        temps[0]='\0';
        if(thisgrupptr->STATUS & RECESSIVEON)
        {/*has to override dominant and nobutton anyway*/
           sprintf(temps," recessiveon");
        }
        else if(thisgrupptr->STATUS & NOBUTTON)
        {
           if(thisgrupptr->STATUS & DOMINANT)
           {/*both*/
               sprintf(temps," nobutton dominant");
           }
           else
           {/*just nobutton*/
              sprintf(temps," nobutton");
           }
        }
        else if(thisgrupptr->STATUS & DOMINANT)
        {/*just dominant*/
           sprintf(temps," dominant");
        }
        
        if(thisgrupptr->instanceptr != NULL)/*this instances an earlier group*/
        {/*this group: instances an earlier group*/
             for(j=0;j<(MAXNAMECHAR);j++)   
                 cname[j]=(thisgrupptr->instanceptr)->name[j+1];
             cname[(MAXNAMECHAR)]='\0';/*force C string end*/ 
             sprintf(bname," instance= {%s}",cname);
        }/*this group: instances an earlier group*/
        else bname[0]='\0';
      /*else sprintf(bname," ");*/

      /*sprintf(numstr," ");*/ /*clear numstr to hold place for masters*/
        numstr[0]='\0'; /*clear numstr to hold place for masters*/
        if(thisgrupptr->master > 0) /*master button for this one*/
        {/*this group: has a master button*/
            thismasterptr = firstmasterptr;
            while(thismasterptr != NULL)
            {
                mask = thismasterptr->mask;
                /*mask = 1<<(i-1);*/ /*see ajustmaster() in MAGEBBOX.c*/
                if((thisgrupptr->master)&mask)
                {
                    sprintf(hold,"%s master= {%s}",numstr,thismasterptr->name);
                    sprintf(numstr,"%s",hold); /* combined -> numstr*/
                }
                thismasterptr = thismasterptr->nextptr;
            }
        }/*this group: has a master button*/

        if     (thisgrupptr->animate == 2) sprintf(word," 2animate");
        else if(thisgrupptr->animate == 1) sprintf(word," animate");
        else if(thisgrupptr->on == 0) sprintf(word," off");
        else word[0]='\0';
      /*else                          sprintf(word," ");*/
            /*animate group can't be arbitrarily off */
        
        if(thisgrupptr->moview > 0) 
            sprintf(cname," moview= %d",thisgrupptr->moview);
        else cname[0]='\0';
      /*else  sprintf(cname," ");*/

        /*animated groups are on/off controlled by MAGE input */
        /*groupnames are given a leading space on input*/
        /*shift groupname left one space*/
        /*this also removes asterisk at beginning of animated group name*/
        for(j=0;j<(MAXNAMECHAR);j++)   aname[j]=thisgrupptr->name[j+1];
        aname[(MAXNAMECHAR)]='\0';/*force C string end*/    

        
        fprintf(fpout,"@group {%s}%s%s%s%s%s%s\n"
                  ,aname,extraname,temps,numstr,bname,word,cname); /*990407 was bname,numstr*/
                     /*MAGE input problem if instance (bname) before master (numstr)*/

            /*always check these, docking can be eposodic during a run*/
            if(thisgrupptr->pdbfilestr[0] != '\0')
            {
               fprintf(fpout,"@grouppdbfile {%s}\n",thisgrupptr->pdbfilestr);
            }
            if(  (  thisgrupptr->pointx[0] >  (float)1.0001 
                  ||thisgrupptr->pointx[0] <  (float)0.9999)
               ||(  thisgrupptr->pointx[1] >  (float)0.0001 
                  ||thisgrupptr->pointx[1] < -(float)0.0001)
               ||(  thisgrupptr->pointx[2] >  (float)0.0001 
                  ||thisgrupptr->pointx[2] < -(float)0.0001)
                  
               ||(  thisgrupptr->pointy[0] >  (float)0.0001 
                  ||thisgrupptr->pointy[0] < -(float)0.0001)
               ||(  thisgrupptr->pointy[1] >  (float)1.0001 
                  ||thisgrupptr->pointy[1] <  (float)0.9999)
               ||(  thisgrupptr->pointy[2] >  (float)0.0001 
                  ||thisgrupptr->pointy[2] < -(float)0.0001)
                  
               ||(  thisgrupptr->pointz[0] >  (float)0.0001 
                  ||thisgrupptr->pointz[0] < -(float)0.0001)
               ||(  thisgrupptr->pointz[1] >  (float)0.0001 
                  ||thisgrupptr->pointz[1] < -(float)0.0001)
               ||(  thisgrupptr->pointz[2] >  (float)1.0001 
                  ||thisgrupptr->pointz[2] <  (float)0.9999)

               ||(  thisgrupptr->position[0]  >  (float)0.0001 
                  ||thisgrupptr->position[0]  < -(float)0.0001)
               ||(  thisgrupptr->position[1] >  (float)0.0001 
                  ||thisgrupptr->position[1] < -(float)0.0001)
               ||(  thisgrupptr->position[2] >  (float)0.0001 
                  ||thisgrupptr->position[2] < -(float)0.0001) )
            {
               fprintf(fpout,"@gnomon\n"
                  " %.3f %.3f %.3f\n"
                  " %.3f %.3f %.3f\n"
                  " %.3f %.3f %.3f\n"
                  " %.3f %.3f %.3f\n"
                  ,thisgrupptr->pointx[0]
                  ,thisgrupptr->pointx[1]
                  ,thisgrupptr->pointx[2]
                  ,thisgrupptr->pointy[0]
                  ,thisgrupptr->pointy[1]
                  ,thisgrupptr->pointy[2]
                  ,thisgrupptr->pointz[0]
                  ,thisgrupptr->pointz[1]
                  ,thisgrupptr->pointz[2]
                  ,thisgrupptr->position[0]
                  ,thisgrupptr->position[1]
                  ,thisgrupptr->position[2]
                  );
            }



       }/*this group: output first line*/
        
        
        if(thisgrupptr->instanceptr == NULL) 
        {/*BIG this group: not instancing earlier group*/
         /*so can have children of its own*/
         thissgrpptr = thisgrupptr->firstsgrpptr;
         while(thissgrpptr != NULL)
         {/*BIG loop-over-subgroups*/
          isurvived = 0; /*set to NOT survive, must be persuaded to live*/


          /*this subgroup: check for self and at least one child survival*/
          if(thissgrpptr->on > -50) /*survived pickshow deletion*/
          {/*this subgroup: survived pickshow deletion*/
           thislistptr = thissgrpptr->firstlistptr;
           while(thislistptr != NULL)
           {/*for this subgroup: test for list survival*/
              if(thislistptr->on > -50) /*survived pickshow deletion*/
              {/*for this subgroup: list survived pickshow*/
                   thispointptr = thislistptr->firstpointptr;
                   while(thispointptr != NULL)
                   {/*for this subgroup: test for point survival*/
                       /*since a surviving point is the ultimate and only true*/
                      /*survival test, check for bond rotation lists here*/
                      /*some of them have no points but all must be kept*/
                      if(  !((thispointptr->type) & PRUNED) /*survived pruning*/
                         || (thislistptr->bondrot != 0)    )/*? bondrot list*/
                       {/*for this subgroup: point survived pruning*/
                           isurvived = 1;
                       }/*for this subgroup: point survived pruning*/  
                       if(thispointptr == thislistptr->lastpointptr)
                           thispointptr = NULL;
                       else thispointptr = thispointptr->nextptr;
                   }/*for this subgroup: test for point survival*/
              }/*for this subgroup: list survived pickshow*/
              if(thislistptr == thissgrpptr->lastlistptr) thislistptr = NULL;
              else thislistptr = thislistptr->nextptr;
           }/*for this subgroup: test for list survival*/
           /*for this subgroup: check for subgroups not to be in a kinemage*/
           if(thisgrupptr == drawgrupptr)
              if(thissgrpptr == drawmarkersgrpptr) isurvived=0;
                  /*this subgroup is just the little draw markers*/
           if(Lvisibleout && thissgrpptr->on == 0)isurvived=0;/*off: don't output*/
          }/*this subgroup: survived pickshow deletion*/
           
           
           
          if(isurvived)
          {/*BIG this subgroup survived*/


          {/*this subgroup: output first line*/
            if((thissgrpptr->STATUS & NEVERSHOW) == 0) 
            {/*explicitly name subgroup in kinemage display list*/
              
              /*dominance and button stuff for a subgroup*/
              temps[0]='\0';
              if(thissgrpptr->STATUS & RECESSIVEON)
              {/*has to override dominant and nobutton anyway*/
                 sprintf(temps," recessiveon");
              }
              else if(thissgrpptr->STATUS & NOBUTTON)
              {
                 if(thissgrpptr->STATUS & DOMINANT)
                 {/*both*/
                     sprintf(temps," nobutton dominant");
                 }
                 else
                 {/*just nobutton*/
                    sprintf(temps," nobutton");

                 }
              }
              else if(thissgrpptr->STATUS & DOMINANT)
              {/*just dominant*/
                 sprintf(temps," dominant");
              }
              
              if(thissgrpptr->instanceptr!= NULL) /*this instances earlier set*/
              {
                 sprintf(bname," instance= {%s}"
                     ,(thissgrpptr->instanceptr)->name);
              }
              else bname[0]='\0';
            /*else sprintf(bname," ");*/

            /*sprintf(numstr," ");*/ /*clear numstr to hold place for masters*/
              numstr[0]='\0'; /*clear numstr to hold place for masters*/
              if(thissgrpptr->master > 0) /*master button for this one*/
              {/*this subgroup has a master button*/
                  thismasterptr = firstmasterptr;
                  while(thismasterptr != NULL)
                  {
                      mask= thismasterptr->mask;
                      /*mask = 1<<(i-1);*/ /*see ajustmaster() in MAGEBBOX.c*/
                      if((thissgrpptr->master)&mask)
                      {
                         sprintf(hold,"%s master= {%s}"
                             ,numstr,thismasterptr->name);
                         sprintf(numstr,"%s",hold); /* combined -> numstr*/
                      }
                      thismasterptr = thismasterptr->nextptr;
                  }
              }/*this subgroup has a master button*/
              
            /*if(thissgrpptr->on > 0) sprintf(KineName," ");*/
              if(thissgrpptr->on > 0) KineName[0]='\0';
              else                    sprintf(KineName," off");

              fprintf(fpout,"@subgroup {%s}%s%s%s%s\n"
                      ,thissgrpptr->name,temps,numstr,bname,KineName); /*990407 was bname,numstr*/

            }/*explicitly name subgroup in kinemage display list*/
            
          }/*this subgroup: output first line*/
            
            
          if(thissgrpptr->instanceptr == NULL)            
          {/*BIG this subgroup: not instancing earlier subgroup*/
            /*so can have children of its own*/

            if(thisgrupptr != drawgrupptr)
            {/*MOD this subgroup: not in the draw-new group*/
             thislistptr = thissgrpptr->firstlistptr;
             while(thislistptr != NULL)
             {/*MOD for this subgroup: loop-over-lists*/
              isurvived = 0;
              
                         
              /*check for survival of self and at least one child*/
              if(thislistptr->on > -50) 
              {/*for this list: survived pickshow deletion*/
                   if(thislistptr->firstpointptr==NULL
                      && thislistptr->bondrot == -1)
                   {/*dummy list to end bondrot scope*/
                       isurvived = 1;
                   }/*dummy list to end bondrot scope*/

                   thispointptr = thislistptr->firstpointptr;
                   while(thispointptr != NULL)
                   {/*for this list: check point survival*/
                       /*since a surviving point is the ultimate and only true*/
                      /*survival test, check for bond rotation lists here*/
                      /*some of them have no points but all must be kept*/
                      if(  !((thispointptr->type) & PRUNED) /*survived pruning*/
                         || (thislistptr->bondrot != 0)    )/*? bondrot list*/
                      {/*for this list: a point survived pruning*/ 
                          isurvived = 1;
                      }/*for this list: a point survived pruning*/   
                      if(thispointptr == thislistptr->lastpointptr)
                         thispointptr = NULL;
                      else thispointptr = thispointptr->nextptr;
                   }/*for this list: check point survival*/
                   /*for this list: check if not to be in a kinemage*/
                   if(Lvisibleout && thislistptr->on == 0) isurvived = 0; 
              }/*for this list: survived pickshow deletion*/

              if(isurvived)
              {/*MOD this list survived*/
                  Lkinformat = 1; /*kinemage rather than PDB format*/
                  writeindividuallist(); /*MAGEOUT.c*/
              }/*MOD this list survived*/

              if(thislistptr == thissgrpptr->lastlistptr) thislistptr = NULL;
              else thislistptr = thislistptr->nextptr;
             }/*MOD for this subgroup: loop-over-lists*/

            }/*MOD this subgroup: not in the draw-new group*/
            else
            {/*MOD this subgroup: in draw-new group, process list differently*/
              if( writedrawnew() ==1)
              {
                ;
              }
              else
              {
                sprintf(alertstr,"failed writing draw_new group to modified kinemage\n");
                dosinglealert(0);
              }
            }/*MOD this subgroup: in draw-new group, process list differently*/
            
           }/*BIG this subgroup: not instancing earlier subgroup*/
          }/*BIG this subgroup survived*/
          if(thissgrpptr == thisgrupptr->lastsgrpptr) thissgrpptr = NULL;
          else thissgrpptr = thissgrpptr->nextptr;
         }/*BIG loop-over-subgroups*/
        }/*BIG this group: not instancing earlier group*/
      }/*BIG this group survived*/
      thisgrupptr = thisgrupptr->nextptr;
    }/*BIG loop-over-groups*/
    ireturn = 1;
    Lpruneactive = 0;/*so know that modified kinemage saved*/
    /* fprintf(fpout,"\n"); */
    /* fclose(fpout); */
    return(ireturn);
}
/*___writepruned()__________________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/

/****writeindividuallist()***************************************************/
void writeindividuallist(void)
{
  int    igoout,k;                   
  long   i11,i12,i13,i21,i22,i23,i31,i32,i33;
  int    ixset,iyset,izset;
  int    ifudgx,ifudgy,ifudgz,idelx,idely,idelz,itemp;
  int    iPointFlag; /*signels new start point for truncated polyline*/
  static  int    nscope=0,newnscope=0,nscopecount=0; 
     /*for conveying samescope%d information*/
  char      bname[26],dname[32],hiliteness[26];
  char      ename[26],fname[26],gname[26],staticness[26],detailness[26];
  char      widthamt[26]; /*000412*/
  char      lensness[12],nozclipness[12],plotness[12],scopeness[12];
  char      ptIDstr[256];
  char      hold[256];
  
  char      keyword[21]; /*MAGEINPT limits keywords to 20 char max*/ /*990124*/
  unsigned long mask;

  if(Lvisibleout) 
  {/*recalculates current view, only outputs what is in sight*/
     /* establish integer array,  8192* for reasonable percision 2**13 */
     i11=(long)(8192*a11); i12=(long)(8192*a12); i13=(long)(8192*a13);
     i21=(long)(8192*a21); i22=(long)(8192*a22); i23=(long)(8192*a23);
     i31=(long)(8192*a31); i32=(long)(8192*a32); i33=(long)(8192*a33);

     ixset = ixctr; 
     iyset = iyctr;
     izset = izctr;
  
     if(Lztran) izset = (izctr + iztran);
     iyset = iyset + iytran;
     iPointFlag = 0;
  }/*recalculates current view, only outputs what is in sight*/
  
  /*kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk*/
  if(Lkinformat)             
  {/*Lkinformat: this list: output first line*/
     
     interpretcolor(thislistptr->color);
         /* returns color in string word */
         /*but don't put out a color=  unless this instance really */
         /*had its own color= originally!*/
         /*So, rewrite string word appropriately */
     if(thislistptr->owncolor != 0)/*960528*/
     {
        if(thislistptr->colorset)
        {/*list color is determined by a named colorset*/
           thiscolorsetptr = firstcolorsetptr;
           while(thiscolorsetptr!=NULL)
           {
              if(thiscolorsetptr->mask == thislistptr->colorset)
              {/*found its colorset*/
                 /*this list defines color as name of colorset*/
                 sprintf(temps," color= {%s}",thiscolorsetptr->name);
                 sprintf(word,"%s",temps);
                 break; /*only get one color designation per list*/
              }
              thiscolorsetptr = thiscolorsetptr->nextptr;
           }
        }
        else
        {/*list color is actually set explicitly*/
           sprintf(temps," color= %s",word);
           sprintf(word,"%s",temps);
        }
     }
     else word[0]='\0';

     if( (thislistptr->STATUS & STATICFLAG) == STATICFLAG)
     {
         sprintf(staticness," static");
     }
     else if( (thislistptr->STATUS & SCREENFLAG) == SCREENFLAG)
     {
         sprintf(staticness," screen");
     }
     else staticness[0]='\0';
     /*Thus screen is a more rigorous form of static */
     /*but in any case, they are incompatible types */

     if( (thislistptr->STATUS & NOHILITEFLAG) == NOHILITEFLAG)
     {
         sprintf(hiliteness," nohilite");
     }
     else hiliteness[0]='\0';

     if( (thislistptr->type & DETAILFLAG) == DETAILFLAG)
     {
         sprintf(detailness," detail");
     }
     else detailness[0]='\0';
 
     if( (thislistptr->type & LENSFLAG) == LENSFLAG)
     {
         sprintf(lensness," lens");
     }
     else lensness[0]='\0';
     
     if( (thislistptr->type & NOZCLIPFLAG) == NOZCLIPFLAG)
     {
         sprintf(nozclipness," nozclip");
     }
     else nozclipness[0]='\0';
     
     if(thislistptr->STATUS & NOBUTTON) sprintf(temps," nobutton");
     else temps[0]='\0';
     
     if(thislistptr->instanceptr != NULL) 
     {/*this instances earlier set*/
          /*recondition(listname[ilist[nlist][7]]);*/
                               
          sprintf(bname," instance= {%s}"
                        ,thislistptr->instanceptr->name);
      }
     else bname[0]='\0';
     
     numstr[0]='\0'; /*clear numstr to hold place for masters*/
     if(thislistptr->master > 0) 
     {/*this list has a master button*/
         thismasterptr = firstmasterptr;
         while(thismasterptr != NULL)
         {
             mask = thismasterptr->mask;
             /*mask = 1<<(i-1);*/ /*see ajustmaster() in MAGEBBOX.c*/
             if((thislistptr->master)&mask)
             {
                sprintf(hold,"%s master= {%s}"
                    ,numstr,thismasterptr->name);
                sprintf(numstr,"%s",hold); /* combined -> numstr*/
             }
             thismasterptr = thismasterptr->nextptr;
         }
     }/*this list has a master button*/
     
     if(thislistptr->on > 0) KineName[0]='\0';
     else                    sprintf(KineName," off");

     /*radiuslist[nlist]  float property associated with this list*/

     /* angle    also a   float property associated with this list*/
     if(   thislistptr->radius > 0.001 
        &&(thislistptr->angle > 0.001 || thislistptr->angle < -0.001) )
     {/*only allow positive values of radius*/
         sprintf(dname," radius= %.3f angle= %.3f"
                ,thislistptr->radius,thislistptr->angle);
     }
     else if(thislistptr->radius > 0.001)
     {/*only allow positive values of radius*/
         sprintf(dname," radius= %.3f",thislistptr->radius);
     }
     else if(thislistptr->angle > 0.001 || thislistptr->angle < -0.001 )
     {
         sprintf(dname," angle= %.3f",thislistptr->angle);
     }
     else dname[0]='\0';
     
     if(thislistptr->width > 0 )
     {/*only allow positive values now*/
         sprintf(widthamt," width= %d",thislistptr->width);
     }
     else widthamt[0]='\0';
     
     /*output of the @----list first line*/
     /*if the scope of a rotation selection starts with the first point */
     /* of a vectorlist, the @beginselection should be entered before*/
     /*the vectors of the list*/
     
     if(Lbeginselectionout)
     {
         if(thislistptr->firstpointptr == beginselectionpointptr)
         {
             fprintf(fpout,"@beginselect\n");
             Lbeginselectionout = 0; /*only do this once*/
         }
     }

     /*Now set up First Line for each type of list*/     /*990124*/
     if(    (   ((thislistptr->type) & VECTOR  )
             &&!((thislistptr->type) & VARIANT1)
             &&!((thislistptr->type) & VARIANT2)
             &&!((thislistptr->STYLE) & ARROWSTYLE) )
        ||  (   ((thislistptr->type) & DOT     )
             &&!((thislistptr->type) & VARIANT1) )
       )
     {/*actual plain VECTOR list, or a plain DOT list*/ /*990124*/
       if((thislistptr->type) & VECTOR) strcpy(keyword,"@vectorlist ");
       else  strcpy(keyword,"@dotlist ");

       /* only a vectorlist or a dotlist can specify a rotation*/
       if(   (thislistptr->bondrot <= nbondrot) 
          && (thislistptr->bondrot >  0       ) )
       {/*this one does specify a rotation*/
         if( (bondrotptr[thislistptr->bondrot])->option > 0 )
         {
             if     ( (bondrotptr[thislistptr->bondrot])->option == 1 )
                sprintf(gname,"parameter"); 
             else if( (bondrotptr[thislistptr->bondrot])->option == 2 )
                sprintf(gname,"precession"); 
             else if( (bondrotptr[thislistptr->bondrot])->option == 3 )
                sprintf(gname,"selection"); 
             else if( (bondrotptr[thislistptr->bondrot])->option == 4 )
                sprintf(gname,"xrotation"); 
             else if( (bondrotptr[thislistptr->bondrot])->option == 5 )
                sprintf(gname,"yrotation"); 
             else if( (bondrotptr[thislistptr->bondrot])->option == 6 )
                sprintf(gname,"zrotation"); 
             else if( (bondrotptr[thislistptr->bondrot])->option == 7 )
                sprintf(gname,"xtranslation"); 
             else if( (bondrotptr[thislistptr->bondrot])->option == 8 )
                sprintf(gname,"ytranslation"); 
             else if( (bondrotptr[thislistptr->bondrot])->option == 9 )
                sprintf(gname,"ztranslation"); 
             else
                gname[0]='\0';
         }
         else
         {
              gname[0]='\0';
         }
         
         if     (thislistptr->bondrot == LbondrotHplot) 
              {sprintf(plotness,"hplot");}
         else if(thislistptr->bondrot == LbondrotVplot) 
              {sprintf(plotness,"vplot");}
         else {plotness[0]='\0';}

         
         if(nscope == thislistptr->bondrot)
         {/*previous bondrots use this ones scope, this one gets marked*/
             sprintf(scopeness,"samescope%d",nscopecount);
             nscopecount = 0; /*reset*/
             nscope = 0;
         }
         else scopeness[0] = '\0';
            
         if((newnscope = (bondrotptr[thislistptr->bondrot]->scopeinstance)) > 0)
         {/*refers to later bondrot for scope of rotation*/
             if(newnscope == nscope) ; /*first of a set determines nscopecount*/
             else if(nscope ==0)
             {/*set up for later bondrot to declare samescope*/
                 nscopecount = newnscope - thislistptr->bondrot + 1;
                 nscope = newnscope;
             }
             /*((nscope > 0 && newnscope != nscope)) PROBABLY AN ERROR*/
         }

         fprintf(fpout,"%s{%s}%s%s%s%s%s%s%s%s%s%s%s%s %dbondrot %.1f %s%s%s\n"
           ,keyword,thislistptr->name,word,temps,numstr,bname,KineName
           ,dname,widthamt,hiliteness,staticness,detailness,lensness,nozclipness
           ,bondrotptr[thislistptr->bondrot]->level
           ,bondrotptr[thislistptr->bondrot]->angle,gname,plotness,scopeness);
       }/*this one does specify a rotation*/
       else if(thislistptr->bondrot <  0) /*-1 for 0bondrot*/
       {
        fprintf(fpout,"%s{%s}%s%s%s%s%s%s%s%s%s%s%s%s nobutton 0bondrot 0.0\n"
           ,keyword,thislistptr->name,word,temps,numstr,bname,KineName
           ,dname,widthamt,hiliteness,staticness,detailness,lensness,nozclipness);  
       }
       else 
       {
        fprintf(fpout,"%s{%s}%s%s%s%s%s%s%s%s%s%s%s%s\n"
           ,keyword,thislistptr->name,word,temps,numstr,bname,KineName
           ,dname,widthamt,hiliteness,staticness,detailness,lensness,nozclipness);
       }
     }/*actual plain VECTOR list, or a plain DOT list*/
     else if(   ((thislistptr->type) & VECTOR  )
             && ((thislistptr->type) & VARIANT1)
             &&!((thislistptr->type) & VARIANT2)
            )
     {/*actual TRIANGLE list*/ 
        fprintf(fpout,"@trianglelist {%s}%s%s%s%s%s%s%s%s%s%s%s%s\n"
           ,thislistptr->name,word,temps,numstr,bname,KineName
           ,dname,widthamt,hiliteness,staticness,detailness,lensness,nozclipness);
     }/*actual TRIANGLE list*/ 
     else if(   ((thislistptr->type) & VECTOR  )
             && ((thislistptr->type) & VARIANT1)
             && ((thislistptr->type) & VARIANT2)
            )
     {/*actual RIBBON list*/ 
        fprintf(fpout,"@ribbonlist {%s}%s%s%s%s%s%s%s%s%s%s%s%s\n"
           ,thislistptr->name,word,temps,numstr,bname,KineName
           ,dname,widthamt,hiliteness,staticness,detailness,lensness,nozclipness);
     }/*actual RIBBON list*/ 
     else if(   ((thislistptr->type) & VECTOR  )
             && ((thislistptr->STYLE) & ARROWSTYLE)
            )
     {/*actual ARROW list*/  /*000804*/
        fprintf(fpout,"@arrowlist {%s}%s%s%s%s%s%s%s%s%s%s%s%s\n"
           ,thislistptr->name,word,temps,numstr,bname,KineName
           ,dname,widthamt,hiliteness,staticness,detailness,lensness,nozclipness);
     }/*actual ARROW list*/ 

     /*990209 de-blot*/
     else if(   ((thislistptr->type) & BALL    )
             &&!((thislistptr->type) & VARIANT1)
            )  /* balllist */
     {/*actual BALL list*/ 
       fprintf(fpout,"@balllist {%s}%s%s%s%s%s%s%s%s%s%s%s%s\n"
            ,thislistptr->name,word,temps,numstr,bname,KineName
            ,dname,widthamt,hiliteness,staticness,detailness,lensness,nozclipness);
     }/*actual BALL list*/
     else if(   ((thislistptr->type) & BALL    )
             && ((thislistptr->type) & VARIANT1)
            )  /* spherelist */
     {/*actual SPHERE list*/
       fprintf(fpout,"@spherelist {%s}%s%s%s%s%s%s%s%s%s%s%s%s\n"
            ,thislistptr->name,word,temps,numstr,bname,KineName
            ,dname,widthamt,hiliteness,staticness,detailness,lensness,nozclipness);
     }/*actual SPHERE list*/
     else if(   ((thislistptr->type) & LABEL   )
            )  /* labellist  if radius given, radius output*/
     {/*actual LABEL list*/
       fprintf(fpout,"@labellist {%s}%s%s%s%s%s%s%s%s%s%s%s%s\n"
            ,thislistptr->name,word,temps,numstr,bname,KineName
            ,dname,widthamt,hiliteness,staticness,detailness,lensness,nozclipness);
     }/*actual LABEL list*/
     else if(   ((thislistptr->type) & MARKTYPE   )
            )  /* marklist  if radius given, radius output*/
     {/*one of the MARKTYPE list*/
        if(   ((thislistptr->STYLE) & RINGSTYLE   )
            )  /* ringlist  if radius given, radius output*/
        {/*actual RINGSTYLE list*/
           fprintf(fpout,"@ringlist {%s}%s%s%s%s%s%s%s%s%s%s%s%s\n"
            ,thislistptr->name,word,temps,numstr,bname,KineName
            ,dname,widthamt,hiliteness,staticness,detailness,lensness,nozclipness);
        }/*actual RINGSTYLE list*/
        if(   ((thislistptr->STYLE) & FANSTYLE   )
            )  /* ringlist  if radius given, radius output*/
        {/*actual FANSTYLE list*/
           fprintf(fpout,"@fanlist {%s}%s%s%s%s%s%s%s%s%s%s%s%s\n"
            ,thislistptr->name,word,temps,numstr,bname,KineName
            ,dname,widthamt,hiliteness,staticness,detailness,lensness,nozclipness);
        }/*actual FANSTYLE list*/
        else
        {/*actual plain MARKTYPE list*/
           fprintf(fpout,"@marklist {%s}%s%s%s%s%s%s%s%s%s%s%s%s\n"
            ,thislistptr->name,word,temps,numstr,bname,KineName
            ,dname,widthamt,hiliteness,staticness,detailness,lensness,nozclipness);
        }/*actual plain MARKTYPE list*/
     }/*one of the MARKTYPE list*/
     else if(   ((thislistptr->type) & WORDS    )
            )  
     {/*actual WORDS list*/
       
       if(thislistptr->wordsfont == 0) ename[0]='\0';
       else sprintf(ename," font= %d",thislistptr->wordsfont);
       if(thislistptr->wordsface == 0) fname[0]='\0';
       else sprintf(fname," face= %d",thislistptr->wordsface);
       if(thislistptr->wordssize == 0) gname[0]='\0';
       else sprintf(gname," size= %d",thislistptr->wordssize);
       
       fprintf(fpout,"@wordlist {%s}%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s\n"
            ,thislistptr->name,word,temps,numstr,bname,KineName
            ,dname,widthamt,ename,fname,gname,hiliteness,staticness
            ,detailness,lensness,nozclipness);   /*970917*/
     }/*actual WORDS list*/
  }/*Lkinformat: this list: output first line*/
  /*kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk*/
     
  if( (thislistptr->instanceptr == 0) )/*list not an instance */
  {/*this list has points to output*/
      thispointptr = thislistptr->firstpointptr;
      while(thispointptr != NULL)
      {/*loop over point triples*/ 
         igoout = 0; /*look for exceptions*/
         if( !((thispointptr->type) & PRUNED) ) /*survived pruning*/
         {
             igoout = 1;
             if( ( (thispointptr->type) & INVENTED ) )
               igoout=0;
                /*extra, shortened vector internal to MAGE*/
         }
         
         /*vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv*/
         if(Lvisibleout && igoout)
         {/*Lvisibleout*/

             igoout = 0; /*presume reject, accept if in view*/
if( (thislistptr->STATUS & STATICFLAG)==0)
{
 jx2 = (  (thispointptr->ix*i11 +thispointptr->iy*i21 +thispointptr->iz*i31)
       >>13)+ixset;
 jy2 = (  (thispointptr->ix*i12 +thispointptr->iy*i22 +thispointptr->iz*i32)
       >>13)+iyset;
 jz2 = (  (thispointptr->ix*i13 +thispointptr->iy*i23 +thispointptr->iz*i33)
       >>13)+izset;
         /*shift by 13 bits rather than divide by 8192 */
}
else
{
    jx2 =  thispointptr->ix + ixset;
    jy2 = -thispointptr->iy + iyset;
    jz2 =  thispointptr->iz + izset;
}
         if(Lperspec)
         {
           ifudgz = 1;
           idelz = ( (jz2/2) - izctr/2 );
           while(idelz > 181 || idelz < -181)
           {
             idelz = idelz/2;
             ifudgz = ifudgz*2;
           }
           ifudgx = 1;
           idelx = jx2 - ixset;
           while(idelx > 181 || idelx < -181)
           {
             idelx = idelx/2;
             ifudgx = ifudgx*2;
           }
           itemp = ((idelx*idelz)/1000);
           jx2 = itemp*ifudgx*ifudgz + jx2;
           ifudgy = 1;
           idely = jy2 - iyset;
           while(idely > 181 || idely < -181)
           {
             idely = idely/2;
             ifudgy = ifudgy*2;
           }
           itemp = ((idely*idelz)/1000);
           jy2 = itemp*ifudgy*ifudgz + jy2;
         }
         LOK = 0; /*flag for passing clip checks */
         /*checksideclip();*/ /*always do this, it is relatively cheap*/
         if(jx2 >= xmin && jx2 <= xmax && jy2 >= ymin && jy2 <= ymax) LOK = 1;
         if(Lzclipon && LOK == 1) 
         {  /* pass altered coord values*/
             /*checkzclip(jx1,jy1,jz1,jx2,jy2,jz2); */
             LOK = 0;
             if(jz2 >= (izctr - izclip) && jz2 <= (izctr + izclip) ) LOK = 1;
         }
         if(LOK == 1)
         {/*survived clipping*/
             igoout = 1; 
         }   
         else 
         {/*clipped point*/
             igoout = 0;
             iPointFlag = 1; /*next point must restart a polyline*/
         }
         }/*Lvisibleout*/
         /*vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv*/         
         
         if(igoout)
         {/*survived exceptions, write point to output*/
          /*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
          if(Lkinformat)
          {/*Lkinformat with Mickey Mouse stuff to get most compressed output*/
             writeindividualpoint(iPointFlag);

             iPointFlag = 0; /*allow next point to be continuing polyline*/

             if(endselectionpointptr != NULL)
             {
                if(thispointptr == endselectionpointptr)
                {/*write keyword after the point in the kinemage file*/
                   fprintf(fpout,"@endselect\n");
                   endselectionpointptr = NULL; /*only do this once*/
                }
             }
          }/*Lkinformat with Mickey Mouse stuff to get most compressed output*/
          /*xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/
          
          /*PDB_OUT_PDB_OUT_PDB_OUT_PDB_OUT_PDB_OUT_PDB_OUT_PDB_OUT_PDB_OUTPUT*/
          else if(     ((thispointptr->type)&VECTOR  ) 
                   && !((thispointptr->type)&MOVETO_P)
                   && !((thispointptr->type)&INVENTED)
                   && !((thispointptr->STATUS)&GHOST)
                 )
          {/*BRK PDB format:fish out unique and complete set of DrawTo Vectors*/
             ptIDstr[0] = '\0'; /*use ptIDstr[], initialize*/
             getptIDstring(ptIDstr, thispointptr);
             /*ptID in ptIDstr supposed to be in PDB format */
             for(k=0;ptIDstr[k]!='\0';k++) ptIDstr[k]=toupper(ptIDstr[k]);
             /*ptIDstr should start with a5,a3,1x,a1,i4,a1 == 15 characters*/
             /*the preceding 1x and the next 3x is part of fprintf format*/
             ptIDstr[15] = '\0'; /*force truncation to just PDB format info*/
             /*this allows ptID to carry extra info after that for kinemage*/
             /*occupancy f6.2, Bvalue f6.2                  occupaBvalue...*/
             /*cols:        12345678901...                  567890123456...*/
             fprintf(fpout,"ATOM      1 %s   %8.3f%8.3f%8.3f  1.0   0.0 \n"
                          ,ptIDstr
                          ,thispointptr->fx,thispointptr->fy,thispointptr->fz);
/*name[n],&ncnt[n],atom[n],res[n],sub[n],&num[n],rins[n],&x[n],&y[n],&z[n]*/
/*format(a6,i5,1x,a5,a3,1x,a1,i4,a1,3x,3f8.3)*/
/*
123456789_123456789_123456789_123456789_123456789_123456789_123456789_123456789_
atom      1  n   arg a   1      26.465  27.452  -2.490  1.00 25.18      4pti  89
*/
          }/*BRK PDB format:fish out unique and complete set of DrawTo Vectors*/
          /*PDB_OUT_PDB_OUT_PDB_OUT_PDB_OUT_PDB_OUT_PDB_OUT_PDB_OUT_PDB_OUTPUT*/
          
         }/*survived exceptions, write point to output*/

         if(thispointptr == thislistptr->lastpointptr)
             thispointptr = NULL;
         else thispointptr = thispointptr->nextptr;

      }/*loop over point triples*/
  }/*this list has points to output*/
}
/*___writeindividuallist()___________________________________________________*/

/****writeindividualpoint()****************************************************/
void writeindividualpoint(int iPointFlag)
{
  char ptIDstr[256];
  char hold[256];
  char char1,char2,char3,char4,charset[12];
  char aname[] = 
           { '\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0'
            ,'\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0'};
           /*enforce aname clearance since text is accummulated in it*/
  char noxyzstr[]={'\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0'};
  int  k,n;
  int  Ltablepoint = 0, Lnoxyz = 0;
   
   if( thispointptr->listptr != NULL)
   {
      if((thispointptr->listptr)->sgrpptr != NULL)
      {
         if(((thispointptr->listptr)->sgrpptr)->grupptr != NULL)
         {
            if(((((thispointptr->listptr)->sgrpptr)->grupptr)->type & TABLEFLAG)
               == TABLEFLAG)
            {
               Ltablepoint = 1;
            }
         }
      }
   }
  
            /*ditto " for efficient ptID in kinemage file*/ 
            /*this gets pretty hairy for shortened vectors with balllists*/
            /*so can't just use thispointptr->previousptr, but have to */
            /* remember the last valid output point's pointID */
            ptIDstr[0] = '\0'; /*use ptIDstr[], initialize*/ 
            getptIDstring(ptIDstr, thispointptr);
            if(thispointptr == (thispointptr->listptr)->firstpointptr )
            {/*first point in a list, make this pointID a reference*/
               strcpy(hold,ptIDstr); /*copy:   2 <- 1 */
            }/*first point in a list, make this pointID a reference*/
            else
            {/*not the first point in a list*/
               /*compare with previously outputed pointID held in hold */ 
               if( (strcmp(ptIDstr,hold)==0) && (hold[0] != '\0')) /*971001*/
               {/*non-NULL pointID same as previous pointID*/ /*971001*/
                    ptIDstr[0] = '\"';
                    ptIDstr[1] = '\0';
               }
               else
               {/*NOT the same, remember for next point*/
                  strcpy(hold,ptIDstr); /*copy:   2 <- 1 */
               }
            }
           if(   (thispointptr->type) & MOVETO_P) 
                 char1 = 'P'; /* valid MOVE: P Point: needed! */
           else  char1 = ' '; /*L Line or elsething*/
           if(Lvisibleout && iPointFlag) char1 ='P';/*after clipped pt*/
           if(  (thispointptr->type) & UNPICKABLE) 
                 char2 = 'U'; /*U Unpickable*/
           else  char2 = ' ';  

           if(  (thispointptr->type) & BALLHERE) 
                 char3 = 'B'; /*B Ball explicit*/
           else  char3 = ' ';  

           if(thispointptr->masterchar != '\0')   /*991210*/
                 char4 = thispointptr->masterchar;
           else  char4 = '\0';  

           charset[0] = '\0'; /*don't need space between bracket and number*/
           for(k=1;k<12;k++) charset[k] = '\0';
           k=0;
           if(char1 == 'P')
           {charset[k++] =char1;charset[k++]=' ';} /*do need space after each */
           if(char2 == 'U')
           {charset[k++] =char2;charset[k++]=' ';} /*single letter flag*/
           if(char3 == 'B')
           {charset[k++] =char3;charset[k++]=' ';}
           if(char4 != '\0')
           {charset[k++]='\'';charset[k++] =char4;charset[k++]='\'';charset[k++]=' ';}
           
           /*981114 avoid space between bracket and P: don't k++ before charset[k]= */
/*960810*/
/*coded in thispointptr->colorwidth*/
/* 2 byte integer: "colordepthwidthtype"
extra types:     8,     9,    10,    11,    12,    13,    14,    15
             16384, 18432, 20480, 22528, 24576, 26624, 28672, 30720

- 32768
- 16384  8 point type code (shift >>11, mask 15) 4 bit new usage: 000804
-  8192  4 point type code (shift >>11, mask  7) old 3 bit codes:
-  4096  2 "    1,     2,     3,     4,     5,     6,     7
-  2048  1 "  2048,  4096,  6144,  8192, 10240, 12288, 14336
-  1024  4 pen width code (shift >>8, mask 7)
-   512  2 "
-   256  1 "
-   128  4 depth cue code (shift >>5, mask 7)
-    64  2 "    1    2    3    4    5    6    7
-    32  1 "   32,  64,  96, 128, 160, 192, 224
-    16 color code (mask 31)
-    8 "
-    4 "
-    2 "
-    1 "
*/
           word[0] = '\0';/*initialize*/ /*960812*/
           aname[0] = '\0';/*initialize*/ /*960812*/
           if(thispointptr->colorwidth != 0) /*960810*/
           {/*decode color_depth_width_type */
               if( (thispointptr->colorwidth & 31)!= 0)
               {/*explicite color for this point*/
                   interpretcolor((thispointptr->colorwidth & 31));
                       /*MAGECOLR.c*/
                   /*color name string put into global "word[]"*/ 
               }/*explicite color for this point*/

               
               if( (thispointptr->colorwidth>>8 & 7)!= 0)
               {/*explicit pen width for this point*/
                   k = (thispointptr->colorwidth>>8) & 7;/*971014 debug*/
                   if      (k==1) sprintf(aname,"width1");
                   else if (k==2) sprintf(aname,"width2");
                   else if (k==3) sprintf(aname,"width3");
                   else if (k==4) sprintf(aname,"width4");
                   else if (k==5) sprintf(aname,"width5");
                   else if (k==6) sprintf(aname,"width6");
                   else if (k==7) sprintf(aname,"width7");
               }/*explicit pen width for this point*/

               
               /*960810 eplicit depth_cue and explicit type*/
               /*NOT coded at input, not allowed for in output*/
               /*Note, however, that write draw_new_parts does*/
               /*separate out constructed dots!  971014*/
               
           }/*decode color_depth_width_type */

           if(thispointptr->radius > 0.001)  /*980817*/
           {/*point radius*/
              sprintf(aname,"%s r=%-.2f",aname,thispointptr->radius);
           }/*point radius*/ /*980817*/
           if( (thispointptr->STATUS & DUMMY) == DUMMY)
           {/*dummy point*/  /*991203*/
              if(Ltablepoint)
              {/*means has no functional x,y,z and doesn't need "dummy" param*/
                 Lnoxyz = 1;
                 sprintf(noxyzstr," tablecell");
              }
              else
              {/*explicit "dummy" parameter*/
                sprintf(aname," dummy %s",aname);
              }
           }/*dummy point*/
           
           if( (thispointptr->STATUS & NOXYZ) == NOXYZ)
           {/*no functional x,y,z coord for this point*/  
              Lnoxyz = 1;
              if(Ltablepoint)
              {
                 sprintf(noxyzstr," tablecell");
              }
              else
              {
                 sprintf(noxyzstr," noxyz");
              }
           }/*no functional x,y,z coord for this point*/  

           if( (thispointptr->STATUS & GHOST) == GHOST)
           {/*seen but not real for some purposes (like PDB output)*/  
              sprintf(aname," ghost %s",aname);
           }/*no functional x,y,z coord for this point*/  
           
           /*"ptIDstr[]" has ptID*/
           /*"temps[]" gets <words comment> */
           /*"charset[]" has P/L, U, B codes*/
           /*"word[]" has color name if given explicitly for point*/
           /*"aname[]" has pen width if given explicitly for point*/

           if(thispointptr->wordoffset != 0)
           {/*has wordstring, get it*/
               getcommentstring(commentstr, thispointptr);
               for(n=3;commentstr[n]!='\0';n++)
                   temps[n-3]=commentstr[n];
               /*temps[n-2]='\0'; but n-3 is not yet defined 960228*/
               temps[n-3]='\0';
           }/*has wordstring, get it*/
           else temps[0] = '\0';

           if(   temps[0] != '\0' 
              || Ltablepoint     /*table cells always get {} <>...*/
              || Lnoxyz )        /*point with no xyz should have something*/
           {/*write with <word>, presume ptID as well*/
             if(word[0]!='\0'||aname[0]!='\0')
             {/*has some explicit point properties*/
               if(Lnoxyz)
               {
                  fprintf(fpout,"{%s} <%s> %s%s %s %s\n"
                   ,ptIDstr,temps,charset,aname,word
                   ,noxyzstr);                         
               }
               else
               {
                  fprintf(fpout,"{%s} <%s> %s%s %s %.3f %.3f %.3f\n"
                   ,ptIDstr,temps,charset,aname,word
                   ,thispointptr->fx,thispointptr->fy,thispointptr->fz);                         
               }
             }/*has some explicit point properties*/
             else
             {
               if(Lnoxyz)
               {
                  fprintf(fpout,"{%s} <%s> %s%s\n"
                   ,ptIDstr,temps,charset
                   ,noxyzstr);  
               }
               else
               {
                  fprintf(fpout,"{%s} <%s> %s %.3f %.3f %.3f\n"
                   ,ptIDstr,temps,charset
                   ,thispointptr->fx,thispointptr->fy,thispointptr->fz);
               }
             }
           }/*write with <word>, presume ptID as well*/
           else if(ptIDstr[0] != '\0')
           {/*write point with ptID*/
             if(word[0]!='\0'||aname[0]!='\0')
             {/*has some explicit point properties*/
               fprintf(fpout,"{%s}%s%s %s %.3f %.3f %.3f\n"
                ,ptIDstr,charset,aname,word
                ,thispointptr->fx,thispointptr->fy,thispointptr->fz);
             }/*has some explicit point properties*/
             else
             {
               fprintf(fpout,"{%s}%s%.3f %.3f %.3f\n"
                ,ptIDstr,charset
                ,thispointptr->fx,thispointptr->fy,thispointptr->fz);
             }
           }/*write point with ptID*/
           else
           {/*write point with no ptID, minimal designation*/
             if(word[0]!='\0'||aname[0]!='\0')
             {/*has some explicit point properties*/
               fprintf(fpout,"%s%s %s %.3f %.3f %.3f\n"
                ,charset,aname,word
                ,thispointptr->fx,thispointptr->fy,thispointptr->fz);
             }/*has some explicit point properties*/
             else
             {
               fprintf(fpout,"%s%.3f %.3f %.3f\n"
                ,charset
                ,thispointptr->fx,thispointptr->fy,thispointptr->fz);
             }
           }/*write point with no ptID, minimal designation*/
}
/*___writeindividualpoint()___________________________________________________*/

/****inventoutputname()*******************************************************/
void inventoutputname(int kind,int k,char TestStr[256],char OutStr[256],int Lnameflag)
{
   /* construct output file name from input file name */
   /* add 2,3,or 4 char: .new to input file name */
   /*or replace last .___ with .new*/
   /* no matter what that name is like. new==vw,ksp,kqa,kip,...,kipn*/
   int i,kk;
   
   for(i=0;i<256;i++)
   {/*copy file name*/
      OutStr[i] = TestStr[i];
      if(OutStr[i] == '\0') break;
   }
   /*modify output file name*/
   kk = 4; /*expect 3 char + \0 */
   if     (kind==1){sprintf(word,"save current view as:");
      OutStr[k+1]='v';OutStr[k+2]='w';OutStr[k+3]='\0';}
   else if(kind==2){sprintf(word,"save current picked point as:");
      OutStr[k+1]='f';OutStr[k+2]='p';OutStr[k+3]='t';}
   else if(kind==3){sprintf(word,"save newly drawn things as:");
      OutStr[k+1]='n';OutStr[k+2]='e';OutStr[k+3]='w';}
   else if(kind==4){sprintf(word,"save rotated stuff as:");
      OutStr[k+1]='r';OutStr[k+2]='o';OutStr[k+3]='t';}
   else if(kind==5)
   {/*modified kin*/
      sprintf(word,"write modified kinemage to:");
      OutStr[k+1]='k';OutStr[k+2]='i';OutStr[k+3]='p';
      if(   (TestStr[k+1] == OutStr[k+1])
         && (TestStr[k+2] == OutStr[k+2])
         && (TestStr[k+3] == OutStr[k+3]) )
      {/*possible duplicate names, they must be different*/
         if(TestStr[k+4] == '\0')
         {
            OutStr[k+4] = '1';
            OutStr[k+5] = '\0';
         }             
         else/*if(TestStr[k+4] != '\0' && TestStr[k+5] == '\0')*/
         {
            if(TestStr[k+4] == '9') OutStr[k+4] = 'a'; /*start using alphabet*/
            else OutStr[k+4] = TestStr[k+4] + 1; /*arbitrarily +1*/
         }
         kk = 5; /*expect 3 char + 1 extra + \0 */
      }/*possible duplicate names, they must be different*/
    }/*modified kin*/
    else if(kind==6){sprintf(word,"current view as postscript file:");
       OutStr[k+1]='e';OutStr[k+2]='p';OutStr[k+3]='s';}
    else if(kind==7){sprintf(word,"current Answers to file:");
       OutStr[k+1]='k';OutStr[k+2]='q';OutStr[k+3]='a';}
    else if(kind==8){sprintf(word,"current view as raster3Drender file:");
       OutStr[k+1]='r';OutStr[k+2]='3';OutStr[k+3]='d';}
    else if(kind==9){sprintf(word,"current view as POV-Ray render file:");
       OutStr[k+1]='p';OutStr[k+2]='o';OutStr[k+3]='v';}
    else if(kind==10){sprintf(word,"current pointID to file:");
       OutStr[k+1]='p';OutStr[k+2]='i';OutStr[k+3]='d';}
    else            {sprintf(word,"no known output %d",kind);
       OutStr[k+1]='k';OutStr[k+2]='\0';OutStr[k+3]='\0';}

    OutStr[k+kk] = '\0';
    if(Lnameflag)
    {/*Could not derive a valid output name, user MUST edit the name*/
       strcpy(TestStr,OutStr);/*later filter against idenity*/
    }
}
/*___inventoutputname()______________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****kinescopeout()***********************************************************/
int     kinescopeout()
{
  /*scope out the entire kinemage file, except text and modified current kin*/
  /*then closes input file and redefines output file to be the current input*/

  int     c,flowID;  /* switch controls for input */
  int  Lkine, Lnew; /* Logicals for input flow */ 
  int  Lscopeout = 0; /*presume false until @kinemage # appropriate*/
  char  buff[256];
  int   ibuff;
  enum{ neutID = 1, keywID, kineID };     
  int   ireturn = 1; /*presume successful*/

 writetext();  /*to fpout, the current output file */ /*____OUT.c*/

 /*origkinenum = -99 default for keeping track of kins in a file*/ 
 /*kinemagenum = 0 default for kinemage about to be read in*/ 
 /*Lorigkinfile tracks changes to input file */ 

 if(!Lorigkinfile) 
 {/*nolonger have original file open so can only write this one*/
   if(Lkinfile==1 || Lkinfile==3)
   {
      /*valid inputted kinemage sets Lkinfile==1*/
      /*internal kinemage sets Lkinfile==3*/
      writepruned(); /*output current kinemage*/
      Lscopeout = 0; /*chug through file image of current kin*/
   }
   else
   {/*Lkinfile==2*/
     ;/*now just get text as output if Lkinfile == 2*/
   }
 } 
 /*if(Lorigkinfile && !(origkinenum==thiskinenum && atEOF) )*/
 /*more than current kinemage to write out*/
 else   /*Lorigkinfile*/
 {/*original kin file is available to write out, even if only 1 kinemage*/ 
   fpin = fp; /*scan primary kinemage file for the other kins*/
   filerewind(fpin); 
   atEOF = 0;

   Lnextkine = 0;
   LnextOK = 1;
   word[0] = '\0';
   iword = 0;
   flowID = neutID;
   while (!atEOF)
   {/*loop while file not at EOF */
     /* #define getnextchar()  getc(fpin), fpin == fp here*/
     /* flow controls and logicals together direct the flow */
     c = getnextchar();
     if(c==EOF) atEOF = 1;
            
     if(Lscopeout) buff[ibuff++] = c; /*buffer for output*/
 
     if (c == '\n' || c == '\r' || (Lscopeout && ibuff >= 254) )
     {/*char is end of line or pushing buffer limit*/
        if(Lscopeout && (ibuff > 0))
        {
           if(buff[0]=='@'&&ibuff >= 8 &&(strncmp(buff,"@kinemage",9)==0)) 
           {/*keyword starts with @: char after \n or \r, check for kinemage*/
              ; /*NOP: don't pass this to output*/
           }
           else
           {/*output this string*/
              buff[ibuff] = '\0';
              fprintf(fpout,"%s",buff);
              buff[0] = '\0';
              ibuff = 0;
           }
        }
        /*c = '\015';*/
        /* whatever newline is, it needs to be CR in text */
     }/*char is end of line or pushing buffer limit*/
     if (c == '@') 
     {
        flowID = keywID; /* need to get begin's key word */
        iword = 0;  /* set keyw character counter */
     }
     switch(flowID)
     {/*switch on flowID*/
         case neutID:  
          /* neutral: no flow designated, no further work on characters */
         break;
                    
         case keywID: 
          /*try to interpret next set of characters as a key wor*/
          /*@keyword must be contiguous characters as a single word*/
          if(c == '@')
          {
             ;  /* @ discarded */
          }
          else
          {/* this routine only looks for kinemage to end */
             iword++;
             word[iword] = c;
             word[iword] = tolower(word[iword]);  
                           /*case independent*/
             if( (c == ' ')||(c == '\015')||(c == ',' )||
                 (c == ';')||(iword >=  8)||(c == '\n')  )
             {/* stop looking when hit white space or 8 char max */
                /* pad ends so can treat word as a real string */
                word[iword+1] = '\0';
                word[0] = ' ';
                           
                /* try to interpret as a keyword string */
                /* search for kinemage as key word */
                Lkine = 0;
                if(strncmp(word," kinemage",9) == 0) Lkine =1; /*MAGEINPT*/
                if(Lkine) 
                {
                   flowID = kineID; 
                   Lnew = 1; /* flag start of scan for kinemage number */
                }
                else
                {
                   flowID = neutID; /* clear flowID */
                }
                iword = 0;
             }/* stop looking when hit white space or 8 char max */
          }/* this routine only looks for kinemage to end */
         break; /* case = keywID */
                
         case kineID: 
           /*when done, getkinemagenum returns as 1 */
           if( getkinemagenum((char)c,Lnew) ) 
           {
              if(kinemagenum == thiskinenum)
              {
                 writepruned(); /*output current kinemage*/
                   /* found desired number */
                 Lscopeout = 0; /*chug through file image of current kin*/
              }
              else if(   kinemagenum >= nextkinenum
                      || kinemagenum < thiskinenum  )
              {/*before or next past current kin,  scope out from file*/  
                 Lscopeout = 1;
                 fprintf(fpout,"@kinemage %d\n",kinemagenum);
                 buff[0] = '\0';
                 ibuff = 0;
              }
              flowID = neutID;
           }
           Lnew = 0;
         break;
     }/*switch on flowID*/
   }/*loop while file not at EOF */
 }/*original kin file is available to write out, even if only 1 kinemage*/
 makecursoractive();
 IOerr = 0;
 atEOF = 1;
 fprintf(fpout,"\n"); /*Keep end clean*/
 fclose(fpout);
 fpout = NULL;
 return(ireturn);
}
/*___kinescopeout()__________________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****routeoutput()************************************************************/
int routeoutput(int kind,char OutStr[256],char NameStr[256])
{
   /*NameStr only used when replacing full kinemage file*/
   int ireturn = 1; /*presume successful*/

   if(kind == 1) 
   {
      writematrix(); /*MAGEOUT.C*/
      Lnewviewactive = 0;  /*971129*/
   }
   else if(kind == 2) writefocus();  /*MAGEOUT.C*/
   else if(kind == 3)
   {
      if( writedrawnew() !=1)  /*MAGEOUT.C*/
      {
         sprintf(alertstr,"no vectors or labels in draw new stuff!");
         dosinglealert(0); /*MACDLOG.C*/ /*MPCDLOG.C*/
      }
      fclose(fpout); /* close here, writedrawnew can be part of output*/
      Ldrawactive = 0;  /*971129*/
   }
   else if(kind == 4) writerotated(); /*MAGEOUT.C*/
   else if(kind == 5) 
   {/*modified kinemage*/
      /*writepruned();*/ /*modified kinemage MAGEOUT.C*/
      /*scope out the entire kinemage file, inc text and modified current kin*/
      if(kinescopeout()) /*returns with fpout closed! */
      {/*successfully written new output file*/
         Lpruneactive = 0;
         Ldrawactive = 0;
         Lnewviewactive = 0;
         /*call dialog to decide just what one wants as current file*/    
         if(Lorigkinfile) /*read in output file to be current input file*/
            outputtoinput(kind,OutStr,NameStr);
      }
      else
      {/*failed to even write to output file */
         sprintf(alertstr,"BEWARE: failure in writing: %s"
                  ,OutStr);
         sprintf(alertstr2,"Current active kinemage file remains: %s"
                  ,NameStr);
         sprintf(alertstr3,"Modified kin file may be defective.");
         DoMageDLOGreport(3); /*mode 2 for abort, 3 for toggle debug*/
         ireturn = 0; /*failure*/
      }

   }/*modified kinemage*/
   else if(kind == 6)
   {
        writepostscript(); /*writes header, sets flags to continue*/
        SetsinGrafWindow();       /*MAGEBBOX.c*/
        redrawvec();              /*____DRAW*/
   }
   else if(kind == 7) writequesanswers(); /*____OUT.C*/
   else if(kind == 8 || kind == 9)
   {/*overload Lraster3Drender == 1 for Raster3D, OR == 2 for POV-Ray*/
        writeraster3Drender(); /*writes header, sets flags to continue*/
        SetsinGrafWindow();       /*MAGEBBOX.c*/
        redrawvec();              /*____DRAW*/
   }
   else if(kind == 10)
   {
        writepointID(); /*writes pointID to file*/   /*000326*/
        SetsinGrafWindow();       /*MAGEBBOX.c*/
        redrawvec();              /*____DRAW*/
   }

   return(ireturn);
}
/*___routeoutput()___________________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****outputtoinput()**********************************************************/
int outputtoinput(int kind,char OutStr[256],char NameStr[256])
{
   int ireturn = 1; /*presume successful*/
   kind = kind; /*avoids not-used warning*/  /*981212*/
   if ((fpnew = fopen(OutStr,"r")) == NULL)
   {/*failed to open output file for reading*/
       sprintf(alertstr,"BEWARE: failed to open file for reading: %s"
                    ,OutStr);
       sprintf(alertstr2,"Current active kinemage file remains: %s"
                    ,NameStr);
       sprintf(alertstr3,"Modified kin file may be defective.");
       DoMageDLOGreport(3); /*mode 2 for abort, 3 for toggle debug*/
       ireturn = 0; /*treat like canceling file open procedure*/
   }
   else
   {
       /*close input file, redefine output file to be the current input*/
       fclose(fp);
       fp = NULL;
       fp = fpnew;
       Lorigkinfile = 1; /*by definition*/  /*981207*/
       Lappend = 0; /*by definition, modified file is a primary file*/
       filerewind(fp);/*now the current primary kinemage file*/
       atEOF = 0;
       /*copy name, so can help get a different name if do this again*/
       strcpy(NameStr, OutStr);
#ifdef UNIX_X11
       printf(" opened modified file: %s\n",OutStr);
#endif

#ifdef PCWINDOWS
		SetMageCaption();
#endif
       Lnextkine = 0;
       LnextOK = 0;
       nextkinenum = thiskinenum; /*get back to current kinemage*/
       thiskinenum = 0;
       findkinemage(); /*kinesearch();*/
       ireturn = 1;/*981212*/
       /*000410 so kinemage itself is reread from file BUT text is NOT */
   }
   return(ireturn);
}
/*___outputtoinput()_________________________________________________________*/
