#include "MAGE.h"
#include "MAGELIST.h"
#include "MAGEMENU.h"
#include "MAGEBBOX.h"
#include "MAGEANGL.h"
/* Functions to deal with compound "slider" windows */
/* Sliders contain: */
/*  1. a vertical scrollbar control */
/*  2. an edit control */
/*  3. a title, drawn in response to WM_PAINT */

/* contents of extra bytes of slider window */
/* THESE ARE THE WIN16 VALUES */
/* 0: HIWORD-edit control id; LOWORD-edit control window handle */
/* 4: HIWORD-scrollbar control id; LOWORD-scrollbar window handle */
/* 8: string table entry of slider title */
/* 12: address (2-byte offset in this code segment) of function */
/*              associated with this slider */
/*              In the large and medium models this function MUST be in */
/*                      the same code segment as all its callers */

/* WIN32 VALUES */
/* 0: edit control id */
/* 4: edit control window handle */
/* 8: scrollbar control id */
/* 12: scrollbar window handle */
/* 16: string table entry of slider title */
/* 20: address of function associated with this slider */
/*       In the large and medium models this function MUST be in */
/*       the same code segment as all its callers */

/* functions called by sliders are passed a double if the double > BARRIER */
/* it is the new value for the slider, otherwise the function simply */
/* returns the current value.  The following three functions MUST be left */
/* in this code segment (i.e., in this file */

/****zoomfunc()*************************************************************/
static double zoomfunc(double x)
{
    zoom = (float)x;
    scalenew = Scale*zoom; /*920607 dcr*/
    rescalekinemage(); /*mageinpt.c*/ /*920607 dcr*/
    return(zoom);
}
/*___zoomfunc()____________________________________________________________*/

/****slabfunc()*************************************************************/
static double slabfunc(double x)
{
    slabfac = x;
	izclipold[0] = (int)(100*slabfac);
    izclip = (int)(izclipold[0]*fzclip); /*920607 dcr*/
    return(slabfac);
}
/*___slabfunc()____________________________________________________________*/

/****tranfunc()*************************************************************/
static double tranfunc(double x)
{
    tranfac = x;
    iztran = (int)(100*tranfac); /*920607 dcr*/
    return(tranfac);
}
/*___tranfunc()____________________________________________________________*/

/****SystemFontSize()*******************************************************/
void SystemFontSize(void)
{
    /* find the system font size */
    HFONT hFont = (HFONT)GetStockObject(SYSTEM_FONT);
    HFONT oldFont;
    TEXTMETRIC tm;
    HDC hDC;
    hDC = GetDC(MageWindow);
    oldFont = (HFONT)SelectObject(hDC,hFont);
    GetTextMetrics(hDC,&tm);
    SelectObject(hDC,oldFont);
    ReleaseDC(MageWindow,hDC);
    fontheight = tm.tmHeight;
    fontwidth = tm.tmAveCharWidth;
    fontmaxwidth = tm.tmMaxCharWidth;
    fontverticalspace = tm.tmHeight + tm.tmExternalLeading;
    oldfontsize = fontverticalspace;
    infofontsize = oldfontsize;
    labelsfontsize = oldfontsize;
    wordsfontsize = oldfontsize;
}
/*___SystemFontSize()______________________________________________________*/

/****AddSliderScrollBar()***************************************************/
static int AddSliderScrollBar(HWND sliderWindow, int id, RECT *rect,
			int fontheight,int low, int high, int start, int page, sliderfunc func)
{
  HWND sWindow;
  SCROLLINFO si;
  int scrollbarwidth = GetSystemMetrics(SM_CXVSCROLL);

  sWindow = CreateWindow(
		"SCROLLBAR",                        /* Scrollbar class */
		NULL,                               /* no title */
		WS_CHILD | WS_VISIBLE | SBS_VERT,   /* Window style. */
		rect->left,                         /* horizontal position */
		rect->top+fontheight+1,             /* vertical position */
		scrollbarwidth*2/3,                 /* width */
		rect->bottom-(fontheight+1),        /* height */
		sliderWindow,                            /* parent */
		(HMENU)(id+2),                      /* window identifier */
		hInst,                              /* This instance owns window */
		NULL                                /* Pointer not needed */
		);

  /* frame window knows its child's id and handle */
  SetWindowLong(sliderWindow,8,(unsigned long)(id+2));
  SetWindowLong(sliderWindow,12,(long)sWindow);
  if (!sliderWindow) return (0);

  /* set starting values (not necessary on resize) */
  if (low != high)
  {
	  si.cbSize = sizeof(SCROLLINFO);
	  si.fMask = SIF_ALL;
	  si.nPage = page;
	  si.nMax = high+si.nPage;
	  si.nMin = low;
	  si.nPos = start;
	  SetScrollInfo(sWindow,SB_CTL,&si,TRUE);
	  
	  SetWindowLong(sliderWindow,20,(long)func);
  }

  /*920720 dcr set common values so sliders can be set as values inputed */

  if(func == zoomfunc) zoommvWindow = sWindow;
  if(func == slabfunc) zslabmvWindow = sWindow;
  if(func == tranfunc) ztranmvWindow = sWindow;
  return(1);
}
/*___AddSliderScrollBar()__________________________________________________*/

/****NewScrollWindow()******************************************************/
/* Create a new scroll window with a value edit control and a scroll bar */
HWND NewScrollWindow(HWND parent, int id, int left, int top, int right, int bottom,
            int low, int high, int start, int page, int titleid, sliderfunc func)
{
    HWND sliderWindow, eWindow;
    char editbuf[10];
    RECT rect;

    /* Create the scroll window */
    sliderWindow = CreateWindow(
		"MageScrollClass",  /* class name						 */
		NULL,				/* no text for window title bar      */
		WS_CHILD | WS_CLIPSIBLINGS, /* Window style. */
		left,				/* horizontal position.				 */
		top,				/* vertical position				 */
		right,				/* width							 */
		bottom,				/* height							 */
		parent,				/* parent							 */
		(HMENU)id,			/* window identifier				 */
		hInst,				/* This instance owns this window.	 */
		NULL				/* Pointer not needed.				 */
		);

    /* If window could not be created, return "failure" */
    if (!sliderWindow) return (0);


    SetWindowLong(sliderWindow,0,0);	/* edit control id				*/
    SetWindowLong(sliderWindow,4,0);	/* edit control window handle	*/
    SetWindowLong(sliderWindow,8,0);	/* scrollbar control id			*/
	SetWindowLong(sliderWindow,12,0);	/* scrollbar window handle		*/
    SetWindowLong(sliderWindow,16,0);	/* string table -> slider title */
    SetWindowLong(sliderWindow,20,0);	/* function memory address		*/

    /* Make the window visible; update its client area; and return "success" */
    ShowWindow(sliderWindow, SW_SHOWNA);  /* Show the window */
    /* UpdateWindow(sliderWindow); */         /* Sends WM_PAINT message */

    GetClientRect(sliderWindow,&rect);

    /* Create a text edit control.  */
    eWindow = CreateWindow(
		/*"Edit", */            /* See RegisterClassEx() call		*/
		"STATIC",               /* See RegisterClassEx() call		*/
		NULL,                   /* Text for window title bar		*/
		WS_CHILD,				/* Window style.					*/
		rect.left,              /* horizontal position				*/
        rect.top,               /* vertical position				*/
		rect.right,             /* width							*/
		rect.top+fontheight,    /* height							*/
		sliderWindow,           /* parent							*/
		(HMENU)(id+1),          /* window identifier				*/
		hInst,                  /* This instance owns this window	*/
		NULL					/* Pointer not needed				*/
		);

	SetWindowLong(sliderWindow,0,(unsigned long)(id+1));
	SetWindowLong(sliderWindow,4,(long)eWindow);
    /* If window could not be created, return "failure" */
    if (!eWindow) return (0);

    /* Make the window visible; update its client area */
    ShowWindow(eWindow, SW_SHOWNA);
    /* UpdateWindow(eWindow); */     /* Sends WM_PAINT message */

    /* create the scroll bar */
    if (!AddSliderScrollBar(sliderWindow,id+2,&rect,fontheight,

		low,high,start,page,func))
            return(0);

    if(titleid == ST_ZOOM_TITLE) sprintf(editbuf,"%4.2lf",(float)start/100);/*zoom*/
    else sprintf(editbuf,"%d",start);/*zslab,ztran*/

    SendMessage((HWND)GetWindowLong(sliderWindow,4),
                WM_SETTEXT,0,(DWORD)editbuf);
    SetWindowLong(sliderWindow,16,(long)titleid);
    InvalidateRect(sliderWindow,NULL,TRUE);

	return(sliderWindow);
}
/*___NewScrollWindow_______________________________________________________*/

/****NewSliderWindows()*****************************************************/
/* create three slider windows on the right side of the main window */
void NewSliderWindows(void)
{
    RECT rect;
    int swidth1 = GetSystemMetrics(SM_CXVSCROLL) + fontwidth + 4;
    int swidth2 = 3 * fontwidth + fontwidth + 4;
    int onethird, twothirds;

    SliderWidth = max(swidth1,swidth2);
    GetClientRect(MageWindow,&rect);
    onethird = rect.bottom / 3;
    twothirds = 2 * onethird;
    sWindow = NewScrollWindow(MageWindow,MAGESCROLLID,
        rect.right-SliderWidth-RWIDTH,    /*Left*/
        0,                                /*Top*/
        SliderWidth,onethird,             /*Width,Height*/
        0,1000,100,10,           /*Min,Max,Setting,Page Increment*/
		ST_ZOOM_TITLE,          /*titleid: relates to stringtable: PCWMAGE.RC*/
        zoomfunc);           /*,function*/
    slabWindow = NewScrollWindow(MageWindow,MAGESCROLLID,
        rect.right-SliderWidth-RWIDTH,    /*Left*/
        onethird,
        SliderWidth,twothirds-onethird,
		  0,800,200,10,ST_ZSLAB_TITLE,slabfunc);
    ztranWindow = NewScrollWindow(MageWindow,MAGESCROLLID,
        rect.right-SliderWidth-RWIDTH,     /*Left*/
        twothirds,
        SliderWidth,rect.bottom-twothirds,
		-500,500,0,10,ST_ZTRAN_TITLE,tranfunc);
}
/*___NewSliderWindows()____________________________________________________*/

/****ScrollWndProc()********************************************************/
LRESULT CALLBACK ScrollWndProc(HWND hWnd, UINT message,
                            WPARAM wParam, LPARAM lParam)
{
  int i, newdraw, scrollbarwidth;
  HWND cWnd;
  HDC hDC;
  PAINTSTRUCT ps;
  SCROLLINFO si;
  RECT rect;
  int titletop, titlebottom, titlespace, titlesize, titleid;
  char editbuf[10];
  sliderfunc func;

  switch (message)
  {
    case WM_PAINT:
      /* draw the title vertically to the right of the scroll bar */
      hDC = BeginPaint(hWnd,&ps);
      GetClientRect(hWnd,&rect);
      titletop = fontheight + 1;
      scrollbarwidth = GetSystemMetrics(SM_CXVSCROLL);
      titlebottom = rect.bottom;
	  titleid = GetWindowLong(hWnd,16);
      LoadString(hInst,titleid,editbuf,sizeof(editbuf));
      titlespace = titlebottom - titletop;
      titlesize = strlen(editbuf) * fontverticalspace;
      titletop += (titlespace - titlesize) / 2;
	  SetBkMode(hDC,TRANSPARENT);
      for (i = 0; (unsigned int)i < strlen(editbuf); ++i)
            TextOut(hDC,scrollbarwidth+1,
                   titletop+i*fontverticalspace,


                   editbuf+i,1);
      EndPaint(hWnd,&ps);
      break;
    case WM_SIZE:
      cWnd = (HWND)GetWindowLong(hWnd,12);
      if (cWnd)
      {
		DestroyWindow(cWnd);
        GetClientRect(hWnd,&rect);
        if (!AddSliderScrollBar(hWnd,GetWindowLong(hWnd,8),
            &rect,fontheight,0,0,0,0,NULL))
          return(0);
      }
      break;
	case WM_CHAR:
	case WM_KEYUP:
    case WM_KEYDOWN:
        SendMessage(MageWindow,message,wParam,lParam);
      break;
	case WM_MOUSEMOVE:
		SetFocus(hWnd);
	  break;
	case WM_MOUSEWHEEL:
	  /* reset the values of wParam and then drop into the      */
	  /* WM_VSCROLL procedure and avoid excess code duplication */
	  if ((short)HIWORD(wParam) > 0)
		  wParam = MAKEWPARAM(SB_PAGEUP,NULL);
	  else if ((short)HIWORD(wParam) < 0) 
		  wParam = MAKEWPARAM(SB_PAGEDOWN,NULL);
    case WM_VSCROLL:
	  /* get current scroll info from the scrollbar */
	  /* fMask set to parameters for READING info   */
	  si.cbSize = sizeof(SCROLLINFO);
	  si.fMask = SIF_ALL;
	  cWnd = (HWND)GetWindowLong(hWnd,12);
	  GetScrollInfo(cWnd,SB_CTL,&si);

      /* messages from the scroll bar */
      newdraw = 1; /*most scroll commands result in a new draw*/

      switch (LOWORD(wParam))
      {
        case SB_LINEDOWN:
          si.nPos++;
          break;
        case SB_LINEUP:
          si.nPos--;
          break;
        case SB_PAGEDOWN:
          si.nPos += si.nPage;
          break;
        case SB_PAGEUP:
          si.nPos -= si.nPage;
          break;
        case SB_THUMBTRACK: /*tracking too slow for new draw each time*/
          newdraw = 0;
        case SB_THUMBPOSITION:
          si.nPos = si.nTrackPos;
          break;
        default: break;
      }

	  if (si.nPos > (si.nMax-(int)si.nPage)) si.nPos = (si.nMax-(int)si.nPage);
	  if (si.nPos < si.nMin) si.nPos = si.nMin;
	  si.fMask = SIF_POS; /* extra precaution so only the position is reset */
	  SetScrollInfo(cWnd,SB_CTL,&si,TRUE);
      
	  func = (sliderfunc) GetWindowLong(hWnd,20);
	  if(newdraw) 
	  {
		  func(si.nPos/100.0);
		  redrawvec();
	  }

	  titleid = GetWindowLong(hWnd,16);
      if(titleid == ST_ZOOM_TITLE)
      {
        sprintf(editbuf,"%4.2lf",(float)si.nPos/100);/*zoom*/
      }
      else sprintf(editbuf,"%d",si.nPos);/*zslab,ztran*/

	  SendMessage((HWND)GetWindowLong(hWnd,4),
                    WM_SETTEXT,0,(DWORD)editbuf);
	  SetFocus(hWnd);
      break;
    default: break;
  }
  return(DefWindowProc(hWnd, message, wParam, lParam));
}
/*___ScrollWndProc()_______________________________________________________*/

/****resetgrafbondrotBar()************************************************/
void resetgrafbondrotBar(int i)
{
    int shiftPlace;
	SCROLLINFO si;
	HWND cWnd;

	cWnd = (HWND)GetWindowLong(bondrotWindow[i],12);

	si.cbSize = sizeof(SCROLLINFO);
	si.fMask = SIF_POS;
    /*now use half degree steps*/
	shiftPlace = 2*((int)(bondrotptr[i]->angle) + 180);
	if(shiftPlace > 2*360) shiftPlace = shiftPlace - 2*360;

	si.nPos = 2*((int)(bondrotptr[i]->angle));
	SetScrollInfo(cWnd,SB_CTL,&si,TRUE);
	writebondrotvalue(i); /*MPCBAR.C*/
	resetgraphedrotamer(i); /*MAGEANGL.c, checks for this graphing*/
}
/*___resetgrafbondrotBar()_______________________________________________*/

/****writebondrotvalue()*****************************************************/
void writebondrotvalue(int i)
{
	char editbuf[10];
	sprintf(editbuf,"%4.2lf",(float)bondrotptr[i]->angle);
	SendMessage((HWND)GetWindowLong(bondrotWindow[i],28),WM_SETTEXT,0,(DWORD)editbuf);

	/*reaffirm starting angle display */
    sprintf(editbuf,"%4.2lf",bondrotptr[i]->origangle);
	SendMessage((HWND)GetWindowLong(bondrotWindow[i],4),WM_SETTEXT,0,(DWORD)editbuf);
}
/*___writebondrotvalue()____________________________________________________*/

/****erasebondrotvalue()*****************************************************/
void erasebondrotvalue(int i)  /* <- MAGEINPT */
{
   if(bondrotWindow[i]!=0)
   {
	   DestroyWindow(bondrotWindow[i]);
	   bondrotWindow[i] = 0;
   }
}
/*___erasebondrotvalue()____________________________________________________*/

/****HScrollWndProc()********************************************************/
LRESULT CALLBACK HScrollWndProc(HWND hWnd, UINT message,
                            WPARAM wParam, LPARAM lParam)
{
  int oldpos, titleid;
  HWND cWnd;
  HDC hDC;
  PAINTSTRUCT ps;
  SCROLLINFO si;
  RECT rect;
  float   theta;

  switch (message)
  {
    case WM_PAINT:
      /* draw the title of the scroll bar */
      hDC = BeginPaint(hWnd,&ps);
      GetClientRect(hWnd,&rect);
	  SetBkMode(hDC,TRANSPARENT);
	  titleid = GetWindowLong(hWnd,16);/*int 1---nbondrot*/
                           /* put name in word, a global variable*/
	  sprintf(word,"%s",bondrotptr[titleid]->name);
      TextOut(hDC,rect.top,rect.left,word,lstrlen(word));
      EndPaint(hWnd,&ps);
      break;
	case WM_CHAR:
	case WM_KEYUP:
    case WM_KEYDOWN:
        SendMessage(MageWindow,message,wParam,lParam);
      break;
	case WM_MOUSEMOVE:
		SetFocus(hWnd);
	  break;
	case WM_MOUSEWHEEL:
	  /* reset the values of wParam and then drop into the      */
	  /* WM_HSCROLL procedure and avoid excess code duplication */
	  if ((short)HIWORD(wParam) > 0)
		  wParam = MAKEWPARAM(SB_PAGEDOWN,NULL);
	  else if ((short)HIWORD(wParam) < 0)
		  wParam = MAKEWPARAM(SB_PAGEUP,NULL);
    case WM_HSCROLL:
	  /* get current scroll info from the scrollbar */
	  /* fMask set to parameters for READING info   */
	  si.cbSize = sizeof(SCROLLINFO);
	  si.fMask = SIF_ALL;
	  cWnd = (HWND)GetWindowLong(hWnd,12);
	  GetScrollInfo(cWnd,SB_CTL,&si);
	  oldpos = si.nPos;

      switch (LOWORD(wParam))
      {
        case SB_LINEDOWN:
          si.nPos++;
          break;
        case SB_LINEUP:
          si.nPos--;
          break;
        case SB_PAGEDOWN:
          si.nPos += si.nPage;
          break;
        case SB_PAGEUP:
          si.nPos -= si.nPage;
          break;
        case SB_THUMBTRACK:
          si.nPos = si.nTrackPos;
		  if(si.nPos > (si.nMax-(int)si.nPage)) si.nPos = (si.nMax-(int)si.nPage);
	      else if(si.nPos < si.nMin) si.nPos = si.nMin;
          break;
        default:
		  break;
      }

      if(oldpos >= (si.nMax-2*(int)si.nPage) && (si.nPos >= (si.nMax-(int)si.nPage)+1))
      {
          si.nPos = si.nPos - 2*(si.nMax-(int)si.nPage);
      }
      else if(oldpos < (si.nMin+(int)si.nPage) && si.nPos < si.nMin)
      {
          si.nPos = si.nPos + 2*(si.nMax - si.nPage);
      }

	  si.fMask = SIF_POS; /* extra precaution so that only the position is reset */
	  SetScrollInfo(cWnd,SB_CTL,&si,TRUE);

	  titleid = GetWindowLong(hWnd,16);
	  icurrentrotation = titleid;
      /*now use half degree steps*/
      bondrotptr[titleid]->angle = ((float)si.nPos)/2;

	  /* update actual angle readout */
	  writebondrotvalue(titleid);

      theta = ((float)(si.nPos - oldpos))/2;
	  if ((int)(2*theta)) /* so windows only executes this CPU intensive code */
					  /* once, because case WM_HSCROLL is called for both */
					  /* botton down and button up */
	  {
		  dobondrotrouter(titleid,theta);
		  /* rotation done on float array entries*/
		  if(Lupdate && !Linhibiton)
		  { /*update from remote program: eg. dots by PROBE */
			  sprintf(word,"\""); /* ditto mark */
			  doupdate(1,word); /* MPCOUT.C */ /*980410*/
			  /* 1: deletes old dots before reloading them */
			  UpdateAppendedSets(); /*MAGEBBOX.c*/ /* 970905*/
		  }
		  rescalekinemage();  /* rescale rebuilds from float arrary*/
		  redrawvec();
	  }
	  SetFocus(hWnd);
	  break;
    default: break;
  }
  return(DefWindowProc(hWnd, message, wParam, lParam));
}
/*___HScrollWndProc()_______________________________________________________*/

/****creategrafbondrotBar()***********************************************/
void creategrafbondrotBar(int i)  /* <-MAGEBBOX/SetsinGrafWindow()*/
{
    RECT rect;
	int sheight;
    HWND eWindow;

    sheight = GetSystemMetrics(SM_CYHSCROLL) + 3 * fontverticalspace;


	/*FIRST DO THINGS IN TERMS OF MageWindow ITSELF */
    GetClientRect(MageWindow,&rect);

    /* Create the scroll window for this bondrot*/
    bondrotWindow[i] = CreateWindow(
        "MageHScrollClass",      /* class name						*/
        NULL,                    /* no text for window title bar	*/
        WS_CHILD | WS_CLIPSIBLINGS, /* Window style.	*/
        rect.right-RWIDTH,       /* horizontal position.			*/
        (i-1)*sheight,           /* vertical position				*/
        RWIDTH,                  /* width							*/
        sheight,                 /* height							*/
        MageWindow,              /* parent							*/
        (HMENU)(MAGEBONDROTID+i),/* window identifier				*/
        hInst,                   /* This instance owns this window. */
        NULL                     /* Pointer not needed.				*/
        );

    /* If window could not be created, return "failure" */
	if (!bondrotWindow[i]) return;

	/*This window class has 28 extra bytes of info*/
	SetWindowLong(bondrotWindow[i],0,0);    /*edit text control ID */
	SetWindowLong(bondrotWindow[i],4,0);	/*edit text handle */
	SetWindowLong(bondrotWindow[i],8,0);	/*scrollbar control ID */
	SetWindowLong(bondrotWindow[i],12,0);   /*scrollbar handle */
	SetWindowLong(bondrotWindow[i],16,0);   /*titleid */
	SetWindowLong(bondrotWindow[i],20,0);	/*functions */
	SetWindowLong(bondrotWindow[i],24,0);	/*another edit text control ID */
	SetWindowLong(bondrotWindow[i],28,0);   /*another edit text handle */

	/* Make the window visible; update its client area; and return "success" */
	ShowWindow(bondrotWindow[i], SW_SHOWNA);  /* Show the window */
	/* UpdateWindow(bondrotWindow[i]); */         /* Sends WM_PAINT message */


	/*NOW DEFINE RECT in terms of this bondrotWindow */
	GetClientRect(bondrotWindow[i],&rect);
	/* Create a text edit control.  */
	eWindow = CreateWindow(
		"STATIC",               /* See RegisterClassEx() call */
		NULL,                   /* Text for window title bar */
		WS_CHILD,               /* Window style. */
		rect.left,              /* horizontal position */
		rect.top+fontheight,    /* vertical position */
		rect.right,             /* width */
		rect.top+fontheight,    /* height */
		bondrotWindow[i],       /* parent */
		(HMENU)(MAGEBONDROTID+i+10),/* window identifier, each child needs its own*/
		hInst,                  /* This instance owns this window */
		NULL					/* Pointer not needed */
		);

	/* bondrotWindow must knows its child's id and handle */
	SetWindowLong(bondrotWindow[i],0,(unsigned long)(MAGEBONDROTID+i+10));
	SetWindowLong(bondrotWindow[i],4,(long)eWindow);
	/* If window could not be created, return "failure" */
	if (!eWindow) return;

	/* Make the window visible; update its client area */
	ShowWindow(eWindow, SW_SHOWNA);
	/* UpdateWindow(eWindow); */     /* Sends WM_PAINT message */

	/* Create another text edit control.  */
	eWindow = CreateWindow(
		"STATIC",                 /* See RegisterClassEx() call */
		NULL,                   /* Text for window title bar */
		WS_CHILD,               /* Window style. */
		rect.left,              /* horizontal position */
		rect.top+2*fontheight,    /* vertical position */
		rect.right,             /* width */
		rect.top+fontheight,    /* height */
		bondrotWindow[i],       /* parent */
		(HMENU)(MAGEBONDROTID+i+40), /* window identifier, each child needs its own*/
		hInst,                  /* This instance owns this window */
		NULL            /* Pointer not needed */
		);

	/* bondrotWindow must knows its child's id and handle */
	SetWindowLong(bondrotWindow[i],24,(unsigned long)(MAGEBONDROTID+i+40));
	SetWindowLong(bondrotWindow[i],28,(long)eWindow);
	/* If window could not be created, return "failure" */
	if (!eWindow) return;

	/* Make the window visible; update its client area */
	ShowWindow(eWindow, SW_SHOWNA);
	/* UpdateWindow(eWindow); */     /* Sends WM_PAINT message */


	/* create the scroll bar */
	/* this is a separate subroutine since resize would need to call it also*/
	if (!AddHScrollBar( bondrotWindow[i],
						MAGEBONDROTID+i+20,
						&rect,
						fontheight,
						-360,
						360,
						i)
	   )
	   return;
    /*now use half degree steps, so +-360 instead of +-180*/ 
	SetWindowLong(bondrotWindow[i],16,(long)i);  /* i th bondrot */

	writebondrotvalue(i); /* write values to screen */
	InvalidateRect(bondrotWindow[i],NULL,TRUE);
	return;
}
/*___creategrafbondrotBar()______________________________________________*/

/****AddHScrollBar()*********************************************************/
static int AddHScrollBar(HWND tWindow, int id, RECT *rect, int fontheight,
            int low, int high, int i)
{
  SCROLLINFO si;
  HWND sWindow;

  sWindow = CreateWindow(
		"SCROLLBAR",                        /* Scrollbar class			*/
		NULL,                               /* no title					*/
		WS_CHILD | WS_VISIBLE | SBS_HORZ,   /* Window style.			*/
		rect->left,                         /* horizontal position		*/
		rect->top+3*fontheight+1,           /* vertical position		*/
		rect->right - rect->left,           /* width					*/
		(fontheight+1)*2/3,                 /* height					*/
		tWindow,                            /* parent					*/

		(HMENU)id,                                 /* window identifier		*/
		hInst,                              /* This instance owns window */
		NULL                                /* Pointer not needed		*/
		);
  /* If window could not be created, return "failure" */
  if (!sWindow) return (0);

  /* frame window knows its child's id and handle */
  SetWindowLong(tWindow,8,(unsigned long)(id));
  SetWindowLong(tWindow,12,(long)sWindow);

  /* set starting values (not needed on resize, so low==high) */
  if (low != high)
  {
	  si.cbSize = sizeof(SCROLLINFO);
	  si.fMask = SIF_ALL;
	  si.nPage = (high-low)/36;
	  si.nMax = high+si.nPage;
	  si.nMin = low;
	  si.nPos = (int)(bondrotptr[i]->angle);
	  SetScrollInfo(sWindow,SB_CTL,&si,TRUE);
  }
  return(1);
}
/*___AddHScrollBar()________________________________________________________*/

/****resetgrafzoomBar()******************************************************/
void resetgrafzoomBar()
{
  SCROLLINFO si;
  char editbuf[10];

  si.cbSize = sizeof(SCROLLINFO);
  si.fMask = SIF_POS;
  si.nPos = (int)(100*zoom);

  SetScrollInfo(zoommvWindow,SB_CTL,&si,TRUE);

  sprintf(editbuf,"%4.2lf",zoom);                           /*zoom*/
  SendMessage((HWND)GetWindowLong(sWindow,4)
               ,WM_SETTEXT,0,(DWORD)editbuf);
}
/*___resetgrafzoomBar()_____________________________________________________*/

/****resetgrafztranBar()*****************************************************/
void resetgrafztranBar(int nztran)
{
  SCROLLINFO si;
  char editbuf[10];

  si.cbSize = sizeof(SCROLLINFO);
  si.fMask = SIF_POS;
  si.nPos = nztran;

  SetScrollInfo(ztranmvWindow,SB_CTL,&si,TRUE);

  sprintf(editbuf,"%d",nztran);
  SendMessage((HWND)GetWindowLong(ztranWindow,4)
               ,WM_SETTEXT,0,(DWORD)editbuf);

}
/*___resetgrafztranBar()____________________________________________________*/

/****resetgrafzclipBar()*****************************************************/
void resetgrafzclipBar(int shiftBar)
{
  SCROLLINFO si;
  char editbuf[10];

  si.cbSize = sizeof(SCROLLINFO);
  si.fMask = SIF_POS;
  si.nPos = shiftBar;

  SetScrollInfo(zslabmvWindow,SB_CTL,&si,TRUE);

  sprintf(editbuf,"%d",shiftBar);
  SendMessage((HWND)GetWindowLong(slabWindow,4)
               ,WM_SETTEXT,0,(DWORD)editbuf);
}
/*___resetgrafzclipBar()____________________________________________________*/

/*dummies for MAC routines called by general MAGE routines */
void   eraseztranvalue(){}
void   erasezclipvalue(){}
void   erasezoomvalue(){}
void   creategrafztranBar(){}
void   creategrafzclipBar(){}
void   creategrafzoomBar(){}
