#include "MAGE.h"
#include "MAGELIST.h"
#include "MAGEDLOG.h"
#include "MAGEMENU.h"
#include "MAGEFLAG.h"
#include "MAGEBBOX.h"
#include "MAGEANGL.h"
#include "MAGETABL.h"

#include <string.h>

/****DoMageDLOGreport()******************************************************/
void DoMageDLOGreport(int mode) /*reports contents of (char)alertstr*/
{
	/*This dialog box can abort program by closing main window*/
	if(mode>=2) ireturnflag=1;
	else ireturnflag = 0;

	DialogBox(hInst,"ALERT_DIALOG",MageWindow,AlertDialog);

	memset(alertstr,'\0',MAXALERTSTR);	/*clear alert report - optimized code*/
	memset(alertstr2,'\0',MAXALERTSTR);	/*clear alert report - optimized code*/
	memset(alertstr3,'\0',MAXALERTSTR);	/*clear alert report - optimized code*/

	if(ireturnflag==1)  /*abort program*/
	{
		Ltest = 0; /*test dialogs seem to have precedence over SC_CLOSE*/
		PostMessage(MageWindow,WM_SYSCOMMAND,SC_CLOSE,0);
		/*now go directly to the mainloop*/
		MainLoop();
	}
}
/*___DoMageDLOGreport()_______________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****AlertDialog()***********************************************************/
BOOL CALLBACK AlertDialog(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
  static int icanabort;
    switch (message)
    {
      case WM_INITDIALOG:
        SetDlgItemText(hDlg,MAGE_TEXT,(LPSTR)alertstr);
        SetDlgItemText(hDlg,MAGE_OPT1,(LPSTR)alertstr2);
		SetDlgItemText(hDlg,MAGE_OPT2,(LPSTR)alertstr3);
		if(ireturnflag==1)
		{
			SetDlgItemText(hDlg,MAGE_NO,"Abort Program");
			ireturnflag = 0;
			icanabort = 1;
		}
		else
		{
			SetDlgItemText(hDlg,MAGE_NO," ");
			icanabort = 0;
		}
        return(TRUE);
      case WM_COMMAND:
        switch (LOWORD(wParam))
        {
            case MAGE_OK:
                EndDialog(hDlg,0);
                return(FALSE);
            case MAGE_CANCEL:
                EndDialog(hDlg,0);
                return(FALSE);
			case MAGE_NO:
				if(icanabort)
				{
				  ireturnflag = 1; /*flag to close main window, end program*/
				}
				  EndDialog(hDlg,0);
				return(FALSE);
            default:
                EndDialog(hDlg,0);
                return(FALSE);
            }
        }
return(FALSE);
}
/*___DoMageDLOGreport()_____________________________________________________*/

/****DoMageinitDLOGreport()**************************************************/
void DoMageinitDLOGreport(void)
{
	ireturnflag=0;  /*This dialog box can abort program by closing main window*/
	DialogBox(hInst,"INTRO_DIALOG",MageWindow,INITIALDialog);
	if(ireturnflag==1) SendMessage(MageWindow,WM_SYSCOMMAND,SC_CLOSE,0);
		/*Send directly since not in master loop */
}
/*___DoMageinitDLOGreport()_________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****INITIALDialog()***********************************************************/
BOOL CALLBACK INITIALDialog(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
	  case WM_INITDIALOG:
		SetDlgItemText(hDlg,MAGE_TEXT,(LPSTR)alertstr);
		SetDlgItemText(hDlg,MAGE_OPT1,(LPSTR)alertstr2);
		return(TRUE);
	  case WM_COMMAND:
		switch (LOWORD(wParam))
		{
			case MAGE_OK:
				EndDialog(hDlg,0);
				return(FALSE);
			case MAGE_NO:
				ireturnflag = 1; /*flag to close main window, end program*/
					/*beware: not in main master loop yet!*/
				EndDialog(hDlg,0);
				return(FALSE);
			case MAGE_CANCEL:
				EndDialog(hDlg,0);
				return(FALSE);
			default:
				EndDialog(hDlg,0);
				return(FALSE);
		}
	  }
return(FALSE);
}
/*___INITIALDialog()________________________________________________________*/

/****DoconstructDialog()*****************************************************/
void DoconstructDialog()
{
    DialogBox(hInst,"CONSTRUCT_DIALOG",MageWindow,constructDialog);
}
/*___DoconstructDialog()____________________________________________________*/

/****constructDialog()*******************************************************/
BOOL CALLBACK constructDialog(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
  static int Lchoice;

  switch (message)
  {
    case WM_INITDIALOG:
        CheckRadioButton(hDlg,MAGE_RADIO1,MAGE_RADIO3,MAGE_RADIO1);
        Lchoice = 1;
        sprintf(numstr,"%.3f",distmeasure);
        SetDlgItemText(hDlg,MAGE_EDIT1,(LPSTR)numstr);
        sprintf(numstr,"%.3f",anglemeasure);
        SetDlgItemText(hDlg,MAGE_EDIT2,(LPSTR)numstr);
        sprintf(numstr,"%.3f",dihedralmeasure);
        SetDlgItemText(hDlg,MAGE_EDIT3,(LPSTR)numstr);
        sprintf(numstr,"%.3f",diststored);
        SetDlgItemText(hDlg,MAGE_EDIT4,(LPSTR)numstr);
        sprintf(numstr,"%.3f",anglestored);
        SetDlgItemText(hDlg,MAGE_EDIT5,(LPSTR)numstr);
        sprintf(numstr,"%.3f",dihedralstored);
        SetDlgItemText(hDlg,MAGE_EDIT6,(LPSTR)numstr);
        sprintf(numstr,"%.3f",distuser);
        SetDlgItemText(hDlg,MAGE_EDIT7,(LPSTR)numstr);
        sprintf(numstr,"%.3f",angleuser);
        SetDlgItemText(hDlg,MAGE_EDIT8,(LPSTR)numstr);
        sprintf(numstr,"%.3f",dihedraluser);
        SetDlgItemText(hDlg,MAGE_EDIT9,(LPSTR)numstr);
        CheckDlgButton(hDlg,MAGE_CHECK1,Lconstructdot);
        CheckDlgButton(hDlg,MAGE_CHECK2,LconstructMultiple); 
        CheckDlgButton(hDlg,MAGE_CHECK3,Lconstructprojection); 
        return(TRUE);
    case WM_COMMAND:
        switch (LOWORD(wParam))
        {
            case MAGE_RADIO1:
                CheckRadioButton(hDlg,MAGE_RADIO1,MAGE_RADIO3,MAGE_RADIO1);
                Lchoice = 1;
                return(TRUE);
            case MAGE_RADIO2:
                CheckRadioButton(hDlg,MAGE_RADIO1,MAGE_RADIO3,MAGE_RADIO2);
                Lchoice = 2;
                return(TRUE);
            case MAGE_RADIO3:
                CheckRadioButton(hDlg,MAGE_RADIO1,MAGE_RADIO3,MAGE_RADIO3);
                Lchoice = 3;
                return(TRUE);
            case MAGE_RADIO4:
                CheckRadioButton(hDlg,MAGE_RADIO1,MAGE_RADIO4,MAGE_RADIO4);
                Lchoice = 4;
                return(TRUE);
            case MAGE_CHECK1:
                Lconstructdot = !Lconstructdot;
                CheckDlgButton(hDlg,MAGE_CHECK1,Lconstructdot);
                return(TRUE);
            case MAGE_CHECK2:
                LconstructMultiple = !LconstructMultiple;
                CheckDlgButton(hDlg,MAGE_CHECK2,LconstructMultiple);
                return(TRUE);
            case MAGE_CHECK3:
                Lconstructprojection = !Lconstructprojection;
                CheckDlgButton(hDlg,MAGE_CHECK3,Lconstructprojection);
                return(TRUE);
            case MAGE_EDIT1:
            case MAGE_EDIT2:
            case MAGE_EDIT3:
               CheckRadioButton(hDlg,MAGE_RADIO1,MAGE_RADIO3,MAGE_RADIO1);
               Lchoice = 1;
               return(TRUE);
            case MAGE_EDIT4:
            case MAGE_EDIT5:
            case MAGE_EDIT6:
               CheckRadioButton(hDlg,MAGE_RADIO1,MAGE_RADIO3,MAGE_RADIO2);
               Lchoice = 2;
               return(TRUE);
            case MAGE_EDIT7:
            case MAGE_EDIT8:
            case MAGE_EDIT9:
               CheckRadioButton(hDlg,MAGE_RADIO1,MAGE_RADIO3,MAGE_RADIO3);
               Lchoice = 3;
               return(TRUE);

            case MAGE_OK:
                if(Lchoice == 1)
                {
                    GetDlgItemText(hDlg,MAGE_EDIT1,numstr,sizeof(numstr));
                    distconstruct = floatfromstr(numstr);
                    GetDlgItemText(hDlg,MAGE_EDIT2,numstr,sizeof(numstr));
                    angleconstruct = floatfromstr(numstr);
                    GetDlgItemText(hDlg,MAGE_EDIT3,numstr,sizeof(numstr));
                    dihedralconstruct = floatfromstr(numstr);
                    Lconstructperpendicular = 0;
                }
                if(Lchoice == 2)
                {
                    GetDlgItemText(hDlg,MAGE_EDIT4,numstr,sizeof(numstr));
                    distconstruct = floatfromstr(numstr);
                    GetDlgItemText(hDlg,MAGE_EDIT5,numstr,sizeof(numstr));
                    angleconstruct = floatfromstr(numstr);
                    GetDlgItemText(hDlg,MAGE_EDIT6,numstr,sizeof(numstr));
                    dihedralconstruct = floatfromstr(numstr);
					Lconstructperpendicular = 0;
                }
                if(Lchoice == 3)
                {
                    GetDlgItemText(hDlg,MAGE_EDIT7,numstr,sizeof(numstr));
                    distconstruct = floatfromstr(numstr);
                    distuser = distconstruct;
                    GetDlgItemText(hDlg,MAGE_EDIT8,numstr,sizeof(numstr));
                    angleconstruct = floatfromstr(numstr);
                    angleuser = angleconstruct;
                    GetDlgItemText(hDlg,MAGE_EDIT9,numstr,sizeof(numstr));
                    dihedralconstruct = floatfromstr(numstr);
                    dihedraluser = dihedralconstruct;
					Lconstructperpendicular = 0;
                }
                if(Lchoice == 4)
                {
                    Lconstructperpendicular = 1;
                }

                /*gets here when (Lconstructon && Lpoint>=4)*/
                doconstructline();    /*MAGEANGL.C*/
                /*stores points for 3 calls, then does construction on 4th*/
                /*called here to construct line, non-modal dialog, */ 
                /*as needed by UNIX*/
                /*point indicator left on until line actually constructed */
				drawmarker1listptr->on = 0; /*turn off point indicaters*/
				drawmarker2listptr->on = 0;
				drawmarker3listptr->on = 0;
                Lpoint = 0; /*clear this attempt to constructline */

                EndDialog(hDlg,0);
                return(FALSE);
            default: return(FALSE);
        }
  }
return(FALSE);
}
/*___constructDialog()______________________________________________________*/

/****DoSearchDialog()********************************************************/
void    DoSearchDialog()
{
 if(!ACTIVE_DLOG) 
 {
      cleargenericflags();  /*MAGEDLOG.c*/
	  Lsearched = 1; /*global, cycle until satisfied or quit*/
	  while(Lsearched)
      {
		  SearchDialog();       /*MAGEDLOG.c*/
		  DogenericDialog();    /*____DLOG.c*/
		  EndSearchDialog();    /*MAGEDLOG.c*/
		  if(Lcancel) break;
	  }

	  SetsinGrafWindow();   /*magebbox.c to turn markers on*/
	  if(Ltablepresent && Ltablesearch) {redrawtable();}/*000324*/
	  redrawvec();     /*MPCDRAW.C*/
 }
}
/*___DoSearchDialog()_______________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/

/****DoQuesDialog()**********************************************************/
void DoQuesDialog(void)
{
DialogBox(hInst,"QUESTION",MageWindow,QuesDialog);
}
/*___DoQuesDialog()_________________________________________________________*/

/****QuesDialog()************************************************************/
BOOL CALLBACK QuesDialog(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
    LPSTR textbuf;
    int j,Lwriteanswers,LstillOK;

    Lwriteanswers = 0;

    switch (message)
    {/*switch (message)*/
      case WM_INITDIALOG:
          for(j=0;j<=iQstring;j++) word[j] = Qstring[j];
          SetDlgItemText(hDlg,MAGE_EDIT2,(LPSTR)word);

          sprintf(word,"%d",nQuestion);
          SetDlgItemText(hDlg,MAGE_EDIT3,(LPSTR)word);
          SetDlgItemText(hDlg,MAGE_EDIT4,(LPSTR)grafselection[0]);
          SetDlgItemText(hDlg,MAGE_EDIT5,(LPSTR)grafselection[1]);
          sprintf(word,"%.3f",distmeasure);
          SetDlgItemText(hDlg,MAGE_EDIT6,(LPSTR)word);
          sprintf(word,"%.3f",anglemeasure);
          SetDlgItemText(hDlg,MAGE_EDIT7,(LPSTR)word);
          sprintf(word,"%.3f",dihedralmeasure);
          SetDlgItemText(hDlg,MAGE_EDIT8,(LPSTR)word);

          sprintf(word,"%s",thisanswer[nQuestion]);
          SetDlgItemText(hDlg,MAGE_EDIT1,(LPSTR)word);


         return(TRUE);
      case WM_COMMAND:
        switch (LOWORD(wParam))
        {/*switch(LOWORD(wParam))*/
            case MAGE_OPT1:
                Lgographics = 2;   /*just goes to current graphics window*/
                EndDialog(hDlg,0);
                return(FALSE);
            case MAGE_OK:      /*Accept*/
                GetDlgItemText(hDlg,MAGE_EDIT1,word,sizeof(word));

                for(j=0;j<MAXQCHAR;j++) thisanswer[nQuestion][j] = word[j];

                /*replace old answer (or ____...) with thisanswer in text field*/
                textbuf = (LPSTR)GetWindowLong(tWindow,TEXTHANDLE);
                LstillOK = 1; /*OK: real answer characters to write*/
                if(itextoffset>0) /*long global stores answer position*/
                itextoffset = itextoffset+3; /*step past bracket,star */
                for(j=0;j<MAXQCHAR;j++)
                { 
                    if(word[j] == '\0') LstillOK = 0;
                    if(LstillOK) textbuf[itextoffset+j] = word[j];
                    else textbuf[itextoffset+j] = '_';
                }
                if(Lwriteanswers) /*so can do this after new answer entered*/
                     writeoutput(7); /*MPCOUT.C calls writequesanswers()*/
                /*then do end stuff of MAGE_CANCEL*/
            case MAGE_CANCEL:
                Lgographics = 0;
                EndDialog(hDlg,0);
                return(FALSE);
            case MAGE_EDIT4:
                SetDlgItemText(hDlg,MAGE_EDIT1,(LPSTR)grafselection[0]);
                return(TRUE);
            case MAGE_EDIT5:
                SetDlgItemText(hDlg,MAGE_EDIT1,(LPSTR)grafselection[1]);
                return(TRUE);
            case MAGE_EDIT6:
                sprintf(word,"%.3f",distmeasure);
                SetDlgItemText(hDlg,MAGE_EDIT1,(LPSTR)word);
                return(TRUE);
            case MAGE_EDIT7:
                sprintf(word,"%.3f",anglemeasure);
                SetDlgItemText(hDlg,MAGE_EDIT1,(LPSTR)word);
                return(TRUE);
            case MAGE_EDIT8:
                sprintf(word,"%.3f",dihedralmeasure);
                SetDlgItemText(hDlg,MAGE_EDIT1,(LPSTR)word);
                return(TRUE);
        }/*switch(LOWORD(wParam))*/
    }/*switch (message)*/
    return(FALSE);
}
/*___QuesDialog()___________________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****DocolorshowDialog()*****************************************************/
void DocolorshowDialog(void)
{
	DialogBox(hInst,"COLORSHOW",MageWindow,colorshowDialog);
}
/*___DocolorshowDialog()____________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/


/****colorshowDialog()*******************************************************/
BOOL CALLBACK colorshowDialog(HWND hDlg, UINT message,WPARAM wParam,LPARAM lParam)
{
static  int isavecolor;

    switch (message)
    {/*switch (message)*/
      case WM_INITDIALOG:
          /*color stuff*/
          origlistcolor = pickedlistptr->color;
          interpretcolor(isavecolor); /* returns color in string word */

		  trialcolor = 0; /*global to hold new color value*/
		  origpointcolor = pickedpointptr->colorwidth & 31; /*hold point color also*/
		  if(Listcolordominant || origpointcolor==0)
		  {
			  trialcolor = origlistcolor;
			  dlog_radioAint = 1;
			  dlog_radioBint = 0;
		  }
		  else 
		  {
			  trialcolor = origpointcolor;
			  dlog_radioAint = 0;
			  dlog_radioBint = 1;
		  }
		  CheckDlgButton(hDlg,DLOG_RADIOA,dlog_radioAint);
		  CheckDlgButton(hDlg,DLOG_RADIOB,dlog_radioBint);

		  interpretcolor(trialcolor); /* returns color in string word */

          sprintf(word,"red");
          SendDlgItemMessage(hDlg,MAGE_TEXT,CB_ADDSTRING,0,(DWORD)word);
          sprintf(word,"green");
          SendDlgItemMessage(hDlg,MAGE_TEXT,CB_ADDSTRING,0,(DWORD)word);
          sprintf(word,"blue");
          SendDlgItemMessage(hDlg,MAGE_TEXT,CB_ADDSTRING,0,(DWORD)word);
          sprintf(word,"cyan");
          SendDlgItemMessage(hDlg,MAGE_TEXT,CB_ADDSTRING,0,(DWORD)word);
          sprintf(word,"yellow");
          SendDlgItemMessage(hDlg,MAGE_TEXT,CB_ADDSTRING,0,(DWORD)word);
          sprintf(word,"magenta");
          SendDlgItemMessage(hDlg,MAGE_TEXT,CB_ADDSTRING,0,(DWORD)word);
          sprintf(word,"white");
          SendDlgItemMessage(hDlg,MAGE_TEXT,CB_ADDSTRING,0,(DWORD)word);
          sprintf(word,"pink");
          SendDlgItemMessage(hDlg,MAGE_TEXT,CB_ADDSTRING,0,(DWORD)word);
          sprintf(word,"orange");
          SendDlgItemMessage(hDlg,MAGE_TEXT,CB_ADDSTRING,0,(DWORD)word);
          sprintf(word,"purple");
          SendDlgItemMessage(hDlg,MAGE_TEXT,CB_ADDSTRING,0,(DWORD)word);
          sprintf(word,"sky");
          SendDlgItemMessage(hDlg,MAGE_TEXT,CB_ADDSTRING,0,(DWORD)word);
          sprintf(word,"brown");
          SendDlgItemMessage(hDlg,MAGE_TEXT,CB_ADDSTRING,0,(DWORD)word);
          sprintf(word,"gray");
          SendDlgItemMessage(hDlg,MAGE_TEXT,CB_ADDSTRING,0,(DWORD)word);
          sprintf(word,"black");
          SendDlgItemMessage(hDlg,MAGE_TEXT,CB_ADDSTRING,0,(DWORD)word);
          sprintf(word,"gold");
          SendDlgItemMessage(hDlg,MAGE_TEXT,CB_ADDSTRING,0,(DWORD)word);
          sprintf(word,"yellowtint");
          SendDlgItemMessage(hDlg,MAGE_TEXT,CB_ADDSTRING,0,(DWORD)word);
          sprintf(word,"sea");
          SendDlgItemMessage(hDlg,MAGE_TEXT,CB_ADDSTRING,0,(DWORD)word);
          sprintf(word,"pinktint");
          SendDlgItemMessage(hDlg,MAGE_TEXT,CB_ADDSTRING,0,(DWORD)word);
          sprintf(word,"bluetint");
          SendDlgItemMessage(hDlg,MAGE_TEXT,CB_ADDSTRING,0,(DWORD)word);
          sprintf(word,"greentint");
          SendDlgItemMessage(hDlg,MAGE_TEXT,CB_ADDSTRING,0,(DWORD)word);
          sprintf(word,"hotpink");
          SendDlgItemMessage(hDlg,MAGE_TEXT,CB_ADDSTRING,0,(DWORD)word);
		  sprintf(word,"invisible");
		  SendDlgItemMessage(hDlg,MAGE_TEXT,CB_ADDSTRING,0,(DWORD)word);
		  sprintf(word,"lime");
		  SendDlgItemMessage(hDlg,MAGE_TEXT,CB_ADDSTRING,0,(DWORD)word);

          SendDlgItemMessage(hDlg,MAGE_TEXT,CB_SETCURSEL,trialcolor-1,0);
		  /* isavecolor-1 used b/c our naming is 1,2,3... and cell numbers */
		  /* are 0,1,2... */


          return(TRUE);
      case WM_COMMAND:
        switch (LOWORD(wParam))
        {
			case DLOG_RADIOA:
				CheckDlgButton(hDlg,DLOG_RADIOA,dlog_radioAint=1);
				CheckDlgButton(hDlg,DLOG_RADIOB,dlog_radioBint=0);
				if (trialcolor == 0) trialcolor = origlistcolor;
				colorshow_update(trialcolor,origpointcolor);
				break;
			case DLOG_RADIOB:
				CheckDlgButton(hDlg,DLOG_RADIOA,dlog_radioAint=0);
				CheckDlgButton(hDlg,DLOG_RADIOB,dlog_radioBint=1);
				if (trialcolor == 0) trialcolor = origpointcolor;
				colorshow_update(origlistcolor,trialcolor);
				break;
			case MAGE_TEXT:
				trialcolor = pickedlistptr->color =
					SendDlgItemMessage(hDlg,MAGE_TEXT,CB_GETCURSEL,0,0)+1;
				if (dlog_radioAint)
				{
					colorshow_update(trialcolor,origpointcolor);
				}
				else if (dlog_radioBint)
				{
					colorshow_update(origlistcolor,trialcolor);
				}
				break;
			case MAGE_CANCEL:
				colorshow_update(origlistcolor,origpointcolor);
                                   /*restore all lists for safety as well as point*/
				EndDialog(hDlg,0);
				return(FALSE);
			case MAGE_OK:
				Lpruneactive = 1; /*971129 for ChangeCheck*/

				if(dlog_radioAint) 
                                    colorshow_update(trialcolor,origpointcolor);
				else if(dlog_radioBint) 
                                    colorshow_update(origlistcolor,trialcolor);
				EndDialog(hDlg,0);
                return(FALSE);
        }
    }/*switch (message)*/
    return(FALSE);
}
/*___colorshowDialog()______________________________________________________*/

/****DopickshowDialog()******************************************************/
void DopickshowDialog(void)
{
	DialogBox(hInst,"OBJECT_DETAILS",MageWindow,pickshowDialog);
}
/*___DopickshowDialog()_____________________________________________________*/

/****pickshowDialog()********************************************************/
BOOL CALLBACK pickshowDialog(HWND hDlg, UINT message,WPARAM wParam,LPARAM lParam)
{
static  int inameshit;

static  int j,k,ibuttshit;
static  int Localdomgroup,Localdomsubgroup,Localneversubgroup;
static  int Localnobuttongroup,Localnobuttonsubgroup,Localnobuttonlist;
static  int ideletegroup,ideletesubgroup,ideletelist,ideleteshit;
static  int iunpickable,isavelisttype,idied,ichanged;

    switch (message)
	{/*switch (message)*/
      case WM_INITDIALOG:
          Localdomgroup = 0;
          Localdomsubgroup = 0;
          Localnobuttongroup = 0;
          Localnobuttonsubgroup = 0;
          Localnobuttonlist = 0;
          Localneversubgroup = 0;
          ibuttshit = 0; /*flag so not need to reset button unless...*/
          idied = 0;
          ideletegroup = 0;
          ideletesubgroup = 0;
          ideletelist = 0;
          ideleteshit = 0;
          inameshit = 0;

          /*name stuff*/
          SetDlgItemText(hDlg,MAGE_EDIT5,(LPSTR)pickedgrupptr->name);
          SetDlgItemText(hDlg,MAGE_EDIT6,(LPSTR)pickedsgrpptr->name);
          SetDlgItemText(hDlg,MAGE_EDIT7,(LPSTR)pickedlistptr->name);
          SetDlgItemText(hDlg,MAGE_EDIT8,(LPSTR)comstr);

          /*dominance and button making features*/
          if(pickedgrupptr->STATUS & DOMINANT)    Localdomgroup = 1;
          if(pickedgrupptr->STATUS & NOBUTTON)    Localnobuttongroup = 1;
          if(pickedsgrpptr->STATUS & DOMINANT)    Localdomsubgroup = 1;
          if(pickedsgrpptr->STATUS & NOBUTTON)    Localnobuttonsubgroup = 1;
          if(pickedsgrpptr->STATUS & NEVERSHOW)   Localneversubgroup = 1;
          if(pickedlistptr->STATUS & NOBUTTON)    Localnobuttonlist = 1;

          CheckDlgButton(hDlg,16,Localdomgroup);
          CheckDlgButton(hDlg,17,Localdomsubgroup);
          CheckDlgButton(hDlg,18,Localnobuttongroup);
          CheckDlgButton(hDlg,19,Localnobuttonsubgroup);
          CheckDlgButton(hDlg,20,Localnobuttonlist);
          CheckDlgButton(hDlg,21,Localneversubgroup);

          /*delete whole things*/
          CheckDlgButton(hDlg,22,ideletegroup);
          CheckDlgButton(hDlg,23,ideletesubgroup);
          CheckDlgButton(hDlg,24,ideletelist);

          /*pickable-unpickable*/
          isavelisttype = pickedpointptr->type; /*control int for this point*/
          if(   isavelisttype == 11 || isavelisttype == 13
             || isavelisttype ==  1 || isavelisttype ==  3) iunpickable = 1;
          else  iunpickable = 0;
          CheckDlgButton(hDlg,15,iunpickable);
          return(TRUE);

      case WM_COMMAND:
        switch (LOWORD(wParam))
        {/*switch(LOWORD(wParam))*/
            case MAGE_EDIT5:
            case MAGE_EDIT6:
            case MAGE_EDIT7:
            case MAGE_EDIT8:
                inameshit = 1; /*activity in a changeable name field*/
                return(TRUE);
            case 16:
                CheckDlgButton(hDlg,16,Localdomgroup=!Localdomgroup);
                ibuttshit=1;
                return(TRUE);
            case 17:
                CheckDlgButton(hDlg,17,Localdomsubgroup=!Localdomsubgroup);
                ibuttshit=1;
                return(TRUE);

            case 18:
                CheckDlgButton(hDlg,18,Localnobuttongroup=!Localnobuttongroup);
                ibuttshit=1;
                return(TRUE);

            case 19:
                CheckDlgButton(hDlg,19,Localnobuttonsubgroup=!Localnobuttonsubgroup);
                ibuttshit=1;
                return(TRUE);

            case 20:
                CheckDlgButton(hDlg,20,Localnobuttonlist=!Localnobuttonlist);
                ibuttshit=1;
                return(TRUE);

            case 21:
                CheckDlgButton(hDlg,21,Localneversubgroup=!Localneversubgroup);
                ibuttshit=1;
                return(TRUE);

            case 22:
                CheckDlgButton(hDlg,22,ideletegroup=!ideletegroup);
                ideleteshit=1;
                return(TRUE);

            case 23:
                CheckDlgButton(hDlg,23,ideletesubgroup=!ideletesubgroup);
                ideleteshit=1;
                return(TRUE);

            case 24:
                CheckDlgButton(hDlg,24,ideletelist=!ideletelist);
                ideleteshit=1;
                return(TRUE);

            case 15:
                if(isavelisttype >= 0 && isavelisttype <= 13) /*vectorlist*/
                {
                    CheckDlgButton(hDlg,15,iunpickable=!iunpickable);
                    return(TRUE);
                }

            case MAGE_CANCEL:
                EndDialog(hDlg,0);
                return(FALSE);
            case MAGE_OK:

                Lpruneactive = 1;

                if(iunpickable==0 && isavelisttype== 1) pickedpointptr->type =  0;
                if(iunpickable==0 && isavelisttype== 3) pickedpointptr->type =  2;
                if(iunpickable==0 && isavelisttype==11) pickedpointptr->type = 10;
                if(iunpickable==0 && isavelisttype==13) pickedpointptr->type = 12;
                if(iunpickable==1 && isavelisttype== 0) pickedpointptr->type =  1;
                if(iunpickable==1 && isavelisttype== 2) pickedpointptr->type =  3;
                if(iunpickable==1 && isavelisttype==10) pickedpointptr->type = 11;
                if(iunpickable==1 && isavelisttype==12) pickedpointptr->type = 13;

     if(ibuttshit==1)
     {
         /*clear STATUS */
         /*REMEMBER: except for ON/OFF  (&mask == ON flag)*/
         /*RESERVED FOR FUTURE WHEN STATUS MIGHT INCLUDE ON FLAG*/
         pickedgrupptr->STATUS = 0; 
         if(Localdomgroup == 1) 
            pickedgrupptr->STATUS = pickedgrupptr->STATUS | DOMINANT;
         if(Localnobuttongroup == 1) 
            pickedgrupptr->STATUS = pickedgrupptr->STATUS | NOBUTTON;
         pickedsgrpptr->STATUS = 0; 
         if(Localdomsubgroup == 1) 
            pickedsgrpptr->STATUS = pickedsgrpptr->STATUS | DOMINANT;
         if(Localnobuttonsubgroup == 1) 
            pickedsgrpptr->STATUS = pickedsgrpptr->STATUS | NOBUTTON;
         if(Localneversubgroup==1) 
            pickedsgrpptr->STATUS = pickedsgrpptr->STATUS | NEVERSHOW;
         pickedlistptr->STATUS = 0; 
         if(Localnobuttonlist ==1) 
            pickedlistptr->STATUS  = pickedlistptr->STATUS | NOBUTTON;
      }
      if(ideleteshit==1)
      {
          if(ideletegroup==1)
          {
              pickedgrupptr->on = pickedgrupptr->on-100;
                    /*very off for output*/
              pickedgrupptr->STATUS = pickedgrupptr->STATUS | DOMINANT | NOBUTTON;
                    /*nobutton && dominant: no buttons below*/
              pickedgrupptr->animate = 0;/*remove from any animation sequence*/
          }
          if(ideletesubgroup==1)
          {
              pickedsgrpptr->on = pickedsgrpptr->on-100;/*very off for output*/
              pickedsgrpptr->STATUS = pickedsgrpptr->STATUS | DOMINANT | NOBUTTON;
                  /*nobutton && dominant: no buttons below*/
          }
          if(ideletelist==1)
          {                      /*very off for output*/
             pickedlistptr->on = pickedlistptr->on-100;
             pickedlistptr->STATUS = pickedlistptr->STATUS | NOBUTTON; 
          }
       }
       if(inameshit==1)
       {
          GetDlgItemText(hDlg,MAGE_EDIT5,pickedgrupptr->name
                                   ,MAXNAMECHAR+1);
          /*MAGE.H: groupname[][MAXNAMECHAR+2] */
          if     (pickedgrupptr->name[0]=='*') pickedgrupptr->animate = 1;
          else if(pickedgrupptr->name[0]=='%') pickedgrupptr->animate = 2;
          else if(pickedgrupptr->name[0]==' ') pickedgrupptr->animate = 0;
          else
          {/*groupname is not to be fully left shifted*/
             /*pascal string, leave count in [0], shift off to right*/
             for (j=MAXNAMECHAR+1;j>=1;j--)
                 pickedgrupptr->name[j]=pickedgrupptr->name[j-1];
             pickedgrupptr->name[0]=' ';
             pickedgrupptr->animate = 0; /*no animation*/
          }
          pickedgrupptr->name[MAXNAMECHAR]='\0'; /*starts at 0 */
       
          GetDlgItemText(hDlg,MAGE_EDIT6,pickedsgrpptr->name
                                      ,MAXNAMECHAR+1);
          /*MAGE.H: setname[][MAXNAMECHAR+1] */
          pickedsgrpptr->name[MAXNAMECHAR]='\0'; /*starts at 0 */
                 
          GetDlgItemText(hDlg,MAGE_EDIT7,pickedlistptr->name
                                       ,MAXNAMECHAR+1);
          pickedlistptr->name[MAXNAMECHAR]='\0'; /*starts at 0 */
                  
          GetDlgItemText(hDlg,MAGE_EDIT8,comstr,sizeof(comstr));
                    /*comstr[MAXPTIDCHAR]='\0'; *//*starts at 0 */
          /*first see if the ptID has really been changed*/
          ichanged = 0;
          getptIDstring(word,pickedpointptr);
          k=-1;
          do
          {
             k++;
             if(word[k] != comstr[k]) ichanged = 1;
          }while(word[k] != '\0');
          if(ichanged)
          {/*ptID changed*/
             k=-1;do{k++;}while(word[k]!='\0');
             j=-1;do{j++;}while(comstr[j]!='\0');
             if(j <= k)
             {/*store in old location*/
                k=-1;
                do
                {
                   k++;
                   (com[(pickedpointptr->nameoffset)+(long)k]=comstr[k]);
                }while(comstr[k] != '\0');
             }
             else
             {/*make new place to store ptID*/
                /*store characters directly into giant character array */
		storeptIDstring(comstr, pickedpointptr);
             }/*make new place to store ptID*/
          }/*ptID changed*/  
       }
       idied = checksurvival(); /*MAGEUTIL.C*/
       /*always do checksurvival() to update vector prune deletions*/
       if(idied || ibuttshit || ideleteshit || inameshit)
       {
           SetsinGrafWindow();       /*MAGEBBOX.C*/
       }
       EndDialog(hDlg,0);
       return(FALSE);
    }/*switch(LOWORD(wParam))*/
  }/*switch (message)*/
  return(FALSE);
}
/*___pickshowDialog()_______________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****DogenericDialog()*******************************************************/
void    DogenericDialog()
{
	if(ACTIVE_DLOG==KINE_DLOG)
		DialogBox(hInst,"KINEMAGE",MageWindow,genericDialog);
	else if(ACTIVE_DLOG==STEREO_DLOG)
		DialogBox(hInst,"STEREO",MageWindow,genericDialog);
	else if(ACTIVE_DLOG==DRAWNEW_DLOG)
		DialogBox(hInst,"DRAW_NEW",MageWindow,genericDialog);
	else if(ACTIVE_DLOG==FIND_DLOG)
		DialogBox(hInst,"FIND",MageWindow,genericDialog);
	else if(ACTIVE_DLOG==VIEW_DLOG)
		DialogBox(hInst,"UPDATE_VIEW",MageWindow,genericDialog);
	else if(ACTIVE_DLOG==CHANGE_DLOG)
		DialogBox(hInst,"CHANGE",MageWindow,genericDialog);
	else if(ACTIVE_DLOG==FONT_DLOG)
		DialogBox(hInst,"GRAPHICS_FONTS",MageWindow,genericDialog);
	else if(ACTIVE_DLOG==POSTSCR_DLOG)
		DialogBox(hInst,"POSTSCRIPT",MageWindow,genericDialog);
	else if(ACTIVE_DLOG==RASTER3D_DLOG)
		DialogBox(hInst,"POSTSCRIPT",MageWindow,genericDialog);
	else if(ACTIVE_DLOG==DETAIL_DLOG)
		DialogBox(hInst,"DETAIL",MageWindow,genericDialog);
	else if(ACTIVE_DLOG==UPDATE_DLOG)
		DialogBox(hInst,"UPDATE_PARTS",MageWindow,genericDialog);
	else if(ACTIVE_DLOG==UPDATEPROBE_DLOG)
		DialogBox(hInst,"UPDATE_PROBE",MageWindow,genericDialog);
	else if(ACTIVE_DLOG==UPDATEPREKIN_DLOG)
		DialogBox(hInst,"UPDATE_PREKIN",MageWindow,genericDialog);
	else if(ACTIVE_DLOG==UPDATEPIPE_DLOG)
		DialogBox(hInst,"UPDATE_PIPE",MageWindow,genericDialog);
	else if(ACTIVE_DLOG==CONSTRUCTFIFTH_DLOG)
		DialogBox(hInst,"CONSTRUCTFIFTH",MageWindow,genericDialog);
	else if(ACTIVE_DLOG==ROTFORMAT_DLOG)
		DialogBox(hInst,"ROTFORMAT",MageWindow,genericDialog);
	else if(ACTIVE_DLOG==KIPOUTPUT_DLOG)
		DialogBox(hInst,"OPTION",MageWindow,genericDialog);
	else if(ACTIVE_DLOG==PICKMARKER_DLOG)
		DialogBox(hInst,"PICK_MARKERS",MageWindow,genericDialog);

	else if(ACTIVE_DLOG==MAKETEXTHELP_DLOG)
		DialogBox(hInst,"ALTERNATES",MageWindow,genericDialog);
	else if(ACTIVE_DLOG==MAKEKINEMAGE_DLOG)
		DialogBox(hInst,"ALTERNATES",MageWindow,genericDialog);

	else
		DialogBox(hInst,"MAGE",MageWindow,genericDialog);
}
/*___DogenericDialog()______________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/

/****genericDialog()*********************************************************/
BOOL CALLBACK genericDialog(HWND hDlg, UINT message, WPARAM wParam,LPARAM lParam)
{
 /* PC repeatedly calls this routine while dialog being processed		  */
 /* use logicals to control which features to set, thus derivative		  */
 /* dialog boxes with fewer features can be directly used by this routine */ 
 int ireturn = FALSE;

 switch (message)
 {/*switch (message)*/
    case WM_INITDIALOG:
        /* load initial values in dialog box	*/
        /* all DLOG have OK and CANCEL buttons, */
        /* titles have charstr set to defaults	*/
            SetDlgItemText(hDlg,DLOG_OK,(LPSTR)dlog_OKstr);
            SetDlgItemText(hDlg,DLOG_CANCEL,(LPSTR)dlog_cancelstr);
        if(Ldlog_option)
            SetDlgItemText(hDlg,DLOG_OPTION,(LPSTR)dlog_optionstr);
        
        if(Ldlog_subject)
            SetDlgItemText(hDlg,DLOG_SUBJECT,(LPSTR)dlog_subjectstr);

        if(Ldlog_paramA)
            SetDlgItemText(hDlg,DLOG_PARAMA,(LPSTR)dlog_paramAstr);
        if(Ldlog_paramB)
            SetDlgItemText(hDlg,DLOG_PARAMB,(LPSTR)dlog_paramBstr);
        if(Ldlog_paramC)
            SetDlgItemText(hDlg,DLOG_PARAMC,(LPSTR)dlog_paramCstr);
        if(Ldlog_paramD)
            SetDlgItemText(hDlg,DLOG_PARAMD,(LPSTR)dlog_paramDstr);

        if(Ldlog_textA)
            SetDlgItemText(hDlg, DLOG_TEXTA, (LPSTR)dlog_textAstr);
        if(Ldlog_textB)
            SetDlgItemText(hDlg, DLOG_TEXTB, (LPSTR)dlog_textBstr);
        if(Ldlog_textC)
            SetDlgItemText(hDlg, DLOG_TEXTC, (LPSTR)dlog_textCstr);
        if(Ldlog_textD)
            SetDlgItemText(hDlg, DLOG_TEXTD, (LPSTR)dlog_textDstr);

        if(Ldlog_checkA) CheckDlgButton(hDlg,DLOG_CHECKA,       dlog_checkAint);
        if(Ldlog_checkA) SetDlgItemText(hDlg,DLOG_CHECKA,(LPSTR)dlog_checkAstr);
        if(Ldlog_checkB) CheckDlgButton(hDlg,DLOG_CHECKB,       dlog_checkBint);
        if(Ldlog_checkB) SetDlgItemText(hDlg,DLOG_CHECKB,(LPSTR)dlog_checkBstr);
        if(Ldlog_checkC) CheckDlgButton(hDlg,DLOG_CHECKC,       dlog_checkCint);
        if(Ldlog_checkC) SetDlgItemText(hDlg,DLOG_CHECKC,(LPSTR)dlog_checkCstr);
        if(Ldlog_checkD) CheckDlgButton(hDlg,DLOG_CHECKD,       dlog_checkDint);
        if(Ldlog_checkD) SetDlgItemText(hDlg,DLOG_CHECKD,(LPSTR)dlog_checkDstr);
        if(Ldlog_checkE) CheckDlgButton(hDlg,DLOG_CHECKE,       dlog_checkEint);
        if(Ldlog_checkE) SetDlgItemText(hDlg,DLOG_CHECKE,(LPSTR)dlog_checkEstr);
        
        if(Ldlog_radioA) CheckDlgButton(hDlg,DLOG_RADIOA,       dlog_radioAint);
        if(Ldlog_radioA) SetDlgItemText(hDlg,DLOG_RADIOA,(LPSTR)dlog_radioAstr);
        if(Ldlog_radioB) CheckDlgButton(hDlg,DLOG_RADIOB,       dlog_radioBint);
        if(Ldlog_radioB) SetDlgItemText(hDlg,DLOG_RADIOB,(LPSTR)dlog_radioBstr);
        if(Ldlog_radioC) CheckDlgButton(hDlg,DLOG_RADIOC,       dlog_radioCint);
        if(Ldlog_radioC) SetDlgItemText(hDlg,DLOG_RADIOC,(LPSTR)dlog_radioCstr);
        if(Ldlog_radioD) CheckDlgButton(hDlg,DLOG_RADIOD,       dlog_radioDint);
        if(Ldlog_radioD) SetDlgItemText(hDlg,DLOG_RADIOD,(LPSTR)dlog_radioDstr);
        if(Ldlog_radioE) CheckDlgButton(hDlg,DLOG_RADIOE,       dlog_radioEint);
        if(Ldlog_radioE) SetDlgItemText(hDlg,DLOG_RADIOE,(LPSTR)dlog_radioEstr);

        if(Ldlog_info)   SetDlgItemText(hDlg,DLOG_INFO,(LPSTR)dlog_infostr);

		ireturn=(TRUE); /*stay under DLOG control*/
	break;
	case WM_COMMAND:
		switch (LOWORD(wParam))
		{/*switch (LOWORD(wParam))*/
			case DLOG_OK: /* end dialog, using current values*/
				Ldlog_OKHIT = 1; /*do standard thing */
				Ldlog_cancelHIT = 0;
				Ldlog_optionHIT = 0;
				Lcancel = 0;
				EndDialog(hDlg,0);
				ireturn=(FALSE);
			break;
			case DLOG_CANCEL: /* end dialog, do not change values */
				Ldlog_cancelHIT = 1; /* take no action */
				Ldlog_OKHIT = 0;
				Ldlog_optionHIT = 0;
				Lcancel = 1;
				EndDialog(hDlg,0);
				ireturn=(FALSE);
			break;
			case DLOG_OPTION: /* end dialog, do optional thing */
				if(Ldlog_option)
				{
					Ldlog_optionHIT = 1;
					Ldlog_cancelHIT = 0;
					Ldlog_OKHIT = 0;
					Lcancel = 0;
					EndDialog(hDlg,0);
					ireturn=(FALSE);
				}
				else ireturn=(TRUE);
			break;
			case DLOG_INFO:
				if (Ldlog_info)
					GetDlgItemText(hDlg,DLOG_INFO,dlog_infostr
											,sizeof(dlog_infostr));
				ireturn=(TRUE);
			break;
			case DLOG_PARAMA: /* get value as text, do not translate */
				if(Ldlog_paramA)
					GetDlgItemText(hDlg,DLOG_PARAMA,dlog_paramAstr
											,sizeof(dlog_paramAstr));
				ireturn=(TRUE); /*stay under DLOG control*/
			break;
			case DLOG_PARAMB: /* get value as text, do not translate */
				if(Ldlog_paramB)
					GetDlgItemText(hDlg,DLOG_PARAMB,dlog_paramBstr
											,sizeof(dlog_paramBstr));
				ireturn=(TRUE);
			break;
			case DLOG_PARAMC: /* get value as text, do not translate */
				if(Ldlog_paramC)
					GetDlgItemText(hDlg,DLOG_PARAMC,dlog_paramCstr
											,sizeof(dlog_paramCstr));
				ireturn=(TRUE);
			break;
			case DLOG_PARAMD: /* get value as text, do not translate */
				if(Ldlog_paramD)
					GetDlgItemText(hDlg,DLOG_PARAMD,dlog_paramDstr
											,sizeof(dlog_paramDstr));
				ireturn=(TRUE);
			break;

         case DLOG_CHECKA: /* toggle value */
				if(Ldlog_checkA)
					CheckDlgButton(hDlg,DLOG_CHECKA,dlog_checkAint
												  =!dlog_checkAint);
				ireturn=(TRUE);
			break;
			case DLOG_CHECKB: /* toggle value */
				if(Ldlog_checkB)
					CheckDlgButton(hDlg,DLOG_CHECKB,dlog_checkBint
												  =!dlog_checkBint);
				ireturn=(TRUE);
			break;
			case DLOG_CHECKC: /* toggle value */
				if(Ldlog_checkC)
					CheckDlgButton(hDlg,DLOG_CHECKC,dlog_checkCint
												  =!dlog_checkCint);
				ireturn=(TRUE);
			break;
			case DLOG_CHECKD: /* toggle value */
				if(Ldlog_checkD)
					CheckDlgButton(hDlg,DLOG_CHECKD,dlog_checkDint
												  =!dlog_checkDint);
				ireturn=(TRUE);
			break;
			case DLOG_CHECKE: /* toggle value */
				if(Ldlog_checkE)
					CheckDlgButton(hDlg,DLOG_CHECKE,dlog_checkEint
												  =!dlog_checkEint);
				ireturn=(TRUE);
			break;

			case DLOG_RADIOA: /* set value on, turn other radios off */
				if(Ldlog_radioA)
					CheckDlgButton(hDlg,DLOG_RADIOA,dlog_radioAint=1);
				if(Ldlog_radioB)
					CheckDlgButton(hDlg,DLOG_RADIOB,dlog_radioBint=0);
				if(Ldlog_radioC)
					CheckDlgButton(hDlg,DLOG_RADIOC,dlog_radioCint=0);
				if(Ldlog_radioD)
					CheckDlgButton(hDlg,DLOG_RADIOD,dlog_radioDint=0);
				if(Ldlog_radioE)
					CheckDlgButton(hDlg,DLOG_RADIOE,dlog_radioEint=0);
				ireturn=(TRUE);
			break;
			case DLOG_RADIOB: /* set value on, turn other radios off */
				if(Ldlog_radioA)
					CheckDlgButton(hDlg,DLOG_RADIOA,dlog_radioAint=0);
				if(Ldlog_radioB)
					CheckDlgButton(hDlg,DLOG_RADIOB,dlog_radioBint=1);
				if(Ldlog_radioC)
					CheckDlgButton(hDlg,DLOG_RADIOC,dlog_radioCint=0);
				if(Ldlog_radioD)
					CheckDlgButton(hDlg,DLOG_RADIOD,dlog_radioDint=0);
				if(Ldlog_radioE)
					CheckDlgButton(hDlg,DLOG_RADIOE,dlog_radioEint=0);
				ireturn=(TRUE);
			break;
			case DLOG_RADIOC: /* set value on, turn other radios off */
				if(Ldlog_radioA)
					CheckDlgButton(hDlg,DLOG_RADIOA,dlog_radioAint=0);
				if(Ldlog_radioB)
					CheckDlgButton(hDlg,DLOG_RADIOB,dlog_radioBint=0);
				if(Ldlog_radioC)
					CheckDlgButton(hDlg,DLOG_RADIOC,dlog_radioCint=1);
				if(Ldlog_radioD)
					CheckDlgButton(hDlg,DLOG_RADIOD,dlog_radioDint=0);
				if(Ldlog_radioE)
					CheckDlgButton(hDlg,DLOG_RADIOE,dlog_radioEint=0);
				ireturn=(TRUE);
			break;
			case DLOG_RADIOD: /* set value on, turn other radios off */
				if(Ldlog_radioA)
					CheckDlgButton(hDlg,DLOG_RADIOA,dlog_radioAint=0);
				if(Ldlog_radioB)
					CheckDlgButton(hDlg,DLOG_RADIOB,dlog_radioBint=0);
				if(Ldlog_radioC)
					CheckDlgButton(hDlg,DLOG_RADIOC,dlog_radioCint=0);
				if(Ldlog_radioD)
					CheckDlgButton(hDlg,DLOG_RADIOD,dlog_radioDint=1);
				if(Ldlog_radioE)
					CheckDlgButton(hDlg,DLOG_RADIOE,dlog_radioEint=0);
				ireturn=(TRUE);
			break;
			case DLOG_RADIOE: /* set value on, turn other radios off */
				if(Ldlog_radioA)
					CheckDlgButton(hDlg,DLOG_RADIOA,dlog_radioAint=0);
				if(Ldlog_radioB)
					CheckDlgButton(hDlg,DLOG_RADIOB,dlog_radioBint=0);
				if(Ldlog_radioC)
					CheckDlgButton(hDlg,DLOG_RADIOC,dlog_radioCint=0);
				if(Ldlog_radioD)
					CheckDlgButton(hDlg,DLOG_RADIOD,dlog_radioDint=0);
			    if(Ldlog_radioE)
					CheckDlgButton(hDlg,DLOG_RADIOE,dlog_radioEint=1);
				ireturn=(TRUE);
			break;

		}/*switch (LOWORD(wParam))*/
  }/*switch (message)*/
  return(ireturn);
}
/*___genericDialog()________________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
