#include "MAGE.h"
#include "MAGELIST.h"
#include "MAGETABL.h"
#include <winbase.h>  /*970605 for timer*/

/*Real difference of philosophy between Mac and PC here !!! */
/*Mac rotations by mouse movement are keep local within routine DRAWgraf()*/
/* The PC has nothing equivalent to Drawgraf, all mouse movements are */
/*managed back at the eventhandler stage of MPCMAIN.C in GrafWndProc()*/
/* So the decision points of , for instance, levelofdetail based on */
/*updaterate are quite different */
/*MAGEDRAW/drawvec as common code, tries to smooth out the differences*/

/****redrawvec()************************************************************/
void redrawvec(void)
{
	paintaux(DC);  /*DC from makenewDC() */
	SetFocus(gWindow);
}
/*___redrawvec()___________________________________________________________*/

/****paintaux()*************************************************************/
void paintaux(HDC DC)
{
	RECT rect;
	long nowticks, oldticks;

  if(!Initialized) return;

  if (IsIconic(gWindow)==0) /*zero if window is not iconic*/
  {/*window is not iconic*/
    do 
    {/*while(Lrecalculate);*/
      if (!hasnewDC) makenewDC();
	  GetClientRect(gWindow,&rect);

	  nowticks = theclockcount(); /*MPCMAIN.C*/
	  predrawticks = (nowticks - icountticks);
	  icountticks = nowticks;
	  oldticks = nowticks;

      /*revision930215 .toy, kaleidoscope, 2-D point plotting*/
      if(Lplotonly)   Lerase = FALSE;
      else            Lerase = TRUE;
      if(Lfirstcall){ Lerase = TRUE; Lfirstcall = FALSE; }
      if(Lerase)
	  {
          if(Lwhitebkg) FillRect(newDC,&rect,(HBRUSH)GetStockObject(WHITE_BRUSH));
          else          FillRect(newDC,&rect,(HBRUSH)GetStockObject(BLACK_BRUSH));
	  }
      cDC = newDC; /*newDC is the offscreen bitmap */
            /* DC is the graphics window bitmap */
      Lrecalculate = 0;
      drawvec();   /* writes to cDC */

	  nowticks = theclockcount(); /*MPCMAIN.C*/

	  BitBlt(DC,0,0,GWIDTH,GHEIGHT,newDC,0,0,SRCCOPY);

      /*DC is the Display Context of the graphics window,*/
      /* newDC == cDC is offscreen bitmap*/

	  nowticks = theclockcount(); /*MPCMAIN.C*/
	  postcopyticks = (nowticks - icountticks);
	  icountticks = nowticks;

	  updaterate = (float)(1000.0/(nowticks-oldticks));
	  mousetickrate = updaterate;
	  if(Ldetail==1) fullupdaterate = updaterate;

	  if(Lrecalculate) rescalekinemage();    /*MAGEINPT.C*/
    }while(Lrecalculate);
  }/*window is not iconic*/
}
/*___paintaux()___________________________________________________________*/

/****makenewDC()*************************************************************/
void makenewDC()
{
  RECT rect;
  /*HDC DC, newDC;*/ /*in common*/

  if (gWindow == 0) return; /* not yet initialized */
  DC = GetDC(gWindow);  /*this has to be balanced by ReleaseDC(DC)*/
  GetClientRect(gWindow,&rect);
  if (hasnewDC) destroynewDC();
  newDC = CreateCompatibleDC(DC);  /*destroy with DeleteDC(newDC) */
  newBitmap = CreateCompatibleBitmap(DC,rect.right,rect.bottom);
  defBitmap = (HBITMAP)SelectObject(newDC,newBitmap); /*def_ault_Bitmap*/
  /*defBitmap is the OLD object, newBitmap is now active */
  /*in destroynewDC(), defBitmap is reselected, so newBitmap becomes*/
  /* selected_out and can be safely destroyed */
  /* SetBkColor(newDC,RGB(0,0,0)); */
  SetBkMode(newDC,TRANSPARENT);

      setpalette(DC);     /*920717 dcr*/
      setpalette(newDC);  /*920717 dcr*/

  hasnewDC = 1;
}
/*___makenewDC()_________________________________________________________*/

/****destroynewDC()*******************************************************/
void destroynewDC()
{
  if (hasnewDC)
  {
    SelectObject(newDC,defBitmap); /*defBitmap selected so */
    DeleteObject(newBitmap);  /*newBitmap can be deleted */
    DeleteDC(newDC);  /*newBitmap selected out, so can delete */
    ReleaseDC(gWindow, DC); /*balances GetDC*/
  }
  hasnewDC = 0;
}
/*___destroynewDC()_______________________________________________________*/

/****setdrawcolorbrush()***************************************************/
void setdrawcolorbrush(int ipenx, int ipeny, int icolorit)
{
    ipenx = ipenx;
    ipeny = ipeny;
    if (icolorit > 255) oldBrush = (HBRUSH)SelectObject(cDC,
        newBrush=CreateSolidBrush(
            RGB((BYTE)(255),
                (BYTE)(255),
                (BYTE)(255) )));
    else oldBrush = (HBRUSH)SelectObject(cDC,
         newBrush = CreateSolidBrush(PALETTEINDEX(icolorit)));
    DeleteObject(oldBrush);
}
/*___setdrawcolorbrush()____________________________________________________*/

/****myGetEntryColor()*****************common name: MAC & PC**************/
void    myGetEntryColor(int icolor)
{
    /*GetEntryColor(MagePalette, icolor,  &rgbColor); */

	rgbColor.red   = (lpPalette->palPalEntry[icolor].peRed)*256;
	rgbColor.green = (lpPalette->palPalEntry[icolor].peGreen)*256;
	rgbColor.blue  = (lpPalette->palPalEntry[icolor].peBlue)*256;

	/* this may not be right for gray palette*/
}
/*___myGetEntryColor()___________________________________________________*/

/****stringtoscreen()********************common name: MAC & PC************/
void stringtoscreen(char *s, int x, int y)
{
	TEXTMETRIC tm;
	static LOGFONT lf;
    
	/*NOTE: fontheight set by SystemFontSize() call when MAGE starts */
    if(infofontsize!=0 && infofontsize!=fontverticalspace)
    {/*not default text, have to build special font*/
        DeleteObject(SelectObject(cDC,GetStockObject(SYSTEM_FONT)));
        GetTextMetrics(cDC,&tm);
        lf.lfHeight = infofontsize;
        DeleteObject(SelectObject(cDC,CreateFontIndirect(&lf)));
           /*deletes previous object, but brings in new font*/
	}

    if(Lwhitebkg) SetTextColor(cDC,PALETTEINDEX(0) );  /*black*/
    else          SetTextColor(cDC,PALETTEINDEX(207) );  /*white4 920801*/

	SetTextAlign(cDC, TA_UPDATECP | TA_BOTTOM);
	MoveToEx(cDC,x,y,NULL);

	TextOut(cDC,x,y,s,strlen(s));      /*920608 dcr*/
    if(infofontsize!=0 && infofontsize!=fontverticalspace)
    {
        DeleteObject(SelectObject(cDC,GetStockObject(SYSTEM_FONT)));
           /*deletes previous object*/
    }
}
/*___stringtoscreen()_______________________________________________________*/

/****labeltoscreen()**********************common name: MAC & PC**************/
void labeltoscreen(char *s, int x, int y, int icolorit)
{
static LOGFONT lf;
TEXTMETRIC tm;
      /*NOTE: fontheight set by SystemFontSize() call when MAGE starts */
      if(labelsfontsize!=0 && labelsfontsize!=fontverticalspace)
      {/*not default text, have to build special font*/
          DeleteObject(SelectObject(cDC,GetStockObject(SYSTEM_FONT)));
          GetTextMetrics(cDC,&tm);
          lf.lfHeight = labelsfontsize;
          DeleteObject(SelectObject(cDC,CreateFontIndirect(&lf)));
          /*deletes previous object, but brings in new font*/
      }
      SetTextColor(cDC,PALETTEINDEX(icolorit) );
      SetTextAlign(cDC, TA_UPDATECP | TA_BOTTOM);
      MoveToEx(cDC,x,y,NULL);
      TextOut(cDC,x,y,s,strlen(s));
      if(labelsfontsize!=0 && labelsfontsize!=fontverticalspace)
      {
         DeleteObject(SelectObject(cDC,GetStockObject(SYSTEM_FONT)));
         /*deletes previous object*/
      }
}
/*___labeltoscreen()________________________________________________________*/

/****wordstoscreen()***********************common name: MAC & PC*************/
void    wordstoscreen(char commentstr[256],int ix,int iy,int icolorit)
{                          /* for labels */ /*PC has to set color */
	POINT xy;	/* changed from DWORD to POINT on 97 0706, MoveToEx calls changed */
				/* from using HIWORD and LOWORD to .x and .y of the POINT struct  */
    HFONT   hFont,hhFont;
    TEXTMETRIC tm;

	static LOGFONT lf;
    int   j,k,kk,n,lineheightnow,i;
    short Thisfont,Thissize,Thisface;
    char szFaceName[LF_FACESIZE]; /* LF_FACESIZE == 32 !?*/

	Thisfont = commentstr[0];
    Thisface = commentstr[1];
    Thissize = commentstr[2];
    Thisface = Thisface; /*dummy: never use this in PC routine*/

    lineheightnow = fontverticalspace;
    if(   (wordsfontsize!=0 && wordsfontsize!=fontverticalspace)
       || (Thisfont!=0 && Thisfont!= fontverticalspace)         )
    {/*not default text, have to build special font*/
        /*SystemFontSize();*/ /*mpczbar.c : fontheight, fontverticalspace*/
        hFont = (HFONT)GetStockObject(SYSTEM_FONT);
        DeleteObject(SelectObject(cDC,hFont));
        GetTextMetrics(cDC,&tm);
		/*NOTE: LOGFONT and TEXTMETRIC only have a few fields in common */
        /*LOGFONT lf is declared static so is initialized to NULL & 0s */
        /* this seems to let the font be set by defaults */

        GetTextFace(cDC, sizeof szFaceName, szFaceName);

        lf.lfHeight = wordsfontsize;
        if(Thissize>0) lf.lfHeight = Thissize;

        hhFont = CreateFontIndirect(&lf);
        DeleteObject(SelectObject(cDC,hhFont));  /*deletes previous object*/
        lineheightnow = lf.lfHeight + tm.tmExternalLeading;
    }
    SetTextColor(cDC,PALETTEINDEX(icolorit) );

	SetTextAlign(cDC, TA_UPDATECP | TA_BOTTOM);

	/*NOW TextOut will start at "current position" and update it afterwards*/
	/*Text will be aligned at bottom left, i.e Mac-like */
	/*NOW must MoveToEx current position, since TextOut now ignores x,y fields*/

	MoveToEx(cDC, ix, iy, NULL);

    k=3;
    for(j=3;j<=255;j++)
    {/*loop over all j characters*/
        kk = j;
        /*if(commentstr[j]=='\\')        */
        /*{                              */
        /*  TextOut(cDC,x,y,s,strlen(s));*/
        /*  DrawText(commentstr,k,kk-k); */ /*clean out earlier*/
        /*  TextFont(23);                */
        /*  DrawText(commentstr,j+1,1);  */ /*draw symbol*/
        /*  TextFont(myfont);            */
        /*  j=j+2;                       */
        /*  k=j;                         */
        /*  kk=j;                        */
        /*}                              */
        /*else if(commentstr[j]=='\015') */
        
        if(commentstr[j]=='\\')  commentstr[j] = ' '; /*make a blank*/
        else if(commentstr[j]=='\r'||commentstr[j]=='\n')
        {
            if(commentstr[j-1]!='\r'&&commentstr[j-1]!='\n')
            {/*only do first of a CRLF pair*/
                n++;
                kk = j-1;
                for(i=0;i<=kk-k;i++) word[i]=commentstr[k+i];
                word[i]='\0';
                TextOut(cDC,ix,iy,word,strlen(word));

                iy=iy + lineheightnow;  /*fontverticalspace;*/
                MoveToEx(cDC, ix, iy, NULL);
            }
            k = j+1  ; /*step ahead to next possible character*/
        }
        else if(commentstr[j]=='{')
        {
			n++;
			kk = j-1;
            for(i=0;i<=kk-k;i++) word[i]=commentstr[k+i];
            word[i]='\0';
            TextOut(cDC,ix,iy,word,strlen(word));
            GetCurrentPositionEx(cDC, &xy);
            MoveToEx(cDC, xy.x, xy.y+lineheightnow/3, NULL);
            k = j+1  ; /*step ahead to next possible character*/
        }
        else if(commentstr[j]=='}')
        {
			n++;
            kk = j-1;
            for(i=0;i<=kk-k;i++) word[i]=commentstr[k+i];
            word[i]='\0';
            TextOut(cDC,ix,iy,word,strlen(word));
            GetCurrentPositionEx(cDC, &xy);
            MoveToEx(cDC, xy.x, xy.y-lineheightnow/3, NULL);
            k = j+1  ; /*step ahead to next possible character*/
        }
      
        else if(commentstr[j] == '\0')
        {
            break;
        }
    }/*loop over all j characters*/
    if(k<kk)
    {/*chars still in commentstr[] buffer*/
       for(i=0;i<=kk-k-1;i++) word[i]=commentstr[k+i];
           word[i++]='\0';
           TextOut(cDC,ix,iy,word,strlen(word));
    }
    if(   (wordsfontsize!=0 && wordsfontsize!=fontverticalspace)
       || (Thisfont!=0 && Thisfont!= fontverticalspace)         )
    {
        hFont = (HFONT)GetStockObject(SYSTEM_FONT);
        DeleteObject(SelectObject(cDC,hFont));   /*deletes previous object*/
    }
}
/*___wordstoscreen__________________________________________________________*/

/****killzoneonscreen()********************************************************/
void killzoneonscreen(void) /*990211*/
{
        setdrawcolorpen(2,2,3); /*draw blue, unfilled, circle*/
	    setdrawcolorbrush(2,2,3); /*????*/

        killradius = 20;
	    Ellipse(cDC, mousexold  - killradius, mouseyold  - killradius,
		        mousexold  + killradius, mouseyold  + killradius );
}
/*___killzoneonscreen()_______________________________________________________*/

/****balltoscreen()***************************common name: MAC & PC**********/
void balltoscreen(int xplace,int yplace,int idisk,int intradius
				 ,int ipen,int icolor,int type)
{
  int    iradius, inner, outer;

          iradius = intradius; /*converts int to short for Mac*/      

  if(idisk == 5) 
  {/*keep ultimate capping disk from obscuring highlight on penutimate disk*/
      if(iradius == 2) iradius = 1; /*2: drop to 1*/
	  else if(iradius <=1) iradius = -1; /*-1: don't draw*/
  }
  if(iradius >= 0)
  {/*draw disk of finite radius*/
				setdrawcolorbrush(ipen, ipen, icolor);

				Ellipse(cDC         , xplace  - iradius
									, yplace  - iradius
									, xplace  + iradius + ipen
									, yplace  + iradius + ipen );
  }
  if(type==1 &&(idisk == 0 || idisk == 4)) /*highlight on penultimate disk*/
  {/*highlight*/
    /*either pure disk or next-to-top disk of fudged space-fill stacked disks*/ 
    /*adjust iradius for the highlight*/
    if(idisk == 0)
    {
        /*iradius = iradius/2;*/ /*pure single disk, old case*/
        outer = (9*iradius)/20;
        inner = outer/2;
    }
	else if(idisk == 4)
    {
        /*highlight on annulus made by penultimate disk*/
        outer = (9*iradius)/12; /*radius of base disk already reduced*/
        inner = outer/2;
    }
    if( (outer - inner) <= 1) 
	{/*need to adjust to keep highlight visible*/
        if( (outer - inner) <= 0) outer = inner;
        inner = inner-1; /*effectively increase highlight size*/
    }
				setdrawcolorpen(ipen, ipen, 256);  /*icolor>255==white*/
				setdrawcolorbrush(ipen, ipen, 256);  /*icolor>255==white*/
	/*DeleteObject(SelectObject(cDC,GetStockObject(NULL_PEN))); */
				Ellipse(cDC         , xplace - outer
									, yplace - outer
									, xplace - inner
									, yplace - inner );
    /*restore working color*/
				setdrawcolorpen(ipen, ipen, icolor);
				setdrawcolorbrush(ipen, ipen, icolor);
  }/*highlight*/
}
/*___balltoscreen___________________________________________________________*/

/****TBstereo_balltoscreen()**************************************/
void TBstereo_balltoscreen(int xplace,int yplace,int idisk,int intradius
                 ,int ipen,int icolor,int type)
{
  int  xiradius, xinner, xouter;  
  int  yiradius, yinner, youter;             

  xiradius = intradius;
  yiradius = intradius/2;      

  if(idisk == 5) 
  {/*keep ultimate capping disk from obscuring highlight on penutimate disk*/
      if(xiradius == 2) xiradius = 1; /*2: drop to 1*/
      else if(xiradius <=1) xiradius = -1; /*-1: don't draw*/
      if(yiradius == 2) yiradius = 1; /*2: drop to 1*/
      else if(yiradius <=1) yiradius = -1; /*-1: don't draw*/
  }
  if(yiradius >= 0) /*y is the smaller*/
  {/*draw disk of finite radius*/
		setdrawcolorbrush(ipen, ipen, icolor);

		Ellipse(cDC         , xplace  - xiradius
							, yplace  - yiradius
							, xplace  + xiradius + ipen
							, yplace  + yiradius + ipen );
  }
  if(type==1 &&(idisk == 0 || idisk == 4)) /*highlight on penultimate disk*/
  {/*highlight*/
    /*either pure disk or next-to-top disk of fudged space-fill stacked disks*/ 
    /*adjust iradius for the highlight*/
    if(idisk == 0)
    {
        /*iradius = iradius/2;*/ /*pure single disk, old case*/
        xouter = (9*xiradius)/20;
        xinner = xouter/2;
        youter = (9*yiradius)/20;
        yinner = youter/2;
    }
    else if(idisk == 4)
    {
        /*highlight on annulus made by penultimate disk*/
        xouter = (9*xiradius)/12; /*radius of base disk already reduced*/
        xinner = xouter/2;
        youter = (9*yiradius)/12; /*radius of base disk already reduced*/
        yinner = youter/2;
    }
    if( (xouter - xinner) <= 1) 
    {/*need to adjust to keep highlight visible*/
        if( (xouter - xinner) <= 0) xouter = xinner;
        xinner = xinner-1; /*effectively increase highlight size*/
    }
    if( (youter - yinner) <= 1) 
    {/*need to adjust to keep highlight visible*/
        if( (youter - yinner) <= 0) youter = yinner;
        yinner = yinner-1; /*effectively increase highlight size*/
    }

	setdrawcolorpen(ipen, ipen, 256);  /*icolor>255==white*/
	setdrawcolorbrush(ipen, ipen, 256);  /*icolor>255==white*/
	/*DeleteObject(SelectObject(cDC,GetStockObject(NULL_PEN))); */
	Ellipse(cDC         , xplace - xouter
						, yplace - youter
						, xplace - xinner
						, yplace - yinner );
                
    /*restore working color*/
	setdrawcolorpen(ipen, ipen, icolor);
	setdrawcolorbrush(ipen, ipen, icolor);
  }/*highlight*/
}
/*___TBstereo_balltoscreen()________________________________________________*/

/****setdrawcolorpen()************************common name: MAC & PC**********/
void setdrawcolorpen(int ipenx, int ipeny, int icolorit)
{
    ipeny = ipeny;
	if (icolorit > 255)
	{
		newPen=CreatePen(PS_SOLID,ipenx,
			RGB((BYTE)(255),
				(BYTE)(255),
				(BYTE)(255) ) );
		oldPen = (HPEN)SelectObject(cDC,newPen);
	}
	else
	{
		 newPen = CreatePen(PS_SOLID,ipenx,PALETTEINDEX(icolorit));
if(newPen==NULL) printf("newPen==NULL\n");
		 oldPen = (HPEN)SelectObject(cDC,newPen);
		 /*oldPen is Handle of object being replaced if successful*/
if(oldPen==NULL) printf("oldPen==NULL\n");
	}
	DeleteObject(oldPen);
}
/*___setdrawcolorpen()_____________________________________________________*/

/****triangletoscreen()******************************************************/
void triangletoscreen(int x1,int y1,int x2,int y2,int x3,int y3,int icolor)
{

POINT aPoints[3];
 
				setdrawcolorbrush(1, 1, icolor);
				DeleteObject(SelectObject(cDC,GetStockObject(NULL_PEN)));

    aPoints[0].x = x1;
    aPoints[0].y = y1;
    aPoints[1].x = x2;
    aPoints[1].y = y2;
    aPoints[2].x = x3;
    aPoints[2].y = y3;

    Polygon(cDC, aPoints, sizeof(aPoints)/sizeof(POINT));
    /*Prog. Ref. v2, p744*/
}
/*___triangletoscreen()_____________________________________________________*/

/****linetoscreen()**********************************************************/
void linetoscreen(int x1, int x2, int y1, int y2)
{
   MoveToEx(cDC,x1,y1,NULL); /*THE MOVE, PC command*/
   LineTo(cDC,x2,y2);        /*THE DRAW, PC command */
}
/*___linetowscreen()________________________________________________________*/

/****marktoscreen()***********************************************************/
void marktoscreen(int x, int y, int r, int icolor)
{
   int w = 4;
   setdrawcolorpen(w,w,icolor);
   MoveToEx(cDC , (x  - r) , (y  - r) , NULL);  
   LineTo(cDC   , (x  - r) , (y  + r) );
   LineTo(cDC   , (x  + r) , (y  + r) );
   LineTo(cDC   , (x  + r) , (y  - r) );
   LineTo(cDC   , (x  - r) , (y  - r) );

   /*Rectangle() does a filled box*/
}
/*___marktoscreen()__________________________________________________________*/

/****ringtoscreen()***********************************************************/
void ringtoscreen(int x, int y, int r, int icolor)
{
   int w = 4;
   setdrawcolorpen(w,w,icolor);
   Arc(cDC
	       , (x  - r) /*xLeft*/
           , (y  - r) /*yTop*/
           , (x  + r) /*xRight*/
           , (y  + r) /*yBottom*/
		   , (x  - r) /*xStart*/
           , (y  - r) /*yStart*/
           , (x  - r) /*xEnd*/
           , (y  - r) /*yEnd*/
		   );
   /*Ellipse() does a filled, full Arc()*/
}
/*___ringtoscreen()__________________________________________________________*/

/****fantoscreen()************************************************************/
void fantoscreen(int x, int y, int icolor, int coloroffset, pointstruct* theptptr)
{
   int x2=0,y2=0,x3=0,y3=0, r=0, xo=0, yo=0;
   float co=0, si=0, mag=0, o=0;
   
   POINT aPoints[4];

   /*NOTE: color and penwidth already have been set for this point*/
   /*virtual pen has already been moved to x1,y1*/
   if(theptptr->moreinfoptr != NULL)
   {/*there is cos,sin info for this radial line*/
      /*for planning, disect components despite computational inefficiency*/
      r = (int)(scalenew*tablefancore); /*fudged radius of inner circle*/
      co = (theptptr->moreinfoptr)->f1; /*stored values of cos, sin */
      si = (theptptr->moreinfoptr)->f2; /*computed when table loaded*/
      mag = scalenew*(theptptr->radius)*tablefanradius;
   

      x2 = (int)((r+mag)*co); /*spine end at outer extent*/
      y2 = (int)((r+mag)*si);
      x3 = (int)(r*co);  /*spine end at inner circle*/
      y3 = (int)(r*si);

      /*angle = (180/(MAXROW+1));*/
      /*angle between spines, half circum == h = pi * radius */
      /*max non-overlapped tangent length ~= t = h/(MAXROW+1) */
      /*max offset to either side at end of spine == o = t/2;*/
      o = (float)(3.14*(r+mag)/(2*(MAXROW+1))); 
      xo = (int)(o * si); /*perpendicular to spine*/
      yo = (int)(o * co);
  
    

      aPoints[0].x = x+x3; /*inner end of radial spine*/
      aPoints[0].y = y-y3;
      aPoints[1].x = x+x2+xo; /*cross arm at outer end of spine*/
      aPoints[1].y = y-y2+yo;
      aPoints[2].x = x+x2-xo; /*cross arm at outer end of spine*/
      aPoints[2].y = y-y2-yo;
      aPoints[3].x = x+x3; /*inner end of radial spine*/
      aPoints[3].y = y-y3;

	  setdrawcolorbrush(1, 1, icolor);
	  DeleteObject(SelectObject(cDC,GetStockObject(NULL_PEN)));

      Polygon(cDC, aPoints, sizeof(aPoints)/sizeof(POINT));

   }/*there is cos,sin info for this radial line*/
   setdrawcolorpen(2,2,7+coloroffset);

   Arc( cDC
	   , (x  - r) /*xLeft*/
       , (y  - r) /*yTop*/
       , (x  + r) /*xRight*/
       , (y  + r) /*yBottom*/
       , (x  - r) /*xStart*/
       , (y  - r) /*yStart*/
       , (x  - r) /*xEnd*/
       , (y  - r) /*yEnd*/
      );

}
/*___fantoscreen()___________________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
