#include "MAGE.h"
#include "MAGELIST.h"
#include "MAGEBBOX.h"
#include "MAGEANGL.h"
#include <direct.h>
#ifndef __MWERKS__
#include <sys\stat.h>
#endif

/****filesize()************************************************************/
long filesize(LPSTR filename)
{
    struct stat statbuf;
    char localname[FILENAME_MAX];
    lstrcpy(localname,filename);
    if (stat(localname,&statbuf) == -1) return(-1);
    else return(statbuf.st_size);
}
/*___filesize()___________________________________________________________*/

/****findkin()****920614 dcr***********************************************/
int findkin(void)  /*called by openfilebyname() */
{
	if(Lappend==0) GetTextFromFile();/*MAGEFILE reads in text part of kinemage*/
    Lreentry = 1; /*Got text, entry() will get rest */
	entry();/*MAGEFILE.C has Lappend controls*/
    return(0);
}
/*___findkin()____________________________________________________________*/

/****openfilebyname()*******************************************************/
void openfilebyname(LPSTR Filename)  /*launched with a file*/
{
	long filesizefromdisk;
    char *cpslash;
    int  error = 0;
    FILE *fptry = NULL;

    lstrcpy(szDirName,Filename);
    if(Lappend)
       lstrcpy(AppendNameStr,Filename); /*permanently store name*/
    else
       lstrcpy(NameStr,Filename); /*permanently store name*/

    if ((cpslash = strrchr(szDirName,'\\')) != NULL) *cpslash = '\0';

	if ((filesizefromdisk = filesize(Filename)) == -1)
    {
        error = 1;
		sprintf(alertstr,"failed to determine filesize\n");
		sprintf(alertstr2,"");
		sprintf(alertstr3,"");
		DoMageDLOGreport(2);
    }
	if (error == 0)
	{
       fptry = fopen(Filename,"r");
       Lorigkinfile = 0; /* fp might not be original input file */
       if (fptry == NULL)
       {
          error = 2;
          sprintf(alertstr,"failed to open file\n");
          sprintf(alertstr2,"%s",Filename);
          sprintf(alertstr3,"");
          DoMageDLOGreport(2);
       }
    }
	if (error == 0)
	{
       if(Lappend)
       {
          fpappend = fptry;
       }
       else
       {
          fp = fptry;
	      SetMageCaption(); /* input file has changed, update the caption */
          InvalidateRect(gWindow,NULL,FALSE);/*when should this be done????*/
       }
       findkin(); /*MPCFILE ->GetTextFromFile() if Lappend==0, then entry()*/
    }
}
/*___openfilebyname()______________________________________________________*/

/****OpenNewFile()**********************************************************/
void OpenNewFile(void)   /*file from pull-down menu open file*/
{
  int error;
  OPENFILENAME ofn;
  char szFile[256],szFileTitle[256],szFilter[256];
  UINT i, cbString;
  char chReplace;

  Lgetnewfile = 0;

  /*if(!Lappend) thiskinenum = 1;*/ /*is this necessary ???? */
  
  if (*szDirName == '\0') _getcwd(szDirName,sizeof(szDirName));
  szFile[0] = '\0';
  strcpy(szFilter,"Kinemages (*.kin,*.kip)|*.ki*|All(*.*)|*.*|");
  cbString = strlen(szFilter);
  chReplace = szFilter[cbString-1];
  for (i = 0; szFilter[i] != '\0'; i++) 
  {
      if (szFilter[i] == chReplace) szFilter[i] = '\0';
  }
  memset(&ofn,0,sizeof(OPENFILENAME));
  ofn.lStructSize		= sizeof(OPENFILENAME);
  ofn.hwndOwner			= MageWindow;
  ofn.hInstance			= NULL;
  ofn.lpstrFilter		= szFilter;
  ofn.lpstrCustomFilter = NULL;
  ofn.nMaxCustFilter	= 0;
  ofn.nFilterIndex		= 1;
  ofn.lpstrFile			= szFile;
  ofn.nMaxFile			= sizeof(szFile);
  ofn.lpstrFileTitle	= szFileTitle;
  ofn.nMaxFileTitle		= sizeof(szFileTitle);
  ofn.lpstrInitialDir	= szDirName;
  ofn.lpstrTitle		= "Open A Kinemage";
  ofn.lpstrDefExt		= "kin";
  ofn.Flags				= OFN_PATHMUSTEXIST | OFN_HIDEREADONLY;

  if (GetOpenFileName(&ofn)) openfilebyname(ofn.lpstrFile); /*where is GetOpenFileName() ???? */
  else error = 10;     

  if (error) return;
}
/*___OpenNewFile()_________________________________________________________*/

