#include "MAGE.h"
#include "MAGELIST.h"
#include "MAGEBBOX.h"
#include "MAGECOLR.h"

/****InitInstance()***********************************************************
    FUNCTION:  InitInstance(HINSTANCE, int)
    PURPOSE:  Saves instance handle and creates main window
    COMMENTS:
        This function is called at initialization time for every instance of
        this application.
****************************************************************************/
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
	RECT rect;
	int tWindowSizeX, tWindowSizeY, tWindowPosX, tWindowPosY;
	int cWindowSizeX, cWindowSizeY, cWindowPosX, cWindowPosY;
	int gWindowSizeX, gWindowSizeY, gWindowPosX, gWindowPosY;
	int i,iret,tryfontsize;
	WNDCLASSEX  wc;
		typedef unsigned int palette256[256][3];
		WORD nNumColors;
		#define PALETTESIZE 256

	/* Save the instance handle in static variable, which will be used in  */
	/* many subsequent calls from this application to Windows.            */

	hInst = hInstance;
	DisplaySizeX = GetSystemMetrics(SM_CXSCREEN);
	DisplaySizeY = GetSystemMetrics(SM_CYSCREEN);

	/* load the menu accelerators to key commands for Open, Find, etc... */
	MageAccel = LoadAccelerators(hInst, "MageAccelerator");

	wc.cbSize			= sizeof (wc);
    wc.style			= CS_HREDRAW | CS_VREDRAW; /* Class style(s).             */
    wc.lpfnWndProc		= MainWndProc;      /* Function to retrieve messages for  */
											/* windows of this class.             */
    wc.cbClsExtra		= 0;                /* No per-class extra data.           */
    wc.cbWndExtra		= 0;                /* No per-window extra data.          */
    wc.hInstance		= hInst;            /* Application that owns the class.   */
    wc.hIcon			= LoadIcon(hInst, "MageIcon");
    wc.hCursor			= LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground	= (HBRUSH)(COLOR_BTNFACE+1);
    wc.lpszMenuName		= "MageMenu";       /* Name of menu resource in .RC file. */
    wc.lpszClassName	= "MageMainClass";  /* Name used in call to CreateWindow. */
	wc.hIconSm			= LoadIcon(hInst, "MageIcon"); /*Icon used in main window's UL corner */

    /* Register the window class and quit on failure. */
    iret				= RegisterClassEx(&wc);
    if (iret == 0)		return(FALSE);


    /* the graphics window class */
	wc.cbSize			= sizeof (wc);
    wc.style			= CS_HREDRAW | CS_VREDRAW;/* Class style(s).              */
    wc.lpfnWndProc		= GraphWndProc;     /* Function to retrieve messages for  */
											/* windows of this class.             */
    wc.cbClsExtra		= 0;                /* No per-class extra data.           */
    wc.cbWndExtra		= 0;                /* No per-window extra data.          */
    wc.hInstance		= hInst;            /* Application that owns the class.   */
    wc.hIcon			= LoadIcon(NULL, IDI_APPLICATION);
//  wc.hIcon			= LoadIcon(hInst, "tetraicon");
    wc.hCursor			= LoadCursor(hInst, "graphcursor");
//  wc.hCursor			= magecursor;		/* from definecursors() */
//  wc.hCursor			= LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground	= (HBRUSH) GetStockObject(BLACK_BRUSH);
    wc.lpszMenuName		= NULL;			    /* no menu resource in .RC file. */
    wc.lpszClassName	= "MageGraphClass"; /* Name used in call to CreateWindow. */
	wc.hIconSm			= LoadIcon(hInst, "MageIcon"); /*Icon used in main window's UL corner */

    iret				= RegisterClassEx(&wc);
    if (iret == 0)		return(FALSE);

    /* register the scroll window */
	wc.cbSize			= sizeof (wc);
    wc.style			= CS_HREDRAW | CS_VREDRAW;/* Class style(s).                    */
    wc.lpfnWndProc		= ScrollWndProc;    /* Function to retrieve messages for  */
											/* windows of this class.             */
    wc.cbClsExtra		= 0;                /* No per-class extra data.           */
    wc.cbWndExtra		= 24;               /* per-window extra data.          */
    wc.hInstance		= hInst;            /* Application that owns the class.   */
    wc.hIcon			= LoadIcon(NULL, IDI_APPLICATION);
    wc.hCursor			= LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground	= (HBRUSH)(COLOR_BTNFACE+1);
    wc.lpszMenuName		= NULL;				/* no menu for this window */
    wc.lpszClassName	= "MageScrollClass";
	wc.hIconSm			= LoadIcon(hInst, "MageIcon"); /*Icon used in main window's UL corner */

    iret				= RegisterClassEx(&wc);
    if (iret == 0)		return(FALSE);

    /* register the horizontal bondrot scroll window */
	wc.cbSize			= sizeof (wc);
    wc.style			= CS_HREDRAW | CS_VREDRAW;/* Class style(s).                    */
    wc.lpfnWndProc		= HScrollWndProc;   /* Function to retrieve messages for  */
											/* windows of this class.             */
    wc.cbClsExtra		= 0;		        /* No per-class extra data.           */
    wc.cbWndExtra		= 32;               /* per-window extra data.          */
    wc.hInstance		= hInst;            /* Application that owns the class.   */
    wc.hIcon			= LoadIcon(NULL, IDI_APPLICATION);
    wc.hCursor			= LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground	= (HBRUSH)(COLOR_BTNFACE+1);
    wc.lpszMenuName		= NULL;				/* no menu for this window */
    wc.lpszClassName	= "MageHScrollClass";
	wc.hIconSm			= LoadIcon(hInst, "MageIcon"); /*Icon used in main window's UL corner */

    iret				= RegisterClassEx(&wc);
    if (iret == 0)		return(FALSE);

    /* register the text window class */
	wc.cbSize			= sizeof (wc);
    wc.style			= CS_HREDRAW | CS_VREDRAW;/* Class style(s).                    */
    wc.lpfnWndProc		= MAGETextWndProc;  /* Function to retrieve messages for  */
											/* windows of this class.             */
    wc.cbClsExtra		= 0;                /* No per-class extra data.           */
    wc.cbWndExtra		= 20;               /* Per-window extra data.          */
    wc.hInstance		= hInst;            /* Application that owns the class.   */
//  wc.hIcon			= LoadIcon(hInstance, "texticon");
    wc.hIcon			= LoadIcon(NULL, IDI_APPLICATION);
    wc.hCursor			= LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground	= (HBRUSH) GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName		= NULL;				/* no menu */
    wc.lpszClassName	= "MageTextClass";	/* Name used in call to CreateWindow. */
	wc.hIconSm			= LoadIcon(hInst, "MageIcon"); /*Icon used in main window's UL corner */

    /* Register the window class and quit on failure. */
    iret				= RegisterClassEx(&wc);
    if (iret == 0)		return(FALSE);

    /* register the table window class */
	wc.cbSize			= sizeof (wc);
    wc.style			= CS_HREDRAW | CS_VREDRAW;/* Class style(s).                    */
    wc.lpfnWndProc		= MAGETableWndProc; /* Function to retrieve messages for  */
											/* windows of this class.             */
    wc.cbClsExtra		= 0;                /* No per-class extra data.           */
    wc.cbWndExtra		= 20;               /* Per-window extra data.          */
    wc.hInstance		= hInst;            /* Application that owns the class.   */
    wc.hIcon			= LoadIcon(NULL, IDI_APPLICATION);
    wc.hCursor			= LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground	= (HBRUSH) GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName		= NULL;				/* no menu */
    wc.lpszClassName	= "MageTableClass";	/* Name used in call to CreateWindow. */
	wc.hIconSm			= LoadIcon(hInst, "MageIcon"); /*Icon used in main window's UL corner */

    /* Register the table window class and quit on failure. */
    iret				= RegisterClassEx(&wc);
    if (iret == 0)		return(FALSE);


	/* Create a main window for this application instance.  */

	MageWindow = CreateWindowEx(
		WS_EX_OVERLAPPEDWINDOW,	 /* Extended Window type	  */
		"MageMainClass",		/* See RegisterClassEx() call. */
		"Mage",					/* Text for window title bar.  */
		WS_TILEDWINDOW | WS_CLIPCHILDREN | WS_BORDER,/* Window style. */
		0,						/* Grab whole display surface  */
		0,
		DisplaySizeX,
		DisplaySizeY-27,
		NULL,					/* Overlapped windows have no parent. */
		NULL,					/* Use the window class menu.         */
		hInst,					/* This instance owns this window.    */
		NULL					/* Pointer not needed.                */
	);

	/* If window could not be created, return "failure" */
	if (!MageWindow) return (FALSE);

	/* Make the window visible and update its client area. */
	ShowWindow(MageWindow, nCmdShow);  /* Show the window */

	GetClientRect(MageWindow,&rect);
	/*for a client: rect.top and rect.left == 0 */
	DisplaySizeX = rect.right;  /*so this is width*/
	DisplaySizeY = rect.bottom; /*so this is height*/

	SystemFontSize();		/*MPCBAR.C*/
	NewSliderWindows();		/*MPCBAR.C*/ /*getbuttonplace() needs SliderWidth*/
	getbuttonplace();		/*gWindow placement needs buttons brect.left*/
							/*MPCBBOX.C*/

	/* calculate the starting sizes and positions of child windows */
	/*based on 5ths */
	gWindowSizeX = brect.left - (15 * DisplaySizeX / 100);
	gWindowSizeY = 90 * DisplaySizeY / 100;

	tWindowSizeX = brect.left - DisplaySizeX / 5;
	tWindowSizeY = 4 * DisplaySizeY / 5;

	  /*screen left == 0 to buttons left edge - 100 for some space */
		  /* for the graphics window to show if text in front */

	cWindowSizeX = brect.left - (5 * DisplaySizeX / 100);
	cWindowSizeY = DisplaySizeY / 5;

	  /*screen left == 0 to buttons left edge - 10 for some margin */

	ROTSWIDTH = DisplaySizeX / 8; /*PC allowance for bondrot scroll bars */
	gWindowPosX = 14 * DisplaySizeX / 100,
							/* horizontal position, set left of buttons */
	gWindowPosY = 0;  /*vertical position at top */
	tWindowPosX = 0;  /*text window at left edge*/
	tWindowPosY = 0;  /*text window at top edge*/
	cWindowPosX = 0;  /*caption to left edge*/
	cWindowPosY = tWindowPosY + tWindowSizeY; /*caption under text*/
	/* start with square graphics window by using min(X Y)*/
	/* Create a graphics window for this application instance.  */

	gWindow = CreateWindowEx(
		WS_EX_OVERLAPPEDWINDOW,	 /* Extended Window type	  */
		"MageGraphClass",        /* See RegisterClassEx() call. */
		"MAGE Graphics",         /* text for window title bar.*/
		WS_CHILD | WS_CLIPSIBLINGS | WS_THICKFRAME,
		gWindowPosX,             /* horizontal position       */
		gWindowPosY,             /* vertical position: top    */
		gWindowSizeX,			 /* width.*/
		gWindowSizeY,			 /* height.*/
		MageWindow,              /* parent window             */
		(HMENU) MAGEGRAPHID,     /* window identifier         */
		hInst,					 /* This instance owns this window.*/
		NULL                     /* Pointer not needed.       */
	);
		   /* | WS_MINIMIZEBOX | WS_MAXIMIZEBOX | WS_SYSMENU,*/
		   /* Window style. No close stuff, no menu stuff*/
		   /*No WS_MAXIMIZEBOX because it goes off bottom, lose pick id*/
		   /*also, buttons are in the MainWindow, so don't readjust*/

	/* If window could not be created, return "failure" */
	if (!gWindow) return (FALSE);

	ResizeMageGraphics(gWindowSizeX, gWindowSizeY);

	/* look and see if oldmaxwide can be removed */	
    if(GWIDTH<GHEIGHT) oldmaxwide = GWIDTH;
    else               oldmaxwide = GHEIGHT; 
	izctr = oldmaxwide/2;
         /*need stored maxwide of a successful GrafWindow to adjust */
         /*resized zclip later*/

	if     (oldmaxwide < 500) tryfontsize = oldfontsize;  //980921b
    else if(oldmaxwide < 800) tryfontsize = 24;
    else                      tryfontsize = 32;
    infofontsize   = tryfontsize;
    labelsfontsize = tryfontsize;
    wordsfontsize  = tryfontsize;

	/*initializegraphicswindow stuff defined as globals*/
	tracking = 0;
	hasnewDC = 0;
	newDC = 0;
	newBitmap = 0;

	/* npixelbits is legacy code and needs to be removed eventually */
	npixelbits = 8;
	/*LCscrn = IsColor();*/ /*find out if color can be used: presumed on PC*/
			/*on Mac, this is a test for color QuickDraw*/
	/* Lcolor = LCscrn;*/  /* Lcolor does color Move-Draw Logic */
	/* more presumptions on PC: */
	LCscrn = 1; /*ability to go to B&W screen*/
	Lcolor = LLcolor = 1;  /* for compatibility with Mac? */
	nNumColors = PALETTESIZE;


	/* allocate and initialize the color palette */
	lpPalette = (LOGPALETTE*) malloc (sizeof(LOGPALETTE)+nNumColors*sizeof(PALETTEENTRY)+4000);
	lpPalette->palNumEntries = nNumColors;
	lpPalette->palVersion = 0x300;
	for (i = 0; i < PALETTESIZE; ++i)
	{
		lpPalette->palPalEntry[i].peRed =   myfullpalette[i][0] / 256u;
		lpPalette->palPalEntry[i].peGreen = myfullpalette[i][1] / 256u;
		lpPalette->palPalEntry[i].peBlue =  myfullpalette[i][2] / 256u;
		lpPalette->palPalEntry[i].peFlags = (BYTE)0;
    }
  
    /* Make the window visible and update its client area */
    BringWindowToTop(gWindow);
    ShowWindow(gWindow, SW_SHOWNA);  /* Show the window */

    /*definecursors(hInst);*/ /*for graphics*/ /*done in main */

    /*SetTextCaption(gWindow,(LPSTR)"MAGE");*/

    /*tWindow -----------------------------------------*/
    tWindow = NewTextWindow(MageWindow,MAGETEXTID,
                        tWindowPosX, tWindowPosY,
                        tWindowSizeX, tWindowSizeY, 0);

    SetTextCaption(tWindow,(LPSTR)"TEXT");  /*920614 dcr */
    cleartexts();

    /*cWindow -----------------------------------------*/

    captionWindow = NewTextWindow(MageWindow,MAGETEXTID,
                        cWindowPosX, cWindowPosY,
                        cWindowSizeX, cWindowSizeY, 0);

    SetTextCaption(captionWindow,(LPSTR)"CAPTION");

    return (TRUE);               /* Returns the value from PostQuitMessage */
}
/*___InitInstance()_________________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/

/****definecursors()*******same name MAC & PC********************************/
void definecursors(HINSTANCE hInstance)
{
         magecursor  = LoadCursor(hInstance, "graphcursor");
         xyrotcursor = LoadCursor(hInstance, "xyrotcursor");
         zrotcursor  = LoadCursor(hInstance, "zrotcursor");
         flatlandcursor  = LoadCursor(hInstance, "flatlandcursor");
         waitcursor  = LoadCursor(hInstance, IDC_WAIT);
}
/*___definecursors()________________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
