/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****PROGRAM: MAGE ****STRUCTURE DISPLAY***********************************/
#define EXTERN
/* EXTERN is defined null, so mage.h will do initial declarations */
/* the scope of definition is just this file, not defined for later files*/

#include "MAGE.h" /*which invokes include for MAGE.HDR */
/* MPCMAIN.C is the ONLY file that defines EXTERN, */
		   /* so declarations are idempotent */
/*include "MAGEMENU.H" done in MAGE.H for menu and dialog item numbers*/
/*include "MAGE.HDR" done in MAGE.H for subroutine prototypes*/

/*NOTE: since routines are being moved around as PC and MAC MAGE are */
/* being worked together, and since C does not have named common, */
/* All globals of any scope should be in MAGE.H  */
/* Initial definitions are best done in mageinitialvalues() in MAGEMAIN.C */
#include <winbase.h>  /* timer stuff*/

#include "MAGEMENU.h"
#include "MAGELIST.h"
#include "MAGEBBOX.h"
#include "MAGEANGL.h"
#include "MAGETABL.h"

void adjustzoom(void);

/****MainLoop()**************************************************************/
int MainLoop()
{
    MSG	msg; /* message */
	
    /* Acquire and dispatch messages until a WM_QUIT message is received. */
	/* Menu Accelerator Keys are bypassed to the accelerator			  */
    while(GetMessage(&msg,NULL,0,0) )
    {
		if (!TranslateAccelerator (MageWindow, MageAccel, &msg))
		{
			TranslateMessage(&msg); /* Translates virtual key codes */
			DispatchMessage(&msg);  /* Dispatches message to window */
		}
    }
    return msg.wParam ;
}
/*___MainLoop()_____________________________________________________________*/

/****WinMain()**************************************************************
    FUNCTION: WinMain(HINSTANCE, HINSTANCE, LPSTR, int)
    PURPOSE: calls initialization function, processes message loop
****************************************************************************/
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
				   LPSTR lpCmdLine, int nCmdShow)
/*HINSTANCE hInstance;    current instance
HINSTANCE hPrevInstance;  previous instance
LPSTR lpCmdLine;          command line
int nCmdShow;             show-window type (open/icon)*/
{
    int ireturn;
    char firstmessage[256];

    if (*lpCmdLine != '\0') filearg = lpCmdLine;
      /*revision930211  do lpCmdLine recovery before anything*/
    Initialized = 0;
        /*Global control to keep from writing graphics before ready*/

/****mainset()*********/

    IPC = 1;  /*flow control for PC computers with windows */
    IMAC = 0; /*flow control for Macintosh computers */
	makecursorwait(); /*MPCMAIN.C*/
    mageinitialvalues(); /*MAGEINIT.C*/ /*InitInstance redefines some*/

    /* equivalent to MAC's Initcomputer*/
    /* MAGE windows defined in InitInstance()*/
    if (!InitInstance(hInstance, nCmdShow))  /*MPCINIT.C*/
        return (FALSE);
    getmageversion();   /*common version number: MAGEINIT.C */

    /* Perform initializations that apply to a specific instance */
    definecursors(hInstance); /*MPCINIT.C*/

    Ltest = 0;
    /*Ltest = 1;*/
    /*test option, compile as TRUE to invoke, as FALSE for distribution*/
    /*depends on dialog window, defined in InitInstance() */
/*___mainset()______*/

/****beginnings()****/
    /* MAGE windows defined in InitInstance()*/
    /*So DoMageDLOGreport() should now be functioning*/

    /*initial dialog box here if always initial dialog box */ 
    setMageinitDLOGreport(); /*MAGEINIT.C*/
    if (!filearg) DoMageinitDLOGreport();  /*MPCDLOG.C*/ /*MACDLOG.C*/
    if(ireturnflag==1) return (FALSE); /*aborted in initDLOG */

    AdjustMenus(); /*MAGEMENU.C*/
    if (filearg == NULL)
    {
      /*initial dialog box here if not one on file launch */ /*2_4:930901*/
        sprintf(firstmessage,"%s\r Use File pull-down menu above \r"
                             " to Open a kinemage File",version);
    }
    else
    {
        sprintf(firstmessage,"%s\r A request for a kinemage file has launched MAGE",version);
    }
	inserttexts(firstmessage);
	completetext();

    /*MAGEINIT.C  alloc storage for big arrays*//*do this before open file*/
	alloclinkarrays(); /*do this first since must have these at orig size*/
	allocdisplayarrays(0);  /* *it[8] array of pointers, it[8][MAXDRAWS]*/
	allocwordcomarray(0);  /*some kinemages don't have any <words> */
       /* char  *wordcom;  pointer to array, for wordcom[MAXWORDCOM], */
       /*size = MAXWORDCOM*/ /* the comment or wordlist character array  */
	alloccomarray(0);
/*___beginnings()______*/

    Initialized = 1;
    if (filearg != NULL) openfilebyname(filearg); /*MPCFILE.C*/
        /* in MPCFILE.C  called from MENU */

	makecursoractive(); /*MPCMAIN.C*/

    /* Acquire and dispatch messages until a WM_QUIT message is received. */
    ireturn = MainLoop();  /*.*/
    cleanup();   /*MAGEINIT.c*/
    return(ireturn) ;
}
/*___WinMain()_____________________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/

/****testbutton()************************************************************/
int testbutton(HWND it, HWND index)
{
    if(it == index) return(1); /*wParam==MM_BUTTONINDEX+index*/
    else return(0);
}
/*___testbutton()___________________________________________________________*/

/****buttonboxcheck()***********************common name: MAC & PC & MUX ***/
void buttonboxcheck(HWND button,int itch)
{
     if(button != NULL) /*box had been created */
     SendMessage(button,BM_SETCHECK,itch,0); /* x mark for itch*/
}
/*___buttonboxcheck()_____________________________________________________*/

/****MainWndProc()**********************************************************
    FUNCTION: MainWndProc(HWND, UINT, WPARAM, LPARAM)
    PURPOSE:  Processes messages
    MESSAGES:

    WM_COMMAND    - application menu (About dialog box)
    WM_DESTROY    - destroy window   940424 causes problems

    COMMENTS:
    To process the IDM_ABOUT message, call Dialogbox which will create the
	box according to the information in your mage.rc file and turn control
	over to the About() function.
****************************************************************************/
LRESULT CALLBACK MainWndProc(HWND hWnd, UINT message,
							 WPARAM wParam, LPARAM lParam)
{
	HDC hDC;
    PAINTSTRUCT ps;
	RECT rect;
	int   WindowSizeX, WindowSizeY;
    int   i,ion,notification;

    switch (message)
    {/*switch (message) MainWndProc master case switches*/
    case WM_CREATE:
		if (!Initialized) return(0);
		/* get the screen dimensions */
		WindowSizeX = GetSystemMetrics(SM_CXSCREEN);
		WindowSizeY = GetSystemMetrics(SM_CYSCREEN);
		/* no break - we want to paint the screen */
	case WM_PAINT:
		hDC = BeginPaint(MageWindow,&ps);
		EndPaint(MageWindow,&ps);
		return(0);
    case WM_COMMAND:
      /* message: from checkbox? */
      /*920605 dcr MM_BUTTONINDEX defined */
      /*  as well as MAXGroups,MAXSubgroups,MAXLists*/

      if (LOWORD(wParam) == MM_BUTTONINDEX)
      {/*should be a message from a checkbox*/
        notification = HIWORD(wParam);

        if (notification == BN_CLICKED)
        {/*button clicked*/ /*unclear why doing this extra check here*/
          /*Mac Mage buttons in DografContentClick() in macmain.c*/
          /*MUX MAGE buttons in buttonscallback() in MUXMBBOX.c */
          /*PC and MUXM toggle buttons change their own state, Mac's don't */

          /*first: get the current toggle state of whoever got clicked */
          ion = SendMessage((HWND)lParam,BM_GETCHECK,0,0l);

          /*during the scan through all boxes, unset those that never show X */

          /* beware: check boxes actually defined even when not created,*/
          /* so search by same hierarchy that created them */

		  /*e.g. to control direction of animation*/
		  if(GetKeyState(VK_SHIFT) < 0) Lshiftkey = 1;
		  else Lshiftkey = 0;

          buttonboxscan((HWND)lParam, ion);  /*MAGEBBOX.c*/
		  redrawvec();            /*MPCDRAW.c*/
        }
      }/*should be a message from a checkbox*/
      /* message: command from application menu? */
      Lmenu = TRUE;
          /*allows routines to know they were invoked by a menu selection */
      switch (LOWORD(wParam))
      {/*switch LOWORD(wParam) within WM_COMMAND case*/
          case openItem:
			   Lappend = 0;
			   Lgetnewfile = 1; /*request to open-new-file */
               if(Lpruneactive||Ldrawactive||Lnewviewactive||Lnewstuffactive)
                   DoChangeCheckDialog(); /*MAGEDLOG, does routing*/
               else
			   {
			 	  OpenNewFile(); /* MPCFILE.C */
			   }
          break;
		  case appendItem:
			   Lappend = 1;
			   Lgetnewfile = 1; /*request to open-new-file */
			   /*can go right to open-new-file stuff, since nothing will be lost*/
			   IOerr = 1;
			   OpenNewFile();  /* MPCFILE.C */
			   Lappend = 0;
		  break;
		  case writekinItem:
              writeoutput(5);/*modified kinemage*//*____OUT.C*/
              InvalidateRect(gWindow,NULL,FALSE);
              redrawvec(); /*MPCDRAW.C*/
          break;

		  case writedrawnewItem:
              writeoutput(3);  /*MPCOUT.C*/ /*MACOUT.C*/
          break;
		  case writerottedItem:
              DocoordformatDialog();  /*MAGEDLOG.c*/
              if(ireturnflag && nbondrot > 0) writeoutput(4); /*MPCOUT.C*/ /*MACOUT.C*/
          break;
          case writeviewItem:
              writeoutput(1);  /*MPCOUT.C*/ /*MACOUT.C*/
          break;
          case writefocusItem:
              writeoutput(2);  /*MPCOUT.C*/ /*MACOUT.C*/
          break;
          case writeQAItem:
              writeoutput(7);/*MPCOUT.C*//*MACOUT.C*/
                  /*hypertext questions and answers*/
          break;
          case writeR3DItem:  /*output for raster3Drender */
              DoRaster3DDialog(); /*MAGEDLOG*/
              redrawvec();  /*000509*/
          break;
          case writeptIDItem:        
               writeoutput(10); /*000326*/
          break;

          case writePostScriptItem:
			  DoPostScriptDialog();  /*MAGEDLOG*/
              if (ireturnflag) 
			  {
				  writeoutput(6); /*MPCOUT.C*//*MACOUT.C*/
				  InvalidateRect(gWindow,NULL,FALSE);
				  redrawvec(); /*MPCDRAW.C*/
			  }
          break;
          case quitItem:
              quitMAGE();
          break;

          case drawlineItem:
			  setdrawline();  /*MAGEMENU.C*/
          break;
		  case drawsetupItem:
			  DodrawlineDialog(); /*MAGEDLOG.C*/
		  break;
          case editviewItem:
			  DoViewsDialog(0); /*MPCDLOG.C*/
          break;
		  case colorshowItem:
			  setcolorshow(); /*MAGEUTIL.C*/
		  break;
          case pruneItem:
			  setprune(); /*MAGEUTIL.C*/
          break;
          case superpickItem:
			  setsuperpick(); /*MAGEUTIL.C*/
          break;
		  case pickshowItem:
			  setpickshow(); /*MAGEUTIL.C*/
          break;

           case tablecutItem:
              tablecelldelete(); /*MAGETABL.c*/
           break;
 
            case tablerestoreItem:
              restoredeletedpoint(); /*MAGETABL.c*/
           break;
          
           case tablepreinsertItem:
              tablecellinsert(-1); /*MAGETABL.c*/
           break;
           
           case tablepostinsertItem:
              tablecellinsert(+1); /*MAGETABL.c*/
           break;
        
           case tablerebuildItem:
              tablerebuild(); /*MAGETABL.c*/
           break;

           case tablecolorItem:
              tablecolor(); /*MAGETABL.c*/
           break;

          case nextItem:
			  Lgetnextkinemage = 1; /*971129*/
              if(Lpruneactive||Ldrawactive||Lnewviewactive||Lnewstuffactive)
              {
                  DoChangeCheckDialog(); /*MAGEDLOG.C */
              }
              else getnextkinemage(); /*MAGEFILE.C*/
          break;
          case chooseItem:
			  Lgetkinemagechoice = 1; /*971129*/
              if(Lpruneactive||Ldrawactive||Lnewviewactive||Lnewstuffactive)
              {
                  DoChangeCheckDialog(); /*MAGEDLOG.C*/
              }
              else getkinemagechoice(); 
          break;

		  case multiwidthItem:
			  setmultiwidth();   /*MAGEMENU.c*/
		  break;
          case widthItem:
			  setwidthtoggle();  /*MAGEUTIL.C*/
          break;
          case thinItem:
			  setthinline();     /*MAGEUTIL.C*/
          break;
          case perspecItem:
			  setperspec();      /*MAGEUTIL.C*/
          break;
          case stereoItem:
			  setstereo();     /*MAGEMENU.C*/
          break;
          case compareItem:
			  setcompare();    /*MAGEMENU.C*/
          break;
		  case sterangItem:
			  DostereoDialog();    /*MPCDLOG.C*/
		  break;
		  case listcolorItem:
			  setlistcolordominance();  /*MAGEMENU.C*/
		  break;
		  case lensItem:
			  setLens();			/* MAGEMENU.C*/
		  break;
		  case detailItem:
			  DodetailDialog();    /*MAGEDLOG.C*/
		  break;
          case whtbkgItem:
			  setwhtbkg();
          break;
          case B_WItem:
             /*PC just fakes a B&W monitor*/
             Lcolor=!Lcolor;
			 setwhtbkg();
          break;
		  case GFontItem:
			  DoSetgraffontsDialog();/*MPCDLOG.C*/
		  break;
		  case strokedfontItem:
			  setstrokedfont();           /*MAGEMENU*/
          break;
		  case flatItem:
			  setflat();           /*MAGEMENU.C*/
          break;
		  case horizItem:
			  sethorizon();           /*MAGEMENU.C*/
          break;
		  case plotonlyItem:
			  setplotonly();/*kalide*//*MAGEMENU.C*/
          break;

          case undopickctrItem:
			  doundopickcenter(); /*MAGEMENU.c*/
          break;
		  case reset1Item:
              resetrot(1);       /*MAGEANGL.C*/
			  redrawvec();  /*MPCDRAW.C*/
          break;
          case reset2Item:
              resetrot(2);
			  redrawvec();
          break;
          case reset3Item:
              resetrot(3);
			  redrawvec();

          break;
          case reset4Item:
              resetrot(4);
			  redrawvec();
          break;
          case reset5Item:
              resetrot(5);
			  redrawvec();
          break;
          case reset6Item:
              resetrot(6);
			  redrawvec();
          break;
          case reset7Item:
              resetrot(7);
			  redrawvec();
          break;
          case reset8Item:
              resetrot(8);
			  redrawvec();
          break;
          case reset9Item:
              resetrot(9);
			  redrawvec();
          break;
          case reset10Item:
              resetrot(10);       /*MAGEANGL.C*/
			  redrawvec();  /*MPCDRAW.C*/
          break;
          case reset11Item:
              resetrot(11);
			  redrawvec();
          break;
          case reset12Item:
              resetrot(12);
			  redrawvec();
          break;
          case reset13Item:
              resetrot(13);
			  redrawvec();
          break;
          case reset14Item:
              resetrot(14);
			  redrawvec();
          break;
          case reset15Item:
              resetrot(15);
			  redrawvec();
          break;
          case reset16Item:
              resetrot(16);
			  redrawvec();
          break;
          case reset17Item:
              resetrot(17);
			  redrawvec();
          break;
          case reset18Item:
              resetrot(18);
			  redrawvec();
          break;
          case reset19Item:
              resetrot(19);
			  redrawvec();
          break;
          case reset20Item:
              resetrot(20);       /*MAGEANGL.C*/
			  redrawvec();  /*MPCDRAW.C*/
          break;
          case reset21Item:
              resetrot(21);
			  redrawvec();
          break;
          case reset22Item:
              resetrot(22);
			  redrawvec();
          break;
          case reset23Item:
              resetrot(23);
			  redrawvec();
          break;
          case reset24Item:
              resetrot(24);
			  redrawvec();
          break;
          case reset25Item:
              resetrot(25);
			  redrawvec();
          break;
          case reset26Item:
              resetrot(26);
			  redrawvec();
          break;
          case reset27Item:
              resetrot(27);
			  redrawvec();
          break;
          case reset28Item:
              resetrot(28);
			  redrawvec();
          break;
          case reset29Item:
              resetrot(29);
			  redrawvec();
          break;
          case reset30Item:
              resetrot(30);       /*MAGEANGL.C*/
			  redrawvec();  /*MPCDRAW.C*/
          break;
          case reset31Item:
              resetrot(31);
			  redrawvec();
          break;
          case reset32Item:
              resetrot(32);
			  redrawvec();
          break;
          case reset33Item:
              resetrot(33);
			  redrawvec();
          break;
          case reset34Item:
              resetrot(34);
			  redrawvec();
          break;
          case reset35Item:
              resetrot(35);
			  redrawvec();
          break;
          case reset36Item:
              resetrot(36);
			  redrawvec();
          break;
          case reset37Item:
              resetrot(37);
			  redrawvec();
          break;
          case reset38Item:
              resetrot(38);
			  redrawvec();
          break;
          case reset39Item:
              resetrot(39);
			  redrawvec();
          break;
          case reset40Item:
              resetrot(40);       /*MAGEANGL.C*/
			  redrawvec();  /*MPCDRAW.C*/
          break;
          case reset41Item:
              resetrot(41);
			  redrawvec();
          break;
          case reset42Item:
              resetrot(42);
			  redrawvec();
          break;
          case reset43Item:
              resetrot(43);
			  redrawvec();
          break;
          case reset44Item:
              resetrot(44);
			  redrawvec();
          break;
          case reset45Item:
              resetrot(45);
			  redrawvec();
          break;
          case reset46Item:
              resetrot(46);
			  redrawvec();
          break;
          case reset47Item:
              resetrot(47);
			  redrawvec();
          break;
          case reset48Item:
              resetrot(48);
			  redrawvec();
          break;
          case reset49Item:
              resetrot(49);
			  redrawvec();
          break;
          case reset50Item:
              resetrot(50);       /*MAGEANGL.C*/
			  redrawvec();  /*MPCDRAW.C*/
          break;
          case reset51Item:
              resetrot(51);
			  redrawvec();
          break;
          case reset52Item:
              resetrot(52);
			  redrawvec();
          break;
          case reset53Item:
              resetrot(53);
			  redrawvec();
          break;
          case reset54Item:
              resetrot(54);
			  redrawvec();
          break;
          case reset55Item:
              resetrot(55);
			  redrawvec();
          break;
          case reset56Item:
              resetrot(56);
			  redrawvec();
          break;
          case reset57Item:
              resetrot(57);
			  redrawvec();
          break;
          case reset58Item:
              resetrot(58);
			  redrawvec();
          break;
          case reset59Item:
              resetrot(59);
			  redrawvec();
          break;
          case reset60Item:
              resetrot(60);
			  redrawvec();
          break;
          case resetRItem:
              resetrot(61);
			  redrawvec();
          break;
          case readersviewItem:
			  sprintf(viewcom[MAXRESETS],"Reader's View");
			  sprintf(temps,"%s",viewcom[MAXRESETS]);
			  setviewidentifier(MAXRESETS,temps); /*980927*/ /*MAGEMENU.c*/
			  checkcurrentviewmenu(MAXRESETS);

			  Lzoomer[MAXRESETS] = 1; /*store zoom as a scaling value 980930*/
			  setrotview(MAXRESETS);
                  /*magerotn.c MAXRESETS: last view is reader's*/
              AdjustMenus();  /*MAGEMENU.C*/
          break;

          case searchItem:
			  DoSearchDialog();/*MPCDLOG.C*/
          break;
		  case findagainItem:
			  DoSearchAgain();    /*MAGEUTIL.c*/ /*971204*/
		  break;
          case measureItem:
			  setmeasures();   /*MAGEUTIL.C*/
          break;

		  case hidemeasuresItem:
			  potentiateMeasures();  /*MAGEMENU.C*/
		  break;
          case brotangleItem:
			  reinitialbondrots(); /*MAGEANGL.C*/
          break;
		  case rot90plusItem:
			  getrot(157,0);  /*MAGEDRAW.C*/
			  redrawvec();
		  break;
		  case rot90minusItem:
			  getrot(-157,0);
			  redrawvec();
		  break;
		  case rot90xplusItem:
			  getrot(0,157);  /*MAGEDRAW.C*/
			  redrawvec();
		  break;
		  case rot90xminusItem:
			  getrot(0,-157);
			  redrawvec();
		  break;
		  case rot90zplusItem:
			  getrot(157,157);  /*MAGEDRAW.C*/
			  redrawvec();
		  break;
		  case rot90zminusItem:
			  getrot(-157,-157);
			  redrawvec();
		  break;

		  case remoteupdateItem:
			  DoupdateDialog();
		  break;
		  case xyzpointItem:
			  setxyzpoint();      /*MAGEUTIL.C*/
		  break;
		  case gnomonItem:
			  setgnomon();        /*MAGEUTIL.C*/
          break;
		  case rateItem:
			  setrate();           /*MAGEUTIL.C*/
			  redrawvec();
          break;
          case countItem:
			  Lcount = 1;
			  countredraws(); /*MPCMAIN.C*/
          break;
          case dockingscopeItem: /*000814*/
              setdockingscope(); 
          break;
		  case formattestItem:
			  setformattest();  /*MAGEUTIL.C*/
		  break;
		  case testItem:
			  settest();           /*MAGEUTIL.C*/
          break;
          case cursorchoiceItem: /*980804*/
              DocursorDialog();
          break;
          case pickmarkerItem: /*000611*/
              DopickmarkerDialog();
          break;
          case visibleoutItem: /*001118*/
              setvisibleout(); /*MAGEMENU.c*/
          break;
          case otheraboutItem:
			  menuaboutOther();/*MAGEUTIL.C*/
          break;

		  case secretItem:
			  menuaboutsecrets(); /*MAGEUTIL.C*/
		  break;
          case showtextItem:
              if (IsIconic(tWindow))
                  SendMessage(tWindow,WM_SYSCOMMAND,SC_RESTORE,0);
              if (GetTopWindow(MageWindow) != tWindow) BringWindowToTop(tWindow);
          break;
          case showcaptionItem:
              if (IsIconic(captionWindow))
                  SendMessage(captionWindow,WM_SYSCOMMAND,SC_RESTORE,0);
              if (GetTopWindow(MageWindow) != captionWindow) BringWindowToTop(captionWindow);
          break;
          case showgraphicsItem:
              if (IsIconic(gWindow))
                  SendMessage(gWindow,WM_SYSCOMMAND,SC_RESTORE,0);
              if (GetTopWindow(MageWindow) != gWindow) BringWindowToTop(gWindow);
			  redrawvec();
          break;
          case showtableItem:
              if (IsIconic(tableWindow))
                  SendMessage(tableWindow,WM_SYSCOMMAND,SC_RESTORE,0);
              if (GetTopWindow(MageWindow) != tableWindow) BringWindowToTop(tableWindow);
			  redrawtable();
          break;
          
          case aboutItem:
			  setMageinitDLOGreport(); /*MAGEINIT.c to get info into alertstrs*/
			  DoMageDLOGreport(1);      /*___DLOG.c*/
          break;
          case writeaboutItem:
              menuaboutwrite();  /*MAGEMENU.C*/
          break;
          case editaboutItem:
			  menuaboutedit(); /*MAGEMENU.C*/
          break;
          case optionsaboutItem:
			  menuaboutoptions();/*MAGEMENU.C*/
          break;
		  case specialaboutItem:
			  menuaboutspecial();    /*MAGEMENU.C*/
		  break;
          case kludgesaboutItem:
			  menuaboutkluges(); /*MAGEMENU.C*/
          break;
		  case mousehelpItem:
			  menuaboutmouse();   /*MAGEMENU.C*/
		  break;
		  case dockinghelpItem:
			  menuaboutdocking();   /*MAGEMENU.C*/
		  break;

		  case resizehelpItem:
			  menuaboutresize();  /*MAGEMENU.C*/
		  break;
		  case tablehelpItem:
			  menuabouttable();  /*MAGEMENU.C*/
		  break;
		  case makehelptextItem:
			  menuadvancedhelp(1);    /*MAGEMENU.C*/
			  SendMessage(tWindow,WM_SIZE,0,0); /*so any new text will be visible*/
		  break;
		  case makekinemageItem:
			  menuadvancedhelp(2);    /*MAGEMENU.C*/
			  SendMessage(tWindow,WM_SIZE,0,0); /*so any new text will be visible*/
			  redrawvec();
		  break;

          default:
              Lmenu = FALSE; /*if no menu items were selected*/
              return(DefWindowProc(hWnd, message, wParam, lParam));
      }/*switch (wParam) within WM_COMMAND case*/
      Lmenu = FALSE; /*get here by break; So WM_COMMAND found!*/
    return(0); /*since WM_COMMAND had valid entry, do clean return*/
    /*end of the case WM_COMMAND:*/

    case WM_CLOSE:      /* message: Main window being closed */
        /*all ways of quiting go through this close window stuff */
        /*so can close out various arrays before destroy mainwindow.*/
        /*Though a PostQuitMessage is issued, it is unclear that */
        /* the code after the main master loop is accessed once the */
        /* mainwindow is destroyed (all child windows automatically */
        /* destroyed by destroying the mainwindow) so cleanup done here*/
		Lgetnewfile=0;
		LquitMAGE=1;
		ireturnflag=1;
		if(Lpruneactive||Ldrawactive||Lnewviewactive||Lnewstuffactive)
			DoChangeCheckDialog(); /*MPCDLOG*/
		if (ireturnflag)
		{
			destroynewDC();   /*MPCDRAW.C*/ /*offscreen bitmap*/
			/* now, pass this message on through to DefWindowProc where */
			/*it will invoke a WM_DESTROY command! */
			return(DefWindowProc(hWnd,message,wParam,lParam));
		}
		else 
		{
			LquitMAGE=0;
			return(0);
		}

    case WM_DESTROY:     /* message: window being destroyed */
        PostQuitMessage(0);
    return (0);

    case WM_SIZE:
        if (!Initialized) return(0);
        destroyallbuttons();
		GetClientRect(MageWindow,&rect);
		/*for a client: rect.top and rect.left == 0 */
		DisplaySizeX = rect.right;  /*so this is width*/
		DisplaySizeY = rect.bottom; /*so this is height*/
        if (sWindow)
        {
            DestroyWindow(sWindow);
            DestroyWindow(slabWindow);
            DestroyWindow(ztranWindow);
            sWindow = 0;
            slabWindow = 0;
            ztranWindow = 0;
            NewSliderWindows();
        }
        if(nbondrot > 0)
        {
            for(i=1; i<=nbondrot; i++)
            {
                DestroyWindow( bondrotWindow[i] );
                bondrotWindow[i] = 0;
            }
        }
		createbuttons(); /*MPCMENU.C calls SetsinGrafWindow()in MAGEBBOX.C */
           /* which can call creategrafbondrotBar(i) in MPCZBAR.C */
		switch (wParam)
		{
			case SIZE_MAXIMIZED:
				getbuttonplace();
				MoveWindow(gWindow, 0, 0,brect.left - (1 * DisplaySizeX / 200),
					brect.bottom, TRUE);
			break;
			case SIZE_RESTORED:
				getbuttonplace();
				MoveWindow(gWindow, 15*DisplaySizeX/100, 0, brect.left-
					(16*DisplaySizeX/100),(90*DisplaySizeY/100), TRUE);
				MoveWindow(tWindow, 0, 0, brect.left - DisplaySizeX/5,
					4*DisplaySizeY/5, TRUE);
				MoveWindow(captionWindow, 0, 4*DisplaySizeY/5, brect.left -
					(5*DisplaySizeX/100), DisplaySizeY/5, TRUE);
			break;
		}
    return(DefWindowProc(hWnd,message,wParam,lParam));
    case WM_LBUTTONDOWN:
        if (GetTopWindow(MageWindow) != gWindow) BringWindowToTop(gWindow);
    return(0);

	case WM_CHAR:
		switch (wParam)
		{
		   case 'a':	/*press 'a' to do animation */
			   if (nanimate > 1)
			   {
				   Lshiftkey = 0;
				   adjustanimate(1);
				   redrawvec();
			   }
			   break;
		   case 'A':	/*press 'A' to do animation */
			   if (nanimate > 1)
			   {
				   Lshiftkey = 1;
				   adjustanimate(1);
				   redrawvec();
			   }
			   break;
		   case 'b':	/*press 'b' to do animation */
			   if (nanimate > 1)
			   {
				   Lshiftkey = 0;
				   adjustanimate(2);
				   redrawvec();
			   }
			   break;
		   case 'B':	/*press 'B' to do animation */
			   if (nanimate > 1)
			   {
				   Lshiftkey = 1;
				   adjustanimate(2);
				   redrawvec();
			   }
			   break;
		   case 'c':	/* c toggles +,- stereo angle */
			   stereoangle = -stereoangle;
			   redrawvec();
			   break;
		   case 'd':	/* d toggles dragline pick-up/new */ 
			   Ladddrag = !Ladddrag;
			   redrawvec();
			   break;
		   case 'e':	/* e toggles lens feature */
			   setLens();
			   break;
		   case 'f':	/* f toggles flatitemXY mode */
			   setflat();	/* MAGEUTIL.c */
			   break;
		   case 'F':
			   if (Lkinfile) DoSearchDialog();/*MPCDLOG.C*/

			   break;
		   case 'G':
			   if (Lkinfile) DoSearchAgain();
			   break;
		   case 'h':	/* h toggles maintain horizon mode, only Y rotation */
			   sethorizon();	/* MAGEUTIL.c */
			   break;

		   case 'k':	/* k toggles kaleidoscope==plotonly mode */
               setplotonly();
			   break;
		   case 'l':	/* l toggles listcolordominance mode */
			   setlistcolordominance();
			   break;
		   case 'm':	/* m blanks measures lines & dots, does not
						remove old values, does disable measure
						operation, i.e. Lmeasures==0, button==off,
						but potentiates a new measures sequence for
						a new Lmeasures==1, effectively NOP if hit
						when measures button is off */
			   potentiateMeasures(); /*MAGEMENU.c*/
			   break;
		   case 'n':	/* +90 degress around Y axis */
			   getrot(157,0);	/*MAGEDRAW.c*/
			   redrawvec();
			   break;
		   case 'N':	/* -90 degrees around Y axis */
			   getrot(-157,0);
			   redrawvec();
			   break;
		   case 'p':  /* p toggles keepperspective */    /*931001*/
               /*Lkeepperspective = !Lkeepperspective;*/
               /*if(Lkeepperspective) Lperspec = 1;*/
               /*else                 Lperspec = 0;*/
               Lperspec = !Lperspec; /*991130 like Mac 981114*/
               resetmenuchecks(); /* MPCMENU.c */
			   redrawvec();
			   break;
		   case 'Q':
			   quitMAGE();
			   break;
			   
           /* q toggles double-sized markers */ /*000804*/
           case 'q':
               Lscalemarkers = !Lscalemarkers;
               /*resetmenuchecks();no menu item yet*/ /*MACPMENU.C calls AdjustMenus();*/
               rescalekinemage();  /*MAGEINPT*/
               redrawvec();       /*MACDRAW.C*/
               break;
               
		   case 's':   /* s toggles keepstereo */
                if(!Lcompareon)
                {
                    Lkeepstereo = !Lkeepstereo;
                    if(Lkeepstereo) Lstereo = 1;
                    else            Lstereo = 0;
                    resetmenuchecks(); /* MPCMENU.c */
					redrawvec();
                }
				break;
           case 't':  /* t toggles keepthinline */
               Lkeepthinline = !Lkeepthinline;
               if(Lkeepthinline) Lthin = 1;
               else              Lthin = 0;
               resetmenuchecks(); /* MPCMENU.c */
			   redrawvec();
			   break;
		   case 'u':	/* u UpdateDialog */
			   if(Lkinfile) DoupdateDialog();
			   break;
		   case 'x':	/* press 'x' : small step trans in -z*/
			   if (Lztran)
			   {
					fxcenternew = fxcenternew - a13;
					fycenternew = fycenternew - a23;
					fzcenternew = fzcenternew - a33;
					rescalekinemage();  /*MAGEINPT.C*/
					redrawvec();
			   }
			   break;
		   case 'X':	/* press 'X': big step translate in -z*/
			   if (Lztran)
			   {
					fxcenternew = fxcenternew - 10*a13;
					fycenternew = fycenternew - 10*a23;
					fzcenternew = fzcenternew - 10*a33;
					rescalekinemage();  /*MAGEINPT.C*/
					redrawvec();
			   }
			   break;
           case 'z':	/*press 'z' to do small step translate in +z*/
			   if (Lztran)
			   {
				   fxcenternew = fxcenternew + a13;
					fycenternew = fycenternew + a23;
					fzcenternew = fzcenternew + a33;
					rescalekinemage();  /*MAGEINPT.C*/
					redrawvec();
			   }
			   break;
		   case 'Z':	/*press 'Z' to do big step translate in +z*/
			   if (Lztran)
			   {
				    fxcenternew = fxcenternew + 10*a13;
					fycenternew = fycenternew + 10*a23;
					fzcenternew = fzcenternew + 10*a33;
					rescalekinemage();  /*MAGEINPT.C*/
					redrawvec();
			   }
			   break;
		   case '1': /* 1 zooms by one unit*/
			   {
				   zoom = zoom +(float)0.01;
                   if(zoom > 10.04) zoom = (float)10.04;/*maximum*/
                   adjustzoom();
			   }
			   break;
		   case '2': /* 2 zooms by ten units*/
			   {
                   zoom = zoom +(float)0.1;
                   if(zoom > 10.04) zoom = (float)10.04;/*maximum*/
                   adjustzoom();
			   }
			   break;
		   case '3': /* 3 zooms by one unit*/
			   {
                   zoom = zoom -(float)0.01;
                   if(zoom < .04) zoom = (float).04;/*minimum*/
                   adjustzoom();
			   }
			   break;
		   case '4': /* 4 zooms by ten units*/
			   {
                   zoom = zoom -(float)0.1;
                   if(zoom < .04) zoom = (float).04;/*minimum*/
                   adjustzoom();
			   }
			   break;

		}
		return(DefWindowProc(hWnd,message,wParam,lParam));
	case WM_KEYDOWN:
		switch (LOWORD(wParam))
		{
		   case VK_LEFT:
			   /*<- one degree less of current bondrotation*/ /*981014*/
			   if (nbondrot > 0) grafbondrotarrow(-1.0);
			   break;
		   case VK_RIGHT:
			   /*-> one degree more of current bondrotation*/ /*981014*/
			   if (nbondrot > 0) grafbondrotarrow(+1.0);
			   break;
		   case VK_DOWN:
			   /*-> plot current H vs V bondrot angles*/ /*981014*/
			   if(nbondrot > 0 && LbondrotHplot > 0 && LbondrotVplot > 0)
				   dobondrotplotter();
			   break;
		   case VK_UP:
			   /*-> graph current H vs V bondrot angles*/ /*001002*/
			   if(nbondrot > 0 && LbondrotHplot > 0 && LbondrotVplot > 0)
				   dobondrotgrapher();
			   break;
		}
		return(DefWindowProc(hWnd, message, wParam, lParam));

    default:      /* Passes it on if unproccessed */
    return (DefWindowProc(hWnd, message, wParam, lParam));

	  /*case level*/
    }/*switch (message) MainWndProc master case switches*/
    /*out of all case switches*/
}
/*___MainWndProc()__________________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/

/****adjustzoom()*************************************************************/
void adjustzoom()
{
   resetgrafzoomBar();
   scalenew = Scale*zoom;
   rescalekinemage();
   redrawvec();
}
/*___adjustzoom()____________________________________________________________*/

/****quitMAGE()***************************************************************/
void quitMAGE()
{
    SendMessage(MageWindow,WM_SYSCOMMAND,SC_CLOSE,0);
}
/*___quitMAGE()______________________________________________________________*/

/****GraphWndProc()**********************************************************/
LRESULT CALLBACK GraphWndProc(HWND hWnd, UINT message,
							  WPARAM wParam, LPARAM lParam)
{
PAINTSTRUCT ps;
HDC hDC;

  switch (message)
  {
    case WM_PAINT:
        hDC = BeginPaint(hWnd,&ps);
        paintaux(hDC);
        EndPaint(hWnd,&ps);
        return(0);
    case WM_LBUTTONDOWN:
		WMLButtonDown(lParam);
        return(0);
    case WM_LBUTTONUP:
		WMLButtonUp();
        return(0);
    case WM_MOUSEMOVE:
		if((LOWORD(wParam) == MK_LBUTTON) || (LOWORD(wParam)==(MK_LBUTTON|MK_SHIFT)))
		{
			WMMouseMove(lParam);
		}
		return(0);
    case WM_SIZE:
        if (Initialized) WMSize((int)LOWORD(lParam),(int)HIWORD(lParam));
        return(0);

	case WM_CHAR: /* pass the keystroke along b/c this window */
	case WM_KEYUP:/* doesn't do anything with it */
    case WM_KEYDOWN:
        SendMessage(MageWindow,message,wParam,lParam);
       return(0);

    default:
       return(DefWindowProc(hWnd, message, wParam, lParam));
  }
}
/*___GraphWndProc()_________________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****WMLButtonDown()********************************************************/
void WMLButtonDown(LPARAM lParam)
{
/*equivalent to MACMAIN/DografContentClick(), MUX_MAIN/pick_CB */
/*and MACDRAW/Drawgraf()*/
    int iresetztran;
    POINTS picked;
    int Nblank = 0; /*000410*/

    if (!Initialized) return;

    if (GetTopWindow(MageWindow) != gWindow) BringWindowToTop(gWindow);

    tracking = 1;

    SetCapture(gWindow);  /*all mouse events sent to gWindow*/

    picked = MAKEPOINTS(lParam);

    /* store the picked point */
    pickx = picked.x;
    picky = picked.y;
    /* store current point as old point */
    xold = pickx;
    yold = picky;

    mousexold = xold;
    mouseyold = yold;

    if(Lflat)
    {/*flatland scrolling*/
        makecursorflatland();
        irotxy = 1;
    }
    else
    {/*3D rotations*/
        if( yold > (GHEIGHT/6) )
        {
            irotxy = 1;
        }
        else
        {
            irotxy = 0;
        }
        if(irotxy==1) makecursorxyrot(); /*___MAIN.C*/
        else          makecursorzrot();  /*___MAIN.C*/
    }
    ipick = 2;
    Lpicknow = 0;  /* flags when get first valid pick */
    Lpick = 0;  /* maintains state for routing */
    if(Ldraglineon || Lnewlabelson) /*991130*/
    {
        Lnewdrag = 1;
        Lnewmatrix = 1;
    }

    fullupdaterate = updateratelimit;
    /*set rate so starts with a full update*/
    redrawvec();
    iresetztran = 0;
    if(Lrecalculate)
    {
        /*rescalekinemage(); ?????*/
        iresetztran = 1;
    }
    while(Lpicknow) /*990211*/
    {
        if(Ltablepickactive && Ltablegraphpicked) /*000327*/
        {/*try to find a corresponding cell in table to graphics picked point*/
           getptIDstring(search1str, pickedpointptr);/*MAGELIST*/
           for(isearch1=0;isearch1<256;isearch1++)
           {
              if(search1str[isearch1]==' ') Nblank++; /*000410*/
              if(search1str[isearch1]=='\0') break;
           }/*isearch1 is size of pointID str*/  
           if(isearch1 == Nblank) isearch1 = 0; /*000410*/
           isearch2 = 0;
           if(isearch1 > 0)  /*000410*/
           {
              searchtablecells(0); /*MAGETABL.c: 0 == match {ptID}*/
              Ltablegraphpicked = 0;/*avoid coordinate matching in drawtable()*/
              redrawtable();/*000324*/
              removetablemarkpoints();
              markfromtablecellsID(1); /*MAGETABL.c flag==1 for ptID matching*/      
           }
        }
        Lpick = 1;
        Lpicknow = 0;
        if(Lsuperpunchon) ipick = 2; 
        /*ipick == 2 allows picking, so Lpicknow could become ==1 */ /*990211*/
        if(Lztran && iresetztran)  /*pickcenter so rezero ztran*/
        {
             iztran = 0;
             resetgrafztranBar(iztran);  /*MACMXMC.C MPCEXTRA.C*/
        }
        if(Lconstruct4on && Lpoint>=4) DoconstructDialog();
        else if(Lconstruct5on && Lpoint==5) DoConstructFifthDialog();
        if(Lpickcoloron) DocolorshowDialog();
        if(Lpickshowon)  DopickshowDialog();
        redrawvec();
    }
    iresetztran = 0;
    /*if(Ltablepickactive && Ltablegraphpicked) redrawtable();*//*000324*/

}
/*___WMLButtonDown()______________________________________________________*/

/****WMLButtonUp()**********************************************************/
void WMLButtonUp()
{
  makecursoractive();
  tracking = 0;
  if(Lmousedown && !Ldetail)
  {
	  Lmousedown = 0;
	  redrawvec();/*redraw with full detail*/
  }
  ReleaseCapture();
}
/*___WMLButtonUp()________________________________________________________*/

/****WMMouseMove()*********************************************************/
void WMMouseMove(LPARAM lParam)
{
   int idelx, idely;
   POINTS picked;

   if(!Initialized) return;

   if(tracking)
   {/*tracking*/
      picked = MAKEPOINTS(lParam);
      pickx = picked.x; /* store the picked point */
      picky = picked.y;
      idelx = pickx - xold; /* determine delta from last point */
      idely = picky - yold;
      xold = pickx; /* store current point as old point */
      yold = picky;

      if( (idelx != 0) || (idely != 0) )
      {/*at least one pixel movement*/
         /*just !=0 is too sensitive! mere click triggers Levelofdetail*/
         /*labels can be dragged */  /*991130*/
         if(Lpick&&(Ldraglineon||Lnewlabelson)) Ldraglineactive = 1;
         if(!Ldraglineactive)
         {   /*VK_MENU refers to the Alt key, */
             /*CONTROL key has special properties in PC*/
            if(GetAsyncKeyState(VK_MENU) < 0) Lscroll = 1; /*Laltkey*/
            else Lscroll = 0; /*Lscroll is independent of Lflat*/
            if(irotxy == 1 && Lshiftkey) /*==1 for initial decision*/
            {/*emphasize x or y : use >=1 for change emphasis while moving*/
               if(idely*idely < idelx*idelx)  irotxy = 2; 
                                /*rotate around y axis*/
               else irotxy = 3; /*rotate around x axis*/
            }/*emphasize x or y */
            getrot(idelx,idely); /*MAGEUTIL.c*/
            Lnewmatrix = 1;
            Lmousedown = 1;
	 }
	 else Lmousedown = 0;
         redrawvec();
      }/*at least one pixel movement*/
   }/*tracking*/
}
/*___WMMouseMove()________________________________________________________*/

/****ResizeMageGraphics()*************************************************/
void ResizeMageGraphics(int width, int height)
{
	int tryfontsize;
	int maxwideremembered = oldmaxwide; /*990112*/

	GWIDTH = width;
	GHEIGHT = height;
	WIDTH =  GWIDTH; /*GWIDTH & GHEIGHT adjusted when make grafWindow*/
    HEIGHT = GHEIGHT;/* WIDTH & HEIGHT reset then also */

	/* cloned from MAC routines */
	igrafscrntall = GHEIGHT;
	if(GWIDTH < 0) GWIDTH = 0;
    if(GWIDTH < GHEIGHT) oldmaxwide = GWIDTH;
    else                 oldmaxwide = GHEIGHT;
	ixctr = GWIDTH/2;
	iyctr = GHEIGHT/2;
	izctr = oldmaxwide/2;
    ieyewide = GWIDTH/2;
    Scale = oldmaxwide/fdiff;
    scalenew = Scale*zoom;
    /*original settings GWIDTH==400,izclip == 200*/
    fzclip =  ((float)oldmaxwide/(float)400) ;
    izclip = (int)(fzclip*izclipold[0]);
        /*working zclip set from new/stored graphics size*/
/*	iztran = fzclip*iztran; *//* to be implemented */
	rescalekinemage();

	if(oldmaxwide != maxwideremembered)   /*990112*/
    {/*genuine change, not just adding/removing bondrot sliders*/
       /*also see SetUpGrafWindow near bottom, and resizeGrafWindow near bottom*/
       if     (oldmaxwide < 500) tryfontsize = oldfontsize;
       else if(oldmaxwide < 800) tryfontsize = 24;
       else                      tryfontsize = 32;
       if(!Linfofontsize )  infofontsize   = tryfontsize;
       if(!Llabelsfontsize) labelsfontsize = tryfontsize;
       if(!Lwordsfontsize)  wordsfontsize  = tryfontsize;
       /*tablefontsize  should NOT track with graphics screen size*/
    }/*genuine change, not just adding/removing bondrot sliders*/
}
/*___ResizeMageGraphics()________________________________________________*/

/****WMSize()*************************************************************/
void WMSize(int width, int height)
{
	ResizeMageGraphics(width,height);
	destroynewDC();
    makenewDC();
    InvalidateRect(gWindow,NULL,FALSE);
}
/*___WMSize()____________________________________________________________*/

void makecursoractive(){SetCursor((HICON)magecursor);}
void makecursorxyrot() {SetCursor((HICON)xyrotcursor);}
void makecursorzrot()  {SetCursor((HICON)zrotcursor);}
void makecursorflatland()  {SetCursor((HICON)flatlandcursor);}
void makecursorwait()  {SetCursor((HICON)waitcursor);}
/****dummies of MAC routines called by MAGE routines*/
void condition(char dummy[256]) {}
void recondition(char dummy[256]) {}

/****theclockcount()*****************************************************/
long theclockcount(void)
{
    return(GetTickCount());
}
/*___theclockcount()____________________________________________________*/

/****countredraws()***********************************************************/
void countredraws()
{
	long nowticks;

    Lcount = 0;

    ncountticks = theclockcount(); /*MPCMAIN.C*/
    icountticks = ncountticks;     /*time mark at beginning*/
        /*icountticks will be reset as get intermediates */

    /* simulate mouse movement: begin-mouse has moved */
    /* get deltas and call for new rotation matrix	  */
    getrot(0,0);
    redrawvec();
    /*endof-mouse has moved */


    /*time mark at end:*/
    nowticks = theclockcount(); /*MPCMAIN.C*/
    postdrawticks = (nowticks - icountticks);
    icountticks = nowticks;

    totalrunticks = (nowticks - ncountticks);
    if(totalrunticks>=0.0001)
		updaterate = (float)(1000.0/totalrunticks);
		/*updaterate = 1.0/( totalrunticks/60.0 ) ;*/
	else updaterate = 0.0;
	{
         sprintf(alertstr,"timing in ticks = 1/1000 sec: "
            "\015predraw = %ld, preloop = %ld"
            ",\015 firstloop = %ld, secondloop = %ld"
            ",\015 pastcopy = %ld, postdraw = %ld"
			" \015\015totalrun = %ld,          updaterate = %.3f per sec"
            ,predrawticks,preloopticks,firstloopticks,secondloopticks
			,postcopyticks,postdrawticks,totalrunticks,updaterate);
		 sprintf(alertstr2,
			"\015\015number of 2-D move-draws = %ld, out of %ld triples "
            "\015 (text has %ld chars)"
			,nmovedraws,nxyz,ntotaltext);   /*970424 ld*/
		 sprintf(alertstr3,"");
		 DoMageDLOGreport(1);
	}
}
/*___countredraws()__________________________________________________________*/
