#include "MAGE.h"
#include "MAGELIST.h"
#include "MAGEBBOX.h"
#include "MAGEFLAG.h"
#include "MAGEANGL.h"
#include <direct.h>

/* save the current directory in a global array so we can look for */
/* the next file in it */
char szWMDirName[256];
/****writeoutput()********************************************************/
void writeoutput(int kind)
{
    /*specific output controlled by kind */

    char *cpslash;
	char chReplace;
	char szFile[256],szFileTitle[256],OutStr[256],
		TestStr[256],szFilter[256];
	char szWMDirName[256] = {0};

    int h,i,j,n,Lnameflag;
    OPENFILENAME ofn;
    UINT ii, cbString;

   makecursorwait();

   Lnameflag = 0; /*flag for derived simple name becoming too long*/    
   n = -1; /*keeps track of last \ directory boundary in full path name*/
    for(i=0;i<256;i++)
    {/*isolate local, simple name from Full Path Name*/
        if(NameStr[i] == '\\') n=i;
        if(NameStr[i] == '\0') break;
    }/*derive output file names from a full kinemage, not an appended file*/
   h = 0; /*index for working version of input name*/
   j = 0; /*flag position for a .kin type suffix to be replaced*/
   /*n is either==0, or set to first char of simple name in the Full Path name*/
    for(i=n+1;i<256;i++)   /*just work in actual local file name part*/
   {/*make copy of working part of input file name, flagged for last . */
      TestStr[h] = NameStr[i]; /*this has exact name of current input file*/
      if(TestStr[h] == '.') j = h; /*j indexes last . in TestStr*/
      if(TestStr[h] == '\0') break;
      h++;
   }
   TestStr[255] = '\0';/*safety, name should be a regular C string at this point*/
   if(j >= 251 || (j==0 && i>=251) ) 
   {                        /* j      */
      Lnameflag = 1;    /* .kip\0 */
      TestStr[251] = '\0';  /* 12345  */
	  j = 251;
   }
   else if(j==0)
   {
      j = h; /*starting index of .new name suffix */
   }
   inventoutputname(kind,j,TestStr,OutStr,Lnameflag);/*MAGEOUT.c*/
      /* construct output file name from input file name */
      /* add 2,3,or 4 char: .new to input file name */
      /* or replace last .___ with .new*/
      /* no matter what that name is like. new==vw,ksp,kqa,kip,...,kipn*/

   Lnameflag = 1; /*reuse this flag*/
   while(Lnameflag)
   {/*Lnameflag: use standard file selection to confirm output file name*/
      Lnameflag = 0; /*reset this flag to presume useable file name*/

      if (*szWMDirName == '\0') _getcwd(szWMDirName,sizeof(szWMDirName));
      szFile[0] = '\0';
      if(kind == 1) strcpy(szFilter,"View (*.vw)|*.vw|");
      if(kind == 2) strcpy(szFilter,"Focus Point Coordinate (*.fpt)|*.fpt|");
      if(kind == 3) strcpy(szFilter,"Draw New Parts (*.new)|*.new|");
      if(kind == 4) strcpy(szFilter,"Rotated Parts (*.rot)|*.rot|");
      if(kind == 5) strcpy(szFilter,"Modified Kinemage (*.kip)|*.kip|");
      if(kind == 6) strcpy(szFilter,"Postscript File (*.eps)|*.EPS|");
      if(kind == 7) strcpy(szFilter,"Question/Answer File (*.kqa)|*.KQA|");
	  if(kind == 8) strcpy(szFilter,"Raster3D Render File (*.r3d)|*.r3d|");
	  if(kind == 9) strcpy(szFilter,"POV-Ray render File (*.pov)|*.pov|");
	  if(kind == 10) strcpy(szFilter,"Point ID File (*.pid)|*.pid|");
  
      cbString = strlen(szFilter);
      chReplace = szFilter[cbString-1];
      for (ii = 0; szFilter[ii] != '\0'; ii++)
        if (szFilter[ii] == chReplace) szFilter[ii] = '\0';
      /*szFliter is a buffer with two \0 terminated strings ended with another \0 */
      /* in order to accomplish this, the |==cbString-1 char is replaced by \0 */

	  strcpy(szFile,OutStr);

      memset(&ofn,0,sizeof(OPENFILENAME));
      ofn.lStructSize = sizeof(OPENFILENAME);
      ofn.hwndOwner = MageWindow;
      ofn.lpstrFilter = szFilter;
      ofn.nFilterIndex = 1;
      ofn.lpstrFile = szFile;
      ofn.nMaxFile = sizeof(szFile);
      ofn.lpstrFileTitle = szFileTitle;
      ofn.nMaxFileTitle = sizeof(szFileTitle);
      ofn.lpstrInitialDir = szWMDirName;
      /* ofn.lpstrDefExt = szFilter+2; */
      ofn.lpstrTitle = word;
      ofn.Flags = OFN_OVERWRITEPROMPT | OFN_HIDEREADONLY;

      if (GetSaveFileName(&ofn))
      {/*succesful file name*/
         lstrcpy(szDirName,ofn.lpstrFile); /*global char szDirName[256] */
		 lstrcpy(OutStr,ofn.lpstrFile);
         /* szDirName temporarily contains the entire file name,*/
         /* and it is in the default data segment, */
         /* which is what fopen() wants for its first argument */
         if(strcmp(NameStr,szDirName)==0)
         {/*OutStr == current input name, this is pathelogical*/
            Lnameflag = 1; /*cannot use this file name*/
            sprintf(word,"MUST EDIT THIS NAME");
         }/*or had to be edited to be valid, so pathelogical until changed*/

      }/*succesful file name*/
      else goto clearwriteconditions; /*canceled file select procedure*/            
   }/*Lnameflag: use standard file selection to confirm output file name*/

   /*succesful file name in hand if reach this point*/
   /*file name recognizable and not pathelogical*/
   if(fpout != NULL) fclose(fpout);/*if a previous file is open, close it*/
   fpout = fopen(szDirName,"w");/*FILE *fpout;  in MAGE.H*/
   if ((cpslash = strrchr(szDirName,'\\')) != NULL) *cpslash = '\0';
   if (fpout == NULL)
            MessageBox(MageWindow,(LPSTR)"Cannot open file",
            (LPSTR)"Mage Error",MB_OK);
   else
   {/*succesful file open*/
      /*NameStr only used when replacing full kinemage file*/
      if(!routeoutput(kind,OutStr,NameStr)) /*MAGEOUT.c*/
         goto clearwriteconditions;
    }/*succesful file open*/
    makecursoractive();

    if(Lgetnewfile) OpenNewFile();
    else if(LquitMAGE) quitMAGE(); /*MACMENU,MPCMAIN,MUXMMENU*/
    else if(Lclosedrawline) closedrawline(); /*MAGEMENU*/
    else if(Lgetnextkinemage) getnextkinemage(); /*MAGEFILE.C*/
    else if(Lgetkinemagechoice) getkinemagechoice(); /*MAGEUTIL*/
    return; /*successful*/
    
    clearwriteconditions:
     Lgetnewfile=0;
     LquitMAGE=0;
     Lclosedrawline=0;
     Lgetnextkinemage=0;
     Lgetkinemagechoice=0;
    makecursoractive();
    return;  /*unsuccessful*/
}
/*___writeoutput()___________________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****writecaption()***********************************************************/
int writecaption()
{
    long              icharhit,icharend,icharbegin; /*931125*/
    int               j=0,k;
    LPSTR             textbuf;

    /*931125 begin write caption*/
    textbuf = (LPSTR)GetWindowLong(captionWindow,TEXTHANDLE);

    icharhit = 0;
    icharbegin = 0;
    icharend = GetWindowLong(captionWindow,TEXTLENGTH);
    if(icharend>0)
    {
        /*space in over the "Kinemage  %d - " characters*/
        /*Mage always puts this on, so always strip it off beginning*/
        while(textbuf[icharbegin]!='-') icharbegin++;
		icharhit = icharbegin = icharbegin+2;

        fprintf(fpout,"@caption%c",EOLOUT); /*990124*/

        while(icharhit<icharend)
        {
            for(j=0;j<254;j++)
            {
                icharhit = icharbegin+j;
                if(icharhit<icharend)
                {
                    word[j]=textbuf[icharhit];
					if (word[j] == EOL) word[j] = EOLOUT;
                }
                else
				{
					word[j] = '\0';
					break;
				}
            }
            word[j+1] = '\0';/*insurance in case doesn't end with break*/
            fprintf(fpout,"%s",word);
            icharbegin = icharhit+1;
        }
		/*990124 ends with j & j+1 as '\0' unless text ends on j==254*/
        /*work backwards from j+1 to ensure that last char is an EOLOUT*/
		k = j+1 ;
        while( k>= 0, word[k]=='\0') k--;
        /*k has last effective character of the string*/
        /*if this falls through to k==0, then safety EOLOUT is done*/
        if(word[k] != EOLOUT) fprintf(fpout,"%c",EOLOUT);
    }
    return(0);
}
/*___writecaption()__________________________________________________________*/

/****writetext()*************************************************************/
int writetext()
{
    long              icharhit,icharend,icharbegin; /*931125*/
    int               j=0, k;
    LPSTR             textbuf;

    /*931125 begin write caption*/
    textbuf = (LPSTR)GetWindowLong(tWindow,TEXTHANDLE);

    icharhit = 0;
    icharbegin = 0;
    icharend = GetWindowLong(tWindow,TEXTLENGTH);
    if(icharend>0)
    {
        icharhit = icharbegin;

        fprintf(fpout,"@text%c",EOLOUT); /*990124*/

        while(icharhit<icharend)
        {
            for(j=0;j<254;j++)
            {
                icharhit = icharbegin+j;
                if(icharhit<icharend)
                {
                    word[j]=textbuf[icharhit];
					if (word[j] == EOL) word[j] = EOLOUT;
                }
                else
				{
					word[j] = '\0';
					break;
				}
            }
            word[j+1] = '\0';/*insurance in case doesn't end with break*/
            fprintf(fpout,"%s",word);
            icharbegin = icharhit+1;
        }
		/*990124 ends with j & j+1 as '\0' unless text ends on j==254*/
        /*work backwards from j+1 to ensure that last char is an EOLOUT*/
        k = j+1 ;
        while( k>= 0, word[k]=='\0') k--;
        /*k has last effective character of the string*/
        /*if this falls through to k==0, then safety EOLOUT is done*/
        if(word[k] != EOLOUT) fprintf(fpout,"%c",EOLOUT);/*000410*/
    }
    return(0);
}
/*___writetext()____________________________________________________________*/

/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****writequesanswers()*******************************************************/
int    writequesanswers() /*931113*/
{
    int j,ireturn,iend,Lquestionhere,flowID,Lnew;

    LPSTR textbuf;

    enum
    {
         skipID = 1
        ,numID = 2
        ,keepID = 3
    };
            textbuf = (LPSTR)GetWindowLong(tWindow,TEXTHANDLE);
            Lquestionhere = 0;
            iQstring = 0;
            iend = GetWindowLong(tWindow,TEXTLENGTH);
            flowID = skipID;
            fprintf(fpout,"Questions from file: %s\n",NameStr);
            for(j=4;j<iend;j++)
            {/*scan over all char in text buffer*/
                if(   textbuf[j-4] == '*'
                   && textbuf[j-3] == '{'
                   && textbuf[j-2] == 'Q'
                   && textbuf[j-1] == ':'
                   && textbuf[j  ] == ' ' )
                {/*find the number*/
                    flowID = numID;
                    Lquestionhere = 1;
                    Lnew = 1;
                }
                if(   textbuf[j-1] == '}'
                   && textbuf[j  ] == '*' )
                {/*found all the question*/
                    flowID = skipID;
                    if(Lquestionhere)
                    {/*really was a question*/
                         Qstring[iQstring-1] = '\0'; /*lop off bracket*/
                         fprintf(fpout,"Q:%d: %s\n"
                            ,nQuestion,Qstring);
                         fprintf(fpout," A:%d: %s\n"
                            ,nQuestion,thisanswer[nQuestion]);
                    }
                    Lquestionhere = 0;
                    iQstring = 0; /*reset char counter*/
                }

                switch(flowID)
                {/*switch*/
                    case skipID:
                        /* neutral: no flow designated, discard characters */
                    break;
                    case numID:
                        /*when done, getinteger returns as 1  */
                        if( getinteger(textbuf[j],Lnew) ) /*MAGEINPT.C*/
                        {
                            nQuestion = intpass;
                            /*intpass global to pass int back */
                            flowID=keepID; /* accummulate characters */
                        }
                        Lnew = 0;
                    break;
                    case keepID:
                        Qstring[iQstring++] = textbuf[j];
                    break;

                }
            }/*scan over all char in text buffer*/
            ireturn = 1;
            fclose(fpout);
    return(ireturn);
}
/*___writequesanswers()_____________________________________________________*/

/* name: p2sys.c                                      */

/*          ** WINDOWS VERSION of p2sys **            */

/* author: J. Michael Word      date written: 11/4/97 */
/* purpose: spawn off a command and return pipes for  */
/*          communication with the process            */

/* WARNING: You should call p2done() to stop the child*/
/*          process before stopping the parent.       */

/* WARNING: If you overflow the data buffer when      */
/*          writing to the child process, you will    */
/*          hang. This is mostly a problem if the     */
/*          child produces a large amount of output   */
/*          before it has finished reading its input. */
/*          The buf max is defined below.             */

#define PIPE_BUF_MAX 4096

#define PROCESS_OPEN_MAX 5

/* record of file handles and process ids */
struct child_io_rec {
   HANDLE id;
   HANDLE fileptr[2];
} P2SYS_KidInfo[PROCESS_OPEN_MAX];

static int P2SYS_Kid = 0;

/* p2sys() - executes a command and returns a vector with two file handles. */
/*      The first is for writing data to the command and the second is for  */
/*      reading the results.												*/
/****p2sys()*****************************************************************/
HANDLE* p2sys(int putout, char *command_line)
{
	/* putout is a flag that identifies PROBE or PREKIN as the spawned app */
	/* PREKIN only needs an output pipe to write a rotation group to       */
   HANDLE hNew			= NULL;
   STARTUPINFO			si;
   PROCESS_INFORMATION	pi;
   SECURITY_ATTRIBUTES	security;

   int bOK				= 0;

   /* set the security attributes to allow inherited handles */
   security.nLength					= sizeof(security);
   security.lpSecurityDescriptor	= NULL;
   security.bInheritHandle			= TRUE;

   if (P2SYS_Kid >= PROCESS_OPEN_MAX)
   {
      fprintf(stderr, "ERROR p2sys: too many open processes\n");
      return NULL;
   }

   /* Initialize structures */
   ZeroMemory( &si, sizeof(STARTUPINFO) );
   ZeroMemory( &pi, sizeof(PROCESS_INFORMATION) );
 
   si.cb          = sizeof(STARTUPINFO);
   si.dwFlags     = STARTF_USESTDHANDLES;

   /* P2SYS_KidInfo[P2SYS_Kid].fileptr[0] is write pipe to consol app */
   /* P2SYS_KidInfo[P2SYS_Kid].fileptr[1] is read pipe from consol app */

   /* create pipe to write to console application, i.e. PROBE/PREKIN */
   if (putout) /* test to see if PROBE will be the spawned application */
   {
	   if (!CreatePipe(&si.hStdInput, &(P2SYS_KidInfo[P2SYS_Kid].fileptr[0]),
	   &security, PIPE_BUF_MAX))
	   {
			perror("CreatePipe");
			return NULL;
	   }
	   
	   /* duplicate write handle with no inheritance, closing original */
	   if (!DuplicateHandle(GetCurrentProcess(), P2SYS_KidInfo[P2SYS_Kid].fileptr[0],
		   GetCurrentProcess(), &hNew, 0, FALSE, DUPLICATE_CLOSE_SOURCE |
		   DUPLICATE_SAME_ACCESS))
	   {
		   CloseHandle(si.hStdInput);
		   perror("DuplicateHandle");
		   return NULL;
	   }
	   P2SYS_KidInfo[P2SYS_Kid].fileptr[0] = hNew;
   }

   /* open pipe to read from console application, both PREKIN and PROBE need this */
   if (!CreatePipe(&(P2SYS_KidInfo[P2SYS_Kid].fileptr[1]), &si.hStdOutput,
	   &security, PIPE_BUF_MAX))
   {
	   CloseHandle(si.hStdInput);
	   perror("CreatePipe");
	   return NULL;
   }

   /* duplicate read handle with no inheritance, closing original */
   if (!DuplicateHandle(GetCurrentProcess(), P2SYS_KidInfo[P2SYS_Kid].fileptr[1],
	   GetCurrentProcess(), &hNew, 0, FALSE, DUPLICATE_CLOSE_SOURCE  |
	   DUPLICATE_SAME_ACCESS))
   {
	   CloseHandle(si.hStdInput);
	   CloseHandle(si.hStdOutput);
	   perror("DuplicateHandle");
	   return NULL;
   }
   P2SYS_KidInfo[P2SYS_Kid].fileptr[1] = hNew;

   /* create child */
   bOK = CreateProcess(NULL, command_line, NULL, NULL, TRUE,
	   DETACHED_PROCESS | HIGH_PRIORITY_CLASS, NULL, NULL, &si, &pi );

   if (!bOK)
   {
	   perror("CreateProcess");
	   return NULL;
   }
   else 
   {
	   /* store process handle as identifier for child record */
	   P2SYS_KidInfo[P2SYS_Kid].id = pi.hProcess;
   }

   /* give console application (only PROBE) plenty of time to open */
   if (putout) WaitForInputIdle(pi.hProcess,5000);

   /* close the handles copied into STARTUPINFO for CreateProcess */
   CloseHandle(si.hStdInput);
   CloseHandle(si.hStdOutput);

   /* assign read handle to global so GetStuffFromFile() can see it */
   readpipe = P2SYS_KidInfo[P2SYS_Kid].fileptr[1];

   return P2SYS_KidInfo[P2SYS_Kid++].fileptr;
}

/*___p2sys()________________________________________________________________*/

/****p2closeData()****closes the data pipe (but not the results pipe)********/
int p2closeData(HANDLE *fileptr)
{
   int i, rc = -1;
   
   for(i=0; i < P2SYS_Kid; i++)
   {
      if (P2SYS_KidInfo[i].fileptr == fileptr)
	  {
		  break;
	  }
   }
   if (i < P2SYS_Kid)
   {
      if (fileptr[0])
	  { 
		  CloseHandle(fileptr[0]);
		  fileptr[0] = NULL;
	  }
      rc = 0;
   }
   return rc;
}
/*___p2closeData()__________________________________________________________*/

/****p2done()****closes both pipes to the command****************************/
/* returns < 1 if there is a problem */
int p2done(HANDLE *fileptr)
{
   int i, ok = 0, rc = 0;
   unsigned long status = 0;
   
   for(i=0; i < P2SYS_Kid; i++)
   {
      if (P2SYS_KidInfo[i].fileptr == fileptr)
	  {
		  break;
	  }
   }
   if (i < P2SYS_Kid)
   {
      if (fileptr[0])
	  {
		  CloseHandle(fileptr[0]); fileptr[0] = NULL;
	  }
      if (fileptr[1])
	  {
		  CloseHandle(fileptr[1]); fileptr[1] = NULL;
	  }

      /* try to kill the detatched process before we say we are done */

      while (ok = GetExitCodeProcess(P2SYS_KidInfo[i].id, (unsigned long*)&status)
	         && status == STILL_ACTIVE) 
	  { /* hang (!) waiting for child to terminate */ }

      if (! ok) 
	  {
	     perror("GetExitCodeProcess");
	     rc = 0;
	     /*return 0;*/
	  }
      else rc = 1; 
		/* success */

      for(i++; i < P2SYS_Kid; i++) P2SYS_KidInfo[i-1] = P2SYS_KidInfo[i];
      P2SYS_Kid--;
   }
   return rc;
}
/*___p2done()_______________________________________________________________*/

/****doupdate()*********remote update****************************************/
void doupdate(int putout, char command[256])
{
HANDLE* p2sys(int putout, char *command_line);
int p2closeData(HANDLE *fileptr);
int p2done(HANDLE *fileptr);
int i;

   char mybuf[256];
   DWORD written;

   HANDLE pdbf = NULL;
   HANDLE *fpv = NULL;

   static char commandstr[256];

   if(command[0]!='"') strcpy(commandstr, command);
	/*NOT ditto an earlier commandstr*/

   Lnewfile = 0; /*reset new file name available flag*/

   /*request p2sys() for pipe pseudo files to write to: fpv[0], */
   /*and read from: fpv[1]*/
   if ((fpv = p2sys(putout,commandstr)) == NULL) 
   {
      perror("p2sys");
      /* exit(1); prevent MAGE from closing b/c of pipe error */
	  return; /* PROBE etc. couldn't be opened, exit w/o killing MAGE */
   }
   if(putout)
   {/*write coords of rotation group, to pipe, e.g. to PROBE */
      Lkinformat = 0; /*NOT kin format, so will be PDB format*/
   
      writerotatedPC(fpv[0]); /*MAGEOUT.c*/
	  /*mybuf[0] = 4; send Ctrl-D char to probe to tell it this
	  mybuf[1] = 0;   is the end of the input we are sending, not necessary*/
	  WriteFile(fpv[0], mybuf, (DWORD)strlen(mybuf), &written, NULL);
   }/*write coords of rotation group, to pipe, e.g. to PROBE */

   /*close the pseudo file pipe line that went out to the remote program*/
   p2closeData(fpv); /*this will close fpv[0] == fpout*/

   /*option to delete group(s) previously appended to this kinemage*/
   if(Ldeleteappend)
   {
      killappendedgroups(); /*MAGELIST.c*/
   }
   else
   {/*make permanent any previously appended groups*/
      firstappendgrupptr = NULL;
      lastappendgrupptr  = NULL;
   }

   /*now read in the stuff generated by the remote program*/
   /*using MAGE parser routines*/
   Lappend = 1;
   /*GetStuffFromFile() has a switch to read from the pipe*/
   GetStuffFromFile(); /*MAGEINPT.c*/
   if(nmaster > 0) 
   {
	   for(i=1; i<=nmaster; i++) resetmaster(i);/*MAGEBBOX*/
      /*each master has a mask position based on "nmaster"*/
   }
   Lappend = 0;

   /*close the pseudo file pipe line that came in from the remote program*/
   p2done(fpv);
}
/*___doupdate()_____________________________________________________________*/

/****doupdatefrompipe()*********remote update********************************/
void doupdatefrompipe(int putout, char command[256])
{
   ;
}
/*___doupdatefrompipe()_____________________________________________________*/

/****flushpipe()*********remote update***************************************/
void flushpipe()
{
   ;
}
/*___flushpipe()____________________________________________________________*/

/****destroyallpipebuff()****************************************************/
void destroyallpipebuff()
{
   ;
}
/*___destroyallpipebuff()___________________________________________________*/

/****writerotatedPC()********************************************************/
void writerotatedPC(HANDLE write)
{
char mybuf[256];
DWORD written;

thisgrupptr = firstgrupptr;
while(thisgrupptr != NULL) {/*loop-over-groups*/
      if(thisgrupptr->bondrot != 0)
      {/*rotated-group*/
        thissgrpptr = thisgrupptr->firstsgrpptr;
        while(thissgrpptr != NULL)
        {/*loop-over-sets*/
          if(thissgrpptr->bondrot != 0)
          {/*rotated-set*/
            thislistptr = thissgrpptr->firstlistptr;
            while(thislistptr != NULL)
            {/*loop-over-lists*/              
              if(thislistptr->bondrot != 0)  /*Sheep from Goats criteria*/
              {/*rotated-list*/ 

                  writeindividuallistPC(write); /*MPCOUT.c*/
                
              }/*rotated-list*/
              if(thislistptr == thissgrpptr->lastlistptr) thislistptr = NULL;
              else thislistptr = thislistptr->nextptr;
            }/*loop-over-lists*/              
          }/*rotated-set*/
          if(thissgrpptr == thisgrupptr->lastsgrpptr) thissgrpptr = NULL;
          else thissgrpptr = thissgrpptr->nextptr;
        }/*loop-over-sets*/
      }/*rotated-group*/
      thisgrupptr = thisgrupptr->nextptr;
    }/*loop-over-groups*/
	sprintf(mybuf, "\n");
	WriteFile(write, mybuf, (DWORD)strlen(mybuf), &written, NULL);
}
/*___writerotated()__________________________________________________________*/

/****writeindividuallistPC()***************************************************/
void writeindividuallistPC(HANDLE write)
{
  int       igoout,k;/*970407*/
  char    wart[256], mybuf[256];
  DWORD   written;

if(  (thislistptr->bondrot >= 0)   /*not a dummy null list */
  /*   &&(thislistptr->on >= 0) */  
     &&(thislistptr->instanceptr == 0) )/*list not an instance */
  {/*this list has points to output*/
       thispointptr = thislistptr->firstpointptr;
       while(thispointptr != NULL)
       {/*loop over point triples*/ 
         igoout = 0; /*look for exceptions*/
         if( !((thispointptr->type) & PRUNED) ) /*survived pruning*/
         {
             igoout = 1;
             if( ( (thispointptr->type) & INVENTED ) )
               igoout=0;
                /*extra, shortened vector internal to MAGE*/
         }
         if(igoout) /*survived exceptions*/
         {/*write point to output*/
          wart[0] = '\0'; /*use wart[], initialize*//*960812*/
          getptIDstring(wart, thispointptr);
          if(     ((thispointptr->type)&VECTOR  ) 
                   && !((thispointptr->type)&MOVETO_P)
                   && !((thispointptr->type)&INVENTED)
                 )
          {/*fish out unique and complete set of DrawTo Vectors*/
           /*for output in BRK PDB format*/
           /*ptID in wart supposed to be in PDB format */
             for(k=0;wart[k]!='\0';k++) wart[k]=toupper(wart[k]);
             sprintf(mybuf,"ATOM      1 %s   %8.3f%8.3f%8.3f\n"
                          ,wart
                          ,thispointptr->fx,thispointptr->fy,thispointptr->fz);
			 WriteFile(write, mybuf, (DWORD)strlen(mybuf), &written, NULL);
/*name[n],&ncnt[n],atom[n],res[n],sub[n],&num[n],rins[n],&x[n],&y[n],&z[n]*/
/*format(a6,i5,1x,a5,a3,1x,a1,i4,a1,3x,3f8.3)*/
/*123456789_123456789_123456789_123456789_123456789_123456789_123456789_123456789_*/
/*atom      1  n   arg a   1      26.465  27.452  -2.490  1.00 25.18      4pti  89*/
          }/*fish out unique and complete set of DrawTo Vectors*/

         }/*write point to output*/
         if(thispointptr == thislistptr->lastpointptr)
             thispointptr = NULL;
         else thispointptr = thispointptr->nextptr;

       }/*loop over point triples*/
     }/*this list has points to output*/
}
/*___writeindividuallistPC()___________________________________________________*/
