/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
#include "MAGE.h"
#include "MAGEMENU.h"
#include "MAGELIST.h"
#include "MAGETABL.h"

void DotableContentClick(LPARAM lParam);
void tableRePaint(HWND hWnd, HDC hDC);
void dotablescroll(HWND, bool, WPARAM);
void resettablescrollbarvalues(HWND);
void makenewtableDC();

/****SetUptableWindow()*******************************************************/
void SetUptableWindow(void)
{
   RECT rect;
	GetClientRect(MageWindow,&rect); 
	/*for a client: rect.top and rect.left == 0 */
	DisplaySizeX = rect.right;  /*so this is width*/
	DisplaySizeY = rect.bottom; /*so this is height*/

   //DisplaySizeX = GetSystemMetrics(SM_CXSCREEN);
   //DisplaySizeY = GetSystemMetrics(SM_CYSCREEN);
	/* Create a graphics window for this application instance.  */

   tableWindow = CreateWindowEx(
		WS_EX_OVERLAPPEDWINDOW,	 /* Extended Window type		*/
		"MageTableClass",        /* See RegisterClassEx() call. */
		"MAGE Table",            /* text for window title bar.	*/
		  WS_CHILD | WS_CAPTION | WS_CLIPSIBLINGS | WS_THICKFRAME 
      | WS_VSCROLL | WS_HSCROLL,
		0,                       /* horizontal position			*/
		DisplaySizeY-100,        /* vertical position: top		*/
		DisplaySizeX-100,		 /* width.						*/
		100,                     /* height.						*/
		MageWindow,              /* parent window				*/
		(HMENU) MAGETABLEID,     /* window identifier			*/
		hInst,					 /* This instance owns this window.*/
		NULL                     /* Pointer not needed.			*/
	);
		   /* | WS_MINIMIZEBOX | WS_MAXIMIZEBOX | WS_SYSMENU,*/
		   /* Window style. No close stuff, no menu stuff*/
		   /*No WS_MAXIMIZEBOX because it goes off bottom, lose pick id*/
		   /*also, buttons are in the MainWindow, so don't readjust*/

	/* NO PROTECTION If window could not be created */

    GetClientRect(tableWindow,&rect); /*????why does one do this here????*/

    if (tableDC!=NULL)
    {
       ReleaseDC(tableWindow,tableDC);
       tableDC = NULL;
    }
    makenewtableDC();

    /* Make the window visible; update its client area; and return "success" */
    ShowWindow(tableWindow, SW_SHOWNA); /* Show the window */	
}
/*___SetUptableWindow()_______________________________________________________*/

/****createtablescrollbars()**************************************************/
void createtablescrollbars()
{
   ;/*resettablescrollbarvalues(tableWindow);*/
}
/*___createtablescrollbars()_________________________________________________*/

/****dotablescroll()**********************************************************/
void dotablescroll(HWND hWnd, bool Lvertical, WPARAM wParam)
{
	RECT rect;
	int adjust=0;
	int newdraw = 1; /*most scroll commands result in a new draw*/
	int movePlace = 0;
    int tablesize=0,tablewindowsize=0;

	GetClientRect(hWnd,&rect);

	if (Lvertical)
	{
		adjust = tablerowheight;
		tablesize = tablehigh;
		tablewindowsize = rect.bottom - rect.top;
	}
	else
	{
		adjust = tablecolwidth;
		tablesize = tablewide;
		tablewindowsize = rect.right - rect.left;
	}

	SCROLLINFO si;
	si.cbSize = sizeof(SCROLLINFO);
	si.fMask = SIF_ALL;
	if (Lvertical) GetScrollInfo(hWnd,SB_VERT,&si);
	else GetScrollInfo(hWnd,SB_HORZ,&si);
	si.nMin = 0;
	si.nMax = tablesize + tablewindowsize;
    /*must allow for the size of the scroll box, the variable thumb size*/
	/*this fancy box or thumb thing changes size with the amount of window*/
	/*space needed to show the whole table - but acts like the low end*/
	/*is the actual position, so max value must be a page size bigger????*/
	si.nPage = tablewindowsize;

	switch (LOWORD(wParam))
	{
        case SB_LINEDOWN:
		  si.nPos += adjust;
          break;
        case SB_LINEUP:
          si.nPos -= adjust;
          break;
        case SB_PAGEDOWN:
          si.nPos += tablewindowsize;
          break;
        case SB_PAGEUP:
          si.nPos -= tablewindowsize;
          break;
        case SB_THUMBTRACK:
        case SB_THUMBPOSITION:
          si.nPos = si.nTrackPos;
          break;
        default:
		  newdraw = 0;
		  break;
	}
	si.nPage = tablewindowsize; /*for the record*/
	/*scroll is from position zero to position==tablesize*/
	/*Mickey Mouse stuff is to let si.nPos track between 0 and tablesize*/
	/*otherwise, use own variables so one can understand the calculation*/
	/*must allow for the size of the scroll box, the variable thumb size*/
	/*this fancy box or thumb thing changes size with the amount of window*/
	/*space needed to show the whole table - but acts like the low end*/
	/*is the actual position, so max value must be a page size bigger????*/
	/*if (si.nPos > (si.nMax-(int)si.nPage)) si.nPos = (si.nMax-(int)si.nPage);*/
    /*if (si.nPos > si.nMax) si.nPos = si.nMax;*/
	/*else if (si.nPos < si.nMin) si.nPos = si.nMin;*/
	if (si.nPos > tablesize) si.nPos = tablesize;
	else if (si.nPos < 0) si.nPos = 0;

   if(newdraw==1)
   {/*valid shift: adjust table and slider postions*/
      if((tablesize-tablewindowsize) > 0)
      {/*something offscreen to scroll to, set zero point of table*/
         /*ratio of slider space == si.nPos/tablesize*/
         movePlace
               = -((tablesize-tablewindowsize)*(si.nPos))/(tablesize);
      }
      if(movePlace > 0) movePlace = 0; /*offset of absolute table zero coord*/

      if(si.nPos == 0) movePlace = 0;
      else if(si.nPos == tablesize)
      { 
         if((tablesize - tablewindowsize) > 0)
             movePlace = -(tablesize-tablewindowsize);
         else movePlace = 0;
      }

	  if (Lvertical)
	  {
		  tablezerohigh = movePlace;
		  SetScrollInfo(hWnd,SB_VERT,&si,TRUE);
	  }
	  else
	  {
		  tablezerowide = movePlace;
		  SetScrollInfo(hWnd,SB_HORZ,&si,TRUE);
	  }
	  redrawtable();
   }/*valid shift: adjust table and slider postions*/
}
/*___dotablescroll()_________________________________________________________*/

/****resettablescrollbarvalues()**********************************************/
void resettablescrollbarvalues(HWND hWnd)
{
	SCROLLINFO si;
	RECT rect;
	int movePlace = 0;
	int verticalwindowsize=0, horizwindowsize=0;

  if(tablehigh > 0 && tablewide > 0)
  {/*table size is defined*/

	GetClientRect(hWnd,&rect);
	verticalwindowsize = rect.bottom - rect.top;
	horizwindowsize = rect.right - rect.left;

	si.cbSize = sizeof(SCROLLINFO);
	si.fMask = SIF_ALL;
 /*reset the values for the vertical scroll bar*/
	GetScrollInfo(hWnd,SB_VERT,&si);
	si.nPage = verticalwindowsize;
	si.nMin = 0;
    si.nMax = tablehigh; 
	/*si.nMax actual table size so scroll bars will disappear when window bigger*/
	
	if((tablehigh-verticalwindowsize) > 0)
    {/*something offscreen to scroll to, set zero point of table*/
         /*ratio of slider space == shiftPlace/maxValue*/
		movePlace
               = -((tablehigh-verticalwindowsize)*(si.nPos))/(tablehigh);
    }
	if(movePlace > 0) movePlace = 0; /*offset of absolute table zero coord*/

    if(si.nPos == 0) movePlace = 0;
    else if(si.nPos == tablehigh)
    { 
       if((tablehigh - verticalwindowsize) > 0)
           movePlace = -(tablehigh-verticalwindowsize);
       else movePlace = 0;
    }
    tablezerohigh = movePlace;
	if (si.nPos > tablehigh) si.nPos = tablehigh;
	else if (si.nPos < 0) si.nPos = 0;

	SetScrollInfo(hWnd,SB_VERT,&si,TRUE);

 /*reset the values for the horizontal scroll bar*/

	GetScrollInfo(hWnd,SB_HORZ,&si);
	si.nPage = horizwindowsize;
    si.nMin = 0;
	si.nMax = tablewide;
	/*si.nMax actual table size so scroll bars will disappear when window bigger*/

    if((tablewide-horizwindowsize) > 0)
    {/*something offscreen to scroll to, set zero point of table*/
       /*ratio of slider space == shiftPlace/maxValue*/
       movePlace
             = -((tablewide-horizwindowsize)*(si.nPos))/(tablewide);
    }
    if(movePlace > 0) movePlace = 0; /*offset of absolute table zero coord*/

    if(si.nPos == 0) movePlace = 0;
    else if(si.nPos == tablewide)
    { 
       if((tablewide - horizwindowsize) > 0)
           movePlace = -(tablewide-horizwindowsize);
       else movePlace = 0;
    }
    tablezerowide = movePlace;
	if (si.nPos > tablewide) si.nPos = tablewide;
	else if (si.nPos < 0) si.nPos = 0;

	SetScrollInfo(hWnd,SB_HORZ,&si,TRUE);
  }/*table size is defined*/

}
/*___resettablescrollbarvalues()_____________________________________________*/

/****tableRePaint()***********************************************************/
/* repaint the table window */
void tableRePaint(HWND hWnd, HDC hDC)
{
	RECT rect;

  if(!Initialized) return;/* general Mage arrays, windows, etc. */

  {
      if (tableDC==NULL) makenewtableDC();
	   GetClientRect(tableWindow,&rect);
      /*erase*/
      FillRect(tableDC,&rect,(HBRUSH)GetStockObject(WHITE_BRUSH));
      drawtable(1);   /* writes to tableDC */

  }
}
/*___tableRePaint()__________________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****makenewtableDC()********************************************************/
void makenewtableDC()
{
  /*HDC tableDC;*/ /*in common*/

  if (tableWindow == 0) return; /* not yet initialized */
  tableDC = GetDC(tableWindow);  /*this has to be balanced by ReleaseDC(DC)*/
  SetBkMode(tableDC,TRANSPARENT);
 
  setpalette(tableDC);
 }
/*___makenewtableDC()_______________________________________________________*/

/****gettablewinedges()*******************************************************/
void gettablewinedges(int* left, int* top, int* right, int* bottom)
{
   RECT rect;

   GetClientRect(tableWindow,&rect);
   *left   =  rect.left;
   *top    =  rect.top;
   *right  =  rect.right;
   *bottom =  rect.bottom;
/*printf("gettablewinedges: %d, %d, %d, %d\n",*left,*top,*right,*bottom);*/
}
/*___gettablewinedges()_____________________________________________________*/


/****MAGETableWndProc()*******************************************************/
LRESULT CALLBACK MAGETableWndProc(HWND hWnd, UINT message,
                            WPARAM wParam, LPARAM lParam)
{                                                     
   PAINTSTRUCT ps;
   HDC hDC;
   BOOL Lprocessed = false;

   switch (message)
   {
    case WM_PAINT:
		hDC = BeginPaint(hWnd,&ps);
		tableRePaint(hWnd, hDC);
		EndPaint(hWnd,&ps);
      break;

	case WM_MOUSEMOVE:
		SetFocus(hWnd);
	  break;
    case WM_LBUTTONDOWN:
		DotableContentClick(lParam);
        Lprocessed = true;
      break;

    case WM_SIZE:
		resettablescrollbarvalues(hWnd);
        InvalidateRect(hWnd,NULL,FALSE);
      break;
	case WM_MOUSEWHEEL:
	  /* reset the values of wParam and then drop into the      */
	  /* WM_VSCROLL procedure and avoid excess code duplication */
	  if ((short)HIWORD(wParam) > 0)
		  wParam = MAKEWPARAM(SB_LINEUP,NULL);
	  else if ((short)HIWORD(wParam) < 0) 
		  wParam = MAKEWPARAM(SB_LINEDOWN,NULL);
    case WM_VSCROLL: /* one function processes both horz and vert scrolls */
        dotablescroll(hWnd, TRUE, wParam);
        InvalidateRect(hWnd,NULL,TRUE);
        Lprocessed = true;
      break;
    case WM_HSCROLL:
        dotablescroll(hWnd, FALSE, wParam);
        InvalidateRect(hWnd,NULL,TRUE);
        Lprocessed = true;
      break;

    default:
      break;
   }
   if(Lprocessed) return(0);
   else return(DefWindowProc(hWnd, message, wParam, lParam));
}
/*___MAGETableWndProc()______________________________________________________*/

/****DotableContentClick()****************************************************/
void DotableContentClick(LPARAM lParam)
{
/*equivalences: */
/*MPCMAIN/WMLButtonDown()*/
/*MPCTABL/DotableContentClick() */
/*MACMAIN/DotableContentClick() */
/*MUXMMAIN/XtCallbackProc tablepick_CB() */
   POINTS picked;

   if (!Initialized) return;

   if (GetTopWindow(MageWindow) != tableWindow) BringWindowToTop(tableWindow);

   picked = MAKEPOINTS(lParam);

   /* store the picked point */
   tablepickx = picked.x;
   tablepicky = picked.y;
   Ltablepicked = 2; /*lurk for a pick*/
   redrawtable(); /*to find possible pick condition*/
   if(Ltablepicked==1) /*tabletographics always active in this direction*/
   {/*table initiated pick operation in graphics window*/
#ifdef OLDPICKBYCOORDCODE
      pickx = -32000; /*set graphics mouseposition to something absurd*/
      picky = -32000; /*since we are going to invoke the */
      ipick = 2; /* regular picking mechanism with a known pickpoint */
      Lpick = 1; /* and depend on it not getting a valid graphics pick*/
                 /* which would override the previous known point*/
      redrawvec(); /*establishes where pick is*/
      redrawvec(); /*need another update of graphics to do picked effect*/
      /*finished operations on the graphics window*/
      /*all table initiated operations done*/
#endif /*OLDPICKBYCOORDCODE*/
      if(Ltablemarkers) removetablemarkpoints();
      markfromtablecellsID(1); /*MAGETABL.c flag==1 for ptID matching*/
       
      redrawvec(); /*establishes where pick is*/
      Ltablepicked = 0; /*used in MAGEDRAW.c/drawvec()*/
      Ltablecellnewlypicked = 0;
   }/*table initiated pick operation in graphics window*/
   Ltablepicked = 0;
}
/*___DotableContentClick()____________________________________________________*/
 
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/

/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/

/****stringtotable()********************common name***************************/
void stringtoscreen(char *s, int x, int y,int icolor)
{
	TEXTMETRIC tm;
	static LOGFONT lf;
    
	/*NOTE: fontheight set by SystemFontSize() call when MAGE starts */
    if(tablefontsize!=0 && tablefontsize!=fontverticalspace)
    {/*not default text, have to build special font*/
        DeleteObject(SelectObject(tableDC,GetStockObject(SYSTEM_FONT)));
        GetTextMetrics(tableDC,&tm);
        lf.lfHeight = tablefontsize;
        DeleteObject(SelectObject(tableDC,CreateFontIndirect(&lf)));
           /*deletes previous object, but brings in new font*/
	}
    SetTextColor(tableDC,PALETTEINDEX(icolor) );
    SetTextAlign(tableDC, TA_UPDATECP | TA_BOTTOM);
    MoveToEx(tableDC,x,y,NULL);
    TextOut(tableDC,x,y,s,strlen(s));
    if(tablefontsize!=0 && tablefontsize!=fontverticalspace)
    {
        DeleteObject(SelectObject(tableDC,GetStockObject(SYSTEM_FONT)));
           /*deletes previous object*/
    }
}
/*___stringtotable()_________________________________________________________*/

/****wordstotable()************************common name************************/
int wordstotable(char commentstr[256],int ix,int iy,int icolor,int bcolor,int ipass)
{ 
   int   j,k,kk,m,mm,oldright,newright,maxright,cellleft,width,Lbkg,Lembedded;
   int   Thissize;
   int   linehigh;

   RECT  rect;				
   HFONT   hFont,hhFont;
   TEXTMETRIC tm;

   static LOGFONT lf;
   int  lineheightnow;
   char szFaceName[LF_FACESIZE]; /* LF_FACESIZE == 32 !?*/

  if(icolor >= 0 && icolor <= 255)
  {/*within 256 palette: a visible color*/
   if(Ltablecellgetwidth || Ltablecellispicked)
   {
      Lbkg = 1;
   }
   else 
   {
      Lbkg = 0;
   }
   if(commentstr[3] != '\0')
   {/*string longer than zero length*/

     Thissize = commentstr[2];
 
     lineheightnow = fontverticalspace;
     if(   (wordsfontsize!=0 && wordsfontsize!=fontverticalspace))
	  {/*not default text, have to build special font*/
        /*SystemFontSize();*/ /*mpczbar.c : fontheight, fontverticalspace*/
        hFont = (HFONT)GetStockObject(SYSTEM_FONT);
        DeleteObject(SelectObject(cDC,hFont));
        GetTextMetrics(cDC,&tm);
		  /*NOTE: LOGFONT and TEXTMETRIC only have a few fields in common */
        /*LOGFONT lf is declared static so is initialized to NULL & 0s */
        /* this seems to let the font be set by defaults */

        GetTextFace(tableDC, sizeof szFaceName, szFaceName);

        lf.lfHeight = tablefontsize;
        if(Thissize>0) lf.lfHeight = Thissize;

        hhFont = CreateFontIndirect(&lf);
        DeleteObject(SelectObject(tableDC,hhFont));/*deletes previous object*/
        /*lineheightnow = lf.lfHeight + tm.tmExternalLeading;*/
        lineheightnow = lf.lfHeight;
     }
	  linehigh = lineheightnow;

//sprintf(alertstr,"linehigh== %d, lf.lfHeight== %d, tm.tmExternalLeading== %d\r\n"
//        ,linehigh,lf.lfHeight,tm.tmExternalLeading);
//inserttexts(alertstr);   /* ___TEXT.C */
//SendMessage(tWindow,WM_SIZE,0,0);
     
     SetTextColor(tableDC,PALETTEINDEX(icolor) );

	  SetTextAlign(tableDC, TA_UPDATECP | TA_BOTTOM);

	  /*NOW TextOut will start at "current position" and update it afterwards*/
	  /*Text will be aligned at bottom left, i.e Mac-like */
	  /*NOW must MoveToEx current position, since TextOut now ignores x,y fields*/

     MoveToEx(tableDC, ix, iy, NULL);
	  Lembedded = 0;
     width = 0;
     maxright = ix;
     oldright = ix;
     newright = ix;
     cellleft = ix;

     k = 3;
     for(j=3;j<=255;j++)
	  {/*loop over all characters in the string*/           
        if(   Lembedded==1
           && (   !(Lsuperpick && Ltablecellispicked)
                || (Ltablecellgetwidth) ) )
        {
           if(commentstr[j]=='>')
           {
              k = j+1;
              Lembedded = 0;
           }
        }
        else
        {/*accept this character*/
           kk = j;
           if(commentstr[j]=='\\')
           {/*backslash character*/
			     /*write out, skip this \, draw next character as special*/
              kk = j-1;
              for(m=0; m<=(kk-k); m++)
              {
                 word[m] = commentstr[k+m];
                 mm = m+1;
              }
              word[mm] = '\0';
              if(Lbkg) 
              {/*bkg rectangle from previous right side to new right edge*/
                 width = LOWORD(GetTabbedTextExtent(tableDC,word,strlen(word),0,NULL));
                 newright = oldright + width;
                 if(maxright < newright) maxright = newright;
                 rect.left = oldright;
					  rect.top = iy-linehigh;
					  rect.right = newright;
					  rect.bottom = iy;
					  oldBrush = (HBRUSH)SelectObject(tableDC,
                          newBrush = CreateSolidBrush(PALETTEINDEX(bcolor)));
                 DeleteObject(oldBrush);
					  FillRect(tableDC,&rect,newBrush);
					  oldright = newright;
                 oldBrush = (HBRUSH)SelectObject(tableDC,
                         newBrush = CreateSolidBrush(PALETTEINDEX(icolor)));
                 DeleteObject(oldBrush); 

              }
              /*dump out earlier characters*/
              MoveToEx(tableDC, ix, iy, NULL);
			     if(ipass != 0)
                 TextOut(tableDC,ix,iy,word,strlen(word));
              ix = ix + LOWORD(GetTabbedTextExtent(tableDC,word,strlen(word),0,NULL));
              /*draw special character*/
              word[0] = commentstr[j+1]; 
              word[1] = '\0';
              if(Lbkg)
              {/*bkg rectangle from previous right side to new right edge*/
                 width = LOWORD(GetTabbedTextExtent(tableDC,word,strlen(word),0,NULL));
                 newright = oldright + width;
                 if(maxright < newright) maxright = newright;
                 rect.left = oldright;
			        rect.top = iy-linehigh;
			        rect.right = newright;
				     rect.bottom = iy;
				     oldBrush = (HBRUSH)SelectObject(tableDC,
                          newBrush = CreateSolidBrush(PALETTEINDEX(bcolor)));
                 DeleteObject(oldBrush);
				     FillRect(tableDC,&rect,newBrush);
				     oldright = newright;
                 oldBrush = (HBRUSH)SelectObject(tableDC,
                          newBrush = CreateSolidBrush(PALETTEINDEX(icolor)));
                 DeleteObject(oldBrush); 

              }
              MoveToEx(tableDC, ix, iy, NULL);
 			     if(ipass != 0)
                 TextOut(tableDC,ix,iy,word,strlen(word));
              ix = ix + LOWORD(GetTabbedTextExtent(tableDC,word,strlen(word),0,NULL));
              j=j+1; /*artificially increase j to that of the special char */
              k=j+2;/*k is one more so when j loop augmented j-k==0*/
           }/*backslash character*/
           else if(   commentstr[j]==EOL    /*defined in MAGE.h*/
                   || commentstr[j]=='\n'
                   || commentstr[j]=='\r'
                  )
           {/*EOL*/
			  if(k==kk)
			  {/*EOL as only character to be printed on this table line*/
				word[0] = ' ';
				word[1] = '\0';
			  }
			  else
			  {/*drop back so not print the EOL*/
				kk = j-1;
				for(m=0; m<=(kk-k); m++)
				{
					word[m] = commentstr[k+m];
				}
				word[m] = '\0';
              }
              if(Lbkg) 
              {/*bkg rectangle from previous right side to new right edge*/
                 width = LOWORD(GetTabbedTextExtent(tableDC,word,strlen(word),0,NULL));
                 newright = oldright + width;
                 if(maxright < newright) maxright = newright;
				     oldBrush = (HBRUSH)SelectObject(tableDC,
                          newBrush = CreateSolidBrush(PALETTEINDEX(bcolor)));
                 DeleteObject(oldBrush);
                 rect.left = oldright;
			        rect.top = iy-linehigh;
			        rect.right = newright;
				     rect.bottom = iy;
				     FillRect(tableDC,&rect,newBrush);

                 oldright = cellleft;
                 newright = cellleft;
				     oldBrush = (HBRUSH)SelectObject(tableDC,
                          newBrush = CreateSolidBrush(PALETTEINDEX(icolor)));
                 DeleteObject(oldBrush);

              }
              MoveToEx(tableDC, ix, iy, NULL);
              if(ipass != 0)
                 TextOut(tableDC,ix,iy,word,strlen(word));
              ix = cellleft;
              iy = iy + linehigh;
              /*j will be augmented at top of cycle*/
              k=j+1; /*so k==j at top of cycle*/
           }/*EOL*/
           else if(commentstr[j]=='{'/*}*/) /*balance curly bracket within paren*/
           {/*L curly bracket*/
              kk = j-1;
              for(m=0; m<=(kk-k); m++)
              {
                 word[m] = commentstr[k+m];
                 mm = m+1;
              }
              word[mm] = '\0';
              if(Lbkg) 
              {/*bkg rectangle from previous right side to new right edge*/
                 width = LOWORD(GetTabbedTextExtent(tableDC,word,strlen(word),0,NULL));
                 newright = oldright + width;
                 if(maxright < newright) maxright = newright;
				     oldBrush = (HBRUSH)SelectObject(tableDC,
                          newBrush = CreateSolidBrush(PALETTEINDEX(bcolor)));
                 DeleteObject(oldBrush);
                 rect.left = oldright;
			        rect.top = iy-linehigh;
			        rect.right = newright;
				     rect.bottom = iy;
				     FillRect(tableDC,&rect,newBrush);
                 iy = iy + linehigh/3; /*keep box in sync with pen*/
                 oldright = newright;
				     oldBrush = (HBRUSH)SelectObject(tableDC,
                          newBrush = CreateSolidBrush(PALETTEINDEX(icolor)));
                 DeleteObject(oldBrush);

              }
              /*dump out earlier characters*/
              MoveToEx(tableDC, ix, iy, NULL);
 			     if(ipass != 0)
                 TextOut(tableDC,ix,iy,word,strlen(word));
              ix = ix + LOWORD(GetTabbedTextExtent(tableDC,word,strlen(word),0,NULL));
              iy = iy + linehigh/3; 
              /*j will be augmented at top of cycle*/
              k=j+1; /*so k==j at top of cycle*/
           }/*L curly bracket*/
                                         
           else if(/*{*/ commentstr[j]=='}')/*balance curly bracket within paren*/
           {/*R curly bracket*/
              kk = j-1;
              for(m=0; m<=(kk-k); m++)
              {
                 word[m] = commentstr[k+m];
                 mm = m+1;
              }
              word[mm] = '\0';
              if(Lbkg) 
              {/*bkg rectangle from previous right side to new right edge*/
                 width = LOWORD(GetTabbedTextExtent(tableDC,word,strlen(word),0,NULL));
                 newright = oldright + width;
                 if(maxright < newright) maxright = newright;
				     oldBrush = (HBRUSH)SelectObject(tableDC,
                          newBrush = CreateSolidBrush(PALETTEINDEX(bcolor)));
                 DeleteObject(oldBrush);
                 rect.left = oldright;
			        rect.top = iy-linehigh;
			        rect.right = newright;
				     rect.bottom = iy;
				     FillRect(tableDC,&rect,newBrush);
                 iy = iy - linehigh/3; /*keep box in sync with pen*/
                 oldright = newright;
				     oldBrush = (HBRUSH)SelectObject(tableDC,
                          newBrush = CreateSolidBrush(PALETTEINDEX(icolor)));
                 DeleteObject(oldBrush);

              }
              /*dump out earlier characters*/
              MoveToEx(tableDC, ix, iy, NULL);
 			     if(ipass != 0)
                 TextOut(tableDC,ix,iy,word,strlen(word));
              ix = ix + LOWORD(GetTabbedTextExtent(tableDC,word,strlen(word),0,NULL));
              iy = iy - linehigh/3; 
              /*j will be augmented at top of cycle*/
              k=j+1; /*so k==j at top of cycle*/
           }/*R curly bracket*/
           else if(commentstr[j]=='<')
           {/*<*/
              kk = j-1;
              for(m=0; m<=(kk-k); m++)
              {
                 word[m] = commentstr[k+m];
                 mm = m+1;
              }
              word[mm] = '\0';
              if(Lbkg) 
              {/*bkg rectangle from previous right side to new right edge*/
                 width = LOWORD(GetTabbedTextExtent(tableDC,word,strlen(word),0,NULL));
                 newright = oldright + width;
                 if(maxright < newright) maxright = newright;
				     oldBrush = (HBRUSH)SelectObject(tableDC,
                          newBrush = CreateSolidBrush(PALETTEINDEX(bcolor)));
                 DeleteObject(oldBrush);
                 rect.left = oldright;
			        rect.top = iy-linehigh;
			        rect.right = newright;
				     rect.bottom = iy;
				     FillRect(tableDC,&rect,newBrush);
                 oldright = newright;
				     oldBrush = (HBRUSH)SelectObject(tableDC,
                          newBrush = CreateSolidBrush(PALETTEINDEX(icolor)));
                 DeleteObject(oldBrush);
                 Ltableextrapass = 1; /*< here means extra in a picked cell*/

              }
              /*dump out earlier characters*/
              MoveToEx(tableDC, ix, iy, NULL);
 			     if(ipass != 0)
                 TextOut(tableDC,ix,iy,word,strlen(word));
              ix = ix + LOWORD(GetTabbedTextExtent(tableDC,word,strlen(word),0,NULL));
              /*j will be augmented at top of cycle*/
              k=j+1; /*so k==j at top of cycle*/
              Lembedded = 1;
           }/*<*/
           else if(commentstr[j]=='>')
           {/*>*/
              kk = j-1;
              for(m=0; m<=(kk-k); m++)
              {
                 word[m] = commentstr[k+m];
                 mm = m+1;
              }
              word[mm] = '\0';
              if(Lbkg) 
              {/*bkg rectangle from previous right side to new right edge*/
                 width = LOWORD(GetTabbedTextExtent(tableDC,word,strlen(word),0,NULL));
                 newright = oldright + width;
                 if(maxright < newright) maxright = newright;
				     oldBrush = (HBRUSH)SelectObject(tableDC,
                          newBrush = CreateSolidBrush(PALETTEINDEX(bcolor)));
                 DeleteObject(oldBrush);
                 rect.left = oldright;
			        rect.top = iy-linehigh;
			        rect.right = newright;
				     rect.bottom = iy;
				     FillRect(tableDC,&rect,newBrush);
                 oldright = newright;
				     oldBrush = (HBRUSH)SelectObject(tableDC,
                          newBrush = CreateSolidBrush(PALETTEINDEX(icolor)));
                 DeleteObject(oldBrush);

              }
              /*dump out earlier characters*/
              MoveToEx(tableDC, ix, iy, NULL);
 			     if(ipass != 0)
                 TextOut(tableDC,ix,iy,word,strlen(word));
              ix = ix + LOWORD(GetTabbedTextExtent(tableDC,word,strlen(word),0,NULL));
              /*j will be augmented at top of cycle*/
              k=j+1; /*so k==j at top of cycle*/
              Lembedded = 0;
           }/*>*/
           else if(commentstr[j] == '\0')
           {/*end of string*/
              break;
           }
        }/*accept this character*/
      }/*loop over all char in string*/
      if(k<kk)
      {/*reached end of string, finish out anything still to be written*/
              kk = j-1;
              for(m=0; m<=(kk-k); m++)
              {
                 word[m] = commentstr[k+m];
                 mm = m+1;
              }
              word[mm] = '\0';
              if(Lbkg) 
              {/*bkg rectangle from previous right side to new right edge*/
                 width = LOWORD(GetTabbedTextExtent(tableDC,word,strlen(word),0,NULL));
                 newright = oldright + width;
                 if(maxright < newright) maxright = newright;
				     oldBrush = (HBRUSH)SelectObject(tableDC,
                          newBrush = CreateSolidBrush(PALETTEINDEX(bcolor)));
                 DeleteObject(oldBrush);
                 rect.left = oldright;
			        rect.top = iy-linehigh;
			        rect.right = newright;
				     rect.bottom = iy;
				     FillRect(tableDC,&rect,newBrush);
                 oldright = newright;
				     oldBrush = (HBRUSH)SelectObject(tableDC,
                          newBrush = CreateSolidBrush(PALETTEINDEX(icolor)));
                 DeleteObject(oldBrush);

              }
              /*dump out characters*/

              MoveToEx(tableDC, ix, iy, NULL);
              if(ipass != 0)
                 TextOut(tableDC,ix,iy,word,strlen(word));
      }/*reached end of string, finish out anything still to be written*/
      if(tablewordwidth < maxright-cellleft)
      {
         tablewordwidth = maxright-cellleft;
      }
   }/*string longer than zero length*/  
  }/*within 256 palette: a visible color*/
  return(iy); /*latest y coord used*/
}
/*___wordstotable()__________________________________________________________*/

/****rectangletoscreen()******************************************************/
void rectangletoscreen(int left, int top, int right, int bottom, int icolor)
{
   RECT  rect;

   rect.left = left;
   rect.top = top;
   rect.right = right;
   rect.bottom = bottom;

   oldBrush = (HBRUSH)SelectObject(tableDC,
          newBrush = CreateSolidBrush(PALETTEINDEX(icolor)));
   DeleteObject(oldBrush);
   /*setpencolor(icolor);*/ /*____DRAW.c*/

   FillRect(tableDC,&rect,newBrush);
}
/*___rectangletoscreen()_____________________________________________________*/

/****redrawtable()*****************common name********************************/
void    redrawtable()
{
      dodrawtable(1);

      if(Ltablepicked>0 || Ltablegraphpicked>0)
      {/*pick invoked call needs second pass to show full state of picks*/
         dodrawtable(1); /*put flag on picked cell(s) only*/
         /*finished operations on the table*/
         /*all graph initiated operations done*/
         Ltablegraphpicked = 0;
         /*but still may have table initiated operations to pass to graph*/
         /*Ltablepicked is the flag for table to graph picking*/
      }
}
/*___redrawtable()__________________________________________________________*/

/****dodrawtable()*****************common name: MAC & PC*********************/
void    dodrawtable(int ipass)
{
   RECT   rect;

	int left=0, top=0, right=0, bottom=0;
   gettablewinedges(&left, &top, &right, &bottom);

   /*erase*/
   GetClientRect(tableWindow,&rect);
   FillRect(tableDC,&rect,(HBRUSH)GetStockObject(WHITE_BRUSH));

   Ltableextrapass = 0;
   drawtable(ipass);  /*MAGETABL.c*/
   if(ipass==1 && Lsuperpick && Ltableextrapass)
   {
      drawtable(2);
      Ltableextrapass = 0;
   }
}
/*___dodrawtable()__________________________________________________________*/

