#include "MAGE.h"
#include "MAGELIST.h"
#include "MAGEBBOX.h"

/****totalbufferlines()******************************************************/
/* count lines in the buffer for the current window size */
long totalbufferlines(HWND hWnd, HDC hDC, LPSTR s)
{
    LPSTR s0;
    LPSTR e;
    int nlines = 0;
    int nb;
    int i;
    RECT r;
    int windowwidth;

    e = s + GetWindowLong(hWnd,TEXTLENGTH);
    GetClientRect(hWnd,&r);
    windowwidth = (r.right - r.left);
    if (s)
	{
		while (*s && s < e)
		{
			nb = nlinebreaks(s,&s0);
			if (nb == 1) s = s0;
			if (s >= e || *s == '\0') break;
			i = sizeoftextline(hDC, windowwidth, s);
			/* putnchars(s,i); */
			s += i;
			while (*s == ' ') ++s;
			++nlines;
		}
	}
    return(nlines);
}
/*___totalbufferlines()_____________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/

/****linefromoffset()********************************************************/
/* For a given offset in the text buffer, what line is it on? */
/* This is used so that the top of the window is roughly the */
/* same after a resize. */
long linefromoffset(HWND hWnd, unsigned long *lsbuf, long offset)
{
    long nlines = GetWindowLong(hWnd,TEXTLINESTOTAL);
    long i;
    unsigned long end;
    for (i = 0; i < nlines; ++i) 
    {
        end = lsbuf[i+1];
        if (end > (unsigned)offset) return(i);
    }
    return(0);
}
/*___linefromoffset()_______________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/

/****makelinestarts()********************************************************/
/* Build the linestart array, freeing and allocating memory as necessary. */
/* Unlock the result and store the handle in text window extra bytes. */
long makelinestarts(HWND hWnd)
{
    LPSTR s00,s0,e;
    int nlines = 0;
    int nb,i,windowwidth;
    RECT r;

    HDC hDC = GetDC(hWnd);

    LPSTR s = (LPSTR)GetWindowLong(hWnd,TEXTHANDLE);
    long* lsbuf = (long*)GetWindowLong(hWnd,TEXTLINESTARTHANDLE);
    long topline = GetWindowLong(hWnd,TEXTLINECURRENT);
    unsigned long currentoffset = 0;
    long nlinestotal;

    nlinestotal = totalbufferlines(hWnd,hDC,s)+1;
    GetClientRect(hWnd,&r);
    windowwidth = (r.right - r.left);
    if (lsbuf != 0) 
    {/* there is an existing buffer; kill it */
        currentoffset = lsbuf[topline];
		free(lsbuf);
        SetWindowLong(hWnd,TEXTLINESTARTHANDLE,0);
    }
    SetWindowLong(hWnd,TEXTLINESTOTAL,nlinestotal);
	/* allocate the new array */
	lsbuf = (long *) calloc(nlinestotal+1,sizeof(nlinestotal));
	SetWindowLong(hWnd,TEXTLINESTARTHANDLE,(long)lsbuf);

    /* fill the new array */
    s00 = s;
    e = s + GetWindowLong(hWnd,TEXTLENGTH);
    if (s)
	{
		while (*s && s < e) 
		{
			nb = nlinebreaks(s,&s0);
			if (nb == 1) s = s0;
			if (s >= e || *s == '\0') break;
			i = sizeoftextline(hDC, windowwidth, s);
			if (nlines > nlinestotal) 
			{
				fprintf(stderr,"Nlines exceeded 2\n");
				exit(10);
			}
			lsbuf[nlines] = s-s00;
			s += i;
			while (*s == ' ') ++s;
			++nlines;
		}
	}
    if (nlines > nlinestotal) 
    {
        fprintf(stderr,"Nlines exceeded 3\n");
        exit(10);
    }
    lsbuf[nlines] = s-s00;
    /* make sure we have the same top line as before */
    topline = linefromoffset(hWnd,(unsigned long *)lsbuf,currentoffset);
    SetWindowLong(hWnd,TEXTLINECURRENT,topline);
    ReleaseDC(hWnd,hDC);
    return(nlines);
}
/*___makelinestarts()_______________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/

/****linesonascreen()********************************************************/
static int linesonascreen(HWND hWnd)
{
    RECT r;
    int n;

    GetClientRect(hWnd,&r);
    if (fontverticalspace <= 0) return(0);
    n = (r.bottom - r.top) / fontverticalspace;
    return(n);
}
/*___linesonascreen()_______________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/

/****resetscrollbarvalues()**************************************************/
void resetscrollbarvalues(HWND hWnd)
{
	SCROLLINFO si;

	si.cbSize = sizeof(SCROLLINFO);
	si.fMask = SIF_ALL;
	si.nPage = linesonascreen(hWnd);
	si.nMin = 0;
	si.nMax = GetWindowLong(hWnd,TEXTLINESTOTAL)-1;
	if ((unsigned long)si.nMax <= si.nPage-1)
	{
		si.nPos = 0;
		SetWindowLong(hWnd,TEXTLINECURRENT,si.nPos);
	}
	else if ((((unsigned long)si.nMax)-GetWindowLong(hWnd,TEXTLINECURRENT))
		< si.nPage)
	{
		si.nPos = si.nMax-si.nPage+1;
		SetWindowLong(hWnd,TEXTLINECURRENT,si.nPos);
	}
	else si.nPos = GetWindowLong(hWnd,TEXTLINECURRENT);
	SetScrollInfo(hWnd, SB_VERT, &si, TRUE);
}
/*___resetscrollbarvalues()_________________________________________________*/

/****NewTextWindow()*********************************************************/
/* Create a new "MageTextWindow" with a caption, system box, minimize and */
/* maximize controls, and a vertical scroll bar */
HWND NewTextWindow(HWND parent, int id, int left, int top,
                    int right, int bottom, int editable)
{
    HWND tWindow;
    RECT rect;

    /* Create a frame with caption */
    tWindow = CreateWindow(
        "MageTextClass", /* class name */
        NULL,   /* no text in title bar */
        WS_CHILD | WS_CAPTION | WS_THICKFRAME | WS_CLIPSIBLINGS | WS_VSCROLL,
          /*| WS_MINIMIZEBOX | WS_MAXIMIZEBOX | WS_SYSMENU,*/
          /* Window style. No menu stuff, no minimize-maximize stuff*/
        left,       /* horizontal position. */
        top,        /* vertical position */
        right,      /* width */
        bottom,     /* height */
        parent,     /* parent */
        (HMENU)id,  /* window identifier */
        hInst,      /* This instance owns this window. */
        NULL        /* Pointer not needed. */
        );

    /* If window could not be created, return "failure" */
    if (!tWindow) return (0);

    GetClientRect(tWindow,&rect);

    /* Make the window visible; update its client area; and return "success" */
    ShowWindow(tWindow, SW_SHOWNA); /* Show the window */
    /* UpdateWindow(tWindow);  */       /* Sends WM_PAINT message */
	/* UpdateWindow command appears unnecessary to post WM_PAINT message  */
	/* because we invalidate the entire rect later after text is inserted */

    return(tWindow);
}
/*___NewTextWindow()________________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/

/****SetTextCaption()********************************************************/
/* Set the caption of a "Window" */
void SetTextCaption(HWND hWnd, LPSTR text)
{
    SendMessage(hWnd,WM_SETTEXT,0,(DWORD)text);
}
/*___SetTextCaption()_______________________________________________________*/

/****SetMageCaption()********************************************************/
/* Set the caption of the "MageWindow" */
void SetMageCaption()
{
	int n,i,h;
	char TestStr[256];

	n = -1; /*keeps track of last \ directory boundary in full path name*/
    for(i=0;i<256;i++)
    {/*isolate local, simple name from Full Path Name*/
        if(NameStr[i] == '\\') n=i;
        if(NameStr[i] == '\0') break;
    }
    h = 0; /*index for working version of input name*/
    /*n is either==0, or set to first char of simple name in the Full Path name*/
    for(i=n+1;i<256;i++)   /*just work in actual local file name part*/
    {/*make copy of working part of input file name, flagged for last . */
      /*derive name only from a full kinemage, not an appended file*/
      TestStr[h] = NameStr[i]; /*this has exact name of current input file*/
      if(TestStr[h] == '\0') break;
      h++;
    }
	lstrcat(TestStr," - Mage");
	SetTextCaption(MageWindow,TestStr);
}
/*___SetMageCaption()_______________________________________________________*/

/****RePaint()***************************************************************/
/* repaint the text window */
int RePaint(HWND hWnd, HDC hDC)
{
  long topline = GetWindowLong(hWnd,TEXTLINECURRENT);
  long totallines = GetWindowLong(hWnd,TEXTLINESTOTAL);
  LPSTR textbuf = (LPSTR)GetWindowLong(hWnd,TEXTHANDLE);
  long* lsbuf = (long*)GetWindowLong(hWnd,TEXTLINESTARTHANDLE);
  int nchars;
  char *textstart;
  long start,end;
  int i;
  int linesperscreen;
  int screenline = 0;

  linesperscreen = linesonascreen(hWnd);

  for (i = topline; i < totallines && screenline < linesperscreen; ++i)
  {
    start = lsbuf[i];
    if (i == totallines) end = GetWindowLong(hWnd,TEXTLENGTH);
    else end = lsbuf[i+1];
	
    nchars = end-start;
    textstart = textbuf+start;
	if (nchars > 0 && (textstart[nchars-1] == EOL)) nchars--;
    if (nchars > 0) TabbedTextOut(hDC,0,screenline*fontverticalspace,
        (LPSTR)textstart,nchars,0,NULL,0);
    ++screenline;
  }
  return(0);
}
/*___RePaint()______________________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/

/****nlinebreaks()************************************************************/
/* count empty lines (if any); record character following last line break */
int nlinebreaks(LPSTR s, LPSTR *t)
{
	int breaks = 0;
    LPSTR s0 = s;
	
	if (*s == EOL)
    {
        breaks = 1;
        s0 = s + 1;
    }
    *t = s0;
    return(breaks);
}
/*___nlinebreaks()__________________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/

/****sizeoftextline()********************************************************/
/* size in characters of longest well-broken text line that */
/*  can fit within windowwidth */
int sizeoftextline(HDC hDC, int windowwidth, char *p)
{
    char *t = p;
    char *t0 = p;
    DWORD extent;

    for (;;) 
    {
        while (!isspace(*t) && *t != '\0') ++t;
        extent = GetTabbedTextExtent(hDC,p,(t-p),0,NULL);
        if (LOWORD(extent) > windowwidth) 
        {
            if (t0 == p) 
            {/* panic: can't fit even one word on line */
              for ( ; t0 < t; ++t0)
                if(LOWORD(GetTabbedTextExtent(hDC,p,t0-p,0,NULL))>windowwidth)
                    return((t0-p)-1);
            }
            else return(t0-p);
        }
        else 
        {
            t0 = t;  /* set last good break point to current point */
            if (*t == '\0' || *t == EOL) return(t-p);
            ++t;
        }
    }
}
/*___sizeoftextline()_______________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/

/****MAGETextWndProc()*******************************************************/
LRESULT CALLBACK MAGETextWndProc(HWND hWnd, UINT message,
                            WPARAM wParam, LPARAM lParam)
{                                                      /*wx931123*/
  HDC hDC, hDCnow;
  PAINTSTRUCT ps;
  RECT  rect;
  long  currentline = GetWindowLong(hWnd,TEXTLINECURRENT);
  long  totallines = GetWindowLong(hWnd,TEXTLINESTOTAL);
  LPSTR textbuf = (LPSTR)GetWindowLong(hWnd,TEXTHANDLE);
  long* lsbuf = (long*)GetWindowLong(hWnd,TEXTLINESTARTHANDLE);
  long  icharbegin,icharhit,icharend;
  int   iadjust, ioffset, isee, iline;
  int   ix, iy, i, j, jth, k;
  long  linecount,inext,iend;
  POINT theplace;

  switch (message)
  {
    case WM_PAINT:
		hDC = BeginPaint(hWnd,&ps);
		RePaint(hWnd, hDC);
		EndPaint(hWnd,&ps);
      break;
	case WM_MOUSEMOVE:
		SetFocus(hWnd);
	  break;
    case WM_LBUTTONDOWN:

        /*if(GetActiveWindow() != hWnd)*/ BringWindowToTop(hWnd);
        /*break;*/
         /*else*/
         {
          GetClientRect(hWnd,&rect);
          iend = GetWindowLong(hWnd,TEXTLENGTH);
          GetCursorPos(&theplace);
          linecount = linesonascreen(hWnd);
          ScreenToClient(hWnd,&theplace);
          iy = theplace.y;
          ix = theplace.x;

          iy = iy/fontverticalspace;  /*screen's lines down to mouse pt*/

          i = currentline + (long)iy;  /*mouse at ith line of total text*/
          /*if(iy>linecount) break;*/
          if(i >totallines) break;
          ioffset = lsbuf[i]; /*textchar index of 1st char this line*/
          /*if(i<=linecount) inext = startpos(lsbuf[i+1])-2;*/ /**/
          if(i < totallines) inext = lsbuf[i+1]-2;
          else   inext =   iend;  /* or end char's number */
          iline = LOWORD(GetTabbedTextExtent((hDCnow=GetDC(hWnd))
                         ,&textbuf[ioffset],inext-ioffset,0,NULL));
						/*max length of this line */
		  ReleaseDC(hWnd,hDCnow);
          if(iline < ix) break;   /*quit if off the end of the line */

          for(j=0;j<255;j++)
          {
             /*isee=LOWORD(GetTabbedTextExtent((hDCnow=GetDC(hWnd))
                         ,&textbuf[ioffset+j],j+1,0,NULL)); */
             isee=LOWORD(GetTabbedTextExtent((hDCnow=GetDC(hWnd))
                         ,&textbuf[ioffset],j,0,NULL));
             ReleaseDC(hWnd,hDCnow);
           if(isee >= ix) break;  /*step aong line until chars' length */
              /* matches or exceeds the x mouse position */
          }
          
         /* textbuf[ioffset+j] = '_';*/
          iy = iy*fontverticalspace; /*iy now mod(fontverticalspace) */


          DestroyCaret();
          CreateCaret(hWnd,NULL,2,fontverticalspace);
          SetCaretPos(isee,iy);
          ShowCaret(hWnd);
          InvalidateRect(hWnd,NULL,FALSE);

            icharhit = ioffset+j;
            icharbegin = -1;
            icharend = -1;
            jth = 0;

            for(j=0;j<255;j++)
            {
              if(icharhit-j > 0)
              {
                if(   textbuf[icharhit-j]   == '*'
                   && textbuf[icharhit-j-1] == '}' )
                {/*hit an end before hit a beginning*/
                    icharbegin = -1; /*restore pristine state*/
                    break;
                }
                if(   textbuf[icharhit-j]  == '{'
                   && textbuf[icharhit-j-1] == '*' )
                {
                    icharbegin = icharhit-j+1;
                    jth = j;
                    break;
                }
              }
              else
              {
                  icharbegin = -1; /*restore pristine state*/
                  break;
              }
            }
            if(icharbegin >= 0)
            {
                for(j=-1;j<(255-jth);j++)
               {
                 if(icharhit+j < iend)
                 {
                    if(   textbuf[icharhit+j]    == '}'
                       && textbuf[icharhit+j+1]  == '*' )
                    {
                        icharend = icharhit+j-1;
                        break;
                    }
                 }
                }
                if(icharend >= 0)
                {
                    k = 0;
                    for(j=icharbegin; j<=icharend; j++)
                        Qstring[k++] = textbuf[j] ;
                    Qstring[k] = '\0';
                    iQstring = k; /*global for Qstring[] char count*/

                    itextoffset = icharend+1; /*position just after question*/
                   /*
                    for(j=0; j<=k; j++) alertstr[j] = Qstring[j];
                    dosinglealert();
                   */
                    Dotexthyperbutton(1); /*MAGEFILE.C*/
                        /* 1 for now, 0 when first setup */
                    //InvalidateRect(hWnd,NULL,FALSE);
                }
            }/**/

          }
        break;

    case WM_SIZE:
		/* calculate new line start array */
        makelinestarts(hWnd);
        resetscrollbarvalues(hWnd);
        InvalidateRect(hWnd,NULL,FALSE);
      break;
    case WM_VSCROLL:
		linecount = linesonascreen(hWnd);
		/* messages from the scroll bar */
		currentline = GetWindowLong(hWnd,TEXTLINECURRENT);
		iadjust = 1;
		switch (LOWORD(wParam))
		{
			case SB_LINEDOWN:
				if (currentline == (GetWindowLong(hWnd,TEXTLINESTOTAL) - linecount))
					iadjust = 0; /* already at bottom, don't redraw */
				else ++currentline;
				break;
			case SB_LINEUP:
				if (currentline == 0) iadjust = 0;
				    /* already at top, don't redraw */
				else --currentline;
				break;
			case SB_PAGEDOWN:
				if (currentline == (GetWindowLong(hWnd,TEXTLINESTOTAL) - linecount))
					iadjust = 0; /* already at bottom, don't redraw */
				else currentline += linecount-1;
				break;
			case SB_PAGEUP:
				if (currentline == 0) iadjust = 0;
				    /* already at top, don't redraw */
				else currentline -= linecount+1;
				break;
			case SB_THUMBTRACK:
				if (currentline != HIWORD(wParam)) currentline = HIWORD(wParam);
				else iadjust = 0;
				break;
			default:
				iadjust = 0;
				break;
		}
		if(iadjust)
		{
          if (currentline < 0) currentline = 0;
          if (currentline > (GetWindowLong(hWnd,TEXTLINESTOTAL)-linecount))
            currentline = (GetWindowLong(hWnd,TEXTLINESTOTAL)-linecount);
          SetWindowLong(hWnd,TEXTLINECURRENT,currentline);
          resetscrollbarvalues(hWnd);
		  InvalidateRect(hWnd,NULL,TRUE);
		}
		break;
	case WM_MOUSEWHEEL:
		linecount = linesonascreen(hWnd);
		if (linecount <= GetWindowLong(hWnd,TEXTLINESTOTAL)-1)
		{/*don't do any of this if screen not full of text*/
			currentline = GetWindowLong(hWnd,TEXTLINECURRENT);
			iadjust = 1; /* by default redraw the screen */
			if(((short)HIWORD(wParam) > 0) && (currentline > 0)) currentline--;
			else if(((short)HIWORD(wParam) < 0) && 
				(currentline < (GetWindowLong(hWnd,TEXTLINESTOTAL)-linecount)))
				currentline++;
			else if (currentline < 0) currentline = 0;
			else if (currentline > (GetWindowLong(hWnd,TEXTLINESTOTAL)-linecount))
				currentline = (GetWindowLong(hWnd,TEXTLINESTOTAL)-linecount);
			else iadjust = 0; /* at top or bottom of text, don't redraw */
			if (iadjust)
			{
				SetWindowLong(hWnd,TEXTLINECURRENT,currentline);
				resetscrollbarvalues(hWnd);
				InvalidateRect(hWnd,NULL,TRUE);
			}
		}
	  break;
    case WM_KEYDOWN:
        linecount = linesonascreen(hWnd);
		if (linecount <= GetWindowLong(hWnd,TEXTLINESTOTAL)-1)
		{/*don't do any of this if screen not full of text*/
			currentline = GetWindowLong(hWnd,TEXTLINECURRENT);
			iadjust = 1;
			switch (wParam)
			{
				case VK_HOME:
					if (currentline == 0) iadjust = 0;
					    /* already at top, don't redraw */
					else currentline = 0;
					break;
				case VK_END:
					if (currentline == (GetWindowLong(hWnd,TEXTLINESTOTAL) - linecount))
						iadjust = 0; /* already at bottom, don't redraw */
					else currentline = GetWindowLong(hWnd,TEXTLINESTOTAL) - linecount;
					break;
				case VK_PRIOR:
					if (currentline == 0)iadjust = 0;
					    /* already at top, don't redraw */
				    else currentline -= linecount+1;
				    break;
				case VK_NEXT:
					if (currentline == (GetWindowLong(hWnd,TEXTLINESTOTAL) - linecount))
						iadjust = 0; /* already at bottom, don't redraw */
				    else currentline += linecount-1;
				    break;
				case VK_UP:
					if (currentline == 0)iadjust = 0;
					    /* already at top, don't redraw */
				    else --currentline;
				    break;
				case VK_DOWN:
					if (currentline == (GetWindowLong(hWnd,TEXTLINESTOTAL) - linecount))
						iadjust = 0; /* already at bottom, don't redraw */
				    else ++currentline;
				    break;

				default:
					SendMessage(MageWindow,message,wParam,lParam);
				 iadjust = 0;
				 break;
			}
			if (iadjust==1)
			{
				if (currentline < 0) currentline = 0;
				if (currentline > (GetWindowLong(hWnd,TEXTLINESTOTAL)-linecount))
					currentline = (GetWindowLong(hWnd,TEXTLINESTOTAL)-linecount);
				SetWindowLong(hWnd,TEXTLINECURRENT,currentline);
				resetscrollbarvalues(hWnd);
				InvalidateRect(hWnd,NULL,TRUE);
			}
		}
      break;
	case WM_CHAR:
	case WM_KEYUP:
		SendMessage(MageWindow,message,wParam,lParam);
	  break;
	case WM_DESTROY:
        if (GetWindowLong(hWnd,TEXTHANDLE))
			free((HANDLE)GetWindowLong(hWnd,TEXTHANDLE));
        if (GetWindowLong(hWnd,TEXTLINESTARTHANDLE))
			free((HANDLE)GetWindowLong(hWnd,TEXTLINESTARTHANDLE));
      break;
    default:
      break;
  }
  return(DefWindowProc(hWnd, message, wParam, lParam));
}
/*___MAGETextWndProc()______________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/

/****clearcapts()************************************************************/
void clearcapts()
{
	textbufclear(captionWindow);
}
/*___clearcapts()___________________________________________________________*/

/****cleartexts()************************************************************/
void cleartexts()
{
	textbufclear(tWindow);
	InvalidateRect(tWindow,NULL,TRUE);
	/* redraw necessary after opening a file to update the text window */
	/* without scrolling or resizing, etc.							   */
}
/*___cleartexts()___________________________________________________________*/

/****textbufclear()**********************************************************/
void textbufclear(HWND hWnd)
{
	HANDLE buf;

	/*setup window text buffer*/
    SetWindowLong(hWnd,TEXTLINECURRENT,0);

    /* give up previous buffer, if any */
    buf = (HANDLE)GetWindowLong(hWnd,TEXTHANDLE);
    if (buf != 0) free(buf);
    /* allocate new buffer */
    buf = calloc(32768,sizeof(char));
    SetWindowLong(hWnd,TEXTHANDLE,(long)buf);
    SetWindowLong(hWnd,TEXTLENGTH,0);
    if (buf == 0)
    {
		sprintf(alertstr,"Out of memory in textbufclear");
		DoMageDLOGreport(2);
    }
}
/*___textbufclear()_________________________________________________________*/

/****inserttexts()***********************************************************/
void inserttexts(char texts[256])  /*<-GetTextFromFile(),MAGETEXT*/
{
	textbufinsert(tWindow,texts);  /* call general insertion routine */
}
/*___inserttexts()___920614 dcr_____________________________________________*/

/****insertcapts()***920614 dcr**********************************************/
void insertcapts(char capts[256])
{
	textbufinsert(captionWindow,capts);  /* call general insertion routine */
}
/*___insertcapts()___920614 dcr_____________________________________________*/

/****textbufinsert()*********************************************************/
void textbufinsert(HWND hWnd, char texts[256])
{
	LPSTR textbuf;
	int j;
	long textend,maxtextchar;

	textbuf = (LPSTR)GetWindowLong(hWnd,TEXTHANDLE);
	maxtextchar = GetWindowLong(hWnd,TEXTLENGTH);

	if(!Limittext)
	{
		textend = maxtextchar;
		maxtextchar = maxtextchar + (long)strlen(texts);
		if (maxtextchar >= 32767L)
		{
			Limittext = 1;
			sprintf(alertstr,"Text about to exceed 32767 characters, \n"
				"no more text will be put into Text Window!\n");
			dosinglealert(2);
		}
		else
		{
			for (j=0; texts[j] != '\0'; j++)
			{
				textbuf[textend] = texts[j];
				textend++;
			}
			textbuf[textend] = '\0';
		}
		maxtextchar = textend;
		SetWindowLong(hWnd,TEXTLENGTH,maxtextchar); /*update actual length*/
	}
}
/*___textbufinsert()________________________________________________________*/

/****completetext()***920614 dcr*********************************************/
void completetext()    /*<-GetTextFromFile()*/
{
    makelinestarts((HWND)tWindow);
	resetscrollbarvalues(tWindow);
    InvalidateRect(tWindow,NULL,FALSE);
}
/*___completetext()___920614 dcr____________________________________________*/

/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/

/****docompletecapt()******************************************************/
void docompletecapt()
{
    makelinestarts((HWND)captionWindow);
	resetscrollbarvalues(captionWindow);
    InvalidateRect(captionWindow,NULL,FALSE);
}
/*___docompletecapt()_____________________________________________________*/
 
/****adjustwindowwidth()*****************************************************/
void adjustwindowwidth()
{                              /*adjust window width for extra slider bars*/
    int i;

		/* used to recalculate brect.left */
		getbuttonplace();

	    MoveWindow(gWindow, (15 * DisplaySizeX / 100), 0, (brect.left - 
			(16 * DisplaySizeX / 100)),(90 * DisplaySizeY / 100), FALSE);
		MoveWindow(tWindow, 0, 0, brect.left - DisplaySizeX/5,
			4*DisplaySizeY/5, FALSE);
		MoveWindow(captionWindow, 0, 4*DisplaySizeY/5, brect.left -
			(5*DisplaySizeX/100), DisplaySizeY/5, FALSE);

        /*destroy sliders so they can be recreated in shifted positions*/
        DestroyWindow(sWindow);
        DestroyWindow(slabWindow);
        DestroyWindow(ztranWindow);
        sWindow = 0;
        slabWindow = 0;
        ztranWindow = 0;
        NewSliderWindows(); /*need to recreate zoom,zslab,ztran sliders */

   for(i=1;i<=MAXBONDROT;i++)
   {
       if(bondrotWindow[i]!=0)
       {
               DestroyWindow(bondrotWindow[i]);
               bondrotWindow[i] = 0;
       }
   }
   /*creategrafbondrotBar(i) will be done in SetsinGrafWindow(),MAGEBBOX.C*/

   RedrawWindow(MageWindow,NULL,NULL,RDW_ERASE | RDW_INVALIDATE | RDW_ALLCHILDREN);
}
/*___adjustwindowwidth()____________________________________________________*/

/*dummies for Mac routines*/
  void    showallwindows(void){;}
  void    choosefrontwindow(void){;}

