                      /*MUX_COLR.c*/
#include "MAGE.h"  
#include "MAGECOLR.h"  
    
unsigned int mypartpalette[200][3] =
{
  /*  51*/ 24000,     0,     0,/* RED0 */
  /*  52*/  2000, 22000,     0,/* GREEN0 */
  /*  53*/  8000,  8000, 23000,/* BLUE0 */
  /*  54*/     0, 20000, 18000,/* CYAN0 */
  /*  55*/ 21000, 20000,     0,/* YELLOW0 */
  /*  56*/ 21000,     0, 19000,/* MAGENTA0 */
  /*  57*/ 19000, 19000, 19000,/* WHITE0 */
  /*  58*/ 30000,  9000, 11000,/* PINK0 */
  /*  59*/ 23000,  7000,     0,/* ORANGE0 */
  /*  60*/ 13000,  6000, 24000,/* PURPLE0 */
  /*  61*/  5000, 12000, 22000,/* SKY0 */
  /*  62*/ 18000, 12000,  9000,/* BROWN0 */
  /*  63*/  9000,  9000,  9000,/* GRAY0 */
  /*  64*/ 22000, 14000,     0,/* GOLD0 */
  /*  65*/ 21000, 21000,  9000,/* YELLOWTINT0 */
  /*  66*/     0, 21000,  8000,/* SEA0 */
  /*  67*/ 30000, 16000, 18000,/* PINKTINT0 */
  /*  68*/ 16000, 20000, 23000,/* BLUETINT0 */
  /*  69*/ 14000, 23000, 17000,/* GREENTINT0 */
  /*  70*/ 23000,     0, 10000,/* HOTPINK0 */
  /*  71*/ 62000, 44000, 44000,/*     RED0 w*/
  /*  72*/ 48000, 56000, 44000,/*   GREEN0 w*/
  /*  73*/ 44000, 44000, 62000,/*    BLUE0 w*/
  /*  74*/ 44000, 56000, 54000,/*    CYAN0 w*/
  /*  75*/ 62000, 60000, 32000,/*  YELLOW0 w*/
  /*  76*/ 59000, 30000, 54000,/* MAGENTA0 w*/
  /*  77*/ 40000, 40000, 40000,/*   black0 default w*/
  /*  78*/ 62000, 35000, 44000,/* PINK0 w*/
  /*  79*/ 62000, 42000, 20000,/* ORANGE0 w*/
  /*  80*/ 46000, 36000, 55000,/* PURPLE0 w*/
  /*  81*/ 30000, 44000, 55000,/* SKY0 w*/
  /*  82*/ 65000, 48000, 35000,/* BROWN0 w*/
  /*  83*/ 45000, 45000, 45000,/* GRAY0 w*/
  /*  84*/ 59000, 50000, 20000,/*GOLD0 w*/
  /*  85*/ 45000, 43000, 30000,/* YELLOWTINT0 w*/
  /*  86*/ 44000, 55000, 48000,/* SEA0 w*/  
  /*  87*/ 55000, 37000, 37000,/* PINKTINT0 Wh*/
  /*  88*/ 36000, 44000, 54000,/* BLUETINT0 Wh*/
  /*  89*/ 36000, 54000, 44000,/* GREENTINT0 Wh*/
  /*  90*/ 62000, 38000, 48000,/* HOTPINK0 Wh*/
  /*  91*/ 35000,     0,     0,/* RED1 */
  /*  92*/  3000, 33000,     0,/* GREEN1 */
  /*  93*/ 10000, 10000, 34000,/* BLUE1 */
  /*  94*/     0, 29000, 27000,/* CYAN1 */
  /*  95*/ 31000, 30000,     0,/* YELLOW1 */
  /*  96*/ 32000,     0, 29000,/* MAGENTA1 */
  /*  97*/ 26000, 26000, 26000,/* WHITE1 */
  /*  98*/ 40000, 14000, 16000,/* PINK1 */
  /*  99*/ 34000, 10000,     0,/* ORANGE1 */
  /* 100*/ 18000,  7000, 34000,/* PURPLE1 */
  /* 101*/  6000, 17000, 32000,/* SKY1 */
  /* 102*/ 23000, 15000, 11000,/* BROWN1 */
  /* 103*/ 12000, 12000, 12000,/* GRAY1 */    
  /* 104*/ 33000, 20000,     0,/* GOLD1 */
  /* 105*/ 32000, 32000, 12000,/* YELLOWTINT1 */
  /* 106*/     0, 32000, 13000,/* SEA1 */
  /* 107*/ 40000, 24000, 26000,/* PINKTINT1 */
  /* 108*/ 22000, 29000, 34000,/* BLUETINT1 */
  /* 109*/ 22000, 34000, 25000,/* GREENTINT1 */
  /* 110*/ 33000,     0, 14000,/* HOTPINK1 */
  /* 111*/ 60000, 33000, 33000,/*     RED1 w*/
  /* 112*/ 37000, 54000, 33000,/*   GREEN1 w*/
  /* 113*/ 33000, 33000, 60000,/*    BLUE1 w*/
  /* 114*/ 33000, 55000, 53000,/*    CYAN1 w*/
  /* 115*/ 60000, 58000, 24000,/*  YELLOW1 w*/
  /* 116*/ 58000, 24000, 54000,/* MAGENTA1 w*/
  /* 117*/ 30000, 30000, 30000,/*   black1 default w*/
  /* 118*/ 60000, 32000, 39000,/*    PINK1 w*/
  /* 119*/ 60000, 36000, 15000,/*  ORANGE1 w*/
  /* 120*/ 42000, 28000, 55000,/*  PURPLE1 w*/
  /* 121*/ 24000, 41000, 55000,/*     SKY1 w*/
  /* 122*/ 60000, 42000, 31000,/*   BROWN1 w*/
  /* 123*/ 40000, 40000, 40000,/*    GRAY1 w*/
  /* 124*/ 58000, 47000, 15000,/*    GOLD1 w*/
  /* 125*/ 43000, 41000, 25000,/* YELLOWTINT1 w*/
  /* 126*/ 33000, 54000, 43000,/*     SEA1 w*/
  /* 127*/ 48000, 29000, 29000,/* PINKTINT1 Wh*/
  /* 128*/ 27000, 33000, 46000,/* BLUETINT1 Wh*/
  /* 129*/ 27000, 46000, 33000,/* GREENTINT1 Wh*/
  /* 130*/ 60000, 28000, 43000,/* HOTPINK1 Wh*/
  /* 131*/ 48000,     0,     0,/* RED2 */
  /* 132*/  4000, 46000,     0,/* GREEN2 */
  /* 133*/ 12000, 12000, 47000,/* BLUE2 */
  /* 134*/     0, 41000, 38000,/* CYAN2 */
  /* 135*/ 44000, 42000,     0,/* YELLOW2 */
  /* 136*/ 44000,     0, 41000,/* MAGENTA2 */
  /* 137*/ 42000, 42000, 42000,/* WHITE2 */
  /* 138*/ 50000, 17000, 20000,/* PINK2 */
  /* 139*/ 46000, 14000,     0,/* ORANGE2 */
  /* 140*/ 24000,  9000, 45000,/* PURPLE2 */
  /* 141*/  9000, 23000, 43000,/* SKY2 */
  /* 142*/ 30000, 19000, 15000,/* BROWN2 */
  /* 143*/ 17000, 17000, 17000,/* GRAY2 */
  /* 144*/ 45000, 27000,     0,/* GOLD2 */
  /* 145*/ 43000, 43000, 20000,/* YELLOWTINT2 */
  /* 146*/     0, 44000, 17000,/* SEA2 */
  /* 147*/ 50000, 31000, 34000,/* PINKTINT2 */
  /* 148*/ 34000, 41000, 47000,/* BLUETINT2 */
  /* 149*/ 30000, 48000, 36000,/* GREENTINT2 */
  /* 150*/ 45000,     0, 18000,/* HOTPINK2 */
  /* 151*/ 58000, 22000, 22000,/*     RED2 w*/
  /* 152*/ 26000, 52000, 22000,/*   GREEN2 w*/
  /* 153*/ 22000, 22000, 58000,/*    BLUE2 w*/
  /* 154*/ 22000, 54000, 52000,/*    CYAN2 w*/
  /* 155*/ 58000, 56000, 16000,/*  YELLOW2 w*/
  /* 156*/ 57000, 18000, 53000,/* MAGENTA2 w*/
  /* 157*/ 20000, 20000, 20000,/*   black2 default w*/
  /* 158*/ 58000, 29000, 34000,/*    PINK2 w*/
  /* 159*/ 58000, 30000, 10000,/*  ORANGE2 w*/
  /* 160*/ 38000, 21000, 55000,/*  PURPLE2 w*/
  /* 161*/ 18000, 38000, 55000,/*     SKY2 w*/
  /* 162*/ 53000, 36000, 27000,/*   BROWN2 w*/
  /* 163*/ 35000, 35000, 35000,/*    GRAY2 w*/
  /* 164*/ 57000, 44000, 10000,/*    GOLD2 w*/
  /* 165*/ 40000, 38000, 20000,/* YELLOWTINT2 w*/
  /* 166*/ 22000, 53000, 38000,/*     SEA2 w*/
  /* 167*/ 43000, 20000, 20000,/* PINKTINT2 Wh*/
  /* 168*/ 18000, 22000, 38000,/* BLUETINT2 Wh*/
  /* 169*/ 18000, 38000, 22000,/* GREENTINT2 Wh*/
  /* 170*/ 58000, 19000, 37000,/* HOTPINK2 Wh*/
  /* 171*/ 59000,     0,     0,/* RED3 */
  /* 172*/  5000, 57000,     0,/* GREEN3 */
  /* 173*/ 14000, 14000, 58000,/* BLUE3 */
  /* 174*/     0, 52000, 49000,/* CYAN3 */
  /* 175*/ 56000, 54000,     0,/* YELLOW3 */
  /* 176*/ 56000,     0, 52000,/* MAGENTA3 */
  /* 177*/ 55000, 55000, 55000,/* WHITE3 */
  /* 178*/ 60000, 22000, 25000,/* PINK3 */
  /* 179*/ 58000, 19000,     0,/* ORANGE3 */
  /* 180*/ 30000, 11000, 57000,/* PURPLE3 */
  /* 181*/ 12000, 30000, 57000,/* SKY3 */
  /* 182*/ 36000, 24000, 18000,/* BROWN3 */
  /* 183*/ 24000, 24000, 24000,/* GRAY3 */
  /* 184*/ 57000, 34000,     0,/* GOLD3 */
  /* 185*/ 56000, 56000, 26000,/* YELLOWTINT3 */
  /* 186*/     0, 55000, 22000,/* SEA3 */
  /* 187*/ 60000, 39000, 43000,/* PINKTINT3 */
  /* 188*/ 40000, 49000, 58000,/* BLUETINT3 */
  /* 189*/ 36000, 59000, 42000,/* GREENTINT3 */
  /* 190*/ 57000,     0, 22000,/* HOTPINK3 */
  /* 191*/ 56000, 11000, 11000,/*     RED3 w*/
  /* 192*/ 15000, 50000, 11000,/*   GREEN3 w*/
  /* 193*/ 11000, 11000, 56000,/*    BLUE3 w*/
  /* 194*/ 11000, 53000, 51000,/*    CYAN3 w*/
  /* 195*/ 56000, 54000,  8000,/*  YELLOW3 w*/
  /* 196*/ 56000, 11000, 53000,/* MAGENTA3 w*/
  /* 197*/ 10000, 10000, 10000,/*   black3 default w*/
  /* 198*/ 56000, 26000, 30000,/*    PINK3 w*/
  /* 199*/ 56000, 24000,  5000,/*  ORANGE3 w*/
  /* 200*/ 34000, 14000, 55000,/*  PURPLE3 w*/
  /* 201*/ 12000, 34000, 55000,/*     SKY3 w*/
  /* 202*/ 45000, 30000, 23000,/*   BROWN3 w*/
  /* 203*/ 30000, 30000, 30000,/*    GRAY3 w*/
  /* 204*/ 56000, 41000,  5000,/*    GOLD3 w*/
  /* 205*/ 37000, 35000, 15000,/* YELLOWTINT3 w*/
  /* 206*/ 11000, 52000, 33000,/*     SEA3 w*/
  /* 207*/ 39000,  8000, 11000,/* PINKTINT3 Wh */
  /* 208*/  9000, 11000, 30000,/* BLUETINT3 Wh */
  /* 209*/ 10000, 31000, 11000,/* GREENTINT3 Wh*/
  /* 210*/ 56000, 10000, 32000,/* HOTPINK3 Wh*/
  /* 211*/ 65535,     0,     0,/* RED4 */ 
  /* 212*/  6000, 65535,     0,/* GREEN4 */
  /* 213*/ 16000, 16000, 65535,/* BLUE4 */
  /* 214*/     0, 62000, 58000,/* CYAN4 */
  /* 215*/ 65535, 63000,     0,/* YELLOW4 */
  /* 216*/ 65535,     0, 60000,/* MAGENTA4 */
  /* 217*/ 65535, 65535, 65535,/* WHITE4 */
  /* 218*/ 65535, 26000, 30000,/* PINK4 */
  /* 219*/ 65535, 24000,     0,/* ORANGE4 */
  /* 220*/ 36000, 14000, 65535,/* PURPLE4 */
  /* 221*/ 15000, 37000, 65535,/* SKY4 */
  /* 222*/ 45000, 30000, 23000,/* BROWN4 */
  /* 223*/ 32000, 32000, 32000,/* GRAY4 */
  /* 224*/ 65535, 40000,     0,/*GOLD4 */
  /* 225*/ 63000, 63000, 30000,/* YELLOWTINT4 */
  /* 226*/     0, 64000, 28000,/* SEA4 */
  /* 227*/ 65535, 44000, 48000,/* PINKTINT4 */
  /* 228*/ 45000, 55000, 65535,/* BLUETINT4 */
  /* 229*/ 39000, 65535, 46000,/* GREENTINT4 */
  /* 230*/ 65535,     0, 26000,/* HOTPINK4 */
  /* 231*/ 54000,     0,     0,/*     RED4 w*/
  /* 232*/  4000, 48000,     0,/*   GREEN4 w*/
  /* 233*/     0,     0, 54000,/*    BLUE4 w*/
  /* 234*/     0, 52000, 50000,/*    CYAN4 w*/
  /* 235*/ 54000, 52000,     0,/*  YELLOW4 w*/
  /* 236*/ 55000,     0, 53000,/* MAGENTA4 w*/
  /* 237*/     0,     0,     0,/*   black4 default w*/
  /* 238*/ 54000, 23000, 26000,/*    PINK4 w*/
  /* 239*/ 54000, 18000,     0,/*  ORANGE4 w*/
  /* 240*/ 30000,  5000, 55000,/*  PURPLE4 w*/
  /* 241*/  5000, 30000, 55000,/*     SKY4 w*/
  /* 242*/ 36000, 24000, 18000,/*   BROWN4 w*/
  /* 243*/ 25000, 25000, 25000,/*    GRAY4 w*/
  /* 244*/ 55000, 38000,     0,/*    GOLD4 w*/
  /* 245*/ 34000, 32000, 10000,/* YELLOWTINT4 Wh*/
  /* 246*/     0, 51000, 28000,/*     SEA4 w*/
  /* 247*/ 35000,  4000,  6000,/* PINKTINT4 Wh*/
  /* 248*/  2000,  4000, 25000,/* BLUETINT4 Wh*/
  /* 249*/  2000, 24000,  4000,/* GREENTINT4 Wh*/
  /* 250*/ 54000,     0, 26000 /* HOTPINK4 Wh*/
};
/* declaration outside of any routine thus extern */
/* dcr's best match to std X11 available colors*/
/*pretty good for blk bkg, poor for wht bkg set */
unsigned int myX11palette[256][3] =
{
/*  0{black}                                    */   0,   0,   0,
/*  1{red0}         93,  0,  0, {red4}           */ 139,   0,   0,
/*  2{green0}        7, 85,  0, {DarkGreen}      */   0, 100,   0,
/*  3{blue0}        31, 31, 89, {NavyBlue}       */   0,   0, 128,
/*  4{cyan0}         0, 78, 70, {cyan4}          */   0, 139, 139,
/*  5{yellow0}      82, 78,  0, {yellow4}        */ 139, 139,   0,
/*  6{magenta0}     82,  0, 74, {magenta4}       */ 139,   0, 139,
/*  7{white0}       74, 74, 74, {gray29}         */  74,  74,  74,
/*  8{pink0}       117, 35, 42, {coral4}         */ 139,  62,  47,
/*  9{orange0}      89, 27,  0, {OrangeRed4}     */ 139,  37,   0,
/* 10{purple0}      50, 23, 93, {purple4}        */  85,  26, 139,
/* 11{sky0}         19, 46, 85, {DodgerBlue4}    */  16,  78, 139,
/* 12{brown0}       70, 46, 35, {LightSalmon4}   */ 139,  87,  66,
/* 13{gray0}        35, 35, 35, {gray14}         */  36,  36,  36,
/* 14{black}                                     */   0,   0,   0,
/* 15{gold0}        85, 54,  0, {orange4}        */ 139,  90,   0,
/* 16{yellowtint0}  82, 82, 35, {LightGoldenrod4}*/ 139, 129,  76,
/* 17{sea0}          0, 82, 31, {SpringGreen4}   */   0, 139,  69,
/* 18{pinktint0}   117, 62, 70, {LightPink4}     */ 139,  95, 101,
/* 19{bluetint0}    62, 78, 89, {LightSkyBlue4}  */  96, 123, 139,
/* 20{greentint0}   54, 89, 66, {PaleGreen4}     */  84, 139,  84,
/* 21{hotpink0}     89,  0, 39, {DeepPink4}      */ 139,  10,  80,
/* 22{black}                                     */   0,   0,   0,
/* 23{black}                                     */   0,   0,   0,
/* 24{black}                                     */   0,   0,   0,
/* 25{black}                                     */   0,   0,   0,
/* 26{red0w}       242,171,171, {LightPink2}     */ 238, 162, 173,
/* 27{green0w}     187,218,171, {honeydew3}      */ 193, 205, 193,
/* 28{blue0w}      171,171,242, {LightSteelBlue} */ 176, 196, 222,
/* 29{cyan0w}      171,218,210, {azure3}         */ 193, 205, 205,
/* 30{yellow0w}    242,234,125, {PaleGoldenrod}  */ 238, 232, 170,
/* 31{magenta0w}   230,117,210, {plum}           */ 221, 160, 221,
/* 32{white0w}     156,156,156, {gray61}         */ 156, 156, 156,
/* 33{pink0w}      242,136,171, {PaleVioletRed1} */ 255, 130, 171,
/* 34{orange0w}    242,164, 78, {tan1}           */ 255, 165,  79,
/* 35{purple0w}    179,140,214, {thistle3}       */ 205, 181, 205,
/* 36{sky0w}       117,171,214, {LightSkyBlue3}  */ 141, 182, 205,
/* 37{brown0w}     253,187,136, {burlywood1}     */ 255, 211, 155,
/* 38{gray0w}      175,175,175, {gray69}         */ 176, 176, 176,
/* 39{black}                                     */   0,   0,   0,
/* 40{gold0w}      230,195, 78, {LightGoldenrod3}*/ 205, 190, 112,
/* 41{yellowtint0w}175,167,117, {wheat3}         */ 205, 186, 150,
/* 42{sea0w}       171,214,187, {honeydew3}      */ 193, 205, 193,
/* 43{pinktint0w}  214,144,144, {LightPink3}     */ 205, 140, 149,
/* 44{bluetint0w}  140,171,210, {LightSkyBlue2}  */ 164, 211, 238,
/* 45{greentint0w} 140,210,171, {DarkSeaGreen3}  */ 155, 205, 155,
/* 46{hotpink0w}   242,148,187, {pink2}          */ 238, 169, 184,
/* 47{black}                                     */   0,   0,   0,
/* 48{black}                                     */   0,   0,   0,
/* 49{black}                                     */   0,   0,   0,
/* 50{black}                                     */   0,   0,   0,
/* 51{red1}        136,  0,  0, {red4}           */ 139,   0,   0,
/* 52{green1}       11,128,  0, {green4}         */   0, 139,   0,
/* 53{blue1}        39, 39,132, {blue4}          */   0,   0, 139,
/* 54{cyan1}         0,113,105, {cyan4}          */   0, 139, 139,
/* 55{yellow1}     121,117,  0, {yellow4}        */ 139, 139,   0,
/* 56{magenta1}    125,  0,113, {magenta4}       */ 139,   0, 139,
/* 57{white1}      101,101,101, {gray40}         */ 102, 102, 102,
/* 58{pink1}       156, 54, 62, {coral4}         */ 139,  62,  47,
/* 59{orange1}     132, 39,  0, {OrangeRed4}     */ 139,  37,   0,
/* 60{purple1}      70, 27,132, {purple4}        */  85,  26, 139,
/* 61{sky1}         23, 66,125, {DodgerBlue4}    */  16,  78, 139,
/* 62{brown1}       89, 58, 42, {LightSalmon4}   */ 139,  87,  66,
/* 63{gray1}        46, 46, 46, {gray18}         */  46,  46,  46,
/* 64{black}                                     */   0,   0,   0,
/* 65{gold1}       128, 78,  0, {orange4}        */ 139,  90,   0,
/* 66{yellowtint1} 125,125, 46, {LightGoldenrod4}*/ 139, 129,  76,
/* 67{sea1}          0,125, 50, {SpringGreen4}   */   0, 139,  69,
/* 68{pinktint1}   156, 93,101, {LightPink4}     */ 139,  95, 101,
/* 69{bluetint1}    85,113,132, {LightSkyBlue4}  */  96, 123, 139,
/* 70{greentint1}   85,132, 97, {PaleGreen4}     */  84, 139,  84,
/* 71{hotpink1}    128,  0, 54, {DeepPink4}      */ 139,  10,  80,
/* 72{black}                                     */   0,   0,   0,
/* 73{black}                                     */   0,   0,   0,
/* 74{black}                                     */   0,   0,   0,
/* 75{black}                                     */   0,   0,   0,
/* 76{red1w}       234,128,128, {LightCoral}     */ 240, 128, 128,
/* 77{green1w}     144,210,128, {DarkSeaGreen3}  */ 155, 205, 155,
/* 78{blue1w}      128,128,234, {MediumSlateBlue}*/ 123, 104, 238,
/* 79{cyan1w}      128,214,207, {PaleTurquoise3} */ 150, 205, 205,
/* 80{yellow1w}    234,226, 93, {LightGoldenrod} */ 238, 221, 130,
/* 81{magenta1w}   226, 93,210, {orchid}         */ 218, 112, 214,
/* 82{white1w}     117,117,117, {gray46}         */ 117, 117, 117,
/* 83{pink1w}      234,125,152, {PaleVioletRed2} */ 238, 121, 159,
/* 84{orange1w}    234,140, 58, {tan2}           */ 238, 154,  73,
/* 85{purple1w}    164,109,214, {MediumPurple2}  */ 159, 121, 238,
/* 86{sky1w}        93,160,214, {SkyBlue3}       */ 108, 166, 205,
/* 87{brown1w}     234,164,121, {burlywood2}     */ 238, 197, 145,
/* 88{gray1w}      156,156,156, {gray61}         */ 156, 156, 156,
/* 89{black}                                     */   0,   0,   0,
/* 90{gold1w}      226,183, 58, {goldenrod2}     */ 238, 180,  34,
/* 91{yellowtint1w}167,160, 97, {DarkKhaki}      */ 189, 183, 107,
/* 92{sea1w}       128,210,167, {honeydew3}      */ 193, 205, 193,
/* 93{pinktint1w}  187,113,113, {PaleVioletRed3} */ 205, 104, 137,
/* 94{bluetint1w}  105,128,179, {LightSkyBlue3}  */ 141, 182, 205,
/* 95{greentint1w} 105,179,128, {MediumAquamarin}*/ 102, 205, 170,
/* 96{hotpink1w}   234,109,167, {HotPink2}       */ 238, 106, 167,
/* 97{black}                                     */   0,   0,   0,
/* 98{black}                                     */   0,   0,   0,
/* 99{black}                                     */   0,   0,   0,
/*100{black}                                     */   0,   0,   0,
/*101{red2}        187,  0,  0, {red3}           */ 205,   0,   0,
/*102{green2}       15,179,  0, {green3}         */   0, 205,   0,
/*103{blue2}        46, 46,183, {blue3}          */   0,   0, 205,
/*104{cyan2}         0,160,148, {cyan3}          */   0, 205, 205,
/*105{yellow2}     171,164,  0, {yellow3}        */ 205, 205,   0,
/*106{magenta2}    171,  0,160, {magenta3}       */ 205,   0, 205,
/*107{white2}      164,164,164, {gray63}         */ 161, 161, 161,
/*108{pink2}       195, 66, 78, {coral3}         */ 205,  91,  69,
/*109{orange2}     179, 54,  0, {OrangeRed3}     */ 205,  55,   0,
/*110{purple2}      93, 35,175, {purple3}        */ 125,  38, 205,
/*111{sky2}         35, 89,167, {DodgerBlue3}    */  24, 116, 205,
/*112{brown2}      117, 74, 58, {LightSalmon3}   */ 205, 129,  98,
/*113{gray2}        66, 66, 66, {gray25}         */  64,  64,  64,
/*114{black}                                     */   0,   0,   0,
/*115{gold2}       175,105,  0, {orange3}        */ 205, 133,   0,
/*116{yellowtint2} 167,167, 78, {LightGoldenrod3}*/ 205, 190, 112,
/*117{sea2}          0,171, 66, {SpringGreen3}   */   0, 205, 102,
/*118{pinktint2}   195,121,132, {LightPink3}     */ 205, 140, 149,
/*119{bluetint2}   132,160,183, {LightSkyBlue3}  */ 141, 182, 205,
/*120{greentint2}  117,187,140, {PaleGreen3}     */ 124, 205, 124,
/*121{hotpink2}    175,  0, 70, {DeepPink3}      */ 205,  16, 118,
/*122{black}                                     */   0,   0,   0,
/*123{black}                                     */   0,   0,   0,
/*124{black}                                     */   0,   0,   0,
/*125{black}                                     */   0,   0,   0,
/*126{red2w}       226, 85, 85, {tomato2}        */ 238,  92,  66,
/*127{green2w}     101,203, 85, {PaleGreen3}     */ 124, 205, 124,
/*128{blue2w}       85, 85,226, {SlateBlue}      */ 106,  90, 205,
/*129{cyan2w}       85,210,203, {MediumTurquoise}*/  72, 209, 204,
/*130{yellow2w}    226,218, 62, {goldenrod1}     */ 255, 193,  37,
/*131{magenta2w}   222, 70,207, {MediumOrchid2}  */ 209,  95, 238,
/*132{white2w}      78, 78, 78, {gray30}         */  77,  77,  77,
/*133{pink2w}      226,113,132, {PaleVioletRed}  */ 219, 112, 147,
/*134{orange2w}    226,117, 39, {chocolate2}     */ 238, 118,  33,
/*135{purple2w}    148, 82,214, {MediumPurple}   */ 147, 112, 219,
/*136{sky2w}        70,148,214, {SteelBlue3}     */  79, 148, 205,
/*137{brown2w}     207,140,105, {burlywood}      */ 222, 184, 135,
/*138{gray2w}      136,136,136, {gray53}         */ 135, 135, 135,
/*139{black}                                     */   0,   0,   0,
/*140{gold2w}      222,171, 39, {goldenrod}      */ 218, 165,  32,
/*141{yellowtint2w}156,148, 78, {khaki4}         */ 139, 134,  78,
/*142{sea2w}        85,207,148, {MediumAquamarin}*/ 102, 205, 170,
/*143{pinktint2w}  167, 78, 78, {PaleVioletRed4} */ 139,  71,  93,
/*144{bluetint2w}   70, 85,148, {SkyBlue4}       */  74, 112, 139,
/*145{greentint2w}  70,148, 85, {PaleGreen4}     */  84, 139,  84,
/*146{hotpink2w}   226, 74,144, {VioletRed2}     */ 238,  58, 140,
/*147{black}                                     */   0,   0,   0,
/*148{black}                                     */   0,   0,   0,
/*149{black}                                     */   0,   0,   0,
/*150{black}                                     */   0,   0,   0,
/*151{red3}        230,  0,  0, {red2}           */ 238,   0,   0,
/*152{green3}       19,222,  0, {green2}         */   0, 238,   0,
/*153{blue3}        54, 54,226, {blue2}          */   0,   0, 238,
/*154{cyan3}         0,203,191, {cyan2}          */   0, 238, 238,
/*155{yellow3}     218,210,  0, {yellow2}        */ 238, 238,   0,
/*156{magenta3}    218,  0,203, {magenta2}       */ 238,   0, 238,
/*157{white3}      214,214,214, {gray83}         */ 212, 212, 212,
/*158{pink3}       234, 85, 97, {coral2}         */ 238, 106,  80,
/*159{orange3}     226, 74,  0, {OrangeRed2}     */ 238,  64,   0,
/*160{purple3}     117, 42,222, {purple2}        */ 145,  44, 238,
/*161{sky3}         46,117,222, {DodgerBlue2}    */  28, 134, 238,
/*162{brown3}      140, 93, 70, {LightSalmon2}   */ 238, 149, 114,
/*163{gray3}        93, 93, 93, {gray36}         */  92,  92,  92,
/*164{black}                                     */   0,   0,   0,
/*165{gold3}       222,132,  0, {orange2}        */ 238, 154,   0,
/*166{yellowtint3} 218,218,101, {LightGoldenrod2}*/ 238, 220, 130,
/*167{sea3}          0,214, 85, {SpringGreen2}   */   0, 238, 118,
/*168{pinktint3}   234,152,167, {LightPink2}     */ 238, 162, 173,
/*169{bluetint3}   156,191,226, {LightSkyBlue2}  */ 164, 211, 238,
/*170{greentint3}  140,230,164, {PaleGreen2}     */ 144, 238, 144,
/*171{hotpink3}    222,  0, 85, {DeepPink2}      */ 238,  18, 137,
/*172{black}                                     */   0,   0,   0,
/*173{black}                                     */   0,   0,   0,
/*174{black}                                     */   0,   0,   0,
/*175{black}                                     */   0,   0,   0,
/*176{red3w}       218, 42, 42, {firebrick3}     */ 205,  38,  38,
/*177{green3w}      58,195, 42, {LimeGreen}      */  50, 205,  50,
/*178{blue3w}       42, 42,218, {RoyalBlue3}     */  58,  95, 205,
/*179{cyan3w}       42,207,199, {turquoise}      */  64, 224, 208,
/*180{yellow3w}    218,210, 31, {gold2}          */ 238, 201,   0,
/*181{magenta3w}   218, 42,207, {magenta3}       */ 205,   0, 205,
/*182{white3w}      39, 39, 39, {gray15}         */  38,  38,  38,
/*183{pink3w}      218,101,117, {PaleVioletRed3} */ 205, 104, 137,
/*184{orange3w}    218, 93, 19, {DarkOrange3}    */ 205, 102,   0,
/*185{purple3w}    132, 54,214, {DarkOrchid3}    */ 154,  50, 205,
/*186{sky3w}        46,132,214, {DodgerBlue3}    */  24, 116, 205,
/*187{brown3w}     175,117, 89, {burlywood3}     */ 205, 170, 125,
/*188{gray3w}      117,117,117, {gray46}         */ 117, 117, 117,
/*189{black}                                     */   0,   0,   0,
/*190{gold3w}      218,160, 19, {goldenrod3}     */ 205, 155,  29,
/*191{yellowtint3w}144,136, 58, {LightGoldenrod4}*/ 139, 129,  76,
/*192{sea3w}        42,203,128, {SeaGreen3}      */  67, 205, 128,
/*193{pinktint3w}  152, 31, 42, {brown}          */ 165,  42,  42,
/*194{bluetint3w}   35, 42,117, {DarkSlateBlue}  */  72,  61, 139,
/*195{greentint3w}  39,121, 42, {ForestGreen}    */  34, 139,  34,
/*196{hotpink3w}   218, 39,125, {VioletRed3}     */ 205,  50, 120,
/*197{black}                                     */   0,   0,   0,
/*198{black}                                     */   0,   0,   0,
/*199{black}                                     */   0,   0,   0,
/*200{black}                                     */   0,   0,   0,
/*201{red4}        255,  0,  0, {red}            */ 255,   0,   0,
/*202{green4}       23,255,  0, {green1}         */   0, 255,   0,
/*203{blue4}        62, 62,255, {blue1}          */   0,   0, 255,
/*204{cyan4}         0,242,226, {cyan1}          */   0, 255, 255,
/*205{yellow4}     255,246,  0, {yellow1}        */ 255, 255,   0,
/*206{magenta4}    255,  0,234, {magenta}        */ 255,   0, 255,
/*207{white4}      255,255,255, {gray100}        */ 255, 255, 255,
/*208{pink4}       255,101,117, {coral1}         */ 255, 114,  86,
/*209{orange4}     255, 93,  0, {OrangeRed}      */ 255,  69,   0,
/*210{purple4}     140, 54,255, {purple1}        */ 155,  48, 255,
/*211{sky4}         58,144,255, {DodgerBlue1}    */  30, 144, 255,
/*212{brown4}      175,117, 89, {LightSalmon1}   */ 255, 160, 122,
/*213{gray4}       125,125,125, {gray49}         */ 125, 125, 125,
/*214{black}                                     */   0,   0,   0,
/*215{gold4}       255,156,  0, {orange1}        */ 255, 165,   0,
/*216{yellowtint4} 246,246,117, {LightGoldenrod1}*/ 255, 236, 139,
/*217{sea4}          0,250,109, {SpringGreen1}   */   0, 255, 127,
/*218{pinktint4}   255,171,187, {LightPink1}     */ 255, 174, 185,
/*219{bluetint4}   175,214,255, {LightSkyBlue1}  */ 176, 226, 255,
/*220{greentint4}  152,255,179, {PaleGreen1}     */ 154, 255, 154,
/*221{hotpink4}    255,  0,101, {DeepPink}       */ 255,  20, 147,
/*222{black}                                     */   0,   0,   0,
/*223{black}                                     */   0,   0,   0,
/*224{black}                                     */   0,   0,   0,
/*225{black}                                     */   0,   0,   0,
/*226{red4w}       210,  0,  0, {red3}           */ 205,   0,   0,
/*227{green4w}      15,187,  0, {green3}         */   0, 205,   0,
/*228{blue4w}        0,  0,210, {MediumBlue}     */   0,   0, 205,
/*229{cyan4w}        0,203,195, {cyan3}          */   0, 205, 205,
/*230{yellow4w}    210,203,  0, {yellow3}        */ 205, 205,   0,
/*231{magenta4w}   214,  0,207, {magenta3}       */ 205,   0, 205,
/*232{white4w}       0,  0,  0, {gray0}          */   0,   0,   0,
/*233{pink4w}      210, 89,101, {salmon3}        */ 205, 112,  84,
/*234{orange4w}    210, 70,  0, {OrangeRed3}     */ 205,  55,   0,
/*235{purple4w}    117, 19,214, {purple3}        */ 125,  38, 205,
/*236{sky4w}        19,117,214, {DodgerBlue3}    */  24, 116, 205,
/*237{brown4w}     140, 93, 70, {burlywood4}     */ 139, 115,  85,
/*238{gray4w}       97, 97, 97, {gray38}         */  97,  97,  97,
/*239{black}                                     */   0,   0,   0,
/*240{gold4w}      214,148,  0, {DarkGoldenrod3} */ 205, 149,  12,
/*241{yellowtint4w}132,125, 39, {goldenrod4}     */ 139, 105,  20,
/*242{sea4w}         0,199,109, {SpringGreen3}   */   0, 205, 102,
/*243{pinktint4w}  136, 15, 23, {firebrick4}     */ 139,  26,  26,
/*244{bluetint4w}    7, 15, 97, {MidnightBlue}   */  25,  25, 112,
/*245{greentint4w}   7, 93, 15, {DarkGreen}      */   0, 100,   0,
/*246{hotpink4w}   210,  0,101, {DeepPink3}      */ 205,  16, 118,
/*247{black}                                     */   0,   0,   0,
/*248{black}                                     */   0,   0,   0,
/*249{black}                                     */   0,   0,   0,
/*250{black}                                     */   0,   0,   0,
/*251{black}                                     */   0,   0,   0,
/*252{black}                                     */   0,   0,   0,
/*253{black}                                     */   0,   0,   0,
/*254{black}                                     */   0,   0,   0,
/*255{white}                                     */ 255, 255, 255 
};
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/

/* declaration outside of any routine thus extern */
unsigned int mygraypalette[16][3] =
{
  /*   0*/     0,     0,     0,/* black */
  /*   1*/ 19000, 19000, 19000,/* WHITE0 */
  /*   2*/ 26000, 26000, 26000,/* WHITE1 */
  /*   3*/ 42000, 42000, 42000,/* WHITE2 */
  /*   4*/ 55000, 55000, 55000,/* WHITE3 */
  /*   5*/ 65535, 65535, 65535,/* WHITE4 */
  /*   6*/ 40000, 40000, 40000,/*   black0 default w*/
  /*   7*/ 30000, 30000, 30000,/*   black1 default w*/
  /*   8*/ 20000, 20000, 20000,/*   black2 default w*/
  /*   9*/ 10000, 10000, 10000,/*   black3 default w*/
  /*  10*/     0,     0,     0,/*   black4 default w*/
  /*  11*/  5000, 12000, 22000,/* dummy */
  /*  12*/ 18000, 12000,  9000,/* dummy */
  /*  13*/  9000,  9000,  9000,/* dummy */
  /*  14*/ 24000,  5000,     0,/* dummy */
  /*  15*/ 65535, 65535, 65535 /* dummy */
};
 
    

/****makexcolors()*************************************************************/
void makexcolors()
{
  XColor  xcolor;
  int     i,j,k,ifail,iwin,ipass,itry,icount;
  unsigned long plane_masks[32];
  int ncolors, nplanes, nrequested;
#ifdef PRINTDEFAULT
  unsigned short  r[512],g[512],b[512];
#endif /*PRINTDEFAULT*/
  int oldLtest;

  oldLtest = Ltest;
  /*Ltest = 1;*/


/*  nrequested = 256;*/
  nrequested = 248; /*used for block color assignment*/


#ifdef PRINTDEFAULT
for(j=0; j<256; j++)
{
  r[j] = 0;
  g[j] = 0;
  b[j] = 0;
  xcolor.pixel = (unsigned long)j;
  XQueryColor(dpy,DefaultColormap(dpy,DefaultScreen(dpy)),&xcolor);
  r[j]=xcolor.red;
  g[j]=xcolor.green;
  b[j]=xcolor.blue;
  /*r[j]=(unsigned int)((xcolor.red)&65535);*/
  /*g[j]=(unsigned int)((xcolor.green)&65535);*/
  /*b[j]=(unsigned int)((xcolor.blue)&65535);*/
  printf("%d: RGB  %u, %u, %u\n"
  ,j
  ,r[j]
  ,g[j]
  ,b[j]  );
}
#endif /*PRINTDEFAULT*/





  for(ipass = 1; ipass<=2; ipass++)
  {
    if(ipass == 1)
    {
        /*Lread_writecolors set by findmonitortype, passed in common*/
        colormap = XCreateColormap(dpy,RootWindow(dpy,DefaultScreen(dpy)),
                             magevisual,AllocNone);
        if(Ltest) printf("pass 1 create colormap== %d\n",colormap);
    }
    else /*ipass == 2*/
    {
        Lread_writecolors = 0; /*don't try to make own map*/
        colormap = DefaultColormap(dpy,DefaultScreen(dpy));
        magevisual = DefaultVisual(dpy,DefaultScreen(dpy));
        if(Ltest) printf("pass 2 use default colormap== %d\n",colormap);
    }
    iwin = 0;
    ifail = 0;
    nplanes = 0; /*pg 198-200, Vol 1 9004*/

    ncolors = nrequested;
    /* XAllocColorCells continuous single array*/

    if(Lread_writecolors)
    {/*read_write color possible*/
        while(1)
        {
            j = XAllocColorCells(
                dpy,
                colormap,
                False,
                plane_masks,
                nplanes,
                incolor,    /*MUXM.H EXTERN unsigned long  incolor[256];*/
                ncolors     /*index into incolor[] array*/
            );
            /*printf("makexcolors XAllocColorCells== %d,  ncolors== %d,"
                     " nplanes== %d\n" ,j,ncolors,nplanes);*/
            if(j) break; /*0 failure, try for fewer colors*/
            ncolors--;
            if(ncolors==0) break;
        }
        if(ncolors==nrequested)
        {
            /*printf("XAllocColorCells succeeded: ncolors == %d\n",ncolors);*/
            ifail = 0;
            iwin = 1;
        }
        else
        {
           if(Ltest)printf("XAllocColorCells failed to alloc read_write colors:"
               " ncolors == only %d of the %d requested\n",ncolors,nrequested);
           Lread_writecolors = 0;
           ifail = 1;
           iwin = 0;
        }
        if(Lread_writecolors)
        {/*store palette values*/
            iwin = 0;
            xcolor.flags = DoRed|DoGreen|DoBlue;
            for(i=0; i<ncolors; i++)
            {
                xcolor.pixel=incolor[i]; /*incolor defined above*/
                xcolor.red   = myfullpalette[i][0]; /*declared above*/
                xcolor.green = myfullpalette[i][1];
                xcolor.blue  = myfullpalette[i][2];
                XStoreColor(dpy,colormap,&xcolor); 
                iwin = iwin + 1;
                incolored[i] = 1;
            }

            BLACKINDEX =  0; /*special entry full black*/
            WHITEINDEX = 39; /*full white in indexed set*/
            /*255 may not be allocated when doing colors this way*/

            if(Ltest) printf("stored %d colors\n",iwin);
        }
    }/*read_write color possible*/
    else if(LLcolor) /*color still possible*/
    {/*try to allocate read only colors*/
      for(itry=1;itry<=2;itry++)
      {/*two tries: 1 with mage palette, 2 with X11 palette*/
        if(Ltest) printf("try %d to allocate read only colors\n",itry);
        icount = 0;
        ifail=0;
        iwin=0;
        xcolor.flags = DoRed|DoGreen|DoBlue;
        /*only need to allocate the exact cells actually used*/
        for(k=0;k<275;k=k+25)
        for(j=0;j<22;j++) /*except j 14, full black/white not used here*/
        {
          i = k + j;
          if(  (j>0 && k>=0 && k<250 && j!=14 )  /*general 20 colors */
             ||(k==0 && j==0)                    /* 0 */
             ||(k==250 && i==255)                /* 255 */
                                   ) 
          {
            icount++;
            /*xcolor.pixel=incolor[i];*/
            if(itry==1)
            {
                xcolor.red   = myfullpalette[i][0]; /*declared above*/
                xcolor.green = myfullpalette[i][1];
                xcolor.blue  = myfullpalette[i][2];
            }
            if(itry==2)
            {
                xcolor.red   = 256*myX11palette[i][0]; /*declared above*/
                xcolor.green = 256*myX11palette[i][1];
                xcolor.blue  = 256*myX11palette[i][2];
            }
            if(XAllocColor(dpy,colormap,&xcolor)) 
            {
                iwin=iwin+1;
                incolor[i] = xcolor.pixel;
                /*incolor for black can be == 0 !! */
                incolored[i] = 1;
               /*
                printf("did match color# incolor[%d]== %ld"
                        ", got RGB: %d, %d, %d,"
                        " orig: %d, %d, %d\n"
                 ,i,incolor[i],xcolor.red,xcolor.green,xcolor.blue
                 ,myfullpalette[i][0],myfullpalette[i][1],myfullpalette[i][2]);
                */
            }
            else 
            {
                ifail = ifail + 1;
                /*incolor for black can be == 0 !! */
                incolor[i] = 0; /*Pixel*/
                incolored[i] = 0; /*flag*/
               /*
                printf("failed to match color# incolor[%d]== %ld"
                ", RGB: %d, %d, %d\n"
                ,i,incolor[i]
                ,myfullpalette[i][0],myfullpalette[i][1],myfullpalette[i][2]);
               */
            }
          }
        }
        if(itry==1)
          printf("MAGE palette matched color %d times out of %d\n",iwin,icount);
        else /*itry==2*/
          printf("X11 palette matched color %d times out of %d\n",iwin,icount);
      
        BLACKINDEX =  0;
        WHITEINDEX = 255; /*most palettes keep this as full white*/
      
        if(ifail>0)
        {
            printf("failed to match color %d times\n",ifail);
            if(itry==1)
            {
                /*Free allocated color cells and try again*/
                /*XFreeColors(dpy,colormap,incolor,256,8);*/
            }
        }
        else break;
      }/*two tries: 1 with mage palette, 2 with X11 palette*/
    }/*try to allocate read only colors*/
    else if(Lcolor) /*only gray still possible*/
    {/*try to allocate read only colorcells*/
        ifail = 0;
        iwin = 0;
        icount = 0;
        if(Ltest) printf("try to allocate read only gray color cells\n");
        xcolor.flags = DoRed|DoGreen|DoBlue;
        for(i=0;i<16;i++)
        {
            icount++;
            /*xcolor.pixel=incolor[i];*/
            xcolor.red   = mygraypalette[i][0]; /*declared above*/
            xcolor.green = mygraypalette[i][1];
            xcolor.blue  = mygraypalette[i][2];
            if(XAllocColor(dpy,colormap,&xcolor)) 
            {
                /* printf("did match gray# %d, got RGB: %d, %d, %d,"
                        " orig: %d, %d, %d\n"
                     ,i,xcolor.red,xcolor.green,xcolor.blue
                 ,myfullpalette[i][0],myfullpalette[i][1],myfullpalette[i][2]);
                */
                iwin = iwin + 1;
                incolor[i] = xcolor.pixel;
                incolored[i] = 1;
            }
            else 
            {
                /*printf("failed to match gray# %d, RGB: %d, %d, %d\n"
                ,i,myfullpalette[i][0],myfullpalette[i][1],myfullpalette[i][2]);
                */
                ifail = ifail + 1;
                incolored[i] = 0;
            }
        }

        BLACKINDEX = 10;
        WHITEINDEX =  5;

        if(ifail>0) 
        {
            printf("failed to match gray %d times\n",ifail);

            BLACKINDEX =  0;
            WHITEINDEX =  1;

        }
        printf("matched gray %d times out of %d\n",iwin,icount);
    }
    if(iwin>0 && !ifail) break;
  }/*ipass*/
  Ltest = oldLtest;
}
/*___makexcolors()____________________________________________________________*/

/****findmonitortype()*********************************************************/
void  findmonitortype(void)    /*<-MUXMINIT.c*/
{
  XVisualInfo    visualtemplate;
  XVisualInfo    *visuallist;
  Visual*        defaultvisual;
  int            j, visualsmatched, ivisual, idefaultvisual;
  int            Ltestcolor, numcolormaps;
  int idummycolor = -1; /*dummy flag, so can keep all possible items in code*/
      /* and still avoid picky compiler messages about not using variables*/
  int idirectcolor = -1; /*flags for these color models at magescreen depth*/
  int itruecolor= -1;
  int ipseudocolor= -1;
  int istaticcolor= -1;
  int igrayscale= -1;
  int istaticgray= -1;
  int firstpseudocolor= -1; /*really want to work with a pseudocolor visual*/

  idummycolor=idummycolor;/*avoid compiler messages about not using variable*/

   Ltestcolor = 0;
 /*Ltestcolor = 1;*/
/*discover Visual attributes of this computer */
  defaultvisual = DefaultVisual(dpy,DefaultScreen(dpy));
  visualtemplate.screen = DefaultScreen(dpy);
  visualtemplate.depth = DefaultDepth(dpy,DefaultScreen(dpy));

  magedepth = visualtemplate.depth;
  /*windowbackground = WhitePixel(dpy,DefaultScreen(dpy));*/
  /*windowborder = BlackPixel(dpy,DefaultScreen(dpy));*/
  /*do this after define palette*/
  WHITEINDEX = WhitePixel(dpy,DefaultScreen(dpy));
  BLACKINDEX = BlackPixel(dpy,DefaultScreen(dpy));

  /*find all visuals that belong to this screen */
  visuallist = XGetVisualInfo(dpy,VisualScreenMask,
                              &visualtemplate,&visualsmatched);
/*
printf("This screen is # %d, with %d color planes,  and %d total visuals\n"
       ,DefaultScreen(dpy),magedepth,visualsmatched);
*/
if(Ltest || Ltestcolor)
{
  printf("default visual: %d, WhitePixel== %d, BlackPixel== %d\n"
        ,defaultvisual,WhitePixel(dpy,DefaultScreen(dpy))
        ,BlackPixel(dpy,DefaultScreen(dpy))  );    
 XListInstalledColormaps(dpy,RootWindow(dpy,DefaultScreen(dpy)),&numcolormaps);
  printf("number of Installed Colormaps == %d\n",numcolormaps);
}

  idirectcolor = -1; /*flags for these color models at magescreen depth*/
  itruecolor = -1;
  ipseudocolor = -1;
  istaticcolor = -1;
  igrayscale = -1;
  istaticgray = -1;
  idefaultvisual = -1;
  firstpseudocolor = -1;

  for(j=0;j<visualsmatched;j++)
  {/*find all visuals of this screen*/
    if(visuallist[j].class==StaticGray)
    {
        sprintf(word,"StaticGray");
        if(visuallist[j].depth>=magedepth) istaticgray = j;
        if(visuallist[j].visual==defaultvisual) idefaultvisual = j;
    }
    if(visuallist[j].class==GrayScale)
    {
        sprintf(word,"GrayScale");
        if(visuallist[j].depth>=magedepth) igrayscale = j;
        if(visuallist[j].visual==defaultvisual) idefaultvisual = j;
    }
    if(visuallist[j].class==StaticColor) 
    {
        sprintf(word,"StaticColor");
        if(visuallist[j].depth>=magedepth) istaticcolor = j;
        if(visuallist[j].visual==defaultvisual) idefaultvisual = j;
    }
    if(visuallist[j].class==PseudoColor) 
    {
        sprintf(word,"PseudoColor");
        if(visuallist[j].depth>=magedepth) ipseudocolor = j;
        if(visuallist[j].visual==defaultvisual) idefaultvisual = j;
        if(firstpseudocolor<0 && visuallist[j].depth>=8) firstpseudocolor = j;
        /*identify first pseudocolor visual that would work for MAGE palatte*/

    }
    if(visuallist[j].class==TrueColor) 
    {
        sprintf(word,"TrueColor");
        if(visuallist[j].depth>=magedepth) itruecolor = j;
        if(visuallist[j].visual==defaultvisual) idefaultvisual = j;
    }
    if(visuallist[j].class==DirectColor) 
    {
        sprintf(word,"DirectColor");
        if(visuallist[j].depth>=magedepth) idirectcolor = j;
        if(visuallist[j].visual==defaultvisual) idefaultvisual = j;
    }
    if(Ltest || Ltestcolor)
     printf("class[%d] %d, %s, depth %d, #entries %d, bits/rgb %d, visual %d\n"
               ,j,visuallist[j].class,word,visuallist[j].depth
               ,visuallist[j].colormap_size
               ,visuallist[j].bits_per_rgb
               ,visuallist[j].visual);
  }/*find all visuals of this screen*/
  /*set color control flags*/
  if(magedepth >= 8){ Lcolor = 1; LLcolor = 1; LCscrn = 1;}
  if(magedepth < 8) { Lcolor = 1; LLcolor = 0; LCscrn = 0;} /*only gray*/
  if(magedepth < 4) { Lcolor = 0; LLcolor = 0; LCscrn = 0;} /*only B&W*/
  Lread_writecolors = 0; /*can't have complete palette control unless 1 */
  /*work through by priority all visuals that are at default screen depth */
/*961013 SGI won't admit to a directcolor that has only a depth of 8*/
/*Since the default screen has only 8, this leaves MAGE trying to match*/
/*colors with the X-palette - with is pretty pathetic for depth cueing*/
/*So try hunting for a visual that is >= 8, MAGE's preferred depth! */
  if(idirectcolor >= 0)     {idummycolor = idirectcolor; } /*not used*/
  else if(itruecolor >= 0)  {idummycolor = itruecolor; } /*not used*/
  /*else if(ipseudocolor >= 0){ivisual = ipseudocolor; Lread_writecolors = 1;}*/
  if     (ipseudocolor >= 0)
  {
      if(firstpseudocolor>=0) ivisual = firstpseudocolor;
      else                    ivisual = ipseudocolor; 
      Lread_writecolors = 1;
  }

  else if(istaticcolor >= 0) {ivisual = istaticcolor; }
  else if(igrayscale >= 0)   {ivisual = igrayscale;   LLcolor = 0;}
  else if(istaticgray >= 0) {ivisual = istaticgray;  LLcolor = 0; Lcolor = 0;}
  else if(idefaultvisual < 0)
  {
    if(Ltest || Ltestcolor)
    {
      printf("never found anything in full screen depth\n");
      printf("using ivisual=1, expect wierd results or a crash\n");
      printf("but setting color controls to off\n");
    }
      ivisual = 0; /*presume at least 0th visual exists*/
      Lcolor  = 0;
      LLcolor = 0;
  }
  else /*idefaultvisual >= 0*/
  {
    if(Ltest || Ltestcolor)
    {
      printf("never found anything in full screen depth\n");
      printf("using default visual\n");
    }
      ivisual = idefaultvisual;
  }


  magevisual = visuallist[ivisual].visual;
  magedepth = visuallist[ivisual].depth;
  if(Ltest || Ltestcolor)
    printf("using visual #%d, depth== %d\n",ivisual,visuallist[ivisual].depth);

      makexcolors();
}
/*___findmonitortype()________________________________________________________*/

/****myGetEntryColor()*********************common name: MAC & PC***********/
void    myGetEntryColor(int icolor)
{
#ifdef UNDEFINED
    GetEntryColor(MagePalette, icolor,  &rgbColor);
#endif
    rgbColor.red   = myfullpalette[icolor][0];
    rgbColor.green = myfullpalette[icolor][1];
    rgbColor.blue  = myfullpalette[icolor][2];

}
/*___myGetEntryColor()___________________________________________________*/

