/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/*MUXMDRAW.c*/
#include "MAGE.h"   
#include "MAGELIST.h"
#include "MAGETABL.h"
/****offscreenclear()********************************************************/
void    offscreenclear() /*heavy Mac specific stuff: */ /*m*/
{
    if(Lerase) 
    {
        if(Lwhitebkg) 
        {
            XSetForeground(dpy,offgc,incolor[WHITEINDEX]);
        }
        else
        {
            XSetForeground(dpy,offgc,incolor[BLACKINDEX]);
        }
        XFillRectangle(dpy,offscreen,offgc,0,0,GWIDTH,GHEIGHT);
        if(Lwhitebkg) 
        {
            XSetForeground(dpy,offgc,incolor[BLACKINDEX]);
        }
        else
        {
            XSetForeground(dpy,offgc,incolor[WHITEINDEX]);
        }
    }
}
/*___offscreenclear()_______________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****preparegrafwindow()*****************************************************/
void    preparegrafwindow() /*Mac specific stuff: */ /*m*/
{
        if(Lwhitebkg) 
        {
            XSetForeground(dpy,offgc,incolor[BLACKINDEX]);
            XSetBackground(dpy,offgc,incolor[WHITEINDEX]);
        }
        else
        {
            XSetForeground(dpy,offgc,incolor[WHITEINDEX]);
            XSetBackground(dpy,offgc,incolor[BLACKINDEX]);
        }
}
/*___preparegrafwindow()____________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/****copytoscreen()**********************************************************/
  /* copy bitmap into front window to see what has just been drawn */
void    copytoscreen() 
{ 
  /*XCopyArea(dpy,offscreen,drawWindow,offgc,0,0,GWIDTH,GHEIGHT,0,MHEIGHT/2);*/
    XCopyArea(dpy,offscreen,drawWindow,offgc,0,0,GWIDTH,GHEIGHT,0,0);
}
/*___copytoscreen()_________________________________________________________*/

/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/

/****redrawgraphics()********************common name: MAC & PC***************/
void  redrawgraphics() {redrawvec();}  /* equivalence Mac vs PC MAGE*/
/*___redrawgraphics()_______________________________________________________*/




/****redrawvec()*****************common name: MAC & PC**********************/
void    redrawvec()
{
   Lrecalculate = 0; /*need here since UNIX_PEX doesn't do it below */
   do 
   {
      predrawticks = (theclockcount() - icountticks);
      icountticks = theclockcount();

#ifndef UNIX_PEX
          if(Lplotonly)     Lerase = FALSE;
          else            Lerase = TRUE;
          if(Lfirstcall){ Lerase = TRUE; Lfirstcall = FALSE; }

          offscreenclear();
          /*XClearArea(dpy,drawWindow,0,0,GWIDTH,GHEIGHT,False);*/
          Lrecalculate = 0;         /*need here to allow redrawing to flag it*/
          drawvec(); /*MAGEDRAW.C*/
          preparegrafwindow();

          copytoscreen();
#endif /*UNIX_PEX*/

      postcopyticks = (theclockcount() - icountticks);
      icountticks = theclockcount();
      if(Lrecalculate) rescalekinemage();    /*MAGEINPT.C*/
   }while(Lrecalculate);
}
/*___redrawvec()____________________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/

/****stringtoscreen()*********************common name: MAC & PC**************/
void    stringtoscreen(char string[256],int ix,int iy)
{
    /*if(infofontsize != oldfontsize)*/
    {
        if(infofontsize <= littlefontsize && littleFont)
        {
            XSetFont(dpy,offgc,littleFont->fid);
        }
        else if(infofontsize <= mediumfontsize && mediumFont)
        {
            XSetFont(dpy,offgc,mediumFont->fid);
        }
        else if(infofontsize >= largefontsize && largeFont)
        {
            XSetFont(dpy,offgc,largeFont->fid);
        }
        else XSetFont(dpy,offgc,littleFont->fid); /*most likely exists*/
    }
    if(Lwhitebkg)
    {
            XSetForeground(dpy,offgc,incolor[BLACKINDEX]);
    }
    else
    {
            XSetForeground(dpy,offgc,incolor[WHITEINDEX]);
    }
    XDrawString(dpy,offscreen,offgc,ix,iy,string,strlen(string));
    oldfontsize = infofontsize; 
}
/*___stringtoscreen_________________________________________________________*/

/****labeltoscreen()**************************common name: MAC & PC**********/
void    labeltoscreen(char string[256],int ix,int iy,int icolorit)
{                                /* for labels */ /*PC has to set color */
    /*if(labelsfontsize != oldfontsize)*/
    {
        if(labelsfontsize <= littlefontsize && littleFont)
        {
           XSetFont(dpy,offgc,littleFont->fid);
        }
        else if(labelsfontsize <= mediumfontsize && mediumFont)
        {
           XSetFont(dpy,offgc,mediumFont->fid);
        }
        else if(labelsfontsize >= largefontsize && largeFont)
        {
           XSetFont(dpy,offgc,largeFont->fid);
        }
        else XSetFont(dpy,offgc,littleFont->fid); /*most likely exists*/
    }
    XSetForeground(dpy,offgc,incolor[icolorit]);
    XDrawString(dpy,offscreen,offgc,ix,iy,string,strlen(string));
    oldfontsize = labelsfontsize;
}
/*___labeltoscreen__________________________________________________________*/

/****killzoneonscreen()********************************************************/
void killzoneonscreen(void) /*990211*/
{
        setdrawcolorpen(2,2,3);
        killradius = 20;
        XDrawArc(dpy,offscreen,offgc
                    ,mousexold-killradius 
                    ,mouseyold-killradius
                    ,2*killradius
                    ,2*killradius
                    ,0,360*64);
}
/*___killzoneonscreen()_______________________________________________________*/

/****balltoscreen()*****************************common name: MAC & PC*********/
void balltoscreen(int xplace,int yplace,int idisk,int intradius
                 ,int ipen,int icolor,int type)
{
  int    iradius, inner, outer, expand; /*981015*/


          iradius = intradius; /*convert int to short for Mac*/      

  if(idisk == 5) 
  {/*keep ultimate capping disk from obscuring highlight on penutimate disk*/
      if(iradius == 2) iradius = 1; /*2: drop to 1*/
      else if(iradius <=1) iradius = -1; /*-1: don't draw*/
  }
  if(2*iradius < ipen || iradius < 1) 
      iradius = 1+ipen/2; /*limit vanishing ball 981015*/
  /*ipen==1 for thinline, 2: onewidth, 1---5 multiwide*/ /*981015*/
  /*X11 lines really stay within one pixel of centered on coord pixel*/
  /* so expand ball evenly around coord */
  if(ipen > 1) expand = ipen - 1; /*981015*/
  else expand = 0;
  if(iradius >= 0)
  {/*draw disk of finite radius*/
                XFillArc(dpy,offscreen,offgc
                          ,xplace-iradius-expand /*981015*/
                          ,yplace-iradius-expand /*981015*/
                          ,2*iradius+expand  /*981015*/
                          ,2*iradius+expand  /*981015*/
                          ,0,360*64);
  }
  if(type==1 &&(idisk == 0 || idisk == 4)) /*highlight on penultimate disk*/
  {/*highlight*/
    /*either pure disk or next-to-top disk of fudged space-fill stacked disks*/ 
    /*adjust iradius for the highlight*/
    if(idisk == 0)
    {
        /*iradius = iradius/2;*/ /*pure single disk, old case*/
        outer = (9*iradius)/20;
        inner = outer/2;
    }
    else if(idisk == 4)
    {
        /*highlight on annulus made by penultimate disk*/
        outer = (9*iradius)/12; /*radius of base disk already reduced*/
        inner = outer/2;
    }
    if( (outer - inner) <= 1)
    {/*always have a highlight, makes a gleam even when ball very small */
       /*need to aadjust to keep highlight visible*/
       inner = outer - 2;  /*effectively increase highlight size*/ /*981015*/
    }
    if(Lcolor) 
    {
            XSetForeground(dpy,offgc,incolor[WHITEINDEX]);
    }
    else if(Lwhitebkg)
    {
            XSetForeground(dpy,offgc,incolor[WHITEINDEX]);
    }
    else
    {
            XSetForeground(dpy,offgc,incolor[BLACKINDEX]);
    }

                XFillArc(dpy,offscreen,offgc
                         ,xplace-outer-expand  /*981015*/
                         ,yplace-outer-expand   /*981015*/
                         ,outer-inner
                         ,outer-inner
                         ,0
                         ,360*64);
               
    /*restore working color*/
    setpencolor(icolor); /*____DRAW.c*/
  }/*highlight*/
}
/*___balltoscreen()_________________________________________________________*/

/****TBstereo_balltoscreen()*******************common name: MAC PC UNIX******/
void TBstereo_balltoscreen(int xplace,int yplace,int idisk,int intradius
                 ,int ipen,int icolor,int type)
{
  int    xiradius, xinner, xouter;              
  int    yiradius, yinner, youter;              


          xiradius = intradius; /*convert int to short for Mac*/      
          yiradius = intradius/2; /*convert int to short for Mac*/      

  if(idisk == 5) 
  {/*keep ultimate capping disk from obscuring highlight on penutimate disk*/
      if(xiradius == 2) xiradius = 1; /*2: drop to 1*/
      else if(xiradius <=1) xiradius = -1; /*-1: don't draw*/
      if(yiradius == 2) yiradius = 1; /*2: drop to 1*/
      else if(yiradius <=1) yiradius = -1; /*-1: don't draw*/
  }
  if(yiradius >= 0) /*y is the smaller*/
  {/*draw disk of finite radius*/
                XFillArc(dpy,offscreen,offgc
                          ,xplace-xiradius
                          ,yplace-yiradius
                          ,2*xiradius+ipen
                          ,2*yiradius+ipen
                          ,0,360*64);
  }
  if(type==1 &&(idisk == 0 || idisk == 4)) /*highlight on penultimate disk*/
  {/*highlight*/
    /*either pure disk or next-to-top disk of fudged space-fill stacked disks*/ 
    /*adjust iradius for the highlight*/
    if(idisk == 0)
    {
        /*iradius = iradius/2;*/ /*pure single disk, old case*/
        xouter = (9*xiradius)/20;
        xinner = xouter/2;
        youter = (9*yiradius)/20;
        yinner = youter/2;
    }
    else if(idisk == 4)
    {
        /*highlight on annulus made by penultimate disk*/
        xouter = (9*xiradius)/12; /*radius of base disk already reduced*/
        xinner = xouter/2;
        youter = (9*yiradius)/12; /*radius of base disk already reduced*/
        yinner = youter/2;
    }
    if( (xouter - xinner) <= 1)
    {/*always have a highlight, makes a gleam even when ball very small */
     /*need to aadjust to keep highlight visible*/
       if( (xouter - xinner) <= 0) xouter = xinner;
       xinner = xinner-1;  /*effectively increase highlight size*/
    }
    if( (youter - yinner) <= 1)
    {/*always have a highlight, makes a gleam even when ball very small */
     /*need to aadjust to keep highlight visible*/
       if( (youter - yinner) <= 0) youter = yinner;
       yinner = yinner-1;  /*effectively increase highlight size*/
    }
    if(Lcolor) 
    {
            XSetForeground(dpy,offgc,incolor[WHITEINDEX]);
    }
    else if(Lwhitebkg)
    {
            XSetForeground(dpy,offgc,incolor[WHITEINDEX]);
    }
    else
    {
            XSetForeground(dpy,offgc,incolor[BLACKINDEX]);
    }

                XFillArc(dpy,offscreen,offgc
                         ,xplace-xouter
                         ,yplace-youter
                         ,xouter-xinner
                         ,youter-yinner
                         ,0
                         ,360*64);
               
    /*restore working color*/
    setpencolor(icolor); /*____DRAW.c*/
  }/*highlight*/
}
/*___TBstereo_balltoscreen()_________________________________________________*/

/****wordstoscreen()************************common name: MAC & PC*************/
void    wordstoscreen(char commentstr[256],int ix,int iy,int icolorit)
{                                /* for labels */ /*PC has to set color */
  int   j,k,kk,workingfontsize,ixorig;
  /*int Thisfont;*/
  /*int Thisface;*/
  int Thissize;
  XFontStruct *thisFont;

  ixorig = ix;

  if(commentstr[3] != '\0')
  {/*string longer than zero length*/

            /*Thisfont = (int)commentstr[0];*/
            /*Thisface = (int)commentstr[1];*/
            Thissize = (int)commentstr[2];
            for(j=3;j<=255;j++)
            {
                commentstr[j-3] = commentstr[j];
                if(commentstr[j]=='\0') break;
            } 

/*printf("%s\n",commentstr);*/

    if(Thissize != 0) workingfontsize = Thissize;
    else workingfontsize = wordsfontsize;

    /*if(workingfontsize != oldfontsize)*/
    {
        if(workingfontsize <= littlefontsize && littleFont)
        {
           thisFont = littleFont;
        }
        else if(workingfontsize <= mediumfontsize && mediumFont)
        {
           thisFont = mediumFont;
        }
        else if(workingfontsize >= largefontsize && largeFont)
        {
           thisFont = largeFont;
        }
        else
        {
           thisFont = littleFont;
        }
        XSetFont(dpy,offgc,thisFont->fid);
        XSetFont(dpy,gc,thisFont->fid);
    }
    XSetForeground(dpy,offgc,incolor[icolorit]);
            k=0;
            for(j=0;j<=255;j++)
            {/*loop over all char in string*/
                kk = j;
                word[j-k] = commentstr[j];
                if(commentstr[j]=='\\')
                {/*skip this \  and draw next character as a special case*/
                    kk = j-1;
                    word[j-k] = '\0';
                    XDrawString(dpy,offscreen,offgc,ix,iy,word,strlen(word));
/*printf("%s: x==%d, y==%d\n",word,ix,iy);*/
                    ix = ix + XTextWidth(thisFont,word,strlen(word));



                    /*if(restoreFont) XSetFont(dpy,offgc,thisFont->fid);*/
                    j=j+1; 
                    k=j+1;/*k is one more so when j loop augmented j-k==0*/
                    word[0] = commentstr[j];
                    word[1] = '\0';
                    XDrawString(dpy,offscreen,offgc,ix,iy,word,strlen(word));
/*printf("%s: x==%d, y==%d\n",word,ix,iy);*/
                    ix = ix + XTextWidth(thisFont,word,strlen(word));
                }
                else if(commentstr[j]=='\015')
                {
                    kk = j-1;
                    word[j-k] = '\0';
                    XDrawString(dpy,offscreen,offgc,ix,iy,word,strlen(word));
/*printf("%s: x==%d, y==%d\n",word,ix,iy);*/
                    ix = ix + XTextWidth(thisFont,word,strlen(word));
                    /*if(restoreFont) XSetFont(dpy,offgc,thisFont->fid);*/
                    j=j+1; /*j will be augmented at top of cycle*/
                    k=j+2;
                }
                else if(commentstr[j]=='\015')
                {
                    kk = j-1;
                    word[j-k] = '\0';
                    XDrawString(dpy,offscreen,offgc,ix,iy,word,strlen(word));
/*printf("%s: x==%d, y==%d\n",word,ix,iy);*/
                    ix = ixorig;
                    iy = iy + wordsfontsize;
                    k = j+1;
                }
                else if(commentstr[j]=='{')
                {
                    kk = j-1;
                    word[j-k] = '\0';
                    XDrawString(dpy,offscreen,offgc,ix,iy,word,strlen(word));
/*printf("%s: x==%d, y==%d\n",word,ix,iy);*/
                    ix=ix+XTextWidth(thisFont,word,strlen(word));
                    iy = iy + wordsfontsize/3;
                    k = j+1;
                }
                else if(commentstr[j]=='}')
                {
                    kk = j-1;
                    word[j-k] = '\0';
                    XDrawString(dpy,offscreen,offgc,ix,iy,word,strlen(word));
/*printf("%s: x==%d, y==%d\n",word,ix,iy);*/
                    ix=ix+XTextWidth(thisFont,word,strlen(word));
                    iy = iy - wordsfontsize/3;
                    k = j+1;
                }
                else if(commentstr[j]==EOL) 
                {
                     kk = j-1;
                     word[j-k] = '\0';
    XDrawString(dpy,offscreen,offgc,ix,iy,word,strlen(word));
/*XDrawString(dpy,offscreen,offgc,ix,iy,commentstr[k],strlen(commentstr[k]));*/
/*printf("%s: x==%d, y==%d\n",word,ix,iy);*/
                     iy=iy + workingfontsize;
                     ix = ixorig;
                     k = j+1  ;
                }
                else if(commentstr[j] == '\0') break;
            }/*loop over all char in string*/
            if(k<kk)
            {
                word[j-k] = '\0';
    XDrawString(dpy,offscreen,offgc,ix,iy,word,strlen(word));
/*printf("%s: x==%d, y==%d\n",word,ix,iy);*/
            }
    oldfontsize = workingfontsize;
  }/*string longer than zero length*/

}
/*___wordstoscreen__________________________________________________________*/

/****setdrawcolorpen()**************************common name: MAC & PC********/
void    setdrawcolorpen(int ix,int iy,int icolor)
{

  XSetLineAttributes(dpy,offgc,ix,LineSolid,CapRound,JoinRound);
  setpencolor(icolor); /*____DRAW.c*/
}
/*___setdrawcolorpen()______________________________________________________*/

/****setpencolor()***********************************************************/
void setpencolor(icolor)
{
 /*set foreground*/
 if(Lcolor && incolored[icolor]) /*color and defined color cell*/
 {
         XSetForeground(dpy,offgc,incolor[icolor]);
 }
 else if(Lwhitebkg)
 {
            XSetForeground(dpy,offgc,incolor[BLACKINDEX]);
 }
 else
 {
            XSetForeground(dpy,offgc,incolor[WHITEINDEX]);
 }
}
/*___setpencolor()__________________________________________________________*/

/****triangletoscreen()******************************************************/
void triangletoscreen(int x1, int y1, int x2, int y2, int x3, int y3
                    , int icolor)
{
#ifdef WIERD
  typedef struct {
      short x, y;
  } XPoint;
#endif

  XPoint aPoints[3];

  aPoints[0].x = x1;
  aPoints[0].y = y1;
  aPoints[1].x = x2;
  aPoints[1].y = y2;
  aPoints[2].x = x3;
  aPoints[2].y = y3;

  setpencolor(icolor); /*____DRAW.c*/

  XFillPolygon(dpy,offscreen,offgc
              ,aPoints
              ,sizeof(aPoints)/sizeof(aPoints[0])
              ,Convex
              ,CoordModeOrigin);
}
/*___triangletoscreen()______________________________________________________*/

/****linetoscreen()***********************************************************/
void linetoscreen(int x1, int x2, int y1, int y2)
{
   XDrawLine( dpy, offscreen, offgc ,x1,y1,x2,y2);
}
/*___linetoscreen()__________________________________________________________*/

/****marktoscreen()***********************************************************/
void marktoscreen(int x, int y, int r, int icolor)
{
   int w = 4;
   setdrawcolorpen(w,w,icolor);
   XDrawRectangle(dpy,offscreen,offgc
                       , (x  - r)   
                       , (y  - r)   
                       , (2*r)
                       , (2*r) );
}
/*___marktoscreen()__________________________________________________________*/

/****ringtoscreen()***********************************************************/
void ringtoscreen(int x, int y, int r, int icolor)
{
   int w = 4;
   setdrawcolorpen(w,w,icolor);
   XDrawArc(dpy,offscreen,offgc
                       , (x  - r)   
                       , (y  - r)   
                       , (2*r)
                       , (2*r) 
                       ,0,360*64);
}
/*___ringtoscreen()__________________________________________________________*/

/****fantoscreen()************************************************************/
void fantoscreen(int x, int y, int icolor, int coloroffset, pointstruct* theptptr)
{
   int x2=0,y2=0,x3=0,y3=0, r=0, xo=0, yo=0;
   float co=0, si=0, mag=0, o=0;
   
   XPoint aPoints[4];

   icolor = icolor; /*PC needs icolor for brush to fill polygons*/
   
   /*NOTE: color and penwidth already have been set for this point*/
   /*virtual pen has already been moved to x1,y1*/
   if(theptptr->moreinfoptr != NULL)
   {/*there is cos,sin info for this radial line*/
      /*for planning, disect components despite computational inefficiency*/
      r = (int)(scalenew*tablefancore); /*fudged radius of inner circle*/
      co = (theptptr->moreinfoptr)->f1; /*stored values of cos, sin */
      si = (theptptr->moreinfoptr)->f2; /*computed when table loaded*/
      mag = scalenew*(theptptr->radius)*tablefanradius;
   

      x2 = (int)((r+mag)*co); /*spine end at outer extent*/
      y2 = (int)((r+mag)*si);
      x3 = (int)(r*co);  /*spine end at inner circle*/
      y3 = (int)(r*si);

      /*angle = (180/(MAXROW+1));*/
      /*angle between spines, half circum == h = pi * radius */
      /*max non-overlapped tangent length ~= t = h/(MAXROW+1) */
      /*max offset to either side at end of spine == o = t/2;*/
      o = 3.14*(r+mag)/(2*(MAXROW+1)); 
      xo = (int)(o * si); /*perpendicular to spine*/
      yo = (int)(o * co);
  
    

      aPoints[0].x = x+x3; /*inner end of radial spine*/
      aPoints[0].y = y-y3;
      aPoints[1].x = x+x2+xo; /*cross arm at outer end of spine*/
      aPoints[1].y = y-y2+yo;
      aPoints[2].x = x+x2-xo; /*cross arm at outer end of spine*/
      aPoints[2].y = y-y2-yo;
      aPoints[3].x = x+x3; /*inner end of radial spine*/
      aPoints[3].y = y-y3;

      XFillPolygon( dpy,offscreen,offgc
                   ,aPoints
                   ,sizeof(aPoints)/sizeof(aPoints[0])
                   ,Convex
                   ,CoordModeOrigin);

   }/*there is cos,sin info for this radial line*/
   setdrawcolorpen(2,2,7+coloroffset);

   XDrawArc( dpy,offscreen,offgc
            , (x  - r)   
            , (y  - r)   
            , (2*r)
            , (2*r) 
            ,0,360*64);
}
/*___fantoscreen()___________________________________________________________*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
