/*MUXMINIT.c*/  /* MOTIF widgets */
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
/*
  mainsetup
  The mainsetup routine creates the widget hierarchy for the program.
  The widget hierarchy used here is:

  (class topLevelShell)
     |
     +-- form (class Form)
           |
	   +--- drawArea (class DrawingArea)
	   |

  The Form widget is used for organizing its child widgets.
  The drawing area widget is used for X11 (or other) draws. 
  The MAGE toggle buttons are used to control the parts of the image displayed.
  The menu items control other functions like file select and quit operations.

  Any necessary resources for the widgets are specified here in the
  program, which override any user defaults or command-line options.  Note
  that this is not very friendly to the user who may want to change the
  font of the push buttons, but MAGE traditionally has had to control its
  own appearance, and it has its own requirments for real estate usage.  

  The display connection (dpy) and window ID (drawWindow) of the drawing
  area widget are available after the widget hierarchy has been realized.
*/
/* 
      Once upon a time this file started with code bundled with the
  ESV, though it has been hacked much beyond recognition, some of the
  motif calls and setups here owe recognition to:
       		Rich Thomson
                Design Systems Division
		Evans & Sutherland Computer Corporation
         Date:  Thursday, June 12th, 1990
       Modified:  J. Buckmiller   Mar 1991.   Approved C binding
  Dave Richardson, June 1994
*/
  
#include "MAGE.h"       
#include "MAGEMENU.h"
#include "MAGELIST.h"
#include "MAGETABL.h"

#ifdef UNIX_PEX
 /* Historical code for the ESV, archive as example of using esternal dials*/
 /* these event handlers take care of blanking and restoring the dial labels */
 extern void enter_handler(Widget, caddr_t, XEvent *,Boolean *); /*MUXPHIG.c*/
 extern void leave_handler(Widget, caddr_t, XEvent *,Boolean *); /*MUXPHIG.c*/
 /*defined for drawArea*/
#endif /*UNIX_PEX*/

#ifdef UNIX_X11
#include <X11/cursorfont.h>
#include <Xm/Protocols.h>
#endif /*UNIX_X11*/

/****mainsetup()*************************************************************/
void    mainsetup(int *argc, char** argv)
{
  int     copy_of_argc, argv_size;
  char**  copy_of_argv;

  int    ncommon = 0;
  int scrHeight = 0;
  int scrWidth = 0;
  int scrsize = 0;

  Lcarry = 0;
  Lnewfile = 0; /*no file in mind*/
  Lstartfile = 0; /*mage not launched by a file*/
  if(*argc>1)
  {/*commandline contains an original kinemage file name*/
      strcpy(NameStr,argv[1]); /*file name copied into MAGE input file Name*/
      Lnewfile=1;   /*file is present*/
      Lstartfile=1; /*file launched mage, use it*/
  }
 

  getmageversion(); /*common version number: MAGEINIT.c */


    IMAC = 0; /*flow control for Macintosh computers */
    IPC  = 0;  /*flow control for PC computers with windows */
    IESV = 0;  /*flow control for E&S ESV Unix with  Xwindows */
    IUXM = 1;  /*flow control for  Unix with Xwindows and Motif*/
    IUX  = 1;  /*flow control for  Unix with Xwindows*/
    IUXP = 0;  /*flow control for  Unix with Xwindows and PEX*/
  mageinitialvalues(); /*mageinit.c*/ /*in case need MAGE parameters*/

  fprintf(stderr,"%s\n",version);

  /*Initialize X toolkit the long way so can mess with color palette */
  XtToolkitInitialize();
  app_context = XtCreateApplicationContext();
  /*copy commandline parameters*/
  copy_of_argc = *argc;
  argv_size = copy_of_argc * (sizeof(char*));
  copy_of_argv = (char**)XtMalloc(argv_size);
  memcpy(copy_of_argv, argv, argv_size);

  /*open display connection*/
  dpy = XtOpenDisplay(app_context,
        NULL,
        NULL,
        "MAGE",
        (XrmOptionDescList) NULL,
        0,
        argc,
        argv);

  /*Now can set visual stuff before opening top shell */
  scrHeight = DisplayHeight( dpy, DefaultScreen(dpy));
  scrWidth  = DisplayWidth ( dpy, DefaultScreen(dpy));
  if(scrHeight < scrWidth) {scrsize = scrHeight;}
  else {scrsize = scrWidth;}
  /*this duplicate some of the static initializations in MAGEINIT.c*/
  if(scrsize > 875)
  {
      GWIDTH  = 800;  /* UNIX effective graphics area window width */
      GHEIGHT = 800;  /* graphics window height*/
  }
  else if(scrsize > 675)
  {
      GWIDTH  = 600;  /* UNIX effective graphics area window width */
      GHEIGHT = 600;  /* graphics window height*/
  }
  else
  {
      GWIDTH  = 400;  /* Mac effective graphics area window width */
      GHEIGHT = 400;  /* graphics window height*/
  }
  WIDTH =  GWIDTH; /*GWIDTH & GHEIGHT adjusted when make grafWindow*/
  HEIGHT = GHEIGHT;/* WIDTH & HEIGHT reset then also */
  if(GWIDTH<GHEIGHT) oldmaxwide = GWIDTH;
  else               oldmaxwide = GHEIGHT;
  
  GZDEEP = oldmaxwide;
  ieyewide = GWIDTH/2;
  /*std screen box 400x400x400, 0 at ctr, zclip 200 from ctr*/
  /*fzclip = 1.0;*/ /*factor==1.0 for std box, scale if screen box resized */
  fzclip = (float)GZDEEP/(float)400;/*std izclip defined in std screen box*/
  /*fzclip mediates between internal izclip value adjusted for box expansion*/
  /* and external izclip which pretends to be in a 400x400x400 box */
  izclipold[0] = 200;
  izclip = fzclip*izclipold[0]; /*refudge izclip*/
  iztranold[0] = 0;
  iztran = fzclip*iztranold[0]; /*refudge iztran*/
  Loriginatctr = 0;
  ixctr = GWIDTH/2;
  iyctr = GHEIGHT/2;
  izctr = GZDEEP/2;


if (GWIDTH<800 && (buttonFont =
    XLoadQueryFont(dpy, "-*-Helvetica-Bold-R-Normal--12*") ) )
{
    /*printf("Small screen: little font Helvetica-Bold-R-Normal--12\n");*/
    fontList = XmFontListCreate(buttonFont, XmSTRING_DEFAULT_CHARSET);
}
else if(buttonFont =
    XLoadQueryFont(dpy, "-*-Helvetica-Bold-R-Normal--14*") )
{
    /*printf("1st choice: little font  Helvetica 14\n");*/
    fontList = XmFontListCreate(buttonFont, XmSTRING_DEFAULT_CHARSET);
}
else if(buttonFont =
       XLoadQueryFont(dpy, "-*-fixed-bold-r-normal--15*") )
{
    /*printf("2nd choice: little font fixed-bold-r 15\n");*/
    fontList = XmFontListCreate(buttonFont, XmSTRING_DEFAULT_CHARSET);
}
else if(buttonFont =
       XLoadQueryFont(dpy, "-*-fixed--r-normal--15*") )
{
    /*printf("3rd choice: little font fixed--r 15\n");*/
    fontList = XmFontListCreate(buttonFont, XmSTRING_DEFAULT_CHARSET);
}
else
{
    /*printf("using default font for little font\n");*/
}
/*printf("buttonFont== %ld\n",(long)buttonFont);*/
/*if(buttonFont) printf("fontList==%ld\n",(long)fontList);*/

/*printf("about to set default Font stuff\n");*/
/*find some bigger fonts*/
labelsfontsize = 14;
wordsfontsize = 14;
infofontsize = 14;
oldfontsize = 14;
littlefontsize = 14;
mediumfontsize = 18;
largefontsize = 24;
/*defaults*/
littleFont = buttonFont;
if (buttonFont) littlefontList = fontList;

if (mediumFont =
    XLoadQueryFont(dpy, "-*-Helvetica-Bold-R-Normal--18*") )
{
/*printf("1st choice: medium font Helvetica-Bold-R-Normal--18\n");*/
    mediumfontList = XmFontListCreate(buttonFont, XmSTRING_DEFAULT_CHARSET);
}
else if( mediumFont =
       XLoadQueryFont(dpy, "-*-fixed-bold-r-normal--18*") )
{
/*printf("2nd choice: medium font fixed-bold-r-normal--18\n");*/
    mediumfontList = XmFontListCreate(mediumFont, XmSTRING_DEFAULT_CHARSET);
}
else if( mediumFont =
       XLoadQueryFont(dpy, "-*-fixed--r-normal--18*") )
{
/*printf("3rd choice: medium font fixed--r-normal--18\n");*/
    mediumfontList = XmFontListCreate(mediumFont, XmSTRING_DEFAULT_CHARSET);
}
else 
{
    mediumFont = buttonFont;
    /*printf("medium font == little font\n");*/
    if (buttonFont) mediumfontList = fontList;
}
/*printf("mediumFont== %ld\n",(long)mediumFont);*/

if (largeFont =
    XLoadQueryFont(dpy, "-*-Helvetica-Bold-R-Normal--24*") )
{
    /*printf("1st choice: large font Helvetica-Bold-R-Normal--24\n");*/
    largefontList = XmFontListCreate(buttonFont, XmSTRING_DEFAULT_CHARSET);
}
else if( largeFont =
       XLoadQueryFont(dpy, "-*-fixed-bold-r-normal--24*") )
{
    /*printf("2nd choice: large font fixed-bold-r-normal--24\n");*/
    largefontList = XmFontListCreate(largeFont, XmSTRING_DEFAULT_CHARSET);
}
else if( largeFont =
       XLoadQueryFont(dpy, "-*-fixed--r-normal--24*") )
{
    /*printf("3rd choice: large font fixed--r-normal--24\n");*/
    largefontList = XmFontListCreate(largeFont, XmSTRING_DEFAULT_CHARSET);
}
else 
{
    largeFont = buttonFont;
    /*printf("large font == little font\n");*/
    if (buttonFont) largefontList = fontList;
}
/*printf("largeFont== %ld\n",(long)largeFont);*/

/*printf("screen Height== %d, Width== %d\n",scrHeight,scrWidth);*/





/*discover Visual attributes of this computer */
#ifdef UNIX_PEX
  magevisual = DefaultVisual(dpy,DefaultScreen(dpy));
  magedepth = DefaultDepth(dpy,DefaultScreen(dpy));
  colormap = DefaultColormap(dpy,DefaultScreen(dpy));
      windowbackground = WhitePixel(dpy,DefaultScreen(dpy));
      windowborder = BlackPixel(dpy,DefaultScreen(dpy));
#else

  findmonitortype(); /*calls makexcolors()*/ /*MUX_COLR.c*/

  /*if(incolored[255])*/
  /*if(incolored[39])*/ /*full white*/
  /*if(incolored[216])*/ /*yellowtint4*/
  /*if(incolored[30])*/ /*yellow0*/
  /*if(incolored[212])*/ /*brown4*/
  if(incolored[37]) /*brown0w*/
  {
      /*windowbackground = incolor[255];*/
      /*windowbackground = incolor[39];*/
      /*windowbackground = incolor[216]; */
      /*windowbackground = incolor[30]; */
      /*windowbackground = incolor[212];*/
      windowbackground = incolor[37];
  }
  else
  {
      windowbackground = WhitePixel(dpy,DefaultScreen(dpy));
  }
  if(incolored[0]) /*incolor for black can be == 0 !! */
  {
      windowborder = incolor[0];
      windowforeground = incolor[0];
  }
  else
  {
      windowborder = BlackPixel(dpy,DefaultScreen(dpy));
      windowforeground = BlackPixel(dpy,DefaultScreen(dpy));
  }
/*
printf("incolor[255]==%d, incolor[0]==%d\n"
,incolor[255],incolor[0]);
printf("WhitePixel==%d, BlackPixel==%d\n"
,WhitePixel(dpy,DefaultScreen(dpy)),BlackPixel(dpy,DefaultScreen(dpy)) );
printf("windowbackground==%d, windowforeground==%d\n"
,windowbackground,windowforeground);
*/
  highlightcolor = incolor[102]; /*green2*/
  /*topshadowcolor = incolor[163];*/ /*gray3*/
  /*bottomshadowcolor = incolor[163];*/ /*gray3*/
  topshadowcolor = incolor[13]; /*gray0*/
  bottomshadowcolor = incolor[13]; /*gray0*/
  /*selectcolor = incolor[202];*/ /*green4*/
  selectcolor = incolor[2]; /*green0*/
  troughcolor = incolor[113];/*gray2*/
  /*troughcolor = incolor[112];*//*brown2*/
  /*troughcolor = incolor[103];*//*blue2*/
  /*troughcolor = incolor[102];*//*green2*/
  armedfillcolor = incolor[52]; /*green1*/

  /*windowbackground = incolor[WHITEINDEX];*/
  /*windowborder = incolor[BLACKINDEX];*/
#endif

  /* create Application Shell for mage named topLevel */
  /* set in commandline parameters */
  n = 0;
  XtSetArg(args[n], XmNvisual, magevisual); n++;
  XtSetArg(args[n], XmNdepth, magedepth); n++;
  XtSetArg(args[n], XmNcolormap, colormap); n++;
  XtSetArg(args[n], XmNbackground, windowbackground); n++;
  XtSetArg(args[n], XmNborderColor, windowborder); n++;
  XtSetArg(args[n], XmNforeground, windowforeground); n++;
  XtSetArg(args[n], XmNhighlightColor, highlightcolor); n++;
  XtSetArg(args[n], XmNtopShadowColor, topshadowcolor); n++;
  XtSetArg(args[n], XmNbottomShadowColor, bottomshadowcolor); n++;
  XtSetArg(args[n], XmNselectColor, selectcolor); n++;
  XtSetArg(args[n], XmNtroughColor, troughcolor); n++;
  XtSetArg(args[n], XmNarmColor, armedfillcolor); n++;

  XtSetArg(args[n], XmNargc, copy_of_argc); n++;
  XtSetArg(args[n], XmNargv, copy_of_argv); n++;
  XtSetArg(args[n], XmNallowResize, True); n++;
  XtSetArg(args[n], XmNmappedWhenManaged, False); n++;
  XtSetArg(args[n], XmNtitle, "MAGE"); n++;
  XtSetArg(args[n], XmNx, 100); n++;
  XtSetArg(args[n], XmNy, 20); n++;
  XtSetArg(args[n], XmNwidth, GWIDTH+BWIDTH+ZWIDTH); n++; 
                         /*orig==800, 100,   30,  UNIX not use RWIDTH here */
  XtSetArg(args[n], XmNheight,GHEIGHT+MHEIGHT); n++; /*orig==860,GHEIGHT==800*/
  topLevel = XtAppCreateShell(NULL,
                             "MAGE",
                             applicationShellWidgetClass,
                             dpy,
                             args,n);

/*printf("topLevel created\n");*/

  /*create topgraf as a popup shell under topLevel*/
  n = 0;
  XtSetArg(args[n], XmNvisual, magevisual); n++;
  XtSetArg(args[n], XmNdepth, magedepth); n++;
  XtSetArg(args[n], XmNcolormap, colormap); n++;
  XtSetArg(args[n], XmNbackground, windowbackground); n++;
  XtSetArg(args[n], XmNborderColor, windowborder); n++;
  XtSetArg(args[n], XmNforeground, windowforeground); n++;
  XtSetArg(args[n], XmNhighlightColor, highlightcolor); n++;
  XtSetArg(args[n], XmNtopShadowColor, topshadowcolor); n++;
  XtSetArg(args[n], XmNbottomShadowColor, bottomshadowcolor); n++;
  XtSetArg(args[n], XmNselectColor, selectcolor); n++;
  XtSetArg(args[n], XmNtroughColor, troughcolor); n++;
  XtSetArg(args[n], XmNarmColor, armedfillcolor); n++;

  if (buttonFont){ XtSetArg(args[n], XmNfontList, fontList); n++;}
  ncommon = n;
  XtSetArg(args[n], XmNtitle, "MAGE GRAPHICS"); n++;
  XtSetArg(args[n], XmNx, 100); n++;
  XtSetArg(args[n], XmNy, 20); n++;
  XtSetArg(args[n], XmNwidth, GWIDTH+BWIDTH+ZWIDTH); n++; 
  XtSetArg(args[n], XmNheight,GHEIGHT+MHEIGHT); n++; /*orig==860,GHEIGHT==800*/
  XtSetArg(args[n], XmNallowResize, True); n++;
  XtSetArg(args[n], XmNdeleteResponse, XmDO_NOTHING); n++; /*use quit_CB*/
  /*XtSetArg(args[n], XmNmappedWhenManaged, False); n++;*/
  topgraf = XtCreatePopupShell("graf",
                               topLevelShellWidgetClass,
                               topLevel,
                               args, n);
  /*setup a callback so choosing close, or exit from the window bar*/
  /*actually quits the whole MAGE program, not just closes that window*/
  /*Though it is supposed to be bad programing practice to just disable*/
  /*the close and exit functions, I can't make the suggested code work to */
  /*call my own quit_CB.  Disable is worse than disappear and/or crash*/
/* WM_DELETE_WINDOW = XmInternAtom(dpy,"WM_DELETE_WINDOW",False);*/
/* XmAddWMProtocolCallback(topLevel,WM_DELETE_WINDOW,(XtCallbackProc)quit_CB,NULL);*/

  /*create grafwindow as a form widget to hold drawArea, menus, buttons, etc.*/
  n = ncommon;  /* window title is a regular string */
  XtSetArg(args[n], XmNtitle, "GRAPHICS"); n++;
  XtSetArg(args[n], XmNx, 100); n++;
  XtSetArg(args[n], XmNy, 20); n++;
  XtSetArg(args[n], XmNwidth, GWIDTH+BWIDTH+ZWIDTH); n++;
  XtSetArg(args[n], XmNheight,GHEIGHT+MHEIGHT); n++; /*orig==860,GHEIGHT==800*/

  grafwindow =				/* create the grafwindow for layout */
    XtCreateManagedWidget("graff",xmFormWidgetClass,topgraf, args, n);
    /*XmCreateForm(topgraf,"grafwindow", args, n);*/
    /*XtCreateWidget("grafwindow", xmFormWidgetClass, topgraf, NULL, 0);*/
  /*XtManageChild(grafwindow);*/
#ifdef UNIX_PEX
  XtAddEventHandler(grafwindow, Button1MotionMask, False, motion_handler, NULL);
  /*motion_handler and pick_CB in MUX_MAIN.c for consistency of ___MAIN stuff*/
  /*motion by dials even when move cursor out of drawArea to hit buttons*/
  /*these event handlers take care of blanking and restoring the dial labels */
  XtAddEventHandler(grafwindow, EnterWindowMask, False, enter_handler, NULL);
  XtAddEventHandler(grafwindow, LeaveWindowMask, False, leave_handler, NULL);
#endif

/*printf("grafwindow created\n");*/
/***********************MENU************************************************/
/*create menuBar*/
  n = ncommon;
  XtSetArg(args[n], XmNrowColumnType, XmMENU_BAR); n++;
  XtSetArg(args[n], XmNheight, MHEIGHT/2); n++;
  XtSetArg(args[n], XmNpacking, XmPACK_COLUMN); n++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
  /*XtSetArg(args[n], XmNrightOffset, BWIDTH+ZWIDTH); n++;*/
  XtSetArg(args[n], XmNrightOffset, ZWIDTH); n++;
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
  menuBar = XmCreateMenuBar(grafwindow, "menuBar", args, n);
  XtManageChild(menuBar);

/*FILEMENU**********************************************************/
/*create a Pulldown Menu Pane */
  n = ncommon;
  fileMenu = XmCreatePulldownMenu(menuBar, "File", args, n);
  /*do not managechild here, popup level is not complete*/
/*create menu CascadeButton for this Menu Pane*/
  n = ncommon;
  XtSetArg(args[n], XmNsubMenuId, fileMenu); n++;
  fileButton = XmCreateCascadeButton(menuBar, "File", args, n);
  XtManageChild(fileButton);

/*create buttons on this Pulldown Menu Pane*/
/*this works for created colormap, fails for default colormap*/
  n = ncommon;
  openItem = XmCreatePushButton(fileMenu,"Open New File...",args,n);
  XtAddCallback(openItem, XmNactivateCallback,(XtCallbackProc)open_CB, NULL); 
  XtManageChild(openItem);
  n = ncommon;
  appendItem = XmCreatePushButton(fileMenu,"Append File...",args,n);
  XtAddCallback(appendItem, XmNactivateCallback,(XtCallbackProc)append_CB,NULL);
  XtManageChild(appendItem);

  n = ncommon;
  writekinItem = 
             XmCreatePushButtonGadget(fileMenu,"Save As...",args,n);
  XtAddCallback(writekinItem,XmNactivateCallback
                                ,(XtCallbackProc)writekin_CB, NULL);
  XtManageChild(writekinItem);

/*NOTE: USING DISTINCTION BETWEEN PushButton and ToggleButton !!!! */
 
/*    FileMenu sub: WriteMenu  **********/

/*create Pulldown MenuPane for Write Menu under File Menu*/
  n = ncommon;
  writeMenu = XmCreatePulldownMenu(fileMenu, "Write Menu dummy", args, n);
  /*do not managechild here, popup level is not complete*/

/*create menus CascadeButton for each MenuPane*/
  n = ncommon;
  XtSetArg(args[n], XmNsubMenuId, writeMenu); n++;
  writeButton = XmCreateCascadeButton(fileMenu, "Save Special", args, n);
  XtManageChild(writeButton);

  n = ncommon;
  writedrawnewItem =XmCreatePushButtonGadget(writeMenu,"DrawNew Parts",args,n);
  XtAddCallback(writedrawnewItem,XmNactivateCallback
                ,(XtCallbackProc)writedrawnew_CB, NULL);
  XtManageChild(writedrawnewItem);

  n = ncommon;
  writerottedItem = XmCreatePushButtonGadget(writeMenu,"Rotated Parts",args,n);
  XtAddCallback(writerottedItem,XmNactivateCallback
                 ,(XtCallbackProc)writerotted_CB, NULL);
  XtManageChild(writerottedItem);
 
  n = ncommon;
  writeviewItem = XmCreatePushButtonGadget(writeMenu,"Current View",args,n);
  XtAddCallback(writeviewItem,XmNactivateCallback
                                 ,(XtCallbackProc)writeview_CB, NULL);
  XtManageChild(writeviewItem);
  n = ncommon;
  writefocusItem = XmCreatePushButtonGadget(writeMenu,"Picked Point coord.",args,n);
  XtAddCallback(writefocusItem,XmNactivateCallback
                                  ,(XtCallbackProc)writefocus_CB,NULL);
  XtManageChild(writefocusItem);

  n = ncommon;
  writeQAItem = XmCreatePushButtonGadget(writeMenu,"Questions & Ans",args,n);
  XtAddCallback(writeQAItem,XmNactivateCallback
                               ,(XtCallbackProc)writeQA_CB,NULL);
  XtManageChild(writeQAItem);

  n = ncommon;
  writeR3DItem = XmCreatePushButtonGadget(writeMenu,"2D rendering file",args,n);
  XtAddCallback(writeR3DItem,XmNactivateCallback
                               ,(XtCallbackProc)writeR3D_CB,NULL);
  XtManageChild(writeR3DItem);

  n = ncommon;
  writeptIDItem = XmCreatePushButtonGadget(writeMenu,"pointID to file",args,n);
  XtAddCallback(writeptIDItem,XmNactivateCallback
                               ,(XtCallbackProc)writeptID_CB,NULL);
  XtManageChild(writeptIDItem);

/*    FileMenu sub: WriteMenu  _______________*/

  n = ncommon;
  writePostScriptItem =
     XmCreatePushButtonGadget(fileMenu,"Write PostScript File...",args,n);
  XtAddCallback(writePostScriptItem,XmNactivateCallback
                ,(XtCallbackProc)writePostScript_CB,NULL);
  XtManageChild(writePostScriptItem);

  n = ncommon;
  quitItem = XmCreatePushButtonGadget(fileMenu,"Quit",args,n);
  XtAddCallback(quitItem,XmNactivateCallback,(XtCallbackProc)quit_CB, NULL);
  XtManageChild(quitItem);
/*FILEMENU______________________________________________________*/

/*EDITMENU*******************************************************/
/*create a Pulldown Menu Pane  */
  n = ncommon;
  editMenu = XmCreatePulldownMenu(menuBar, "Edit", args, n);
/*create CascadeButton for this Menu Pane*/
  n = ncommon;
  XtSetArg(args[n], XmNsubMenuId, editMenu); n++;
  editButton = XmCreateCascadeButton(menuBar, "Edit", args, n);
  XtManageChild(editButton);
  
  n = ncommon;  /*Toggle buttons all have same args */
  XtSetArg(args[n], XmNindicatorOn, True); n++;
  XtSetArg(args[n], XmNfillOnSelect, True); n++;
  XtSetArg(args[n], XmNselectColor, (Pixel)1); n++;
  drawlineItem = XmCreateToggleButtonGadget(editMenu,"Draw New",args,n);
  XtAddCallback(drawlineItem,XmNvalueChangedCallback
                                     ,(XtCallbackProc)drawline_CB,NULL);
  XtManageChild(drawlineItem);

  n = ncommon;  /*971129*/
  drawsetupItem = XmCreatePushButtonGadget(editMenu,"Draw New Setup...",args,n);
  XtAddCallback(drawsetupItem,XmNactivateCallback
                               ,(XtCallbackProc)drawsetup_CB, NULL);
  XtManageChild(drawsetupItem);

  n = ncommon;
  editviewItem = XmCreatePushButtonGadget(editMenu,"Keep Current View...",args,n);
  XtAddCallback(editviewItem,XmNactivateCallback
                               ,(XtCallbackProc)editview_CB, NULL);
  XtManageChild(editviewItem);

  colorshowItem = XmCreateToggleButtonGadget(editMenu,"Change Color",args,n);
  XtAddCallback(colorshowItem,XmNvalueChangedCallback
                             ,(XtCallbackProc)pickcolor_CB,NULL);
  XtManageChild(colorshowItem);

  pruneItem = XmCreateToggleButtonGadget(editMenu,"Prune",args,n);
  XtAddCallback(pruneItem,XmNvalueChangedCallback 
                                          ,(XtCallbackProc)prune_CB, NULL);
  XtManageChild(pruneItem);

  superpickItem = XmCreateToggleButtonGadget(editMenu,"Superpick",args,n);
  XtAddCallback(superpickItem,XmNvalueChangedCallback
                             ,(XtCallbackProc)superpick_CB, NULL);
  XtManageChild(superpickItem);
  
  pickshowItem = XmCreateToggleButtonGadget(editMenu,"Show Object Properties",args,n);
  XtAddCallback(pickshowItem,XmNvalueChangedCallback
                                       ,(XtCallbackProc)pickshow_CB, NULL);
  XtManageChild(pickshowItem);

  enableTEItem = XmCreateToggleButtonGadget(editMenu,"Text Editable",args,n);
  XtAddCallback(enableTEItem,XmNvalueChangedCallback
                                       ,(XtCallbackProc)enableTE_CB, NULL);
  XtManageChild(enableTEItem);

  tablecutItem=XmCreateToggleButtonGadget(editMenu,"Table Cell: Delete",args,n);
  XtAddCallback(tablecutItem,XmNvalueChangedCallback
                                       ,(XtCallbackProc)tablecut_CB, NULL);
  XtManageChild(tablecutItem);

  tablerestoreItem = XmCreateToggleButtonGadget(editMenu,"   Restore",args,n);
  XtAddCallback(tablerestoreItem,XmNvalueChangedCallback
                                   ,(XtCallbackProc)tablerestore_CB, NULL);
  XtManageChild(tablerestoreItem);

  tablepreinsertItem=XmCreateToggleButtonGadget(editMenu," Insert before",args,n);
  XtAddCallback(tablepreinsertItem,XmNvalueChangedCallback
                                 ,(XtCallbackProc)tablepreinsert_CB, NULL);
  XtManageChild(tablepreinsertItem);

  tablepostinsertItem=XmCreateToggleButtonGadget(editMenu," Insert after",args,n);
  XtAddCallback(tablepostinsertItem,XmNvalueChangedCallback
                                ,(XtCallbackProc)tablepostinsert_CB, NULL);
  XtManageChild(tablepostinsertItem);

  tablerebuildItem = XmCreateToggleButtonGadget(editMenu,"Table rebuild",args,n);
  XtAddCallback(tablerebuildItem,XmNvalueChangedCallback
                                   ,(XtCallbackProc)tablerebuild_CB, NULL);
  XtManageChild(tablerebuildItem);

  tablecolorItem=XmCreateToggleButtonGadget(editMenu,"Table change color",args,n);
  XtAddCallback(tablecolorItem,XmNvalueChangedCallback
                                    ,(XtCallbackProc)tablecolor_CB, NULL);
  XtManageChild(tablecolorItem);

/*EDITMENU_______________________________________________________*/

/*KINEMENU***********************************************************/
/*create a Pulldown Menu Pane  */
  n = ncommon;
  kineMenu = XmCreatePulldownMenu(menuBar, "KINEMAGE", args, n);
/*create CascadeButton for this Menu Pane*/
  n = ncommon;
  XtSetArg(args[n], XmNsubMenuId, kineMenu); n++;
  kineButton = XmCreateCascadeButton(menuBar, "KINEMAGE", args, n);
  XtManageChild(kineButton);
  n = ncommon;
  nextItem = XmCreatePushButtonGadget(kineMenu,"Next",args,n);
  XtAddCallback(nextItem,XmNactivateCallback,(XtCallbackProc)next_CB, NULL); 
  XtManageChild(nextItem);
  n = ncommon;
  chooseItem = XmCreatePushButtonGadget(kineMenu,"Choose...",args,n);
  XtAddCallback(chooseItem,XmNactivateCallback,(XtCallbackProc)choose_CB, NULL);
  XtManageChild(chooseItem);
/*KINEMENU__________________________________________________________*/

/*OPTIMENU******Display**********************************************/ 
/*create a Pulldown Menu Pane */
  n = ncommon;
  optiMenu = XmCreatePulldownMenu(menuBar, "Display", args, n);
/*create a CascadeButton for this Menu Pane*/
  n = ncommon;
  XtSetArg(args[n], XmNsubMenuId, optiMenu); n++;
  optiButton = XmCreateCascadeButton(menuBar, "Display", args, n);
  XtManageChild(optiButton);

  n = ncommon;  /*Toggle buttons all have same args */
  XtSetArg(args[n], XmNindicatorOn, True); n++;
  XtSetArg(args[n], XmNfillOnSelect, True); n++;
  XtSetArg(args[n], XmNselectColor, (Pixel)1); n++;
  
  multiwidthItem = XmCreateToggleButtonGadget(optiMenu,"Multi-Width",args,n);
  XtAddCallback(multiwidthItem,XmNvalueChangedCallback
                                  ,(XtCallbackProc)multiwidth_CB, NULL); 
  XtManageChild(multiwidthItem);

  widthItem = XmCreateToggleButtonGadget(optiMenu,"One Width",args,n);
  XtAddCallback(widthItem,XmNvalueChangedCallback
                                  ,(XtCallbackProc)width_CB, NULL); 
  XtManageChild(widthItem);

  thinItem = XmCreateToggleButtonGadget(optiMenu,"Thin Line 't'",args,n);
  XtAddCallback(thinItem,XmNvalueChangedCallback,(XtCallbackProc)thin_CB, NULL);
  XtManageChild(thinItem);
  
  perspecItem = XmCreateToggleButtonGadget(optiMenu,"Perspective 'p'",args,n);
  XtAddCallback(perspecItem,XmNvalueChangedCallback
                                    ,(XtCallbackProc)perspec_CB, NULL); 
  XtManageChild(perspecItem);

  stereoItem = XmCreateToggleButtonGadget(optiMenu,"Stereo On 's','c'",args,n);
  XtAddCallback(stereoItem, XmNvalueChangedCallback
                                    ,(XtCallbackProc)stereo_CB, NULL); 
  XtManageChild(stereoItem);
  compareItem = XmCreateToggleButtonGadget(optiMenu,"Compare On",args,n);
  XtAddCallback(compareItem, XmNvalueChangedCallback
                                     ,(XtCallbackProc)compare_CB, NULL); 
  XtManageChild(compareItem);

  n = ncommon;
  sterangItem = XmCreatePushButtonGadget(optiMenu,"Viewing Params...",args,n);
  XtAddCallback(sterangItem, XmNactivateCallback
                                    ,(XtCallbackProc)sterang_CB, NULL);
  XtManageChild(sterangItem);

  n = ncommon;  /*Toggle buttons all have same args */
  XtSetArg(args[n], XmNindicatorOn, True); n++;
  XtSetArg(args[n], XmNfillOnSelect, True); n++;
  XtSetArg(args[n], XmNselectColor, (Pixel)1); n++;

  listcolorItem = 
    XmCreateToggleButtonGadget(optiMenu,"List Color Dominant 'l'",args,n);
  XtAddCallback(listcolorItem, XmNvalueChangedCallback
                                     ,(XtCallbackProc)listcolor_CB, NULL); 
  XtManageChild(listcolorItem);
  
  lensItem = 
    XmCreateToggleButtonGadget(optiMenu,"Lens at Center 'e'",args,n);
  XtAddCallback(lensItem, XmNvalueChangedCallback
                                    ,(XtCallbackProc)lens_CB, NULL);
  XtManageChild(lensItem);

  n = ncommon;
  detailItem = XmCreatePushButtonGadget(optiMenu,"Detail Level...",args,n);
  XtAddCallback(detailItem, XmNactivateCallback
                                    ,(XtCallbackProc)detail_CB, NULL);
  XtManageChild(detailItem);
  
  n = ncommon; /* toggle buttons all have the same args*/
  XtSetArg(args[n], XmNindicatorOn, True); n++;
  XtSetArg(args[n], XmNfillOnSelect, True); n++;
  XtSetArg(args[n], XmNselectColor, (Pixel)1); n++;
  whtbkgItem = XmCreateToggleButtonGadget(optiMenu,"White Background",args,n);
  XtAddCallback(whtbkgItem,XmNvalueChangedCallback
                                    ,(XtCallbackProc)whtbkg_CB, NULL); 
  XtManageChild(whtbkgItem);
  B_WItem = XmCreateToggleButtonGadget(optiMenu,"Black&White",args,n);
  XtAddCallback(B_WItem,XmNvalueChangedCallback,(XtCallbackProc)B_W_CB, NULL); 
  XtManageChild(B_WItem);

  n = ncommon;
  GFontItem = XmCreatePushButtonGadget(optiMenu,"Font Sizes...",args,n);
  XtAddCallback(GFontItem, XmNactivateCallback,(XtCallbackProc)GFont_CB, NULL);
  XtManageChild(GFontItem);
 
  n = ncommon;
  XtSetArg(args[n], XmNindicatorOn, True); n++;
  XtSetArg(args[n], XmNfillOnSelect, True); n++;
  XtSetArg(args[n], XmNselectColor, (Pixel)1); n++;
  strokedfontItem = XmCreateToggleButtonGadget(optiMenu,"stroked font",args,n);
  XtAddCallback(strokedfontItem, XmNvalueChangedCallback
                       ,(XtCallbackProc)strokedfont_CB, NULL);
  XtManageChild(strokedfontItem);

  n = ncommon; /* toggle buttons all have the same args*/
  XtSetArg(args[n], XmNindicatorOn, True); n++;
  XtSetArg(args[n], XmNfillOnSelect, True); n++;
  XtSetArg(args[n], XmNselectColor, (Pixel)1); n++;
  flatItem=XmCreateToggleButtonGadget(optiMenu,"Flatland XY Scroll 'f'",args,n);
  XtAddCallback(flatItem,XmNvalueChangedCallback
                                   ,(XtCallbackProc)flat_CB,NULL);
  XtManageChild(flatItem);
 
  n = ncommon; /* toggle buttons all have the same args*/
  XtSetArg(args[n], XmNindicatorOn, True); n++;
  XtSetArg(args[n], XmNfillOnSelect, True); n++;
  XtSetArg(args[n], XmNselectColor, (Pixel)1); n++;
  horizItem=XmCreateToggleButtonGadget(optiMenu,"horizontal around Y rotation 'h'",args,n);
  XtAddCallback(horizItem,XmNvalueChangedCallback
                                   ,(XtCallbackProc)horizon_CB,NULL);
  XtManageChild(horizItem);
  
  n = ncommon; /* toggle buttons all have the same args*/
  XtSetArg(args[n], XmNindicatorOn, True); n++;
  XtSetArg(args[n], XmNfillOnSelect, True); n++;
  XtSetArg(args[n], XmNselectColor, (Pixel)1); n++;
  plotonlyItem = XmCreateToggleButtonGadget(optiMenu,"Kaleidoscope 'k'",args,n);
  XtAddCallback(plotonlyItem,XmNvalueChangedCallback
                                       ,(XtCallbackProc)plotonly_CB,NULL);
  XtManageChild(plotonlyItem);

/*OPTIMENU_____Display_______________________________________________*/

/*VIEWMENU************************************************************/

/*create a Pulldown Menu Pane */
  n = ncommon;
  viewMenu = XmCreatePulldownMenu(menuBar, "VIEWS", args, n);
/*create menu CascadeButton for this Menu Pane*/
  n = ncommon;
  XtSetArg(args[n], XmNsubMenuId, viewMenu); n++;
  viewButton = XmCreateCascadeButton(menuBar, "VIEWS", args, n);
  XtManageChild(viewButton);
  
  undopickctrItem = XmCreateToggleButtonGadget(viewMenu,"Undo Pickcenter"
                                               ,args,n);
  XtAddCallback(undopickctrItem, XmNvalueChangedCallback
                                     ,(XtCallbackProc)undopickctr_CB, NULL); 
  XtManageChild(undopickctrItem);


  n = ncommon; /*10 view Toggle buttons: all have same args*/
  XtSetArg(args[n], XmNindicatorOn, True); n++;
  XtSetArg(args[n], XmNfillOnSelect, True); n++;
  XtSetArg(args[n], XmNselectColor, (Pixel)1); n++;
  
  reset1Item = XmCreateToggleButtonGadget(viewMenu,"View1",args,n);
  XtAddCallback(reset1Item,XmNvalueChangedCallback
                                 ,(XtCallbackProc)view1_CB, NULL); 
  XtManageChild(reset1Item);
  
  reset2Item = XmCreateToggleButtonGadget(viewMenu,"View2",args,n);
  XtAddCallback(reset2Item, XmNvalueChangedCallback
                                  ,(XtCallbackProc)view2_CB, NULL); 
  XtManageChild(reset2Item);
  reset3Item = XmCreateToggleButtonGadget(viewMenu,"View3",args,n);
  XtAddCallback(reset3Item, XmNvalueChangedCallback
                                   ,(XtCallbackProc)view3_CB, NULL); 
  XtManageChild(reset3Item);
  reset4Item = XmCreateToggleButtonGadget(viewMenu,"View4",args,n);
  XtAddCallback(reset4Item, XmNvalueChangedCallback
                                   ,(XtCallbackProc)view4_CB, NULL); 
  XtManageChild(reset4Item);
  reset5Item = XmCreateToggleButtonGadget(viewMenu,"View5",args,n);
  XtAddCallback(reset5Item, XmNvalueChangedCallback
                                   ,(XtCallbackProc)view5_CB, NULL); 
  XtManageChild(reset5Item);
  reset6Item = XmCreateToggleButtonGadget(viewMenu,"View6",args,n);
  XtAddCallback(reset6Item, XmNvalueChangedCallback
                                   ,(XtCallbackProc)view6_CB, NULL); 
  XtManageChild(reset6Item);
  reset7Item = XmCreateToggleButtonGadget(viewMenu,"View7",args,n);
  XtAddCallback(reset7Item, XmNvalueChangedCallback
                                   ,(XtCallbackProc)view7_CB, NULL); 
  XtManageChild(reset7Item);
  reset8Item = XmCreateToggleButtonGadget(viewMenu,"View8",args,n);
  XtAddCallback(reset8Item, XmNvalueChangedCallback
                                   ,(XtCallbackProc)view8_CB, NULL); 
  XtManageChild(reset8Item);
  reset9Item = XmCreateToggleButtonGadget(viewMenu,"View9",args,n);
  XtAddCallback(reset9Item, XmNvalueChangedCallback
                                   ,(XtCallbackProc)view9_CB, NULL); 
  XtManageChild(reset9Item);
  reset10Item = XmCreateToggleButtonGadget(viewMenu,"View10",args,n);
  XtAddCallback(reset10Item, XmNvalueChangedCallback
                                   ,(XtCallbackProc)view10_CB, NULL); 
  XtManageChild(reset10Item);
  reset11Item = XmCreateToggleButtonGadget(viewMenu,"View11",args,n);
  XtAddCallback(reset11Item,XmNvalueChangedCallback
                                 ,(XtCallbackProc)view11_CB, NULL); 
  XtManageChild(reset11Item);
  reset12Item = XmCreateToggleButtonGadget(viewMenu,"View12",args,n);
  XtAddCallback(reset12Item, XmNvalueChangedCallback
                                  ,(XtCallbackProc)view12_CB, NULL); 
  XtManageChild(reset12Item);
  reset13Item = XmCreateToggleButtonGadget(viewMenu,"View13",args,n);
  XtAddCallback(reset13Item, XmNvalueChangedCallback
                                   ,(XtCallbackProc)view13_CB, NULL); 
  XtManageChild(reset13Item);
  reset14Item = XmCreateToggleButtonGadget(viewMenu,"View14",args,n);
  XtAddCallback(reset14Item, XmNvalueChangedCallback
                                   ,(XtCallbackProc)view14_CB, NULL); 
  XtManageChild(reset14Item);
  reset15Item = XmCreateToggleButtonGadget(viewMenu,"View15",args,n);
  XtAddCallback(reset15Item, XmNvalueChangedCallback
                                   ,(XtCallbackProc)view15_CB, NULL); 
  XtManageChild(reset15Item);
  reset16Item = XmCreateToggleButtonGadget(viewMenu,"View16",args,n);
  XtAddCallback(reset16Item, XmNvalueChangedCallback
                                   ,(XtCallbackProc)view16_CB, NULL); 
  XtManageChild(reset16Item);
  reset17Item = XmCreateToggleButtonGadget(viewMenu,"View17",args,n);
  XtAddCallback(reset17Item, XmNvalueChangedCallback
                                   ,(XtCallbackProc)view17_CB, NULL); 
  XtManageChild(reset17Item);
  reset18Item = XmCreateToggleButtonGadget(viewMenu,"View18",args,n);
  XtAddCallback(reset18Item, XmNvalueChangedCallback
                                   ,(XtCallbackProc)view18_CB, NULL); 
  XtManageChild(reset18Item);
  reset19Item = XmCreateToggleButtonGadget(viewMenu,"View19",args,n);
  XtAddCallback(reset19Item, XmNvalueChangedCallback
                                   ,(XtCallbackProc)view19_CB, NULL); 
  XtManageChild(reset19Item);
  reset20Item = XmCreateToggleButtonGadget(viewMenu,"View20",args,n);
  XtAddCallback(reset20Item, XmNvalueChangedCallback
                                   ,(XtCallbackProc)view20_CB, NULL); 
  XtManageChild(reset20Item);
  reset21Item = XmCreateToggleButtonGadget(viewMenu,"View21",args,n);
  XtAddCallback(reset21Item,XmNvalueChangedCallback
                                 ,(XtCallbackProc)view21_CB, NULL); 
  XtManageChild(reset21Item);
  reset22Item = XmCreateToggleButtonGadget(viewMenu,"View22",args,n);
  XtAddCallback(reset22Item, XmNvalueChangedCallback
                                  ,(XtCallbackProc)view22_CB, NULL); 
  XtManageChild(reset22Item);
  reset23Item = XmCreateToggleButtonGadget(viewMenu,"View23",args,n);
  XtAddCallback(reset23Item, XmNvalueChangedCallback
                                   ,(XtCallbackProc)view23_CB, NULL); 
  XtManageChild(reset23Item);
  reset24Item = XmCreateToggleButtonGadget(viewMenu,"View24",args,n);
  XtAddCallback(reset24Item, XmNvalueChangedCallback
                                   ,(XtCallbackProc)view24_CB, NULL); 
  XtManageChild(reset24Item);
  reset25Item = XmCreateToggleButtonGadget(viewMenu,"View25",args,n);
  XtAddCallback(reset25Item, XmNvalueChangedCallback
                                   ,(XtCallbackProc)view25_CB, NULL); 
  XtManageChild(reset25Item);
  reset26Item = XmCreateToggleButtonGadget(viewMenu,"View26",args,n);
  XtAddCallback(reset26Item, XmNvalueChangedCallback
                                   ,(XtCallbackProc)view26_CB, NULL); 
  XtManageChild(reset26Item);
  reset27Item = XmCreateToggleButtonGadget(viewMenu,"View27",args,n);
  XtAddCallback(reset27Item, XmNvalueChangedCallback
                                   ,(XtCallbackProc)view27_CB, NULL); 
  XtManageChild(reset27Item);
  reset28Item = XmCreateToggleButtonGadget(viewMenu,"View28",args,n);
  XtAddCallback(reset28Item, XmNvalueChangedCallback
                                   ,(XtCallbackProc)view28_CB, NULL); 
  XtManageChild(reset28Item);
  reset29Item = XmCreateToggleButtonGadget(viewMenu,"View29",args,n);
  XtAddCallback(reset29Item,XmNvalueChangedCallback
                                    ,(XtCallbackProc)view29_CB, NULL); 
  XtManageChild(reset29Item);
  

  /*    VIEWSMENU: sub  EXTRAMENU***extra views*****/
/*create Pulldown Menu Pane for ExtraViews Menu under Views Menu*/
  n = ncommon;
  extraviewMenu = XmCreatePulldownMenu(viewMenu, "extra Menu dummy", args, n);
  /*do not managechild here, popup level is not complete*/
/*create menu CascadeButton for this Menu Pane*/
  n = ncommon;
  XtSetArg(args[n], XmNsubMenuId, extraviewMenu); n++;
  extraviewsButton = XmCreateCascadeButton(viewMenu,"extra views",args,n);
  XtManageChild(extraviewsButton);

  

  n = ncommon; /*10 view Toggle buttons: all have same args*/
  XtSetArg(args[n], XmNindicatorOn, True); n++;
  XtSetArg(args[n], XmNfillOnSelect, True); n++;
  XtSetArg(args[n], XmNselectColor, (Pixel)1); n++;
  
  reset30Item = XmCreateToggleButtonGadget(extraviewMenu,"View30",args,n);
  XtAddCallback(reset30Item, XmNvalueChangedCallback
                                    ,(XtCallbackProc)view30_CB, NULL); 
  XtManageChild(reset30Item);
  reset31Item = XmCreateToggleButtonGadget(extraviewMenu,"View31",args,n);
  XtAddCallback(reset31Item,XmNvalueChangedCallback
                                    ,(XtCallbackProc)view31_CB, NULL); 
  XtManageChild(reset31Item);
  
  reset32Item = XmCreateToggleButtonGadget(extraviewMenu,"View32",args,n);
  XtAddCallback(reset32Item, XmNvalueChangedCallback
                                    ,(XtCallbackProc)view32_CB, NULL); 
  XtManageChild(reset32Item);
  reset33Item = XmCreateToggleButtonGadget(extraviewMenu,"View33",args,n);
  XtAddCallback(reset33Item, XmNvalueChangedCallback
                                    ,(XtCallbackProc)view33_CB, NULL); 
  XtManageChild(reset33Item);
  reset34Item = XmCreateToggleButtonGadget(extraviewMenu,"View34",args,n);
  XtAddCallback(reset34Item, XmNvalueChangedCallback
                                    ,(XtCallbackProc)view34_CB, NULL); 
  XtManageChild(reset34Item);
  reset35Item = XmCreateToggleButtonGadget(extraviewMenu,"View35",args,n);
  XtAddCallback(reset35Item, XmNvalueChangedCallback
                                    ,(XtCallbackProc)view35_CB, NULL); 
  XtManageChild(reset35Item);
  reset36Item = XmCreateToggleButtonGadget(extraviewMenu,"View36",args,n);
  XtAddCallback(reset36Item, XmNvalueChangedCallback
                                    ,(XtCallbackProc)view36_CB, NULL); 
  XtManageChild(reset36Item);
  reset37Item = XmCreateToggleButtonGadget(extraviewMenu,"View37",args,n);
  XtAddCallback(reset37Item, XmNvalueChangedCallback
                                    ,(XtCallbackProc)view37_CB, NULL); 
  XtManageChild(reset37Item);
  reset38Item = XmCreateToggleButtonGadget(extraviewMenu,"View38",args,n);
  XtAddCallback(reset38Item, XmNvalueChangedCallback
                                    ,(XtCallbackProc)view38_CB, NULL); 
  XtManageChild(reset38Item);
  reset39Item = XmCreateToggleButtonGadget(extraviewMenu,"View39",args,n);
  XtAddCallback(reset39Item, XmNvalueChangedCallback
                                    ,(XtCallbackProc)view39_CB, NULL); 
  XtManageChild(reset39Item);
  reset40Item = XmCreateToggleButtonGadget(extraviewMenu,"View40",args,n);
  XtAddCallback(reset40Item, XmNvalueChangedCallback
                                    ,(XtCallbackProc)view40_CB, NULL); 
  XtManageChild(reset40Item);
  reset41Item = XmCreateToggleButtonGadget(extraviewMenu,"View41",args,n);
  XtAddCallback(reset41Item,XmNvalueChangedCallback
                                    ,(XtCallbackProc)view41_CB, NULL); 
  XtManageChild(reset41Item);
  reset42Item = XmCreateToggleButtonGadget(extraviewMenu,"View42",args,n);
  XtAddCallback(reset42Item, XmNvalueChangedCallback
                                    ,(XtCallbackProc)view42_CB, NULL); 
  XtManageChild(reset42Item);
  reset43Item = XmCreateToggleButtonGadget(extraviewMenu,"View43",args,n);
  XtAddCallback(reset43Item, XmNvalueChangedCallback
                                    ,(XtCallbackProc)view43_CB, NULL); 
  XtManageChild(reset43Item);
  reset44Item = XmCreateToggleButtonGadget(extraviewMenu,"View44",args,n);
  XtAddCallback(reset44Item, XmNvalueChangedCallback
                                    ,(XtCallbackProc)view44_CB, NULL); 
  XtManageChild(reset44Item);
  reset45Item = XmCreateToggleButtonGadget(extraviewMenu,"View45",args,n);
  XtAddCallback(reset45Item, XmNvalueChangedCallback
                                    ,(XtCallbackProc)view45_CB, NULL); 
  XtManageChild(reset45Item);
  reset46Item = XmCreateToggleButtonGadget(extraviewMenu,"View46",args,n);
  XtAddCallback(reset46Item, XmNvalueChangedCallback
                                    ,(XtCallbackProc)view46_CB, NULL); 
  XtManageChild(reset46Item);
  reset47Item = XmCreateToggleButtonGadget(extraviewMenu,"View47",args,n);
  XtAddCallback(reset47Item, XmNvalueChangedCallback
                                    ,(XtCallbackProc)view47_CB, NULL); 
  XtManageChild(reset47Item);
  reset48Item = XmCreateToggleButtonGadget(extraviewMenu,"View48",args,n);
  XtAddCallback(reset48Item, XmNvalueChangedCallback
                                    ,(XtCallbackProc)view48_CB, NULL); 
  XtManageChild(reset48Item);
  reset49Item = XmCreateToggleButtonGadget(extraviewMenu,"View49",args,n);
  XtAddCallback(reset49Item, XmNvalueChangedCallback
                                    ,(XtCallbackProc)view49_CB, NULL); 
  XtManageChild(reset49Item);
  reset50Item = XmCreateToggleButtonGadget(extraviewMenu,"View50",args,n);
  XtAddCallback(reset50Item, XmNvalueChangedCallback
                                   ,(XtCallbackProc)view50_CB, NULL); 
  XtManageChild(reset50Item);
  reset51Item = XmCreateToggleButtonGadget(extraviewMenu,"View51",args,n);
  XtAddCallback(reset51Item,XmNvalueChangedCallback
                                    ,(XtCallbackProc)view51_CB, NULL); 
  XtManageChild(reset51Item);
  reset52Item = XmCreateToggleButtonGadget(extraviewMenu,"View52",args,n);
  XtAddCallback(reset52Item, XmNvalueChangedCallback
                                    ,(XtCallbackProc)view52_CB, NULL); 
  XtManageChild(reset52Item);
  reset53Item = XmCreateToggleButtonGadget(extraviewMenu,"View53",args,n);
  XtAddCallback(reset53Item, XmNvalueChangedCallback
                                    ,(XtCallbackProc)view53_CB, NULL); 
  XtManageChild(reset53Item);
  reset54Item = XmCreateToggleButtonGadget(extraviewMenu,"View54",args,n);
  XtAddCallback(reset54Item, XmNvalueChangedCallback
                                    ,(XtCallbackProc)view54_CB, NULL); 
  XtManageChild(reset54Item);
  reset55Item = XmCreateToggleButtonGadget(extraviewMenu,"View55",args,n);
  XtAddCallback(reset55Item, XmNvalueChangedCallback
                                    ,(XtCallbackProc)view55_CB, NULL); 
  XtManageChild(reset55Item);
  reset56Item = XmCreateToggleButtonGadget(extraviewMenu,"View56",args,n);
  XtAddCallback(reset56Item, XmNvalueChangedCallback
                                    ,(XtCallbackProc)view56_CB, NULL); 
  XtManageChild(reset56Item);
  reset57Item = XmCreateToggleButtonGadget(extraviewMenu,"View57",args,n);
  XtAddCallback(reset57Item, XmNvalueChangedCallback
                                    ,(XtCallbackProc)view57_CB, NULL); 
  XtManageChild(reset57Item);
  reset58Item = XmCreateToggleButtonGadget(extraviewMenu,"View58",args,n);
  XtAddCallback(reset58Item, XmNvalueChangedCallback
                                    ,(XtCallbackProc)view58_CB, NULL); 
  XtManageChild(reset58Item);
  reset59Item = XmCreateToggleButtonGadget(extraviewMenu,"View59",args,n);
  XtAddCallback(reset59Item, XmNvalueChangedCallback
                                    ,(XtCallbackProc)view59_CB, NULL); 
  XtManageChild(reset59Item);
  reset60Item = XmCreateToggleButtonGadget(extraviewMenu,"View60",args,n);
  XtAddCallback(reset60Item, XmNvalueChangedCallback
                                    ,(XtCallbackProc)view60_CB, NULL); 
  XtManageChild(reset60Item);



  resetRItem = XmCreateToggleButtonGadget(viewMenu,"Reader's View",args,n);
  XtAddCallback(resetRItem, XmNvalueChangedCallback
                                   ,(XtCallbackProc)viewR_CB, NULL); 
  XtManageChild(resetRItem);

  n = ncommon;
  readersviewItem=
           XmCreatePushButtonGadget(viewMenu,"Set Reader's View",args,n);
  XtAddCallback(readersviewItem,XmNactivateCallback
                 ,(XtCallbackProc)readersview_CB,NULL); 
  XtManageChild(readersviewItem);

/*VIEWMENU________________________________________________________*/

/*OTHERMENU*********Tools*******************************************/
/*create a Pulldown Menu Pane */
  n = ncommon;
  otherMenu = XmCreatePulldownMenu(menuBar, "Other", args, n);
/*create menu CascadeButton for this Menu Pane*/
  n = ncommon;
  XtSetArg(args[n], XmNsubMenuId, otherMenu); n++;
  otherButton = XmCreateCascadeButton(menuBar, "Tools", args, n);
  XtManageChild(otherButton);

  n = ncommon;
  searchItem = XmCreatePushButtonGadget(otherMenu,"Find ...",args,n);
  XtAddCallback(searchItem, XmNactivateCallback,(XtCallbackProc)search_CB,NULL);
  XtManageChild(searchItem);

  n = ncommon;
  findagainItem = XmCreatePushButtonGadget(otherMenu,"Find Again",args,n);
  XtAddCallback(findagainItem, XmNactivateCallback,(XtCallbackProc)findagain_CB,NULL);
  XtManageChild(findagainItem);
  
  n = ncommon; /* set of toggle buttons all have the same args*/
  XtSetArg(args[n], XmNindicatorOn, True); n++;
  XtSetArg(args[n], XmNfillOnSelect, True); n++;
  XtSetArg(args[n], XmNselectColor, (Pixel)1); n++;
  measureItem = XmCreateToggleButtonGadget(otherMenu,"measures",args,n);
  XtAddCallback(measureItem, XmNvalueChangedCallback
                                     ,(XtCallbackProc)measure_CB, NULL); 
  XtManageChild(measureItem);
  
  /*    OTHERMENU(Tools): sub  HELPMENU***Empowerments*****/
/*create Pulldown Menu Pane for Help Menu under Other Menu*/
  n = ncommon;
  helpMenu = XmCreatePulldownMenu(otherMenu, "Help Menu dummy", args, n);
  /*do not managechild here, popup level is not complete*/
/*create menu CascadeButton for this Menu Pane*/
  n = ncommon;
  XtSetArg(args[n], XmNsubMenuId, helpMenu); n++;
  helpButton = XmCreateCascadeButton(otherMenu, "Empowerments", args, n);
  XtManageChild(helpButton);

  n = ncommon;
  hidemeasuresItem = XmCreatePushButtonGadget(helpMenu,"Hide Measures  'm'",args,n);
  XtAddCallback(hidemeasuresItem, XmNactivateCallback,(XtCallbackProc)hidemeasures_CB,NULL);
  XtManageChild(hidemeasuresItem);

  n = ncommon;
  brotangleItem = XmCreatePushButtonGadget(helpMenu,"Restore Rotations",args,n);
  XtAddCallback(brotangleItem, XmNactivateCallback,(XtCallbackProc)brotangle_CB,NULL);
  XtManageChild(brotangleItem);

  n = ncommon;
  rot90plusItem = XmCreatePushButtonGadget(helpMenu,"Rotate 90+  'n'",args,n);
  XtAddCallback(rot90plusItem, XmNactivateCallback,(XtCallbackProc)rot90plus_CB,NULL);
  XtManageChild(rot90plusItem);

  n = ncommon;
  rot90minusItem = XmCreatePushButtonGadget(helpMenu,"Rotate 90-  'N'",args,n);
  XtAddCallback(rot90minusItem, XmNactivateCallback,(XtCallbackProc)rot90minus_CB,NULL);
  XtManageChild(rot90minusItem);

  n = ncommon;
  rot90xplusItem = XmCreatePushButtonGadget(helpMenu,"Rotate 90+ horiz",args,n);
  XtAddCallback(rot90xplusItem, XmNactivateCallback,(XtCallbackProc)rot90xplus_CB,NULL);
  XtManageChild(rot90xplusItem);

  n = ncommon;
  rot90xminusItem = XmCreatePushButtonGadget(helpMenu,"Rotate 90- horiz",args,n);
  XtAddCallback(rot90xminusItem, XmNactivateCallback,(XtCallbackProc)rot90xminus_CB,NULL);
  XtManageChild(rot90xminusItem);

  n = ncommon;
  rot90zplusItem = XmCreatePushButtonGadget(helpMenu,"Rotate 90+ screen",args,n);
  XtAddCallback(rot90zplusItem, XmNactivateCallback,(XtCallbackProc)rot90zplus_CB,NULL);
  XtManageChild(rot90zplusItem);

  n = ncommon;
  rot90zminusItem = XmCreatePushButtonGadget(helpMenu,"Rotate 90- screen",args,n);
  XtAddCallback(rot90zminusItem, XmNactivateCallback,(XtCallbackProc)rot90zminus_CB,NULL);
  XtManageChild(rot90zminusItem);

/*    OTHERMENU(Tools): sub  HELPMENU_____ Empowerments_____*/

  n = ncommon; /* toggle buttons all have the same args*/
  XtSetArg(args[n], XmNindicatorOn, True); n++;
  XtSetArg(args[n], XmNfillOnSelect, True); n++;
  XtSetArg(args[n], XmNselectColor, (Pixel)1); n++;
  remoteupdateItem = XmCreateToggleButtonGadget(otherMenu
                                                ,"Remote Update... 'u'",args,n);
  XtAddCallback(remoteupdateItem,XmNvalueChangedCallback
                                   ,(XtCallbackProc)remoteupdate_CB,NULL);
  XtManageChild(remoteupdateItem);

  n = ncommon; /* set of toggle buttons all have the same args*/
  XtSetArg(args[n], XmNindicatorOn, True); n++;
  XtSetArg(args[n], XmNfillOnSelect, True); n++;
  XtSetArg(args[n], XmNselectColor, (Pixel)1); n++;
  xyzpointItem = XmCreateToggleButtonGadget(otherMenu,"XYZ point",args,n);
  XtAddCallback(xyzpointItem,XmNvalueChangedCallback
                                     ,(XtCallbackProc)xyzpoint_CB,NULL);
  
  XtManageChild(xyzpointItem);
  gnomonItem = XmCreateToggleButtonGadget(otherMenu,"gnomon",args,n);
  XtAddCallback(gnomonItem, XmNvalueChangedCallback
                                     ,(XtCallbackProc)gnomon_CB, NULL);
  XtManageChild(gnomonItem);


  n = ncommon; /* set of toggle buttons all have the same args*/
  XtSetArg(args[n], XmNindicatorOn, True); n++;
  XtSetArg(args[n], XmNfillOnSelect, True); n++;
  XtSetArg(args[n], XmNselectColor, (Pixel)1); n++;
  rateItem = XmCreateToggleButtonGadget(otherMenu,"Rate",args,n);
  XtAddCallback(rateItem, XmNvalueChangedCallback,(XtCallbackProc)rate_CB,NULL);
  XtManageChild(rateItem);
 
  n = ncommon;
  countItem = XmCreatePushButtonGadget(otherMenu,"Count",args,n);
  XtAddCallback(countItem, XmNactivateCallback,(XtCallbackProc)count_CB, NULL);
  XtManageChild(countItem);
  
  dockingscopeItem = XmCreateToggleButtonGadget(otherMenu,"Docking Scope",args,n);
  XtAddCallback(dockingscopeItem, XmNvalueChangedCallback
                                   ,(XtCallbackProc)dockingscope_CB,NULL);
  XtManageChild(dockingscopeItem);
 

/*    OTHERMENU(Tools): sub  KLUGESMENU**************/
/*create Pulldown Menu Pane for Kluges Menu under Other Menu*/
  n = ncommon;
  kludgeMenu = XmCreatePulldownMenu(otherMenu, "Kluges Menu dummy", args, n);
  /*do not managechild here, popup level is not complete*/
/*create menu CascadeButton for this Menu Pane*/
  n = ncommon;
  XtSetArg(args[n], XmNsubMenuId, kludgeMenu); n++;
  kludgeButton = XmCreateCascadeButton(otherMenu, "Kludges", args, n);
  XtManageChild(kludgeButton);

  n = ncommon; /* set of toggle buttons all have the same args*/
  XtSetArg(args[n], XmNindicatorOn, True); n++;
  XtSetArg(args[n], XmNfillOnSelect, True); n++;
  XtSetArg(args[n], XmNselectColor, (Pixel)1); n++;

  formattestItem = 
     XmCreateToggleButtonGadget(kludgeMenu,"Test Kin Format",args,n);
  XtAddCallback(formattestItem, XmNvalueChangedCallback
                              ,(XtCallbackProc)formattest_CB, NULL);
  XtManageChild(formattestItem);

  testItem = XmCreateToggleButtonGadget(kludgeMenu,"Debug test",args,n);
  XtAddCallback(testItem, XmNvalueChangedCallback,(XtCallbackProc)test_CB,NULL);
  XtManageChild(testItem);

  cursorchoiceItem =XmCreatePushButtonGadget(kludgeMenu,"Cursor Choice",args,n);
  XtAddCallback(cursorchoiceItem,XmNactivateCallback
                                   ,(XtCallbackProc)cursorchoice_CB,NULL);
  XtManageChild(cursorchoiceItem);

  pickmarkerItem = XmCreateToggleButtonGadget(kludgeMenu,"Pick Marker",args,n);
  XtAddCallback(pickmarkerItem, XmNvalueChangedCallback
                                   ,(XtCallbackProc)pickmarker_CB,NULL);
  XtManageChild(pickmarkerItem);
  visibleoutItem = XmCreateToggleButtonGadget(kludgeMenu,"output only visible",args,n);
  XtAddCallback(visibleoutItem, XmNvalueChangedCallback
                                   ,(XtCallbackProc)visibleout_CB,NULL);
  XtManageChild(visibleoutItem);
/*    OTHERMENU: sub  KLUGESMENU_____________*/
/*OTHERMENU____________________________________________________________*/

/*WINDMENU******************Help*********************************/
/*create a Pulldown Menu Pane  */
  n = ncommon;
  windMenu = XmCreatePulldownMenu(menuBar, "Windows", args, n);
/*create CascadeButton for this Menu Pane*/
  n = ncommon;
  XtSetArg(args[n], XmNsubMenuId, windMenu); n++;
  windButton = XmCreateCascadeButton(menuBar, "Help Mage", args, n);
  XtManageChild(windButton);
  
  n = ncommon;
  secretItem = XmCreatePushButtonGadget(windMenu,"Keyboard Shortcuts",args,n);
  XtAddCallback(secretItem, XmNactivateCallback,(XtCallbackProc)secret_CB,NULL);
  XtManageChild(secretItem);
  
  
  n = ncommon;
  showtextItem = XmCreatePushButtonGadget(windMenu,"Show text",args,n);
  XtAddCallback(showtextItem,XmNactivateCallback
                                   ,(XtCallbackProc)showtext_CB, NULL);
  XtManageChild(showtextItem);
  n = ncommon;
  showcaptionItem = XmCreatePushButtonGadget(windMenu,"Show caption",args,n);
  XtAddCallback(showcaptionItem,XmNactivateCallback
                               ,(XtCallbackProc)showcaption_CB, NULL);
  XtManageChild(showcaptionItem);
  n = ncommon;
  showgraphicsItem = XmCreatePushButtonGadget(windMenu,"Show graphics",args,n);
  XtAddCallback(showgraphicsItem,XmNactivateCallback
                      ,(XtCallbackProc)showgraphics_CB, NULL);
  XtManageChild(showgraphicsItem);
   n = ncommon;
  showtableItem = XmCreatePushButtonGadget(windMenu,"Show table",args,n);
  XtAddCallback(showtableItem,XmNactivateCallback
                      ,(XtCallbackProc)showtable_CB, NULL);
  XtManageChild(showtableItem);
  n = ncommon;
  aboutItem = XmCreatePushButtonGadget(windMenu,"About MAGE Help",args,n);
  XtAddCallback(aboutItem, XmNactivateCallback,(XtCallbackProc)alert_CB, NULL); 
  XtManageChild(aboutItem);
 
  n = ncommon;
  writeaboutItem = XmCreatePushButtonGadget(windMenu,"Input Output Help",args,n);
  XtAddCallback(writeaboutItem,XmNactivateCallback
                                   ,(XtCallbackProc)writeabout_CB,NULL);
  XtManageChild(writeaboutItem);

  n = ncommon;
  editaboutItem = XmCreatePushButtonGadget(windMenu,"Edit Help",args,n);
  XtAddCallback(editaboutItem,XmNactivateCallback
                                ,(XtCallbackProc)editabout_CB, NULL);
  XtManageChild(editaboutItem);

  n = ncommon;
  optionsaboutItem = XmCreatePushButtonGadget(windMenu,"Display Help",args,n);
  XtAddCallback(optionsaboutItem,XmNactivateCallback
                ,(XtCallbackProc)optionsabout_CB,NULL); 
  XtManageChild(optionsaboutItem);

  n = ncommon;
  specialaboutItem = XmCreatePushButtonGadget(windMenu,"fonts,,,views Help",args,n);
  XtAddCallback(specialaboutItem,XmNactivateCallback
                                    ,(XtCallbackProc)specialabout_CB,NULL);
  XtManageChild(specialaboutItem);

  otheraboutItem = XmCreatePushButtonGadget(windMenu,"Tools Help",args,n);
  XtAddCallback(otheraboutItem,XmNactivateCallback
                                      ,(XtCallbackProc)otherabout_CB,NULL); 
  XtManageChild(otheraboutItem);
 
  n = ncommon;
  kludgesaboutItem = XmCreatePushButtonGadget(windMenu,"Kludges Help",args,n);
  XtAddCallback(kludgesaboutItem,XmNactivateCallback
                 ,(XtCallbackProc)kludgesabout_CB,NULL);
  XtManageChild(kludgesaboutItem);

  mousehelpItem = XmCreatePushButtonGadget(windMenu,"Mouse Help",args,n);
  XtAddCallback(mousehelpItem,XmNactivateCallback
                                    ,(XtCallbackProc)mousehelp_CB, NULL);
  XtManageChild(mousehelpItem);
  dockinghelpItem = XmCreatePushButtonGadget(windMenu,"Docking Help",args,n);
  XtAddCallback(dockinghelpItem,XmNactivateCallback
                                    ,(XtCallbackProc)dockinghelp_CB, NULL);
  XtManageChild(dockinghelpItem);

  resizehelpItem = XmCreatePushButtonGadget(windMenu,"Window sizing Help",args,n);
  XtAddCallback(resizehelpItem,XmNactivateCallback
                                     ,(XtCallbackProc)resizehelp_CB,NULL);
  XtManageChild(resizehelpItem);
  tablehelpItem = XmCreatePushButtonGadget(windMenu,"Table, Bonds Help",args,n);
  XtAddCallback(tablehelpItem,XmNactivateCallback
                                     ,(XtCallbackProc)tablehelp_CB,NULL);
  XtManageChild(tablehelpItem);

  n = ncommon;
  makehelptextItem = XmCreatePushButtonGadget(windMenu,"Help->text...",args,n);
  XtAddCallback(makehelptextItem,XmNactivateCallback
                                    ,(XtCallbackProc)makehelptext_CB,NULL);
  XtManageChild(makehelptextItem);

  n = ncommon;
  makekinemageItem = XmCreatePushButtonGadget(windMenu,"Make kinemage...",args,n);
  XtAddCallback(makekinemageItem,XmNactivateCallback
                                    ,(XtCallbackProc)makekinemage_CB,NULL);
  XtManageChild(makekinemageItem);


  
/*WINDMENU__________________________________________________________*/



/*___________________________MENU__________________________________________*/

/*create pointID and distance message place, for PEX use only*/
  n = ncommon;/* create the message place for pointID, dist, etc. */
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNheight, MHEIGHT/2); n++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNrightOffset, BWIDTH+ZWIDTH); n++;
  XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNmarginHeight, 0); n++;
  XtSetArg(args[n], XmNmarginWidth, 5); n++;
  XtSetArg(args[n], XmNeditable, False); n++;
  XtSetArg(args[n], XmNautoShowCursorPosition, False); n++;
  XtSetArg(args[n], XmNcursorPositionVisible, False); n++;
  if (buttonFont) { XtSetArg(args[n], XmNfontList, fontList); n++; }
  message = XtCreateWidget("message", xmTextWidgetClass, grafwindow, args, n);
  XtManageChild(message);

/*create drawArea directly in grafwindow as parent*/
  n = ncommon;/* create the drawing area for PEX or X11 */
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNtopOffset, MHEIGHT/2); n++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNrightOffset, BWIDTH+ZWIDTH); n++;
  XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNbottomOffset, MHEIGHT/2); n++;
  drawArea = XtCreateWidget("drawArea", xmDrawingAreaWidgetClass,
				   grafwindow, args, n);
/* add exposure and input callbacks */
  XtAddCallback(drawArea,XmNinputCallback,(XtCallbackProc)pick_CB,NULL); 
                                                        /*MUX_MAIN.c*/
  XtAddCallback(drawArea,XmNexposeCallback,(XtCallbackProc)drawArea_CB,NULL);
  XtAddCallback(drawArea, XmNresizeCallback,(XtCallbackProc)resize_CB, NULL);
                                                            /*MUX_MENU.c*/
  XtAddEventHandler(drawArea, Button1MotionMask, False, motion_handler, NULL);
  /*motion_handler and pick_CB in MUX_MAIN.c for consistency of ___MAIN stuff*/

#ifdef UNIX_PEX
/* these event handlers take care of blanking and restoring the dial labels */
  XtAddEventHandler(drawArea, EnterWindowMask, False, enter_handler, NULL);
  XtAddEventHandler(drawArea, LeaveWindowMask, False, leave_handler, NULL);
#endif /*UNIX_PEX*/

  XtManageChild(drawArea);

/*printf("drawArea created\n");*/

/*create captwindow*/
 /*create topcapt as a topLevel shell with mage topLevel as parent*/
 /*topcapt = XtCreateApplicationShell("CAPT",topLevelShellWidgetClass,NULL,0);*/
  n = ncommon;  /* window title is a regular string */
  XtSetArg(args[n], XmNtitle, "MAGE CAPTION"); n++;
  XtSetArg(args[n], XmNdeleteResponse, XmDO_NOTHING); n++; /*use quit_CB*/
  topcapt = XtCreatePopupShell(NULL,
                               topLevelShellWidgetClass,
                               topLevel,
                               args, n);

  n = ncommon;  /* window title is a regular string */
  XtSetArg(args[n], XmNtitle, "CAPTION"); n++;
  XtSetArg(args[n], XmNx, 0); n++;
  XtSetArg(args[n], XmNy, 600); n++;
  XtSetArg(args[n], XmNwidth, 600); n++;
  XtSetArg(args[n], XmNheight, 200); n++;
  XtSetArg(args[n], XmNscrollHorizontal, False); n++;
  XtSetArg(args[n], XmNscrollingPolicy, XmAUTOMATIC); n++;
  XtSetArg(args[n], XmNeditable, True); n++; /*981005*/
  XtSetArg(args[n], XmNeditMode, XmMULTI_LINE_EDIT); n++;
  XtSetArg(args[n], XmNautoShowCursorPosition, True); n++; /*981005*/
  XtSetArg(args[n], XmNcursorPositionVisible, True); n++; /*981005*/
  XtSetArg(args[n], XmNwordWrap, True); n++;
  if (buttonFont) { XtSetArg(args[n], XmNfontList, fontList); n++; }
  /* create the captwindow for MAGE CAPTION  */
  captwindow =
    XmCreateScrolledText(topcapt,"captwindow", args, n);
  XtManageChild(captwindow);
/*printf("captwindow created\n");*/

/*create textwindow*/
 /*create toptext as a topLevel shell with mage topLevel as parent*/
 /*toptext = XtCreateApplicationShell("TEXT",topLevelShellWidgetClass,NULL,0);*/
  n = ncommon;  /* window title is a regular string */
  XtSetArg(args[n], XmNtitle, "MAGE TEXT"); n++;
  XtSetArg(args[n], XmNdeleteResponse, XmDO_NOTHING); n++; /*use quit_CB*/
  toptext = XtCreatePopupShell(NULL,
                               topLevelShellWidgetClass,
                               topLevel,
                               args, n);

  n = ncommon;  /* window title is a regular string */
  XtSetArg(args[n], XmNtitle, "TEXT"); n++;
  XtSetArg(args[n], XmNx, 10); n++;
  XtSetArg(args[n], XmNy, 100); n++;
  XtSetArg(args[n], XmNwidth, 600); n++;
  XtSetArg(args[n], XmNheight, 400); n++;
  XtSetArg(args[n], XmNscrollHorizontal, False); n++;
  XtSetArg(args[n], XmNscrollingPolicy, XmAUTOMATIC); n++;
  XtSetArg(args[n], XmNeditable, True); n++; /*981005*/
  XtSetArg(args[n], XmNeditMode, XmMULTI_LINE_EDIT); n++;
  XtSetArg(args[n], XmNautoShowCursorPosition, True); n++; /*981005*/
  XtSetArg(args[n], XmNcursorPositionVisible, True); n++; /*981005*/
  XtSetArg(args[n], XmNwordWrap, True); n++;
  if (buttonFont) { XtSetArg(args[n], XmNfontList, fontList); n++; }
  /* create the textwindow for MAGE TEXT  */
  textwindow =
    XmCreateScrolledText(toptext,"textwindow", args, n);
  XtAddCallback(textwindow,XmNmotionVerifyCallback,(XtCallbackProc)textcursor_CB,NULL); 
      /*for hypertext*/
  XtManageChild(textwindow);
/*printf("textwindow created\n");*/

/*realize widget hierarchy*/
  XtPopup(topcapt,XtGrabNone);
  XtRealizeWidget(topcapt);
  XtPopup(toptext,XtGrabNone);
  XtRealizeWidget(toptext);
  XtPopup(topgraf,XtGrabNone);
  XtRealizeWidget(topgraf); /*realize last: overlays others*/

/*get the drawing area widget's window ID*/
  drawWindow = XtWindow(drawArea);

#ifndef UNIX_PEX  /*GENERIC UNIX uses offscreen buffer space */
/*create offscreenpixmap*/
   offscreen = XCreatePixmap(dpy,RootWindow(dpy,DefaultScreen(dpy))
                               ,GWIDTH,GHEIGHT,magedepth);

   gc = XCreateGC(dpy,drawWindow,0L,NULL);
   XSetFont(dpy,gc,buttonFont->fid);
   XSetForeground(dpy,gc,WhitePixel(dpy,DefaultScreen(dpy)));
   XSetBackground(dpy,gc,BlackPixel(dpy,DefaultScreen(dpy)));

   offgc = XCreateGC(dpy,offscreen,0L,NULL);
   XSetFont(dpy,offgc,buttonFont->fid);
   XSetForeground(dpy,offgc,WhitePixel(dpy,DefaultScreen(dpy)));
   XSetBackground(dpy,offgc,BlackPixel(dpy,DefaultScreen(dpy)));

/*printf("offscreen created\n");*/

/*Generic Mage: zoom, zslab, and ztrans  are done with on-screen sliders */
   creategrafzoomBar();  /*___BAR.c*/
   creategrafzclipBar(); /*___BAR.c*/
   creategrafztranBar(); /*___BAR.c*/
/*printf("Zbars created\n");*/
#endif /*of NOT UNIX_PEX*/

   AdjustMenus(); /*MAGEMENU.c*/ /*to deactivate writes until file comes in*/
/*printf("just did AdjustMenus()\n");*/

   definecursors();  /*MUXMINIT.C*/
   makecursorwait(); /*MUX_MAIN.C*/
/*finished mainsetup, set flag so mage will do beginnings() */
   Lbegin = 1;
/*printf("call beginnings()\n");*/
   beginnings(); /*MUXMINIT.C*/
}
/*___mainsetup()____________________________________________________________*/

/****definecursors()*********************************************************/
void    definecursors()
{
 XColor  body, back;
    magecursor = XCreateFontCursor(dpy,XC_top_left_arrow);
    waitcursor = XCreateFontCursor(dpy,XC_watch);
    xyrotcursor = XCreateFontCursor(dpy,XC_fleur);
    zrotcursor = XCreateFontCursor(dpy,XC_exchange);
    flatlandcursor = XCreateFontCursor(dpy,XC_cross_reverse);
    body.red = 65535;     body.green = 0;     body.blue = 0;

    back.red =     0; back.green = 65535; back.blue =     0;
    XRecolorCursor(dpy,magecursor,&body,&back);
    XRecolorCursor(dpy,waitcursor,&body,&back);
    XRecolorCursor(dpy,xyrotcursor,&body,&back);
    XRecolorCursor(dpy,zrotcursor,&body,&back);
/*printf("definecursors with bodyRGB: %d, %d, %d, backRGB: %d, %d, %d\n"*/
/*,body.red,body.green,body.blue,back.red,back.green,back.blue);*/
} 
/*___definecursors()________________________________________________________*/

/****beginnings()*************************************************************/
void    beginnings()
{
   int  launched;
    
        launched = 0;
        Lbegin = 0;
        fp = NULL;
        IOerr = 1;    /* Begins asumming no file */ 
            /* and various flags set for no legitimate file */

        launched = Lstartfile; /*gotten from ARGC in MAIN */
        makecursoractive(); /*MACMAIN*/
        setMageinitDLOGreport(); /*message*/  /*MAGEINIT.C*/
        /*initial dialog box here for always initial box*/
        /*DoMageinitDLOGreport();*/ 
        
      /*  XRaiseWindow(dpy,textwindow);*/ /* next thing is a message*/
             /* to be shown in the textWindow.  Avoids flipping to graphics */
             /* and messing with the graphics cursor choices */
        
        if( launched != 0) /* invoked by a file */
        {
            makecursorwait();  /*MUX_MAIN.C*/
            IOerr = 0; /* putative .kin file available */
            Lnewfile = 1;
            Lstartfile = 1;
            sprintf(word,"%s\n A request for a kinemage "      /*c*/
                         "file has launched MAGE.",version);
            cleartexts();      /*MUXMWIND.C*/
            inserttexts(word); /*MUXMWIND.C*/
            showthegrafwindow(); /*MUX_MENU.c*/  /*970422*/
        }
        else
        {
            makecursoractive();  /*MACMAIN.C*/
           /*initial dialog box here for no box on file launch*/
           DoMageinitDLOGreport(); 

           sprintf(word,"%s\nUse File pull-down menu above"    /*c*/ 
                        " to Open a kinemage File.",version);

            cleartexts();         /*MUXMWIND.C*/
            inserttexts(word);    /*MUXMWIND.C*/
        }

/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
        /*MAGEINIT.C  alloc storage for big arrays*//*do this before open file*/
        alloclinkarrays(); /*MAGEINIT.c*/
          /*thelink[0][1000] first indexed display point in this bin*/
          /*thelink[1][1000] last indexed display point in this bin*/
        allocdisplayarrays(0);/*it[7], it[7][MAXDRAWS], itpointptr[MAXDRAWS]*/
        allocwordcomarray(0);
          /* char  *wordcom;  pointer to array, for wordcom[MAXWORDCOM], */
          /*size = MAXWORDCOM*/ /* the comment or wordlist character array  */
        alloccomarray(0); /*ptIDs*/



        if(Lnewfile) newfile();  /*MUX_FILE.c*/
}
/*___beginnings()____________________________________________________________*/

