   /*MUX_MAIN.c*/
/*3456789_123456789_123456789_123456789_123456789_123456789_123456789_12345678*/
#define EXTERN   /* as nothing, this file has the main() */
#include "MAGE.h"   
#include "MAGELIST.h"
#include "MAGEDLOG.h"
#include "MAGEMENU.h"
#include "MAGEANGL.h"
#include "MAGETABL.h"
#include <sys/time.h>
#include <time.h>

void adjustzoom(void);

/****main()*******************************************************************/
main(int argc, char** argv)
{
  XEvent report;
/*printf("CurrentTime==%ld\n",CurrentTime);*/

  done = 0; /*master flag, set true exits program */
  mainsetup(&argc, argv); /*MUXMINIT.C*/

/*printf("returned from mainsetup()\n");*/

#ifdef UNIX_PEX
  OpenPhigs();   /*MUXPHIG.c*/
#endif /*UNIX_PEX*/

    while (!done) /* until user wants to quit... */
    {/*master event loop*/
      XtAppNextEvent(app_context,&report); /* get the next event */
#ifdef UNIX_PEX
      if (report.type < LASTEvent)
#endif
      {
          if(report.type == KeyPress||report.type == KeyRelease ) 
          {/*need both to track ShiftKey state*/
              if(!ACTIVE_DLOG && !Ltexteditable) 
              {
                  fprintf(stderr," \010");/*print space+backspace to trick SGI */
                  keypresseventhandler(&report);/*MUX_MAIN.c*/
              }
              else
              {
                  XtDispatchEvent(&report);
              }
          }
          else
          {
              XtDispatchEvent(&report);
          }
          /*NOTE:  mousedown event calls pick_CB as handler */
      }
#ifdef UNIX_PEX
      else
      {
          dospecialevent(&report);  /*MUXPHIG.c*/
      }
#endif /*UNIX_PEX*/

      
      if(Lpipeactive)
      {/*controls for input from an active pipe*/
         if(Lpipebufferloaded)
         {
            if(!Linhibiton)
            {
               GetStuffFromFile(); /*MAGEINPT*/
            }
         }
         else
         {
            readpipeintobuffer(1); /*up to #char before returning,____PIPE*/
         }
      }/*controls for input from an active pipe*/

    }/*master event loop*/
}
/*___main()_________________________________________________________________*/


/****keypresseventhandler()***************************************************/
void keypresseventhandler(XEvent* event)
{
  /*ref: Johnson&Reichard,2nd Ed,Motif,MIS Press,1993, pg 387*/
  KeySym         keysym;
  XComposeStatus compose_status;
  int            length, size=9;
  char           string[10];
  float          factor;

/*keysym:*/
#define SPACEBAR  32
#define LARROW 65361
#define RARROW 65363
#define DARROW 65364
#define UARROW 65362

#define LSHIFT 65505
#define RSHIFT 65506
#define LCONTROLKEY 65507 
#define RCONTROLKEY 65508 
#define LALTKEY 65513 
#define RALTKEY 65514 

  switch(event->type)
  {
    case KeyRelease:
      length = 
         XLookupString((XKeyEvent *)event,string,size,&keysym,&compose_status);
      if(keysym==SPACEBAR){ Lspacebar=0;}
      if(keysym==LSHIFT || keysym==RSHIFT){ Lshiftkey=0;}
      if(keysym==LCONTROLKEY || RCONTROLKEY){ Lctrlkey=0;}
      if(keysym==LALTKEY || RALTKEY){ Laltkey=0;}
/*
fprintf(stderr,"key: %s, l== %d, e->state== %u, ->code== %u, sym== %u, Lspace==%d, Lshift==%d, Lctrl==%d, Lalt==%d\n"
,string,length,((XKeyEvent *)event)->state,((XKeyEvent *)event)->keycode,keysym,Lspacebar,Lshiftkey,Lctrlkey,Laltkey);
*/
    break;

    case KeyPress:
      length = 
         XLookupString((XKeyEvent *)event,string,size,&keysym,&compose_status);
      if(keysym==SPACEBAR){ Lspacebar=1;}
      if(keysym==LSHIFT || keysym==RSHIFT){ Lshiftkey=1;}
      if(keysym==LCONTROLKEY || keysym==RCONTROLKEY){ Lctrlkey=1;}
      if(keysym==LALTKEY || keysym==RALTKEY){ Laltkey=1;}
/*
fprintf(stderr,"key: %s, l== %d, e->state== %u, ->code== %u, sym== %u, Lspace==%d, Lshift==%d, Lctrl==%d, Lalt==%d\n"
,string,length,((XKeyEvent *)event)->state,((XKeyEvent *)event)->keycode,keysym,Lspacebar,Lshiftkey,Lctrlkey,Laltkey);
*/
      /*drop through from special key-down logical state settings*/
      if(length>0 && length<=9)
      {
        string[length] = '\0';
        

        if( (string[0] == 'O') ) /* 'O'  open*/
        {
            Lshiftkey=0; /*drop no-longer-needed shift flag*/
            Lappend = 0;
            Lgetnewfile = 1; /*request to open-new-file */
            ireturnflag = 0;
            if(Lpruneactive||Ldrawactive||Lnewviewactive||Lnewstuffactive)
            {/*check dialog sets ireturnflag*/
                 DoChangeCheckDialog();
            }
            else
            {/*can go right to open-new-file stuff*/
                OpenNewFile(); /*.*/
            }
        }
        if( (string[0] == 'S') ) /* 'S'  save whole kin as a kip*/
        {
            Lshiftkey=0; /*drop no-longer-needed shift flag*/
            writeoutput(5);/*MUX_OUT.c*//*writes entire, possibly modified, kinemage*/
        }
        if( (string[0] == 'Q') ) /* 'Q'  quit*/
        {
            Lshiftkey=0; /*drop no-longer-needed shift flag*/
             trytoquitMAGE();      /*____MENU.c*/
        }
        /* q toggles double-sized markers */ /*000804*/
        if(string[0]=='q')
        {
            Lscalemarkers = !Lscalemarkers;
            /*resetmenuchecks();no menu item yet*/ /*MACPMENU.C calls AdjustMenus();*/
            rescalekinemage();  /*MAGEINPT*/
            redrawvec();       /*MACDRAW.C*/
        }

        if( (string[0] == 'V') ) /* 'V'  viewing parameters dialog*/
        {
            Lshiftkey=0; /*drop no-longer-needed shift flag*/
             DostereoDialog(); /*which is still does as well*/
        }
        if( (string[0] == 'R') ) /* 'R'  Reset to view 1 */
        {
            Lshiftkey=0; /*drop no-longer-needed shift flag*/
             resetrot(1);   /*MAGEANGL.C*/
        }
        if( (string[0] == 'K') ) /* 'K'  next Kinemage, re: meta-N on Mac */
        {
            Lshiftkey=0; /*drop no-longer-needed shift flag*/
            Lgetnextkinemage = 1; /*971129*/
            if(Lpruneactive||Ldrawactive||Lnewviewactive||Lnewstuffactive)
            {
                DoChangeCheckDialog(); /*MAGEDLOG.C */
            }
            else
            {
                getnextkinemage(); /*MAGEFILE.C*/
            }              
        }
        
        /* 'a'  animation*/
        if( (nanimate > 1)&&((string[0] == 'a') || (string[0] == 'A')) ) 
        {
             adjustanimate(1); /*MAGEBBOX.c*/
             redrawvec();      /*___DRAW.c*/
        }
        /* 'b' 2animation*/
        if( (nanimate > 1)&&((string[0] == 'b') || (string[0] == 'B')) ) 
        {
             adjustanimate(2); /*MAGEBBOX.c*/
             redrawvec();      /*___DRAW.c*/
        }

        /* s toggles keepstereo */
        if(string[0]=='s' && !Lcompareon)
        {
            Lkeepstereo = !Lkeepstereo;
            if(Lkeepstereo) Lstereo = 1;
            else            Lstereo = 0;
            adjuststereo(); /*MAGEMENU*/
        }

        /* t toggles keepthinline */
        if(string[0]=='t')
        {
            Lkeepthinline = !Lkeepthinline;
            if(Lkeepthinline) Lthin = 1;
            else              Lthin = 0;
            resetmenuchecks();/*___MENU.c calls AdjustMenus();*/
            redrawvec();      /*___DRAW.c*/
        }

        /* P Puts PointID into commandline string */
        if( (string[0] == 'P') ) /* 'P' */
        {
            Lshiftkey=0; /*drop no-longer-needed shift flag*/
            commandfrompointID(); /*MAGEOUT.c*/
        }
        /* p toggles keepperspective */
        if(string[0]=='p')
        {
            /*Lkeepperspective = !Lkeepperspective;*/
            /*if(Lkeepperspective) Lperspec = 1;*/
            /*else                 Lperspec = 0;*/
            Lperspec = !Lperspec; /*991130 like Mac 981114*/
            resetmenuchecks(); /*___PMENU.c calls AdjustMenus();*/
            redrawvec();       /*___DRAW.c*/
        }

        /* c toggles +,- stereo angle */
        if(string[0]=='c')
        {
            stereoangle = -stereoangle;
            redrawvec(); /*___DRAW.c*/
        }
        /* d toggles dragline pick-up/new */
        if(string[0]=='d')
        {
            Ladddrag = !Ladddrag;
            redrawvec(); /*___DRAW.c*/
        }

        /* k toggles kaleidoscope==plotonly mode */
        if(string[0]=='k')
        {
            mycheckitem(kludgeMenu,plotonlyItem,Lplotonly=!Lplotonly);
                /*___MENU.c*/
            redrawvec(); /*___DRAW.c*/
        }
        /* l toggles listcolor state, either color specified by list or point*/
        if(string[0]=='l')
        {
            setlistcolordominance();
            redrawvec(); /*___DRAW.c*/
        }
        if(Lztran)
        {
            factor = 0.0;
            if(string[0]=='z') factor = +1.0;
                  /*press 'z' to do small step translate in +z*/
            if(string[0]=='Z') factor = +10.0;
                  /*press 'Z' to do big step translate in +z*/
            if(string[0]=='x') factor = -1.0;
                  /*press 'x' to do small step translate in -z*/
            if(string[0]=='X') factor = -10.0;
                  /*press 'X' to do big step translate iz*/
            if(factor > 0.01 || factor < -0.01)
            {
                fxcenternew = fxcenternew + factor*a13/20.0;
                fycenternew = fycenternew + factor*a23/20.0;
                fzcenternew = fzcenternew + factor*a33/20.0;
                rescalekinemage();  /*MAGEINPT.c*/
                redrawvec();        /*___DRAW.c*/
            }
        }
        /* u invokes general update Dialog */
        if(string[0]=='u' &&Lkinfile) 
        {
            if(Lkinfile) DoupdateDialog(); /*MAGEDLOG*/
        }
        
        /* e toggles between Lens on and Lens off *//*971109*/
        if(string[0]=='e')
        {
           setLens(); /*MAGEMENU.C*/
            redrawvec(); /*___DRAW.c*/
        }

        /* f toggles scroll state, either xy rotations or xy tranlations */
        if(string[0]=='f')
        {
            setflat();
        }
        /* F invokes Find == search dialog */
        if(string[0]=='F' && Lkinfile)
        {
            Lshiftkey=0; /*drop no-longer-needed shift flag*/
            DoSearchDialog(); /*MUXMDLOG*/
            /*redrawvec();*/ /*___DRAW.c*/
        }
        /* G invokes Find Again == search again for same strings */
        if(string[0]=='G' && Lkinfile)
        {
            Lshiftkey=0; /*drop no-longer-needed shift flag*/
            DoSearchAgain(); /*MAGEUTIL*/
            /*redrawvec();*/ /*___DRAW.c*/
        }
        /* h toggles maintain horizon state, only y rotation */
        if(string[0]=='h')
        {
            sethorizon();
        }

        /* m blanks measures lines & dots, does not remove old values */
        /*does disable measures operation, i.e. Lmeasureson==0, button==off*/
        /*but potentiates a new measures sequence for a new Lmeasureson==1*/
        /*effectively NOP if hit when measures button is off*/
        /*971204*/
        if(string[0]=='m')
        {
           potentiateMeasures(); /*MAGEMENU.C*/
        }

        /* n for +90 ninty*/  /*971104*/
        if(string[0]=='n')
        {
           getrot(157,0); /*MAGEDRAW*/
           redrawvec();
        }
        /* N for -90 Ninty*/  /*971104*/
        if(string[0]=='N')
        {
            Lshiftkey=0; /*drop no-longer-needed shift flag*/
           getrot(-157,0); /*MAGEDRAW*/
           redrawvec();
        }

        if(string[0]=='1') /* 1 zooms by one unit*/
        {
           zoom = zoom +0.01;
           if(zoom > 10.04) zoom = 10.04;/*maximum*/
           adjustzoom();
        }
        if(string[0]=='2') /* 2 zooms by ten units*/
        {
           zoom = zoom +0.1;
           if(zoom > 10.04) zoom = 10.04;/*maximum*/
           adjustzoom();
        }
        if(string[0]=='3') /* 3 zooms by one unit*/
        {
           zoom = zoom -0.01;
           if(zoom < .04) zoom = .04;/*minimum*/
           adjustzoom();
        }
        if(string[0]=='4') /* 4 zooms by ten units*/
        {
           zoom = zoom -0.1;
           if(zoom < .04) zoom = .04;/*minimum*/
           adjustzoom();
        }

      }
      else
      {
        if(nbondrot > 0 )
        {
           /*<- one degree less of current bondrotation*/ /*970917*/
           if(keysym==LARROW) 
           {
              grafbondrotarrow(-1.0); /*MAGEANGL*/
           }
           /*-> one degree more of current bondrotation*/ /*970917*/
           if(keysym==RARROW)
           {
              grafbondrotarrow(+1.0); /*MAGEANGL*/
           }
           if(keysym==DARROW && LbondrotHplot && LbondrotVplot)
           {
              dobondrotplotter(); /*MAGEANGL*/
           }
           if(keysym==UARROW && LbondrotHplot && LbondrotVplot)
           {
              dobondrotgrapher(); /*MAGEANGL*/
           }
        }
      }
    break;
  }
}
/*___keypresseventhandler()__________________________________________________*/

/****adjustzoom()*************************************************************/
void adjustzoom()
{
   resetgrafzoomBar(); /*calc setting from zoom*/
   scalenew = Scale*zoom;
   writezoomvalue();
   rescalekinemage();
   redrawvec();
}
/*___adjustzoom()____________________________________________________________*/

/****textcursor_CB()**********************************************************/
XtCallbackProc textcursor_CB(Widget w,XtPointer client_data,XtPointer call_data)
{
  XmTextPosition   textplace;
  XmTextVerifyCallbackStruct  *cbs = 
                  (XmTextVerifyCallbackStruct  *)call_data;
    textplace = cbs->newInsert;
    /*this is the index into the text buffer, hypertext?? */

    DotextContentClick(textplace);
    return(NULL);
}
/*___textcursor_CB()_________________________________________________________*/

/****pick_CB()****************************************************************/
XtCallbackProc pick_CB(Widget drawArea,caddr_t client_data,
                       XmDrawingAreaCallbackStruct *call_data)
{
/*equivalent to MPCMAIN/WMLButtonDown(), MACMAIN/DografContentClick() */
/*static int oldx,oldy;*/
/*Window *root, *child;*/
/*int *root_x,*root_y,*child_x,child_y;*/
/*unsigned int keys_buttons;*/
/*XEvent *report;*/
/*int idelx,idely;*/

int Nblank = 0; /*000410*/

XButtonPressedEvent *bpress = (XButtonPressedEvent *) call_data->event;
/*XPointerMovedEvent *mousemove = (XPointerMovedEvent *) call_data->event;*/
    
   if (call_data->reason == XmCR_INPUT)
   {/*call_data->reason == XmCR_INPUT*/
/*printf("%d call_data->event->type\n",call_data->event->type);*/
      switch (call_data->event->type)
      {/*switch call_data->event->type*/
	case ButtonPress:
	  if (bpress->button == Button1)
          {/*Button1*/
          
#ifdef UNIX_PEX
             doxpick(call_data->window,  bpress->x, bpress->y); /*MUXPHIG.c*/ 
#else /*NOT UNIX_PEX*/
              
              /*updateratelimit = 10.0; */
              /* updates per sec, default in MAGEINIT*/

              updaterate = updateratelimit;
              /*set rate so starts with a full update*/
              /*and thus can evaluate what the */
              /*full detail update rate really is */

              fullupdaterate = updaterate;
              ncountticks=theclockcount();/*___MAIN.C*/

              mousex = bpress->x;
              mousexold = bpress->x;
              mousey = bpress->y;
              mouseyold = bpress->y;

              if(Lflat)
              {/*flatland scrolling*/
                 makecursorflatland();
                 irotxy = 1;
              }
              else
              {/*3D rotations*/
                 if( mousey > (GHEIGHT/6) )
                 {
                    irotxy = 1; 
                 }
                 else
                 {
                    irotxy = 0;
                 }
                 if(irotxy==1) makecursorxyrot(); /*___MAIN.C*/ 
                 else          makecursorzrot();  /*___MAIN.C*/ 
              }


              ipick = 2; /*flag for pick point recognition for button press*/
              pickx = mousex;
              picky = mousey;
              /*flag nothing picked yet */
              Lpick = 0; 
              Lpicknow = 0; 
              if(Ldraglineon || Lnewlabelson) /*991130*/
              {
                  Lnewdrag = 1;
                  Lnewmatrix = 1;
              }
              redrawvec();

              Lcarry = 1;
              totalrunticks = (theclockcount() - ncountticks);  /*960809*/

              if(totalrunticks != 0)
                   updaterate = (float)CLOCKS_PER_SEC/(float)totalrunticks;
              else updaterate = 999;
              if(Ldetail==1) fullupdaterate = updaterate;
              while(Lpicknow) /*990211*/
              {/*while Lpicknow*/
                 if(Ltablepickactive && Ltablegraphpicked) /*000327*/
                 {/*try to find a corresponding cell in table to graphics picked point*/
                    getptIDstring(search1str, pickedpointptr);/*MAGELIST*/
                    for(isearch1=0;isearch1<256;isearch1++)
                    {
                       if(search1str[isearch1]==' ') Nblank++; /*000410*/
                       if(search1str[isearch1]=='\0') break;
                    }/*isearch1 is size of pointID str*/  
                    if(isearch1 == Nblank) isearch1 = 0; /*000410*/
                    isearch2 = 0;
                    if(isearch1 > 0)  /*000410*/
                    {
                       searchtablecells(0); /*MAGETABL.c: 0 == match {ptID}*/
                       Ltablegraphpicked = 0;/*avoid coordinate matching in drawtable()*/
                       redrawtable();/*000324*/
                       removetablemarkpoints();
                       markfromtablecellsID(1); /*MAGETABL.c flag==1 for ptID matching*/      
                    }
                 }
                 Lpicknow = 0; 
                 /* passes state between here and drawvec()*/
                 if(Lsuperpunchon) ipick = 2; /*990211*/
                 /*ipick==2 allows picking, so Lpicknow could become ==1 */
                 redrawvec(); /*MACDRAW.C*/
                     /*to move marker to picked atom if any near */
              }/*while Lpicknow*/

              /*if(Ltablepickactive && Ltablegraphpicked) redrawtable();*//*000324*/

              mouseticks=theclockcount();/*____MAIN.C*/
              /*set reference for timing mouse induced movements*/
              Lmousedown = 1; /*so Levelofdetail could be invoked*/

#endif /*if---else of UNIX_PEX*/
              break;
          }/*Button1*/
	  else
          {/*some other button pressed*/
            ;
#ifdef UNIX_PEX
            doxprepick(call_data->window,  bpress->x, bpress->y);/*MUXPHIG.c*/
#endif /*UNIX_PEX*/
          }
	break; /*from case ButtonPress */
	case ButtonRelease:
           makecursoractive();  /*___MAIN.C*/ 
           Lcarry = 0;
           Lmousedown = 0; /*so Levelofdetail not be invoked*/
           if(Ldetail==0) 
           {
               redrawvec(); /*restore detail*/
           }
#ifdef UNIX_PEX
	   doxpickpredraw(); /*MUXPHIG.c*/ 
#endif /*UNIX_PEX*/
	break; /*from case ButtonRelease*/
      }/*switch call_data->event->type*/
      if(Lpick) /*a pick is currently active*/
      {/*entered twice when last pick done for construction*/
          if(Lconstruct4on && Lpoint==4)
          {/*ACTIVE_DLOG filter protects dialog box creation*/
              DoconstructDialog(); /*MUX_DLOG.c*/
              /*this doesn't seem to need redrawvec() here ! */
          }
          else if(Lconstruct5on && Lpoint==5)
          {
              DoConstructFifthDialog(); /*MUX_DLOG.c*/
          }
          if(Lpickcoloron) DocolorshowDialog(); /*___DLOG.C*/
          if(Lpickshowon)  DopickshowDialog();  /*___DLOG.C*/
      }
   }/*call_data->reason == XmCR_INPUT*/
   return(NULL);
}
/*___pick_CB()_______________________________________________________________*/

/****motion_handler***********************************************************/
/*void motion_handler(Widget widget,caddr_t client_data,XEvent *event,Boolean *continue_to_dispatch)*/

void motion_handler(widget, client_data, event)
     Widget widget;                 
     caddr_t client_data;           
     register XPointerMovedEvent  *event;                  /*Vol 4, 218*/
  /* Boolean *continue_to_dispatch; */

/*equivalent to MPCMAIN/WMMouseMove(), MACDRAW/Drawgraf( internal loop ) */

{
int idelx,idely;
long temptimeticks=0;

  mousex = event->x; 
  mousey = event->y; 

  if(XtAppPending(app_context) == 0)
  {/*no pending events*/ /*so caught up to latest mouse movement*/
    idelx = (mousex - mousexold);
    idely = (mousey - mouseyold);
    if(idelx!=0 || idely!=0)
    {
         mousexold = mousex;
         mouseyold = mousey;
         pickx = mousex; /*dragline needs this updated*/
         picky = mousey;
         /*labels can be dragged */  /*991130*/
         if(Lpick&&(Ldraglineon||Lnewlabelson)) Ldraglineactive = 1;         
       /*if(Lpick&&Ldraglineon) Ldraglineactive = 1;*/ 
         if(!Ldraglineactive)
         {
             if(Lctrlkey) Lscroll = 1;
             else Lscroll = 0; /*Lscroll is independent of Lflat*/
             if(irotxy == 1 && Lshiftkey) /*==1 for initial decision*/
             {/*emphasize x or y : use >=1 for change emphasis while moving*/
                if(idely*idely < idelx*idelx)  irotxy = 2; 
                                 /*rotate around y axis*/
                else irotxy = 3; /*rotate around x axis*/
             }/*emphasize x or y */
             getrot(idelx,idely); /*MAGEUTIL.c*/
             Lnewmatrix = 1;
         }
         temptimeticks = (float)theclockcount();
         temptimeticks = temptimeticks - mouseticks;
         if(temptimeticks != 0)
         {
            mousetickrate =   (float)CLOCKS_PER_SEC/temptimeticks;
         }
         else
         {
            mousetickrate = 0;
         }
         mouseticks = theclockcount();  /*____MAIN.C*/ 

         redrawvec();

    }
  }/*no pending events*/
}
/*___motion_handler()________________________________________________________*/

/****condition()*************************************************************/
void    condition(char strg[256]){;}
/*___condition()____________________________________________________________*/
/****recondition()***********************************************************/
void    recondition(char strg[256]){;}
/*___recondition()__________________________________________________________*/

/****makecursoractive()******************************************************/
void    makecursoractive()
{
 XDefineCursor(dpy,drawWindow,magecursor);
 Lcursoractive = 1;
}
/*___makecursoractive()_____________________________________________________*/

/****makecursorwait()********************************************************/
void    makecursorwait()
{
 XDefineCursor(dpy,drawWindow,waitcursor);
 Lcursoractive = 0;
/*XRaiseWindow(XtDisplay(topgraf),XtWindow(topgraf));*/
}
/*___makecursorwait()_______________________________________________________*/

/****makecursorxyrot()*******************************************************/
void    makecursorxyrot()
{
 XDefineCursor(dpy,drawWindow,xyrotcursor);
 Lcursoractive = 1;
/*XRaiseWindow(XtDisplay(topgraf),XtWindow(topgraf));*/
}
/*___makecursorxyrot()______________________________________________________*/

/****makecursorzrot()********************************************************/
void    makecursorzrot()
{
   XDefineCursor(dpy,drawWindow,zrotcursor);
   Lcursoractive = 1;
/*XRaiseWindow(XtDisplay(topgraf),XtWindow(topgraf));*/
}
/*___makecursorzrot()_______________________________________________________*/

/****makecursorsculpt()******************************************************/
void    makecursorsculpt(){;}
/*___makecursorsculpt()_____________________________________________________*/

/****makecursorflatland()****************************************************/
void    makecursorflatland()
{
   XDefineCursor(dpy,drawWindow,flatlandcursor);
   Lcursoractive = 1;
}
/*___makecursorflatland()___________________________________________________*/

/****theclockcount()********************950113*********/
long    theclockcount()
{
/*int      iok;*/
/*long     timestamp;*/
long     clockstamp;

/*time_t thetime,thistime;*/
/*clock_t theclock;*/

/*    timestamp = time(&thetime);*/
    clockstamp = clock();
/*printf("timestamp== %ld, clockstamp==%ld\n",timestamp,clockstamp);*/
    if(clockstamp != -1)
       return(clockstamp);
    else
       return(0L);
}
/*___theclockcount()____________________________*/

/****countredraws()***********************************************************/
void    countredraws()
{
            int idelx,idely, Lnew;
            float    rate;
/*static        int xold,yold;*/

    Lnew = 1;
    Lcount = 0;
    ncountticks = theclockcount(); /*long*/
    icountticks = ncountticks; /*start with same number for both*/
        /*icountticks will be reset as get intermediates*/
    {
        /* not testing if mouse still down */
            if(Lnew)
            {/*establish mouse position at beginning of mouse down episode*/
                Lnew = 0;
                /*xold = 0;*/
                /*yold = 0;*/
            }
                /* simulate mouse has moved */
            {    /*begin-mouse has moved */
                /* get deltas and call for new rotation matrix */
                idelx = 0;
                idely = 0;
                getrot(idelx,idely); /*MAGEUTIL.C*/

                redrawvec(); /*MACDRAW.C*/

            }/*endof-mouse has moved */
    }
    postdrawticks = (theclockcount() - icountticks);
    icountticks = theclockcount();

    totalrunticks = (theclockcount() - ncountticks);
    /*rate = 1.0/( totalrunticks/60.0 ) ;*/
    if(totalrunticks > 0)
        rate = (float)CLOCKS_PER_SEC / (float)totalrunticks  ;
    else
        rate = 999.;
        
         sprintf(alertstr,"timing in .01 sec *1,000,000: "
            CRLF"predraw = %ld, preloop = %ld"
            CRLF", firstloop = %ld, secondloop = %ld"
            CRLF", pastcopy = %ld, postdraw = %ld"
            ,predrawticks,preloopticks,firstloopticks,secondloopticks
            ,postcopyticks,postdrawticks
            );
         sprintf(alertstr2,
                " totalrun = %ld,                rate = %.3f per sec"
            CRLF"number of 2-D move-draws = %ld, out of %ld triples "
            CRLF" (text has %ld chars)"
            ,totalrunticks,rate
            ,nmovedraws,nxyz,ntotaltext
            );
         alertstr3[0]='\0';
         DoMageDLOGreport(1); /*alertstr,alertstr2,alertstr3*/ /*___DLOG.C*/

}
/*___countredraws()__________________________________________________________*/

/*
				Get_events

  This routine processes events requested by the program.  XtNextEvent
  obtains the next event from the input queue and places it in report.  The
  type of the event is then examined to determine if it is an extension
  event or a regular X event.  The constant LASTEvent (defined in X.h) is
  bigger than the event type of any X event and can be used to
  differentiate extension events from normal X events.

  Regular events are handled by the toolkit dispatch mechanism via
  XtDispatchEvent.  Extension events (DeviceMotion and picking events) are
  handled on a case-by-case basis.

  When a DeviceMotion event is encountered, all device motion events are
  removed from the event queue and accumulated into knob_totals, since the
  dials box reports relative changes.  Event explosion is a very real
  possibility since every device motion event requires 2 XEvent structures
  (only 6 axes' worth of data fit in a single XEvent) and the sample rate
  of the dials box is high.  Since this program is only concerned with
  cumulative changes in the dials values, it is safe to condense the device
  motion events via XCheckTypedEvent.  Since XCheckTypedEvent can remove
  events that are not at the head of the event queue, it may not be
  appropriate for situations where the semantics of a device motion event
  can be changed by another event (for instance, a key or button press).

  When a pick event is encountered, the picked structure element is identified
  and the corresponding list is searched for the nearest point to the picked
  coordinates.  If pick-centering is on, then the local MAGE center is updated
  and the display redrawn.  If markers are on, the markers are placed on the
  closest point to the pick-place.
*/

