/*                          winHandleGetc.c
 * Author: J. Michael Word           Date Written: April 8, 1998
 * Purpose: read from a windows pipe one character at a time
 * Example:
 *   while((ch = winHandleGetc(h)) != EOF) {
 *      process ch...
 *   }
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "winHandleGetc.h"

static int PipeBufSize = 4096;

static char *PipeBuf = NULL;
static int  PBcursor = -1;
static int  PBnchar  =  0;
static int  OK = 0;

DWORD numbytesread;

int winHandleSetBufLen(int nc) {
   int lastSize = PipeBufSize;

   PipeBufSize = nc;

   if (PipeBufSize > lastSize) {
      winHandleDestroyBuf();
   }
   return lastSize;
}

void winHandleDestroyBuf() {
   if (PipeBuf != NULL) {
      free(PipeBuf);
      PipeBuf = NULL;
   }

   PBcursor = -1;
   PBnchar  =  0;
}

int winHandleCreateBuf() {
   winHandleDestroyBuf();

   if (PipeBufSize < 1) { return 0; }

   PipeBuf = (char *) malloc(PipeBufSize);

   if (PipeBuf == NULL) { return 0; }

   return 1;
}

int winHandleGetc(HANDLE inputHandle) {
   if (PipeBuf == NULL) {
      if (! winHandleCreateBuf()) { return EOF; }
   }

   if (PBcursor < 0 || PBcursor >= PBnchar) {
      OK = ReadFile(inputHandle, PipeBuf, (DWORD)PipeBufSize, &numbytesread, NULL);
	  PBnchar = (int)numbytesread;
      if ((!OK) || (PBnchar < 1)) { return EOF; }
      PBcursor = 0;
   }
   return PipeBuf[PBcursor++];
}

int winHandlePushBack(int ch) {
   if (PipeBuf == NULL) {
      if (! winHandleCreateBuf()) { return 0; }
   }

   if (PBcursor > 0) {
      PipeBuf[--PBcursor] = ch;
      return 1; /* made the previous character */
   }
   else if (PBnchar < PipeBufSize) {
      if (PBnchar > 0) { /* shift by one character */
	 memmove(PipeBuf+1, PipeBuf, PBnchar++);
      }
      else { PBnchar = 1; }

      PipeBuf[PBcursor = 0] = ch;

      return 1; /* inserted as first character */
   }
   return 0; /* failed! no room to push back */
}
